/****************************************************************************
*
*						  Ultra Long Period Timer
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:		ANSI C
* Environment:	OS/2
*
* Description:  OS specific implementation for the Zen Timer functions.
*
****************************************************************************/

/*---------------------------- Global variables ---------------------------*/

static ulong	frequency;

/*----------------------------- Implementation ----------------------------*/

/****************************************************************************
REMARKS:
Initialise the Zen Timer module internals.
****************************************************************************/
void __ZTimerInit(void)
{
	DosTmrQueryFreq(&frequency);
}

/****************************************************************************
REMARKS:
Start the Zen Timer counting.
****************************************************************************/
#define	__LZTimerOn(tm)	DosTmrQueryTime((QWORD*)&tm->start)

/****************************************************************************
REMARKS:
Compute the lap time since the timer was started.
****************************************************************************/
static ulong __LZTimerLap(
	LZTimerObject *tm)
{
	CPU_largeInteger	tmLap,tmCount;

	DosTmrQueryTime((QWORD*)&tmLap);
	_CPU_diffTime64(&tm->start,&tmLap,&tmCount);
	return _CPU_calcMicroSec(&tmCount,frequency);
}

/****************************************************************************
REMARKS:
Call the assembler Zen Timer functions to do the timing.
****************************************************************************/
#define	__LZTimerOff(tm)	DosTmrQueryTime((QWORD*)&tm->end)

/****************************************************************************
REMARKS:
Call the assembler Zen Timer functions to do the timing.
****************************************************************************/
static ulong __LZTimerCount(
	LZTimerObject *tm)
{
	CPU_largeInteger tmCount;

	_CPU_diffTime64(&tm->start,&tm->end,&tmCount);
	return _CPU_calcMicroSec(&tmCount,frequency);
}

/****************************************************************************
REMARKS:
Define the resolution of the long period timer as seconds per timer tick.
****************************************************************************/
#define	ULZTIMER_RESOLUTION		(1.0 / 1000.0)

/****************************************************************************
REMARKS:
Read the Long Period timer value from the BIOS timer tick.
****************************************************************************/
static ulong __ULZReadTime(void)
{
	QWORD count;
	DosTmrQueryTime(&count);
	return (count.ulLo * 1000.0 / frequency);
}

/****************************************************************************
REMARKS:
Compute the elapsed time from the BIOS timer tick. Note that we check to see
whether a midnight boundary has passed, and if so adjust the finish time to
account for this. We cannot detect if more that one midnight boundary has
passed, so if this happens we will be generating erronous results.
****************************************************************************/
ulong __ULZElapsedTime(ulong start,ulong finish)
{ return finish - start; }
