/*
 * Mesa 3-D graphics library
 * Version:  3.1
 *
 * Copyright (C) 1999  Brian Paul   All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/*
 * 3Dnow assembly code by Holger Waechtler
 */


#include "assyntax.h"

        SEG_TEXT

#if !defined(NASM_ASSEMBLER) && !defined(MASM_ASSEMBLER)
#define LLBL(a) .L ## a
#else
#define LLBL(a) a
#endif



/*
 * typedef void (*normal_transform_function) ( const GLmatrix *mat,
 *                                             GLfloat scale,
 *                                             const GLvector3f *in,
 *                                             const GLfloat *lengths,
 *                                             const GLubyte mask[],
 *                                             GLvector3f *dest )
 */

#define OFFSET_MAT 4
#define OFFSET_SCALE 8
#define OFFSET_IN 12
#define OFFSET_LENGTHS 16
#define OFFSET_MASK 20
#define OFFSET_DEST 24

#define ARG_MAT         REGOFF(FRAME_OFFSET+OFFSET_MAT, ESP)
#define ARG_SCALE       REGOFF(FRAME_OFFSET+OFFSET_SCALE, ESP)
#define ARG_IN          REGOFF(FRAME_OFFSET+OFFSET_IN, ESP)
#define ARG_LENGTHS     REGOFF(FRAME_OFFSET+OFFSET_LENGTHS, ESP)
#define ARG_MASK        REGOFF(FRAME_OFFSET+OFFSET_MASK, ESP)
#define ARG_DEST        REGOFF(FRAME_OFFSET+OFFSET_DEST, ESP)


#define V3F_START       4
#define V3F_COUNT       8
#define V3F_STRIDE      12

#define MAT_INV         64

#define M(i)    REGOFF(i * 4, ECX)
#define STRIDE  REGOFF(12, ESI)


ALIGNTEXT16
GLOBL GLNAME(gl_3dnow_transform_normalize_normals_raw)
GLNAME(gl_3dnow_transform_normalize_normals_raw):

 #define FRAME_OFFSET 12
    SUB_L   ( CONST(4), ESP )
    PUSH_L  ( EDI )
    PUSH_L  ( ESI )

    MOV_L   ( ARG_LENGTHS, EDI )
    MOV_L   ( ARG_IN, EAX )
    MOV_L   ( ARG_DEST, EDX )
    MOV_L   ( REGOFF(V3F_COUNT, EAX), EAX ) /*  dest->count = in->count   */
    MOV_L   ( EAX, REGOFF(V3F_COUNT, EDX) )
    MOV_L   ( ARG_IN, ESI )
    MOV_L   ( ARG_MAT, ECX )
    MOV_L   ( REGOFF(V3F_START, EDX), EAX ) /*  dest->start  */
    MOV_L   ( REGOFF(MAT_INV, ECX), ECX ) /*  mat->inv     */
    MOV_L   ( REGOFF(V3F_START, ESI), EDX ) /*  in->start    */


ALIGNTEXT32

    CMP_L      ( CONST(0), REGOFF (V3F_COUNT, ESI ) ) /*   count > 0 ??  */
    JE         ( LLBL (G3TN_end) )

    PUSH_L     ( EBP )
    MOV_L      ( REGOFF (V3F_COUNT, ESI), EBP )
    FEMMS

    PUSH_L     ( EBP )
    PUSH_L     ( EAX )
    PUSH_L     ( EDX )                  /*  save counter & pointer for   */
                                        /*  the normalize pass           */


    MOVQ       ( M(0), MM3 )            /*  m1              | m0         */
    MOVQ       ( M(4), MM4 )            /*  m5              | m4         */

    MOVD       ( M(2), MM5 )            /*                  | m2         */
    PUNPCKLDQ  ( M(6), MM5 )            /*  m6              | m2         */

    MOVQ       ( M(8), MM6 )            /*  m9              | m8         */
    MOVQ       ( M(10), MM7 )           /*                  | m10        */

    CMP_L      ( CONST(0), EDI )        /*  lengths == 0 ?                 */
    JNE        ( LLBL (G3TN_scale_end ) )

 #undef  FRAME_OFFSET
 #define FRAME_OFFSET 28
    MOVD       ( ARG_SCALE, MM0 )       /*               | scale           */
    PUNPCKLDQ  ( MM0, MM0 )             /* scale         | scale           */

    PFMUL      ( MM0, MM3 )             /* scale * m1    | scale * m0      */
    PFMUL      ( MM0, MM4 )             /* scale * m5    | scale * m4      */
    PFMUL      ( MM0, MM5 )             /* scale * m6    | scale * m2      */
    PFMUL      ( MM0, MM6 )             /* scale * m9    | scale * m8      */
    PFMUL      ( MM0, MM7 )             /*               | scale * m10     */

LLBL (G3TN_scale_end):
    MOVQ       ( REGIND (EDX), MM0 )    /*  x1              | x0         */
    MOVD       ( REGOFF (8, EDX), MM2 ) /*                  | x2         */

ALIGNTEXT32
LLBL (G3TN_transform):
    MOVQ       ( MM0, MM1 )             /*  x1              | x0           */
    PUNPCKLDQ  ( MM2, MM2 )             /*  x2              | x2           */

    PFMUL      ( MM3, MM0 )             /*  x1*m1           | x0*m0        */
    ADD_L      ( CONST(12), EAX )       /*  next r                         */

    PFMUL      ( MM4, MM1 )             /*  x1*m5           | x0*m4        */
    PFACC      ( MM1, MM0 )             /*  x0*m4+x1*m5     | x0*m0+x1*m1  */

    PFMUL      ( MM5, MM2 )             /*  x2*m6           | x2*m2        */
    PFADD      ( MM2, MM0 )             /* x0*m4+x1*m5+x2*m6| x0*m0+...+x2**/

    MOVQ       ( REGIND (EDX), MM1 )    /*  x1           | x0              */
    MOVQ       ( MM0, REGOFF(-12, EAX) ) /* write r0, r1                   */

    PFMUL      ( MM6, MM1 )             /* x1*m9         | x0*m8           */
    MOVD       ( REGOFF (8, EDX), MM2 ) /*               | x2              */

    PFMUL      ( MM7, MM2 )             /*               | x2*m10          */
    PFACC      ( MM1, MM1 )             /*  *not used*   | x0*m8+x1*m9     */

    PFADD      ( MM2, MM1 )             /*  *not used*   | x0*m8+x1*m9+x2*m*/
    ADD_L      ( STRIDE, EDX )          /*  next normal                    */

    MOVD       ( MM1, REGOFF(-4, EAX) ) /*  write r2                       */
    MOVQ       ( REGIND (EDX), MM0 )    /*  x1           | x0              */

    MOVD       ( REGOFF (8, EDX), MM2 ) /*               | x2              */
    DEC_L      ( EBP )                  /*  decrement normal counter       */
    JA         ( LLBL (G3TN_transform) )


    POP_L      ( EDX )                  /*  end of transform ---           */
    POP_L      ( EAX )                  /*    now normalizing ...          */
    POP_L      ( EBP )

    MOVQ       ( REGIND(EAX), MM0 )     /*  x1              | x0           */
    MOVD       ( REGOFF(8, EAX), MM1 )  /*                  | x2           */

    CMP_L      ( CONST(0), EDI )        /*  lengths == 0 ?                 */
    JE         ( LLBL (G3TN_norm ) )    /*  calculate lengths              */


ALIGNTEXT32
LLBL (G3TN_norm_w_lengths):
    MOVD       ( REGIND (EDI), MM3 )    /*                  | length (x)   */
    PFMUL      ( MM3, MM1 )             /*                  | x2 (normalize*/

    PUNPCKLDQ  ( MM3, MM3 )             /*  length (x)      | length (x)   */
    PFMUL      ( MM3, MM0 )             /*  x1 (normalized) | x0 (normalize*/

    MOVQ       ( MM0, REGIND(EAX) )     /*  write new x0, x1               */
    MOVD       ( MM1, REGOFF(8, EAX) )  /*  write new x2                   */

    ADD_L      ( STRIDE, EDX )          /*  next normal                    */
    ADD_L      ( CONST(12), EAX )       /*  next r                         */

    ADD_L      ( CONST(4), EDI )        /*  next length                    */
    DEC_L      ( EBP )                  /*  decrement normal counter       */

    MOVQ       ( REGIND(EAX), MM0 )     /*  x1              | x0           */
    MOVD       ( REGOFF(8, EAX), MM1 )  /*                  | x2           */
    JA         ( LLBL (G3TN_norm_w_lengths) )
    JMP        ( LLBL (G3TN_exit_3dnow) )

ALIGNTEXT32
LLBL (G3TN_norm):
    MOVQ       ( MM0, MM3 )             /*  x1              | x0           */
    MOVQ       ( MM1, MM4 )             /*                  | x2           */

    PFMUL      ( MM0, MM3 )             /*  x1*x1           | x0*x0        */
    ADD_L      ( CONST(12), EAX )       /*  next r                         */

    PFMUL      ( MM1, MM4 )             /*                  | x2*x2        */
    PFADD      ( MM4, MM3 )             /*                  | x0*x0+x2*x2  */

    PFACC      ( MM3, MM3 )             /* **not used**    | x0*x0+x1*x1+x2**/
    PFRSQRT    ( MM3, MM5 )             /*  1/sqrt (x0*x0+x1*x1+x2*x2)     */

    MOVQ       ( MM5, MM4 )
    PUNPCKLDQ  ( MM3, MM3 )

    DEC_L      ( EBP )                  /*  decrement normal counter       */
    PFMUL      ( MM5, MM5 )

    PFRSQIT1   ( MM3, MM5 )
    PFRCPIT2   ( MM4, MM5 )

    PFMUL      ( MM5, MM0 )             /*  x1 (normalized) | x0 (normalize*/

    MOVQ       ( MM0, REGOFF(-12, EAX) ) /*  write new x0, x1              */
    PFMUL      ( MM5, MM1 )             /*                 | x2 (normalize*/

    MOVD       ( MM1, REGOFF(-4, EAX) ) /*  write new x2                  */
    MOVQ       ( REGIND (EAX), MM0 )    /*  x1             | x0           */

    MOVD       ( REGOFF(8, EAX), MM1 )  /*                 | x2           */
    JA         ( LLBL (G3TN_norm) )

LLBL (G3TN_exit_3dnow):
    FEMMS
    POP_L      ( EBP )

LLBL (G3TN_end):
    POP_L      ( ESI )
    POP_L      ( EDI )
    POP_L      ( ECX )
    RET



ALIGNTEXT16

GLOBL GLNAME(gl_3dnow_transform_normalize_normals_no_rot_raw)
GLNAME(gl_3dnow_transform_normalize_normals_no_rot_raw):

 #undef FRAME_OFFSET 
 #define FRAME_OFFSET 12
    SUB_L   ( CONST(4), ESP )
    PUSH_L  ( EDI )
    PUSH_L  ( ESI )

    MOV_L   ( ARG_LENGTHS, EDI )
    MOV_L   ( ARG_IN, EAX )
    MOV_L   ( ARG_DEST, EDX )
    MOV_L   ( REGOFF(V3F_COUNT, EAX), EAX ) /*  dest->count = in->count   */
    MOV_L   ( EAX, REGOFF(V3F_COUNT, EDX) )
    MOV_L   ( ARG_IN, ESI )
    MOV_L   ( ARG_MAT, ECX )
    MOV_L   ( REGOFF(V3F_START, EDX), EAX ) /*  dest->start  */
    MOV_L   ( REGOFF(MAT_INV, ECX), ECX ) /*  mat->inv     */
    MOV_L   ( REGOFF(V3F_START, ESI), EDX ) /*  in->start    */


ALIGNTEXT32

    CMP_L      ( CONST(0), REGOFF (V3F_COUNT, ESI ) ) /*   count > 0 ??  */
    JE         ( LLBL (G3TNNR_end) )

    PUSH_L     ( EBP )
    MOV_L      ( REGOFF (V3F_COUNT, ESI), EBP )
    FEMMS

    MOVD       ( M(0), MM0 )            /*               | m0                 */
    PUNPCKLDQ  ( M(5), MM0 )            /* m5            | m0                 */

    MOVD       ( M(10), MM2 )           /*               | m10                */
    PUNPCKLDQ  ( MM2, MM2 )             /* m10           | m10                */

    CMP_L      ( CONST(0), EDI )        /*  lengths == 0 ?                    */
    JNE        ( LLBL (G3TNNR_scale_end ) )

 #undef  FRAME_OFFSET
 #define FRAME_OFFSET 16
    MOVD       ( ARG_SCALE, MM7 )       /*               | scale              */
    PUNPCKLDQ  ( MM7, MM7 )             /* scale         | scale              */

    PFMUL      ( MM7, MM0 )             /* scale * m5    | scale * m0         */
    PFMUL      ( MM7, MM2 )             /* scale * m10   | scale * m10        */

LLBL (G3TNNR_scale_end):
    MOVQ       ( REGIND(EDX), MM6 )     /* x1            | x0                 */
    MOVD       ( REGOFF(8, EDX), MM7 )  /*               | x2                 */

    CMP_L      ( CONST(0), EDI )        /* lengths == 0 ?                     */
    JE         ( LLBL (G3TNNR_norm) )   /* need to calculate lengths          */

    MOVD       ( REGIND(EDI), MM3 )     /*                 | length (x)       */


LLBL (G3TNNR_norm_w_lengths):           /* use precalculated lengths          */
    PFMUL      ( MM0, MM6 )             /* x1*m5         | x0*m0              */
    ADD_L      ( STRIDE, EDX )          /* next normal                        */

    PFMUL      ( MM2, MM7 )             /*               | x2*m10             */
    ADD_L      ( CONST(12), EAX )       /* next r                             */

    PFMUL      ( MM3, MM7 )             /*               | x2 (normalized)  */
    PUNPCKLDQ  ( MM3, MM3 )             /* length (x)    | length (x)       */

    ADD_L      ( CONST(4), EDI )        /* next length                        */
    PFMUL      ( MM3, MM6 )             /* x1 (normalized) | x0 (normalized)  */

    DEC_L      ( EBP )                  /* decrement normal counter           */
    MOVQ       ( MM6, REGOFF(-12, EAX) ) /* write r0, r1                      */

    MOVD       ( MM7, REGOFF(-4, EAX) ) /* write r2                           */
    MOVD       ( REGIND(EDI), MM3 )     /*                 | length (x)       */

    MOVQ       ( REGIND(EDX), MM6 )     /* x1              | x0               */
    MOVD       ( REGOFF(8, EDX), MM7 )  /*                 | x2               */

    JA         ( LLBL (G3TNNR_norm_w_lengths) )
    JMP        ( LLBL (G3TNNR_exit_3dnow) )

LLBL (G3TNNR_norm):                     /* need to calculate lengths          */
    PFMUL      ( MM0, MM6 )             /* x1*m5           | x0*m0            */
    ADD_L      ( CONST(12), EAX )       /* next r                             */

    PFMUL      ( MM2, MM7 )             /*                 | x2*m10           */
    MOVQ       ( MM6, MM3 )             /* x1 (transformed)| x0 (transformed) */

    MOVQ       ( MM7, MM4 )             /*                 | x2 (transformed) */
    PFMUL      ( MM6, MM3 )             /* x1*x1           | x0*x0            */

    PFMUL      ( MM7, MM4 )             /*                 | x2*x2            */
    PFACC      ( MM3, MM3 )             /* **not used**    | x0*x0+x1*x1      */

    PFADD      ( MM4, MM3 )             /*                 | x0*x0+x1*x1+x2*x2*/
    ADD_L      ( STRIDE, EDX )          /* next normal            */

    PFRSQRT    ( MM3, MM5 )             /* 1/sqrt (x0*x0+x1*x1+x2*x2)         */
    MOVQ       ( MM5, MM4 )

    PUNPCKLDQ  ( MM3, MM3 )
    PFMUL      ( MM5, MM5 )

    PFRSQIT1   ( MM3, MM5 )
    DEC_L      ( EBP )                  /* decrement normal counter           */

    PFRCPIT2   ( MM4, MM5 )
    PFMUL      ( MM5, MM6 )             /* x1 (normalized) | x0 (normalized)  */

    MOVQ       ( MM6, REGOFF(-12, EAX) ) /* write r0, r1                      */
    PFMUL      ( MM5, MM7 )             /*                 | x2 (normalized)  */

    MOVD       ( MM7, REGOFF(-4, EAX) ) /* write r2                           */
    MOVQ       ( REGIND(EDX), MM6 )     /* x1              | x0               */

    MOVD       ( REGOFF(8, EDX), MM7 )  /*                 | x2               */
    JA         ( LLBL (G3TNNR_norm) )


LLBL (G3TNNR_exit_3dnow):
    FEMMS
    POP_L      ( EBP )

LLBL (G3TNNR_end):
    POP_L      ( ESI )
    POP_L      ( EDI )
    POP_L      ( ECX )
    RET






ALIGNTEXT16

GLOBL GLNAME(gl_3dnow_transform_rescale_normals_no_rot_raw)
GLNAME(gl_3dnow_transform_rescale_normals_no_rot_raw):

 #undef FRAME_OFFSET 
 #define FRAME_OFFSET 12
    SUB_L   ( CONST(4), ESP )
    PUSH_L  ( EDI )
    PUSH_L  ( ESI )

    MOV_L   ( ARG_IN, EAX )
    MOV_L   ( ARG_DEST, EDX )
    MOV_L   ( REGOFF(V3F_COUNT, EAX), EAX ) /*  dest->count = in->count   */
    MOV_L   ( EAX, REGOFF(V3F_COUNT, EDX) )
    MOV_L   ( ARG_IN, ESI )
    MOV_L   ( ARG_MAT, ECX )
    MOV_L   ( REGOFF(V3F_START, EDX), EAX ) /*  dest->start  */
    MOV_L   ( REGOFF(MAT_INV, ECX), ECX ) /*  mat->inv     */
    MOV_L   ( REGOFF(V3F_START, ESI), EDX ) /*  in->start    */


ALIGNTEXT32

    CMP_L      ( CONST(0), REGOFF (V3F_COUNT, ESI) )
    JE         ( LLBL (G3TRNR_end) )

    PUSH_L     ( EBP )
    MOV_L      ( REGOFF (V3F_COUNT, ESI), EBP )
    FEMMS

 #undef  FRAME_OFFSET
 #define FRAME_OFFSET 16
    MOVD       ( ARG_SCALE, MM6 )       /*               | scale              */
    PUNPCKLDQ  ( MM6, MM6 )             /* scale         | scale              */

    MOVD       ( REGIND(ECX), MM0 )     /*               | m0                 */
    PUNPCKLDQ  ( REGOFF(20, ECX), MM0 ) /* m5            | m0                 */

    PFMUL      ( MM6, MM0 )             /* scale*m5      | scale*m0           */
    MOVD       ( REGOFF(40, ECX), MM2 ) /*               | m10                */

    MOVQ       ( REGIND(EDX), MM4 )     /* x1            | x0                 */
    PFMUL      ( MM6, MM2 )             /*               | scale*m10          */

    MOVD       ( REGOFF(8, EDX), MM5 )  /*               | x2                 */

ALIGNTEXT32

LLBL (G3TRNR_rescale):
    PFMUL      ( MM0, MM4 )             /* x1*m5         | x0*m0              */
    ADD_L      ( STRIDE, EDX )          /* next normal                        */

    PFMUL      ( MM2, MM5 )             /*               | x2*m10             */
    ADD_L      ( CONST(12), EAX )       /* next r                             */

    DEC_L      ( EBP )                  /* decrement normal counter           */
    MOVQ       ( MM4, REGOFF(-12, EAX) ) /* write r0, r1                      */

    MOVD       ( MM5, REGOFF(-4, EAX) ) /* write r2                           */
    MOVQ       ( REGIND(EDX), MM4 )     /* x1            | x0                 */

    MOVD       ( REGOFF(8, EDX), MM5 )  /*               | x2                 */
    JA         ( LLBL (G3TRNR_rescale) ) /* cnt > 0 ? -> process next normal  */

    FEMMS
    POP_L      ( EBP )

LLBL (G3TRNR_end):
    POP_L      ( ESI )
    POP_L      ( EDI )
    POP_L      ( ECX )
    RET





ALIGNTEXT16
GLOBL GLNAME(gl_3dnow_transform_rescale_normals_raw)
GLNAME(gl_3dnow_transform_rescale_normals_raw):

 #undef  FRAME_OFFSET
 #define FRAME_OFFSET 12
    SUB_L   ( CONST(4), ESP )
    PUSH_L  ( EDI )
    PUSH_L  ( ESI )

    MOV_L   (REGOFF(24,ESP), EAX)
    MOV_L   (REGOFF(36,ESP), EDX)
    MOV_L   (REGOFF(8,EAX), EAX)
    MOV_L   (EAX, REGOFF(8,EDX))
    MOV_L   (REGOFF(24,ESP), EDI)
    MOV_L   (REGOFF(4,EDX), EAX)
    MOV_L   (REGOFF(16,ESP), ECX)
    MOV_L   (REGOFF(24,ESP), ESI)
    MOV_L   (REGOFF(64,ECX), ECX)
    MOV_L   (REGOFF(4,EDI), EDX)
    MOV_L   (REGOFF(8,EDI), EDI)

ALIGNTEXT32

    CMP_L      ( CONST(0), EDI )
    JE         ( LLBL (G3TR_end) )

    FEMMS

    MOVQ       ( REGIND(ECX), MM3 )     /* m1            | m0                 */

    MOVQ       ( REGOFF(16,ECX), MM4 )  /* m5            | m4                 */
    MOVD       ( REGOFF(20, ESP), MM0 ) /* scale       */

    MOVD       ( REGOFF(8,ECX), MM5 )   /*               | m2                 */
    PUNPCKLDQ  ( MM0, MM0 )             /* scale         | scale              */

    PUNPCKLDQ ( REGOFF(24, ECX), MM5 )
    PFMUL      ( MM0, MM3 )             /* scale*m1      | scale*m0           */

    MOVQ       ( REGOFF(32, ECX), MM6 ) /* m9            | m8*/
    PFMUL      ( MM0, MM4 )             /* scale*m5      | scale*m4           */

    MOVD       ( REGOFF(40, ECX), MM7 ) /*               | m10                */
    PFMUL      ( MM0, MM5 )             /* scale*m6      | scale*m2           */

    PFMUL      ( MM0, MM6 )             /* scale*m9      | scale*m8           */
    MOVD       ( REGOFF(8, EDX), MM2 )  /*               | x2                 */

    PFMUL      ( MM0, MM7 )             /*               | scale*m10          */
    MOVQ       ( REGIND(EDX), MM0 )     /* x1            | x0                 */

LLBL (G3TR_rescale):
    MOVQ       ( MM0, MM1 )             /* x1            | x0                 */
    PUNPCKLDQ  ( MM2, MM2 )             /* x2            | x2                 */

    PFMUL      ( MM3, MM0 )             /* x1*m1         | x0*m0              */
    ADD_L      ( CONST(12), EAX )       /* next r                             */

    PFMUL      ( MM4, MM1 )             /* x1*m5         | x0*m4              */
    PFACC      ( MM1, MM0 )             /* x0*m4+x1*m5   | x0*m0+x1*m1        */

    PFMUL      ( MM5, MM2 )             /* x2*m6         | x2*m2              */
    PFADD      ( MM2, MM0 )             /* x0*m4...+x2*m6| x0*m0+x1*m1+x2*m2  */

    MOVQ       ( REGIND(EDX), MM1 )     /* x1            | x0                 */
    MOVQ       ( MM0, REGOFF(-12, EAX) ) /* write r0, r1                      */

    PFMUL      ( MM6, MM1 )             /* x1*m9         | x0*m8              */
    MOVD       ( REGOFF(8, EDX), MM2 )  /*               | x2                 */

    PFMUL      ( MM7, MM2 )             /*               | x2*m10             */
    PFACC      ( MM1, MM1 )             /* *not used*    | x0*m8+x1*m9        */

    PFADD      ( MM2, MM1 )             /* *not used*    | x0*m8+x1*m9+x2*m10 */
    ADD_L      ( REGOFF(12, ESI), EDX ) /* next normal                    */

    MOVD       ( MM1, REGOFF(-4, EAX) ) /* write r2                           */
    MOVQ       ( REGIND(EDX), MM0 )     /* x1            | x0                 */

    MOVD       ( REGOFF(8, EDX), MM2 )  /*               | x2                 */
    DEC_L      ( EDI )                  /* decrement normal counter           */
    JA         ( LLBL (G3TR_rescale) )

    FEMMS

LLBL (G3TR_end):
    POP_L       ( ESI )
    POP_L       ( EDI )
    POP_L       ( ECX )
    RET







ALIGNTEXT16
GLOBL GLNAME(gl_3dnow_transform_normals_no_rot_raw)
GLNAME(gl_3dnow_transform_normals_no_rot_raw):

 #define FRAME_OFFSET 12
    SUB_L   ( CONST(4), ESP )
    PUSH_L  ( EDI )
    PUSH_L  ( ESI )

    MOV_L   (REGOFF(24,ESP), EAX)
    MOV_L   (REGOFF(36,ESP), EDX)
    MOV_L   (REGOFF(8,EAX), EAX)
    MOV_L   (EAX, REGOFF(8,EDX))
    MOV_L   (REGOFF(24,ESP), EDI)
    MOV_L   (REGOFF(4,EDX), EAX)
    MOV_L   (REGOFF(16,ESP), ECX)
    MOV_L   (REGOFF(24,ESP), ESI)
    MOV_L   (REGOFF(64,ECX), ECX)
    MOV_L   (REGOFF(4,EDI), EDX)
    MOV_L   (REGOFF(8,EDI), EDI)

	
ALIGNTEXT32

    CMP_L      ( CONST(0), EDI )
    JE         ( LLBL (G3TNR_end) )

    FEMMS

    MOVD       ( REGIND(ECX), MM0 )     /*               | m0                 */
    PUNPCKLDQ  ( REGOFF(20, ECX), MM0 ) /* m5            | m0                 */

    MOVD       ( REGOFF(40, ECX), MM2 ) /*               | m10                */
    PUNPCKLDQ  ( MM2, MM2 )             /* m10           | m10                */

    MOVQ       ( REGIND(EDX), MM4 )     /* x1            | x0                 */
    MOVD       ( REGOFF(8, EDX), MM5 )  /*               | x2                 */

ALIGNTEXT32

LLBL (G3TNR_transform):
    PFMUL      ( MM0, MM4 )             /* x1*m5         | x0*m0              */
    ADD_L      ( REGOFF(12, ESI), EDX)  /* next normal      */

    PFMUL      ( MM2, MM5 )             /*               | x2*m10             */
    ADD_L      ( CONST(12), EAX )       /* next r                             */

    DEC_L      ( EDI )                  /* decrement normal counter           */
    MOVQ       ( MM4, REGOFF(-12, EAX) ) /* write r0, r1                      */

    MOVD       ( MM5, REGOFF(-4, EAX) ) /* write r2                           */
    MOVQ       ( REGIND(EDX), MM4 )     /* x1            | x0                 */

    MOVD       ( REGOFF(8, EDX), MM5 )  /*               | x2                 */
    JA         ( LLBL (G3TNR_transform) )

    FEMMS

LLBL (G3TNR_end):
    POP_L       ( ESI )
    POP_L       ( EDI )
    POP_L       ( ECX )
    RET








ALIGNTEXT16
GLOBL GLNAME(gl_3dnow_transform_normals_raw)
GLNAME(gl_3dnow_transform_normals_raw):

 #define FRAME_OFFSET 12
    SUB_L   ( CONST(4), ESP )
    PUSH_L  ( EDI )
    PUSH_L  ( ESI )
	
    MOV_L   (REGOFF(24,ESP), EAX)
    MOV_L   (REGOFF(36,ESP), EDX)
    MOV_L   (REGOFF(8,EAX), EAX)
    MOV_L   (EAX, REGOFF(8,EDX))
    MOV_L   (REGOFF(24,ESP), EDI)
    MOV_L   (REGOFF(4,EDX), EAX)
    MOV_L   (REGOFF(16,ESP), ECX)
    MOV_L   (REGOFF(24,ESP), ESI)
    MOV_L   (REGOFF(64,ECX), ECX)
    MOV_L   (REGOFF(4,EDI), EDX)
    MOV_L   (REGOFF(8,EDI), EDI)
	
ALIGNTEXT32

    CMP_L      ( CONST(0), EDI )        /* count > 0 ??                       */
    JE         ( LLBL (G3T_end) )

    FEMMS

    MOVQ       ( REGIND(ECX), MM3 )     /* m1            | m0                 */
    MOVQ       ( REGOFF(16, ECX), MM4 ) /* m5            | m4                 */

    MOVD       ( REGOFF(8, ECX), MM5 )  /*               | m2                 */
    PUNPCKLDQ  ( REGOFF(24, ECX), MM5 ) /* m6            | m2*/

    MOVQ       ( REGOFF(32,ECX), MM6 )  /* m9            | m8                 */
    MOVD       ( REGOFF(40,ECX), MM7 )  /*               | m10                */

    MOVQ       ( REGIND(EDX), MM0 )     /* x1            | x0                 */
    MOVD       ( REGOFF(8, EDX), MM2 )  /*               | x2                 */

LLBL (G3T_transform):
    MOVQ       ( MM0, MM1 )             /* x1            | x0                 */
    PUNPCKLDQ  ( MM2, MM2 )             /* x2            | x2                 */

    PFMUL      ( MM3, MM0 )             /* x1*m1         | x0*m0              */
    ADD_L      ( CONST(12), EAX )       /* next r                             */

    PFMUL      ( MM4, MM1 )             /* x1*m5         | x0*m4              */
    PFACC      ( MM1, MM0 )             /* x0*m4+x1*m5   | x0*m0+x1*m1        */

    PFMUL      ( MM5, MM2 )             /* x2*m6         | x2*m2              */
    PFADD      ( MM2, MM0 )             /* x0*m4...+x2*m6| x0*m0+x1*m1+x2*m2  */

    MOVQ       ( REGIND(EDX), MM1 )     /* x1            | x0                 */
    MOVQ       ( MM0, REGOFF(-12, EAX) ) /* write r0, r1                      */

    PFMUL      ( MM6, MM1 )             /* x1*m9         | x0*m8              */
    MOVD       ( REGOFF(8, EDX), MM2 )  /*               | x2                 */

    PFMUL      ( MM7, MM2 )             /*               | x2*m10             */
    PFACC      ( MM1, MM1 )             /* *not used*    | x0*m8+x1*m9        */

    PFADD      ( MM2, MM1 )             /* *not used*    | x0*m8+x1*m9+x2*m10 */
    ADD_L      ( REGOFF(12, ESI), EDX ) /* next normal               */

    MOVD       ( MM1, REGOFF(-4, EAX) ) /* write r2                           */
    MOVQ       ( REGIND(EDX), MM0 )     /* x1            | x0                 */

    MOVD       ( REGOFF(8, EDX), MM2 )  /*               | x2                 */
    DEC_L      ( EDI )                  /* decrement normal counter           */
    JA         ( LLBL (G3T_transform) )

    FEMMS

LLBL (G3T_end):
    POP_L  ( ESI )
    POP_L  ( EDI )
    POP_L  ( ECX )
    RET






ALIGNTEXT16
GLOBL GLNAME(gl_3dnow_normalize_normals_raw)
GLNAME(gl_3dnow_normalize_normals_raw):

 #define FRAME_OFFSET 12
    SUB_L   ( CONST(4), ESP )
    PUSH_L  ( EDI )
    PUSH_L  ( ESI )

    MOV_L   (REGOFF(16,ESP), ESI)
    MOV_L   (REGOFF(24,ESP), EAX)
    MOV_L   (REGOFF(36,ESP), EDX)
    MOV_L   (REGOFF(8,EAX), EAX)
    MOV_L   (EAX, REGOFF(8,EDX))
    MOV_L   (REGOFF(4,EDX), EAX)
    MOV_L   (REGOFF(24,ESP), ECX)
    MOV_L   (REGOFF(28,ESP), EDX)
    MOV_L   (REGOFF(24,ESP), EDI)
    MOV_L   (REGOFF(4,ECX), ECX)

	
ALIGNTEXT32

    CMP_L      ( CONST(0), REGOFF(8, EDI) ) /* count > 0 ?? */
    JE         ( LLBL (G3N_end) )

    PUSH_L     ( EBP )
    MOV_L      (REGOFF(8,EDI), EBP)

    FEMMS

    MOVQ       ( REGIND(ECX), MM0 )     /* x1              | x0               */
    MOVD       ( REGOFF(8, ECX), MM1 )  /*                 | x2               */

    CMP_L      ( CONST(0), EDX )        /* lengths == 0 ?                     */
    JE         ( LLBL (G3N_norm2) )     /* calculate lengths                  */

LLBL (G3N_norm1):                       /* use precalculated lengths          */
    MOVD       ( REGIND(EDX), MM3 )     /*                 | length (x)       */
    PFMUL      ( MM3, MM1 )             /*                 | x2 (normalized)  */

    PUNPCKLDQ  ( MM3, MM3 )             /* length (x)      | length (x)       */
    PFMUL      ( MM3, MM0 )             /* x1 (normalized) | x0 (normalized)  */

    MOVQ       ( MM0, REGIND(EAX) )     /* write new x0, x1                   */
    MOVD       ( MM1, REGOFF(8, EAX) )  /* write new x2                       */

    ADD_L      ( REGOFF(12, EDI), ECX ) /* next normal            */
    ADD_L      ( CONST(12), EAX )       /* next r                             */

    ADD_L      ( CONST(4), EDX )        /* next length                        */
    DEC_L      ( EBP )                  /* decrement normal counter           */

    MOVQ       ( REGIND(ECX), MM0 )     /* x1              | x0               */
    MOVD       ( REGOFF(8, ECX), MM1 )  /*                 | x2               */
    JA         ( LLBL (G3N_norm1) )

    JMP        ( LLBL (G3N_end1) )

LLBL (G3N_norm2):
                                        /* need to calculate lengths          */
    MOVQ       ( MM0, MM3 )             /* x1              | x0               */
    ADD_L      ( REGOFF(12, EDI), ECX ) /* next normal    */

    PFMUL      ( MM0, MM3 )             /* x1*x1           | x0*x0            */
    MOVQ       ( MM1, MM4 )             /*                 | x2               */

    ADD_L      ( CONST(12), EAX )       /* next r                             */
    PFMUL      ( MM1, MM4 )             /*                 | x2*x2            */

    PFADD      ( MM4, MM3 )             /*                 | x0*x0+x2*x2      */
    PFACC      ( MM3, MM3 )             /* x0*x0+...+x2*x2 | x0*x0+x1*x1+x2*x2*/

    PFRSQRT    ( MM3, MM5 )             /* 1/sqrt (x0*x0+x1*x1+x2*x2)         */
    MOVQ       ( MM5, MM4 )

    PUNPCKLDQ  ( MM3, MM3 )
    PFMUL      ( MM5, MM5 )

    PFRSQIT1   ( MM3, MM5 )
    DEC_L      ( EBP )                  /* decrement normal counter           */

    PFRCPIT2   ( MM4, MM5 )

    PFMUL      ( MM5, MM0 )             /* x1 (normalized) | x0 (normalized)  */
    MOVQ       ( MM0, REGOFF(-12, EAX) ) /* write new x0, x1                  */

    PFMUL      ( MM5, MM1 )             /*                 | x2 (normalized)  */
    MOVD       ( MM1, REGOFF(-4, EAX) ) /* write new x2                       */

    MOVQ       ( REGIND(ECX), MM0 )     /* x1              | x0               */
    MOVD       ( REGOFF(8, ECX), MM1 )  /*                 | x2               */
    JA         ( LLBL (G3N_norm2) )

LLBL (G3N_end1):
    FEMMS
    POP_L      ( EBP )

LLBL (G3N_end):
    POP_L  ( ESI )
    POP_L  ( EDI )
    POP_L  ( ECX )
    RET






ALIGNTEXT16
GLOBL GLNAME(gl_3dnow_rescale_normals_raw)
GLNAME(gl_3dnow_rescale_normals_raw):

 #define FRAME_OFFSET 12
    SUB_L   ( CONST(4), ESP )
    PUSH_L  ( EDI )
    PUSH_L  ( ESI )

    MOV_L   (REGOFF(20,ESP), ESI)
    MOV_L   (REGOFF(24,ESP), EAX)
    MOV_L   (REGOFF(36,ESP), EDX)
    MOV_L   (REGOFF(8,EAX), EAX)
    MOV_L   (EAX, REGOFF(8,EDX))
    MOV_L   (REGOFF(24,ESP), EDI)
    MOV_L   (EDI, ECX)
    MOV_L   (REGOFF(4,EDX), EAX)
    MOV_L   (REGOFF(4,ECX), ECX)
    MOV_L   (REGOFF(8,EDI), EDX)

ALIGNTEXT32

    CMP_L      ( CONST(0), EDX )
    JE         ( LLBL (G3R_end) )

    FEMMS

    MOVD       ( ESI, MM0 )             /* scale                              */
    PUNPCKLDQ  ( MM0, MM0 )

    MOVQ       ( REGIND(ECX), MM1 )     /* x1            | x0                 */
    MOVD       ( REGOFF(8, ECX), MM2 )  /*               | x2                 */

ALIGNTEXT32

LLBL (G3R_rescale):
    PFMUL      ( MM0, MM1 )             /* x1*scale      | x0*scale           */
    ADD_L      ( REGOFF(12, EDI), ECX ) /* next normal                  */

    PFMUL      ( MM0, MM2 )             /*               | x2*scale           */
    ADD_L      ( CONST(12), EAX )       /* next r                             */

    DEC_L      ( EDX )                  /* decrement normal counter           */
    MOVQ       ( MM1, REGOFF(-12, EAX) ) /* write r0, r1                      */

    MOVD       ( MM2, REGOFF(-4, EAX) ) /* write r2                           */
    MOVQ       ( REGIND(ECX), MM1 )     /* x1            | x0                 */

    MOVD       ( REGOFF(8, ECX), MM2 )  /*               | x2                 */
    JA         ( LLBL (G3R_rescale) )

    FEMMS

LLBL (G3R_end):
    POP_L  ( ESI )
    POP_L  ( EDI )
    POP_L  ( ECX )
    RET










