/****************************************************************************
*
*						   Console Output Library
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:		ANSI C
* Environment:	Any
*
* Description:  Data definition for the 8x8, 8x14 and 8x16 text mode fonts.
*
****************************************************************************/

/* VGA index register ports */
#define CRT_I   0x3D4		/* CRT Controller Index 					*/
#define ATT_IW  0x3C0		/* Attribute Controller Index & Data 		*/
#define GRA_I   0x3CE		/* Graphics Controller Index 				*/
#define SEQ_I   0x3C4		/* Sequencer Index 							*/

/* VGA data register ports */
#define CRT_D   0x3D5		/* CRT Controller Data Register				*/
#define ATT_R   0x3C1		/* Attribute Controller Data Read Register 	*/
#define GRA_D   0x3CF		/* Graphics Controller Data Register 		*/
#define SEQ_D   0x3C5		/* Sequencer Data Register 					*/
#define MIS_R   0x3CC		/* Misc Output Read Register 				*/
#define MIS_W   0x3C2		/* Misc Output Write Register 				*/
#define IS1_R   0x3DA		/* Input Status Register 1 					*/

/* Standard VGA indexes max counts */
#define CRT_C   24			/* 24  CRT Controller Registers 			*/
#define ATT_C   21			/* 21  Attribute Controller Registers 		*/
#define GRA_C   9			/* 9   Graphics Controller Registers 		*/
#define SEQ_C   5			/* 5   Sequencer Registers 					*/
#define MIS_C   1			/* 1   Misc Output Register 				*/

/* VGA registers saving indexes */
#define CRT     0			/* CRT Controller Registers start 			*/
#define ATT     (CRT+CRT_C)	/* Attribute Controller Registers start 	*/
#define GRA     (ATT+ATT_C)	/* Graphics Controller Registers start 		*/
#define SEQ     (GRA+GRA_C)	/* Sequencer Registers 						*/
#define MIS     (SEQ+SEQ_C)	/* General Registers 						*/
#define	REG_SIZE	(CRT_C + ATT_C + GRA_C + SEQ_C + MIS_C)

/* Size in bytes of a single character generator RAM definition	*/
#define CHAR_SIZE	32

static uchar VGA_save[REG_SIZE];
static uchar FONT_save[CHAR_SIZE*256+2];

static uchar VGA_80x25[REG_SIZE] = {
	0x5F,0x4F,0x50,0x82,0x55,0x81,0xBF,0x1F,0x00,0x4F,0x0D,0x0E,0x00,0x00,
	0x00,0xA0,0x9C,0x8E,0x8F,0x28,0x1F,0x96,0xB9,0xA3,0x00,0x01,0x02,0x03,
	0x04,0x05,0x14,0x07,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x0C,0x00,
	0x0F,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x0E,0x00,0xFF,0x03,0x00,
	0x03,0x00,0x02,0x67,
	};

static uchar VGA_80x43[REG_SIZE] = {
    0x5F,0x4F,0x50,0x82,0x55,0x81,0xBF,0x1F,0x00,0x47,0x06,0x07,0x00,0x00,
    0x00,0xA0,0x83,0x85,0x57,0x28,0x1F,0x63,0xBA,0xA3,0x00,0x01,0x02,0x03,
    0x04,0x05,0x14,0x07,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x08,0x00,
    0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x0E,0x00,0xFF,0x03,0x01,
	0x03,0x00,0x02,0xA3,
	};

static uchar VGA_80x50[REG_SIZE] = {
	0x5F,0x4F,0x50,0x82,0x55,0x81,0xBF,0x1F,0x00,0x47,0x06,0x07,0x00,0x00,
	0x00,0xA0,0x9C,0x8E,0x8F,0x28,0x1F,0x96,0xB9,0xA3,0x00,0x01,0x02,0x03,
	0x04,0x05,0x14,0x07,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x0C,0x00,
	0x0F,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x0E,0x00,0xFF,0x03,0x00,
	0x03,0x00,0x02,0x67,
	};

static uchar VGA_font8x8[] = {
	8,8,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(00) NUL */
	0x7E,0x81,0xA5,0x81,0xBD,0x99,0x81,0x7E,      /* Char(01) SOH */
	0x7E,0xFF,0xDB,0xFF,0xC3,0xE7,0xFF,0x7E,      /* Char(02) STX */
	0x6C,0xFE,0xFE,0xFE,0x7C,0x38,0x10,0x00,      /* Char(03) ETX */
	0x10,0x38,0x7C,0xFE,0x7C,0x38,0x10,0x00,      /* Char(04) EOT */
	0x38,0x7C,0x38,0xFE,0xFE,0x7C,0x38,0x7C,      /* Char(05) ENQ */
	0x10,0x10,0x38,0x7C,0xFE,0x7C,0x38,0x7C,      /* Char(06) ACK */
	0x00,0x00,0x18,0x3C,0x3C,0x18,0x00,0x00,      /* Char(07) BELL */
	0xFF,0xFF,0xE7,0xC3,0xC3,0xE7,0xFF,0xFF,      /* Char(08) BACKSPACE */
	0x00,0x3C,0x66,0x42,0x42,0x66,0x3C,0x00,      /* Char(09) TAB */
	0xFF,0xC3,0x99,0xBD,0xBD,0x99,0xC3,0xFF,      /* Char(0A) LF */
	0x0F,0x07,0x0F,0x7D,0xCC,0xCC,0xCC,0x78,      /* Char(0B) VT */
	0x3C,0x66,0x66,0x66,0x3C,0x18,0x7E,0x18,      /* Char(0C) FF */
	0x3F,0x33,0x3F,0x30,0x30,0x70,0xF0,0xE0,      /* Char(0D) CR */
	0x7F,0x63,0x7F,0x63,0x63,0x67,0xE6,0xC0,      /* Char(0E) SO */
	0x99,0x5A,0x3C,0xE7,0xE7,0x3C,0x5A,0x99,      /* Char(0F) SI */
	0x80,0xE0,0xF8,0xFE,0xF8,0xE0,0x80,0x00,      /* Char(10) DLE */
	0x02,0x0E,0x3E,0xFE,0x3E,0x0E,0x02,0x00,      /* Char(11) DC1 */
	0x18,0x3C,0x7E,0x18,0x18,0x7E,0x3C,0x18,      /* Char(12) DC2 */
	0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x00,      /* Char(13) DC3 */
	0x7F,0xDB,0xDB,0x7B,0x1B,0x1B,0x1B,0x00,      /* Char(14) DC4 */
	0x3E,0x63,0x38,0x6C,0x6C,0x38,0xCC,0x78,      /* Char(15) NAK */
	0x00,0x00,0x00,0x00,0x7E,0x7E,0x7E,0x00,      /* Char(16) SYN */
	0x18,0x3C,0x7E,0x18,0x7E,0x3C,0x18,0xFF,      /* Char(17) ETB */
	0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x00,      /* Char(18) CAN */
	0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,      /* Char(19) EM */
	0x00,0x18,0x0C,0xFE,0x0C,0x18,0x00,0x00,      /* Char(1A) SUB */
	0x00,0x30,0x60,0xFE,0x60,0x30,0x00,0x00,      /* Char(1B) ESC */
	0x00,0x00,0xC0,0xC0,0xC0,0xFE,0x00,0x00,      /* Char(1C) FS */
	0x00,0x24,0x66,0xFF,0x66,0x24,0x00,0x00,      /* Char(1D) GS */
	0x00,0x18,0x3C,0x7E,0xFF,0xFF,0x00,0x00,      /* Char(1E) RS */
	0x00,0xFF,0xFF,0x7E,0x3C,0x18,0x00,0x00,      /* Char(1F) US */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(20) SPACE */
	0x30,0x78,0x78,0x78,0x30,0x00,0x30,0x00,      /* Char(21) ! */
	0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00,      /* Char(22) " */
	0x6C,0x6C,0xFE,0x6C,0xFE,0x6C,0x6C,0x00,      /* Char(23) # */
	0x30,0x7C,0xC0,0x78,0x0C,0xF8,0x30,0x00,      /* Char(24) $ */
	0x00,0xC6,0xCC,0x18,0x30,0x66,0xC6,0x00,      /* Char(25) % */
	0x38,0x6C,0x38,0x76,0xDC,0xCC,0x76,0x00,      /* Char(26) & */
	0x60,0x60,0xC0,0x00,0x00,0x00,0x00,0x00,      /* Char(27) ' */
	0x18,0x30,0x60,0x60,0x60,0x30,0x18,0x00,      /* Char(28) ( */
	0x60,0x30,0x18,0x18,0x18,0x30,0x60,0x00,      /* Char(29) ) */
	0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00,      /* Char(2A) * */
	0x00,0x30,0x30,0xFC,0x30,0x30,0x00,0x00,      /* Char(2B) + */
	0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x60,      /* Char(2C) , */
	0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00,      /* Char(2D) - */
	0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,      /* Char(2E) . */
	0x06,0x0C,0x18,0x30,0x60,0xC0,0x80,0x00,      /* Char(2F) / */
	0x7C,0xC6,0xCE,0xDE,0xF6,0xE6,0x7C,0x00,      /* Char(30) 0 */
	0x30,0x70,0x30,0x30,0x30,0x30,0xFC,0x00,      /* Char(31) 1 */
	0x78,0xCC,0x0C,0x38,0x60,0xCC,0xFC,0x00,      /* Char(32) 2 */
	0x78,0xCC,0x0C,0x38,0x0C,0xCC,0x78,0x00,      /* Char(33) 3 */
	0x1C,0x3C,0x6C,0xCC,0xFE,0x0C,0x1E,0x00,      /* Char(34) 4 */
	0xFC,0xC0,0xF8,0x0C,0x0C,0xCC,0x78,0x00,      /* Char(35) 5 */
	0x38,0x60,0xC0,0xF8,0xCC,0xCC,0x78,0x00,      /* Char(36) 6 */
	0xFC,0xCC,0x0C,0x18,0x30,0x30,0x30,0x00,      /* Char(37) 7 */
	0x78,0xCC,0xCC,0x78,0xCC,0xCC,0x78,0x00,      /* Char(38) 8 */
	0x78,0xCC,0xCC,0x7C,0x0C,0x18,0x70,0x00,      /* Char(39) 9 */
	0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x00,      /* Char(3A) : */
	0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x60,      /* Char(3B) ; */
	0x18,0x30,0x60,0xC0,0x60,0x30,0x18,0x00,      /* Char(3C) < */
	0x00,0x00,0xFC,0x00,0x00,0xFC,0x00,0x00,      /* Char(3D) = */
	0x60,0x30,0x18,0x0C,0x18,0x30,0x60,0x00,      /* Char(3E) > */
	0x78,0xCC,0x0C,0x18,0x30,0x00,0x30,0x00,      /* Char(3F) ? */
	0x7C,0xC6,0xDE,0xDE,0xDE,0xC0,0x78,0x00,      /* Char(40) @ */
	0x30,0x78,0xCC,0xCC,0xFC,0xCC,0xCC,0x00,      /* Char(41) A */
	0xFC,0x66,0x66,0x7C,0x66,0x66,0xFC,0x00,      /* Char(42) B */
	0x3C,0x66,0xC0,0xC0,0xC0,0x66,0x3C,0x00,      /* Char(43) C */
	0xF8,0x6C,0x66,0x66,0x66,0x6C,0xF8,0x00,      /* Char(44) D */
	0x7E,0x60,0x60,0x78,0x60,0x60,0x7E,0x00,      /* Char(45) E */
    0x7E,0x60,0x60,0x78,0x60,0x60,0x60,0x00,      /* Char(46) F */
    0x3C,0x66,0xC0,0xC0,0xCE,0x66,0x3E,0x00,      /* Char(47) G */
    0xCC,0xCC,0xCC,0xFC,0xCC,0xCC,0xCC,0x00,      /* Char(48) H */
    0x78,0x30,0x30,0x30,0x30,0x30,0x78,0x00,      /* Char(49) I */
    0x1E,0x0C,0x0C,0x0C,0xCC,0xCC,0x78,0x00,      /* Char(4A) J */
    0xE6,0x66,0x6C,0x78,0x6C,0x66,0xE6,0x00,      /* Char(4B) K */
    0x60,0x60,0x60,0x60,0x60,0x60,0x7E,0x00,      /* Char(4C) L */
    0xC6,0xEE,0xFE,0xFE,0xD6,0xC6,0xC6,0x00,      /* Char(4D) M */
    0xC6,0xE6,0xF6,0xDE,0xCE,0xC6,0xC6,0x00,      /* Char(4E) N */
    0x38,0x6C,0xC6,0xC6,0xC6,0x6C,0x38,0x00,      /* Char(4F) O */
    0xFC,0x66,0x66,0x7C,0x60,0x60,0xF0,0x00,      /* Char(50) P */
    0x78,0xCC,0xCC,0xCC,0xDC,0x78,0x1C,0x00,      /* Char(51) Q */
    0xFC,0x66,0x66,0x7C,0x6C,0x66,0xE6,0x00,      /* Char(52) R */
    0x78,0xCC,0xE0,0x70,0x1C,0xCC,0x78,0x00,      /* Char(53) S */
    0xFC,0x30,0x30,0x30,0x30,0x30,0x30,0x00,      /* Char(54) T */
    0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xFC,0x00,      /* Char(55) U */
    0xCC,0xCC,0xCC,0xCC,0xCC,0x78,0x30,0x00,      /* Char(56) V */
    0xC6,0xC6,0xC6,0xD6,0xFE,0xEE,0xC6,0x00,      /* Char(57) W */
    0xC6,0xC6,0x6C,0x38,0x38,0x6C,0xC6,0x00,      /* Char(58) X */
    0xCC,0xCC,0xCC,0x78,0x30,0x30,0x78,0x00,      /* Char(59) Y */
    0xFE,0x06,0x0C,0x18,0x30,0x60,0xFE,0x00,      /* Char(5A) Z */
    0x78,0x60,0x60,0x60,0x60,0x60,0x78,0x00,      /* Char(5B) [ */
    0xC0,0x60,0x30,0x18,0x0C,0x06,0x02,0x00,      /* Char(5C) '\' */
    0x78,0x18,0x18,0x18,0x18,0x18,0x78,0x00,      /* Char(5D) ] */
    0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00,      /* Char(5E) ^ */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,      /* Char(5F) _ */
    0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00,      /* Char(60) ` */
    0x00,0x00,0x78,0x0C,0x7C,0xCC,0x76,0x00,      /* Char(61) a */
    0xE0,0x60,0x60,0x7C,0x66,0x66,0xDC,0x00,      /* Char(62) b */
    0x00,0x00,0x78,0xCC,0xC0,0xCC,0x78,0x00,      /* Char(63) c */
    0x1C,0x0C,0x0C,0x7C,0xCC,0xCC,0x76,0x00,      /* Char(64) d */
    0x00,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00,      /* Char(65) e */
    0x38,0x6C,0x60,0xF0,0x60,0x60,0xF0,0x00,      /* Char(66) f */
    0x00,0x00,0x76,0xCC,0xCC,0x7C,0x0C,0xF8,      /* Char(67) g */
    0xE0,0x60,0x6C,0x76,0x66,0x66,0xE6,0x00,      /* Char(68) h */
    0x30,0x00,0x70,0x30,0x30,0x30,0x78,0x00,      /* Char(69) i */
    0x0C,0x00,0x0C,0x0C,0x0C,0xCC,0xCC,0x78,      /* Char(6A) j */
    0xE0,0x60,0x66,0x6C,0x78,0x6C,0xE6,0x00,      /* Char(6B) k */
    0x70,0x30,0x30,0x30,0x30,0x30,0x78,0x00,      /* Char(6C) l */
    0x00,0x00,0xCC,0xFE,0xFE,0xD6,0xC6,0x00,      /* Char(6D) m */
    0x00,0x00,0xF8,0xCC,0xCC,0xCC,0xCC,0x00,      /* Char(6E) n */
    0x00,0x00,0x78,0xCC,0xCC,0xCC,0x78,0x00,      /* Char(6F) o */
    0x00,0x00,0xDC,0x66,0x66,0x7C,0x60,0xF0,      /* Char(70) p */
    0x00,0x00,0x76,0xCC,0xCC,0x7C,0x0C,0x1E,      /* Char(71) q */
    0x00,0x00,0xDC,0x76,0x66,0x60,0xF0,0x00,      /* Char(72) r */
    0x00,0x00,0x7C,0xC0,0x78,0x0C,0xF8,0x00,      /* Char(73) s */
    0x10,0x30,0x7C,0x30,0x30,0x34,0x18,0x00,      /* Char(74) t */
    0x00,0x00,0xCC,0xCC,0xCC,0xCC,0x76,0x00,      /* Char(75) u */
    0x00,0x00,0xCC,0xCC,0xCC,0x78,0x30,0x00,      /* Char(76) v */
    0x00,0x00,0xC6,0xD6,0xFE,0xFE,0x6C,0x00,      /* Char(77) w */
    0x00,0x00,0xC6,0x6C,0x38,0x6C,0xC6,0x00,      /* Char(78) x */
    0x00,0x00,0xCC,0xCC,0xCC,0x7C,0x0C,0xF8,      /* Char(79) y */
    0x00,0x00,0xFC,0x98,0x30,0x64,0xFC,0x00,      /* Char(7A) z */
    0x1C,0x30,0x30,0xE0,0x30,0x30,0x1C,0x00,      /* Char(7B) { */
    0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x00,      /* Char(7C) | */
    0xE0,0x30,0x30,0x1C,0x30,0x30,0xE0,0x00,      /* Char(7D) } */
    0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(7E) ~ */
    0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0x00,      /* Char(7F) DEL */
    0x78,0xCC,0xC0,0xCC,0x78,0x18,0x0C,0x78,      /* Char(80)  */
    0x00,0xCC,0x00,0xCC,0xCC,0xCC,0x7E,0x00,      /* Char(81)  */
    0x1C,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00,      /* Char(82)  */
    0x7E,0xC3,0x3C,0x06,0x3E,0x66,0x3F,0x00,      /* Char(83)  */
    0xCC,0x00,0x78,0x0C,0x7C,0xCC,0x7E,0x00,      /* Char(84)  */
    0xE0,0x00,0x78,0x0C,0x7C,0xCC,0x7E,0x00,      /* Char(85)  */
    0x30,0x30,0x78,0x0C,0x7C,0xCC,0x7E,0x00,      /* Char(86)  */
    0x00,0x00,0x78,0xC0,0xC0,0x78,0x0C,0x38,      /* Char(87)  */
    0x7E,0xC3,0x3C,0x66,0x7E,0x60,0x3C,0x00,      /* Char(88)  */
    0xCC,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00,      /* Char(89)  */
    0xE0,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00,      /* Char(8A)  */
    0xCC,0x00,0x70,0x30,0x30,0x30,0x78,0x00,      /* Char(8B)  */
    0x7C,0xC6,0x38,0x18,0x18,0x18,0x3C,0x00,      /* Char(8C)  */
    0xE0,0x00,0x70,0x30,0x30,0x30,0x78,0x00,      /* Char(8D)  */
    0xC6,0x38,0x6C,0xC6,0xFE,0xC6,0xC6,0x00,      /* Char(8E)  */
    0x30,0x30,0x00,0x78,0xCC,0xFC,0xCC,0x00,      /* Char(8F)  */
    0x1C,0x00,0xFC,0x60,0x78,0x60,0xFC,0x00,      /* Char(90)  */
    0x00,0x00,0x7F,0x0C,0x7F,0xCC,0x7F,0x00,      /* Char(91)  */
    0x3E,0x6C,0xCC,0xFE,0xCC,0xCC,0xCE,0x00,      /* Char(92)  */
    0x78,0xCC,0x00,0x78,0xCC,0xCC,0x78,0x00,      /* Char(93)  */
    0x00,0xCC,0x00,0x78,0xCC,0xCC,0x78,0x00,      /* Char(94)  */
    0x00,0xE0,0x00,0x78,0xCC,0xCC,0x78,0x00,      /* Char(95)  */
    0x78,0xCC,0x00,0xCC,0xCC,0xCC,0x7E,0x00,      /* Char(96)  */
    0x00,0xE0,0x00,0xCC,0xCC,0xCC,0x7E,0x00,      /* Char(97)  */
    0x00,0xCC,0x00,0xCC,0xCC,0x7C,0x0C,0xF8,      /* Char(98)  */
    0xC3,0x18,0x3C,0x66,0x66,0x3C,0x18,0x00,      /* Char(99)  */
    0xCC,0x00,0xCC,0xCC,0xCC,0xCC,0x78,0x00,      /* Char(9A)  */
    0x18,0x18,0x7E,0xC0,0xC0,0x7E,0x18,0x18,      /* Char(9B)  */
    0x38,0x6C,0x64,0xF0,0x60,0xE6,0xFC,0x00,      /* Char(9C)  */
    0xCC,0xCC,0x78,0xFC,0x30,0xFC,0x30,0x30,      /* Char(9D)  */
    0xF8,0xCC,0xCC,0xFA,0xC6,0xCF,0xC6,0xC7,      /* Char(9E)  */
    0x0E,0x1B,0x18,0x3C,0x18,0x18,0xD8,0x70,      /* Char(9F)  */
    0x1C,0x00,0x78,0x0C,0x7C,0xCC,0x7E,0x00,      /* Char(A0)  */
    0x38,0x00,0x70,0x30,0x30,0x30,0x78,0x00,      /* Char(A1)  */
    0x00,0x1C,0x00,0x78,0xCC,0xCC,0x78,0x00,      /* Char(A2)  */
    0x00,0x1C,0x00,0xCC,0xCC,0xCC,0x7E,0x00,      /* Char(A3)  */
    0x00,0xF8,0x00,0xF8,0xCC,0xCC,0xCC,0x00,      /* Char(A4)  */
    0xFC,0x00,0xCC,0xEC,0xFC,0xDC,0xCC,0x00,      /* Char(A5)  */
    0x3C,0x6C,0x6C,0x3E,0x00,0x7E,0x00,0x00,      /* Char(A6)  */
    0x38,0x6C,0x6C,0x38,0x00,0x7C,0x00,0x00,      /* Char(A7)  */
    0x30,0x00,0x30,0x60,0xC0,0xCC,0x78,0x00,      /* Char(A8)  */
    0x00,0x00,0x00,0xFC,0xC0,0xC0,0x00,0x00,      /* Char(A9)  */
    0x00,0x00,0x00,0xFC,0x0C,0x0C,0x00,0x00,      /* Char(AA)  */
    0xC3,0xC6,0xCC,0xDE,0x33,0x66,0xCC,0x0F,      /* Char(AB)  */
    0xC3,0xC6,0xCC,0xDB,0x37,0x6F,0xCF,0x03,      /* Char(AC)  */
    0x18,0x18,0x00,0x18,0x18,0x18,0x18,0x00,      /* Char(AD)  */
    0x00,0x33,0x66,0xCC,0x66,0x33,0x00,0x00,      /* Char(AE)  */
    0x00,0xCC,0x66,0x33,0x66,0xCC,0x00,0x00,      /* Char(AF)  */
    0x22,0x88,0x22,0x88,0x22,0x88,0x22,0x88,      /* Char(B0)  */
    0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,      /* Char(B1)  */
    0xDB,0x77,0xDB,0xEE,0xDB,0x77,0xDB,0xEE,      /* Char(B2)  */
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,      /* Char(B3)  */
    0x18,0x18,0x18,0x18,0xF8,0x18,0x18,0x18,      /* Char(B4)  */
    0x18,0x18,0xF8,0x18,0xF8,0x18,0x18,0x18,      /* Char(B5)  */
    0x36,0x36,0x36,0x36,0xF6,0x36,0x36,0x36,      /* Char(B6)  */
    0x00,0x00,0x00,0x00,0xFE,0x36,0x36,0x36,      /* Char(B7)  */
    0x00,0x00,0xF8,0x18,0xF8,0x18,0x18,0x18,      /* Char(B8)  */
    0x36,0x36,0xF6,0x06,0xF6,0x36,0x36,0x36,      /* Char(B9)  */
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,      /* Char(BA)  */
    0x00,0x00,0xFE,0x06,0xF6,0x36,0x36,0x36,      /* Char(BB)  */
    0x36,0x36,0xF6,0x06,0xFE,0x00,0x00,0x00,      /* Char(BC)  */
    0x36,0x36,0x36,0x36,0xFE,0x00,0x00,0x00,      /* Char(BD)  */
    0x18,0x18,0xF8,0x18,0xF8,0x00,0x00,0x00,      /* Char(BE)  */
    0x00,0x00,0x00,0x00,0xF8,0x18,0x18,0x18,      /* Char(BF)  */
    0x18,0x18,0x18,0x18,0x1F,0x00,0x00,0x00,      /* Char(C0)  */
    0x18,0x18,0x18,0x18,0xFF,0x00,0x00,0x00,      /* Char(C1)  */
    0x00,0x00,0x00,0x00,0xFF,0x18,0x18,0x18,      /* Char(C2)  */
    0x18,0x18,0x18,0x18,0x1F,0x18,0x18,0x18,      /* Char(C3)  */
    0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,      /* Char(C4)  */
    0x18,0x18,0x18,0x18,0xFF,0x18,0x18,0x18,      /* Char(C5)  */
    0x18,0x18,0x1F,0x18,0x1F,0x18,0x18,0x18,      /* Char(C6)  */
    0x36,0x36,0x36,0x36,0x37,0x36,0x36,0x36,      /* Char(C7)  */
    0x36,0x36,0x37,0x30,0x3F,0x00,0x00,0x00,      /* Char(C8)  */
    0x00,0x00,0x3F,0x30,0x37,0x36,0x36,0x36,      /* Char(C9)  */
    0x36,0x36,0xF7,0x00,0xFF,0x00,0x00,0x00,      /* Char(CA)  */
    0x00,0x00,0xFF,0x00,0xF7,0x36,0x36,0x36,      /* Char(CB)  */
    0x36,0x36,0x37,0x30,0x37,0x36,0x36,0x36,      /* Char(CC)  */
    0x00,0x00,0xFF,0x00,0xFF,0x00,0x00,0x00,      /* Char(CD)  */
    0x36,0x36,0xF7,0x00,0xF7,0x36,0x36,0x36,      /* Char(CE)  */
    0x18,0x18,0xFF,0x00,0xFF,0x00,0x00,0x00,      /* Char(CF)  */
    0x36,0x36,0x36,0x36,0xFF,0x00,0x00,0x00,      /* Char(D0)  */
    0x00,0x00,0xFF,0x00,0xFF,0x18,0x18,0x18,      /* Char(D1)  */
    0x00,0x00,0x00,0x00,0xFF,0x36,0x36,0x36,      /* Char(D2)  */
    0x36,0x36,0x36,0x36,0x3F,0x00,0x00,0x00,      /* Char(D3)  */
    0x18,0x18,0x1F,0x18,0x1F,0x00,0x00,0x00,      /* Char(D4)  */
    0x00,0x00,0x1F,0x18,0x1F,0x18,0x18,0x18,      /* Char(D5)  */
    0x00,0x00,0x00,0x00,0x3F,0x36,0x36,0x36,      /* Char(D6)  */
    0x36,0x36,0x36,0x36,0xFF,0x36,0x36,0x36,      /* Char(D7)  */
    0x18,0x18,0xFF,0x18,0xFF,0x18,0x18,0x18,      /* Char(D8)  */
    0x18,0x18,0x18,0x18,0xF8,0x00,0x00,0x00,      /* Char(D9)  */
    0x00,0x00,0x00,0x00,0x1F,0x18,0x18,0x18,      /* Char(DA)  */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,      /* Char(DB)  */
    0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,      /* Char(DC)  */
    0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,      /* Char(DD)  */
    0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,      /* Char(DE)  */
    0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,      /* Char(DF)  */
    0x00,0x00,0x76,0xDC,0xC8,0xDC,0x76,0x00,      /* Char(E0)  */
    0x00,0x78,0xCC,0xF8,0xCC,0xF8,0xC0,0xC0,      /* Char(E1)  */
    0x00,0xFC,0xCC,0xC0,0xC0,0xC0,0xC0,0x00,      /* Char(E2)  */
    0x00,0xFE,0x6C,0x6C,0x6C,0x6C,0x6C,0x00,      /* Char(E3)  */
    0xFC,0xCC,0x60,0x30,0x60,0xCC,0xFC,0x00,      /* Char(E4)  */
    0x00,0x00,0x7E,0xD8,0xD8,0xD8,0x70,0x00,      /* Char(E5)  */
    0x00,0x66,0x66,0x66,0x66,0x7C,0x60,0xC0,      /* Char(E6)  */
    0x00,0x76,0xDC,0x18,0x18,0x18,0x18,0x00,      /* Char(E7)  */
    0xFC,0x30,0x78,0xCC,0xCC,0x78,0x30,0xFC,      /* Char(E8)  */
    0x38,0x6C,0xC6,0xFE,0xC6,0x6C,0x38,0x00,      /* Char(E9)  */
    0x38,0x6C,0xC6,0xC6,0x6C,0x6C,0xEE,0x00,      /* Char(EA)  */
    0x1C,0x30,0x18,0x7C,0xCC,0xCC,0x78,0x00,      /* Char(EB)  */
    0x00,0x00,0x7E,0xDB,0xDB,0x7E,0x00,0x00,      /* Char(EC)  */
    0x06,0x0C,0x7E,0xDB,0xDB,0x7E,0x60,0xC0,      /* Char(ED)  */
    0x38,0x60,0xC0,0xF8,0xC0,0x60,0x38,0x00,      /* Char(EE)  */
    0x78,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x00,      /* Char(EF)  */
    0x00,0xFC,0x00,0xFC,0x00,0xFC,0x00,0x00,      /* Char(F0)  */
    0x30,0x30,0xFC,0x30,0x30,0x00,0xFC,0x00,      /* Char(F1)  */
    0x60,0x30,0x18,0x30,0x60,0x00,0xFC,0x00,      /* Char(F2)  */
    0x18,0x30,0x60,0x30,0x18,0x00,0xFC,0x00,      /* Char(F3)  */
    0x0E,0x1B,0x1B,0x18,0x18,0x18,0x18,0x18,      /* Char(F4)  */
    0x18,0x18,0x18,0x18,0x18,0xD8,0xD8,0x70,      /* Char(F5)  */
    0x30,0x30,0x00,0xFC,0x00,0x30,0x30,0x00,      /* Char(F6)  */
    0x00,0x76,0xDC,0x00,0x76,0xDC,0x00,0x00,      /* Char(F7)  */
    0x38,0x6C,0x6C,0x38,0x00,0x00,0x00,0x00,      /* Char(F8)  */
    0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,      /* Char(F9)  */
    0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,      /* Char(FA)  */
    0x0F,0x0C,0x0C,0x0C,0xEC,0x6C,0x3C,0x1C,      /* Char(FB)  */
    0x78,0x6C,0x6C,0x6C,0x6C,0x00,0x00,0x00,      /* Char(FC)  */
    0x70,0x18,0x30,0x60,0x78,0x00,0x00,0x00,      /* Char(FD)  */
    0x00,0x00,0x3C,0x3C,0x3C,0x3C,0x00,0x00,      /* Char(FE)  */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(FF)  */
	};

static uchar VGA_font8x16[] = {
	8,16,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(00) NUL       */
    0x00,0x00,0x7E,0x81,0xA5,0x81,0x81,0xBD,0x99,0x81,0x81,0x7E,0x00,0x00,0x00,0x00,      /* Char(01) SOH       */
    0x00,0x00,0x7E,0xFF,0xDB,0xFF,0xFF,0xC3,0xE7,0xFF,0xFF,0x7E,0x00,0x00,0x00,0x00,      /* Char(02) STX       */
    0x00,0x00,0x00,0x00,0x6C,0xFE,0xFE,0xFE,0xFE,0x7C,0x38,0x10,0x00,0x00,0x00,0x00,      /* Char(03) ETX       */
    0x00,0x00,0x00,0x00,0x10,0x38,0x7C,0xFE,0x7C,0x38,0x10,0x00,0x00,0x00,0x00,0x00,      /* Char(04) EOT       */
    0x00,0x00,0x00,0x18,0x3C,0x3C,0xE7,0xE7,0xE7,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,      /* Char(05) ENQ       */
    0x00,0x00,0x00,0x18,0x3C,0x7E,0xFF,0xFF,0x7E,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,      /* Char(06) ACK       */
    0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x3C,0x3C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(07) BELL      */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xE7,0xC3,0xC3,0xE7,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,      /* Char(08) BACKSPACE */
    0x00,0x00,0x00,0x00,0x00,0x3C,0x66,0x42,0x42,0x66,0x3C,0x00,0x00,0x00,0x00,0x00,      /* Char(09) TAB       */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xC3,0x99,0xBD,0xBD,0x99,0xC3,0xFF,0xFF,0xFF,0xFF,0xFF,      /* Char(0A) LF        */
    0x00,0x00,0x1E,0x0E,0x1A,0x32,0x78,0xCC,0xCC,0xCC,0xCC,0x78,0x00,0x00,0x00,0x00,      /* Char(0B) VT        */
    0x00,0x00,0x3C,0x66,0x66,0x66,0x66,0x3C,0x18,0x7E,0x18,0x18,0x00,0x00,0x00,0x00,      /* Char(0C) FF        */
    0x00,0x00,0x3F,0x33,0x3F,0x30,0x30,0x30,0x30,0x70,0xF0,0xE0,0x00,0x00,0x00,0x00,      /* Char(0D) C         */
    0x00,0x00,0x7F,0x63,0x7F,0x63,0x63,0x63,0x63,0x67,0xE7,0xE6,0xC0,0x00,0x00,0x00,      /* Char(0E) SO        */
    0x00,0x00,0x00,0x18,0x18,0xDB,0x3C,0xE7,0x3C,0xDB,0x18,0x18,0x00,0x00,0x00,0x00,      /* Char(0F) SI        */
    0x00,0x80,0xC0,0xE0,0xF0,0xF8,0xFE,0xF8,0xF0,0xE0,0xC0,0x80,0x00,0x00,0x00,0x00,      /* Char(10) DLE       */
    0x00,0x02,0x06,0x0E,0x1E,0x3E,0xFE,0x3E,0x1E,0x0E,0x06,0x02,0x00,0x00,0x00,0x00,      /* Char(11) DC1       */
    0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,0x00,0x00,0x00,0x00,      /* Char(12) DC2       */
    0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x66,0x00,0x00,0x00,0x00,      /* Char(13) DC3       */
    0x00,0x00,0x7F,0xDB,0xDB,0xDB,0x7B,0x1B,0x1B,0x1B,0x1B,0x1B,0x00,0x00,0x00,0x00,      /* Char(14) DC4       */
    0x00,0x7C,0xC6,0x60,0x38,0x6C,0xC6,0xC6,0x6C,0x38,0x0C,0xC6,0x7C,0x00,0x00,0x00,      /* Char(15) NAK       */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0xFE,0xFE,0x00,0x00,0x00,0x00,      /* Char(16) SYN       */
    0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x7E,0x3C,0x18,0x7E,0x00,0x00,0x00,0x00,      /* Char(17) ETB       */
    0x00,0x00,0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00,      /* Char(18) CAN       */
    0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00,0x00,0x00,0x00,      /* Char(19) EM        */
    0x00,0x00,0x00,0x00,0x00,0x18,0x0C,0xFE,0x0C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(1A) SUB       */
    0x00,0x00,0x00,0x00,0x00,0x30,0x60,0xFE,0x60,0x30,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(1B) ESC       */
    0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0xC0,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(1C) FS        */
    0x00,0x00,0x00,0x00,0x00,0x28,0x6C,0xFE,0x6C,0x28,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(1D) GS        */
    0x00,0x00,0x00,0x00,0x10,0x38,0x38,0x7C,0x7C,0xFE,0xFE,0x00,0x00,0x00,0x00,0x00,      /* Char(1E) RS        */
    0x00,0x00,0x00,0x00,0xFE,0xFE,0x7C,0x7C,0x38,0x38,0x10,0x00,0x00,0x00,0x00,0x00,      /* Char(1F) US        */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(20) SPACE     */
    0x00,0x00,0x18,0x3C,0x3C,0x3C,0x18,0x18,0x18,0x00,0x18,0x18,0x00,0x00,0x00,0x00,      /* Char(21) !         */
    0x00,0x66,0x66,0x66,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(22) "         */
    0x00,0x00,0x00,0x6C,0x6C,0xFE,0x6C,0x6C,0x6C,0xFE,0x6C,0x6C,0x00,0x00,0x00,0x00,      /* Char(23) #         */
    0x18,0x18,0x7C,0xC6,0xC2,0xC0,0x7C,0x06,0x06,0x86,0xC6,0x7C,0x18,0x18,0x00,0x00,      /* Char(24) $         */
    0x00,0x00,0x00,0x00,0xC2,0xC6,0x0C,0x18,0x30,0x60,0xC6,0x86,0x00,0x00,0x00,0x00,      /* Char(25) %         */
    0x00,0x00,0x38,0x6C,0x6C,0x38,0x76,0xDC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00,      /* Char(26) &         */
    0x00,0x30,0x30,0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(27) '         */
    0x00,0x00,0x0C,0x18,0x30,0x30,0x30,0x30,0x30,0x30,0x18,0x0C,0x00,0x00,0x00,0x00,      /* Char(28) (         */
    0x00,0x00,0x30,0x18,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x18,0x30,0x00,0x00,0x00,0x00,      /* Char(29) )         */
    0x00,0x00,0x00,0x00,0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(2A) *         */
    0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(2B) +         */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x30,0x00,0x00,0x00,      /* Char(2C) ,         */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(2D) -         */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,      /* Char(2E) .         */
    0x00,0x00,0x00,0x00,0x02,0x06,0x0C,0x18,0x30,0x60,0xC0,0x80,0x00,0x00,0x00,0x00,      /* Char(2F) /         */
    0x00,0x00,0x38,0x6C,0xC6,0xC6,0xD6,0xD6,0xC6,0xC6,0x6C,0x38,0x00,0x00,0x00,0x00,      /* Char(30) 0         */
    0x00,0x00,0x18,0x38,0x78,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x00,0x00,0x00,0x00,      /* Char(31) 1         */
    0x00,0x00,0x7C,0xC6,0x06,0x0C,0x18,0x30,0x60,0xC0,0xC6,0xFE,0x00,0x00,0x00,0x00,      /* Char(32) 2         */
    0x00,0x00,0x7C,0xC6,0x06,0x06,0x3C,0x06,0x06,0x06,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(33) 3         */
    0x00,0x00,0x0C,0x1C,0x3C,0x6C,0xCC,0xFE,0x0C,0x0C,0x0C,0x1E,0x00,0x00,0x00,0x00,      /* Char(34) 4         */
    0x00,0x00,0xFE,0xC0,0xC0,0xC0,0xFC,0x06,0x06,0x06,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(35) 5         */
    0x00,0x00,0x38,0x60,0xC0,0xC0,0xFC,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(36) 6         */
    0x00,0x00,0xFE,0xC6,0x06,0x06,0x0C,0x18,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,      /* Char(37) 7         */
    0x00,0x00,0x7C,0xC6,0xC6,0xC6,0x7C,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(38) 8         */
    0x00,0x00,0x7C,0xC6,0xC6,0xC6,0x7E,0x06,0x06,0x06,0x0C,0x78,0x00,0x00,0x00,0x00,      /* Char(39) 9         */
    0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,      /* Char(3A) :         */
    0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x18,0x18,0x30,0x00,0x00,0x00,0x00,      /* Char(3B) ;         */
    0x00,0x00,0x00,0x06,0x0C,0x18,0x30,0x60,0x30,0x18,0x0C,0x06,0x00,0x00,0x00,0x00,      /* Char(3C) <         */
    0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(3D) =         */
    0x00,0x00,0x00,0x60,0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x60,0x00,0x00,0x00,0x00,      /* Char(3E) >         */
    0x00,0x00,0x7C,0xC6,0xC6,0x0C,0x18,0x18,0x18,0x00,0x18,0x18,0x00,0x00,0x00,0x00,      /* Char(3F) ?         */
    0x00,0x00,0x00,0x7C,0xC6,0xC6,0xDE,0xDE,0xDE,0xDC,0xC0,0x7C,0x00,0x00,0x00,0x00,      /* Char(40) @         */
    0x00,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00,      /* Char(41) A         */
    0x00,0x00,0xFC,0x66,0x66,0x66,0x7C,0x66,0x66,0x66,0x66,0xFC,0x00,0x00,0x00,0x00,      /* Char(42) B         */
    0x00,0x00,0x3C,0x66,0xC2,0xC0,0xC0,0xC0,0xC0,0xC2,0x66,0x3C,0x00,0x00,0x00,0x00,      /* Char(43) C         */
    0x00,0x00,0xF8,0x6C,0x66,0x66,0x66,0x66,0x66,0x66,0x6C,0xF8,0x00,0x00,0x00,0x00,      /* Char(44) D         */
    0x00,0x00,0xFE,0x66,0x62,0x68,0x78,0x68,0x60,0x62,0x66,0xFE,0x00,0x00,0x00,0x00,      /* Char(45) E         */
    0x00,0x00,0xFE,0x66,0x62,0x68,0x78,0x68,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00,      /* Char(46) F         */
    0x00,0x00,0x3C,0x66,0xC2,0xC0,0xC0,0xDE,0xC6,0xC6,0x66,0x3A,0x00,0x00,0x00,0x00,      /* Char(47) G         */
    0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00,      /* Char(48) H         */
    0x00,0x00,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,      /* Char(49) I         */
    0x00,0x00,0x1E,0x0C,0x0C,0x0C,0x0C,0x0C,0xCC,0xCC,0xCC,0x78,0x00,0x00,0x00,0x00,      /* Char(4A) J         */
    0x00,0x00,0xE6,0x66,0x66,0x6C,0x78,0x78,0x6C,0x66,0x66,0xE6,0x00,0x00,0x00,0x00,      /* Char(4B) K         */
    0x00,0x00,0xF0,0x60,0x60,0x60,0x60,0x60,0x60,0x62,0x66,0xFE,0x00,0x00,0x00,0x00,      /* Char(4C) L         */
    0x00,0x00,0xC6,0xEE,0xFE,0xFE,0xD6,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00,      /* Char(4D) M         */
    0x00,0x00,0xC6,0xE6,0xF6,0xFE,0xDE,0xCE,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00,      /* Char(4E) N         */
    0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(4F) O         */
    0x00,0x00,0xFC,0x66,0x66,0x66,0x7C,0x60,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00,      /* Char(50) P         */
    0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xD6,0xDE,0x7C,0x0C,0x0E,0x00,0x00,      /* Char(51) Q         */
    0x00,0x00,0xFC,0x66,0x66,0x66,0x7C,0x6C,0x66,0x66,0x66,0xE6,0x00,0x00,0x00,0x00,      /* Char(52) R         */
    0x00,0x00,0x7C,0xC6,0xC6,0x60,0x38,0x0C,0x06,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(53) S         */
    0x00,0x00,0x7E,0x7E,0x5A,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,      /* Char(54) T         */
    0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(55) U         */
    0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x6C,0x38,0x10,0x00,0x00,0x00,0x00,      /* Char(56) V         */
    0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xD6,0xD6,0xD6,0xFE,0xEE,0x6C,0x00,0x00,0x00,0x00,      /* Char(57) W         */
    0x00,0x00,0xC6,0xC6,0x6C,0x7C,0x38,0x38,0x7C,0x6C,0xC6,0xC6,0x00,0x00,0x00,0x00,      /* Char(58) X         */
    0x00,0x00,0x66,0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,      /* Char(59) Y         */
    0x00,0x00,0xFE,0xC6,0x86,0x0C,0x18,0x30,0x60,0xC2,0xC6,0xFE,0x00,0x00,0x00,0x00,      /* Char(5A) Z         */
    0x00,0x00,0x3C,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x3C,0x00,0x00,0x00,0x00,      /* Char(5B) [         */
    0x00,0x00,0x00,0x80,0xC0,0xE0,0x70,0x38,0x1C,0x0E,0x06,0x02,0x00,0x00,0x00,0x00,      /* Char(5C) '\'       */
    0x00,0x00,0x3C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x3C,0x00,0x00,0x00,0x00,      /* Char(5D) ]         */
    0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(5E) ^         */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,      /* Char(5F) _         */
    0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(60) `         */
    0x00,0x00,0x00,0x00,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00,      /* Char(61) a         */
    0x00,0x00,0xE0,0x60,0x60,0x78,0x6C,0x66,0x66,0x66,0x66,0x7C,0x00,0x00,0x00,0x00,      /* Char(62) b         */
    0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC0,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(63) c         */
    0x00,0x00,0x1C,0x0C,0x0C,0x3C,0x6C,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00,      /* Char(64) d         */
    0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(65) e         */
    0x00,0x00,0x38,0x6C,0x64,0x60,0xF0,0x60,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00,      /* Char(66) f         */
    0x00,0x00,0x00,0x00,0x00,0x76,0xCC,0xCC,0xCC,0xCC,0xCC,0x7C,0x0C,0xCC,0x78,0x00,      /* Char(67) g         */
    0x00,0x00,0xE0,0x60,0x60,0x6C,0x76,0x66,0x66,0x66,0x66,0xE6,0x00,0x00,0x00,0x00,      /* Char(68) h         */
    0x00,0x00,0x18,0x18,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,      /* Char(69) i         */
    0x00,0x00,0x06,0x06,0x00,0x0E,0x06,0x06,0x06,0x06,0x06,0x06,0x66,0x66,0x3C,0x00,      /* Char(6A) j         */
    0x00,0x00,0xE0,0x60,0x60,0x66,0x6C,0x78,0x78,0x6C,0x66,0xE6,0x00,0x00,0x00,0x00,      /* Char(6B) k         */
    0x00,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,      /* Char(6C) l         */
    0x00,0x00,0x00,0x00,0x00,0xEC,0xFE,0xD6,0xD6,0xD6,0xD6,0xC6,0x00,0x00,0x00,0x00,      /* Char(6D) m         */
    0x00,0x00,0x00,0x00,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x00,0x00,      /* Char(6E) n         */
    0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(6F) o         */
    0x00,0x00,0x00,0x00,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x7C,0x60,0x60,0xF0,0x00,      /* Char(70) p         */
    0x00,0x00,0x00,0x00,0x00,0x76,0xCC,0xCC,0xCC,0xCC,0xCC,0x7C,0x0C,0x0C,0x1E,0x00,      /* Char(71) q         */
    0x00,0x00,0x00,0x00,0x00,0xDC,0x76,0x66,0x60,0x60,0x60,0xF0,0x00,0x00,0x00,0x00,      /* Char(72) r         */
    0x00,0x00,0x00,0x00,0x00,0x7C,0xC6,0x60,0x38,0x0C,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(73) s         */
    0x00,0x00,0x10,0x30,0x30,0xFC,0x30,0x30,0x30,0x30,0x36,0x1C,0x00,0x00,0x00,0x00,      /* Char(74) t         */
    0x00,0x00,0x00,0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00,      /* Char(75) u         */
    0x00,0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x3C,0x18,0x00,0x00,0x00,0x00,      /* Char(76) v         */
    0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xD6,0xD6,0xD6,0xFE,0x6C,0x00,0x00,0x00,0x00,      /* Char(77) w         */
    0x00,0x00,0x00,0x00,0x00,0xC6,0x6C,0x38,0x38,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00,      /* Char(78) x         */
    0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x0C,0xF8,0x00,      /* Char(79) y         */
    0x00,0x00,0x00,0x00,0x00,0xFE,0xCC,0x18,0x30,0x60,0xC6,0xFE,0x00,0x00,0x00,0x00,      /* Char(7A) z         */
    0x00,0x00,0x0E,0x18,0x18,0x18,0x70,0x18,0x18,0x18,0x18,0x0E,0x00,0x00,0x00,0x00,      /* Char(7B) {         */
    0x00,0x00,0x18,0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00,      /* Char(7C) |         */
    0x00,0x00,0x70,0x18,0x18,0x18,0x0E,0x18,0x18,0x18,0x18,0x70,0x00,0x00,0x00,0x00,      /* Char(7D) }         */
    0x00,0x00,0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(7E) ~         */
    0x00,0x00,0x00,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xC6,0xFE,0x00,0x00,0x00,0x00,0x00,      /* Char(7F) DEL       */
    0x00,0x00,0x3C,0x66,0xC2,0xC0,0xC0,0xC0,0xC2,0x66,0x3C,0x0C,0x06,0x7C,0x00,0x00,      /* Char(80)          */
    0x00,0x00,0xCC,0x00,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00,      /* Char(81)          */
    0x00,0x0C,0x18,0x30,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(82)          */
    0x00,0x10,0x38,0x6C,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00,      /* Char(83)          */
    0x00,0x00,0xCC,0x00,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00,      /* Char(84)          */
    0x00,0x60,0x30,0x18,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00,      /* Char(85)          */
    0x00,0x38,0x6C,0x38,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00,      /* Char(86)          */
    0x00,0x00,0x00,0x00,0x3C,0x66,0x60,0x60,0x66,0x3C,0x0C,0x06,0x3C,0x00,0x00,0x00,      /* Char(87)          */
    0x00,0x10,0x38,0x6C,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(88)          */
    0x00,0x00,0xC6,0x00,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(89)          */
    0x00,0x60,0x30,0x18,0x00,0x7C,0xC6,0xFE,0xC0,0xC0,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(8A)          */
    0x00,0x00,0x66,0x00,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,      /* Char(8B)          */
    0x00,0x18,0x3C,0x66,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,      /* Char(8C)          */
    0x00,0x60,0x30,0x18,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,      /* Char(8D)          */
    0x00,0xC6,0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00,      /* Char(8E)          */
    0x38,0x6C,0x38,0x00,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00,      /* Char(8F)          */
    0x18,0x30,0x60,0x00,0xFE,0x66,0x60,0x7C,0x60,0x60,0x66,0xFE,0x00,0x00,0x00,0x00,      /* Char(90)          */
    0x00,0x00,0x00,0x00,0x00,0xCC,0x76,0x36,0x7E,0xD8,0xD8,0x6E,0x00,0x00,0x00,0x00,      /* Char(91)          */
    0x00,0x00,0x3E,0x6C,0xCC,0xCC,0xFE,0xCC,0xCC,0xCC,0xCC,0xCE,0x00,0x00,0x00,0x00,      /* Char(92)          */
    0x00,0x10,0x38,0x6C,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(93)          */
    0x00,0x00,0xC6,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(94)          */
    0x00,0x60,0x30,0x18,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(95)          */
    0x00,0x30,0x78,0xCC,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00,      /* Char(96)          */
    0x00,0x60,0x30,0x18,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00,      /* Char(97)          */
    0x00,0x00,0xC6,0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7E,0x06,0x0C,0x78,0x00,      /* Char(98)          */
    0x00,0xC6,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(99)          */
    0x00,0xC6,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(9A)          */
    0x00,0x18,0x18,0x3C,0x66,0x60,0x60,0x60,0x66,0x3C,0x18,0x18,0x00,0x00,0x00,0x00,      /* Char(9B)          */
    0x00,0x38,0x6C,0x64,0x60,0xF0,0x60,0x60,0x60,0x60,0xE6,0xFC,0x00,0x00,0x00,0x00,      /* Char(9C)          */
    0x00,0x00,0x66,0x66,0x3C,0x18,0x7E,0x18,0x7E,0x18,0x18,0x18,0x00,0x00,0x00,0x00,      /* Char(9D)          */
    0x00,0xF8,0xCC,0xCC,0xF8,0xC4,0xCC,0xDE,0xCC,0xCC,0xCC,0xC6,0x00,0x00,0x00,0x00,      /* Char(9E)          */
    0x00,0x0E,0x1B,0x18,0x18,0x18,0x7E,0x18,0x18,0x18,0x18,0x18,0xD8,0x70,0x00,0x00,      /* Char(9F)          */
    0x00,0x18,0x30,0x60,0x00,0x78,0x0C,0x7C,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00,      /* Char(A0)          */
    0x00,0x0C,0x18,0x30,0x00,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,0x00,0x00,0x00,      /* Char(A1)          */
    0x00,0x18,0x30,0x60,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(A2)          */
    0x00,0x18,0x30,0x60,0x00,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x76,0x00,0x00,0x00,0x00,      /* Char(A3)          */
    0x00,0x00,0x76,0xDC,0x00,0xDC,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x00,0x00,      /* Char(A4)          */
    0x76,0xDC,0x00,0xC6,0xE6,0xF6,0xFE,0xDE,0xCE,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00,      /* Char(A5)          */
    0x00,0x3C,0x6C,0x6C,0x3E,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(A6)          */
    0x00,0x38,0x6C,0x6C,0x38,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(A7)          */
    0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x60,0xC0,0xC6,0xC6,0x7C,0x00,0x00,0x00,0x00,      /* Char(A8)          */
    0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xC0,0xC0,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,      /* Char(A9)          */
    0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x06,0x06,0x06,0x06,0x00,0x00,0x00,0x00,0x00,      /* Char(AA)          */
    0x00,0xC0,0xC0,0xC2,0xC6,0xCC,0x18,0x30,0x60,0xDC,0x86,0x0C,0x18,0x3E,0x00,0x00,      /* Char(AB)          */
    0x00,0xC0,0xC0,0xC2,0xC6,0xCC,0x18,0x30,0x66,0xCE,0x9E,0x3E,0x06,0x06,0x00,0x00,      /* Char(AC)          */
    0x00,0x00,0x18,0x18,0x00,0x18,0x18,0x18,0x3C,0x3C,0x3C,0x18,0x00,0x00,0x00,0x00,      /* Char(AD)          */
    0x00,0x00,0x00,0x00,0x00,0x36,0x6C,0xD8,0x6C,0x36,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(AE)          */
    0x00,0x00,0x00,0x00,0x00,0xD8,0x6C,0x36,0x6C,0xD8,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(AF)          */
    0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,0x11,0x44,      /* Char(B0)          */
    0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,      /* Char(B1)          */
    0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,0xDD,0x77,      /* Char(B2)          */
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,      /* Char(B3)          */
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,      /* Char(B4)          */
    0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,      /* Char(B5)          */
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,      /* Char(B6)          */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,      /* Char(B7)          */
    0x00,0x00,0x00,0x00,0x00,0xF8,0x18,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,      /* Char(B8)          */
    0x36,0x36,0x36,0x36,0x36,0xF6,0x06,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,      /* Char(B9)          */
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,      /* Char(BA)          */
    0x00,0x00,0x00,0x00,0x00,0xFE,0x06,0xF6,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,      /* Char(BB)          */
    0x36,0x36,0x36,0x36,0x36,0xF6,0x06,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(BC)          */
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(BD)          */
    0x18,0x18,0x18,0x18,0x18,0xF8,0x18,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(BE)          */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,      /* Char(BF)          */
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(C0)          */
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(C1)          */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,      /* Char(C2)          */
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,      /* Char(C3)          */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(C4)          */
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,      /* Char(C5)          */
    0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,      /* Char(C6)          */
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x37,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,      /* Char(C7)          */
    0x36,0x36,0x36,0x36,0x36,0x37,0x30,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(C8)          */
    0x00,0x00,0x00,0x00,0x00,0x3F,0x30,0x37,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,      /* Char(C9)          */
    0x36,0x36,0x36,0x36,0x36,0xF7,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(CA)          */
    0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xF7,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,      /* Char(CB)          */
    0x36,0x36,0x36,0x36,0x36,0x37,0x30,0x37,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,      /* Char(CC)          */
    0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(CD)          */
    0x36,0x36,0x36,0x36,0x36,0xF7,0x00,0xF7,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,      /* Char(CE)          */
    0x18,0x18,0x18,0x18,0x18,0xFF,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(CF)          */
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(D0)          */
    0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,      /* Char(D1)          */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,      /* Char(D2)          */
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(D3)          */
    0x18,0x18,0x18,0x18,0x18,0x1F,0x18,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(D4)          */
    0x00,0x00,0x00,0x00,0x00,0x1F,0x18,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,      /* Char(D5)          */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,      /* Char(D6)          */
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0xFF,0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,      /* Char(D7)          */
    0x18,0x18,0x18,0x18,0x18,0xFF,0x18,0xFF,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,      /* Char(D8)          */
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(D9)          */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,      /* Char(DA)          */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,      /* Char(DB)          */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,      /* Char(DC)          */
    0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,      /* Char(DD)          */
    0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,      /* Char(DE)          */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(DF)          */
    0x00,0x00,0x00,0x00,0x00,0x76,0xDC,0xD8,0xD8,0xD8,0xDC,0x76,0x00,0x00,0x00,0x00,      /* Char(E0)          */
    0x00,0x00,0x78,0xCC,0xCC,0xCC,0xD8,0xCC,0xC6,0xC6,0xC6,0xCC,0x00,0x00,0x00,0x00,      /* Char(E1)          */
    0x00,0x00,0xFE,0xC6,0xC6,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0x00,0x00,0x00,0x00,      /* Char(E2)          */
    0x00,0x00,0x00,0x00,0xFE,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,      /* Char(E3)          */
    0x00,0x00,0x00,0xFE,0xC6,0x60,0x30,0x18,0x30,0x60,0xC6,0xFE,0x00,0x00,0x00,0x00,      /* Char(E4)          */
    0x00,0x00,0x00,0x00,0x00,0x7E,0xD8,0xD8,0xD8,0xD8,0xD8,0x70,0x00,0x00,0x00,0x00,      /* Char(E5)          */
    0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x7C,0x60,0x60,0xC0,0x00,0x00,0x00,      /* Char(E6)          */
    0x00,0x00,0x00,0x00,0x76,0xDC,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00,      /* Char(E7)          */
    0x00,0x00,0x00,0x7E,0x18,0x3C,0x66,0x66,0x66,0x3C,0x18,0x7E,0x00,0x00,0x00,0x00,      /* Char(E8)          */
    0x00,0x00,0x00,0x38,0x6C,0xC6,0xC6,0xFE,0xC6,0xC6,0x6C,0x38,0x00,0x00,0x00,0x00,      /* Char(E9)          */
    0x00,0x00,0x38,0x6C,0xC6,0xC6,0xC6,0x6C,0x6C,0x6C,0x6C,0xEE,0x00,0x00,0x00,0x00,      /* Char(EA)          */
    0x00,0x00,0x1E,0x30,0x18,0x0C,0x3E,0x66,0x66,0x66,0x66,0x3C,0x00,0x00,0x00,0x00,      /* Char(EB)          */
    0x00,0x00,0x00,0x00,0x00,0x7E,0xDB,0xDB,0xDB,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(EC)          */
    0x00,0x00,0x00,0x03,0x06,0x7E,0xDB,0xDB,0xF3,0x7E,0x60,0xC0,0x00,0x00,0x00,0x00,      /* Char(ED)          */
    0x00,0x00,0x1C,0x30,0x60,0x60,0x7C,0x60,0x60,0x60,0x30,0x1C,0x00,0x00,0x00,0x00,      /* Char(EE)          */
    0x00,0x00,0x00,0x7C,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,0x00,0x00,      /* Char(EF)          */
    0x00,0x00,0x00,0x00,0xFE,0x00,0x00,0xFE,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,      /* Char(F0)          */
    0x00,0x00,0x00,0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,      /* Char(F1)          */
    0x00,0x00,0x00,0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x00,0x7E,0x00,0x00,0x00,0x00,      /* Char(F2)          */
    0x00,0x00,0x00,0x0C,0x18,0x30,0x60,0x30,0x18,0x0C,0x00,0x7E,0x00,0x00,0x00,0x00,      /* Char(F3)          */
    0x00,0x00,0x0E,0x1B,0x1B,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,      /* Char(F4)          */
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xD8,0xD8,0xD8,0x70,0x00,0x00,0x00,0x00,      /* Char(F5)          */
    0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x7E,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,      /* Char(F6)          */
    0x00,0x00,0x00,0x00,0x00,0x76,0xDC,0x00,0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(F7)          */
    0x00,0x38,0x6C,0x6C,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(F8)          */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(F9)          */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(FA)          */
    0x00,0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0xEC,0x6C,0x6C,0x3C,0x1C,0x00,0x00,0x00,0x00,      /* Char(FB)          */
    0x00,0xD8,0x6C,0x6C,0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(FC)          */
    0x00,0x70,0xD8,0x30,0x60,0xC8,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(FD)          */
    0x00,0x00,0x00,0x00,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x00,0x00,0x00,0x00,0x00,      /* Char(FE)          */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,      /* Char(FF)          */
	};
