
#ifndef WPPower_Source
#define WPPower_Source

#include <wpabs.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);

#define OPEN_STATUS  131
#define OPEN_BATTERY 132

class WPPower : public WPAbstract {

     #pragma SOMMap (WPPower, "WPPower", "M_WPPower")

     #pragma SOMClassVersion (WPPower, 1, 2)

     #pragma SOMCallstyle (WPPower, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual ULONG wpAddPowerPage(HWND hwndNotebook);
     virtual ULONG wpAddPowerViewPage(HWND hwndNotebook);
     virtual BOOL wpChangePowerState(ULONG ulParm1, ULONG ulParm2);
     virtual BOOL wpQueryAutoRefresh();
     virtual ULONG wpQueryDefStatusView();
     virtual BOOL wpQueryPowerConfirmation();
     virtual BOOL wpQueryPowerManagement();
     virtual ULONG wpQueryRefreshRate();
     virtual void wpSetAutoRefresh(BOOL fAutoRefresh);
     virtual void wpSetDefStatusView(ULONG ulDefStatus);
     virtual void wpSetPowerConfirmation(BOOL fConfirm);
     virtual BOOL wpSetPowerManagement(BOOL fPower);
     virtual BOOL wpSetRefreshRate(ULONG ulRefreshRate);
     virtual HWND wpOpen(HWND hwndCnr, ULONG ulView, ULONG param);
     virtual ULONG wpFilterPopupMenu(ULONG ulFlags, HWND hwndCnr,
                                     BOOL fMultiSelect);
     virtual BOOL wpAddSettingsPages(HWND hwndNotebook);
     virtual BOOL wpModifyPopupMenu(HWND hwndMenu, HWND hwndCnr,
                                    ULONG iPosition);
     virtual BOOL wpMenuItemSelected(HWND hwndFrame, ULONG ulMenuId);
     virtual void wpInitData();
     virtual BOOL wpSaveState();
     virtual BOOL wpRestoreState(ULONG ulReserved);
     virtual BOOL wpMenuItemHelpSelected(ULONG MenuId);
     virtual ULONG wpAddObjectWindowPage(HWND hwndNotebook);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ( \
                              wpChangePowerState, \
                              wpSetPowerManagement, \
                              wpQueryPowerManagement, \
                              wpSetPowerConfirmation, \
                              wpQueryPowerConfirmation, \
                              wpAddPowerPage, \
                              wpAddPowerViewPage, \
                              wpSetAutoRefresh, \
                              wpQueryAutoRefresh, \
                              wpQueryRefreshRate, \
                              wpSetRefreshRate, \
                              *, \
                              *, \
                              wpQueryDefStatusView, \
                              wpSetDefStatusView)
};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* WPPower_Source */

#ifndef M_WPPower_Source
#define M_WPPower_Source

#include <wpabs.hh>
#include <somcls.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class M_WPPower : public M_WPAbstract {

     #pragma SOMClassVersion (M_WPPower, 1, 2)

     #pragma SOMCallstyle (M_WPPower, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual ULONG wpclsQueryDefaultView();
     virtual BOOL wpclsQueryDefaultHelp(PULONG pHelpPanelId,
                                        PSZ pszHelpLibrary);
     virtual ULONG wpclsQueryIconData(PICONINFO pIconInfo);
     virtual ULONG wpclsQueryStyle();
     virtual PSZ wpclsQueryTitle();
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ()

};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* M_WPPower_Source */

