
#ifndef WPDisk_Source
#define WPDisk_Source

#include <wpabs.hh>


#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);

#ifndef WPRootFolder_Source
class WPRootFolder;
#endif
#define OPEN_AUTO            120

class WPDisk : public WPAbstract {

     #pragma SOMMap (WPDisk, "WPDisk", "M_WPDisk")

     #pragma SOMClassVersion (WPDisk, 1, 2)

     #pragma SOMCallstyle (WPDisk, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual ULONG wpAddDiskDetailsPage(HWND hwndNotebook);
     virtual ULONG wpQueryDriveLockStatus(PULONG pulLockStatus,
                                          PULONG pulLockCount);
     virtual ULONG wpEjectDisk();
     virtual ULONG wpLockDrive(BOOL fLock);
     virtual ULONG wpQueryLogicalDrive();
     virtual WPRootFolder* wpQueryRootFolder();
     virtual BOOL wpSetup(PSZ pszSetupString);
     virtual BOOL wpSaveState();
     virtual BOOL wpRestoreState(ULONG ulReserved);
     virtual BOOL wpAddSettingsPages(HWND hwndNotebook);
     virtual ULONG wpFilterPopupMenu(ULONG ulFlags, HWND hwndCnr,
                                     BOOL fMultiSelect);
     virtual BOOL wpModifyPopupMenu(HWND hwndMenu, HWND hwndCnr,
                                    ULONG iPosition);
     virtual BOOL wpMenuItemHelpSelected(ULONG MenuId);
     virtual BOOL wpMenuItemSelected(HWND hwndFrame, ULONG ulMenuId);
     virtual BOOL wpSetTitle(PSZ pszNewTitle);
     virtual HWND wpOpen(HWND hwndCnr, ULONG ulView, ULONG param);
     virtual BOOL wpQueryDefaultHelp(PULONG pHelpPanelId, PSZ HelpLibrary);
     virtual MRESULT wpDragOver(HWND hwndCnr, PDRAGINFO pdrgInfo);
     virtual MRESULT wpDrop(HWND hwndCnr, PDRAGINFO pdrgInfo,
                            PDRAGITEM pdrgItem);
     virtual ULONG wpQueryIconData(PICONINFO pIconInfo);
     virtual BOOL wpSetIconData(PICONINFO pIconInfo);
     virtual HWND wpViewObject(HWND hwndCnr, ULONG ulView, ULONG param);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ( \
                              wpAddDiskDetailsPage, \
                              *, \
                              wpQueryLogicalDrive, \
                              *, \
                              wpQueryRootFolder, \
                              *, \
                              *, \
                              *, \
                              wpQueryDriveLockStatus, \
                              wpEjectDisk, \
                              wpLockDrive)
};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* WPDisk_Source */

#ifndef M_WPDisk_Source
#define M_WPDisk_Source

#include <wpabs.hh>
#include <somcls.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class M_WPDisk : public M_WPAbstract {

     #pragma SOMClassVersion (M_WPDisk, 1, 2)

     #pragma SOMCallstyle (M_WPDisk, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual BOOL wpclsQueryDefaultHelp(PULONG pHelpPanelId,
                                        PSZ pszHelpLibrary);
     virtual ULONG wpclsQueryIconData(PICONINFO pIconInfo);
     virtual ULONG wpclsQueryStyle();
     virtual PSZ wpclsQueryTitle();
     virtual ULONG wpclsQueryDefaultView();
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ()

};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* M_WPDisk_Source */

