/* RX.C (RX.EXE)
 *
 * This is a Presentation Manager program that launches a REXX script and allows it to open and use a PM window
 * with PM controls in order to obtain user input (as opposed to "pull"ing from a command line prompt). It takes 1 arg
 * from OS/2; the name of the REXX script to launch. It uses Rexx Dialog to implement the REXX/PM interface.
 */

#define INCL_WINSYS
#define INCL_WINWINDOWMGR

#include <os2.h>
#include "rx.h"



/* Functions for REXX commands */
VOID EXPENTRY Add2(VOID);
VOID EXPENTRY Subtract2(VOID);



/* Globals */
HMQ hmq;
PFUNC cmdFuncs[] = { Add2, Subtract2 };
UCHAR cmdArray[] = {3, 'A', 'D', 'D', 8, 'S', 'U', 'B', 'T', 'R', 'A', 'C', 'T', 0 };



/********************************** main() ********************************
 * 1. Initializes PM environment: obtains anchor block handle and creates msg queue
 *    that all of the Rexx Dialog windows use.
 * 2. Initializes REXXSPEC for adding 2 REXX commands: APPADD, APPSUBTRACT
 * 3. Calls RexxSet() routine (init RXDLG.DLL stuff)
 * 4. Executes REXX script
 * 5. Frees resources
 * 6. Ends program
 *
 * Return: 0 if successful execution, non-zero if error
 *************************************************************************/
int main(int argc, char *argv[], char *envp[])
{
    register ULONG id;

    /* Obtain and initialize PM Message Queue for this process */
    if(!(RexxSpec.Hab = WinInitialize(0)))
    {
badinit:
	DosBeep(60, 120);
	return(ERRAPP);
    }

    if(!(hmq = WinCreateMsgQueue(RexxSpec.Hab, 0)))
    {
	WinTerminate(RexxSpec.Hab);
	goto badinit;
    }

    /* Is there a REXX script name specified? */
    if (argc>1)
    {
	/* Setup this app's REXX commands */
	RexxSpec.Cmds = &cmdArray[0];
	RexxSpec.Handlers = &cmdFuncs[0];
	RexxSpec.Prefix = "APP";

	/* Install REXX support */
	if((id = RexxSet()))
	{
	    DlgErrMsg(id, id+ERRAPP);
	}
	else
	{
	    /* Execute REXX script (if it exists) */
	    RexxRunScript(argv[1]);

	    /* Uninstall REXX support */
	    RexxFree();
	}
    }
    /* Print usage */
    else
    {
	DlgMsgStr("Usage: RX3 [Rexx script filename]", 0, 0);
    }

    /* Free resources */
    WinDestroyMsgQueue(hmq);
    WinTerminate(RexxSpec.Hab);

    /* Return error code */
    return(RexxSpec.ErrNum);
}



VOID EXPENTRY Add2(VOID)
{
    LONG num1, num2;

    /* Get first number */
    num1 = DlgAsciiToNum(RexxSpec.FromStr, &RexxSpec.FromStr, 0);

    /* Get second number */
    num2 = DlgAsciiToNum(RexxSpec.FromStr, 0, 0);

    /* Add numbers and return it to the script */
    RexxSetNumVar("SUM", num1+num2);
}

VOID EXPENTRY Subtract2(VOID)
{
    LONG num1, num2;

    /* Get first number */
    num1 = DlgAsciiToNum(RexxSpec.FromStr, &RexxSpec.FromStr, 0);

    /* Get second number */
    num2 = DlgAsciiToNum(RexxSpec.FromStr, 0, 0);

    /* Check if num1 < num2.  If so, then return an error. We arbitrarily
       choose an error number of ERRAPP+DISPLAYLEVEL, and a display level
       of DISPLAYLEVEL (defined in RX.H) */
    if (num1 < num2)
    {
	DlgMsgStr("Second number smaller than first", ERRAPP+DISPLAYLEVEL, DISPLAYLEVEL);
	return;
    }

    /* Subtract numbers and return it to the script in the variable "ANSWER.0" */
    RexxSetNumVar("ANSWER.0", num1-num2);
}
