/********************************************************************/

/*                                                                  */

/* (C) Copyright IBM UK Ltd. 1996                                   */

/*                                                                  */

/* QEIP - Example of DosQueryModFromEIP usage.                      */

/*                                                                  */

/* Query a module handle and name from a give flat address.         */

/* Note: does not have to be a code address.                        */

/*                                                                  */

/* Richard Moore 18th December 98                                   */

/* Version 1.0                                                      */

/*                                                                  */

/* Syntax QEIP <address>                                            */

/* example: QEIP 0x10000                                            */

/* example: QEIP 0x1bfb0000                                         */

/* example: QEIP 0xfffb0000                                         */

/*                                                                  */

/*                                                                  */

/********************************************************************/





#define INCL_DOSMODULEMGR



#include <os2.h>

#include <conio.h>

#include <stdio.h>

#include <string.h>

#include <stdlib.h>



/*************************************************************************************/

/*                                                                                   */

/* Purpose:                                                                          */

/*                                                                                   */

/* DosQueryModFromEIP takes a flat 32-bit address as a parameter, and returns        */

/* information about the module owning that storage (module refers to                */

/* a protect mode application currently executing).                                  */

/*                                                                                   */

/*************************************************************************************/



/*************************************************************************************/

/*                                                                                   */

/*                       Prototype definition for DosQueryModFromEIP                 */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/* APIRET APIENTRY DosQueryModFromEIP( HMODULE *phMod,                               */

/*                                     ULONG *pObjNum,                               */

/*                                     ULONG BuffLen,                                */

/*                                     PCHAR pBuff,                                  */

/*                                     ULONG *pOffset,                               */

/*                                     ULONG Address );                              */

/*                                                                                   */

/*************************************************************************************/



/*************************************************************************************/

/*                                                                                   */

/*                       Parameter definitions for DosQueryModFromEIP                */

/*                                                                                   */

/*************************************************************************************/



/* phMod is the address of a location in which the module handle is returned.        */



/* pObjNum is the address of a ULONG where the module object number corresponding to */

/* the Address is returned. The object is zero based.                                */



/* BuffLen is the length of the user supplied buffer pointed to by pBuff.            */



/* pBuf is the address of a user supplied buffer in which the module name is returned*/



/* pOffset is the address of a ULONG where the offset to the object corresponding to */

/* the Address is returned. The offset is zero based.                                */



/* Address is the input address to be queried.                                       */





/*************************************************************************************/

/*                                                                                   */

/* DosQueryModuleFromEIP returns the following:                                      */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/*  0      NO_ERROR                                                                  */

/*  87     ERROR_INVALID_PARAMETER                                                   */

/*  487    ERROR_INVALID_ADDRESS                                                     */

/*                                                                                   */

/*************************************************************************************/





int main(int argc, char *argv[], char *envp[])

{

   HMODULE hMod;

   ULONG ObjNum;

   ULONG Offset;

   ULONG eip;

   APIRET rc;

   char Buff[256];   



   

   if (argc !=2) {

      printf("QEIP <Address>\n");

      return 0;

   } /* endif */



   eip = strtoul(argv[1],NULL,0);



   rc=DosQueryModFromEIP( &hMod,

                          &ObjNum,

                          sizeof(Buff),

                          Buff,

                          &Offset,

                          eip);

   if (rc!=0) {

      printf("DosQueryModFromEIP returned rc=%u\n",rc);

      return rc;

   } /* endif */



   printf("\nLinear Address: 0x%08x\n",eip);

   printf("%s\n",Buff);

   printf("handle: 0x%04x\n",hMod);

   printf("Object: 0x%08x\n",ObjNum);

   printf("Offset: 0x%08x\n",Offset);



   return 0;

}



