/*-----------------------------------------------------*/
/*  Panel3 Options Java Program                        */
/*-----------------------------------------------------*/

import java.awt.*;
import java.applet.*;
import java.util.*;


/*--------------------------------------------------------------*/
/* The class is an extension of Frame                           */
/*  It provides options display/selection for panel3            */
/*  Several sets of options are handled using a cardlayout      */
/*   panel                                                      */
/*--------------------------------------------------------------*/
public class P3opt extends Frame {
  private Panel3 parentApp;
  private String myTitle;
  private Panel3 qParent;

  private Panel mainPanel = new Panel();
  private Panel fontPanel = new Panel();
  private Panel colorPanel = new Panel();
  private CardLayout cl = new CardLayout();

  private Panel bPanel = new Panel();
  private Button bApply = new Button("Apply");
  private Button bDone = new Button("Done");
  private Button bRefresh = new Button("Refresh");
  private MenuBar mb = new MenuBar();
  private Menu  mPage  = new Menu("View...");
  private CheckboxMenuItem  mFont = new CheckboxMenuItem("Font");
  private CheckboxMenuItem  mColor   = new CheckboxMenuItem("Color");

  Checkbox cbPlain = new Checkbox("Plain");
  Checkbox cbBold = new Checkbox("Bold");
  Checkbox cbItalic= new Checkbox("Italicized");
  CheckboxGroup cbgStyle = new CheckboxGroup();

  Label lFont = new Label("Font: ", Label.RIGHT);
  Choice cSize = new Choice();
  Choice cFont = new Choice();

  Label lRed = new Label("Red ", Label.RIGHT);
  Label lGreen = new Label("Green", Label.RIGHT);
  Label lBlue = new Label("Blue", Label.RIGHT);
  Label lRedval = new Label("0", Label.CENTER);
  Label lGreenval = new Label("0", Label.CENTER);
  Label lBlueval = new Label("0", Label.CENTER);
  Scrollbar sbRed = new Scrollbar(Scrollbar.HORIZONTAL, 0, 64, 0, 255);
  Scrollbar sbGreen = new Scrollbar(Scrollbar.HORIZONTAL, 0, 64, 0, 255);
  Scrollbar sbBlue = new Scrollbar(Scrollbar.HORIZONTAL, 0, 64, 0, 255);
  TextField tfTest = new TextField("", 16);

  int iFontsize;

  int iSizes[] = {8, 10, 12, 14, 16, 18, 20, 22, 24};
  String sFonts[] = {"Courier", "Helv", "TimesNewRoman"};


  int     ix=0, iy=0;

/*---------------------------------------------------------------*/
/* Constructor for option frame                                  */
/*  args are: frame title, parent applet, parent panel object    */
/*---------------------------------------------------------------*/

  public P3opt(String sTitle, Panel3 app) {

    super(sTitle);

    parentApp = app;
    myTitle = sTitle;

// Construct menubar, menus and menuitems
    mPage.add(mFont);
    mPage.add(mColor);
    mb.add(mPage);
    setMenuBar(mb);
    mFont.setState(true);

//  Identify card layout for central options panel(s)
    mainPanel.setLayout(cl);        //use card layout for master panel

// Create center panel with option info (font options)

    GridBagConstraints gbc = new GridBagConstraints();
    GridBagLayout gbl = new GridBagLayout();
    gbc.anchor = GridBagConstraints.WEST;

    fontPanel.setLayout(gbl);

// Add the fontsize choicelist and its label to the panel
// Add the fontsizes from the static array to the choice and
//  set the default size to the fourth entry

    gbc.gridx=0; gbc.gridy=0;
    gbc.gridwidth=1;
    addElement(fontPanel, lFont, gbl, gbc);

    gbc.gridx=GridBagConstraints.RELATIVE;
    addElement(fontPanel, cFont, gbl, gbc);
    for (int i=0; i<sFonts.length; i++ ) {
       cFont.addItem(sFonts[i]);
    }
    cFont.select(0);

    gbc.gridx = 1; gbc.gridy = 1;
    addElement(fontPanel, cSize, gbl, gbc);
    for (int i=0;i<iSizes.length ;i++ ) {
       cSize.addItem( (new Integer(iSizes[i])).toString() );
    }
    cSize.select(3);


    mainPanel.add("font", fontPanel);

// Create center panel with option info (color options)

    GridBagConstraints gbc2 = new GridBagConstraints();
    GridBagLayout gbl2 = new GridBagLayout();
    gbc2.anchor = GridBagConstraints.WEST;

    colorPanel.setLayout(gbl2);

// Add the fontstyle buttons to the panel and then define them
//  as a group.  Set the initial style to BOLD

    gbc2.gridx=0; gbc2.gridy=0;
    gbc2.gridwidth=1;

    addElement(colorPanel, cbPlain, gbl2, gbc2);
    gbc2.gridx = GridBagConstraints.RELATIVE;
    addElement(colorPanel, cbItalic, gbl2, gbc2);
    addElement(colorPanel, cbBold, gbl2, gbc2);
    cbPlain.setCheckboxGroup(cbgStyle);
    cbBold.setCheckboxGroup(cbgStyle);
    cbItalic.setCheckboxGroup(cbgStyle);
    cbgStyle.setCurrent(cbBold);

// Add color vector scrollbars

    gbc2.gridx=0; gbc2.gridy=1;
    
    lRed.setForeground(Color.red);
    addElement(colorPanel, lRed, gbl2, gbc2);
    gbc2.gridx = GridBagConstraints.RELATIVE;
    gbc2.gridwidth = 2;
    addElement(colorPanel, sbRed, gbl2, gbc2);
    gbc2.gridwidth = 1;
    addElement(colorPanel, lRedval, gbl2, gbc2);

    gbc2.gridx=0; gbc2.gridy=2;
    lGreen.setForeground(Color.green);
    addElement(colorPanel, lGreen, gbl2, gbc2);
    gbc2.gridx = GridBagConstraints.RELATIVE;
    gbc2.gridwidth = 2;
    addElement(colorPanel, sbGreen, gbl2, gbc2);
    gbc2.gridwidth = 1;
    addElement(colorPanel, lGreenval, gbl2, gbc2);

    gbc2.gridx=0; gbc2.gridy=3;
    lBlue.setForeground(Color.blue);
    addElement(colorPanel, lBlue, gbl2, gbc2);
    gbc2.gridx = GridBagConstraints.RELATIVE;
    gbc2.gridwidth = 2;
    addElement(colorPanel, sbBlue, gbl2, gbc2);
    gbc2.gridwidth = 1;
    addElement(colorPanel, lBlueval, gbl2, gbc2);
    gbc2.gridx = 1; gbc2.gridy = 4;
    gbc2.gridwidth = 2;
    addElement(colorPanel, tfTest, gbl2, gbc2);

    
    mainPanel.add("color", colorPanel);

// add the entire cardlayout panel onto the frame

    add("Center", mainPanel);

// Create button panel
    bPanel.setLayout(new FlowLayout());
    bPanel.add(bApply);
    bPanel.add(bDone);
    bPanel.add(bRefresh);
    add("South", bPanel);

// Show and then resize the frame
    show();
    resize(300,250);

  }

/*--------------------------------------------------------------*/
/* ACTION method override                                       */
/*    process menu item and button selections                   */
/*--------------------------------------------------------------*/

    public boolean action(Event e, Object o) {

      if (e.target == bApply) {
          parentApp.colorText = tfTest.getBackground();

          Checkbox cbTemp = cbgStyle.getCurrent();
          if (cbTemp == cbBold) {
             parentApp.iStyle = Font.BOLD;
          } else {
              if (cbTemp == cbItalic) {
                  parentApp.iStyle = Font.ITALIC;
              } else {
                parentApp.iStyle = Font.PLAIN;
                } 
          } 

          parentApp.iSize = iSizes[cSize.getSelectedIndex()];
          parentApp.pFont = cFont.getSelectedItem();
          parentApp.repaint();
          return true;
      }

      if (e.target == bDone) {
          hide();
          return true;
      }

      if (e.target == bRefresh) {
          return true;
      }

      if (e.target == mFont) {
         mFont.setState(true);
         mColor.setState(false);
         cl.show(mainPanel, "font");
         return true;
      }

      if (e.target == mColor) {
         mFont.setState(false);
         mColor.setState(true);
         cl.show(mainPanel, "color");
         return true;
      }

      return false;
    }


/*------------------------------------------------------*/
/* Add Element method                                   */
/*------------------------------------------------------*/
  public void addElement(Panel p,
                         Component o,
                         GridBagLayout g,
                         GridBagConstraints c) {
    g.setConstraints(o, c);
    p.add(o);
  }

/*--------------------------------------------------------*/
/* handleEvent method                                     */
/*  invoked when an event action occurs. It processes     */
/*  events from the scollbar controls.                    */
/*--------------------------------------------------------*/

  public boolean handleEvent(Event e) {
    int sbVal;

    if (e.target == sbRed) {
       sbVal = sbRed.getValue();
       lRedval.setText( (new Integer(sbVal)).toString() );
       Color c = tfTest.getBackground();
       tfTest.setBackground(new Color(sbVal, c.getGreen(), c.getBlue()));
    }

    if (e.target == sbGreen) {
       sbVal = sbGreen.getValue();
       lGreenval.setText( (new Integer(sbVal)).toString() );
       Color c = tfTest.getBackground();
       tfTest.setBackground(new Color(c.getRed(), sbVal, c.getBlue()));
    }

    if (e.target == sbBlue) {
       sbVal = sbBlue.getValue();
       lBlueval.setText( (new Integer(sbVal)).toString() );
       Color c = tfTest.getBackground();
       tfTest.setBackground(new Color(c.getRed(), c.getGreen(), sbVal));
    }

     
    return super.handleEvent(e);
  }

}
