/*----------------------------------------------------------*/
/* GUI version of profile display                           */
/*   demonstrates use of native methods myLib.dll           */
/*----------------------------------------------------------*/

import java.applet.*;
import java.awt.*;
import java.util.*;

public class ProfGui extends Applet {

  NativeClass1 nw1;

  private List liApps = new List(10, false);
  private List liKeys = new List(10, false);
  private TextField tfProf = new TextField(20);
  private Button bLoad = new Button("Load Profile");
  private TextArea taValue = new TextArea(3, 40);

  private String curProfile;
  private String curApp;
  private String curKey;


/*-----------------------------------------------*/
/* init method                                   */
/*-----------------------------------------------*/

  public void init() {

    setLayout(new BorderLayout() );

    Panel nPanel = new Panel();
    nPanel.setLayout(new FlowLayout());
    nPanel.add(new Label("Profile to process"));
    nPanel.add(tfProf);
    nPanel.add(bLoad);
    add("North", nPanel);

    Panel cPanel = new Panel();
    cPanel.setLayout(new GridLayout(1,2));
    cPanel.add(liApps);
    cPanel.add(liKeys);
    add("Center", cPanel);

    add("South", taValue);   

    show();

  }

/*-----------------------------------------------*/
/* action method                                 */
/*  processes button clicks                      */
/*-----------------------------------------------*/

  public boolean action(Event e, Object o) {

    if (e.target == bLoad) {
       loadProfile(tfProf.getText(), liApps);
       return true;
    }

    return false;
  } // end of action method override

/*-----------------------------------------------*/
/* HandleEvent method override                   */
/*  processes list selects                       */
/*-----------------------------------------------*/

  public boolean handleEvent(Event e) {

    if (e.id == Event.LIST_SELECT) {
       if ( (List) e.target == liApps ) {
          loadKeys(liApps.getSelectedItem(), liKeys);
          return true;
       }
       if ( (List) e.target == liKeys ) {
          loadValue(liKeys.getSelectedItem(), taValue);
          return true;
       }
    }

    return super.handleEvent(e);
  } // end of handleEvent override

/*-----------------------------------------------*/
/* loadValue   method                            */
/*-----------------------------------------------*/

  private void loadValue(String sKey, TextArea taTarget) {

    taTarget.setText(nw1.getKeyString(curApp, sKey));
  }

/*-----------------------------------------------*/
/* loadKeys    method                            */
/*-----------------------------------------------*/

  private void loadKeys(String sApp, List liTarget) {
    int iLoop;
    String sNext;

    curApp = sApp;
    liTarget.clear();

    nw1.getKeys(sApp);
    
    for (iLoop=0;iLoop<100 ;iLoop++ ) {
        sNext = nw1.nextKey();
        if (sNext.equals("eof"))
           iLoop=900;
        else
           liTarget.addItem(sNext);
    } /* endfor */

  } // end of loadKeys method

/*-----------------------------------------------*/
/* loadProfile method                            */
/*-----------------------------------------------*/

  private void loadProfile(String sProfile, List liTarget) {
    int iLoop;
    String sNext;

    curProfile = sProfile;
    liTarget.clear();
    liKeys.clear();

    nw1 = new NativeClass1(sProfile);   //construct the profile class object
    nw1.getApps();
    
    for (iLoop=0;iLoop<100 ;iLoop++ ) {
        sNext = nw1.nextApp();
        if (sNext.equals("eof"))
           iLoop=900;
        else
           liTarget.addItem(sNext);
    } /* endfor */

  } // end of loadProfile method


} // end of class def 



