/*-----------------------------------------------------*/
/* sample native class for OS/2                        */
/*   this class contains wrapper methods for           */
/*   invoking native OS/2 profile functions            */
/*     plus several simple demo methods for            */
/*     demonstrating return types                      */
/*-----------------------------------------------------*/
/* the source code for the native functions is in:     */
/*     myLib.c                                         */
/*-----------------------------------------------------*/

import java.util.*;
public class NativeClass1 {

//   class variables, the static function causes the dll
//      for the native methods to be loaded
   String x;
   String curProf;
   String curApp;
   String curKey;
   int    whichProf;   // 1=system, 2=user
   boolean bOk;
   static { System.loadLibrary("myLib"); }

//   list of entry points in native method dll

   public native boolean profOpen(int prof);
   public native int     profApps();
   public native int     profKeys(String sApp);
   public native String  seqApp();
   public native String  seqKey();
   public native String  qString(String sApp, String sKey);
   public native int     qInt(String sApp, String sKey);
   public native String  c2(String xx);

//  constructor, the input variable is the name of the
//  profile to be processed: values are:
//     "system" ==>    OS/2 system profile
//     "user" =>    OS/2 user profile
 
   public NativeClass1(String sProfname) {
      curProf = sProfname;
      if (sProfname.equals("system")) {
        whichProf = 1;
        bOk = profOpen(whichProf);
      }
      else
         if (sProfname.equals("user")) {
            whichProf = 2;
            bOk = profOpen(whichProf);
         }
         else {
            whichProf = 0;
         }
    }

// Methods - each is a simple wrap for the dll functions

   public String addString(String xx) {
      return c2(xx);
   }

   public int getApps() {
      if (bOk) 
         return profApps();
      else
         return 0;
      }

   public String nextApp() {
      if (bOk)
         return curApp = seqApp();
      else
         return "eof";
   }

   public String nextKey() {
      if (bOk)
         return curKey = seqKey();
      else
         return "eof";
   }

   public int getKeys(String sApp) {
      if (bOk) {
         curApp = sApp;
         return profKeys(sApp);
      }
      else
         return 0;
      }

   public String getKeyString(String sApp, String sKey) {
      if (bOk) 
         return qString(sApp, sKey);
      else
         return null;
   }

   public String getKeyString(String sKey) {
      if (bOk) 
         return qString(curApp, sKey);
      else
         return null;
   }

   public String getKeyString() {
      if (bOk) 
         return qString(curApp, curKey);
      else
         return null;
   }

   public int getKeyInt(String sKey) {
      if (bOk)
         return qInt(curApp, sKey);
      else
         return 0;
   }

}
