#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <os2.h>
#include <unidef.h>
#include <uconv.h>

#define US_CPNAME_MAX   12
#define US_CPSPEC_MAX ( US_CPNAME_MAX + 50 )

/*****************************************************************************
 * Converts the string passed on the command line to a format acceptable to  *
 * HTML, with all non-ASCII characters represented using Unicode tag syntax. *
 *****************************************************************************/
int main( int argc, char *argv[] )
{
    UconvObject uconvCP = NULL;         // ULS conversion object
    UniChar     *psuOutput,             // UCS-2 output string
                *psuOffset,             // pointer to last converted UniChar
                psuCP[ US_CPSPEC_MAX ], // codepage specification string
                uc;                     // the current UniChar (for parsing)
    PSZ         pszInput;               // the multi-byte input string
    int         ulCP = 0,               // requested codepage number
                ulRC,                   // API return code
                i;                      // counter
    size_t      stInLen,                // size of the input buffer
                stOutLen,               // size of the output buffer
                stSubstitutions = 0;    // number of substitutions made


    if ( argc < 2 ) {
        printf("Syntax: %s <string> [ /<codepage> ]\n", argv[0] );
        return 0;
    }
    if ( argc > 2 ) {
        if ( argv[2][0] == '/') sscanf( argv[2], "/%u", &ulCP );
    }

    // Create a conversion object for the requested codepage
    memset( psuCP, 0, US_CPSPEC_MAX );
    if ( ulCP != 0 ) {
        ulRC = UniMapCpToUcsCp( ulCP, psuCP, US_CPNAME_MAX );
        if ( ulRC != ULS_SUCCESS ) {
            printf("UniMapCpToUcsCp error: 0x%X\n", ulRC );
            return ulRC;
        }
    }
    UniStrcat( psuCP, (UniChar *) L"@map=display");
    ulRC = UniCreateUconvObject( psuCP, &uconvCP );
    if ( ulRC != ULS_SUCCESS ) {
        printf("UniCreateUconvObject error: 0x%X\n", ulRC );
        return ulRC;
    }

    pszInput = argv[ 1 ];
    printf("INPUT:\n");
    printf("%s\n\n", pszInput );

    // create the output buffer
    stInLen   = strlen( pszInput ) + 1;
    stOutLen  = stInLen;
    psuOutput = (UniChar *) calloc( stOutLen, sizeof(UniChar) );

    // Now convert the input string to UCS-2 using UniUconvToUcs()
    psuOffset = psuOutput;
    ulRC = UniUconvToUcs( uconvCP, (PVOID *) &pszInput, &stInLen,
                          &psuOffset, &stOutLen, &stSubstitutions );
    if ( ulRC != ULS_SUCCESS ) {
        printf("UniUconvToUcs error: 0x%X\n", ulRC );
        printf("(%d characters not converted)\n\n", stInLen );
    }
    stOutLen = UniStrlen( psuOutput );

    // Print the results
    printf("OUTPUT:\n");
    for ( i = 0; i < stOutLen; i++ ) {
        uc = psuOutput[ i ];
        // Displayable ASCII characters can be printed verbatim
        if (( uc >= 0x20 ) && ( uc <= 0x7E )) printf("%lc", uc );
        // Print all others as HTML unicode values
        else printf("&#x%04x;", uc );
    }
    printf("\n");

    // Free the allocated memory and return
    UniFreeUconvObject( uconvCP );
    free( psuOutput );
    return 0;
}

