/* version.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <emx/syscalls.h>

int main (int argc, char *argv[]);
static void bit (char *s, int n);


static void bit (char *s, int n)
{
  printf ("%s  %s\n", s, ((_emx_env & n) ? "YES" : "NO"));
}


int main (int argc, char *argv[])
{
  int sz[2], i;
  int mem_flag = 0;
  int scr_flag = 0;
  int exe_flag = 0;

  for (i = 1; i < argc; ++i)
    if (strcmp (argv[i], "-e") == 0)
      exe_flag = 1;
    else if (strcmp (argv[i], "-m") == 0)
      mem_flag = 1;
    else if (strcmp (argv[i], "-s") == 0)
      scr_flag = 1;
  printf ("emx version %s (0x%x)\n", _emx_vprt, _emx_vcmp);
  if (_emx_rev != 0)
    printf ("emx revision %u\n", _emx_rev);
  bit ("VCPI     ", 0x0001);
  bit ("XMS      ", 0x0002);
  bit ("VDISK 3.3", 0x0004);
  bit ("DESQview ", 0x0008);
  bit ("287      ", 0x0010);
  bit ("387      ", 0x0020);
  bit ("OS/2 2.x ", 0x0200);
  bit ("-t       ", 0x0400);
  bit ("-ac      ", 0x0800);
  bit ("RSX      ", 0x1000);
  printf ("Operating system: %s %d.%d\n",
          (_osmode == DOS_MODE ? "MS-DOS"
           : (_osmode == OS2_MODE ? "OS/2" : "unknown")),
          _osmajor, _osminor);
  if (mem_flag)
    printf ("Available memory: %d KByte\n", __memavail () * 4);
  if (scr_flag)
    {
      _scrsize (sz);
      printf ("Screen size:      %d x %d\n", sz[0], sz[1]);
    }
  if (exe_flag)
    {
      char buf[256];
      if (_execname (buf, sizeof (buf)) == 0)
        printf ("Executable file:  %s\n", buf);
    }
  return 0;
}
