/* opendir.c (emx+gcc) */

#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>

int main (int argc, char *argv[])
{
  DIR *d;
  struct dirent *e;

  if (argc != 2)
    {
      puts ("Usage: opendir <directory>");
      return 1;
    }

  d = opendir (argv[1]);
  if (d == NULL)
    {
      perror (argv[1]);
      return 2;
    }
  while ((e = readdir (d)) != NULL)
    printf ("%s\n", e->d_name);
  closedir (d);
  return 0;
}
