/* math1.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>
#include <signal.h>

void fpe_handler (int signo)
{
  printf ("This program requires a coprocessor.\n");
  exit (1);
}


int main (void)
{
  double x, y;
  volatile long n;
  volatile unsigned long un;
  int i;

  signal (SIGFPE, fpe_handler);
#if defined (MSDOS)
  _control87 (EM_OVERFLOW|EM_UNDERFLOW|EM_INEXACT, MCW_EM);
#endif
  while (scanf ("%lf", &x) == 1)
    {
      printf ("x=%g, floor(x)=%g, ceil(x)=%g\n",
                    x, floor (x), ceil (x));
      printf ("rint(x)=%g, trunc(x)=%g\n", rint (x), trunc (x));
      printf ("fabs(x)=%g, sqrt(x)=%g\n", fabs (x), sqrt (x));
      printf ("exp(x)=%g, log(x)=%g, log10(x)=%g\n", exp (x), log (x), log10 (x));
      printf ("sinh(x)=%g, cosh(x)=%g, tanh(x)=%g\n", sinh (x), cosh (x), tanh (x));
      printf ("sin(x)=%g, cos(x)=%g, tan(x)=%g\n", sin (x), cos (x), tan (x));
      printf ("atan(x)=%g, asin(x)=%g, acos(x)=%g\n", atan (x), asin (x), acos (x));
      printf ("atan2(x,1)=%g\n", atan2 (x, 1));
      printf ("ldexp(x,0)=%g, ldexp(x,-2)=%g, ldexp(x,3)=%g\n", ldexp (x, 0), ldexp (x, -2), ldexp (x, 3));
      printf ("pow(x,1.8)=%g pow(1.8,x)=%g\n", pow (x, 1.8), pow (1.8, x));
      printf ("pow(x,3.8)=%g pow(3.8,x)=%g\n", pow (x, 3.8), pow (3.8, x));
      printf ("pow(-2.0,x)=%g\n", pow (-2.0, x));
      printf ("fmod(-200000,x)=%g fmod(x,-3)=%g\n", fmod (-200000.0, x), fmod (x, -3.0));
      printf ("cbrt(x)=%g, hypot(x,4)=%g\n", cbrt (x), hypot (x, 4.0));
      y = frexp (x, &i);
      printf ("frexp: x=%g*2^%d\n", y, i);
      n = (long)x; un = (unsigned long)x;
      printf ("(long)x         =%ld -> %g\n", n, (double)n);
      printf ("(unsigned long)x=%lu -> %g\n", un, (double)un);
    }
  return 0;
}
