/* wmdelcha.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <string.h>
#include <sys/winmgr.h>
#include "winmgr2.h"

void wm_del_char (wm_handle wh, int x, int y, int count)
{
  char *mem;
  int idx, px, py, len;

  if (wh->used != WM_USED || count <= 0)
    return;
  if (x + count >= wh->width)
    count = wh->width - x;
  len = wh->width - x - count;
  px = x + wh->ax;
  py = y + wh->ay;
  idx = px + py * wh->bwidth;
  mem = &wh->data[2*idx];
  memmove (mem, mem + 2 * count, (size_t)(2 * len));
  while (count > 0 && x+len < wh->width)
    {
      mem[2*len+0] = ' ';
      mem[2*len+1] = (char)wh->wattr;
      --count; ++len;
    }
  if (wh->display)
    {
      px = x+wh->x0;
      py = y+wh->y0;
      if (wh->visible)
        _wm_move2 (mem, py, px, wh->bx1, 1);
      else
        _wm_line2 (&wh->mask[idx], mem, py, px, wh->bx1);
    }
  else
    wh->update_req = TRUE;
  _wm_cursor1 ();
}
