/* settimeo.c (emx+gcc) -- Copyright (c) 1995-1996 by Eberhard Mattes */

#include <time.h>
#include <sys/time.h>
#include <errno.h>
#include <emx/time.h>
#include <emx/syscalls.h>

int _settimeofday (const struct timeval *tp, const struct timezone *tzp)
{
  struct timeval local;
  time_t t;

  if (tzp != NULL)
    {
      errno = EINVAL;
      return -1;
    }
  if (!_tzset_flag) _tzset ();
  t = tp->tv_sec;
  local.tv_sec = _gmt2loc (&t);
  local.tv_usec = tp->tv_usec;
  return __settime (tp);
}
