/* inetaddr.c (emx+gcc) -- Copyright (c) 1994-1995 by Eberhard Mattes */

#include <stdlib.h>
#include <ctype.h>
#include <sys/types.h>
#include <netinet/in.h>

unsigned long inet_addr (const char *s)
{
  unsigned long numbers[4];
  unsigned long r;
  int i;
  char *e;
  long n;

  if (!isdigit ((unsigned char)*s))
    return INADDR_NONE;
  for (i = 0; i < 4; ++i)
    {
      n = strtol (s, &e, 0);
      if (e == s)
        return INADDR_NONE;
      s = e;
      numbers[i] = n;
      if (*s != '.')
        break;
      ++s;
      if (!isdigit ((unsigned char)*s))
        return INADDR_NONE;
    }
  if (*s != 0 && !isspace ((unsigned char)*s))
    return INADDR_NONE;

  switch (i)
    {
    case 0:
      r = numbers[0];
      break;
    case 1:
      r = (numbers[0] << 24) | (numbers[1] & 0xffffff);
      break;
    case 2:
      r = ((numbers[0] << 24) | ((numbers[1] & 0xff) << 16)
           | (numbers[2] & 0xffff));
      break;
    default:
      r = ((numbers[0] << 24) | ((numbers[1] & 0xff) << 16)
           | ((numbers[2] & 0xff) << 8) | (numbers[3] & 0xff));
      break;
    }
  return htonl (r);
}
