/* fncmp.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include <stdlib.h>
#include <sys/nls.h>

int _fncmp (const unsigned char *string1, const unsigned char *string2)
{
  int d;
  unsigned char c1, c2;

  for (;;)
    {
      c1 = *string1;
      if (!_nls_is_dbcs_lead (c1))
        c1 = _nls_toupper_tab[c1];
      c2 = *string2;
      if (!_nls_is_dbcs_lead (c2))
        c2 = _nls_toupper_tab[c2];
      d = (int)c1 - (int)c2;
      if (d != 0 || *string1 == 0 || *string2 == 0)
        return d;
      ++string1; ++string2;
    }
}
