/* malloc1.h (emx+gcc) */

#define END_OF_HEAP 0xfffffffe      /* MF_FREE not set! */
#define ALIGNMENT       4
#define MAX_SIZE        0x40000000

#define MF_FLAGS        0x03
#define MF_FREE         0x01
#define MF_RESERVED     0x02

#define FALSE           0
#define TRUE            1

typedef unsigned long maddr_t;  /* A pointer as unsigned integer */
typedef unsigned long msize_t;  /* The size of a block */

typedef struct
{
  /* Bit 0 (MF_FREE) clear means the block is in use,
     Bit 1 (MF_RESERVED) is reserved (always zero) */
  msize_t size;
} mheader_t;

extern mheader_t *_malloc_rover;
extern mheader_t *_malloc_bottom;
extern mheader_t *_malloc_top;

#define MHEADER_SIZE    (sizeof (mheader_t))
#define ADDR(p)         ((maddr_t)(p))
#define MHEADER(p)      ((mheader_t *)(p))
#define FREE(mem)       ((MHEADER (mem))[-1].size |= MF_FREE)
#define SIZE(x)         ((x) & ~MF_FLAGS)
#define FLAGS(x)        ((x) & MF_FLAGS)
#define ROUNDUP(x)      (((x) + (ALIGNMENT-1)) & ~(ALIGNMENT-1))

int _emx_malloc_init (void);
void _emx_malloc_magic (void);
void *_expand2 (void *mem, size_t size, int expand_heap, int tile);
void *_malloc2 (size_t size, int expand_heap, int tile);
void *_realloc2 (void *mem, size_t size, int tile);

#if defined (__MT__)

void _heap_lock (void);
void _heap_unlock (void);

#define HEAP_LOCK   _heap_lock()
#define HEAP_UNLOCK _heap_unlock()

#else

#define HEAP_LOCK
#define HEAP_UNLOCK

#endif /* defined (__MT__) */
