/* _fbuf.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include <stdio.h>
#include <stdlib.h>
#include <emx/io.h>

/* Assign a buffer to a stream (which must not have a buffer) */

void _fbuf (FILE *stream)
{
  if (stream->_flags & _IONBF)
    stream->_buffer = NULL;
  else
    stream->_buffer = malloc (BUFSIZ);
  if (stream->_buffer == NULL)
    {
      stream->_buf_size = 1;
      stream->_buffer = &stream->_char_buf;
      stream->_flags &= ~(_IOFBF|_IOLBF|_IOBUFMASK);
      stream->_flags |= _IONBF|_IOBUFCHAR;
    }
  else
    {
      stream->_buf_size = BUFSIZ;
      stream->_flags &= ~_IOBUFMASK;
      stream->_flags |= _IOBUFLIB;
    }
  stream->_ptr = stream->_buffer;
  stream->_rcount = 0;
  stream->_wcount = 0;
  stream->_ungetc_count = 0;
}
