/* -------------------------------------------------------------------

	Project:

	Objective-C interface file for the class namedpipe

	COPYRIGHT (C), 1995, Thomas Baier
	ALL RIGHTS RESERVED.

	Date:				Rev:
	1995-Aug-16			___

 */

/*====================================================================
                     Interface of class namedpipe                     
====================================================================*/
#ifndef _NAMEDPIPE_H_
#define _NAMEDPIPE_H_

#include <objc/os2.h>
#include <objc/Object.h>

@interface NamedPipe : Object
{
  HPIPE          handle;
  char          *pipeName;
  unsigned long  openMode;
  unsigned long  pipeMode;
  unsigned long  bufferSize;
}

/* -------------------------- Initialize -------------------------- */
-init;
-create;
-open;

/* ----------------------------- Free ----------------------------- */
-free;

/* ----------- Methods for access to Instance Variables ----------- */
-setPipeName: (const char *) aName;
-(const char *) pipeName;
-setOpenMode: (unsigned long) aMode;
-setPipeMode: (unsigned long) aMode;
-setBufferSize: (unsigned long) aSize;

/* ------------------------ Public methods ------------------------ */
-writeBlock: (void *) block size: (unsigned long) aSize;
-writeString: (char *) aString;
-readBlock: (void *) block size: (unsigned long) aSize;
/* ----------------------- Private methods ------------------------ */

/* ---------------------- Archiving methods ----------------------- */

@end

#endif
