#ifndef _INTERFACEFILE_H_
#define _INTERFACEFILE_H_

#include <util/KeyedList.h>
#include <util/String.h>

struct outlet_action_structure {
  char *source;
  char *target;
  char *command;
};

typedef struct outlet_action_structure Action;
typedef struct outlet_action_structure Outlet;

@interface InterfaceFile : Object <Archiving>
{
  KeyedList  *objects;
  KeyedList  *classes;
  SimpleList *actions;
  SimpleList *outlets;

  id  owner;
  HAB hab;
}

- init;
- free;          /* only free this object */
- freeObjects;   /* also free objects in the list */
- freeAll;       /* free this object, all objects in list and key strings */

/* --------------- Access to the lists storing data --------------- */
- objects;
- classes;
- actions;
- outlets;

-setOwner: anObject;
-owner;
-setHab: (HAB) aHab;
-(HAB) hab;

- (char *) keyFor: (unsigned long) index;
- objectFor: (unsigned long) index;

- (unsigned long) objectCount;
- (unsigned long) classObjectCount;
- (unsigned long) actionCount;
- (unsigned long) outletCount;

/*
 * access to objects
 */
- addObject: anObject withTitle: (char *) aKey;
- objectWithTitle: (char *) aTitle;
- deleteObjectWithTitle: (char *) aKey;
- (unsigned long) indexWithTitle: (char *) aKey;
- (unsigned long) indexForObject: anObject;

/*
 * access to objects not archived
 */
- addClassObject: (char *) className withTitle: (char *) aKey;
- classObjectWithTitle: (char *) aKey;
- deleteClassObjectWithTitle: (char *) aKey;
- (unsigned long) classObjectIndexWithTitle: (char *) aKey;

/*
 * access to outlets
 */
/*- addOutlet: (char *) varName from: (char *) source to: (char *) target;
- deleteOutletAt: (unsigned long) index;
*/
-outletsForObject: anObject;
-outletsToObject: anObject;

-actionsForObject: anObject;
-actionsToObject: anObject;

/*
 * information about objects
 */
-(BOOL) isObjectConnected: anObject;
-deleteConnectionsFor: anObject;

- awake;
- read: (TypedStream *) aStream;
- write: (TypedStream *) aStrem;

-initializeObjects;

@end

#endif
