/* BFD back-end for emx a.out binaries, derived from i386aout.c and aout-target.h
   Copyright 1990, 1991, 1992 Free Software Foundation, Inc.

This file is part of BFD, the Binary File Descriptor library.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#define TARGET_PAGE_SIZE 0x1000
#define SEGMENT_SIZE     0x10000
#define TEXT_START_ADDR  0x10000
#define DEFAULT_ARCH     bfd_arch_i386
#define ZMAGIC_DISK_BLOCK_SIZE 1024
#define BYTES_IN_WORD    4

/* Define some macros to play correctly with a.out-emx header */
#define N_HEADER_IN_TEXT(x) 0
#define N_TXTOFF(x) (N_MAGIC(x) == ZMAGIC ? 0x400 : EXEC_BYTES_SIZE)

#define N_DATOFF(x) (N_TXTOFF(x) + N_TXTSIZE(x))

#define MY(OP) CAT(i386aout_emx_,OP)
#define TARGETNAME "a.out-emx"
#define NO_WRITE_HEADER_KLUDGE 1

#define IS_STAB(flags) (((flags) & N_STAB) \
	&& (flags) != (N_IMP1|N_EXT) && (flags) != (N_IMP2|N_EXT))

#include "bfd.h"

#include "sysdep.h"
#include "libbfd.h"
#include "libaout.h"

static boolean MY(set_sizes) ();
#define MY_backend_data &MY(backend_data)

static boolean MY(add_dynamic_symbols) ();
#define MY_add_dynamic_symbols MY(add_dynamic_symbols)

static CONST struct aout_backend_data MY(backend_data) = {
  0,				/* zmagic contiguous */
  0,				/* text incl header */
  0,				/* entry is text address */
  0,				/* exec_hdr_flags */
  0,				/* text vma? */
  MY(set_sizes),
  1,				/* exec header not counted */
  MY(add_dynamic_symbols),	/* add_dynamic_symbols */
  0,				/* add_one_symbol */
  0,				/* link_dynamic_object */
  0,				/* write_dynamic_symbol */
  0,				/* check_dynamic_reloc */
  0				/* finish_dynamic_link */
};

#include "aout-target.h"

/*
 * Scan syms for imported definitions and add them as abs_section-related
 * symbols (emxbind will fix them later anyway as they should really be)
 * If we won't do this ld will simply ignore N_IMP1 symbols (since they
 * fits N_STAB mask, and ld considers they're debug info). Alas, this
 * required two changes to aoutx.h so ld won't throw them away before we'll
 * receive control.
 */

static boolean MY(add_dynamic_symbols) (abfd, info, syms, sym_count, strings)
 bfd *abfd;
 struct bfd_link_info *info;
 struct external_nlist **syms;
 bfd_size_type *sym_count;
 char **strings;
{
  register struct external_nlist *p;
  struct external_nlist *pend;

  p = *syms;
  pend = p + *sym_count;
  for (; p < pend; p++)
  {
   int type;
   const char *name;
   bfd_vma value;

   type = bfd_h_get_8 (abfd, p->e_type);
   /* Ignore non-imported symbols */
   if (type != (N_IMP1 | N_EXT))
    continue;

   name = *strings + GET_WORD (abfd, p->e_strx);
   value = GET_WORD (abfd, p->e_value);

   _bfd_generic_link_add_one_symbol (info, abfd, name, BSF_DYNAMIC /*flags*/,
    bfd_abs_section_ptr /* section */, 0 /* value */, NULL /* string */,
    false /* copy */, false /* collect */, NULL /* hash */);
  }


 return true;
}
