#ifndef _WINDOWDELEGATE_H_
#define _WINDOWDELEGATE_H_

@protocol CommandDelegate
- buttonWasPressed: (ULONG) buttonId : sender;
- menuWasSelected: (ULONG) menuId : sender;
- commandPosted: (ULONG) origin : sender;
@end

@protocol SysCommandDelegate
- sysButtonWasPressed: (ULONG) buttonId : sender;
- sysMenuWasSelected: (ULONG) menuId : sender;
- sysCommandPosted: (ULONG) origin : sender;
@end

@protocol WindowDelegate
- (MRESULT) handleMessage: (ULONG) msg withParams: (MPARAM) mp1 
            and: (MPARAM) mp2 : sender;
- windowWillClose: sender;
- windowDidMove: sender;
- windowDidResizeFrom: (LONG) oldX : (LONG) oldY 
                   to: (LONG) newX : (LONG) newY : sender;
- windowDidResize: sender;
@end

@protocol ContainerObject
- (CHAR *) fieldData: (ULONG) field;
@end

#endif
