#! /bin/sh
#
# This shell script will extract all useful files from
# binutils-2.9.1 after compilation.
#

function run()
{
  echo $*
  $*
  if [ $? != 0 ]; then
    echo "$0: command failed, aborting"
    exit 1
  fi
}

function copy()
{
  if echo $2 | grep -qs ".new$"; then
    dst=$2/`basename $1`
  else
    dst=$2
  fi
  if [ -f $1 ]; then
    if [ ! -f $dst -o $1 -nt $dst ]; then
      run cp $1 $dst && \
      echo $dst | grep -Eqs "(exe|dll)$" && run lxlite -b- `echo $dst | tr / \\\\\\\\`
    else
      echo "file $1 has already been installed"
    fi
  else
    echo "$0: file $1 has not been built!"
  fi
}

if [ ! -f ltmain.sh ]; then
  echo "This script should be run from base binutils directory!"
  exit 1
fi

[ ! -d /emx ] && run mkdir /emx
[ ! -d /emx/bin.new ] && run mkdir /emx/bin.new
[ ! -d /emx/lib.new ] && run mkdir /emx/lib.new
[ ! -d /emx/dll.new ] && run mkdir /emx/dll.new
[ ! -d /emx/include.new ] && run mkdir /emx/include.new

# Copy libraries first
copy libiberty/libiberty.a /emx/lib.new/iberty.a
copy libiberty/iberty_s.a /emx/lib.new
copy bfd/.libs/bfd.a /emx/lib.new
copy bfd/.libs/bfd_s.a /emx/lib.new
copy opcodes/.libs/opcodes.a /emx/lib.new
copy opcodes/.libs/opcodes_s.a /emx/lib.new

# Now copy the DLLs
copy libiberty/iberty.dll /emx/dll.new
copy bfd/.libs/bfd.dll /emx/dll.new
copy opcodes/.libs/opcodes.dll /emx/dll.new

# And now copy executables
copy binutils/.libs/ar.exe /emx/bin.new
copy binutils/.libs/objdump.exe /emx/bin.new
copy binutils/.libs/objcopy.exe /emx/bin.new
copy binutils/.libs/ranlib.exe /emx/bin.new
copy binutils/.libs/size.exe /emx/bin.new
copy binutils/.libs/strings.exe /emx/bin.new
copy binutils/.libs/addr2line.exe /emx/bin.new
copy binutils/.libs/nm-new.exe /emx/bin.new/nm.exe
copy binutils/.libs/strip-new.exe /emx/bin.new/strip.exe
copy binutils/c++filt.exe /emx/bin.new
copy gas/.libs/as-new.exe /emx/bin.new/as.exe
copy gas/gasp-new.exe /emx/bin.new/gasp.exe
copy gprof/.libs/gprof.exe /emx/bin.new

# Finally, copy include files
copy include/demangle.h /emx/include.new
copy include/dis-asm.h /emx/include.new
copy include/getopt.h /emx/include.new
copy include/fnmatch.h /emx/include.new
copy include/libiberty.h /emx/include.new
copy include/objalloc.h /emx/include.new
copy include/obstack.h /emx/include.new
