
void memset (void *output, int value, unsigned int len);
#pragma aux memset=              \
        "rep stosb"              \
        parm [edi] [eax] [ecx]   \
        modify [edi ecx]

void memcpy (void *output, void *input, unsigned int len);
#pragma aux memcpy=              \
        "rep movsb"              \
        parm [edi] [esi] [ecx]   \
        modify [edi esi ecx]

int memcmp (void *s1, void *s2, unsigned int len);
#pragma aux memcmp=              \
        "xor eax,eax"            \
        "repe cmpsb"             \
        "jb @2"                  \
        "seta al"                \
        "jmp @3"                 \
        "@2:"                    \
        "sbb eax,eax"            \
        "@3:"                    \
        parm [esi] [edi] [ecx]   \
        modify [esi edi ecx eax] \
        value [eax]

char * strcpy(char *dst, const char *src);
#pragma aux strcpy=              \
        "xor ecx,ecx"            \
        "dec ecx"                \
        "push edi"               \
        "mov edi,esi"            \
        "xor eax,eax"            \
        "repne scasb"            \
        "neg ecx"                \
        "dec ecx"                \
        "pop edi"                \
        "mov eax,edi"            \
        "rep movsb"              \
        parm [edi] [esi]         \
        value [eax]              \
        modify [edi esi ecx eax]

int  strlen(char *str);
#pragma aux strlen=              \
        "xor ecx,ecx"            \
        "dec ecx"                \
        "xor eax,eax"            \
        "repnz scasb"            \
        "neg ecx"                \
        "dec ecx"                \
        "mov eax,ecx"            \
        parm [edi]               \
        value [eax]              \
        modify [ecx edi eax]

ULONG ULongToDec(char * buffer, ULONG value);
#pragma aux ULongToDec=          \
        "mov ebx,1000000000"     \
        "mov esi,1"              \
        "mov esi,edi"            \
        "@1:"                    \
        "mov eax,ecx"            \
        "xor edx,edx"            \
        "div ebx"                \
        "add al,48"              \
        "stosb"                  \
        "mov ecx,edx"            \
        "xor edx,edx"            \
        "mov eax,ebx"            \
        "mov ebx,10"             \
        "div ebx"                \
        "mov ebx,eax"            \
        "test ecx,ecx"           \
        "jnz @1"                 \
        "mov eax,edi"            \
        "sub eax,esi"            \
        parm [edi] [ecx]         \
        value [eax]              \
        modify [eax ebx ecx edx esi edi]

//static char HexDigits[]="0123456789ABCDEF";

void ULongToHex(char * buffer, ULONG value);
/*#pragma aux ULongToHex=          \
        "lea ebx,HexDigits"      \
        "mov ch,28"              \
        "mov cl,8"               \
        "@1:"                    \
        "xchg ch,cl"             \
        "mov eax,edx"            \
        "shr eax,cl"             \
        "and al,15"              \
        "xlat"                   \
        "stosb"                  \
        "sub cl,4"               \
        "xchg ch,cl"             \
        "loop @1"                \
        "mov eax,8"              \
        parm [edi] [edx]         \
        value [eax]              \
        modify [eax ebx ecx edx edi]
*/
void HexToULong(const char * buffer, PULONG value);

