-- this is a simple test script to be run from the SQLite shell prompt
-- via the .read command

-- show the schema of the current database
select 'current schema:';
.schema
select ' ';

-- create a temporary table then populate it
select 'creating temporary table...';
create temporary table tmp01 (id integer primary key, word text);
insert into tmp01 (id, word) values (1, 'think');
insert into tmp01 (id, word) values (2, 'plan');
insert into tmp01 (id, word) values (3, 'do');
select ' ';

-- show the schema again to make sure the table is there
select 'current schema:';
.schema
select ' ';

-- show what's in the table
select 'temporary table contents:';
select * from tmp01;
select ' ';

-- repeat the table creation and reporting using memory for temporary tables
select 'switch to using memory for temporary storage...';
pragma temp_store = 'MEMORY';

-- changing the temporary storage should have (unceremoniusly) junked
-- the tmp01 table
select 'current schema:';
.schema
select ' ';

-- create a temporary table then populate it
select 'creating temporary table...';
create temporary table tmp01 (id integer primary key, word text);
insert into tmp01 (id, word) values (1, 'think');
insert into tmp01 (id, word) values (2, 'plan');
insert into tmp01 (id, word) values (3, 'do');
select ' ';

-- show the schema again to make sure the table is there
select 'current schema:';
.schema
select ' ';

-- show what's in the table
select 'temporary table contents:';
select * from tmp01;
select ' ';

-- restore the temporary storage to a file
select 'switch to using files for temporary storage...';
pragma temp_store = 'FILE';
select 'current schema:';
.schema
select ' ';

