/*
** 2006 June 7
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** This header file defines the SQLite interface for use by
** shared libraries that want to be imported as extensions into
** an SQLite instance.  Shared libraries that intend to be loaded
** as extensions by SQLite should #include this file instead of 
** sqlite3.h.
**
** @(#) $Id: sqlite3ext.h,v 1.25 2008/10/12 00:27:54 shane Exp $
*/
#ifndef _SQLITE3EXT_H_
#define _SQLITE3EXT_H_
#include "sqlite3.h"

typedef struct sqlite3_api_routines sqlite3_api_routines;

/*
** The following structure holds pointers to all of the SQLite API
** routines.
**
** WARNING:  In order to maintain backwards compatibility, add new
** interfaces to the end of this structure only.  If you insert new
** interfaces in the middle of this structure, then older different
** versions of SQLite will not be able to load each others' shared
** libraries!
*/
struct sqlite3_api_routines {
  void * (SQLITE_CALL *aggregate_context)(sqlite3_context*,int nBytes);
  int  (SQLITE_CALL *aggregate_count)(sqlite3_context*);
  int  (SQLITE_CALL *bind_blob)(sqlite3_stmt*,int,const void*,int n,void(SQLITE_CALL *)(void*));
  int  (SQLITE_CALL *bind_double)(sqlite3_stmt*,int,double);
  int  (SQLITE_CALL *bind_int)(sqlite3_stmt*,int,int);
  int  (SQLITE_CALL *bind_int64)(sqlite3_stmt*,int,sqlite_int64);
  int  (SQLITE_CALL *bind_null)(sqlite3_stmt*,int);
  int  (SQLITE_CALL *bind_parameter_count)(sqlite3_stmt*);
  int  (SQLITE_CALL *bind_parameter_index)(sqlite3_stmt*,const char*zName);
  const char * (SQLITE_CALL *bind_parameter_name)(sqlite3_stmt*,int);
  int  (SQLITE_CALL *bind_text)(sqlite3_stmt*,int,const char*,int n,void(SQLITE_CALL *)(void*));
  int  (SQLITE_CALL *bind_text16)(sqlite3_stmt*,int,const void*,int,void(SQLITE_CALL *)(void*));
  int  (SQLITE_CALL *bind_value)(sqlite3_stmt*,int,const sqlite3_value*);
  int  (SQLITE_CALL *busy_handler)(sqlite3*,int(SQLITE_CALL *)(void*,int),void*);
  int  (SQLITE_CALL *busy_timeout)(sqlite3*,int ms);
  int  (SQLITE_CALL *changes)(sqlite3*);
  int  (SQLITE_CALL *close)(sqlite3*);
  int  (SQLITE_CALL *collation_needed)(sqlite3*,void*,void(SQLITE_CALL *)(void*,sqlite3*,int eTextRep,const char*));
  int  (SQLITE_CALL *collation_needed16)(sqlite3*,void*,void(SQLITE_CALL *)(void*,sqlite3*,int eTextRep,const void*));
  const void * (SQLITE_CALL *column_blob)(sqlite3_stmt*,int iCol);
  int  (SQLITE_CALL *column_bytes)(sqlite3_stmt*,int iCol);
  int  (SQLITE_CALL *column_bytes16)(sqlite3_stmt*,int iCol);
  int  (SQLITE_CALL *column_count)(sqlite3_stmt*pStmt);
  const char * (SQLITE_CALL *column_database_name)(sqlite3_stmt*,int);
  const void * (SQLITE_CALL *column_database_name16)(sqlite3_stmt*,int);
  const char * (SQLITE_CALL *column_decltype)(sqlite3_stmt*,int i);
  const void * (SQLITE_CALL *column_decltype16)(sqlite3_stmt*,int);
  double  (SQLITE_CALL *column_double)(sqlite3_stmt*,int iCol);
  int  (SQLITE_CALL *column_int)(sqlite3_stmt*,int iCol);
  sqlite_int64  (SQLITE_CALL *column_int64)(sqlite3_stmt*,int iCol);
  const char * (SQLITE_CALL *column_name)(sqlite3_stmt*,int);
  const void * (SQLITE_CALL *column_name16)(sqlite3_stmt*,int);
  const char * (SQLITE_CALL *column_origin_name)(sqlite3_stmt*,int);
  const void * (SQLITE_CALL *column_origin_name16)(sqlite3_stmt*,int);
  const char * (SQLITE_CALL *column_table_name)(sqlite3_stmt*,int);
  const void * (SQLITE_CALL *column_table_name16)(sqlite3_stmt*,int);
  const unsigned char * (SQLITE_CALL *column_text)(sqlite3_stmt*,int iCol);
  const void * (SQLITE_CALL *column_text16)(sqlite3_stmt*,int iCol);
  int  (SQLITE_CALL *column_type)(sqlite3_stmt*,int iCol);
  sqlite3_value* (SQLITE_CALL *column_value)(sqlite3_stmt*,int iCol);
  void * (SQLITE_CALL *commit_hook)(sqlite3*,int(SQLITE_CALL *)(void*),void*);
  int  (SQLITE_CALL *complete)(const char*sql);
  int  (SQLITE_CALL *complete16)(const void*sql);
  int  (SQLITE_CALL *create_collation)(sqlite3*,const char*,int,void*,int(SQLITE_CALL *)(void*,int,const void*,int,const void*));
  int  (SQLITE_CALL *create_collation16)(sqlite3*,const void*,int,void*,int(SQLITE_CALL *)(void*,int,const void*,int,const void*));
  int  (SQLITE_CALL *create_function)(sqlite3*,const char*,int,int,void*,void (SQLITE_CALL *xFunc)(sqlite3_context*,int,sqlite3_value**),void (SQLITE_CALL *xStep)(sqlite3_context*,int,sqlite3_value**),void (SQLITE_CALL *xFinal)(sqlite3_context*));
  int  (SQLITE_CALL *create_function16)(sqlite3*,const void*,int,int,void*,void (SQLITE_CALL *xFunc)(sqlite3_context*,int,sqlite3_value**),void (SQLITE_CALL *xStep)(sqlite3_context*,int,sqlite3_value**),void (SQLITE_CALL *xFinal)(sqlite3_context*));
  int (SQLITE_CALL *create_module)(sqlite3*,const char*,const sqlite3_module*,void*);
  int  (SQLITE_CALL *data_count)(sqlite3_stmt*pStmt);
  sqlite3 * (SQLITE_CALL *db_handle)(sqlite3_stmt*);
  int (SQLITE_CALL *declare_vtab)(sqlite3*,const char*);
  int  (SQLITE_CALL *enable_shared_cache)(int);
  int  (SQLITE_CALL *errcode)(sqlite3*db);
  const char * (SQLITE_CALL *errmsg)(sqlite3*);
  const void * (SQLITE_CALL *errmsg16)(sqlite3*);
  int  (SQLITE_CALL *exec)(sqlite3*,const char*,sqlite3_callback,void*,char**);
  int  (SQLITE_CALL *expired)(sqlite3_stmt*);
  int  (SQLITE_CALL *finalize)(sqlite3_stmt*pStmt);
  void  (SQLITE_CALL *free)(void*);
  void  (SQLITE_CALL *free_table)(char**result);
  int  (SQLITE_CALL *get_autocommit)(sqlite3*);
  void * (SQLITE_CALL *get_auxdata)(sqlite3_context*,int);
  int  (SQLITE_CALL *get_table)(sqlite3*,const char*,char***,int*,int*,char**);
  int  (SQLITE_CALL *global_recover)(void);
  void  (SQLITE_CALL *interruptx)(sqlite3*);
  sqlite_int64  (SQLITE_CALL *last_insert_rowid)(sqlite3*);
  const char * (SQLITE_CALL *libversion)(void);
  int  (SQLITE_CALL *libversion_number)(void);
  void *(SQLITE_CALL *malloc)(int);
  char *(SQLITE_CALL *mprintf)(const char*,...);
  int  (SQLITE_CALL *open)(const char*,sqlite3**);
  int  (SQLITE_CALL *open16)(const void*,sqlite3**);
  int  (SQLITE_CALL *prepare)(sqlite3*,const char*,int,sqlite3_stmt**,const char**);
  int  (SQLITE_CALL *prepare16)(sqlite3*,const void*,int,sqlite3_stmt**,const void**);
  void * (SQLITE_CALL *profile)(sqlite3*,void(SQLITE_CALL *)(void*,const char*,sqlite_uint64),void*);
  void  (SQLITE_CALL *progress_handler)(sqlite3*,int,int(SQLITE_CALL *)(void*),void*);
  void * (SQLITE_CALL *realloc)(void*,int);
  int  (SQLITE_CALL *reset)(sqlite3_stmt*pStmt);
  void  (SQLITE_CALL *result_blob)(sqlite3_context*,const void*,int,void(SQLITE_CALL *)(void*));
  void  (SQLITE_CALL *result_double)(sqlite3_context*,double);
  void  (SQLITE_CALL *result_error)(sqlite3_context*,const char*,int);
  void  (SQLITE_CALL *result_error16)(sqlite3_context*,const void*,int);
  void  (SQLITE_CALL *result_int)(sqlite3_context*,int);
  void  (SQLITE_CALL *result_int64)(sqlite3_context*,sqlite_int64);
  void  (SQLITE_CALL *result_null)(sqlite3_context*);
  void  (SQLITE_CALL *result_text)(sqlite3_context*,const char*,int,void(SQLITE_CALL *)(void*));
  void  (SQLITE_CALL *result_text16)(sqlite3_context*,const void*,int,void(SQLITE_CALL *)(void*));
  void  (SQLITE_CALL *result_text16be)(sqlite3_context*,const void*,int,void(SQLITE_CALL *)(void*));
  void  (SQLITE_CALL *result_text16le)(sqlite3_context*,const void*,int,void(SQLITE_CALL *)(void*));
  void  (SQLITE_CALL *result_value)(sqlite3_context*,sqlite3_value*);
  void * (SQLITE_CALL *rollback_hook)(sqlite3*,void(SQLITE_CALL *)(void*),void*);
  int  (SQLITE_CALL *set_authorizer)(sqlite3*,int(SQLITE_CALL *)(void*,int,const char*,const char*,const char*,const char*),void*);
  void  (SQLITE_CALL *set_auxdata)(sqlite3_context*,int,void*,void (SQLITE_CALL *)(void*));
  char * (SQLITE_CALL *snprintf)(int,char*,const char*,...);
  int  (SQLITE_CALL *step)(sqlite3_stmt*);
  int  (SQLITE_CALL *table_column_metadata)(sqlite3*,const char*,const char*,const char*,char const**,char const**,int*,int*,int*);
  void  (SQLITE_CALL *thread_cleanup)(void);
  int  (SQLITE_CALL *total_changes)(sqlite3*);
  void * (SQLITE_CALL *trace)(sqlite3*,void(SQLITE_CALL *xTrace)(void*,const char*),void*);
  int  (SQLITE_CALL *transfer_bindings)(sqlite3_stmt*,sqlite3_stmt*);
  void * (SQLITE_CALL *update_hook)(sqlite3*,void(SQLITE_CALL *)(void*,int ,char const*,char const*,sqlite_int64),void*);
  void * (SQLITE_CALL *user_data)(sqlite3_context*);
  const void * (SQLITE_CALL *value_blob)(sqlite3_value*);
  int  (SQLITE_CALL *value_bytes)(sqlite3_value*);
  int  (SQLITE_CALL *value_bytes16)(sqlite3_value*);
  double  (SQLITE_CALL *value_double)(sqlite3_value*);
  int  (SQLITE_CALL *value_int)(sqlite3_value*);
  sqlite_int64  (SQLITE_CALL *value_int64)(sqlite3_value*);
  int  (SQLITE_CALL *value_numeric_type)(sqlite3_value*);
  const unsigned char * (SQLITE_CALL *value_text)(sqlite3_value*);
  const void * (SQLITE_CALL *value_text16)(sqlite3_value*);
  const void * (SQLITE_CALL *value_text16be)(sqlite3_value*);
  const void * (SQLITE_CALL *value_text16le)(sqlite3_value*);
  int  (SQLITE_CALL *value_type)(sqlite3_value*);
  char *(SQLITE_CALL *vmprintf)(const char*,va_list);
  /* Added ??? */
  int (SQLITE_CALL *overload_function)(sqlite3*, const char *zFuncName, int nArg);
  /* Added by 3.3.13 */
  int (SQLITE_CALL *prepare_v2)(sqlite3*,const char*,int,sqlite3_stmt**,const char**);
  int (SQLITE_CALL *prepare16_v2)(sqlite3*,const void*,int,sqlite3_stmt**,const void**);
  int (SQLITE_CALL *clear_bindings)(sqlite3_stmt*);
  /* Added by 3.4.1 */
  int (SQLITE_CALL *create_module_v2)(sqlite3*,const char*,const sqlite3_module*,void*,void (SQLITE_CALL *xDestroy)(void *));
  /* Added by 3.5.0 */
  int (SQLITE_CALL *bind_zeroblob)(sqlite3_stmt*,int,int);
  int (SQLITE_CALL *blob_bytes)(sqlite3_blob*);
  int (SQLITE_CALL *blob_close)(sqlite3_blob*);
  int (SQLITE_CALL *blob_open)(sqlite3*,const char*,const char*,const char*,sqlite3_int64,int,sqlite3_blob**);
  int (SQLITE_CALL *blob_read)(sqlite3_blob*,void*,int,int);
  int (SQLITE_CALL *blob_write)(sqlite3_blob*,const void*,int,int);
  int (SQLITE_CALL *create_collation_v2)(sqlite3*,const char*,int,void*,int(SQLITE_CALL *)(void*,int,const void*,int,const void*),void(*)(void*));
  int (SQLITE_CALL *file_control)(sqlite3*,const char*,int,void*);
  sqlite3_int64 (SQLITE_CALL *memory_highwater)(int);
  sqlite3_int64 (SQLITE_CALL *memory_used)(void);
  sqlite3_mutex *(SQLITE_CALL *mutex_alloc)(int);
  void (SQLITE_CALL *mutex_enter)(sqlite3_mutex*);
  void (SQLITE_CALL *mutex_free)(sqlite3_mutex*);
  void (SQLITE_CALL *mutex_leave)(sqlite3_mutex*);
  int (SQLITE_CALL *mutex_try)(sqlite3_mutex*);
  int (SQLITE_CALL *open_v2)(const char*,sqlite3**,int,const char*);
  int (SQLITE_CALL *release_memory)(int);
  void (SQLITE_CALL *result_error_nomem)(sqlite3_context*);
  void (SQLITE_CALL *result_error_toobig)(sqlite3_context*);
  int (SQLITE_CALL *sleep)(int);
  void (SQLITE_CALL *soft_heap_limit)(int);
  sqlite3_vfs *(SQLITE_CALL *vfs_find)(const char*);
  int (SQLITE_CALL *vfs_register)(sqlite3_vfs*,int);
  int (SQLITE_CALL *vfs_unregister)(sqlite3_vfs*);
  int (SQLITE_CALL *xthreadsafe)(void);
  void (SQLITE_CALL *result_zeroblob)(sqlite3_context*,int);
  void (SQLITE_CALL *result_error_code)(sqlite3_context*,int);
  int (SQLITE_CALL *test_control)(int, ...);
  void (SQLITE_CALL *randomness)(int,void*);
  sqlite3 *(SQLITE_CALL *context_db_handle)(sqlite3_context*);
  int (SQLITE_CALL *extended_result_codes)(sqlite3*,int);
  int (SQLITE_CALL *limit)(sqlite3*,int,int);
  sqlite3_stmt *(SQLITE_CALL *next_stmt)(sqlite3*,sqlite3_stmt*);
  const char *(SQLITE_CALL *sql)(sqlite3_stmt*);
  int (SQLITE_CALL *status)(int,int*,int*,int);
};

/*
** The following macros redefine the API routines so that they are
** redirected throught the global sqlite3_api structure.
**
** This header file is also used by the loadext.c source file
** (part of the main SQLite library - not an extension) so that
** it can get access to the sqlite3_api_routines structure
** definition.  But the main library does not want to redefine
** the API.  So the redefinition macros are only valid if the
** SQLITE_CORE macros is undefined.
*/
#ifndef SQLITE_CORE
#define sqlite3_aggregate_context      sqlite3_api->aggregate_context
#ifndef SQLITE_OMIT_DEPRECATED
#define sqlite3_aggregate_count        sqlite3_api->aggregate_count
#endif
#define sqlite3_bind_blob              sqlite3_api->bind_blob
#define sqlite3_bind_double            sqlite3_api->bind_double
#define sqlite3_bind_int               sqlite3_api->bind_int
#define sqlite3_bind_int64             sqlite3_api->bind_int64
#define sqlite3_bind_null              sqlite3_api->bind_null
#define sqlite3_bind_parameter_count   sqlite3_api->bind_parameter_count
#define sqlite3_bind_parameter_index   sqlite3_api->bind_parameter_index
#define sqlite3_bind_parameter_name    sqlite3_api->bind_parameter_name
#define sqlite3_bind_text              sqlite3_api->bind_text
#define sqlite3_bind_text16            sqlite3_api->bind_text16
#define sqlite3_bind_value             sqlite3_api->bind_value
#define sqlite3_busy_handler           sqlite3_api->busy_handler
#define sqlite3_busy_timeout           sqlite3_api->busy_timeout
#define sqlite3_changes                sqlite3_api->changes
#define sqlite3_close                  sqlite3_api->close
#define sqlite3_collation_needed       sqlite3_api->collation_needed
#define sqlite3_collation_needed16     sqlite3_api->collation_needed16
#define sqlite3_column_blob            sqlite3_api->column_blob
#define sqlite3_column_bytes           sqlite3_api->column_bytes
#define sqlite3_column_bytes16         sqlite3_api->column_bytes16
#define sqlite3_column_count           sqlite3_api->column_count
#define sqlite3_column_database_name   sqlite3_api->column_database_name
#define sqlite3_column_database_name16 sqlite3_api->column_database_name16
#define sqlite3_column_decltype        sqlite3_api->column_decltype
#define sqlite3_column_decltype16      sqlite3_api->column_decltype16
#define sqlite3_column_double          sqlite3_api->column_double
#define sqlite3_column_int             sqlite3_api->column_int
#define sqlite3_column_int64           sqlite3_api->column_int64
#define sqlite3_column_name            sqlite3_api->column_name
#define sqlite3_column_name16          sqlite3_api->column_name16
#define sqlite3_column_origin_name     sqlite3_api->column_origin_name
#define sqlite3_column_origin_name16   sqlite3_api->column_origin_name16
#define sqlite3_column_table_name      sqlite3_api->column_table_name
#define sqlite3_column_table_name16    sqlite3_api->column_table_name16
#define sqlite3_column_text            sqlite3_api->column_text
#define sqlite3_column_text16          sqlite3_api->column_text16
#define sqlite3_column_type            sqlite3_api->column_type
#define sqlite3_column_value           sqlite3_api->column_value
#define sqlite3_commit_hook            sqlite3_api->commit_hook
#define sqlite3_complete               sqlite3_api->complete
#define sqlite3_complete16             sqlite3_api->complete16
#define sqlite3_create_collation       sqlite3_api->create_collation
#define sqlite3_create_collation16     sqlite3_api->create_collation16
#define sqlite3_create_function        sqlite3_api->create_function
#define sqlite3_create_function16      sqlite3_api->create_function16
#define sqlite3_create_module          sqlite3_api->create_module
#define sqlite3_create_module_v2       sqlite3_api->create_module_v2
#define sqlite3_data_count             sqlite3_api->data_count
#define sqlite3_db_handle              sqlite3_api->db_handle
#define sqlite3_declare_vtab           sqlite3_api->declare_vtab
#define sqlite3_enable_shared_cache    sqlite3_api->enable_shared_cache
#define sqlite3_errcode                sqlite3_api->errcode
#define sqlite3_errmsg                 sqlite3_api->errmsg
#define sqlite3_errmsg16               sqlite3_api->errmsg16
#define sqlite3_exec                   sqlite3_api->exec
#ifndef SQLITE_OMIT_DEPRECATED
#define sqlite3_expired                sqlite3_api->expired
#endif
#define sqlite3_finalize               sqlite3_api->finalize
#define sqlite3_free                   sqlite3_api->free
#define sqlite3_free_table             sqlite3_api->free_table
#define sqlite3_get_autocommit         sqlite3_api->get_autocommit
#define sqlite3_get_auxdata            sqlite3_api->get_auxdata
#define sqlite3_get_table              sqlite3_api->get_table
#ifndef SQLITE_OMIT_DEPRECATED
#define sqlite3_global_recover         sqlite3_api->global_recover
#endif
#define sqlite3_interrupt              sqlite3_api->interruptx
#define sqlite3_last_insert_rowid      sqlite3_api->last_insert_rowid
#define sqlite3_libversion             sqlite3_api->libversion
#define sqlite3_libversion_number      sqlite3_api->libversion_number
#define sqlite3_malloc                 sqlite3_api->malloc
#define sqlite3_mprintf                sqlite3_api->mprintf
#define sqlite3_open                   sqlite3_api->open
#define sqlite3_open16                 sqlite3_api->open16
#define sqlite3_prepare                sqlite3_api->prepare
#define sqlite3_prepare16              sqlite3_api->prepare16
#define sqlite3_prepare_v2             sqlite3_api->prepare_v2
#define sqlite3_prepare16_v2           sqlite3_api->prepare16_v2
#define sqlite3_profile                sqlite3_api->profile
#define sqlite3_progress_handler       sqlite3_api->progress_handler
#define sqlite3_realloc                sqlite3_api->realloc
#define sqlite3_reset                  sqlite3_api->reset
#define sqlite3_result_blob            sqlite3_api->result_blob
#define sqlite3_result_double          sqlite3_api->result_double
#define sqlite3_result_error           sqlite3_api->result_error
#define sqlite3_result_error16         sqlite3_api->result_error16
#define sqlite3_result_int             sqlite3_api->result_int
#define sqlite3_result_int64           sqlite3_api->result_int64
#define sqlite3_result_null            sqlite3_api->result_null
#define sqlite3_result_text            sqlite3_api->result_text
#define sqlite3_result_text16          sqlite3_api->result_text16
#define sqlite3_result_text16be        sqlite3_api->result_text16be
#define sqlite3_result_text16le        sqlite3_api->result_text16le
#define sqlite3_result_value           sqlite3_api->result_value
#define sqlite3_rollback_hook          sqlite3_api->rollback_hook
#define sqlite3_set_authorizer         sqlite3_api->set_authorizer
#define sqlite3_set_auxdata            sqlite3_api->set_auxdata
#define sqlite3_snprintf               sqlite3_api->snprintf
#define sqlite3_step                   sqlite3_api->step
#define sqlite3_table_column_metadata  sqlite3_api->table_column_metadata
#define sqlite3_thread_cleanup         sqlite3_api->thread_cleanup
#define sqlite3_total_changes          sqlite3_api->total_changes
#define sqlite3_trace                  sqlite3_api->trace
#ifndef SQLITE_OMIT_DEPRECATED
#define sqlite3_transfer_bindings      sqlite3_api->transfer_bindings
#endif
#define sqlite3_update_hook            sqlite3_api->update_hook
#define sqlite3_user_data              sqlite3_api->user_data
#define sqlite3_value_blob             sqlite3_api->value_blob
#define sqlite3_value_bytes            sqlite3_api->value_bytes
#define sqlite3_value_bytes16          sqlite3_api->value_bytes16
#define sqlite3_value_double           sqlite3_api->value_double
#define sqlite3_value_int              sqlite3_api->value_int
#define sqlite3_value_int64            sqlite3_api->value_int64
#define sqlite3_value_numeric_type     sqlite3_api->value_numeric_type
#define sqlite3_value_text             sqlite3_api->value_text
#define sqlite3_value_text16           sqlite3_api->value_text16
#define sqlite3_value_text16be         sqlite3_api->value_text16be
#define sqlite3_value_text16le         sqlite3_api->value_text16le
#define sqlite3_value_type             sqlite3_api->value_type
#define sqlite3_vmprintf               sqlite3_api->vmprintf
#define sqlite3_overload_function      sqlite3_api->overload_function
#define sqlite3_prepare_v2             sqlite3_api->prepare_v2
#define sqlite3_prepare16_v2           sqlite3_api->prepare16_v2
#define sqlite3_clear_bindings         sqlite3_api->clear_bindings
#define sqlite3_bind_zeroblob          sqlite3_api->bind_zeroblob
#define sqlite3_blob_bytes             sqlite3_api->blob_bytes
#define sqlite3_blob_close             sqlite3_api->blob_close
#define sqlite3_blob_open              sqlite3_api->blob_open
#define sqlite3_blob_read              sqlite3_api->blob_read
#define sqlite3_blob_write             sqlite3_api->blob_write
#define sqlite3_create_collation_v2    sqlite3_api->create_collation_v2
#define sqlite3_file_control           sqlite3_api->file_control
#define sqlite3_memory_highwater       sqlite3_api->memory_highwater
#define sqlite3_memory_used            sqlite3_api->memory_used
#define sqlite3_mutex_alloc            sqlite3_api->mutex_alloc
#define sqlite3_mutex_enter            sqlite3_api->mutex_enter
#define sqlite3_mutex_free             sqlite3_api->mutex_free
#define sqlite3_mutex_leave            sqlite3_api->mutex_leave
#define sqlite3_mutex_try              sqlite3_api->mutex_try
#define sqlite3_open_v2                sqlite3_api->open_v2
#define sqlite3_release_memory         sqlite3_api->release_memory
#define sqlite3_result_error_nomem     sqlite3_api->result_error_nomem
#define sqlite3_result_error_toobig    sqlite3_api->result_error_toobig
#define sqlite3_sleep                  sqlite3_api->sleep
#define sqlite3_soft_heap_limit        sqlite3_api->soft_heap_limit
#define sqlite3_vfs_find               sqlite3_api->vfs_find
#define sqlite3_vfs_register           sqlite3_api->vfs_register
#define sqlite3_vfs_unregister         sqlite3_api->vfs_unregister
#define sqlite3_threadsafe             sqlite3_api->xthreadsafe
#define sqlite3_result_zeroblob        sqlite3_api->result_zeroblob
#define sqlite3_result_error_code      sqlite3_api->result_error_code
#define sqlite3_test_control           sqlite3_api->test_control
#define sqlite3_randomness             sqlite3_api->randomness
#define sqlite3_context_db_handle      sqlite3_api->context_db_handle
#define sqlite3_extended_result_codes  sqlite3_api->extended_result_codes
#define sqlite3_limit                  sqlite3_api->limit
#define sqlite3_next_stmt              sqlite3_api->next_stmt
#define sqlite3_sql                    sqlite3_api->sql
#define sqlite3_status                 sqlite3_api->status
#endif /* SQLITE_CORE */

#define SQLITE_EXTENSION_INIT1     const sqlite3_api_routines *sqlite3_api = 0;
#define SQLITE_EXTENSION_INIT2(v)  sqlite3_api = v;

#endif /* _SQLITE3EXT_H_ */
