/*           Copyright (c) 2003  Andrew I MacIntyre
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/* a dummy to resolve a missing reference to _environ caused
 * by something in spawnve being pulled in by the linker, even
 * though spawnve is not referenced anywhere in the source of
 * this package :-(
 */

char **_environ = (void *)0;

/* Remap OS/2 TCP/IP errors to standard EMX (Posix'ish) errors.
 * We provide functions to set the socket errno as well as
 * retrieve it; though the setting of socket errno's is not
 * documented that I can find...
 */
#include <errno.h>

#define SOCBASEERR	10000
static int os2errors[50][2] = { { SOCBASEERR, 0 },
				{ SOCBASEERR + 1,  EPERM },
				{ SOCBASEERR + 3,  ESRCH },
				{ SOCBASEERR + 4,  EINTR },
				{ SOCBASEERR + 6,  ENXIO },
				{ SOCBASEERR + 9,  EBADF },
				{ SOCBASEERR + 13,  EACCES },
				{ SOCBASEERR + 14,  EFAULT },
				{ SOCBASEERR + 22,  EINVAL },
				{ SOCBASEERR + 24,  EMFILE },
				{ SOCBASEERR + 32,  EPIPE },
				{ SOCBASEERR + 35,  EWOULDBLOCK },
				{ SOCBASEERR + 36,  EINPROGRESS },
				{ SOCBASEERR + 37,  EALREADY },
				{ SOCBASEERR + 38,  ENOTSOCK },
				{ SOCBASEERR + 39,  EDESTADDRREQ },
				{ SOCBASEERR + 40,  EMSGSIZE },
				{ SOCBASEERR + 41,  EPROTOTYPE },
				{ SOCBASEERR + 42,  ENOPROTOOPT },
				{ SOCBASEERR + 43,  EPROTONOSUPPORT },
				{ SOCBASEERR + 44,  ESOCKTNOSUPPORT },
				{ SOCBASEERR + 45,  EOPNOTSUPP },
				{ SOCBASEERR + 46,  EPFNOSUPPORT },
				{ SOCBASEERR + 47,  EAFNOSUPPORT },
				{ SOCBASEERR + 48,  EADDRINUSE },
				{ SOCBASEERR + 49,  EADDRNOTAVAIL },
				{ SOCBASEERR + 50,  ENETDOWN },
				{ SOCBASEERR + 51,  ENETUNREACH },
				{ SOCBASEERR + 52,  ENETRESET },
				{ SOCBASEERR + 53,  ECONNABORTED },
				{ SOCBASEERR + 54,  ECONNRESET },
				{ SOCBASEERR + 55,  ENOBUFS },
				{ SOCBASEERR + 56,  EISCONN },
				{ SOCBASEERR + 57,  ENOTCONN },
				{ SOCBASEERR + 58,  ESHUTDOWN },
				{ SOCBASEERR + 59,  ETOOMANYREFS },
				{ SOCBASEERR + 60,  ETIMEDOUT },
				{ SOCBASEERR + 61,  ECONNREFUSED },
				{ SOCBASEERR + 62,  ELOOP },
				{ SOCBASEERR + 63,  ENAMETOOLONG },
				{ SOCBASEERR + 64,  EHOSTDOWN },
				{ SOCBASEERR + 65,  EHOSTUNREACH },
				{ SOCBASEERR + 66,  ENOTEMPTY },
				{ SOCBASEERR + 100, EIO },
				{ 0,  EINVAL } };

extern void set_errno(int e);	/* undocumented DLL export */
extern int sock_errno(void);

int os2sock_errno(void)
{
	int i;
	int os2_e;
	int e = sock_errno();

	i = 0;
	while ((os2_e = os2errors[i][0]) > 0 && os2_e != e)
		i++;

	return os2errors[i][1];
}

void os2sock_seterrno(int e)
{
	int i;

	i = 0;
	while (os2errors[i][0] > 0 && os2errors[i][1] != e)
		i++;

	set_errno(os2errors[i][0]);
}

/* a wrapper for so_ioctl to hide the fourth parameter,
 * when the data component is an integer.  This applies
 * to FIONBIO and FIONREAD requests _only_!
 */
extern int so_ioctl(int s, int cmd, void *data, int dlen);

int ioctlsocket(int s, int cmd, void *data)
{
	int rc;
	rc = so_ioctl(s, cmd, data, sizeof(int));
	return rc;
}
