/* header to define endianness routines in terms known to the
 * IBM TCP/IP stack for OS/2, v4.
 *
 * EMX provides its own definitions for these macros, which
 * won't work in -Zso -Zsys builds unless -lsocket is used.
 * Because -lsocket resolves other symbols that don't work
 * with -Zso -Zsys, we need these barefoot definitions.
 */

extern unsigned long lswap(unsigned long);
extern unsigned short bswap(unsigned short);

#define htonl(x)	(lswap(x))
#define ntohl(x)	(lswap(x))
#define htons(x)	(bswap(x))
#define ntohs(x)	(bswap(x))
