:userdoc.
:docprof toc=123456.
:title.Harbour Reference Guide
.* HBDOC generated IPF Source File.
.* HBDOC Document Source Extractor, (c)1999-2000 Luiz Rafael Culik.
:h1 HARBY.HARBOUR TOOLS
:h2  res=1.TFileRead()
:i1 id=HARBOX.HARBOUR TOOLS
:i2 refid=HARBOX.TFILEREAD()
:p.TFileRead&lpar.&rpar.
.br
.br
:hp2.Read a file one line at a time:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.oFile &colon.&eq. TFileRead&lpar.&rpar.&colon.New&lpar. <cFileName> &lbrk.&comma. <nReadSize> &rbrk.. &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<cFileName>:ehp2.  is the required name of the file to be read.
.br
:p.<nReadSize> is the optional size to use when reading from the file.  The default value is 4096 and the allowed range is 1 through 65535.  Any value outside of this range causes the default value to be used.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.An  instance of the File Reader class
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.TFileRead&lpar.&rpar. is used to access a file one line at a time. You must  specify the name of the file when an instance of the class is created.
:p.The class data should be considered private to the class.
.br
:p.The class methods are as follows&colon.
.br
:p.New&lpar.&rpar.              Creates a new instance of the TFileRead class.
.br
:p.Open&lpar.&lbrk.<nFlags>&rbrk..&rpar.   Opens the file for reading. The optional nFlags  parameter can use any of the FOPEN&lpar.&rpar. flags from  fileio.ch. The default is FO&us.READ + FO&us.SHARED.  Calling this method when
the file is already  open causes the next ReadLine&lpar.&rpar. to start over  from the beginning of the file.
.br
:p.Close&lpar.&rpar.            Closes the file.
.br
:p.ReadLine&lpar.&rpar.         Returns one line from the file&comma. stripping the  newline characters. The following sequences are  treated as one newline&colon. 1&rpar. CR CR LF&semi. 2&rpar. CR LF&semi.  3&rpar. LF&semi. and
4&rpar. CR. Note&colon. LF CR is 2 newlines.
:p.Name&lpar.&rpar.             Returns the name of the file.
.br
:p.IsOpen&lpar.&rpar.           Returns .T. if the file is open.
.br
:p.MoreToRead&lpar.&rpar.       Returns .T. if there are more lines to be read  &lpar.think of it as an inverse EOF function&rpar..
.br
:p.Error&lpar.&rpar.            Returns .T. if an error has occurred.
.br
:p.ErrorNo&lpar.&rpar.          Returns the current error code.
.br
:p.ErrorMsg&lpar.&lbrk.<cPre>&rbrk..&rpar. Returns a formatted error message.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      #ifdef &us.&us.HARBOUR&us.&us.
.br
       #define NEW&us.LINE CHR&lpar. 10 &rpar.
.br
      #else
.br
       #define NEW&us.LINE CHR&lpar. 13 &rpar. + CHR&lpar. 10 &rpar.
.br
      #endif
.br
      #include &cdq.fileio.ch&cdq.
.br

.br
      PROCEDURE Main&lpar. cFile &rpar.
.br
      LOCAL oFile &colon.&eq. TFileRead&lpar.&rpar.&colon.New&lpar. cFile &rpar.
.br

.br
         oFile&colon.Open&lpar.&rpar.
.br
         IF oFile&colon.Error&lpar.&rpar.
.br
            QOUT&lpar. oFile&colon.ErrorMsg&lpar. &cdq.FileRead&colon. &cdq. &rpar. &rpar.
.br
         ELSE
.br
            WHILE oFile&colon.MoreToRead&lpar.&rpar.
.br
               OUTSTD&lpar. oFile&colon.ReadLine&lpar.&rpar. &rpar.
.br
               OUTSTD&lpar. NEW&us.LINE &rpar.
.br
            END WHILE
.br
            oFile&colon.Close&lpar.&rpar.
.br
         END IF
.br
      QUIT
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See Examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This is a new Harbour Tools class
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=2.TCLASS():elink.
.br
:h1 CONVY.CONVERSION TOOLS
:h2  res=3.ISBIN()
:i1 id=CONVEX.CONVERSION TOOLS
:i2 refid=CONVEX.ISBIN()
:p.ISBIN&lpar.&rpar.
.br
.br
:hp2.Check if the value is a Binary  Number:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ISBIN&lpar.<cN>&rpar. &minus.><cNr>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cN> STRING TO BE CHECKED
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cNr> .T. IF THE STRING IS BYNARY&comma.otherwise .F.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.check if the passed string is a bynary number or not
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=4.ISOCTAL():elink.
.br
:link reftype=hd res=5.ISDEC():elink.
.br
:link reftype=hd res=6.ISHEXA():elink.
.br
:h2 id=CONVY res=4.ISOCTAL()
:i2 refid=CONVEX.ISOCTAL()
:p.ISOCTAL&lpar.&rpar.
.br
.br
:hp2.Check if the value is a Octal  Number:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ISOCTAL&lpar.<cN>&rpar. &minus.><cNr>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cN> STRING TO BE CHECKED
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cNr> .T. IF THE STRING IS OCTAL&semi.otherwise .F.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.check if the passed string is a octal number or not
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=3.ISBIN():elink.
.br
:link reftype=hd res=5.ISDEC():elink.
.br
:link reftype=hd res=6.ISHEXA():elink.
.br
:h2 id=CONVY res=5.ISDEC()
:i2 refid=CONVEX.ISDEC()
:p.ISDEC&lpar.&rpar.
.br
.br
:hp2.Check if the value is a Decimal  Number:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ISDEC&lpar.<cN>&rpar. &minus.><cNr>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cN> STRING TO BE CHECKED
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cNr> .T. IF THE STRING IS DECIMAL&semi.otherwise .F.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.check if the passed string is a decimal number or not
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=4.ISOCTAL():elink.
.br
:link reftype=hd res=3.ISBIN():elink.
.br
:link reftype=hd res=6.ISHEXA():elink.
.br
:h2 id=CONVY res=6.ISHEXA()
:i2 refid=CONVEX.ISHEXA()
:p.ISHEXA&lpar.&rpar.
.br
.br
:hp2.Check if the value is a Hexal  Number:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ISHEXA&lpar.<cN>&rpar. &minus.><cNr>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cN> STRING TO BE CHECKED
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cNr> .T. IF THE STRING IS HEXA&semi.otherwise .F.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.check if the passed string is a hexa number or not
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=4.ISOCTAL():elink.
.br
:link reftype=hd res=5.ISDEC():elink.
.br
:link reftype=hd res=3.ISBIN():elink.
.br
:h2 id=CONVY res=7.DECTOBIN()
:i2 refid=CONVEX.DECTOBIN()
:p.DECTOBIN&lpar.&rpar.
.br
.br
:hp2.Converts a Decimal Value to Binary:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DECTOBIN&lpar.<cN>&rpar. &minus.><cNr>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cN> NUMBER TO BE CONVERTED
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cNr>  NUMBER CONVERTED
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts a string <cN> from an decimal value  to an binary value.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=8.DECTOHEXA():elink.
.br
:link reftype=hd res=9.DECTOOCTAL():elink.
.br
:h2 id=CONVY res=9.DECTOOCTAL()
:i2 refid=CONVEX.DECTOOCTAL()
:p.DECTOOCTAL&lpar.&rpar.
.br
.br
:hp2.Converts a Decimal Value to Octal:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DECTOOCTAL&lpar.<cN>&rpar. &minus.><cNr>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cN> NUMBER TO BE CONVERTED
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cNr>  NUMBER CONVERTED
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts a string <cN> from an decimal value  to an octal value.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=8.DECTOHEXA():elink.
.br
:link reftype=hd res=7.DECTOBIN():elink.
.br
:h2 id=CONVY res=8.DECTOHEXA()
:i2 refid=CONVEX.DECTOHEXA()
:p.DECTOHEXA&lpar.&rpar.
.br
.br
:hp2.Converts a Decimal Value to Hexa:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DECTOHEXA&lpar.<cN>&rpar. &minus.><cNr>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cN> NUMBER TO BE CONVERTED
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cNr>  NUMBER CONVERTED
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts a string <cN> from an decimal value  to an hexadecimal value.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=7.DECTOBIN():elink.
.br
:link reftype=hd res=9.DECTOOCTAL():elink.
.br
:h2 id=CONVY res=10.BINTODEC()
:i2 refid=CONVEX.BINTODEC()
:p.BINTODEC&lpar.&rpar.
.br
.br
:hp2.Converts a Binary Value to Decimal:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.BIntODEC&lpar.<cN>&rpar. &minus.><cNr>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cN> NUMBER TO BE CONVERTED
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cNr>  NUMBER CONVERTED
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts a string <cN> from an binary value  to a numeric decimal value.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=11.OCTALTODEC():elink.
.br
:link reftype=hd res=12.HEXATODEC():elink.
.br
:h2 id=CONVY res=11.OCTALTODEC()
:i2 refid=CONVEX.OCTALTODEC()
:p.OCTALTODEC&lpar.&rpar.
.br
.br
:hp2.Converts a Octal Value to Decimal:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.OCTALTODEC&lpar.<cN>&rpar. &minus.><cNr>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cN> NUMBER TO BE CONVERTED
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cNr>  NUMBER CONVERTED
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts a string <cN> from an octal value  to a numeric decimal value.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=10.BINTODEC():elink.
.br
:link reftype=hd res=12.HEXATODEC():elink.
.br
:h2 id=CONVY res=12.HEXATODEC()
:i2 refid=CONVEX.HEXATODEC()
:p.HEXATODEC&lpar.&rpar.
.br
.br
:hp2.Converts a Hexa Value to Decimal:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HEXATODEC&lpar.<cN>&rpar. &minus.><cNr>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cN> NUMBER TO BE CONVERTED
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cNr>  NUMBER CONVERTED
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts a string <cN> from an hexadecimal value  to a numeric decimal value.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=11.OCTALTODEC():elink.
.br
:link reftype=hd res=10.BINTODEC():elink.
.br
:h1 DATAY.DATABASE TOOLS
:h2  res=13.FIELDTYPE()
:i1 id=DATABX.DATABASE TOOLS
:i2 refid=DATABX.FIELDTYPE()
:p.FIELDTYPE&lpar.&rpar.
.br
.br
:hp2.Determines the type of a given field.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FIELDTYPE&lpar.<nFieldNum>&rpar. &minus.&minus.> cFieldType:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nFieldNum> Data field &comma. which type need to be determined.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.FIELDTYPE&lpar.&rpar. returns the character that designates the type of  a given field&colon.
:table cols=' 3 17'.
:row.
:c.'C'
:c.character string;
:row.
:c.'N'
:c.numeric;
:row.
:c.'L'
:c.logical;
:row.
:c.'D'
:c.date;
:row.
:c.'M'
:c.memo.
:etable.
.br
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function determines the type of a field&comma. designated by its  number.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
      LOCAL i
.br
      USE Tests NEW
.br
      FOR i &eq. 1 TO FCOUNT&lpar.&rpar.
.br
        ? FieldType&lpar. i &rpar.
.br
      NEXT
.br
      USE
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.CLIPPER tools compatible
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=14.FIELDSIZE():elink.
.br
:link reftype=hd res=15.FIELDDECI():elink.
.br
:h2 id=DATAY res=14.FIELDSIZE()
:i2 refid=DATABX.FIELDSIZE()
:p.FIELDSIZE&lpar.&rpar.
.br
.br
:hp2.Determines the size of a given field.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FIELDSIZE&lpar.<nFieldNum>&rpar. &minus.&minus.> nFieldSize:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nFieldNum> Data field &comma. which size need to be determined.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.FIELDSIZE&lpar.&rpar. returns the number that designates the size of a given  field.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function determines the size of a field&comma. designated by its number.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
      LOCAL i
.br
      USE Tests NEW
.br
      FOR i &eq. 1 TO FCOUNT&lpar.&rpar.
.br
        ? FieldSize&lpar. i &rpar.
.br
      NEXT
.br
      USE
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.CLIPPER tools compatible
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=13.FIELDTYPE():elink.
.br
:link reftype=hd res=15.FIELDDECI():elink.
.br
:h2 id=DATAY res=15.FIELDDECI()
:i2 refid=DATABX.FIELDDECI()
:p.FIELDDECI&lpar.&rpar.
.br
.br
:hp2.Determines the number of decimal places of a given numeric field.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FIELDDECI&lpar.<nFieldNum>&rpar. &minus.&minus.> nFieldDeci:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nFieldNum> Numeric data field &comma. for which number of decimal  places need to be determined.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.FIELDDECI&lpar.&rpar. returns the numeric value that designates the number  of decimal places of a given field.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function determines the number of decimal places of a given numeric field.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
      LOCAL i
.br
      USE Tests NEW
.br
      FOR i &eq. 1 TO FCOUNT&lpar.&rpar.
.br
        ? FieldDeci&lpar. i &rpar.
.br
      NEXT
.br
      USE
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.CLIPPER tools compatible
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=13.FIELDTYPE():elink.
.br
:link reftype=hd res=14.FIELDSIZE():elink.
.br
:h2 id=HARBY res=16.THtml()
:i2 refid=HARBOX.THTML()
:p.THtml&lpar.&rpar.
.br
.br
:hp2.Html Class:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.oHtml&colon.&eq.THtml&lpar.&rpar.&colon.New&lpar.<cFile>&rpar. &minus.&minus.> oHtm:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<cFile>:ehp2.  Name of the Html file to create
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<oHtm>:ehp2.  An  instance of the THtml Class
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.THtml&lpar.&rpar. is a class that creates an .html file of the same  name you pass to the constructor.
:p.The class methods are as follows&colon.
:p.New&lpar.<cFile>&rpar.         Create a new instance of the THtml class
:p.Close&lpar.&rpar.              Close the created file
:p.WriteTitle&lpar.<cTitle>&rpar. Write the file title
:p.WritePar&lpar.<cPar>&rpar.     Writes a paragraph
:p.WriteParBold&lpar.<cPar>&rpar. Same as WritePar&lpar.&rpar.&comma. but the text is bold
:p.WriteLink&lpar.<cLink>&comma.<cName>&rpar.  Write a link to another topic
:p.WriteText&lpar.<cText>&rpar.   Write any text
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION MAIN&lpar.&rpar.
.br

.br
      LOCAL oHtm
.br

.br
      oHtm &colon.&eq. THTML&lpar.&rpar.&colon.New&lpar. &cdq.www\harbour.html&cdq. &rpar.
.br
      oHtm&colon.WriteTitle&lpar. &cdq.Harbour Reference Guide&cdq. &rpar.
.br
      oHtm&colon.WritePar&lpar. &cdq.HARBOUR&cdq. &rpar.
.br
      oHtm&colon.WriteLink&lpar. &cdq.OverView&cdq. &rpar.
.br
      oHtm&colon.WriteLink&lpar. &cdq.License&cdq. &rpar.
.br
      oHtm&colon.WriteLink&lpar. &cdq.http&colon.&slash.&slash.www.gnu.org&slash.copyleft&slash.gpl&cdq. &rpar.
.br
      oHtm&colon.WritePar&lpar. &cdq.See the Links Above&cdq. &rpar.
.br
      oHtm&colon.Close&lpar.&rpar.
.br
      RETURN Nil
.br
  </par>
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This is a new Harbour Tools class
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.ALL
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=2.TCLASS():elink.
.br
:h2 id=HARBY res=17.TOs2()
:i2 refid=HARBOX.TOS2()
:p.TOs2&lpar.&rpar.
.br
.br
:hp2.OS&slash.2 Documentation Class:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.oNg&colon.&eq.TOs2&lpar.&rpar.&colon.New&lpar.<cFile>&rpar. &minus.&minus.> oOs2:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<cFile>:ehp2.  Name of the IPF Source file to create
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<oOs2>:ehp2.  An instance of the TOs2 Class
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.TOs2&lpar.&rpar. is a class that creates the OS&slash.2 IPF Source  of the same name you pass to the constructor.
:p.The class methods are as follows&colon.
:p.New&lpar.<cFile>&rpar.          Create a new instance of the TOs2 class
:p.Close&lpar.&rpar.               Close the created file
:p.WriteTitle&lpar.<cTopic>&comma.<cTitle>&rpar.  Write the file title
:p.WritePar&lpar.<cPar>&rpar.      Write a paragraph
:p.WriteParBold&lpar.<cPar>&rpar.  Same as WritePar&lpar.&rpar.&comma. but the text is bold
:p.WriteLink&lpar.<cLink>&rpar.    Write a link to another topic
:p.ScanLink&lpar.<clink>&rpar.     Scan the aLinkRef array for a valid topic
:p.DosToOs2Text&lpar.<cText>&rpar. Convert a Dos string to a OS&slash.2 String
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION MAIN&lpar.&rpar.
.br

.br
      LOCAL oNg
.br

.br
      oNg &colon.&eq. TOs2&lpar.&rpar.&colon.New&lpar. &cdq.ngi\harbour.ngi&cdq. &rpar.
.br
      oNg&colon.WriteTitle&lpar. &cdq.Harbour Reference Guide&cdq. &rpar.
.br
      oNg&colon.WritePar&lpar. &cdq.HARBOUR&cdq. &rpar.
.br
      oNg&colon.WriteLink&lpar. &cdq.OverView&cdq. &rpar.
.br
      oNg&colon.WriteLink&lpar. &cdq.License&cdq. &rpar.
.br

.br
      oNg&colon.WritePar&lpar. &cdq.See the Links Above&cdq. &rpar.
.br
      oNg&colon.Close&lpar.&rpar.
.br
      RETURN Nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This is a new Harbour Tools class
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.ALL
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=18.TNORTONGUIDE():elink.
.br
:h2 id=HARBY res=18.TNortonGuide()
:i2 refid=HARBOX.TNORTONGUIDE()
:p.TNortonGuide&lpar.&rpar.
.br
.br
:hp2.Norton Guide Class:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.oNg&colon.&eq.TNortonGuide&lpar.&rpar.&colon.New&lpar.<cFile>&rpar. &minus.&minus.> oNg:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<cFile>:ehp2.  Name of the Ng Source file to create
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<oNg>:ehp2.  An instance of the TNortonGuide Class
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.TNortonGuide&lpar.&rpar. is a class that creates the Norton Guide Source  Code of the same name you pass to the constructor.
:p.The class methods are as follows&colon.
:p.New&lpar.<cFile>&rpar.         Create an instance of the TNortonGuide class
:p.Close&lpar.&rpar.              Close the created file
:p.WriteTitle&lpar.<cTopic>&comma.<cTitle>&rpar.  Write the file title
:p.WritePar&lpar.<cPar>&rpar.     Write a paragraph
:p.WriteParBold&lpar.<cPar>&rpar. Same as WritePar&lpar.&rpar.&comma. but the text is bold
:p.WriteLink&lpar.<cLink>&rpar.   Write a link to another topic
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION MAIN&lpar.&rpar.
.br

.br
      LOCAL oNg
.br

.br
      oNg &colon.&eq. TNortonGuide&lpar.&rpar.&colon.New&lpar. &cdq.ngi\harbour.ngi&cdq. &rpar.
.br
      oNg&colon.WriteTitle&lpar. &cdq.Harbour Reference Guide&cdq. &rpar.
.br
      oNg&colon.WritePar&lpar. &cdq.HARBOUR&cdq. &rpar.
.br
      oNg&colon.WriteLink&lpar. &cdq.OverView&cdq. &rpar.
.br
      oNg&colon.WriteLink&lpar. &cdq.License&cdq. &rpar.
.br

.br
      oNg&colon.WritePar&lpar. &cdq.See the Links Above&cdq. &rpar.
.br
      oNg&colon.Close&lpar.&rpar.
.br
      RETURN Nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This is a new Harbour Tools class
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.ALL
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=19.TTROFF():elink.
.br
:link reftype=hd res=20.TRTF():elink.
.br
:link reftype=hd res=16.THTML():elink.
.br
:link reftype=hd res=17.TOS2():elink.
.br
:h2 id=HARBY res=20.TRtf()
:i2 refid=HARBOX.TRTF()
:p.TRtf&lpar.&rpar.
.br
.br
:hp2.Rtf Class:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.oNg&colon.&eq.TRtf&lpar.&rpar.&colon.New&lpar.<cFile>&rpar. &minus.&minus.> oRtf:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<cFile>:ehp2.  Name of the RTF file to create
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<oRtf>:ehp2.  An  instance of the TRtf Class
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.TRtf&lpar.&rpar. is a class that creates the RTF Documentation Source  Code of the same name you pass to the constructor.
:p.The class methods are as follows&colon.
:p.New&lpar.<cFile>&rpar.         Create a new instance of the TRtf class
:p.Close&lpar.&rpar.              Close the create file
:p.WriteTitle&lpar.<cTopic>&comma.<cTitle>&rpar.  Write the file title
:p.WritePar&lpar.<cPar>&rpar.     Write a paragraph
:p.WriteParBold&lpar.<cPar>&rpar. Same as WritePar&lpar.&rpar.&comma. but the text is bold
:p.WriteLink&lpar.<cLink>&rpar.   Write a link to another topic
:p.WriteHeader&lpar.&rpar.        Write the RTF header
:p.EndPar&lpar.&rpar.             Write the end paragraph delimiter
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION MAIN&lpar.&rpar.
.br

.br
      LOCAL oRtf
.br

.br
      oRtf &colon.&eq. TRtf&lpar.&rpar.&colon.New&lpar. &cdq.rtf\harbour.rtf&cdq. &rpar.
.br
      oRtf&colon.WriteHeader&lpar.&rpar.
.br
      oRtf&colon.WriteTitle&lpar. &cdq.Harbour Reference Guide&cdq. &rpar.
.br
      oRtf&colon.WritePar&lpar. &cdq.HARBOUR&cdq. &rpar.&colon.Endpar&lpar.&rpar.
.br
      oRtf&colon.WriteLink&lpar. &cdq.OverView&cdq. &rpar.
.br
      oRtf&colon.WriteLink&lpar. &cdq.License&cdq. &rpar.
.br

.br
      oRtf&colon.WritePar&lpar. &cdq.See the Links Above&cdq. &rpar.&colon.EndPar&lpar.&rpar.
.br
      oRtf&colon.Close&lpar.&rpar.
.br
      RETURN Nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This is a new Harbour Tools class
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.ALL
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=18.TNORTONGUIDE():elink.
.br
:h2 id=HARBY res=19.TTroff()
:i2 refid=HARBOX.TTROFF()
:p.TTroff&lpar.&rpar.
.br
.br
:hp2.Troff Class:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.oTroff&colon.&eq.TTrof&lpar.&rpar.&colon.New&lpar.<cFile>&rpar. &minus.&minus.> oTrf:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<cFile>:ehp2.  Name of the Troff file to create
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<oTrf>:ehp2.   instance of the TTroff Class
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.TTroff&lpar.&rpar. is a class that creates the TROFF Documentation Source  Code of the same name you pass to the constructor.
:p.The class methods are as follows&colon.
:p.New&lpar.<cFile>&rpar.         Create a new instance of the THtml class  Close&lpar.&rpar.              Close the created file
:p.WriteTitle&lpar.<cTopic>&comma.<cTitle>&rpar. Write the file title
:p.WritePar&lpar.<cPar>&rpar.     Write a paragraph
:p.WriteParBold&lpar.<cPar>&rpar. Same as WritePar&lpar.&rpar.&comma. but the text is bold
:p.WriteLink&lpar.<cLink>&rpar.   Write a link to another topic
:p.WriteText&lpar.&rpar.          Writes text without formating
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION MAIN&lpar.&rpar.
.br

.br
      LOCAL oTroff
.br
      oTroff &colon.&eq. TTroff&lpar.&rpar.&colon.New&lpar. &cdq.tr\harbour.ngi&cdq. &rpar.
.br
      oTroff&colon.WriteTitle&lpar. &cdq.Harbour Reference Guide&cdq. &rpar.
.br
      oTroff&colon.WritePar&lpar. &cdq.HARBOUR&cdq. &rpar.
.br
      oTroff&colon.WriteLink&lpar. &cdq.OverView&cdq. &rpar.
.br
      oTroff&colon.WriteLink&lpar. &cdq.License&cdq. &rpar.
.br

.br
      oTroff&colon.WritePar&lpar. &cdq.See the Links Above&cdq. &rpar.
.br
      oTroff&colon.Close&lpar.&rpar.
.br

.br
      RETURN Nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This is a new Harbour Tools class
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.ALL
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=18.TNORTONGUIDE():elink.
.br
:h1 DOSY.DOS TOOLS
:h2  res=21.CD()
:i1 id=DOS TX.DOS TOOLS
:i2 refid=DOS TX.CD()
:p.CD&lpar.&rpar.
.br
.br
:hp2.Change the Current Directory:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.CD&lpar.<cDir>&rpar. &minus.&minus.> lSuccess:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cDir> DIR TO BE CHANGED
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lSucess> .T. IF SUCESSFUL&semi. otherwise .F.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.CHANGE THE CURRENT DIRECTORY
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      IF CD&lpar.&cdq.OLA&cdq.&rpar.
.br
         RETURN&lpar..T.&rpar.
.br
      ELSE
.br
         RETURN&lpar..F.&rpar.
.br
      ENDIF
.br
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Header is Fileio.ch
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=22.MD():elink.
.br
:link reftype=hd res=23.RD():elink.
.br
:h2 id=DOSY res=22.MD()
:i2 refid=DOS TX.MD()
:p.MD&lpar.&rpar.
.br
.br
:hp2.Creates a Directory:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.MD&lpar.<cDir>&rpar. &minus.> <lSucess>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cDir> DIRECTORY TO BE CREATED
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lSucess> .T. IF SUCESSFUL&semi. otherwise .F.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.CREATE A  DIRECTORY
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      IF MD&lpar.&cdq.OLA&cdq.&rpar.
.br
        RETURN&lpar..T.&rpar.
.br
      ELSE
.br
        RETURN&lpar..F.&rpar.
.br
      ENDIF
.br
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Header is Fileio.ch
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=21.CD():elink.
.br
:link reftype=hd res=22.MD():elink.
.br
:h2 id=DOSY res=23.RD()
:i2 refid=DOS TX.RD()
:p.RD&lpar.&rpar.
.br
.br
:hp2.Remove a Directory:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.RD&lpar.<cDir>&rpar. &minus.&minus.> <lSucess>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cDir> DIR TO BE DELETED
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lSucess> .T. IF SUCESSFUL&semi. otherwise .F.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.REMOVE A  DIRECTORY
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
     IF RD&lpar.&cdq.OLA&cdq.&rpar.
.br
       RETURN&lpar..T.&rpar.
.br
     ELSE
.br
       RETURN&lpar..F.&rpar.
.br
     ENDIF
.br
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Header is Fileio.ch
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=21.CD():elink.
.br
:link reftype=hd res=22.MD():elink.
.br
:h1 STRIY.STRING TOOLS
:h2  res=24.StrFormat()
:i1 id=STRINX.STRING TOOLS
:i2 refid=STRINX.STRFORMAT()
:p.StrFormat&lpar.&rpar.
.br
.br
:hp2.Format a string:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.StrFormat&lpar.<cMask>&lbrk.&comma. <cPar1>&lbrk.&comma. <cParn>&lbrk.&comma. ...&rbrk..&rbrk..&rpar. &minus.&minus.> cString:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<cMask>:ehp2.  Holds the mask for the resulting string
:p.<cParn> Holds the strings to be inserted in the mask  maximum 9 of them can be specified.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<cString>:ehp2.  Return the mask with all the parameters inserted.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.String replacment&comma. can be useful when writing international  apps. You can separate the constant strings from the variable ones.  Each %1 &minus. %9 marks will be replaced with the appropriate parameter  from the parameter
list.
:p.Marks can be in any order&comma. and can be duplicated.
:p.You can print &cdq.%&cdq. character with &cdq.%%&cdq..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      StrFormat&lpar.&cdq.Please insert disk %1 to drive %2&cdq.&comma. LTrim&lpar.Str&lpar.2&rpar.&rpar.&comma. &cdq.A&colon.&cdq.&rpar.
.br
      StrFormat&lpar.&cdq.This is %1 from %2&cdq.&comma. &cdq.Victor&cdq.&comma. &cdq.Hungary&cdq.&rpar.
.br
      StrFormat&lpar.&cdq.%2 %1 %2&cdq.&comma. &cdq.Param1&cdq.&comma. &cdq.Param2&cdq.&rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      ? StrFormat&lpar.&cdq.Please insert disk %1 to drive %2&cdq.&comma. LTrim&lpar.Str&lpar.2&rpar.&rpar.&comma. &cdq.A&colon.&cdq.&rpar.
.br
      ? StrFormat&lpar.&cdq.This is %1 from %2&cdq.&comma. &cdq.Victor&cdq.&comma. &cdq.Hungary&cdq.&rpar.
.br
      ? StrFormat&lpar.&cdq.%2 %1 %2&cdq.&comma. &cdq.Param1&cdq.&comma. &cdq.Param2&cdq.&rpar.
.br
      ? StrFormat&lpar.&cdq.Hello&cdq.&rpar.
.br
      ? StrFormat&lpar.&cdq.%1 &minus. %2&cdq.&comma. &cdq.one&cdq.&rpar.
.br
      ? StrFormat&lpar.&cdq.%1 &minus. %2&cdq.&comma. &cdq.one&cdq.&comma. &cdq.two&cdq.&rpar.
.br
      ? StrFormat&lpar.&cdq.%2 &minus. %1&cdq.&comma. &cdq.one&cdq.&comma. &cdq.two&cdq.&rpar.
.br
      ? StrFormat&lpar.&cdq.%2 &minus. %&cdq.&comma. &cdq.one&cdq.&comma. &cdq.two&cdq.&rpar.
.br
      ? StrFormat&lpar.&cdq.%% &minus. %&cdq.&comma. &cdq.one&cdq.&comma. &cdq.two&cdq.&rpar.
.br
      ? StrFormat&lpar.&cdq.%9 &minus. %&cdq.&comma. &cdq.one&cdq.&comma. &cdq.two&cdq.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Done
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.All platforms
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
:h1 DATEY.DATE
:h2  res=25.AMONTHS()
:i1 id=DATEX.DATE
:i2 refid=DATEX.AMONTHS()
:p.AMONTHS&lpar.&rpar.
.br
.br
:hp2.Returns an array with the months names.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.AMONTHS&lpar.&rpar.  &minus.&minus.> aMonths:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<aMonths> The array which holds the months names.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns an array with all the months names in the  selected current language.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      aMonths &colon.&eq. AMonths&lpar.&rpar.
.br
      ? aMonths&lbrk.1&rbrk.. &minus.> January
.br
      ? aMonths&lbrk.1&rbrk.. &minus.> Enero &lpar.if the selected language is Spanish&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is new in Harbour.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=26.ADAYS():elink.
.br
:h2 id=DATEY res=26.ADAYS()
:i2 refid=DATEX.ADAYS()
:p.ADAYS&lpar.&rpar.
.br
.br
:hp2.Returns an array with the days names.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ADAYS&lpar.&rpar.  &minus.&minus.> aDays:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<aDays>   The array which holds the days names.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns an array with all the days names in the  selected current language.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      aDays &colon.&eq. ADays&lpar.&rpar.
.br
      ? aDays&lbrk.1&rbrk.. &minus.> Sunday
.br
      ? aDays&lbrk.1&rbrk.. &minus.> Domingo &lpar.if the selected language is Spanish&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is new in Harbour.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=26.ADAYS():elink.
.br
:h2 id=DATEY res=27.ISLEAPYEAR()
:i2 refid=DATEX.ISLEAPYEAR()
:p.ISLEAPYEAR&lpar.&rpar.
.br
.br
:hp2.Checks if the given date is a leap year.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ISLEAPYEAR&lpar. <dDate> &rpar.  &minus.&minus.> lTrueOrFalse:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<dDate>   A valid date.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lTrueOrFalse>  A logical that indicates if the date year is leap
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns true if the given date is a leap year and  false if isn't.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? IsLeapYear&lpar. DToC&lpar. &cdq.01&slash.01&slash.2000&cdq. &rpar. &rpar. &minus.> .t.
.br
      ? IsLeapYear&lpar. DToC&lpar. &cdq.01&slash.01&slash.2001&cdq. &rpar. &rpar. &minus.> .f.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is new in Harbour.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=28.DAYSINMONTH():elink.
.br
:h2 id=DATEY res=28.DAYSINMONTH()
:i2 refid=DATEX.DAYSINMONTH()
:p.DAYSINMONTH&lpar.&rpar.
.br
.br
:hp2.Gets the days in a month.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DAYSINMONTH&lpar. <dDate> &rpar.  &minus.&minus.> nDays:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<dDate>   A valid date.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nDays>   The number of days of the month.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the number of days of the given date month.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? DaysInMonth&lpar. DToC&lpar. &cdq.01&slash.01&slash.2000&cdq. &rpar. &rpar. &minus.> 31
.br
      ? DaysInMonth&lpar. DToC&lpar. &cdq.02&slash.01&slash.2000&cdq. &rpar. &rpar. &minus.> 29
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is new in Harbour.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=27.ISLEAPYEAR():elink.
.br
:h2 id=DATEY res=29.EOM()
:i2 refid=DATEX.EOM()
:p.EOM&lpar.&rpar.
.br
.br
:hp2.Gets the last day in a month.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.EOM&lpar. <dDate> &rpar.  &minus.&minus.> dEOM:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<dDate>   A valid date.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<dEOM>    The last day in the month.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the last day of a given month date.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? EOM&lpar. DToC&lpar. &cdq.01&slash.01&slash.2000&cdq. &rpar. &rpar. &minus.> &cdq.01&slash.31&slash.2000&cdq.
.br
      ? EOM&lpar. DToC&lpar. &cdq.02&slash.01&slash.2000&cdq. &rpar. &rpar. &minus.> &cdq.01&slash.29&slash.2000&cdq.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is new in Harbour.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=30.BOM():elink.
.br
:link reftype=hd res=31.WOM():elink.
.br
:h2 id=DATEY res=30.BOM()
:i2 refid=DATEX.BOM()
:p.BOM&lpar.&rpar.
.br
.br
:hp2.Gets the first day in a month.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.BOM&lpar. <dDate> &rpar.  &minus.&minus.> dBOM:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<dDate>   A valid date.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<dBOM>    The first day in the month.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the first day of a given month date.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? BOM&lpar. DToC&lpar. &cdq.01&slash.25&slash.2000&cdq. &rpar. &rpar. &minus.> &cdq.01&slash.01&slash.2000&cdq.
.br
      ? BOM&lpar. DToC&lpar. &cdq.02&slash.24&slash.2000&cdq. &rpar. &rpar. &minus.> &cdq.02&slash.01&slash.2000&cdq.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is new in Harbour.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=29.EOM():elink.
.br
:link reftype=hd res=31.WOM():elink.
.br
:h2 id=DATEY res=32.DOY()
:i2 refid=DATEX.DOY()
:p.DOY&lpar.&rpar.
.br
.br
:hp2.Gets the day number of the year.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DOY&lpar. <dDate> &rpar.  &minus.&minus.> nDay:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<dDate>   A valid date.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nDay>    The day number
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the day number of the year for a given date.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? DOY&lpar. DToC&lpar. &cdq.01&slash.31&slash.2000&cdq. &rpar. &rpar. &minus.> 31
.br
      ? DOY&lpar. DToC&lpar. &cdq.02&slash.20&slash.2000&cdq. &rpar. &rpar. &minus.> 51
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is new in Harbour.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=33.WOY():elink.
.br
:h2 id=DATEY res=33.WOY()
:i2 refid=DATEX.WOY()
:p.WOY&lpar.&rpar.
.br
.br
:hp2.Gets the week number of the year.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.WOY&lpar. <dDate>&comma. <lIso> &rpar.  &minus.&minus.> nWeek:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<dDate>   A valid date.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nWeek>   The week number  <lIso>    Flag that indicates if <nWeek> is in ISO format.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the week number of the year for a given date.  It returns the week number in ISO format &lpar. range 0 &minus. 52&comma. by default  or passing TRUE as second parameter&rpar. or 1 &minus. 52 if lIso is
FALSE.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? WOY&lpar. DToC&lpar. &cdq.01&slash.31&slash.2000&cdq. &rpar. &rpar. &minus.> 3
.br
      ? WOY&lpar. DToC&lpar. &cdq.01&slash.31&slash.2000&cdq. &rpar.&comma. FALSE &rpar. &minus.> 4
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is new in Harbour.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=32.DOY():elink.
.br
:h2 id=DATEY res=34.EOY()
:i2 refid=DATEX.EOY()
:p.EOY&lpar.&rpar.
.br
.br
:hp2.Gets the last date of the year.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.EOY&lpar. <dDate> &rpar.  &minus.&minus.> dEOY:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<dDate>   A valid date.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<dEOY>    The last date of the year.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the last date of a given year date.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? EOY&lpar. DToC&lpar. &cdq.01&slash.01&slash.2000&cdq. &rpar. &rpar. &minus.> &cdq.31&slash.12&slash.2000&cdq.
.br
      ? EOY&lpar. DToC&lpar. &cdq.01&slash.01&slash.2001&cdq. &rpar. &rpar. &minus.> &cdq.31&slash.12&slash.2001&cdq.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is new in Harbour.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=35.BOY():elink.
.br
:h2 id=DATEY res=35.BOY()
:i2 refid=DATEX.BOY()
:p.BOY&lpar.&rpar.
.br
.br
:hp2.Gets the first date of the year.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.BOY&lpar. <dDate> &rpar.  &minus.&minus.> dBOY:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<dDate>   A valid date.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<dBOY>    The first day in the year.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the first date of a given year date.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? BOY&lpar. DToC&lpar. &cdq.01&slash.25&slash.2000&cdq. &rpar. &rpar. &minus.> &cdq.01&slash.01&slash.2000&cdq.
.br
      ? BOY&lpar. DToC&lpar. &cdq.02&slash.24&slash.2001&cdq. &rpar. &rpar. &minus.> &cdq.01&slash.01&slash.2001&cdq.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is new in Harbour.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libmisc
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=34.EOY():elink.
.br
:h1 ZIPY.ZIP FUNCTION
:h2  res=36.HB_ZIPFILE()
:i1 id=ZIP FX.ZIP FUNCTION
:i2 refid=ZIP FX.HB_ZIPFILE()
:p.HB&us.ZIPFILE&lpar.&rpar.
.br
.br
:hp2.Create a zip file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.ZIPFILE&lpar. <cFile> &comma. <cFileToCompress> &splitvbar. <aFiles>&comma. <nLevel> &comma.:ehp2.
:p.:hp2.<bBlock>&comma.<lOverWrite> &rpar. &minus.&minus.&minus.> lCompress:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFile>   Name of the zip file
.br
:p.<cFileToCompress>  Name of a file to Compress&comma. Drive and&slash.or path  can be used
.br
:p.<aFiles>  An array containing files to compress&comma. Drive and&slash.or path  can be used
.br
:p.<nLevel>  Compression level ranging from 0 to 9
.br
:p.<bBlock>  Code block to execute while compressing
.br
:p.<lOverWrite>  Toggle to overwite the file if exists
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lCompress>  .t. if file was create&comma. otherwise .f.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function creates a zip file named <cFile>. If the extension  is ommited&comma. .ZIP will be assumed. If the second parameter is a  character string&comma. this file will be added to the zip file. If the  second parameter is
an array&comma. all file names contained in <aFiles>  will be compressed.
.br
:p.If <nLevel> is used&comma. it detemines the compression type where 0 means  no compression and 9 means best compression.
.br
:p.If <bBlock> is used&comma. every time the file is opened to compress it  will evaluate bBlock. Parameters of bBlock are cFile and nPos.
.br
:p.If <lOverWrite> is used &comma. it toggles to overwrite or not the existing  file. Default is to overwrite the file.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION MAIN&lpar.&rpar.
.br

.br
      IF HB&us.ZIPFILE&lpar. &cdq.TEST.ZIP&cdq.&comma.&cdq.TEST.PRG&cdq.&rpar.
.br
         qout&lpar.&cdq.File was successly create&cdq.&rpar.
.br
      ENDIF
.br

.br
      IF HB&us.ZIPFILE&lpar. &cdq.TEST1.ZIP&cdq.&comma.&lbrc.&cdq.TEST.PRG&cdq.&comma.&cdq.c&colon.\windows\win.ini&cdq.&rbrc.&rpar.
.br
         qout&lpar.&cdq.File was successly create&cdq.&rpar.
.br
      ENDIF
.br

.br
      IF HB&us.ZIPFILE&lpar. &cdq.TEST2.ZIP&cdq.&comma.&lbrc.&cdq.TEST.PRG&cdq.&comma.&cdq.c&colon.\windows\win.ini&cdq.&rbrc.&comma.8&comma.&lbrc.&splitvbar.nPos&comma.cFile&splitvbar.&comma.qout&lpar.cFile&rpar.&rbrc.&rpar.
.br
         qout&lpar.&cdq.File was successly create&cdq.&rpar.
.br
      ENDIF
.br

.br
      aFiles &colon.&eq. &lbrc.&cdq.TEST.PRG&cdq.&comma.&cdq.c&colon.\windows\win.ini&cdq.&rbrc.
.br
      nLen   &colon.&eq. Len&lpar.afiles&rpar.
.br
      aGauge &colon.&eq. GaugeNew&lpar. 5&comma. 5&comma. 7&comma.40 &comma. &cdq.W&slash.B&cdq.&comma. &cdq.W+&slash.B&cdq. &comma.''&rpar.
.br
      GaugeDisplay&lpar. aGauge &rpar.
.br
      Hb&us.ZIPFILE&lpar.'test33.zip'&comma.aFiles&comma.8&comma.&lbrc.&splitvbar.cFile&comma.nPos&splitvbar. GaugeUpdate&lpar.aGauge&comma.nPos&slash.nLen&rpar.&rbrc.&rpar.
.br
      Return Nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is zlib.lib and zlib&us.bor.lib For Borland Compilers  Library is zlib.lib zlib&us.ms.lib for MSVC compilers
:h2 id=ZIPY res=37.HB_UNZIPFILE()
:i2 refid=ZIP FX.HB_UNZIPFILE()
:p.HB&us.UNZIPFILE&lpar.&rpar.
.br
.br
:hp2.Unzip a compressed file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.UNZIPFILE&lpar. <cFile> &comma. <bBlock> &comma. <lWithPath>&rpar. &minus.&minus.&minus.> lCompress:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFile>   Name of the zip file
.br
:p.<bBlock>  Code block to execute while compressing
.br
:p.<lWithPath> Toggle to create directory if needed
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lCompress>  .t. if all file was successfuly restored&comma. otherwise .f.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function restores all files contained inside the <cFile>.  If the extension is ommited&comma. .ZIP will be assumed. If a file already  exists&comma. it wlll be overwriten.
.br
:p.If <bBlock> is used&comma. every time the file is opened to compress it  will evaluate bBlock. Parameters of bBlock are cFile and nPos.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION MAIN&lpar.&rpar.
.br

.br
      IF HB&us.UNZIPFILE&lpar. &cdq.TEST.ZIP&cdq.&rpar.
.br
         qout&lpar.&cdq.File was successly create&cdq.&rpar.
.br
      ENDIF
.br

.br
      IF HB&us.ZIPFILE&lpar. &cdq.TEST2.ZIP&cdq.&comma.&lbrc.&splitvbar.cFile&splitvbar.&comma.qout&lpar.cFile&rpar.&rbrc.&rpar.
.br
         qout&lpar.&cdq.File was successly create&cdq.&rpar.
.br
      ENDIF
.br

.br
      Return Nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is zlib.lib and zlib&us.bor.lib For Borland Compilers  Library is zlib.lib zlib&us.ms.lib for MSVC compilers
:h2 id=ZIPY res=38.HB_GETUNZIPFILE()
:i2 refid=ZIP FX.HB_GETUNZIPFILE()
:p.HB&us.GETUNZIPFILE&lpar.&rpar.
.br
.br
:hp2.Gets the number of files that are in the zipfile:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.GETUNZIPFILE&lpar. <cFile>&rpar. &minus.&minus.&minus.> nNumber:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFile>   Name of the zip file
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nNumber>  The number of files contained inside the zipfile
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the number of files that is stored in the zipfile.  The purpose for this function is to use in conjuntion with the  HB&us.UNZIPFILE&lpar.&rpar. function&comma. so you can use returned result in the code
block. See example below.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION MAIN&lpar.&rpar.
.br
      Local nFiles &colon.&eq.HB&us.GETUNZIPFILE&lpar.'test.zip'&rpar.
.br

.br
      if nFiles >0
.br
         ? &cdq.This files Contains &cdq.&comma.nfiles
.br
      endif
.br

.br
      Return Nil
.br

.br
      Here is an example of How to use HB&us.GETUNZIPFILE&lpar.&rpar. in conjunction
.br
      with HB&us.UNZIPFILE&lpar.&rpar.
.br

.br
      Function Main&lpar.&rpar.
.br
      Local aGauge&comma.nLen
.br

.br
      aGauge &colon.&eq. GaugeNew&lpar. 5&comma. 5&comma. 7&comma.40 &comma. &cdq.W&slash.B&cdq.&comma. &cdq.W+&slash.B&cdq. &comma.''&rpar.
.br
      GaugeDisplay&lpar. aGauge &rpar.
.br
      nLen &colon.&eq. HB&us.GETUNZIPFILE&lpar.'test22'&rpar.
.br
      hb&us.UNZIPFILE&lpar.'test22'&comma.&lbrc.&splitvbar.cFile&comma.nPos&splitvbar. GaugeUpdate&lpar.aGauge&comma.nPos&slash.nLen&rpar.&comma.qout&lpar.cFile&rpar.&rbrc.&comma..t.&rpar.
.br

.br
      Return Nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is zlib.lib and zlib&us.bor.lib For Borland Compilers  Library is zlib.lib zlib&us.ms.lib for MSVC compilers
:h1 DOCUY.DOCUMENT
:h2  res=39.OVERVIEW
:i1 id=DOCUMX.DOCUMENT
:i2 refid=DOCUMX.OVERVIEW
:p.OVERVIEW
.br
.br
:hp2.HARBOUR Read me:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
.br
:p.:hp2.The Harbour project:ehp2.
.br
:p.:hp2.************************************************************************:ehp2.
:p.:hp2.*  This file contains information on obtaining&comma. installing&comma. and using  *:ehp2.
:p.:hp2.*  Harbour. Please read it *completely* before asking for help.        *:ehp2.
:p.:hp2.************************************************************************:ehp2.
.br
:p.Harbour is a free implementation of an xBase language compiler. It is  designed to be source code compatible with the CA&minus.Clipper&lpar.r&rpar. compiler.  That means that if you've got some code that would compile using
CA&minus.Clipper&lpar.r&rpar. then it should compile under Harbour. The Harbour&minus.Project  web page is&colon.
:p.:hp2.http:&slash.&slash.www.Harbour&minus.Project.org&slash.:ehp2.
.br
.br
:p.Status and other information is always available from the web site.  There is a Harbour mailing list. Harbour is still at a very early  stage of development&comma. so the mailing list is very much a Developers  only list&comma.
although every body is welcome to join in the discussions.
.br
:p.We would like you to join the Harbour development team. If you are  interested you may suscribe to our mailing list and start contributing  to this free public project.
.br
:p.Please feel free to report all questions&comma. ideas&comma. suggestions&comma. fixes&comma.  code&comma. etc. you may need and want. With the help of all of you&comma. the Harbour  compiler and runtime libraries will become a
reality very soon.
.br
.br
:p.:hp2.What this distribution contains:ehp2.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.This distribution is a Source code only distribution. It does not contain  any executable files. Executable versions of Harbour are available from  the web site. Executable versions of Harbour DO NOT create runable  programs.
Harbour at the moment produces C output code&comma. which must be  compiled with the Harbour Virtual Machine and the support libraries  in order to create a functioning program.
:p.Please test running Harbour against your Clipper source code and report  any problems that might occur.
.br
:p.Very important&colon. The preprocessor functionality is now working.
.br
:p.:hp2.Installation:ehp2.
:p.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
.br
:p.1. Unzip with Harbour zip file using pkunzip or equivalent.
:p.E.G. pkunzip &minus.d build72.zip
:p.This will create Harbour&slash. directory and all the relevant sub  directories.
.br
:p.2. Compile Harbour using your C compiler. Make files for different  platforms are included in the <WHERE ARE THEY?> directory.
.br
.br
:p.:hp2.&minus.&minus.&minus. COPYRIGHT &minus.&minus.&minus.:ehp2.
.br
:p.What copyright information do we have
.br
.br
:p.:hp2.&minus.&minus.&minus. LICENCE &minus.&minus.&minus.:ehp2.
.br
:p.Information about the License for usage of Harbour is available in the  file LICENCE.TXT &lpar.when we have a license&rpar.
.br
:p.:hp2.&minus.&minus.&minus. DISCLAIMER &minus.&minus.&minus.:ehp2.
.br
:p.Participants of The Harbour Project assume no responsibility for errors or  omissions in these materials.
.br
:p.:hp2.THESE MATERIALS ARE PROVIDED &cdq.AS IS&cdq. WITHOUT WARRANTY OF ANY KIND&comma. EITHER  EXPRESS OR IMPLIED&comma. INCLUDING BUT NOT LIMITED TO&comma. THE IMPLIED WARRANTIES  OF MERCHANTABILITY&comma. FITNESS FOR A
PARTICULAR PURPOSE&comma. OR NON&minus.INFRINGEMENT.:ehp2.
.br
:p.Participants of The Harbour Project further do not warrant the accuracy or  completeness of the code&comma. information&comma. text&comma. output or any other items  contained within these materials. Participants of The Harbour
Project  shall not be liable for any special&comma. direct&comma. indirect&comma. incidental&comma. or  consequential damages&comma. including without limitation&comma. lost revenues or  lost profits&comma. which may result from
the use or mis&minus.use of these materials.
.br
:p.The information in The Harbour Project is subject to change without notice  and does not represent any future commitment by the participants of The  Harbour Project.
.br
:p.The Harbour Project
.br
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=40.LICENSE:elink.
.br
:h2 id=DOCUY res=40.License
:i2 refid=DOCUMX.LICENSE
:p.License
.br
.br
:hp2.Harbour License:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
.br
:p.:hp2.THE HARBOUR PROJECT LICENSE:ehp2.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.This program is free software&semi. you can redistribute it and&slash.or modify  it under the terms of the GNU General Public License as published by  the Free Software Foundation&semi. either version 2 of the License&comma. or
&lpar.at your option&rpar. any later version&comma. with one exception&colon.
.br
:p.The exception is that if you link the Harbour Runtime Library &lpar.HRL&rpar.  and&slash.or the Harbour Virtual Machine &lpar.HVM&rpar. with other files to produce  an executable&comma. this does not by itself cause the resulting
executable  to be covered by the GNU General Public License. Your use of that  executable is in no way restricted on account of linking the HRL  and&slash.or HVM code into it.
.br
:p.This program is distributed in the hope that it will be useful&comma.  but :hp2.WITHOUT ANY WARRANTY:ehp2.&semi. without even the implied warranty of  :hp2.MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE:ehp2..  See the  GNU
General Public License for more details.
.br
:p.You should have received a copy of the GNU General Public License  along with this program&semi. if not&comma. write to the Free Software  Foundation&comma. Inc.&comma. 675 Mass Ave&comma. Cambridge&comma. MA 02139&comma. USA
&lpar.or visit  their web site at http&colon.&slash.&slash.www.gnu.org&slash.&rpar..
.br
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=39.OVERVIEW:elink.
.br
:euserdoc.
