:userdoc.
:docprof toc=123456.
:title.Harbour Reference Guide
.* HBDOC generated IPF Source File.
.* HBDOC Document Source Extractor, (c)1999-2000 Luiz Rafael Culik.
:h1 STRIY.STRING TOOLS
:h2  res=1.GT_ASCPOS()
:i1 id=STRINX.STRING TOOLS
:i2 refid=STRINX.GT_ASCPOS()
:p.GT&us.ASCPOS&lpar.&rpar.
.br
.br
:hp2.Return the ascii value of a specified character in a string:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GT&us.Ascpos&lpar.<cStr>&comma. <nPos>&rpar. &minus.&minus.> nAscVal:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cStr>  &minus. The string  <nPos>  &minus. The position in <cStr>
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nAscVal> &minus. The ascii value of substr&lpar.<cStr>&comma. <nPos>&comma. 1&rpar.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Return the ascii value of a specified character in a string  Equivalent &lpar.but much faster&rpar. to  asc&lpar.substr&lpar.cStr&comma. nPos&comma. 1&rpar.
.br
:p.NOTE&colon.  invalid parameters will return &minus.1  nPos > len&lpar.cStr&rpar.   will return &minus.2
.br
:p.This last behaviour is different to the Funcky function of the  same name.  I changed the behaviour because some of the strings  I process contain embedded NULs.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
       ? gt&us.ascpos&lpar.&cdq.the cat sat on the mat&cdq.&comma. 3&rpar. &slash.&slash. prints e
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libgt
:h2 id=STRIY res=2.GT_ASCIISUM()
:i2 refid=STRINX.GT_ASCIISUM()
:p.GT&us.ASCIISUM&lpar.&rpar.
.br
.br
:hp2.Sum the ascii values in a string.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GT&us.AsciiSum&lpar.<cStr>&rpar. &minus.&minus.> nSum:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cStr>  &minus. The string to sum
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nSum>    &minus. The sum of all ascii values in <cStr>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Sum the ascii value of every character in the passed string  and return the result.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libgt
:h2 id=STRIY res=3.GT_ATDIFF()
:i2 refid=STRINX.GT_ATDIFF()
:p.GT&us.ATDIFF&lpar.&rpar.
.br
.br
:hp2.Return the position where two strings begin to differ:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GT&us.AtDiff&lpar.<cStr1>&comma. <cStr2>&rpar. &minus.&minus.> nPos:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cStr1>  &minus. A character string to compare  <cStr2>  &minus. The string to compare with
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nPos>     &minus. The position in <cStr2> where <cStr1> begins to differ
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Return the position in <cStr2> where <cStr1> begins to differ.  If the strings differ in the first character GT&us.AtDiff&lpar.&rpar. will  return 1.  If the two strings are identical &lpar.or identical upto  the last character
in <cStr2>&rpar. the function will return 0.
.br
:p.NOTE&colon.  invalid parameters will return &minus.1
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? gt&us.atDiff&lpar.&cdq.the cat&cdq.&comma. &cdq.the rat&cdq.&rpar.          &slash.&slash. prints 5
.br
      ? gt&us.atDiff&lpar.&cdq.the cat&cdq.&comma. &cdq.the &cdq.&rpar.             &slash.&slash. prints 0
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libgt
:h2 id=STRIY res=4.GT_CHAREVEN()
:i2 refid=STRINX.GT_CHAREVEN()
:p.GT&us.CHAREVEN&lpar.&rpar.
.br
.br
:hp2.Return a string of all the characters in even positions:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GT&us.CharEven&lpar.<cStr>&rpar. &minus.&minus.> cRet:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cStr>   &minus. A character string to extract chars from
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cRet>     &minus. A string of all the chars in even positions
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Return a string consisting of all the characters in even  positions in <cStr1>.
.br
:p.NOTE&colon.  invalid parameters will return &cdq.&cdq.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? gt&us.CharEven&lpar.&cdq.abcdefghijklm&cdq.&rpar.             &slash.&slash. prints &cdq.bdfhjl&cdq.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libgt
:h2 id=STRIY res=5.GT_CHARMIX()
:i2 refid=STRINX.GT_CHARMIX()
:p.GT&us.CHARMIX&lpar.&rpar.
.br
.br
:hp2.Amalgamate two strings to form the return value:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GT&us.CharMix&lpar.<cStr1>&comma. <cStr2>&rpar. &minus.&minus.> cRet:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cStr1>  &minus. A character string to mix  <cStr2>  &minus. A character string to mix with
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cRet>     &minus. A string consisting of all the characters in <cStr1>  mixed with all the characters in <cStr2>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Return a string consisting of all the characters in <cStr1>  mixed with the characters from <cStr2>.
.br
:p.NOTE&colon.  invalid parameters will return &cdq.&cdq.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? gt&us.CharMix&lpar.&cdq.abc&cdq.&comma. &cdq.123&cdq.&rpar.               &slash.&slash. prints &cdq.a1b2c3&cdq.
.br
      ? gt&us.CharMix&lpar.&cdq.abcde&cdq.&comma. &cdq.123&cdq.&rpar.             &slash.&slash. prints &cdq.a1b2c3de&cdq.
.br
      ? gt&us.CharMix&lpar.&cdq.abc&cdq.&comma. &cdq.12345&cdq.&rpar.             &slash.&slash. prints &cdq.a1b2c345&cdq.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libgt
:h2 id=STRIY res=6.GT_CHARODD()
:i2 refid=STRINX.GT_CHARODD()
:p.GT&us.CHARODD&lpar.&rpar.
.br
.br
:hp2.Return a string of all the characters in odd positions:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GT&us.CharOdd&lpar.<cStr>&rpar. &minus.&minus.> cRet:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cStr>   &minus. A character string to extract chars from
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cRet>     &minus. A string of all the chars in odd positions
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Return a string consisting of all the characters in odd  positions in <cStr1>.
.br
:p.NOTE&colon.  invalid parameters will return &cdq.&cdq.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? gt&us.CharOdd&lpar.&cdq.abcdefghijklm&cdq.&rpar.             &slash.&slash. prints &cdq.acegikm&cdq.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libgt
:h2 id=STRIY res=7.GT_CHRCOUNT()
:i2 refid=STRINX.GT_CHRCOUNT()
:p.GT&us.CHRCOUNT&lpar.&rpar.
.br
.br
:hp2.Count the number of times a character appears in a string:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GT&us.ChrCount&lpar.<cChr>&comma. <cStr>&rpar. &minus.&minus.> nFreq:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cChr>  &minus. The character to find the frequence of  <cStr>  &minus. The string in which to find the character
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.nFreq   &minus. The number of times <cChr> occurs in <cStr>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.GT&us.ChrCount&lpar.&rpar. counts how many times a specified character  appears in a string.
.br
:p.NOTE&colon.  invalid parameters will return &minus.1
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? GT&us.ChrCount&lpar.&cdq.t&cdq.&comma. &cdq.the cat sat on the mat&cdq.&rpar.      &slash.&slash. prints 4
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libgt
:h2 id=STRIY res=8.GT_CHRFIRST()
:i2 refid=STRINX.GT_CHRFIRST()
:p.GT&us.CHRFIRST&lpar.&rpar.
.br
.br
:hp2.Find which character occurs first in a string:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GT&us.ChrFirst&lpar.<cChars>&comma. <cStr>&rpar. &minus.&minus.> nAsc:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cChars> &minus. The set of characters to find  <cStr>   &minus. The input string
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nAsc>     &minus. The ASCII value of the first character in <cChars>  which appears first in <cStr>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Return the ascii value of a character in <cChars>  which appears first in <cStr>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? chr&lpar.GT&us.ChrFirst&lpar.&cdq.sa &cdq.&comma. &cdq.This is a test&cdq.&rpar.&rpar.  &slash.&slash. prints &cdq.s&cdq.
.br
      ? chr&lpar.GT&us.ChrFirst&lpar.&cdq.et&cdq.&comma.  &cdq.This is a test&cdq.&rpar.&rpar.   &slash.&slash. prints &cdq.t&cdq.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libgt
:h2 id=STRIY res=9.GT_CHRTOTAL()
:i2 refid=STRINX.GT_CHRTOTAL()
:p.GT&us.CHRTOTAL&lpar.&rpar.
.br
.br
:hp2.Find number of times a set of characters appears in a string:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GT&us.ChrTotal&lpar.<cChrs>&comma. <cStr>&rpar. &minus.&minus.> nTotOcc:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cChrs> &minus. The set of characters  <cStr>  &minus. The string to search
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nTotOcc> &minus. The number of times the characters specified in  <cChrs> appears in <cStr>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Returns the numnber of occurrences of characters belonging  to the set <cChrs> in the string <cStr>.  If no characters  in <cChrs> appears in <cStr> GT&us.ChrTotal&lpar.&rpar. will return 0.
.br
:p.NOTE&colon.  invalid parameters will return &minus.1
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
       local cStr1 &colon.&eq. &cdq.the cat sat on the mat&cdq.
.br

.br
       ? GT&us.ChrTotal&lpar.&cdq.tae&cdq.&comma. cStr1&rpar.            &slash.&slash. prints 10
.br
       ? GT&us.ChrTotal&lpar.&cdq.zqw&cdq.&comma. cStr1&rpar.            &slash.&slash. prints  0
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libgt
:h2 id=STRIY res=10.GT_STRCOUNT()
:i2 refid=STRINX.GT_STRCOUNT()
:p.GT&us.STRCOUNT&lpar.&rpar.
.br
.br
:hp2.Count the number of times a substring appears in a string:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GT&us.StrCount&lpar.<cChrs>&comma. <cStr>&rpar. &minus.&minus.> nFreq:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cChrs> &minus. The substring to find the frequence of  <cStr>  &minus. The string in which to find the character
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nFreq>   &minus. The number of times <cChrs> occurs in <cStr>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.GT&us.StrCount&lpar.&rpar. counts how many times a specified substring  appears in a string.  If the substring does NOT appear in <cStr> this function  will return 0.  If the substring is a single character use
GT&us.ChrCount&lpar.&rpar. as  it will be faster.
.br
:p.NOTE&colon.  invalid parameters will return &minus.1
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? GT&us.StrCount&lpar.&cdq.the&cdq.&comma. &cdq.the cat sat on the mat&cdq.&rpar.      &slash.&slash. prints 2
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libgt
:h2 id=STRIY res=11.GT_STRCSPN()
:i2 refid=STRINX.GT_STRCSPN()
:p.GT&us.STRCSPN&lpar.&rpar.
.br
.br
:hp2.Return length of prefix in string of chars NOT in set.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GT&us.strcspn&lpar.<cString>&comma. <cSet>&rpar. &minus.&minus.> nLength:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> &minus. The string to find the prefix in  <cSet>    &minus. The set of characters
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nLength>   &minus. The length of a string upto a character in the set
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Return the number of characters in the leading segment of a  string that consists solely of characters NOT in the set.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? GT&us.strcspn&lpar.&cdq.this is a test&cdq.&comma. &cdq.as &cdq.&rpar.      &slash.&slash. prints 3
.br
      ? GT&us.strcspn&lpar.&cdq.this is a test&cdq.&comma. &cdq.elnjpq&cdq.&rpar.   &slash.&slash. prints 11
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libgt
:h2 id=STRIY res=12.GT_STRDIFF()
:i2 refid=STRINX.GT_STRDIFF()
:p.GT&us.STRDIFF&lpar.&rpar.
.br
.br
:hp2.Return a string where it begins to differ from another:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GT&us.StrDiff&lpar.<cStr1>&comma. <cStr2>&rpar. &minus.&minus.> cRet:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cStr1>  &minus. A character string to compare  <cStr2>  &minus. The string to compare with
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cRet>     &minus. A string beginning at the position in <cStr2> where  <cStr1> begins to differ from <cStr1>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Return a string beginning at the position in <cStr2> where  <cStr1> begins to differ from <cStr1>. If the two strings are  identical &lpar.or identical upto the last character in <cStr2>&rpar.  the function will return
&cdq.&cdq..
.br
:p.NOTE&colon.  invalid parameters will return &cdq.&cdq.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? gt&us.strDiff&lpar.&cdq.the cat&cdq.&comma. &cdq.the rat&cdq.&rpar.          &slash.&slash. prints &cdq.rat&cdq.
.br
      ? gt&us.strDiff&lpar.&cdq.the cat&cdq.&comma. &cdq.the &cdq.&rpar.             &slash.&slash. prints &cdq.&cdq.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libgt
:h2 id=STRIY res=13.GT_STREXPAND()
:i2 refid=STRINX.GT_STREXPAND()
:p.GT&us.STREXPAND&lpar.&rpar.
.br
.br
:hp2.Insert fillers between characters in a passed string:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GT&us.StrExpand&lpar.<cStr>&comma. &lbrk.<nNum>&rbrk..&comma. &lbrk.<cChar>&rbrk..&rpar. &minus.&minus.> cRet:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cStr1>  &minus. A character string to insert chars into  <nNum>   &minus. The number of fill characters to insert &lpar.default 1&rpar.  <cChar>  &minus. The fill chararacter &lpar.default space&rpar.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cRet>     &minus. The input string with fill characters inserted between  every character in the original.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Inserts fill characters into a string.
.br
:p.NOTE&colon.  invalid parameters will return &cdq.&cdq.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? gt&us.strexpand&lpar.&cdq.abc&cdq.&rpar.                    &slash.&slash. prints &cdq.a b c&cdq.
.br
      ? gt&us.strexpand&lpar.&cdq.abc&cdq.&comma. 2&rpar.                 &slash.&slash. prints &cdq.a  b  c&cdq.
.br
      ? gt&us.strexpand&lpar.&cdq.abc&cdq.&comma. 2&comma. ''&rpar.            &slash.&slash. prints &cdq.abc&cdq.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libgt
:h2 id=STRIY res=14.GT_STRLEFT()
:i2 refid=STRINX.GT_STRLEFT()
:p.GT&us.STRLEFT&lpar.&rpar.
.br
.br
:hp2.Find length of prefix of a string:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GT&us.StrLeft&lpar.<cStr>&comma. <cChars>&rpar. &minus.&minus.> nLen:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cStr>   &minus. The input string  <cChars> &minus. The set of characters to find
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.nLen     &minus. The length of the prefix found.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Return the length of the leading segment in the passed string  <cStr> that consists solely of the characters in the character  set <cChars>.
.br
:p.If no characters in the the search set are found&comma. the function  shall return 0
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? GT&us.StrLeft&lpar.&cdq.this is a test&cdq.&comma. &cdq.hsit &cdq.&rpar.       &slash.&slash. prints 8
.br
      ? GT&us.StrLeft&lpar.&cdq.this is a test&cdq.&comma. &cdq.hit a&cdq.&rpar.       &slash.&slash. prints 3
.br
      ? GT&us.StrLeft&lpar.&cdq.this is a test&cdq.&comma. &cdq.zxy&cdq.&rpar.         &slash.&slash. prints 0
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libgt
:h2 id=STRIY res=15.GT_STRPBRK()
:i2 refid=STRINX.GT_STRPBRK()
:p.GT&us.STRPBRK&lpar.&rpar.
.br
.br
:hp2.Return string after 1st char from a set:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GT&us.StrpBrk&lpar.<cStr>&comma. <cSet>&rpar. &minus.&minus.> cString:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cStr>   &minus. The input string  <cSet>   &minus. The set of characters to find
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cString>  &minus. The input string after the first occurance of any  character from <cSet>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Return a string after the first occurance of any character from  the input set <cSet>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? GT&us.Strpbrk&lpar.&cdq.This is a test&cdq.&comma. &cdq.sa &cdq.&rpar.  &slash.&slash. prints &cdq.s is a test&cdq.
.br
      ? GT&us.Strpbrk&lpar.&cdq.This is a test&cdq.&comma. &cdq.et&cdq.&rpar.   &slash.&slash. prints &cdq.test&cdq.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libgt
:h2 id=STRIY res=16.GT_STRRIGHT()
:i2 refid=STRINX.GT_STRRIGHT()
:p.GT&us.STRRIGHT&lpar.&rpar.
.br
.br
:hp2.Find length of a suffix of a string:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GT&us.StrRight&lpar.<cStr>&comma. <cChars>&rpar. &minus.&minus.> nLen:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cStr>   &minus. The input string  <cChars> &minus. The set of characters to find
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nLen>     &minus. The length of the prefix found.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Return the length of the trailing segment in the passed string  <cStr> that consists solely of the characters in the character  set <cChars>.
.br
:p.If no characters in the the search set are found&comma. the function  shall return 0
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? GT&us.StrRight&lpar.&cdq.this is a test&cdq.&comma. &cdq.teas &cdq.&rpar.       &slash.&slash. prints 8
.br
      ? GT&us.StrRight&lpar.&cdq.this is a test&cdq.&comma. &cdq.tes h&cdq.&rpar.       &slash.&slash. prints 5
.br
      ? GT&us.StrRight&lpar.&cdq.this is a test&cdq.&comma. &cdq.zxy&cdq.&rpar.         &slash.&slash. prints 0
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is libgt
:h1 DOCUY.DOCUMENT
:h2  res=17.OVERVIEW
:i1 id=DOCUMX.DOCUMENT
:i2 refid=DOCUMX.OVERVIEW
:p.OVERVIEW
.br
.br
:hp2.HARBOUR Read me:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
.br
:p.:hp2.The Harbour project:ehp2.
.br
:p.:hp2.************************************************************************:ehp2.
:p.:hp2.*  This file contains information on obtaining&comma. installing&comma. and using  *:ehp2.
:p.:hp2.*  Harbour. Please read it *completely* before asking for help.        *:ehp2.
:p.:hp2.************************************************************************:ehp2.
.br
:p.Harbour is a free implementation of an xBase language compiler. It is  designed to be source code compatible with the CA&minus.Clipper&lpar.r&rpar. compiler.  That means that if you've got some code that would compile using
CA&minus.Clipper&lpar.r&rpar. then it should compile under Harbour. The Harbour&minus.Project  web page is&colon.
:p.:hp2.http:&slash.&slash.www.Harbour&minus.Project.org&slash.:ehp2.
.br
.br
:p.Status and other information is always available from the web site.  There is a Harbour mailing list. Harbour is still at a very early  stage of development&comma. so the mailing list is very much a Developers  only list&comma.
although every body is welcome to join in the discussions.
.br
:p.We would like you to join the Harbour development team. If you are  interested you may suscribe to our mailing list and start contributing  to this free public project.
.br
:p.Please feel free to report all questions&comma. ideas&comma. suggestions&comma. fixes&comma.  code&comma. etc. you may need and want. With the help of all of you&comma. the Harbour  compiler and runtime libraries will become a
reality very soon.
.br
.br
:p.:hp2.What this distribution contains:ehp2.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.This distribution is a Source code only distribution. It does not contain  any executable files. Executable versions of Harbour are available from  the web site. Executable versions of Harbour DO NOT create runable  programs.
Harbour at the moment produces C output code&comma. which must be  compiled with the Harbour Virtual Machine and the support libraries  in order to create a functioning program.
:p.Please test running Harbour against your Clipper source code and report  any problems that might occur.
.br
:p.Very important&colon. The preprocessor functionality is now working.
.br
:p.:hp2.Installation:ehp2.
:p.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
.br
:p.1. Unzip with Harbour zip file using pkunzip or equivalent.
:p.E.G. pkunzip &minus.d build72.zip
:p.This will create Harbour&slash. directory and all the relevant sub  directories.
.br
:p.2. Compile Harbour using your C compiler. Make files for different  platforms are included in the <WHERE ARE THEY?> directory.
.br
.br
:p.:hp2.&minus.&minus.&minus. COPYRIGHT &minus.&minus.&minus.:ehp2.
.br
:p.What copyright information do we have
.br
.br
:p.:hp2.&minus.&minus.&minus. LICENCE &minus.&minus.&minus.:ehp2.
.br
:p.Information about the License for usage of Harbour is available in the  file LICENCE.TXT &lpar.when we have a license&rpar.
.br
:p.:hp2.&minus.&minus.&minus. DISCLAIMER &minus.&minus.&minus.:ehp2.
.br
:p.Participants of The Harbour Project assume no responsibility for errors or  omissions in these materials.
.br
:p.:hp2.THESE MATERIALS ARE PROVIDED &cdq.AS IS&cdq. WITHOUT WARRANTY OF ANY KIND&comma. EITHER  EXPRESS OR IMPLIED&comma. INCLUDING BUT NOT LIMITED TO&comma. THE IMPLIED WARRANTIES  OF MERCHANTABILITY&comma. FITNESS FOR A
PARTICULAR PURPOSE&comma. OR NON&minus.INFRINGEMENT.:ehp2.
.br
:p.Participants of The Harbour Project further do not warrant the accuracy or  completeness of the code&comma. information&comma. text&comma. output or any other items  contained within these materials. Participants of The Harbour
Project  shall not be liable for any special&comma. direct&comma. indirect&comma. incidental&comma. or  consequential damages&comma. including without limitation&comma. lost revenues or  lost profits&comma. which may result from
the use or mis&minus.use of these materials.
.br
:p.The information in The Harbour Project is subject to change without notice  and does not represent any future commitment by the participants of The  Harbour Project.
.br
:p.The Harbour Project
.br
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=18.LICENSE:elink.
.br
:h2 id=DOCUY res=18.License
:i2 refid=DOCUMX.LICENSE
:p.License
.br
.br
:hp2.Harbour License:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
.br
:p.:hp2.THE HARBOUR PROJECT LICENSE:ehp2.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.This program is free software&semi. you can redistribute it and&slash.or modify  it under the terms of the GNU General Public License as published by  the Free Software Foundation&semi. either version 2 of the License&comma. or
&lpar.at your option&rpar. any later version&comma. with one exception&colon.
.br
:p.The exception is that if you link the Harbour Runtime Library &lpar.HRL&rpar.  and&slash.or the Harbour Virtual Machine &lpar.HVM&rpar. with other files to produce  an executable&comma. this does not by itself cause the resulting
executable  to be covered by the GNU General Public License. Your use of that  executable is in no way restricted on account of linking the HRL  and&slash.or HVM code into it.
.br
:p.This program is distributed in the hope that it will be useful&comma.  but :hp2.WITHOUT ANY WARRANTY:ehp2.&semi. without even the implied warranty of  :hp2.MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE:ehp2..  See the  GNU
General Public License for more details.
.br
:p.You should have received a copy of the GNU General Public License  along with this program&semi. if not&comma. write to the Free Software  Foundation&comma. Inc.&comma. 675 Mass Ave&comma. Cambridge&comma. MA 02139&comma. USA
&lpar.or visit  their web site at http&colon.&slash.&slash.www.gnu.org&slash.&rpar..
.br
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=17.OVERVIEW:elink.
.br
:euserdoc.
