:userdoc.
:docprof toc=123456.
:title.Harbour Reference Guide
.* HBDOC generated IPF Source File.
.* HBDOC Document Source Extractor, (c)1999-2000 Luiz Rafael Culik.
:h1 ARRAY.ARRAY
:h2  res=1.ARRAY()
:i1 id=ARRAYX.ARRAY
:i2 refid=ARRAYX.ARRAY()
:p.ARRAY&lpar.&rpar.
.br
.br
:hp2.Create an uninitialized array of specified length:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ARRAY&lpar. <nElements> &lbrk.&comma. <nElements>...&rbrk.. &rpar. &minus.&minus.> aArray:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nElements> is the number of elements in the specified dimension.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<aArray> an array of specified dimensions.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns an uninitialized array with the length of  <nElements>. Nested arrays are uninitialized within the same array  pointer reference if additional parameters are specified.  Establishing a memory variable with
the same name as the array may  destroy the original array and release the entire contents of the  array. This depends&comma. of course&comma. on the data storage type of either  the array or the variable with the same name as
the array.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
        LOCAL aArray&colon.&eq.Array&lpar.10&rpar.
.br
        LOCAL x&colon.&eq.1
.br
        FOR x&colon.&eq.1 to LEN&lpar.aArray&rpar.
.br
          aArray&lbrk.x&rbrk..&colon.&eq.Array&lpar.x&rpar.
.br
        NEXT
.br
        Return Nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.CLIPPER Compliant in all Cases&comma. except that  arrays in Harbour can have an unlimited number of dimensions&comma. while  Clipper has a limit of 4096 array elements.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=2.AADD():elink.
.br
:link reftype=hd res=3.ADEL():elink.
.br
:link reftype=hd res=4.AFILL():elink.
.br
:link reftype=hd res=5.AINS():elink.
.br
:h2 id=ARRAY res=2.AADD()
:i2 refid=ARRAYX.AADD()
:p.AADD&lpar.&rpar.
.br
.br
:hp2.Dynamically add an element to an array:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.AADD&lpar.<aArray>&lbrk.&comma. <xValue>&rbrk..&rpar. &minus.&minus.> Value:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<aArray> The name of an array
.br
:p.<xValue> Element to add to array <aArray>
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<Value> if specified <xValue>&comma.<xValue> will return &comma. otherwise this  function  returns a NIL value.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function dynamically increases the length of the array named  <aArray> by one element and stores the value of <xValue> to that  newly created element.
.br
:p.<xValue> may be an array reference pointer&comma. which in turn may be  stored to an array's subscript position.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      LOCAL aArray&colon.&eq.&lbrc.&rbrc.
.br
      AADD&lpar.aArray&comma.10&rpar.
.br
      FOR x&colon.&eq.1 to 10
.br
          AADD&lpar.aArray&comma.x&rpar.
.br
      NEXT
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=5.AINS():elink.
.br
:link reftype=hd res=6.ASIZE():elink.
.br
:h2 id=ARRAY res=6.ASIZE()
:i2 refid=ARRAYX.ASIZE()
:p.ASIZE&lpar.&rpar.
.br
.br
:hp2.Adjust the size of an array:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ASIZE&lpar.<aArray>&comma. <nLen>&rpar. &minus.&minus.> aTarget:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<aArray> Name of array to be dynamically altered
.br
:p.<nLen> Numeric value representing the new size of <aArray>
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<aTarget> an array pointer reference to <aTarget>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function will dynamically increase or decrease the size of  <aArray> by adjusting the length of the array to <nLen> subscript  positions.
.br
:p.If the length of the array <aArray> is shortened&comma. those former  subscript positions are lost. If the length of the array is  lengthened a NIL value is assigned to the new subscript position.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      aArray &colon.&eq. &lbrc. 1 &rbrc.          &slash.&slash. Result&colon. aArray is &lbrc. 1 &rbrc.
.br
      ASIZE&lpar.aArray&comma. 3&rpar.         &slash.&slash. Result&colon. aArray is &lbrc. 1&comma. NIL&comma. NIL &rbrc.
.br
      ASIZE&lpar.aArray&comma. 1&rpar.         &slash.&slash. Result&colon. aArray is &lbrc. 1 &rbrc.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.If HB&us.COMPAT&us.C53 is defined&comma. the function generates an Error&comma.  else it will return the array itself.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=2.AADD():elink.
.br
:link reftype=hd res=3.ADEL():elink.
.br
:link reftype=hd res=4.AFILL():elink.
.br
:link reftype=hd res=5.AINS():elink.
.br
:h2 id=ARRAY res=7.ATAIL()
:i2 refid=ARRAYX.ATAIL()
:p.ATAIL&lpar.&rpar.
.br
.br
:hp2.Returns the rightmost element of an array:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ATAIL&lpar. <aArray> &rpar. &minus.&minus.> Element:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<aArray> is the array.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<Element> the expression of the last element in the array.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function return the value of the last element in the array  named <aArray>. This function does not alter the size of the  array or any of the subscript values.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      LOCAL array&colon.&eq. &lbrc.&cdq.Harbour&cdq.&comma. &cdq.is&cdq.&comma. &cdq.Supreme&cdq.&comma. &cdq.Power&cdq.&rbrc.
.br
      ? ATAIL&lpar.aArray&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=8.LEN():elink.
.br
:link reftype=hd res=1.ARRAY():elink.
.br
:link reftype=hd res=6.ASIZE():elink.
.br
:link reftype=hd res=2.AADD():elink.
.br
:h2 id=ARRAY res=5.AINS()
:i2 refid=ARRAYX.AINS()
:p.AINS&lpar.&rpar.
.br
.br
:hp2.Insert a NIL value at an array subscript position.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.AINS&lpar. <aArray>&comma. <nPos> &rpar. &minus.&minus.> aTarget:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<aArray> Array name.
.br
:p.<nPos> Subscript position in <aArray>
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<aTarget> an array pointer reference.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function inserts a NIL value in the array named <aArray>  at the <nPos>th position.
.br
:p.All array elements starting with the <nPos>th position will be  shifted down one subscript position in the array list and the  last item in the array will be removed completely. In other words&comma.  if an array element were to
be inserted at the fifth subscript  position&comma. the element previously in the fifth position would now  be located at the sixth position. The length of the array <aArray>  will remain unchanged.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      LOCAL aArray&colon.&eq.&lbrc.&cdq.Harbour&cdq.&comma.&cdq.is&cdq.&comma.&cdq.Power!&cdq.&comma.&cdq.!!!&cdq.&rbrc.
.br
      AINS&lpar.aArray&comma.4&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=2.AADD():elink.
.br
:link reftype=hd res=9.ACOPY():elink.
.br
:link reftype=hd res=3.ADEL():elink.
.br
:link reftype=hd res=10.AEVAL():elink.
.br
:link reftype=hd res=4.AFILL():elink.
.br
:link reftype=hd res=6.ASIZE():elink.
.br
:h2 id=ARRAY res=3.ADEL()
:i2 refid=ARRAYX.ADEL()
:p.ADEL&lpar.&rpar.
.br
.br
:hp2.Delete an element form an array.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ADEL&lpar.<aArray>&comma. <nPos>&rpar. &minus.&minus.> aTarget:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<aArray> Name of array from which an element is to be removed.
.br
:p.<nPos>   Subscript of the element to be removed.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<aTarget> an array pointer reference.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function deletes the element found at <nPos> subscript position  in the array <aArray>. All elements in the array <aArray> below the  given subscript position <nPos> will move up one position in the  array. In other
words&comma. what was formerly the sixth subscript position  will become the fifth subscript position. The length of the array  <aArray> will remain unchanged&comma.as the last element in the array will  become a NIL data type.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
     LOCAL aArray
.br
      aArray &colon.&eq. &lbrc. &cdq.Harbour&cdq.&comma.&cdq.is&cdq.&comma.&cdq.Power&cdq. &rbrc.      &slash.&slash. Result&colon. aArray is
.br

.br
      ADEL&lpar.aArray&comma. 2&rpar.            &slash.&slash. Result&colon. aArray is
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=9.ACOPY():elink.
.br
:link reftype=hd res=5.AINS():elink.
.br
:link reftype=hd res=4.AFILL():elink.
.br
:h2 id=ARRAY res=4.AFILL()
:i2 refid=ARRAYX.AFILL()
:p.AFILL&lpar.&rpar.
.br
.br
:hp2.Fill an array with a specified value:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.AFILL&lpar. <aArray>&comma. <xValue>&comma. &lbrk.<nStart>&rbrk..&comma. &lbrk.<nCount>&rbrk.. &rpar. &minus.&minus.> aTarget:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<aArray> Name of array to be filled.
.br
:p.<xValue> Expression to be globally filled in <aArray>
.br
:p.<nStart> Subscript starting position
.br
:p.<nCount> Number of subscript to be filled
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<aTarget> an array pointer.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function will fill each element of an array named <aArray> with  the value <xValue>. If specified&comma. <nStart> denotes the beginning  element to be filled and the array elements will continue to be  filled for <nCount>
positions. If Not specified&comma. the value of  <nStart> will be 1&comma. and the value of <nCount> will be the value  of LEN&lpar.<aArray>&rpar.&semi. thus&comma. all subscript positions in the array  <aArray> will be filled
with the value of <xValue>.
.br
:p.This function will work on only a single dimension of <aArray>.  If there are array pointer references within a subscript <aArray>&comma.  those values will be lost&comma. since this function will overwrite those  values with new
values.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      LOCAL aTest&colon.&eq.&lbrc.Nil&comma.0&comma.1&comma.2&rbrc.
.br
      Afill&lpar.aTest&comma.5&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=2.AADD():elink.
.br
:link reftype=hd res=10.AEVAL():elink.
.br
:link reftype=hd res=11.DBSTRUCT():elink.
.br
:link reftype=hd res=12.DIRECTORY():elink.
.br
:h2 id=ARRAY res=13.ASCAN()
:i2 refid=ARRAYX.ASCAN()
:p.ASCAN&lpar.&rpar.
.br
.br
:hp2.Scan array elements for a specified condition:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ASCAN&lpar. <aTarget>&comma. <xSearch>&comma. &lbrk.<nStart>&rbrk..&comma. &lbrk.<nCount>&rbrk.. &rpar. &minus.&minus.> nStoppedAt:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<aTarget>   Name of array to be scanned.
.br
:p.<xSearch>   Expression to search for in <aTarget>
.br
:p.<nStart>    Beginning subscript position at which to start the search.
.br
:p.<nCount>    Number of elements to scan with <aTarget>.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nStoppedAt> A numeric value of subscript position where <xSearch>  was found.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function scan the content of array named <aTarget> for the  value of <xSearch>. The return value is the position in the array  <aTarget> in which <xSearch> was found. If it was not found&comma. the  return value will be 0.
.br
:p.If specified&comma. the beginning subscript position at which to start  scanning may be set with the value passed as <nStart>. The default  is 1.
.br
:p.If specified&comma. the number of array elements to scan may be set with  the value passed as <nCount>. The default is the number of elements  in the array <aTarget>.
.br
:p.If <xSearch> is a code block&comma. the operation of the function is  slightly different. Each array subscript pointer reference is  passed to the code block to be evaluated. The scanning routine  will continue until the value
obtained from the code block is a  logical true &lpar..T.&rpar. or until the end of the array has been reached.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      aDir&colon.&eq.Directory&lpar.&cdq.*.prg&cdq.&rpar.
.br
      AScan&lpar.aDir&comma.&comma.&comma.&lbrc.&splitvbar.x&comma.y&splitvbar. x&lbrk.1&rbrk..&eq.&cdq.Test.prg&cdq.&rbrc.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is not CA&minus.Clipper compatible. Clipper ASCAN&lpar.&rpar. is affected by the SET EXACT ON&slash.OFF Condition
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=10.AEVAL():elink.
.br
:h2 id=ARRAY res=10.AEVAL()
:i2 refid=ARRAYX.AEVAL()
:p.AEVAL&lpar.&rpar.
.br
.br
:hp2.Evaluated the subscript element of an array:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.AEVAL&lpar.<aArray>&comma. <bBlock>&comma. &lbrk.<nStart>&rbrk..&comma. &lbrk.<nCount>&rbrk..&rpar. &minus.&minus.> aArray:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<aArray> Is the array to be evaluated.
.br
:p.<bBlock> Is a code block to evaluate for each element processed.
.br
:p.<nStart> The beginning  array element to evaluate.
.br
:p.<nCount> The number of elements to process.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<aArray> an array pointer reference.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function will evaluate and process the subscript elements  in <aArray>. A code block passed as <bBlock> defines the operation  to be executed on each element of the array. All elements in <aArray>  will be evaluated unless
specified by a beginning subscript position  in <nStart> for <nCount> elements.
.br
:p.Two parameters are passed to the code block <bBlock>. The individual  elements in an array are the first parameter and the subscript position  is the second.
.br
:p.AEVAL&lpar.&rpar. does not replace a FOR...NEXT loop for processing arrays. If  an array is an autonomous unit&comma. AEVAL&lpar.&rpar. is appropriate. If the array  is to be altered or if elements are to be reevaluated&comma. a
FOR...NEXT  loop is more appropriate.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=14.EVAL():elink.
.br
:link reftype=hd res=15.DBEVAL():elink.
.br
:h2 id=ARRAY res=9.ACOPY()
:i2 refid=ARRAYX.ACOPY()
:p.ACOPY&lpar.&rpar.
.br
.br
:hp2.Copy elements from one array to another:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ACOPY&lpar. <aSource>&comma. <aTarget>&comma. &lbrk.<nStart>&rbrk..&comma. &lbrk.<nCount>&rbrk..&comma. &lbrk.<nTargetPos>&rbrk.. &rpar.:ehp2.
:p.:hp2.&minus.&minus.> aTarget:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<aSource> is the array to copy elements from.
.br
:p.<aTarget> is the array to copy elements to.
.br
:p.<nStart>  is the beginning subscript position to copy from <aSource>
.br
:p.<nCount>  the number of subscript elements to copy from <aSource>.
.br
:p.<nTargetPos> the starting subscript position in <aTarget> to copy  elements to.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<aTarget> an array pointer reference
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function copies array elements from <aSource> to <aTarget>.  <nStart> is the beginning element to be copied from <aSource>&semi.  the default is 1.
.br
:p.<nCount> is the number of elements to be copied from <aSource>&semi.  the default is the entire array.
.br
:p.<nTargetPos> is the subscript number in the target array&comma.<aTarget>&comma.  to which array elements are to be copied&semi. the default is 1
.br
:p.This function will copy all data types in <aSource> to <aTarget>.
.br
:p.If an array element in <aSource> is a pointer reference to another  array&comma. that array pointer will be copied to <aTarget>&semi. not all  subdimensions will be copied from one array to the next. This must  be accomplished
via the ACLONE&lpar.&rpar. function.
.br
:p.Note  If array <aSource> is larger then <aTarget>&comma. array elements will  start copying at <nTargetPos> and continue copying until the end  of array <aTarget> is reached. The ACOPY&lpar.&rpar. function doesn't append
subscript positions to the target array&comma. the size of the target  array <aTarget> remains constant.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      LOCAL nCount &colon.&eq. 2&comma. nStart &colon.&eq. 1&comma. aOne&comma. aTwo
.br
      aOne &colon.&eq. &lbrc.&cdq.HABOUR&cdq.&comma.&cdq. is &cdq.&comma.&cdq.POWER&cdq.&rbrc.
.br
      aTwo &colon.&eq. &lbrc.&cdq.CLIPPER&cdq.&comma.&cdq. was &cdq.&comma.&cdq.POWER&cdq.&rbrc.
.br
      ACOPY&lpar.aOne&comma. aTwo&comma. nStart&comma. nCount&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=16.ACLONE():elink.
.br
:link reftype=hd res=3.ADEL():elink.
.br
:link reftype=hd res=10.AEVAL():elink.
.br
:link reftype=hd res=4.AFILL():elink.
.br
:link reftype=hd res=5.AINS():elink.
.br
:link reftype=hd res=17.ASORT():elink.
.br
:h2 id=ARRAY res=16.ACLONE()
:i2 refid=ARRAYX.ACLONE()
:p.ACLONE&lpar.&rpar.
.br
.br
:hp2.Duplicate a  multidimensional array:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ACLONE&lpar.<aSource>&rpar. &minus.&minus.> aDuplicate:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<aSource> Name of the array to be cloned.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<aDuplicate> A new array pointer reference complete with nested  array values.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function makes a complete copy of the array expressed as  <aSource> and return a cloned set of array values.This provides  a complete set of arrays values for all dimensions within the  original array <aSource>
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      LOCAL aOne&comma. aTwo
.br
      aOne &colon.&eq. &lbrc.&cdq.Harbour&cdq.&comma.&cdq. is &cdq.&comma.&cdq.POWER&cdq.&rbrc.
.br
      aTwo &colon.&eq. ACLONE&lpar.aOne&rpar.       &slash.&slash. Result&colon. aTwo is &lbrc.1&comma. 2&comma. 3&rbrc.
.br
      aOne&lbrk.1&rbrk.. &colon.&eq. &cdq.The Harbour Compiler&cdq.              &slash.&slash. Result&colon. aOne is &lbrc.99&comma. 2&comma. 3&rbrc.
.br
                                 &slash.&slash. aTwo is still &lbrc.1&comma. 2&comma. 3&rbrc.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.Clipper will return NIL if the parameter is not an array.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=9.ACOPY():elink.
.br
:link reftype=hd res=3.ADEL():elink.
.br
:link reftype=hd res=5.AINS():elink.
.br
:link reftype=hd res=6.ASIZE():elink.
.br
:h2 id=ARRAY res=17.ASORT()
:i2 refid=ARRAYX.ASORT()
:p.ASORT&lpar.&rpar.
.br
.br
:hp2.Sort an array:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ASORT&lpar. <aArray>&comma. &lbrk.<nStart>&rbrk..&comma. &lbrk.<nCount>&rbrk..&comma. &lbrk.<bSort>&rbrk.. &rpar. &minus.&minus.> aArray:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<aArray> Array to be sorted.
.br
:p.<nStart> The first element to start the sort from&comma. default is 1.
.br
:p.<nCount> Number of elements starting from <nStart> to sort&comma. default  is all elements.
.br
:p.<bSort> Code block for sorting order&comma. default is ascending order  &lbrc.&splitvbar. x&comma. y &splitvbar. x < y &rbrc.. The code block should accept two parameters and  must return .T. if the sort is in order&comma. .F. if
not.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<aArray> reference to the now sorted <aArray> or NIL if the  passed <aArray> is not an array.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.ASORT&lpar.&rpar. sort all or part of a given array. If <bSort> is omitted&comma.  the function expect <aArray> to be one dimensional array containing  single data type &lpar.one of&colon. Character&comma. Date&comma.
Logical&comma. Numeric&rpar. and sort  this array in ascending order&colon. Character are sorted by their ASCII  value&comma. Dates are sorted chronologically&comma. Logical put .F. values before  .T.&comma. Numeric are sorted by
their value.
.br
:p.If <bSort> is specified&comma. it is used to handle the sorting order. With  each time the block is evaluate&comma. two array elements are passed to the  code block&comma. and <bSort> must return a logical value that state if
those elements are in order &lpar..T.&rpar. or not &lpar..F.&rpar.. Using this block you  can sort multidimensional array&comma. descending orders or even &lpar.but why  would you want to do that&rpar. sort array that contain
different data  type.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. sort numeric values in ascending order
.br
      ASORT&lpar. &lbrc. 3&comma. 1&comma. 4&comma. 42&comma. 5&comma. 9 &rbrc. &rpar.     &slash.&slash. result&colon. &lbrc. 1&comma. 3&comma. 4&comma. 5&comma. 9&comma. 42 &rbrc.
.br

.br
      &slash.&slash. sort character strings in descending lexical order
.br
      aKeys &colon.&eq. &lbrc. &cdq.Ctrl&cdq.&comma. &cdq.Alt&cdq.&comma. &cdq.Delete&cdq. &rbrc.
.br
      bSort &colon.&eq. &lbrc.&splitvbar. x&comma. y &splitvbar. UPPER&lpar. x &rpar. > UPPER&lpar. y &rpar. &rbrc.
.br
      ASORT&lpar. aKeys&comma.&comma.&comma. bSort &rpar.      &slash.&slash. result&colon. &lbrc. &cdq.Delete&cdq.&comma. &cdq.Ctrl&cdq.&comma. &cdq.Alt&cdq. &rbrc.
.br

.br
      &slash.&slash. sort two&minus.dimensional array according to 2nd element of each pair
.br
      aPair &colon.&eq.   &lbrc. &lbrc.&cdq.Sun&cdq.&comma.8&rbrc.&comma. &lbrc.&cdq.Mon&cdq.&comma.1&rbrc.&comma. &lbrc.&cdq.Tue&cdq.&comma.57&rbrc.&comma. &lbrc.&cdq.Wed&cdq.&comma.&minus.6&rbrc. &rbrc.
.br
      ASORT&lpar. aPair&comma.&comma.&comma. &lbrc.&splitvbar. x&comma. y &splitvbar. x&lbrk.2&rbrk.. < y&lbrk.2&rbrk.. &rbrc. &rpar.
.br
      &slash.&slash. result&colon. &lbrc. &lbrc.&cdq.Wed&cdq.&comma.&minus.6&rbrc.&comma. &lbrc.&cdq.Mon&cdq.&comma.1&rbrc.&comma. &lbrc.&cdq.Sun&cdq.&comma.8&rbrc.&comma. &lbrc.&cdq.Tue&cdq.&comma.57&rbrc. &rbrc.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.Codeblock calling frequency and order differs from Clipper&comma. since  Harbour uses a different &lpar.faster&rpar. sorting algorithm &lpar.quicksort&rpar..
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=13.ASCAN():elink.
.br
:link reftype=hd res=14.EVAL():elink.
.br
:link reftype=hd res=18.SORT:elink.
.br
:h1 BINAY.BINARY CONVERSION
:h2  res=19.BIN2W()
:i1 id=BINARX.BINARY CONVERSION
:i2 refid=BINARX.BIN2W()
:p.BIN2W&lpar.&rpar.
.br
.br
:hp2.Convert unsigned short encoded bytes into Harbour numeric:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.BIN2W&lpar. <cBuffer> &rpar. &minus.&minus.> nNumber:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cBuffer> is a character string that contain 16 bit encoded unsigned  short integer &lpar.least significant byte first&rpar.. The first two bytes  are taken into account&comma. the rest if any are ignored.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.BIN2W&lpar.&rpar. return numeric integer &lpar.or 0 if <cBuffer> is not a string&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.BIN2W&lpar.&rpar. is one of the low level binary conversion functions&comma. those  functions convert between Harbour numeric and a character  representation of numeric value. BIN2W&lpar.&rpar. take two bytes of encoded  16 bit
unsigned short integer and convert it into standard Harbour  numeric value.
.br
:p.You might ask what is the need for such functions&comma. well&comma. first of  all it allow you to read&slash.write information from&slash.to a binary file  &lpar.like extracting information from DBF header&rpar.&comma. it is
also a useful  way to share information from source other than Harbour &lpar.C for  instance&rpar..
.br
:p.BIN2W&lpar.&rpar. is the opposite of W2BIN&lpar.&rpar.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Show header length of a DBF
.br
      FUNCTION main&lpar.&rpar.
.br
      LOCAL nHandle&comma. cBuffer &colon.&eq. space&lpar. 2 &rpar.
.br
      nHandle &colon.&eq. fopen&lpar. &cdq.test.dbf&cdq. &rpar.
.br
      IF nHandle > 0
.br
         fseek&lpar. nHandle&comma. 8 &rpar.
.br
         fread&lpar. nHandle&comma. @cBuffer&comma. 2 &rpar.
.br
         ? &cdq.Length of DBF header in bytes&colon.&cdq.&comma. BIN2W&lpar. cBuffer &rpar.
.br
         fclose&lpar. nHandle &rpar.
.br
      ELSE
.br
         ? &cdq.Can not open file&cdq.
.br
      ENDIF
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.BIN2W&lpar.&rpar. works exactly like CA&minus.Clipper's BIN2W&lpar.&rpar.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=20.BIN2I():elink.
.br
:link reftype=hd res=21.BIN2L():elink.
.br
:link reftype=hd res=22.BIN2U():elink.
.br
:link reftype=hd res=23.I2BIN():elink.
.br
:link reftype=hd res=24.L2BIN():elink.
.br
:link reftype=hd res=25.W2BIN():elink.
.br
:link reftype=hd res=26.WORD():elink.
.br
:link reftype=hd res=27.U2BIN():elink.
.br
:link reftype=hd res=28.FREAD():elink.
.br
:h2 id=BINAY res=20.BIN2I()
:i2 refid=BINARX.BIN2I()
:p.BIN2I&lpar.&rpar.
.br
.br
:hp2.Convert signed short encoded bytes into Harbour numeric:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.BIN2I&lpar. <cBuffer> &rpar. &minus.&minus.> nNumber:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cBuffer> is a character string that contain 16 bit encoded signed  short integer &lpar.least significant byte first&rpar.. The first two bytes  are taken into account&comma. the rest if any are ignored.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.BIN2I&lpar.&rpar. return numeric integer &lpar.or 0 if <cBuffer> is not a string&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.BIN2I&lpar.&rpar. is one of the low level binary conversion functions&comma. those  functions convert between Harbour numeric and a character  representation of numeric value. BIN2I&lpar.&rpar. take two bytes of encoded  16 bit
signed short integer and convert it into standard Harbour  numeric value.
.br
:p.You might ask what is the need for such functions&comma. well&comma. first of  all it allow you to read&slash.write information from&slash.to a binary file  &lpar.like extracting information from DBF header&rpar.&comma. it is
also a useful  way to share information from source other than Harbour &lpar.C for  instance&rpar..
.br
:p.BIN2I&lpar.&rpar. is the opposite of I2BIN&lpar.&rpar.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Show DBF last update date
.br
      FUNCTION main&lpar.&rpar.
.br
      LOCAL nHandle&comma. cYear&comma. cMonth&comma. cDay
.br
      nHandle &colon.&eq. fopen&lpar. &cdq.test.dbf&cdq. &rpar.
.br
      IF nHandle > 0
.br
         fseek&lpar. nHandle&comma. 1 &rpar.
.br
         cYear &colon.&eq. cMonth &colon.&eq. cDay &colon.&eq. &cdq. &cdq.
.br
         fread&lpar. nHandle&comma. @cYear &comma. 1 &rpar.
.br
         fread&lpar. nHandle&comma. @cMonth&comma. 1 &rpar.
.br
         fread&lpar. nHandle&comma. @cDay  &comma. 1 &rpar.
.br
         ? &cdq.Last update&colon.&cdq.&comma. BIN2I&lpar. cYear &rpar.&comma. BIN2I&lpar. cMonth &rpar.&comma. BIN2I&lpar. cDay &rpar.
.br
         fclose&lpar. nHandle &rpar.
.br
      ELSE
.br
         ? &cdq.Can not open file&cdq.
.br
      ENDIF
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.BIN2I&lpar.&rpar. works exactly like CA&minus.Clipper's BIN2I&lpar.&rpar.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=21.BIN2L():elink.
.br
:link reftype=hd res=22.BIN2U():elink.
.br
:link reftype=hd res=19.BIN2W():elink.
.br
:link reftype=hd res=23.I2BIN():elink.
.br
:link reftype=hd res=24.L2BIN():elink.
.br
:link reftype=hd res=25.W2BIN():elink.
.br
:link reftype=hd res=26.WORD():elink.
.br
:link reftype=hd res=27.U2BIN():elink.
.br
:link reftype=hd res=28.FREAD():elink.
.br
:h2 id=BINAY res=21.BIN2L()
:i2 refid=BINARX.BIN2L()
:p.BIN2L&lpar.&rpar.
.br
.br
:hp2.Convert signed long encoded bytes into Harbour numeric:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.BIN2L&lpar. <cBuffer> &rpar. &minus.&minus.> nNumber:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cBuffer> is a character string that contain 32 bit encoded signed  long integer &lpar.least significant byte first&rpar.. The first four bytes  are taken into account&comma. the rest if any are ignored.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.BIN2L&lpar.&rpar. return numeric integer &lpar.or 0 if <cBuffer> is not a string&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.BIN2L&lpar.&rpar. is one of the low level binary conversion functions&comma. those  functions convert between Harbour numeric and a character  representation of numeric value. BIN2L&lpar.&rpar. take four bytes of encoded  32 bit
signed long integer and convert it into standard Harbour  numeric value.
.br
:p.You might ask what is the need for such functions&comma. well&comma. first of  all it allow you to read&slash.write information from&slash.to a binary file  &lpar.like extracting information from DBF header&rpar.&comma. it is
also a useful  way to share information from source other than Harbour &lpar.C for  instance&rpar..
.br
:p.BIN2L&lpar.&rpar. is the opposite of L2BIN&lpar.&rpar.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Show number of records in DBF
.br
      FUNCTION main&lpar.&rpar.
.br
      LOCAL nHandle&comma. cBuffer &colon.&eq. space&lpar. 4 &rpar.
.br
      nHandle &colon.&eq. fopen&lpar. &cdq.test.dbf&cdq. &rpar.
.br
      IF nHandle > 0
.br
         fseek&lpar. nHandle&comma. 4 &rpar.
.br
         fread&lpar. nHandle&comma. @cBuffer&comma. 4 &rpar.
.br
         ? &cdq.Number of records in file&colon.&cdq.&comma. BIN2L&lpar. cBuffer &rpar.
.br
         fclose&lpar. nHandle &rpar.
.br
      ELSE
.br
         ? &cdq.Can not open file&cdq.
.br
      ENDIF
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.BIN2L&lpar.&rpar. works exactly like CA&minus.Clipper's BIN2L&lpar.&rpar.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=20.BIN2I():elink.
.br
:link reftype=hd res=22.BIN2U():elink.
.br
:link reftype=hd res=19.BIN2W():elink.
.br
:link reftype=hd res=23.I2BIN():elink.
.br
:link reftype=hd res=24.L2BIN():elink.
.br
:link reftype=hd res=25.W2BIN():elink.
.br
:link reftype=hd res=26.WORD():elink.
.br
:link reftype=hd res=27.U2BIN():elink.
.br
:link reftype=hd res=28.FREAD():elink.
.br
:h2 id=BINAY res=22.BIN2U()
:i2 refid=BINARX.BIN2U()
:p.BIN2U&lpar.&rpar.
.br
.br
:hp2.Convert unsigned long encoded bytes into Harbour numeric:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.BIN2U&lpar. <cBuffer> &rpar. &minus.&minus.> nNumber:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cBuffer> is a character string that contain 32 bit encoded unsigned  long integer &lpar.least significant byte first&rpar.. The first four bytes  are taken into account&comma. the rest if any are ignored.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.BIN2U&lpar.&rpar. return numeric integer &lpar.or 0 if <cBuffer> is not a string&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.BIN2U&lpar.&rpar. is one of the low level binary conversion functions&comma. those  functions convert between Harbour numeric and a character  representation of numeric value. BIN2U&lpar.&rpar. take four bytes of encoded  32 bit
unsigned long integer and convert it into standard Harbour  numeric value.
.br
:p.You might ask what is the need for such functions&comma. well&comma. first of  all it allow you to read&slash.write information from&slash.to a binary file  &lpar.like extracting information from DBF header&rpar.&comma. it is
also a useful  way to share information from source other than Harbour &lpar.C for  instance&rpar..
.br
:p.BIN2U&lpar.&rpar. is the opposite of U2BIN&lpar.&rpar.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Show number of records in DBF
.br
      FUNCTION main&lpar.&rpar.
.br
      LOCAL nHandle&comma. cBuffer &colon.&eq. space&lpar. 4 &rpar.
.br
      nHandle &colon.&eq. fopen&lpar. &cdq.test.dbf&cdq. &rpar.
.br
      IF nHandle > 0
.br
         fseek&lpar. nHandle&comma. 4 &rpar.
.br
         fread&lpar. nHandle&comma. @cBuffer&comma. 4 &rpar.
.br
         ? &cdq.Number of records in file&colon.&cdq.&comma. BIN2U&lpar. cBuffer &rpar.
.br
         fclose&lpar. nHandle &rpar.
.br
      ELSE
.br
         ? &cdq.Can not open file&cdq.
.br
      ENDIF
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.BIN2U&lpar.&rpar. is an XBase++ compatibility function and does not exist  as a standard CA&minus.Clipper 5.x function.  This function is only visible if source&slash.rtl&slash.binnum.c was compiled  with the HB&us.COMPAT&us.XPP
flag.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=20.BIN2I():elink.
.br
:link reftype=hd res=21.BIN2L():elink.
.br
:link reftype=hd res=19.BIN2W():elink.
.br
:link reftype=hd res=23.I2BIN():elink.
.br
:link reftype=hd res=24.L2BIN():elink.
.br
:link reftype=hd res=25.W2BIN():elink.
.br
:link reftype=hd res=26.WORD():elink.
.br
:link reftype=hd res=27.U2BIN():elink.
.br
:link reftype=hd res=28.FREAD():elink.
.br
:h2 id=BINAY res=23.I2BIN()
:i2 refid=BINARX.I2BIN()
:p.I2BIN&lpar.&rpar.
.br
.br
:hp2.Convert Harbour numeric into signed short encoded bytes:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.I2BIN&lpar. <nNumber> &rpar. &minus.&minus.> cBuffer:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nNumber> is a numeric value to convert &lpar.decimal digits are ignored&rpar..
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.I2BIN&lpar.&rpar. return two bytes character string that contain 16 bit  encoded signed short integer &lpar.least significant byte first&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.I2BIN&lpar.&rpar. is one of the low level binary conversion functions&comma. those  functions convert between Harbour numeric and a character  representation of numeric value. I2BIN&lpar.&rpar. take a numeric integer  value and
convert it into two bytes of encoded 16 bit signed short  integer.
.br
:p.You might ask what is the need for such functions&comma. well&comma. first of  all it allow you to read&slash.write information from&slash.to a binary file  &lpar.like extracting information from DBF header&rpar.&comma. it is
also a useful  way to share information from source other than Harbour &lpar.C for  instance&rpar..
.br
:p.I2BIN&lpar.&rpar. is the opposite of BIN2I&lpar.&rpar.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Update DBF &cdq.last update&cdq. date
.br
      #include &cdq.fileio.ch&cdq.
.br
      FUNCTION main&lpar.&rpar.
.br
      LOCAL nHandle&comma. cYear&comma. cMonth&comma. cDay
.br
      use test
.br
      ? &cdq.Original update date is&colon.&cdq.&comma. lupdate&lpar.&rpar.
.br
      close
.br
      nHandle &colon.&eq. fopen&lpar. &cdq.test.dbf&cdq.&comma. FO&us.READWRITE &rpar.
.br
      IF nHandle > 0
.br
         fseek&lpar. nHandle&comma. 1&comma. &rpar.
.br
         cYear  &colon.&eq. I2BIN&lpar. 68 &rpar.
.br
         cMonth &colon.&eq. I2BIN&lpar.  8 &rpar.
.br
         cDay   &colon.&eq. I2BIN&lpar.  1 &rpar.
.br
         fwrite&lpar. nHandle&comma. cYear &comma. 1 &rpar.   &slash.&slash. write only the first byte
.br
         fwrite&lpar. nHandle&comma. cMonth&comma. 1 &rpar.
.br
         fwrite&lpar. nHandle&comma. cDay  &comma. 1 &rpar.
.br
         fclose&lpar. nHandle &rpar.
.br
         use test
.br
         ? &cdq.New update date is&colon.&cdq.&comma. lupdate&lpar.&rpar.
.br
         close
.br
      ELSE
.br
         ? &cdq.Can not open file&cdq.
.br
      ENDIF
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.I2BIN&lpar.&rpar. works exactly like CA&minus.Clipper's I2BIN&lpar.&rpar.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=20.BIN2I():elink.
.br
:link reftype=hd res=21.BIN2L():elink.
.br
:link reftype=hd res=22.BIN2U():elink.
.br
:link reftype=hd res=19.BIN2W():elink.
.br
:link reftype=hd res=24.L2BIN():elink.
.br
:link reftype=hd res=25.W2BIN():elink.
.br
:link reftype=hd res=26.WORD():elink.
.br
:link reftype=hd res=27.U2BIN():elink.
.br
:link reftype=hd res=29.FWRITE():elink.
.br
:h2 id=BINAY res=25.W2BIN()
:i2 refid=BINARX.W2BIN()
:p.W2BIN&lpar.&rpar.
.br
.br
:hp2.Convert Harbour numeric into unsigned short encoded bytes:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.W2BIN&lpar. <nNumber> &rpar. &minus.&minus.> cBuffer:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nNumber> is a numeric value to convert &lpar.decimal digits are ignored&rpar..
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.W2BIN&lpar.&rpar. return two bytes character string that contain 16 bit  encoded unsigned short integer &lpar.least significant byte first&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.W2BIN&lpar.&rpar. is one of the low level binary conversion functions&comma. those  functions convert between Harbour numeric and a character  representation of numeric value. W2BIN&lpar.&rpar. take a numeric integer  value and
convert it into two bytes of encoded 16 bit unsigned short  integer.
.br
:p.You might ask what is the need for such functions&comma. well&comma. first of  all it allow you to read&slash.write information from&slash.to a binary file  &lpar.like extracting information from DBF header&rpar.&comma. it is
also a useful  way to share information from source other than Harbour &lpar.C for  instance&rpar..
.br
:p.W2BIN&lpar.&rpar. is the opposite of BIN2W&lpar.&rpar.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.W2BIN&lpar.&rpar. is an XBase++ compatibility function and does not exist  as a standard CA&minus.Clipper 5.x function.  This function is only visible if source&slash.rtl&slash.binnum.c was compiled  with the HB&us.COMPAT&us.XPP
flag.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=20.BIN2I():elink.
.br
:link reftype=hd res=21.BIN2L():elink.
.br
:link reftype=hd res=22.BIN2U():elink.
.br
:link reftype=hd res=19.BIN2W():elink.
.br
:link reftype=hd res=23.I2BIN():elink.
.br
:link reftype=hd res=24.L2BIN():elink.
.br
:link reftype=hd res=26.WORD():elink.
.br
:link reftype=hd res=27.U2BIN():elink.
.br
:link reftype=hd res=29.FWRITE():elink.
.br
:h2 id=BINAY res=24.L2BIN()
:i2 refid=BINARX.L2BIN()
:p.L2BIN&lpar.&rpar.
.br
.br
:hp2.Convert Harbour numeric into signed long encoded bytes:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.L2BIN&lpar. <nNumber> &rpar. &minus.&minus.> cBuffer:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nNumber> is a numeric value to convert &lpar.decimal digits are ignored&rpar..
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.L2BIN&lpar.&rpar. return four bytes character string that contain 32 bit  encoded signed long integer &lpar.least significant byte first&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.L2BIN&lpar.&rpar. is one of the low level binary conversion functions&comma. those  functions convert between Harbour numeric and a character  representation of numeric value. L2BIN&lpar.&rpar. take a numeric integer  value and
convert it into four bytes of encoded 32 bit signed long  integer.
.br
:p.You might ask what is the need for such functions&comma. well&comma. first of  all it allow you to read&slash.write information from&slash.to a binary file  &lpar.like extracting information from DBF header&rpar.&comma. it is
also a useful  way to share information from source other than Harbour &lpar.C for  instance&rpar..
.br
:p.L2BIN&lpar.&rpar. is the opposite of BIN2L&lpar.&rpar.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.L2BIN&lpar.&rpar. works exactly like CA&minus.Clipper's L2BIN&lpar.&rpar.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=20.BIN2I():elink.
.br
:link reftype=hd res=21.BIN2L():elink.
.br
:link reftype=hd res=22.BIN2U():elink.
.br
:link reftype=hd res=19.BIN2W():elink.
.br
:link reftype=hd res=23.I2BIN():elink.
.br
:link reftype=hd res=25.W2BIN():elink.
.br
:link reftype=hd res=26.WORD():elink.
.br
:link reftype=hd res=27.U2BIN():elink.
.br
:link reftype=hd res=29.FWRITE():elink.
.br
:h2 id=BINAY res=27.U2BIN()
:i2 refid=BINARX.U2BIN()
:p.U2BIN&lpar.&rpar.
.br
.br
:hp2.Convert Harbour numeric into unsigned long encoded bytes:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.U2BIN&lpar. <nNumber> &rpar. &minus.&minus.> cBuffer:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nNumber> is a numeric value to convert &lpar.decimal digits are ignored&rpar..
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.U2BIN&lpar.&rpar. return four bytes character string that contain 32 bit  encoded unsigned long integer &lpar.least significant byte first&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.U2BIN&lpar.&rpar. is one of the low level binary conversion functions&comma. those  functions convert between Harbour numeric and a character  representation of numeric value. U2BIN&lpar.&rpar. take a numeric integer  value and
convert it into four bytes of encoded 32 bit unsigned long  integer.
.br
:p.You might ask what is the need for such functions&comma. well&comma. first of  all it allow you to read&slash.write information from&slash.to a binary file  &lpar.like extracting information from DBF header&rpar.&comma. it is
also a useful  way to share information from source other than Harbour &lpar.C for  instance&rpar..
.br
:p.U2BIN&lpar.&rpar. is the opposite of BIN2U&lpar.&rpar.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.U2BIN&lpar.&rpar. is an XBase++ compatibility function and does not exist  as a standard CA&minus.Clipper 5.x function.  This function is only visible if source&slash.rtl&slash.binnum.c was compiled  with the HB&us.COMPAT&us.XPP
flag.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=20.BIN2I():elink.
.br
:link reftype=hd res=21.BIN2L():elink.
.br
:link reftype=hd res=22.BIN2U():elink.
.br
:link reftype=hd res=19.BIN2W():elink.
.br
:link reftype=hd res=23.I2BIN():elink.
.br
:link reftype=hd res=24.L2BIN():elink.
.br
:link reftype=hd res=25.W2BIN():elink.
.br
:link reftype=hd res=26.WORD():elink.
.br
:link reftype=hd res=29.FWRITE():elink.
.br
:h1 CONVY.CONVERSION
:h2  res=26.WORD()
:i1 id=CONVEX.CONVERSION
:i2 refid=CONVEX.WORD()
:p.WORD&lpar.&rpar.
.br
.br
:hp2.Converts double to integer values.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.WORD&lpar. <nDouble> &rpar. &minus.&minus.> <nInteger>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nDouble> is a numeric double value.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.WORD&lpar.&rpar. return an integer in the range +&minus.32767
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts double values to integers to use  within the CALL command
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.The Clipper NG states that WORD&lpar.&rpar. will only work when used in CALL  commands parameter list&comma. otherwise it will return NIL&comma. in Harbour  it will work anywhere.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=30.CALL:elink.
.br
:h1 DATAY.DATA INPUT AND OUTPUT
:h2  res=31.DBEDIT()*
:i1 id=DATAX.DATA INPUT AND OUTPUT
:i2 refid=DATAX.DBEDIT()*
:p.DBEDIT&lpar.&rpar.*
.br
.br
:hp2.Browse records in a table:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBEDIT&lpar. &lbrk.<nTop>&rbrk..&comma. &lbrk.<nLeft>&rbrk..&comma. &lbrk.<nBottom>&rbrk..&comma. &lbrk.<nRight>&rbrk..&comma. &lbrk.<acColumns>&rbrk..&comma. &lbrk.<xUserFunc>&rbrk..&comma.:ehp2.
:hp2.&lbrk.<xColumnSayPictures>&rbrk..&comma. &lbrk.<xColumnHeaders>&rbrk..&comma. &lbrk.<xHeadingSeparators>&rbrk..&comma. &lbrk.<xColumnSeparators>&rbrk..&comma. &lbrk.<xFootingSeparators>&rbrk..&comma.:ehp2.
:hp2.&lbrk.<xColumnFootings>&rbrk.. &rpar. &minus.&minus.> lOk:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nTop> coordinate for top row display. <nTop> could range from 0  to MAXROW&lpar.&rpar.&comma. default is 0.
.br
:p.<nLeft> coordinate for left column display. <nLeft> could range  from 0 to MAXCOL&lpar.&rpar.&comma. default is 0.
.br
:p.<nBottom> coordinate for bottom row display. <nBottom> could range  from 0 to MAXROW&lpar.&rpar.&comma. default is MAXROW&lpar.&rpar..
.br
:p.<nRight> coordinate for right column display. <nRight> could range  from 0 to MAXCOL&lpar.&rpar.&comma. default is MAXCOL&lpar.&rpar..
.br
:p.<acColumns> is an array of character expressions that contain  database fields names or expressions to display in each column.  If not specified&comma. the default is to display all fields from the  database in the current work
area.
.br
:p.<xUserFunc> is a name of a user defined function or a code block  that would be called every time unrecognized key is been pressed or  when there are no keys waiting to be processed and DBEDIT&lpar.&rpar. goes  into idle mode. If
<xUserFunc> is a character string&comma. it must  contain root name of a valid user define function without  parentheses. Both the user define function or the code block should  accept two parameters&colon. nMode&comma.
nCurrentColumn. Both should return  a numeric value that correspond to one of the expected return codes  &lpar.see table below for a list of nMode and return codes&rpar..
.br
:p.<xColumnSayPictures> is an optional picture. If <xColumnSayPictures>  is a character string&comma. all columns would used this value as a  picture string. If <xColumnSayPictures> is an array&comma. each element  should be a
character string that correspond to a picture string  for the column with the same index. Look at the help for @...SAY  to get more information about picture values.
.br
:p.<xColumnHeaders> contain the header titles for each column&comma. if this  is a character string&comma. all columns would have that same header&comma. if  this is an array&comma. each element is a character string that contain
the header title for one column. Header may be split to more than  one line by placing semicolon &lpar.&semi.&rpar. in places where you want to break  line. If omitted&comma. the default value for each column header is taken
from <acColumns> or field name if <acColumns> was not specified.
.br
:p.<xHeadingSeparators> is an array that contain characters that draw  the lines separating the headers and the fields data. Instead of an  array you can use a character string that would be used to display  the same line for all
fields. Default value is a double line.
.br
:p.<xColumnSeparators> is an array that contain characters that draw  the lines separating displayed columns. Instead of an array you can  use a character string that would be used to display the same line  for all fields. Default
value is a single line.
.br
:p.<xFootingSeparators> is an array that contain characters that draw  the lines separating the fields data area and the footing area.  Instead of an array you can use a character string that would be  used to display the same line
for all footers. Default is to have to  no footing separators.
.br
:p.<xColumnFootings> contain the footing to be displayed at the bottom  of each column&comma. if this is a character string&comma. all columns would  have that same footer&comma. if this is an array&comma. each element is a
character string that contain the footer for one column. Footer may  be split to more than one line by placing semicolon &lpar.&semi.&rpar. in places  where you want to break line. If omitted&comma. no footer are displayed.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBEDIT&lpar.&rpar. return .F. if there is no database in use or if the number  of columns to display is zero&comma. else DBEDIT&lpar.&rpar. return .T.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.DBEDIT&lpar.&rpar. display and edit records from one or more work areas in  a grid on screen. Each column is defined by element from <acColumns>  and is the equivalent of one field. Each row is equivalent of one  database record.
.br
:p.Following are active keys that handled by DBEDIT&lpar.&rpar.&colon.
:p.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
.br
:table cols='14 44'.
:row.
:c.Key
:c.Meaning
:row.
:c.
:row.
:c.Left
:c.Move one column to the left (previous field)
:row.
:c.Right
:c.Move one column to the right (next field)
:row.
:c.Up
:c.Move up one row (previous record)
:row.
:c.Down
:c.Move down one row (next record)
:row.
:c.Page-Up
:c.Move to the previous screen
:row.
:c.Page-Down
:c.Move to the next screen
:row.
:c.Ctrl Page-Up
:c.Move to the top of the file
:row.
:c.Ctrl Page-Down
:c.Move to the end of the file
:row.
:c.Home
:c.Move to the leftmost visible column
:row.
:c.End
:c.Move to the rightmost visible column
:row.
:c.Ctrl Left
:c.Pan one column to the left
:row.
:c.Ctrl Right
:c.Pan one column to the right
:row.
:c.Ctrl Home
:c.Move to the leftmost column
:row.
:c.Ctrl End
:c.Move to the rightmost column
:etable.
.br
.br
:p.When <xUserFunc> is omitted&comma. two more keys are active&colon.
.br
:table cols=' 5 18'.
:row.
:c.Key
:c.Meaning
:row.
:c.
:row.
:c.Esc
:c.Terminate BROWSE()
:row.
:c.Enter
:c.Terminate BROWSE()
:etable.
.br
.br
:p.When DBEDIT&lpar.&rpar. execute <xUserFunc> it pass the following arguments&colon.  nMode and the index of current record in <acColumns>. If <acColumns>  is omitted&comma. the index number is the FIELD&lpar.&rpar. number of the
open  database structure.
.br
:p.DBEDIT&lpar.&rpar. nMode could be one of the following&colon.
:p.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
.br
:table cols='12 54'.
:row.
:c.Dbedit.ch
:c.Meaning
:row.
:c.
:row.
:c.DE_IDLE
:c.DBEDIT() is idle, all movement keys have been handled.
:row.
:c.DE_HITTOP
:c.Attempt to cursor past top of file.
:row.
:c.DE_HITBOTTOM
:c.Attempt to cursor past bottom of file.
:row.
:c.DE_EMPTY
:c.No records in work area, database is empty.
:row.
:c.DE_EXCEPT
:c.Key exception.
:etable.
.br
.br
:p.The user define function or code block must return a value that tell  DBEDIT&lpar.&rpar. what to do next.
.br
:p.User function return codes&colon.
:p.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
.br
:table cols='10  5 40'.
:row.
:c.Dbedit.ch
:c.Value
:c.Meaning
:row.
:c.
:row.
:c.DE_ABORT
:c.0
:c.Abort DBEDIT().
:row.
:c.DE_CONT
:c.1
:c.Continue DBEDIT() as is.
:row.
:c.DE_REFRESH
:c.2
:c.Force reread/redisplay of all data rows.
:etable.
.br
.br
:p.The user function is called once in each of the following cases&colon.  &minus. The database is empty.  &minus. The user try to move past top of file or past bottom file.  &minus. Key exception&comma. the uses had pressed a key
that is not handled by DBEDIT&lpar.&rpar..  &minus. The keyboard buffer is empty or a screen refresh had just occurred  DBEDIT&lpar.&rpar. is a compatibility function&comma. it is superseded by the  T
Browse class and there for not recommended for new applications.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Browse a file using default values
.br
      USE Test
.br
      DBEDIT&lpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.<xUserFunc> can take a code block value&comma. this is a Harbour  extension.
.br
:p.CA&minus.Clipper will throw an error if there's no database open&comma. Harbour  would return .F.
.br
:p.CA&minus.Clipper is buggy and will throw an error if the number of columns  zero&comma. Harbour would return .F.
.br
:p.The CA&minus.Clipper 5.2 NG state that the return value is NIL&comma. this is  wrong and should be read logical.
.br
:p.There is an undocumented result code &lpar.3&rpar. from the user defined  function in Clipper &lpar.both 87 and 5.x&rpar.. This is an Append Mode which&colon.  &cdq.split the screen to allow data to be appended in windowed
area&cdq..  This mode is not supported by Harbour.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Header files are dbedit.ch&comma. inkey.ch  Library is rtl
.br
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=32.@...SAY:elink.
.br
:link reftype=hd res=33.BROWSE():elink.
.br
:link reftype=hd res=34.TBROWSE CLASS:elink.
.br
:link reftype=hd res=35.TRANSFORM():elink.
.br
:h2 id=DATAY res=33.BROWSE()
:i2 refid=DATAX.BROWSE()
:p.BROWSE&lpar.&rpar.
.br
.br
:hp2.Browse a database file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.BROWSE&lpar. &lbrk.<nTop>&comma. <nLeft>&comma. <nBottom>&comma. <nRight>&rbrk.. &rpar. &minus.&minus.> lOk:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nTop> coordinate for top row display.
.br
:p.<nLeft> coordinate for left column display.
.br
:p.<nBottom> coordinate for bottom row display.
.br
:p.<nRight> coordinate for right column display.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.BROWSE&lpar.&rpar. return .F. if there is no database open in this work area&comma.  else it return .T.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.BROWSE&lpar.&rpar. is a general purpose database browser&comma. without any  thinking you can browse a file using the following keys&colon.
.br
:table cols='14 44'.
:row.
:c.Key
:c.Meaning
:row.
:c.
:row.
:c.Left
:c.Move one column to the left (previous field)
:row.
:c.Right
:c.Move one column to the right (next field)
:row.
:c.Up
:c.Move up one row (previous record)
:row.
:c.Down
:c.Move down one row (next record)
:row.
:c.Page-Up
:c.Move to the previous screen
:row.
:c.Page-Down
:c.Move to the next screen
:row.
:c.Ctrl Page-Up
:c.Move to the top of the file
:row.
:c.Ctrl Page-Down
:c.Move to the end of the file
:row.
:c.Home
:c.Move to the leftmost visible column
:row.
:c.End
:c.Move to the rightmost visible column
:row.
:c.Ctrl Left
:c.Pan one column to the left
:row.
:c.Ctrl Right
:c.Pan one column to the right
:row.
:c.Ctrl Home
:c.Move to the leftmost column
:row.
:c.Ctrl End
:c.Move to the rightmost column
:row.
:c.Esc
:c.Terminate BROWSE()
:etable.
.br
:p.On top of the screen you see a status line with the following  indication&colon.
.br
:table cols='15 48'.
:row.
:c.Record ###/###
:c.Current record number / Total number of records.
:row.
:c.&lt.none&gt.
:c.There are no records, the file is empty.
:row.
:c.&lt.new&gt.
:c.You are in append mode at the bottom of file.
:row.
:c.&lt.Deleted&gt.
:c.Current record is deleted.
:row.
:c.&lt.bof&gt.
:c.You are at the top of file.
:etable.
.br
:p.You should pass whole four valid coordinate&comma. if less than four  parameters are passed to BROWSE&lpar.&rpar. the coordinate are default to&colon.  1&comma. 0&comma. MAXROW&lpar.&rpar.&comma. MAXCOL&lpar.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. this one shows you how to browse around
.br
      USE Around
.br
      BROWSE&lpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=31.DBEDIT()*:elink.
.br
:link reftype=hd res=34.TBROWSE CLASS:elink.
.br
:h1 TBROY.TBROWSE CLASS
:h2  res=36.TBrowseDB()
:i1 id=TBROWX.TBROWSE CLASS
:i2 refid=TBROWX.TBROWSEDB()
:p.TBrowseDB&lpar.&rpar.
.br
.br
:hp2.Create a new TBrowse object to be used with database file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.TBrowseDB&lpar. &lbrk.<nTop>&rbrk..&comma. &lbrk.<nLeft>&rbrk..&comma. &lbrk.<nBottom>&rbrk..&comma. &lbrk.<nRight>&rbrk.. &rpar. &minus.&minus.> oBrowse:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nTop> coordinate for top row display.
.br
:p.<nLeft> coordinate for left column display.
.br
:p.<nBottom> coordinate for bottom row display.
.br
:p.<nRight> coordinate for right column display.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.TBrowseDB&lpar.&rpar. return new TBrowse object with the specified coordinate  and a default &colon.SkipBlock&comma. &colon.GoTopBlock and &colon.GoBottomBlock to browse  a database file.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.TBrowseDB&lpar.&rpar. is a quick way to create a TBrowse object along with  the minimal support needed to browse a database. Note that the  returned TBrowse object contain no TBColumn objects and you need  to add column for each
field by your self.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      for a good example&comma. look at the source code for BROWSE&lpar.&rpar. function
.br
      at source&slash.rtl&slash.browse.prg
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.TBrowseDB&lpar.&rpar. works exactly like CA&minus.Clipper's TBrowseDB&lpar.&rpar..
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=33.BROWSE():elink.
.br
:link reftype=hd res=37.TBCOLUMN CLASS:elink.
.br
:link reftype=hd res=34.TBROWSE CLASS:elink.
.br
:link reftype=hd res=38.TBROWSENEW():elink.
.br
:h2 id=DATAY res=39.dbSkipper()
:i1 id=DATABX.DATABASE
:i2 refid=DATABX.DBSKIPPER()
:p.dbSkipper&lpar.&rpar.
.br
.br
:hp2.Helper function to skip a database:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.dbSkipper&lpar. <nRecs> &rpar. &minus.&minus.> nSkipped:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nRecs> is the number of records to skip relative to current record.  Positive number would try to move the record pointer forward&comma. while  a negative number would try to move the record pointer back <nRecs>  records.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.dbSkipper&lpar.&rpar. return the number of actual record skipped.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.dbSkipper&lpar.&rpar. is a helper function used in browse mechanism to skip  a number of records while giving the caller indication about the  actual records skipped.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. open a file and find if we've got enough records in it
.br
      USE MonthSales
.br
      IF dbSkipper&lpar. 100 &rpar. &eq.&eq. 100
.br
         ? &cdq.Good work! You can party now&cdq.
.br
      ELSE
.br
         ? &cdq.Too bad&comma. you should really work harder&cdq.
.br
      ENDIF
.br
      CLOSE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.dbSkipper&lpar.&rpar. is an XBase++ compatibility function and does not exist  as a standard CA&minus.Clipper 5.x function.
.br
:p.This function is only visible if source&slash.rtl&slash.browdb.prg was compiled  with the HB&us.COMPAT&us.XPP flag.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=40.DBSKIP():elink.
.br
:link reftype=hd res=41.SKIP:elink.
.br
:h1 OOPY.OOP COMMAND
:h2  res=42.CLASS
:i1 id=OOP CX.OOP COMMAND
:i2 refid=OOP CX.CLASS
:p.CLASS
.br
.br
:hp2.Define a Class for Object Oriented Programming:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&lbrk.CREATE&rbrk.. CLASS <ClassName> &lbrk. <FROM&comma. INHERIT> <SuperClass1> &lbrk.&comma.<SuperClassN>&rbrk.. &rbrk..  &lbrk.STATIC&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<ClassName>  Name of the class to define. By tradition&comma. Harbour  classes start with &cdq.T&cdq. to avoid collisions with user&minus.  created classes.
.br
:p.<SuperClass1...n> The Parent class&lpar.es&rpar. to use for inheritance.  Harbour supports Multiple Inheritance.
.br
:p.STATIC       This clause causes the class function to be declared  as a static function. It will therefore not be available outside the current module.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.CLASS creates a class from which you can create objects.  The CLASS command begins the class specification&comma. in which the DATA  elements &lpar.also known as instance variables&rpar. and METHODS of the  class are named. The
following scoping commands may also appear.  They control the default scope of DATA and METHOD commands that follow them.
.br
         EXPORTED&colon.
.br
         VISIBLE&colon.
.br
         HIDDEN&colon.
.br
         PROTECTED&colon.
.br
:p.The class specification ends with the END CLASS command.
.br
:p.Classes can inherit from multiple <SuperClasses>&comma. and the chain of  inheritance can extend to many levels.
.br
:p.A program uses a Class by calling the Class Constructor&comma. usually the  New&lpar.&rpar. method&comma. to create an object. That object is usually assigned  to a variable&comma. which is used to access the DATA elements and
methods.
.br
:p.Harbour's OOP syntax and implementation supports Scoping &lpar.Protect&comma. Hidden and Readonly&rpar.  and Delegating&comma. and is largely compatible with Class&lpar.y&rpar.&lpar.tm&rpar.&comma. TopClass&lpar.tm&rpar.  and
Visual Objects&lpar.tm&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      CLASS TBColumn
.br

.br
         DATA Block      &slash.&slash. Code block to retrieve data for the column
.br
         DATA Cargo      &slash.&slash. User&minus.definable variable
.br
         DATA ColorBlock &slash.&slash. Code block that determines color of data items
.br
         DATA ColSep     &slash.&slash. Column separator character
.br
         DATA DefColor   &slash.&slash. Array of numeric indexes into the color table
.br
         DATA Footing    &slash.&slash. Column footing
.br
         DATA FootSep    &slash.&slash. Footing separator character
.br
         DATA Heading    &slash.&slash. Column heading
.br
         DATA HeadSep    &slash.&slash. Heading separator character
.br
         DATA Width      &slash.&slash. Column display width
.br
         DATA ColPos     &slash.&slash. Temporary column position on screen
.br

.br
         METHOD New&lpar.&rpar.    &slash.&slash. Constructor
.br

.br
      ENDCLASS
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.CLASS is a Harbour extension.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=43.TCLASS():elink.
.br
:link reftype=hd res=44.OBJECT ORIENTED PROGRAMMING:elink.
.br
:link reftype=hd res=45.DATA:elink.
.br
:link reftype=hd res=46.METHOD:elink.
.br
:h2 id=OOPY res=45.DATA
:i2 refid=OOP CX.DATA
:p.DATA
.br
.br
:hp2.Alternate syntax for VAR&colon. instance variable for the objects.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DATA <DataName1> &lbrk.&comma.<DataNameN>&rbrk.. &lbrk. AS <type> &rbrk.. &lbrk. INIT <uValue> &rbrk..:ehp2.
:p.:hp2.&lbrk.&lbrk.EXPORTED &splitvbar. VISIBLE&rbrk.. &splitvbar. &lbrk.PROTECTED&rbrk.. &splitvbar. &lbrk.HIDDEN&rbrk..&rbrk.. &lbrk.READONLY &splitvbar. RO&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<DataName1>  Name of the DATA
.br
:p.<type>       Optional data type specification from the following&colon.  Character&comma. Numeric&comma. Date&comma. Logical&comma. Codeblock&comma. Nil.
.br
:p.<uValue>     Optional initial value when creating a new object.
.br
:p.EXPORTED     Specifies that this DATA is accessible to functions and  methods outside of the class.  VISIBLE is a synonym for EXPORTED.
.br
:p.PROTECTED    Specifies that this DATA is only accessible to functions and methods within this class and its subclasses.
.br
:p.HIDDEN       Specifies that this DATA is only accessible to the  class where it was defined&comma. and is not inherited by the  subclasses.
.br
:p.READONLY     Restricts assignment to the variable. If specified with  the EXPORTED clause&comma. assignment is only permitted from the current  class and its subclasses.  If specified with the PROTECTED clause&comma.  assignment
is only permitted from the current class.  RO is a synonym for READONLY.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.DATA elements can also be thought of as the &cdq.properties&cdq. of an  object. They can be of any data type&comma. including codeblock.  Once an object has been created&comma. the DATA elements are referenced  with the colon
&lpar.&colon.&rpar. as in  MyObject&colon.Heading &colon.&eq. &cdq.Last name&cdq..  Usually a class also defines methods to manipulate the DATA.
.br
:p.You can use the &cdq.AS <type>&cdq. clause to enforce that the DATA is  maintained as a certain type. Otherwise it will take on the type of  whatever value is first assigned to it.
.br
:p.Use the &cdq.INIT <uValue>&cdq. clause to initialize that DATA to <uValue>  whenever a new object is created.
.br
:p.VAR can be a synonym for DATA&comma. or it can use a slightly different  syntax for compatibility with other dialects.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      CLASS TBColumn
.br

.br
         DATA Block      &slash.&slash. Code block to retrieve data for the column
.br
         DATA Cargo      &slash.&slash. User&minus.definable variable
.br
         DATA ColorBlock &slash.&slash. Code block that determines color of data items
.br
         DATA ColSep     &slash.&slash. Column separator character
.br
         DATA DefColor   &slash.&slash. Array of numeric indexes into the color table
.br
         DATA Footing    &slash.&slash. Column footing
.br
         DATA FootSep    &slash.&slash. Footing separator character
.br
         DATA Heading    &slash.&slash. Column heading
.br
         DATA HeadSep    &slash.&slash. Heading separator character
.br
         DATA Width      &slash.&slash. Column display width
.br
         DATA ColPos     &slash.&slash. Temporary column position on screen
.br

.br
         METHOD New&lpar.&rpar.    &slash.&slash. Constructor
.br

.br
      ENDCLASS
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.DATA is a Harbour extension.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=44.OBJECT ORIENTED PROGRAMMING:elink.
.br
:link reftype=hd res=42.CLASS:elink.
.br
:link reftype=hd res=46.METHOD:elink.
.br
:link reftype=hd res=47.CLASSDATA:elink.
.br
:link reftype=hd res=48.VAR:elink.
.br
:h2 id=OOPY res=47.CLASSDATA
:i2 refid=OOP CX.CLASSDATA
:p.CLASSDATA
.br
.br
:hp2.Define a CLASSDATA variable for a class &lpar.NOT for an Object!&rpar.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.CLASSDATA <DataName1> &lbrk.&comma.<DataNameN>&rbrk.. &lbrk. AS <type> &rbrk.. &lbrk. INIT <uValue> &rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<DataName1>  Name of the DATA
.br
:p.<type>       Optional data type specification from the following&colon.  Character&comma. Numeric&comma. Date&comma. Logical&comma. Codeblock&comma. Nil
.br
:p.<uValue>     Optional initial value at program startup
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.CLASSDATA variables can also be thought of as the &cdq.properties&cdq. of an  entire class. Each CLASSDATA exists only once&comma. no matter how many  objects are created. A common usage is for a counter that is  incremented
whenever an object is created and decremented when one  is destroyed&comma. thus monitoring the number of objects in existance  for this class.
.br
:p.You can use the &cdq.AS <type>&cdq. clause to enforce that the CLASSDATA is  maintained as a certain type. Otherwise it will take on the type of  whatever value is first assigned to it.  Use the &cdq.INIT <uValue>&cdq. clause to
initialize that DATA to <uValue>  whenever the class is first used.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      CLASS TWindow
.br
         DATA   hWnd&comma. nOldProc
.br
         CLASSDATA lRegistered AS LOGICAL
.br
      ENDCLASS
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.CLASSDATA is a Harbour extension.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=44.OBJECT ORIENTED PROGRAMMING:elink.
.br
:link reftype=hd res=42.CLASS:elink.
.br
:link reftype=hd res=46.METHOD:elink.
.br
:link reftype=hd res=45.DATA:elink.
.br
:h2 id=OOPY res=46.METHOD
:i2 refid=OOP CX.METHOD
:p.METHOD
.br
.br
:hp2.Declare a METHOD for a class in the class header:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.METHOD <MethodName>&lpar. &lbrk.<params&comma....>&rbrk.. &rpar. &lbrk. CONSTRUCTOR &rbrk..:ehp2.
:p.:hp2.METHOD <MethodName>&lpar. &lbrk.<params&comma....>&rbrk.. &rpar. INLINE <Code&comma....>:ehp2.
:p.:hp2.METHOD <MethodName>&lpar. &lbrk.<params&comma....>&rbrk.. &rpar. BLOCK  <CodeBlock>:ehp2.
:p.:hp2.METHOD <MethodName>&lpar. &lbrk.<params&comma....>&rbrk.. &rpar. EXTERN <FuncName>&lpar.&lbrk.<args&comma....>&rbrk..&rpar.:ehp2.
:p.:hp2.METHOD <MethodName>&lpar. &lbrk.<params&comma....>&rbrk.. &rpar. SETGET:ehp2.
:p.:hp2.METHOD <MethodName>&lpar. &lbrk.<params&comma....>&rbrk.. &rpar. VIRTUAL:ehp2.
:p.:hp2.METHOD <MethodName>&lpar. &lbrk.<param>&rbrk.. &rpar.      OPERATOR <op>:ehp2.
:p.:hp2.METHOD <MethodName>&lpar. &lbrk.<params&comma....>&rbrk.. &rpar. CLASS <ClassName>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<MethodName>  Name of the method to define
.br
:p.<params&comma....>  Optional parameter list
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Methods are &cdq.class functions&cdq. which do the work of the class.  All methods must be defined in the class header between the  CLASS and ENDCLASS commands.  If the body of a method is not fully  defined here&comma. the full
body is written below the ENDCLASS command  using this syntax&colon.
.br
:p.METHOD <MethodName>&lpar. &lbrk.<params&comma....>&rbrk.. &rpar. CLASS <ClassName>
.br
:p.Methods can reference the current object with the keyword &cdq.Self&colon.&cdq. or  its shorthand version &cdq.&colon.&colon.&cdq..
.br
:p.CLAUSES&colon.
.br
:p.CONSTRUCTOR  Defines a special method Class Constructor method&comma.  used to create objects.  This is usually the  New&lpar.&rpar. method. Constructors always return the new  object.
.br
:p.INLINE       Fast and easy to code&comma. INLINE lets you define the  code for the method immediately within the definition  of the Class. Any methods not declared INLINE or BLOCK  must be fully defined after the ENDCLASS
command.  The <Code&comma....> following INLINE receives a parameter  of Self. If you need to receive more parameters&comma. use  the BLOCK clause instead.
.br
:p.BLOCK        Use this clause when you want to declare fast 'inline'  methods that need parameters. The first parameter to  <CodeBlock> must be Self&comma. as in&colon.
.br
:p.METHOD <MethodName> BLOCK &lbrc.&splitvbar.Self&comma.<arg1>&comma.<arg2>&comma. ...&comma.<argN>&splitvbar....&rbrc.
.br
:p.EXTERN       If an external function does what the method needs&comma.  use this clause to make an optimized call to that  function directly.
.br
:p.SETGET       For calculated Data. The name of the method can be  manipulated like a Data element to Set or Get a value.
.br
:p.VIRTUAL      Methods that do nothing. Useful for Base classes where  the child class will define the method's behavior&comma. or  when you are first creating and testing a Class.
.br
:p.OPERATOR     Operator Overloading for classes.  See example Tests&slash.TestOp.prg for details.
.br
:p.CLASS <ClassName>  Use this syntax only for defining a full method after  the ENDCLASS command.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      CLASS TWindow
.br
         DATA   hWnd&comma. nOldProc
.br
         METHOD New&lpar. &rpar. CONSTRUCTOR
.br
         METHOD Capture&lpar.&rpar. INLINE  SetCapture&lpar. &colon.&colon.hWnd &rpar.
.br
         METHOD End&lpar.&rpar. BLOCK  &lbrc. &splitvbar. Self&comma. lEnd &splitvbar. If&lpar. lEnd &colon.&eq. &colon.&colon.lValid&lpar.&rpar.&comma.&semi.
.br
                                 &colon.&colon.PostMsg&lpar. WM&us.CLOSE &rpar.&comma.&rpar.&comma. lEnd &rbrc.
.br
         METHOD EraseBkGnd&lpar. hDC &rpar.
.br
         METHOD cTitle&lpar. cNewTitle &rpar. SETGET
.br
         METHOD Close&lpar.&rpar. VIRTUAL
.br
      ENDCLASS
.br

.br
      METHOD New&lpar. &rpar. CLASS TWindow
.br
         local nVar&comma. cStr
.br
         ... <code> ...
.br
         ... <code> ...
.br
      RETURN Self
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      TestOp.prg
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.METHOD is a Harbour extension.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=43.TCLASS():elink.
.br
:link reftype=hd res=44.OBJECT ORIENTED PROGRAMMING:elink.
.br
:link reftype=hd res=45.DATA:elink.
.br
:link reftype=hd res=42.CLASS:elink.
.br
:h2 id=OOPY res=49.MESSAGE
:i2 refid=OOP CX.MESSAGE
:p.MESSAGE
.br
.br
:hp2.Route a method call to another Method:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.MESSAGE <MessageName>   METHOD <MethodName>&lpar. &lbrk.<params&comma....>&rbrk.. &rpar.:ehp2.
:p.:hp2.MESSAGE <MessageName>&lpar.&rpar. METHOD <MethodName>&lpar. &lbrk.<params&comma....>&rbrk.. &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<MessageName>  The pseudo&minus.method name to define
.br
:p.<MethodName>   The method to create and call when <MessageName>  is invoked.
.br
:p.<params&comma....>   Optional parameter list for the method
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The MESSAGE command is a seldom&minus.used feature that lets you re&minus.route  a call to a method with a different name. This can be necessary if  a method name conflicts with a public function that needs to be  called from
within the class methods.
.br
:p.For example&comma. your app may have a public function called BeginPaint&lpar.&rpar.  that is used in painting windows. It would also be natural to have a  Window class method called &colon.BeginPaint&lpar.&rpar. that the
application can  call. But within the class method you would not be able to call the  public function because internally methods are based on static  functions &lpar.which hide public functions of the same name&rpar..
.br
:p.The MESSAGE command lets you create the true method with a different  name &lpar.&colon.&colon.xBeginPaint&lpar.&rpar.&rpar.&comma. yet still allow the &colon.&colon.BeginPaint&lpar.&rpar. syntax  to call
&colon.&colon.xBeginPaint&lpar.&rpar..  This is then free to call the public  function BeginPaint&lpar.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      CLASS TWindow
.br
         DATA   hWnd&comma. nOldProc
.br
         METHOD New&lpar. &rpar. CONSTRUCTOR
.br
         MESSAGE BeginPaint METHOD xBeginPaint&lpar.&rpar.
.br
      ENDCLASS
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.MESSAGE is a Harbour extension.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=46.METHOD:elink.
.br
:link reftype=hd res=45.DATA:elink.
.br
:link reftype=hd res=42.CLASS:elink.
.br
:link reftype=hd res=44.OBJECT ORIENTED PROGRAMMING:elink.
.br
:h2 id=OOPY res=50.ERROR HANDLER
:i2 refid=OOP CX.ERROR HANDLER
:p.ERROR HANDLER
.br
.br
:hp2.Designate a method as an error handler for the class:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ERROR HANDLER <MethodName>&lpar. &lbrk.<params&comma....>&rbrk.. &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<MethodName>  Name of the method to define
.br
:p.<params&comma....>  Optional parameter list
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.ERROR HANDLER names the method that should handle errors for the  class being defined.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      CLASS TWindow
.br
         ERROR HANDLER  MyErrHandler&lpar.&rpar.
.br
      ENDCLASS
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.ERROR HANDLER is a Harbour extension.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=44.OBJECT ORIENTED PROGRAMMING:elink.
.br
:link reftype=hd res=51.ON ERROR:elink.
.br
:link reftype=hd res=42.CLASS:elink.
.br
:link reftype=hd res=46.METHOD:elink.
.br
:link reftype=hd res=45.DATA:elink.
.br
:h2 id=OOPY res=51.ON ERROR
:i2 refid=OOP CX.ON ERROR
:p.ON ERROR
.br
.br
:hp2.Designate a method as an error handler for the class:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ON ERROR <MethodName>&lpar. &lbrk.<params&comma....>&rbrk.. &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<MethodName>  Name of the method to define
.br
:p.<params&comma....>  Optional parameter list
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.ON ERROR is a synonym for ERROR HANDLER.  It names the method that should handle errors for the  class being defined.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      CLASS TWindow
.br
         ON ERROR  MyErrHandler&lpar.&rpar.
.br
      ENDCLASS
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.ON ERROR is a Harbour extension.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=44.OBJECT ORIENTED PROGRAMMING:elink.
.br
:link reftype=hd res=50.ERROR HANDLER:elink.
.br
:link reftype=hd res=42.CLASS:elink.
.br
:link reftype=hd res=46.METHOD:elink.
.br
:link reftype=hd res=45.DATA:elink.
.br
:h2 id=OOPY res=52.ENDCLASS
:i2 refid=OOP CX.ENDCLASS
:p.ENDCLASS
.br
.br
:hp2.End the declaration of a class.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ENDCLASS:ehp2.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.ENDCLASS marks the end of a class declaration.  It is usually followed by the class methods that are not INLINE.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      CLASS TWindow
.br
         DATA   hWnd&comma. nOldProc
.br
      ENDCLASS
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.ON ERROR is a Harbour extension.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=44.OBJECT ORIENTED PROGRAMMING:elink.
.br
:link reftype=hd res=42.CLASS:elink.
.br
:link reftype=hd res=46.METHOD:elink.
.br
:link reftype=hd res=45.DATA:elink.
.br
:h1 DATEY.DATE
:h2  res=53.CDOW()
:i1 id=DATEX.DATE
:i2 refid=DATEX.CDOW()
:p.CDOW&lpar.&rpar.
.br
.br
:hp2.Converts a date to the day of week:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.CDOW&lpar.<dDate>&rpar.  &minus.&minus.> cDay:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<dDate>  Any date expression.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cDay>  The current day of week.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a character string of the day of the week&comma.  from a date expression <dDate> passed to it.  If a NULL date is passed to the function&comma. the value of the function  will be a NULL byte.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? CDOW&lpar.DATE&lpar.&rpar.&rpar.
.br
      if CDOW&lpar.DATE&lpar.&rpar.+10&rpar. &eq.&eq.&cdq.SUNDAY&cdq.
.br
         ? &cdq.This is a sunny day.&cdq.
.br
      Endif
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=54.DAY():elink.
.br
:link reftype=hd res=55.DOW():elink.
.br
:link reftype=hd res=56.DATE():elink.
.br
:link reftype=hd res=57.CMONTH():elink.
.br
:h2 id=DATEY res=57.CMONTH()
:i2 refid=DATEX.CMONTH()
:p.CMONTH&lpar.&rpar.
.br
.br
:hp2.Return the name of the month.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.CMONTH&lpar.<dDate>&rpar.  &minus.&minus.> cMonth:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<dDate>  Any date expression.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cMonth>  The current month name
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the name of the month &lpar.January&comma.February&comma.etc.&rpar.  from a date expression <dDate> passed to it.  If a NULL date is passed to the function&comma. the value of the function  will be a NULL
byte.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? CMONTH&lpar.DATE&lpar.&rpar.&rpar.
.br
      if CMONTH&lpar.DATE&lpar.&rpar.+10&rpar. &eq.&eq.&cdq.March&cdq.
.br
         ? &cdq.Have you done your system BACKUP?&cdq.
.br
      Endif
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=53.CDOW():elink.
.br
:link reftype=hd res=56.DATE():elink.
.br
:link reftype=hd res=58.MONTH():elink.
.br
:link reftype=hd res=59.YEAR():elink.
.br
:link reftype=hd res=55.DOW():elink.
.br
:link reftype=hd res=60.DTOC():elink.
.br
:h2 id=DATEY res=56.DATE()
:i2 refid=DATEX.DATE()
:p.DATE&lpar.&rpar.
.br
.br
:hp2.Return the Current OS Date:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DATE&lpar.&rpar. &minus.&minus.> dCurDate:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<dCurDate>  Current system date.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the current system date.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? Date&lpar.&rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      ? &cdq.Today is &cdq.&comma.Day&lpar.date&lpar.&rpar.&rpar.&comma.&cdq. of &cdq.&comma.cMonth&lpar.date&lpar.&rpar.&rpar.&comma.&cdq. of &cdq.&comma.Year&lpar.date&lpar.&rpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper Compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=61.CTOD():elink.
.br
:link reftype=hd res=62.DTOS():elink.
.br
:link reftype=hd res=60.DTOC():elink.
.br
:link reftype=hd res=54.DAY():elink.
.br
:link reftype=hd res=58.MONTH():elink.
.br
:link reftype=hd res=57.CMONTH():elink.
.br
:h2 id=DATEY res=61.CTOD()
:i2 refid=DATEX.CTOD()
:p.CTOD&lpar.&rpar.
.br
.br
:hp2.Converts a character string to a date expression:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.CTOD&lpar.<cDateString>&rpar.  &minus.&minus.> dDate:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cDateString> A character date in format 'mm&slash.dd&slash.yy'
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<dDate> A date expression
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts a date that has been entered as a character  expression to a date expression.The character expression will be in  the form &cdq.MM&slash.DD&slash.YY&cdq. &lpar.based on the default value in SET DATE&rpar.
or in  the appropriate format specified by the SET DATE TO command. If an  improper character string is passed to the function&comma.an empty date  value will be returned.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? CTOD&lpar.'12&slash.21&slash.00'&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=63.SET DATE:elink.
.br
:link reftype=hd res=56.DATE():elink.
.br
:link reftype=hd res=62.DTOS():elink.
.br
:h2 id=DATEY res=54.DAY()
:i2 refid=DATEX.DAY()
:p.DAY&lpar.&rpar.
.br
.br
:hp2.Return the numeric day of the month.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DAY&lpar.<cDate>&rpar. &minus.&minus.> nMonth:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cDate> Any valid date expression.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nMonth> Numeric value of the day of month.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the numeric value of the day of month from a  date.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? Day&lpar.DATE&lpar.&rpar.&rpar.
.br
      ? Day&lpar.DATE&lpar.&rpar.+6325&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=61.CTOD():elink.
.br
:link reftype=hd res=62.DTOS():elink.
.br
:link reftype=hd res=60.DTOC():elink.
.br
:link reftype=hd res=56.DATE():elink.
.br
:link reftype=hd res=58.MONTH():elink.
.br
:link reftype=hd res=57.CMONTH():elink.
.br
:h2 id=DATEY res=64.DAYS()
:i2 refid=DATEX.DAYS()
:p.DAYS&lpar.&rpar.
.br
.br
:hp2.Convert elapsed seconds into days:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DAYS&lpar.<nSecs> &rpar. &minus.&minus.> nDay:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nSecs> The number of seconds
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nDay>  The number of days
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts <nSecs> seconds to the equivalent number  of days&semi. 86399 seconds represents one day&comma. 0 seconds being midnight.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? DAYS&lpar.2434234&rpar.
.br
      ? &cdq.Has been passed &cdq.&comma.DAYS&lpar.63251&rpar.&comma.' since midnight'
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=65.SECONDS():elink.
.br
:link reftype=hd res=66.SECS():elink.
.br
:link reftype=hd res=67.ELAPTIME():elink.
.br
:h2 id=DATEY res=55.DOW()
:i2 refid=DATEX.DOW()
:p.DOW&lpar.&rpar.
.br
.br
:hp2.Value for the day of week.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DOW&lpar.<dDate>&rpar. &minus.&minus.> nDay:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<dDate>  Any valid date expression
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nDay>  The current day number
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the number representing the day of the week  for the date expressed as <dDate>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? DOW&lpar.DATE&lpar.&rpar.&rpar.
.br
      ? DOW&lpar.DATE&lpar.&rpar.&minus.6584&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=60.DTOC():elink.
.br
:link reftype=hd res=53.CDOW():elink.
.br
:link reftype=hd res=56.DATE():elink.
.br
:link reftype=hd res=62.DTOS():elink.
.br
:link reftype=hd res=54.DAY():elink.
.br
:h2 id=DATEY res=60.DTOC()
:i2 refid=DATEX.DTOC()
:p.DTOC&lpar.&rpar.
.br
.br
:hp2.Date to character conversion:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DTOC&lpar.<dDateString>&rpar.  &minus.&minus.> cDate:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<dDateString> Any date
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<dDate> Character represention of date
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts any date expression &lpar.a field or variable&rpar.  expressed as <dDateString> to a character expression in the default  format &cdq.MM&slash.DD&slash.YY&cdq.. The date format expressed by this function is
controled in part by the date format specified in the SET DATE  command
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? DTOC&lpar.Date&lpar.&rpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=63.SET DATE:elink.
.br
:link reftype=hd res=56.DATE():elink.
.br
:link reftype=hd res=62.DTOS():elink.
.br
:h2 id=DATEY res=62.DTOS()
:i2 refid=DATEX.DTOS()
:p.DTOS&lpar.&rpar.
.br
.br
:hp2.Date to string conversion:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DTOS&lpar.<dDateString>&rpar.  &minus.&minus.> cDate:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<dDateString> Any date
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<dDate> String notation of the date
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the value of <dDateString> as a character  string in the format of YYYYMMDD. If the value of <dDateString> is  an empty date&comma. this function will return eight blank spaces.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? DTOS&lpar.Date&lpar.&rpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=60.DTOC():elink.
.br
:link reftype=hd res=56.DATE():elink.
.br
:link reftype=hd res=62.DTOS():elink.
.br
:h1 TIMEY.TIME
:h2  res=67.ELAPTIME()
:i1 id=TIMEX.TIME
:i2 refid=TIMEX.ELAPTIME()
:p.ELAPTIME&lpar.&rpar.
.br
.br
:hp2.Calculates elapted time.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ELAPTIME&lpar.<cStartTime>&comma.<cEndTime>&rpar. &minus.&minus.> cDiference:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cStartTime> Start in time as a string format  <cEndTime>   End time as a string format
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cDiference>  Difference between the times
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a string that shows the difference between  the starting time represented as <cStartTime> and the ending time  as <cEndTime>. If the stating time is greater then the ending  time&comma. the function will
assume that the date changed once.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      Static cStartTime
.br
      Init Proc Startup
.br
      cStartTime&colon.&eq.Time&lpar.&rpar.
.br

.br
      Exit Proc StartExit
.br
      ? &cdq.You used this program by&cdq.&comma.ELAPTIME&lpar.cStartTime&comma.Time&lpar.&rpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=66.SECS():elink.
.br
:link reftype=hd res=65.SECONDS():elink.
.br
:link reftype=hd res=68.TIME():elink.
.br
:link reftype=hd res=54.DAY():elink.
.br
:h2 id=DATEY res=58.MONTH()
:i2 refid=DATEX.MONTH()
:p.MONTH&lpar.&rpar.
.br
.br
:hp2.Converts a date expression to a month value:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.MONTH&lpar.<dDate>&rpar. &minus.&minus.> nMonth:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<dDate> Any valid date expression
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nMonth> Corresponding number of the month in the year&comma. ranging from  0 to 12
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a number that represents the month of a given  date expression <dDate>. If a NULL date &lpar.CTOD&lpar.''&rpar.&rpar. is passed to the  function&comma. the value of the function will be 0.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? Month&lpar.DATE&lpar.&rpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=53.CDOW():elink.
.br
:link reftype=hd res=55.DOW():elink.
.br
:link reftype=hd res=59.YEAR():elink.
.br
:link reftype=hd res=57.CMONTH():elink.
.br
:h2 id=TIMEY res=65.SECONDS()
:i2 refid=TIMEX.SECONDS()
:p.SECONDS&lpar.&rpar.
.br
.br
:hp2.Returns the number of elapsed seconds past midnight.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SECONDS&lpar.&rpar. &minus.&minus.> nSeconds:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nSeconds> Number of seconds since midnight
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a numeric value representing the number of  elapsed seconds based on the current system time.  The system time is considered to start at 0 &lpar.midnight&rpar.&semi.it continues  up to 86399 seconds.The
value of the return expression is displayed  in both seconds and hundredths of seconds.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? Seconds&lpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=68.TIME():elink.
.br
:h2 id=TIMEY res=66.SECS()
:i2 refid=TIMEX.SECS()
:p.SECS&lpar.&rpar.
.br
.br
:hp2.Return the number of seconds from the system date.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SECS&lpar. <cTime> &rpar. &minus.&minus.> nSeconds:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cTime> Character expression in a time string format
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nSeconds> Number of seconds
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a numeric value that is a number of elapsed  seconds from midnight based on a time string given as <cTime>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? Secs&lpar.Time&lpar.&rpar.&rpar.
.br
      ? Secs&lpar.time&lpar.&rpar.&minus.10&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=65.SECONDS():elink.
.br
:link reftype=hd res=67.ELAPTIME():elink.
.br
:link reftype=hd res=68.TIME():elink.
.br
:h2 id=TIMEY res=68.TIME()
:i2 refid=TIMEX.TIME()
:p.TIME&lpar.&rpar.
.br
.br
:hp2.Returns the system time as a string:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.TIME&lpar.&rpar. &minus.&minus.> cTime:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cTime> Character string representing time
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the system time represented as a character  expression in the format of HH&colon.MM&colon.SS
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? Time&lpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=56.DATE():elink.
.br
:link reftype=hd res=65.SECONDS():elink.
.br
:h2 id=DATEY res=59.YEAR()
:i2 refid=DATEX.YEAR()
:p.YEAR&lpar.&rpar.
.br
.br
:hp2.Converts the year portion of a date into a numeric value:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.YEAR&lpar.<cDate>&rpar. &minus.&minus.> nYear:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<dDate> Any valid date expression
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nYear> The year portion of the date.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the numeric value for the year in <dDate>.  This value will always be a four&minus.digit number and is not affected  by the setting of the SET CENTURY and SET DATE commands. Addition  ally&comma. an empty
date expression passed to this function will yield  a zero value.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? Year&lpar.date&lpar.&rpar.&rpar.
.br
      ? year&lpar.CTOD&lpar.&cdq.01&slash.25&slash.3251&cdq.&rpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=54.DAY():elink.
.br
:link reftype=hd res=58.MONTH():elink.
.br
:h2 id=DATAY res=69.__dbCopyStruct()
:i2 refid=DATABX.__DBCOPYSTRUCT()
:p.&us.&us.dbCopyStruct&lpar.&rpar.
.br
.br
:hp2.Create a new database based on current database structure:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.dbCopyStruct&lpar. <cFileName>&comma. &lbrk.<aFieldList>&rbrk.. &rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFileName> is the name of the new database file to create. &lpar..dbf&rpar.  is the default extension if none is given.
.br
:p.<aFieldList> is an array where each element is a field name.  Names could be specified as uppercase or lowercase.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.dbCopyStruct&lpar.&rpar. always return NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.dbCopyStruct&lpar.&rpar. create a new empty database file with a structure  that is based on the currently open database in this work&minus.area. If  <aFieldList> is empty&comma. the newly created file would have the same
structure as the currently open database. Else&comma. the new file would  contain only fields that exactly match <aFieldList>.
.br
:p.&us.&us.dbCopyStruct&lpar.&rpar. can be use to create a sub&minus.set of the currently  open database&comma. based on a given field list.
.br
:p.COPY STRUCTURE command is preprocessed into &us.&us.dbCopyStruct&lpar.&rpar.  function during compile time.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
     &slash.&slash. Create a new file that contain the same structure
.br
      USE TEST
.br
      &us.&us.dbCopyStruct&lpar. &cdq.MyCopy.DBF&cdq. &rpar.
.br

.br
      &slash.&slash. Create a new file that contain part of the original structure
.br
      LOCAL aList
.br
      USE TEST
.br
      aList &colon.&eq. &lbrc. &cdq.NAME&cdq. &rbrc.
.br
      &us.&us.dbCopyStruct&lpar. &cdq.OnlyName.DBF&cdq.&comma. aList &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.dbCopyStruct&lpar.&rpar. works exactly like CA&minus.Clipper's &us.&us.dbCopyStruct&lpar.&rpar.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=70.COPY STRUCTURE:elink.
.br
:link reftype=hd res=71.COPY STRUCTURE EXTENDED:elink.
.br
:link reftype=hd res=72.DBCREATE():elink.
.br
:link reftype=hd res=11.DBSTRUCT():elink.
.br
:link reftype=hd res=73.__DBCOPYXSTRUCT():elink.
.br
:link reftype=hd res=74.__DBCREATE():elink.
.br
:link reftype=hd res=75.__DBSTRUCTFILTER():elink.
.br
:h1 COMMY.COMMAND
:h2  res=70.COPY STRUCTURE
:i1 id=COMMAX.COMMAND
:i2 refid=COMMAX.COPY STRUCTURE
:p.COPY STRUCTURE
.br
.br
:hp2.Create a new database based on current database structure:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.COPY STRUCTURE TO <xcFileName> &lbrk.FIELDS <field&comma....>&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.TO <xcFileName>:ehp2. is the name of the new database file to  create. &lpar..dbf&rpar. is the default extension if none is given. It can be  specified as a literal file name or as a character expression  enclosed in
parentheses.
.br
:p.:hp2.FIELDS <field&comma....>:ehp2. is an optional list of field names to copy  from the currently open database in the specified order&comma. the default  is all fields. Names could be specified as uppercase or lowercase.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.COPY STRUCTURE create a new empty database file with a structure  that is based on the currently open database in this work&minus.area.
.br
:p.COPY STRUCTURE can be use to create a sub&minus.set of the currently  open database&comma. based on a given field list.
.br
:p.COPY STRUCTURE command is preprocessed into &us.&us.dbCopyStruct&lpar.&rpar.  function during compile time.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
     &slash.&slash. Create a new file that contains the same structure
.br
      USE TEST
.br
      COPY STRUCTURE TO MyCopy
.br

.br
      &slash.&slash. Create a new file that contains part of the original structure
.br
      USE TEST
.br
      COPY STRUCTURE TO SomePart FIELDS name&comma. address
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.COPY STRUCTURE works exactly as in CA&minus.Clipper
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=71.COPY STRUCTURE EXTENDED:elink.
.br
:link reftype=hd res=72.DBCREATE():elink.
.br
:link reftype=hd res=11.DBSTRUCT():elink.
.br
:link reftype=hd res=69.__DBCOPYSTRUCT():elink.
.br
:link reftype=hd res=73.__DBCOPYXSTRUCT():elink.
.br
:link reftype=hd res=74.__DBCREATE():elink.
.br
:link reftype=hd res=75.__DBSTRUCTFILTER():elink.
.br
:h2 id=DATAY res=73.__dbCopyXStruct()
:i2 refid=DATABX.__DBCOPYXSTRUCT()
:p.&us.&us.dbCopyXStruct&lpar.&rpar.
.br
.br
:hp2.Copy current database structure into a definition file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.dbCopyXStruct&lpar. <cFileName> &rpar. &minus.&minus.> lSuccess:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFileName> is the name of target definition file to create. &lpar..dbf&rpar.  is the default extension if none is given.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.dbCopyXStruct&lpar.&rpar. return &lpar..F.&rpar. if no database is USED in the current  work&minus.area&comma. &lpar..T.&rpar. on success&comma. or a run&minus.time error if the file create  operation had failed.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.dbCopyXStruct&lpar.&rpar. create a new database named <cFileName> with a  pre&minus.defined structure &lpar.also called &cdq.structure extended file&cdq.&rpar.&colon.
.br
:table cols='10  4  6  8'.
:row.
:c.Field name
:c.Type
:c.Length
:c.Decimals
:row.
:c.
:row.
:c.FIELD_NAME
:c.C
:c.10
:c.0
:row.
:c.FIELD_TYPE
:c.C
:c.1
:c.0
:row.
:c.FIELD_LEN
:c.N
:c.3
:c.0
:row.
:c.FIELD_DEC
:c.N
:c.3
:c.0
:etable.
.br
.br
:p.Each record in the new file contains information about one field in  the original file. CREATE FROM could be used to create a database  from the structure extended file.
.br
:p.For prehistoric compatibility reasons&comma. Character fields which are  longer than 255 characters are treated in a special way by writing  part of the length in the FIELD&us.DEC according to the following  formula &lpar.this is
done internally&rpar.&colon.
.br
      FIELD&minus.>FIELD&us.DEC &colon.&eq. int&lpar. nLength &slash. 256 &rpar.
.br
      FIELD&minus.>FIELD&us.LEN &colon.&eq. &lpar. nLength % 256 &rpar.
.br
.br
:p.Later if you want to calculate the length of a field you can use  the following formula&colon.
.br
      nLength &colon.&eq. IIF&lpar. FIELD&minus.>FIELD&us.TYPE &eq.&eq. &cdq.C&cdq.&comma. &semi.
.br
                      FIELD&minus.>FIELD&us.DEC * 256 + FIELD&minus.>FIELD&us.LEN&comma. &semi.
.br
                      FIELD&minus.>FIELD&us.LEN &rpar.
.br
.br
:p.COPY STRUCTURE EXTENDED command is preprocessed into  &us.&us.dbCopyXStruct&lpar.&rpar. function during compile time.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Open a database&comma. then copy its structure to a new file&comma.
.br
      &slash.&slash. Open the new file and list all its records
.br
      USE Test
.br
      &us.&us.dbCopyXStruct&lpar. &cdq.TestStru&cdq. &rpar.
.br
      USE TestStru
.br
      LIST
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.dbCopyXStruct&lpar.&rpar. works exactly like CA&minus.Clipper's &us.&us.dbCopyXStruct&lpar.&rpar.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=70.COPY STRUCTURE:elink.
.br
:link reftype=hd res=71.COPY STRUCTURE EXTENDED:elink.
.br
:link reftype=hd res=76.CREATE:elink.
.br
:link reftype=hd res=77.CREATE FROM:elink.
.br
:link reftype=hd res=72.DBCREATE():elink.
.br
:link reftype=hd res=11.DBSTRUCT():elink.
.br
:link reftype=hd res=69.__DBCOPYSTRUCT():elink.
.br
:link reftype=hd res=74.__DBCREATE():elink.
.br
:h2 id=COMMY res=71.COPY STRUCTURE EXTENDED
:i2 refid=COMMAX.COPY STRUCTURE EXTENDED
:p.COPY STRUCTURE EXTENDED
.br
.br
:hp2.Copy current database structure into a definition file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.COPY STRUCTURE EXTENDED TO <xcFileName>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.TO <xcFileName>:ehp2.  The name of the target definition file to  create. &lpar..dbf&rpar. is the default extension if none is given. It can be  specified as a literal file name or as a character expression  enclosed in
parentheses.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.COPY STRUCTURE EXTENDED create a new database named <cFileName> with  a pre&minus.defined structure &lpar.also called &cdq.structure extended file&cdq.&rpar.&colon.
.br
:table cols='10  4  6  8'.
:row.
:c.Field name
:c.Type
:c.Length
:c.Decimals
:row.
:c.
:row.
:c.FIELD_NAME
:c.C
:c.10
:c.0
:row.
:c.FIELD_TYPE
:c.C
:c.1
:c.0
:row.
:c.FIELD_LEN
:c.N
:c.3
:c.0
:row.
:c.FIELD_DEC
:c.N
:c.3
:c.0
:etable.
.br
.br
:p.Each record in the new file contains information about one field in  the original file. CREATE FROM could be used to create a database  from the structure extended file.
.br
:p.For prehistoric compatibility reasons&comma. Character fields which are  longer than 255 characters are treated in a special way by writing  part of the length in the FIELD&us.DEC according to the following  formula &lpar.this is
done internally&rpar.&colon.
.br
      FIELD&minus.>FIELD&us.DEC &colon.&eq. int&lpar. nLength &slash. 256 &rpar.
.br
      FIELD&minus.>FIELD&us.LEN &colon.&eq. &lpar. nLength % 256 &rpar.
.br
.br
:p.Later if you want to calculate the length of a field you can use  the following formula&colon.
.br
      nLength &colon.&eq. IIF&lpar. FIELD&minus.>FIELD&us.TYPE &eq.&eq. &cdq.C&cdq.&comma. &semi.
.br
                      FIELD&minus.>FIELD&us.DEC * 256 + FIELD&minus.>FIELD&us.LEN&comma. &semi.
.br
                      FIELD&minus.>FIELD&us.LEN &rpar.
.br
.br
:p.COPY STRUCTURE EXTENDED command is preprocessed into  &us.&us.dbCopyXStruct&lpar.&rpar. function during compile time.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Open a database&comma. then copy its structure to a new file&comma.
.br
      &slash.&slash. Open the new file and list all its records
.br
      USE Test
.br
      COPY STRUCTURE EXTENDED TO TestStru
.br
      USE TestStru
.br
      LIST
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.COPY STRUCTURE EXTENDED works exactly as in CA&minus.Clipper
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=70.COPY STRUCTURE:elink.
.br
:link reftype=hd res=76.CREATE:elink.
.br
:link reftype=hd res=77.CREATE FROM:elink.
.br
:link reftype=hd res=72.DBCREATE():elink.
.br
:link reftype=hd res=11.DBSTRUCT():elink.
.br
:link reftype=hd res=69.__DBCOPYSTRUCT():elink.
.br
:link reftype=hd res=73.__DBCOPYXSTRUCT():elink.
.br
:link reftype=hd res=74.__DBCREATE():elink.
.br
:h2 id=DATAY res=74.__dbCreate()
:i2 refid=DATABX.__DBCREATE()
:p.&us.&us.dbCreate&lpar.&rpar.
.br
.br
:hp2.Create structure extended file or use one to create new file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.dbCreate&lpar. <cFileName>&comma. &lbrk.<cFileFrom>&rbrk..&comma. &lbrk.<cRDDName>&rbrk..&comma. &lbrk.<lNew>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<cAlias>&rbrk.. &rpar. &minus.&minus.> lUsed:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFileName> is the target file name to create and then open. &lpar..dbf&rpar.  is the default extension if none is given.
.br
:p.<cFileFrom> is an optional structure extended file name from which  the target file <cFileName> is going to be built. If omitted&comma. a new  empty structure extended file with the name <cFileName> is created  and opened in the
current work&minus.area.
.br
:p.<cRDDName> is RDD name to create target with. If omitted&comma. the  default RDD is used.
.br
:p.<lNew> is an optional logical expression&comma. &lpar..T.&rpar. opens the target file  name <cFileName> in the next available unused work&minus.area and makes  it the current work&minus.area. &lpar..F.&rpar. opens the target file
in the current  work&minus.area. Default value is &lpar..F.&rpar.. The value of <lNew> is ignored if  <cFileFrom> is not specified.
.br
:p.<cAlias> is an optional alias to USE the target file with. If not  specified&comma. alias is based on the root name of <cFileName>.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.dbCreate&lpar.&rpar. returns &lpar..T.&rpar. if there is database USED in the  current work&minus.area &lpar.this might be the newly selected work&minus.area&rpar.&comma. or  &lpar..F.&rpar. if there is no database USED.
Note that on success a &lpar..T.&rpar.  would be returned&comma. but on failure you probably end up with a  run&minus.time error and not a &lpar..F.&rpar. value.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.dbCreate&lpar.&rpar. works in two modes depending on the value of <cFileFrom>&colon.
.br
:p.:hp2.1&rpar.:ehp2. If <cFileFrom> is empty or not specified a new empty  structure extended file with the name <cFileName> is created and  then opened in the current work&minus.area &lpar.<lNew> is ignored&rpar.. The new  file
has the following structure:
.br
:table cols='10  4  6  8'.
:row.
:c.Field name
:c.Type
:c.Length
:c.Decimals
:row.
:c.
:row.
:c.FIELD_NAME
:c.C
:c.10
:c.0
:row.
:c.FIELD_TYPE
:c.C
:c.1
:c.0
:row.
:c.FIELD_LEN
:c.N
:c.3
:c.0
:row.
:c.FIELD_DEC
:c.N
:c.3
:c.0
:etable.
.br
.br
:p.The CREATE command is preprocessed into the &us.&us.dbCopyStruct&lpar.&rpar. function  during compile time and uses this mode.
.br
:p.:hp2.2&rpar.:ehp2. If <cFileFrom> is specified&comma. it is opened and assumed to  be a structure extended file where each record contains at least the  following fields &lpar.in no particular order&rpar.: FIELD&us.NAME&comma.
FIELD&us.TYPE&comma.  FIELD&us.LEN and FIELD&us.DEC. Any other field is ignored. From this  information the file <cFileName> is then created and opened in the  current or new work&minus.area &lpar.according to <lNew>&rpar.&comma.
if this is a new  work&minus.area it becomes the current.
.br
:p.For prehistoric compatibility reasons&comma. structure extended file  Character fields which are longer than 255 characters should be  treated in a special way by writing part of the length in the  FIELD&us.DEC according to the
following formula&colon.
.br
      FIELD&minus.>FIELD&us.DEC &colon.&eq. int&lpar. nLength &slash. 256 &rpar.
.br
      FIELD&minus.>FIELD&us.LEN &colon.&eq. &lpar. nLength % 256 &rpar.
.br
.br
:p.CREATE FROM command is preprocessed into &us.&us.dbCopyStruct&lpar.&rpar. function  during compile time and use this mode.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. CREATE a new structure extended file&comma. append some records and
.br
      &slash.&slash. then CREATE FROM this file a new database file
.br

.br
      &us.&us.dbCreate&lpar. &cdq.template&cdq. &rpar.
.br
      DBAPPEND&lpar.&rpar.
.br
      FIELD&minus.>FIELD&us.NAME &colon.&eq. &cdq.CHANNEL&cdq.
.br
      FIELD&minus.>FIELD&us.TYPE &colon.&eq. &cdq.N&cdq.
.br
      FIELD&minus.>FIELD&us.LEN  &colon.&eq. 2
.br
      FIELD&minus.>FIELD&us.DEC  &colon.&eq. 0
.br
      DBAPPEND&lpar.&rpar.
.br
      FIELD&minus.>FIELD&us.NAME &colon.&eq. &cdq.PROGRAM&cdq.
.br
      FIELD&minus.>FIELD&us.TYPE &colon.&eq. &cdq.C&cdq.
.br
      FIELD&minus.>FIELD&us.LEN  &colon.&eq. 20
.br
      FIELD&minus.>FIELD&us.DEC  &colon.&eq. 0
.br
      DBAPPEND&lpar.&rpar.
.br
      FIELD&minus.>FIELD&us.NAME &colon.&eq. &cdq.REVIEW&cdq.
.br
      FIELD&minus.>FIELD&us.TYPE &colon.&eq. &cdq.C&cdq.      &slash.&slash. this field is 1000 char long
.br
      FIELD&minus.>FIELD&us.LEN  &colon.&eq. 232      &slash.&slash. 1000 % 256 &eq. 232
.br
      FIELD&minus.>FIELD&us.DEC  &colon.&eq. 3        &slash.&slash. 1000 &slash. 256 &eq. 3
.br
      DBCLOSEAREA&lpar.&rpar.
.br
      &us.&us.dbCreate&lpar. &cdq.TV&us.Guide&cdq.&comma. &cdq.template&cdq. &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.dbCreate&lpar.&rpar. works exactly as in CA&minus.Clipper
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=70.COPY STRUCTURE:elink.
.br
:link reftype=hd res=71.COPY STRUCTURE EXTENDED:elink.
.br
:link reftype=hd res=76.CREATE:elink.
.br
:link reftype=hd res=77.CREATE FROM:elink.
.br
:link reftype=hd res=72.DBCREATE():elink.
.br
:link reftype=hd res=11.DBSTRUCT():elink.
.br
:link reftype=hd res=69.__DBCOPYSTRUCT():elink.
.br
:link reftype=hd res=73.__DBCOPYXSTRUCT():elink.
.br
:h2 id=COMMY res=76.CREATE
:i2 refid=COMMAX.CREATE
:p.CREATE
.br
.br
:hp2.Create empty structure extended file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.CREATE <xcFileName> &lbrk.VIA <xcRDDName>&rbrk.. &lbrk.ALIAS <xcAlias>&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xcFileName> is the target file name to create and then open. &lpar..dbf&rpar.  is the default extension if none is given. It can be specified as  literal file name or as a character expression enclosed in  parentheses.
.br
:p.:hp2.VIA <xcRDDName>:ehp2. is RDD name to create target with. If omitted&comma.  the default RDD is used. It can be specified as literal name or as a  character expression enclosed in parentheses.
.br
:p.:hp2.ALIAS <xcAlias>:ehp2. is an optional alias to USE the target file  with. If not specified&comma. alias is based on the root name of  <xcFileName>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.CREATE a new empty structure extended file with the name <cFileName>  and then open it in the current work&minus.area. The new file has the  following structure&colon.
.br
:table cols='10  4  6  8'.
:row.
:c.Field name
:c.Type
:c.Length
:c.Decimals
:row.
:c.
:row.
:c.FIELD_NAME
:c.C
:c.10
:c.0
:row.
:c.FIELD_TYPE
:c.C
:c.1
:c.0
:row.
:c.FIELD_LEN
:c.N
:c.3
:c.0
:row.
:c.FIELD_DEC
:c.N
:c.3
:c.0
:etable.
.br
.br
:p.CREATE command is preprocessed into &us.&us.dbCopyStruct&lpar.&rpar. function during  compile time and use this mode.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. CREATE a new structure extended file&comma. append some records and
.br
      &slash.&slash. then CREATE FROM this file a new database file
.br

.br
      CREATE template
.br
      APPEND BLANK
.br
      FIELD&minus.>FIELD&us.NAME &colon.&eq. &cdq.CHANNEL&cdq.
.br
      FIELD&minus.>FIELD&us.TYPE &colon.&eq. &cdq.N&cdq.
.br
      FIELD&minus.>FIELD&us.LEN  &colon.&eq. 2
.br
      FIELD&minus.>FIELD&us.DEC  &colon.&eq. 0
.br
      APPEND BLANK
.br
      FIELD&minus.>FIELD&us.NAME &colon.&eq. &cdq.PROGRAM&cdq.
.br
      FIELD&minus.>FIELD&us.TYPE &colon.&eq. &cdq.C&cdq.
.br
      FIELD&minus.>FIELD&us.LEN  &colon.&eq. 20
.br
      FIELD&minus.>FIELD&us.DEC  &colon.&eq. 0
.br
      APPEND BLANK
.br
      FIELD&minus.>FIELD&us.NAME &colon.&eq. &cdq.REVIEW&cdq.
.br
      FIELD&minus.>FIELD&us.TYPE &colon.&eq. &cdq.C&cdq.      &slash.&slash. this field is 1000 char long
.br
      FIELD&minus.>FIELD&us.LEN  &colon.&eq. 232      &slash.&slash. 1000 % 256 &eq. 232
.br
      FIELD&minus.>FIELD&us.DEC  &colon.&eq. 3        &slash.&slash. 1000 &slash. 256 &eq. 3
.br
      CLOSE
.br
      CREATE TV&us.Guide FROM template
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.CREATE works exactly as in CA&minus.Clipper
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=70.COPY STRUCTURE:elink.
.br
:link reftype=hd res=71.COPY STRUCTURE EXTENDED:elink.
.br
:link reftype=hd res=77.CREATE FROM:elink.
.br
:link reftype=hd res=72.DBCREATE():elink.
.br
:link reftype=hd res=11.DBSTRUCT():elink.
.br
:link reftype=hd res=69.__DBCOPYSTRUCT():elink.
.br
:link reftype=hd res=73.__DBCOPYXSTRUCT():elink.
.br
:link reftype=hd res=74.__DBCREATE():elink.
.br
:h2 id=COMMY res=77.CREATE FROM
:i2 refid=COMMAX.CREATE FROM
:p.CREATE FROM
.br
.br
:hp2.Create new database file from a structure extended file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.CREATE <xcFileName> FROM <xcFileFrom> &lbrk.VIA <xcRDDName>&rbrk.. &lbrk.NEW&rbrk..:ehp2.
:p.:hp2.&lbrk.ALIAS <xcAlias>&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xcFileName> is the target file name to create and then open. &lpar..dbf&rpar.  is the default extension if none is given. It can be specified as  literal file name or as a character expression enclosed in  parentheses.
.br
:p.:hp2.FROM <xcFileFrom>:ehp2. is a structure extended file name from  which the target file <xcFileName> is going to be built. It can be  specified as literal file name or as a character expression enclosed  in parentheses.
.br
:p.:hp2.VIA <xcRDDName>:ehp2. is RDD name to create target with. If omitted&comma.  the default RDD is used. It can be specified as literal name or as a  character expression enclosed in parentheses.
.br
:p.:hp2.NEW:ehp2. open the target file name <xcFileName> in the next  available unused work&minus.area and making it the current work&minus.area. If  omitted open the target file in current work&minus.area.
.br
:p.:hp2.ALIAS <xcAlias>:ehp2. is an optional alias to USE the target file  with. If not specified&comma. alias is based on the root name of  <xcFileName>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.CREATE FROM open a structure extended file <xcFileFrom> where each  record contain at least the following fields &lpar.in no particular  order&rpar.&colon. FIELD&us.NAME&comma. FIELD&us.TYPE&comma. FIELD&us.LEN and FIELD&us.DEC.
Any other  field is ignored. From this information the file <xcFileName> is  then created and opened in the current or new work&minus.area &lpar.according to  the NEW clause&rpar.&comma. if this is a new work&minus.area it
becomes the current.
.br
:p.For prehistoric compatibility reasons&comma. structure extended file  Character fields which are longer than 255 characters should be  treated in a special way by writing part of the length in the  FIELD&us.DEC according to the
following formula&colon.
.br
      FIELD&minus.>FIELD&us.DEC &colon.&eq. int&lpar. nLength &slash. 256 &rpar.
.br
      FIELD&minus.>FIELD&us.LEN &colon.&eq. &lpar. nLength % 256 &rpar.
.br
.br
:p.CREATE FROM command is preprocessed into &us.&us.dbCopyStruct&lpar.&rpar. function  during compile time and uses this mode.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      See example in the CREATE command
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.CREATE FROM works exactly as in CA&minus.Clipper
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=70.COPY STRUCTURE:elink.
.br
:link reftype=hd res=71.COPY STRUCTURE EXTENDED:elink.
.br
:link reftype=hd res=76.CREATE:elink.
.br
:link reftype=hd res=72.DBCREATE():elink.
.br
:link reftype=hd res=11.DBSTRUCT():elink.
.br
:link reftype=hd res=69.__DBCOPYSTRUCT():elink.
.br
:link reftype=hd res=73.__DBCOPYXSTRUCT():elink.
.br
:link reftype=hd res=74.__DBCREATE():elink.
.br
:h2 id=DATAY res=78.__FLEDIT()*
:i2 refid=DATABX.__FLEDIT()*
:p.&us.&us.FLEDIT&lpar.&rpar.*
.br
.br
:hp2.Filter a database structure array:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.FLEDIT&lpar. <aStruct>&comma. &lbrk.<aFieldList>&rbrk.. &rpar. &minus.&minus.> aStructFiltered:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<aStruct> is a multidimensional array with database fields  structure&comma. which is usually the output from DBSTRUCT&lpar.&rpar.&comma. where each  array element has the following structure&colon.
.br
:table cols=' 8 12 11'.
:row.
:c.Position
:c.Description
:c.dbstruct.ch
:row.
:c.
:row.
:c.1
:c.cFieldName
:c.DBS_NAME
:row.
:c.2
:c.cFieldType
:c.DBS_TYPE
:row.
:c.3
:c.nFieldLength
:c.DBS_LEN
:row.
:c.4
:c.nDecimals
:c.DBS_DEC
:etable.
.br
.br
:p.<aFieldList> is an array where each element is a field name.  Names could be specified as uppercase or lowercase.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.FLEDIT&lpar.&rpar. return a new multidimensional array where each element is  in the same structure as the original <aStruct>&comma. but the array is  built according to the list of fields in <aFieldList>. If
<aFieldList> is empty&comma. &us.&us.FLEDIT&lpar.&rpar. return reference to the original  <aStruct> array.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.FLEDIT&lpar.&rpar. can be use to create a sub&minus.set of a database structure&comma.  based on a given field list.
.br
:p.Note that field names in <aStruct> MUST be specified in uppercase  or else no match would found.
.br
:p.SET EXACT has no effect on the return value.
.br
:p.&us.&us.FLEDIT&lpar.&rpar. is a compatibility function and it is synonym for  &us.&us.dbStructFilter&lpar.&rpar. which does exactly the same.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      LOCAL aStruct&comma. aList&comma. aRet
.br
      aStruct &colon.&eq. &lbrc. &lbrc. &cdq.CODE&cdq.&comma.  &cdq.N&cdq.&comma.  4&comma. 0 &rbrc.&comma. &semi.
.br
                   &lbrc. &cdq.NAME&cdq.&comma.  &cdq.C&cdq.&comma. 10&comma. 0 &rbrc.&comma. &semi.
.br
                   &lbrc. &cdq.PHONE&cdq.&comma. &cdq.C&cdq.&comma. 13&comma. 0 &rbrc.&comma. &semi.
.br
                   &lbrc. &cdq.IQ&cdq.&comma.    &cdq.N&cdq.&comma.  3&comma. 0 &rbrc. &rbrc.
.br
      aList &colon.&eq. &lbrc. &cdq.IQ&cdq.&comma. &cdq.NAME&cdq. &rbrc.
.br
      aRet &colon.&eq. &us.&us.FLEDIT&lpar. aStruct&comma. aList &rpar.
.br
                        &slash.&slash. &lbrc. &lbrc. &cdq.IQ&cdq.&comma. &cdq.N&cdq.&comma. 3&comma. 0 &rbrc.&comma. &lbrc. &cdq.NAME&cdq.&comma. &cdq.C&cdq.&comma. 10&comma. 0 &rbrc. &rbrc.
.br

.br
      aRet &colon.&eq. &us.&us.FLEDIT&lpar. aStruct&comma. &lbrc.&rbrc. &rpar.
.br
      ? aRet &eq.&eq. aStruct &slash.&slash. .T.
.br

.br
      aList &colon.&eq. &lbrc. &cdq.iq&cdq.&comma. &cdq.NOTEXIST&cdq. &rbrc.
.br
      aRet &colon.&eq. &us.&us.FLEDIT&lpar. aStruct&comma. aList &rpar.
.br
                        &slash.&slash. &lbrc. &lbrc. &cdq.IQ&cdq.&comma. &cdq.N&cdq.&comma. 3&comma. 0 &rbrc. &rbrc.
.br

.br
      aList &colon.&eq. &lbrc. &cdq.NOTEXIST&cdq. &rbrc.
.br
      aRet &colon.&eq. &us.&us.FLEDIT&lpar. aStruct&comma. aList &rpar.   &slash.&slash. &lbrc.&rbrc.
.br

.br

.br
      &slash.&slash. Create a new file that contain part of the original structure
.br
      LOCAL aStruct&comma. aList&comma. aRet
.br
      USE TEST
.br
      aStruct &colon.&eq. DBSTRUCT&lpar.&rpar.
.br
      aList &colon.&eq. &lbrc. &cdq.NAME&cdq. &rbrc.
.br
      DBCREATE&lpar. &cdq.OnlyName.DBF&cdq.&comma. &us.&us.FLEDIT&lpar. aStruct&comma. aList &rpar. &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.CA&minus.Clipper has internal undocumented function named &us.&us.FLEDIT&lpar.&rpar.&comma.  in Harbour we name it &us.&us.dbStructFilter&lpar.&rpar.. The new name gives a better  description of what this function does. In
Harbour &us.&us.FLEDIT&lpar.&rpar. simply  calls &us.&us.dbStructFilter&lpar.&rpar. and therefor the later is the recommended  function to use.
.br
:p.This function is only visible if source&slash.rdd&slash.dbstrux.prg was compiled  with the HB&us.C52&us.UNDOC flag.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Header file is dbstruct.ch  Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=72.DBCREATE():elink.
.br
:link reftype=hd res=11.DBSTRUCT():elink.
.br
:link reftype=hd res=69.__DBCOPYSTRUCT():elink.
.br
:link reftype=hd res=75.__DBSTRUCTFILTER():elink.
.br
:h2 id=DATAY res=75.__dbStructFilter()
:i2 refid=DATABX.__DBSTRUCTFILTER()
:p.&us.&us.dbStructFilter&lpar.&rpar.
.br
.br
:hp2.Filter a database structure array:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.dbStructFilter&lpar. <aStruct>&comma. &lbrk.<aFieldList>&rbrk.. &rpar. &minus.&minus.> aStructFiltered:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<aStruct> is a multidimensional array with database fields  structure&comma. which is usually the output from DBSTRUCT&lpar.&rpar.&comma. where each  array element has the following structure&colon.
.br
:table cols=' 8 12 11'.
:row.
:c.Position
:c.Description
:c.dbstruct.ch
:row.
:c.
:row.
:c.1
:c.cFieldName
:c.DBS_NAME
:row.
:c.2
:c.cFieldType
:c.DBS_TYPE
:row.
:c.3
:c.nFieldLength
:c.DBS_LEN
:row.
:c.4
:c.nDecimals
:c.DBS_DEC
:etable.
.br
.br
:p.<aFieldList> is an array where each element is a field name.  Names could be specified as uppercase or lowercase.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.dbStructFilter&lpar.&rpar. return a new multidimensional array where each  element is in the same structure as the original <aStruct>&comma. but the  array is built according to the list of fields in <aFieldList>. If
<aFieldList> is empty&comma. &us.&us.dbStructFilter&lpar.&rpar. return reference to the  original <aStruct> array.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.dbStructFilter&lpar.&rpar. can be use to create a sub&minus.set of a database  structure&comma. based on a given field list.
.br
:p.Note that field names in <aStruct> MUST be specified in uppercase  or else no match would be found.
.br
:p.SET EXACT has no effect on the return value.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      LOCAL aStruct&comma. aList&comma. aRet
.br
      aStruct &colon.&eq. &lbrc. &lbrc. &cdq.CODE&cdq.&comma.  &cdq.N&cdq.&comma.  4&comma. 0 &rbrc.&comma. &semi.
.br
                   &lbrc. &cdq.NAME&cdq.&comma.  &cdq.C&cdq.&comma. 10&comma. 0 &rbrc.&comma. &semi.
.br
                   &lbrc. &cdq.PHONE&cdq.&comma. &cdq.C&cdq.&comma. 13&comma. 0 &rbrc.&comma. &semi.
.br
                   &lbrc. &cdq.IQ&cdq.&comma.    &cdq.N&cdq.&comma.  3&comma. 0 &rbrc. &rbrc.
.br
      aList &colon.&eq. &lbrc. &cdq.IQ&cdq.&comma. &cdq.NAME&cdq. &rbrc.
.br
      aRet &colon.&eq. &us.&us.dbStructFilter&lpar. aStruct&comma. aList &rpar.
.br
                        &slash.&slash. &lbrc. &lbrc. &cdq.IQ&cdq.&comma. &cdq.N&cdq.&comma. 3&comma. 0 &rbrc.&comma. &lbrc. &cdq.NAME&cdq.&comma. &cdq.C&cdq.&comma. 10&comma. 0 &rbrc. &rbrc.
.br

.br
      aRet &colon.&eq. &us.&us.dbStructFilter&lpar. aStruct&comma. &lbrc.&rbrc. &rpar.
.br
      ? aRet &eq.&eq. aStruct &slash.&slash. .T.
.br

.br
      aList &colon.&eq. &lbrc. &cdq.iq&cdq.&comma. &cdq.NOTEXIST&cdq. &rbrc.
.br
      aRet &colon.&eq. &us.&us.dbStructFilter&lpar. aStruct&comma. aList &rpar.
.br
                        &slash.&slash. &lbrc. &lbrc. &cdq.IQ&cdq.&comma. &cdq.N&cdq.&comma. 3&comma. 0 &rbrc. &rbrc.
.br

.br
      aList &colon.&eq. &lbrc. &cdq.NOTEXIST&cdq. &rbrc.
.br
      aRet &colon.&eq. &us.&us.dbStructFilter&lpar. aStruct&comma. aList &rpar.   &slash.&slash. &lbrc.&rbrc.
.br

.br

.br
      &slash.&slash. Create a new file that contain part of the original structure
.br
      LOCAL aStruct&comma. aList&comma. aRet
.br
      USE TEST
.br
      aStruct &colon.&eq. DBSTRUCT&lpar.&rpar.
.br
      aList &colon.&eq. &lbrc. &cdq.NAME&cdq. &rbrc.
.br
      DBCREATE&lpar. &cdq.OnlyName.DBF&cdq.&comma. &us.&us.dbStructFilter&lpar. aStruct&comma. aList &rpar. &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.dbStructFilter&lpar.&rpar. is a Harbour extension. CA&minus.Clipper has an internal  undocumented function named &us.&us.FLEDIT&lpar.&rpar. that does exactly the same  thing. The new name gives a better description of
what this function does.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Header file is dbstruct.ch  Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=72.DBCREATE():elink.
.br
:link reftype=hd res=11.DBSTRUCT():elink.
.br
:link reftype=hd res=69.__DBCOPYSTRUCT():elink.
.br
:link reftype=hd res=78.__FLEDIT()*:elink.
.br
:h1 LOWY.LOW LEVEL
:h2  res=79.DISKSPACE()
:i1 id=LOW LX.LOW LEVEL
:i2 refid=LOW LX.DISKSPACE()
:p.DISKSPACE&lpar.&rpar.
.br
.br
:hp2.Get the amount of space available on a disk:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DISKSPACE&lpar. &lbrk.<nDrive>&rbrk.. &rpar. &minus.&minus.> nDiskbytes:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nDrive> The number of the drive you are requesting info on where 1 &eq. A&comma.  2 &eq. B&comma. etc. For 0 or no parameter&comma. DiskSpace will operate on the current  drive.  The default is 0
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nDiskBytes> The number of bytes on the requested disk that match the  requested type.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.By default&comma. this function will return the number of bytes of  free space on the current drive that is available to the user  requesting the information.
.br
:p.If information is requested on a disk that is not available&comma. a runtime  error 2018 will be raised.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? &cdq.You can use &colon. &cdq. +Str&lpar. DiskSpace&lpar.&rpar. &rpar. + &cdq. bytes &cdq. +&semi.
.br
      Note&colon. See tests\tstdspac.prg for another example
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.Dos&comma.Win32&comma.OS&slash.2
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl  Header is fileio.ch
:h2 id=LOWY res=80.HB_DISKSPACE()
:i2 refid=LOW LX.HB_DISKSPACE()
:p.HB&us.DISKSPACE&lpar.&rpar.
.br
.br
:hp2.Get the amount of space available on a disk:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.DISKSPACE&lpar. &lbrk.<cDrive>&rbrk.. &lbrk.&comma. <nType>&rbrk.. &rpar. &minus.&minus.> nDiskbytes:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cDrive> The drive letter you are requesting info on. The default  is A&colon.
.br
:p.<nType> The type of space being requested.The default is HB&us.DISK&us.AVAIL.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nDiskBytes> The number of bytes on the requested disk that match the  requested type.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.By default&comma. this function will return the number of bytes of  free space on the current drive that is available to the user  requesting the information.
.br
:p.There are 4 types of information available&colon.
.br
:p.HB&us.FS&us.AVAIL    The amount of space available to the user making the  request.  This value could be less than HB&us.FS&us.FREE if  disk quotas are supported by the O&slash.S in use at runtime&comma.  and disk quotas are in
effect.  Otherwise&comma. the value  will be equal to that returned for HB&us.FS&us.FREE.
.br
:p.HB&us.FS&us.FREE     The actual amount of free diskspace on the drive.
.br
:p.HB&us.FS&us.USED     The number of bytes in use on the disk.
.br
:p.HB&us.FS&us.TOTAL    The total amount of space allocated for the user if  disk quotas are in effect&comma. otherwise&comma. the actual size  of the drive.
.br
:p.If information is requested on a disk that is not available&comma. a runtime  error 2018 will be raised.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? &cdq.You can use &colon. &cdq. +Str&lpar. HB&us.DiskSpace&lpar.&rpar. &rpar. + &cdq. bytes &cdq. +&semi.
.br
        &cdq.Out of a total of &cdq. + Str&lpar. HB&us.DiskSpace&lpar.'C&colon.'&comma.HB&us.FS&us.TOTAL&rpar. &rpar.
.br

.br
      Note&colon. See tests\tstdspac.prg for another example
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.CA&minus.Clipper will return an integer value which limits it's usefulness to  drives less than 2 gigabytes.  The Harbour version will return a  floating point value with 0 decimals if the disk is > 2 gigabytes.  <nType> is a
Harbour extension.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.Dos&comma.Win32&comma.OS&slash.2&comma.Unix
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl  Header is fileio.ch
:h1 FILEY.FILE MANAGEMENT
:h2  res=81.__Dir()*
:i1 id=FILEX.FILE MANAGEMENT
:i2 refid=FILEX.__DIR()*
:p.&us.&us.Dir&lpar.&rpar.*
.br
.br
:hp2.Display listings of files:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.Dir&lpar. &lbrk.<cFileMask>&rbrk.. &rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFileMask> File mask to include in the function return. It could  contain path and standard wildcard characters as supported by your  OS &lpar.like * and ?&rpar.. If <cFileMask> contains no path&comma. then SET DEFAULT  path is
used to display files in the mask.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.Dir&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.If no <cFileMask> is given&comma. &us.&us.Dir&lpar.&rpar. displays information about all  *.dbf in the SET DEFAULT path. This information contains&colon. file name&comma.  number of records&comma. last update date and the size of
each file.
.br
:p.If <cFileMask> is given&comma. &us.&us.Dir&lpar.&rpar. list all files that match the mask  with the following details&colon. Name&comma. Extension&comma. Size&comma. Date.
.br
:p.DIR command is preprocessed into &us.&us.Dir&lpar.&rpar. function during compile  time.
.br
:p.&us.&us.Dir&lpar.&rpar. is a compatibility function&comma. it is superseded by DIRECTORY&lpar.&rpar.  which return all the information in a multidimensional array.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &us.&us.Dir&lpar.&rpar.      &slash.&slash. information for all DBF files in current directory
.br

.br
      &us.&us.Dir&lpar. &cdq.*.dbf&cdq. &rpar.         &slash.&slash. list all DBF file in current directory
.br

.br
      &slash.&slash. list all PRG files in Harbour Run&minus.Time library
.br
      &slash.&slash. for DOS compatible operating systems
.br
      &us.&us.Dir&lpar. &cdq.c&colon.\harbour\source\rtl\*.prg&cdq. &rpar.
.br

.br
      &slash.&slash. list all files in the public section on a Unix like machine
.br
      &us.&us.Dir&lpar. &cdq.&slash.pub&cdq. &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.DBF information&colon. CA&minus.Clipper displays 8.3 file names&comma. Harbour displays  the first 15 characters of a long file name if available.
.br
:p.File listing&colon. To format file names displayed we use something like&colon.  PadR&lpar. Name&comma. 8 &rpar. + &cdq. &cdq. + PadR&lpar. Ext&comma. 3 &rpar.  CA&minus.Clipper use 8.3 file name&comma. with Harbour it would
probably cut  long file names to feet this template.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=82.ADIR():elink.
.br
:link reftype=hd res=12.DIRECTORY():elink.
.br
:link reftype=hd res=83.SET DEFAULT:elink.
.br
:link reftype=hd res=84.DIR:elink.
.br
:h2 id=COMMY res=84.DIR
:i2 refid=COMMAX.DIR
:p.DIR
.br
.br
:hp2.Display listings of files:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DIR &lbrk.<cFileMask>&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFileMask> File mask to include in the function return. It could  contain path and standard wildcard characters as supported by your  OS &lpar.like * and ?&rpar.. If <cFileMask> contains no path&comma. then SET DEFAULT  path is
used to display files in the mask.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.If no <cFileMask> is given&comma. &us.&us.Dir&lpar.&rpar. display information about all  *.dbf in the SET DEFAULT path&comma. this information contain&colon. file name&comma.  number of records&comma. last update date and the
size of each file.
.br
:p.If <cFileMask> is given&comma. &us.&us.Dir&lpar.&rpar. list all files that match the mask  with the following details&colon. Name&comma. Extension&comma. Size&comma. Date.
.br
:p.DIR command is preprocessed into &us.&us.Dir&lpar.&rpar. function during compile  time.
.br
:p.&us.&us.Dir&lpar.&rpar. is a compatibility function&comma. it is superseded by DIRECTORY&lpar.&rpar.  which returns all the information in a multidimensional array.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      DIR          &slash.&slash. information for all DBF files in current directory
.br

.br
      dir   &cdq.*.dbf&cdq.          &slash.&slash. list all DBF file in current directory
.br

.br
      &slash.&slash. list all PRG files in Harbour Run&minus.Time library
.br
      &slash.&slash. for DOS compatible operating systems
.br
        Dir  &cdq.c&colon.\harbour\source\rtl\*.prg&cdq.
.br

.br
      &slash.&slash. list all files in the public section on a Unix like machine
.br
        Dir  &cdq.&slash.pub&cdq.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.DBF information&colon. CA&minus.Clipper displays 8.3 file names&comma. Harbour displays  the first 15 characters of a long file name if available.
.br
:p.File listing&colon. To format file names displayed we use something like&colon.  PadR&lpar. Name&comma. 8 &rpar. + &cdq. &cdq. + PadR&lpar. Ext&comma. 3 &rpar.  CA&minus.Clipper use 8.3 file name&comma. with Harbour it would
probably cut  long file names to feet this template.
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=82.ADIR():elink.
.br
:link reftype=hd res=12.DIRECTORY():elink.
.br
:link reftype=hd res=83.SET DEFAULT:elink.
.br
:link reftype=hd res=81.__DIR()*:elink.
.br
:h2 id=ARRAY res=82.ADIR()
:i2 refid=ARRAYX.ADIR()
:p.ADIR&lpar.&rpar.
.br
.br
:hp2.Fill pre&minus.defined arrays with file&slash.directory information:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ADIR&lpar. &lbrk.<cFileMask>&rbrk..&comma. &lbrk.<aName>&rbrk..&comma. &lbrk.<aSize>&rbrk..&comma. &lbrk.<aDate>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<aTime>&rbrk..&comma. &lbrk.<aAttr>&rbrk.. &rpar. &minus.> nDirEnries:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFileMask> File mask to include in the function return. It could  contain path and standard wildcard characters as supported by your  OS &lpar.like * and ?&rpar.. If you omit <cFileMask> or if <cFileMask> contains  no
path&comma. then the path from SET DEFAULT is used.
.br
:p.<aName> Array to fill with file name of files that meet <cFileMask>.  Each element is a Character string and include the file name and  extension without the path. The name is the long file name as  reported by the OS and not
necessarily the 8.3 uppercase name.
.br
:p.<aSize> Array to fill with file size of files that meet <cFileMask>.  Each element is a Numeric integer for the file size in Bytes.  Directories are always zero in size.
.br
:p.<aDate> Array to fill with file last modification date of files that  meet <cFileMask>. Each element is of type Date.
.br
:p.<aTime> Array to fill with file last modification time of files that  meet <cFileMask>. Each element is a Character string in the format  HH&colon.mm&colon.ss.
.br
:p.<aAttr> Array to fill with attribute of files that meet <cFileMask>.  Each element is a Character string&comma. see DIRECTORY&lpar.&rpar. for information  about attribute values. If you pass array to <aAttr>&comma. the function
is going to return files with normal&comma. hidden&comma. system and directory  attributes. If <aAttr> is not specified or with type other than  Array&comma. only files with normal attribute would return.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.ADIR&lpar.&rpar. return the number of file entries that meet <cFileMask>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.ADIR&lpar.&rpar. return the number of files and&slash.or directories that match  a specified skeleton&comma. it also fill a series of given arrays with  the name&comma. size&comma. date&comma. time and attribute of those files.
The passed  arrays should pre&minus.initialized to the proper size&comma. see example below.  In order to include hidden&comma. system or directories <aAttr> must be  specified.
.br
:p.ADIR&lpar.&rpar. is a compatibility function&comma. it is superseded by DIRECTORY&lpar.&rpar.  which returns all the information in a multidimensional array.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      LOCAL aName&comma. aSize&comma. aDate&comma. aTime&comma. aAttr&comma. nLen&comma. i
.br
      nLen &colon.&eq. ADIR&lpar. &cdq.*.JPG&cdq. &rpar.     &slash.&slash. Number of JPG files in this directory
.br
      IF nLen > 0
.br
         aName &colon.&eq. Array&lpar. nLen &rpar.   &slash.&slash. make room to store the information
.br
         aSize &colon.&eq. Array&lpar. nLen &rpar.
.br
         aDate &colon.&eq. Array&lpar. nLen &rpar.
.br
         aTime &colon.&eq. Array&lpar. nLen &rpar.
.br
         aAttr &colon.&eq. Array&lpar. nLen &rpar.
.br
         FOR i &eq. 1 TO nLen
.br
             ? aName&lbrk.i&rbrk..&comma. aSize&lbrk.i&rbrk..&comma. aDate&lbrk.i&rbrk..&comma. aTime&lbrk.i&rbrk..&comma. aAttr&lbrk.i&rbrk..
.br
         NEXT
.br
      ELSE
.br
         ? &cdq.This directory is clean from smut&cdq.
.br
      ENDIF
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.<aName> is going to be fill with long file name and not necessarily  the 8.3 uppercase name.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=1.ARRAY():elink.
.br
:link reftype=hd res=12.DIRECTORY():elink.
.br
:link reftype=hd res=83.SET DEFAULT:elink.
.br
:h1 ERROY.ERROR RECOVERY
:h2  res=85.ERRORSYS()
:i1 id=ERRORX.ERROR RECOVERY
:i2 refid=ERRORX.ERRORSYS()
:p.ERRORSYS&lpar.&rpar.
.br
.br
:hp2.Install default error handler:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ERRORSYS&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.ERRORSYS&lpar.&rpar. always return NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.ERRORSYS&lpar.&rpar. is called upon startup by Harbour and install the default  error handler. Normally you should not call this function directly&comma.  instead use ERRORBLOCK&lpar.&rpar. to install your own error handler.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.ERRORSYS&lpar.&rpar. works exactly like CA&minus.Clipper's ERRORSYS&lpar.&rpar..
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=86.ERRORBLOCK():elink.
.br
:link reftype=hd res=87.ERROR CLASS:elink.
.br
:h2 id=LOWY res=88.FOPEN()
:i2 refid=LOW LX.FOPEN()
:p.FOPEN&lpar.&rpar.
.br
.br
:hp2.Open a file.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FOPEN&lpar. <cFile>&comma. &lbrk.<nMode>&rbrk.. &rpar. &minus.&minus.> nHandle:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFile> Name of file to open.
.br
:p.<nMode> Dos file open mode.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nHandle> A file handle.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function opens a file expressed as <cFile> and returns a  file handle to be used with other low&minus.level file functions. The  value of <nMode> represents the status of the file to be opened&semi.  the default value is 0.
The file open modes are as follows&colon.
.br
:table cols=' 5 12 27'.
:row.
:c.nMode
:c.fileio.ch
:c.Meaning
:row.
:c.
:row.
:c.0
:c.FO_READ
:c.Read only
:row.
:c.1
:c.FO_WRITE
:c.Write only
:row.
:c.2
:c.FO_READWRITE
:c.Read/write
:row.
:c.16
:c.FO_EXCLUSIVE
:c.Exclusive read only
:row.
:c.32
:c.FO_DENYWRITE
:c.Prevent others from writing
:row.
:c.48
:c.FO_DENYREAD
:c.Deny read only
:row.
:c.64
:c.FO_DENYNONE
:c.Share read only
:etable.
.br
:p.If there is an error in opening a file&comma. a &minus.1 will be returned by  the function. Files handles may be in the range of 0 to 65535. The  status of the SET DEFAULT TO and SET PATH TO commands has no effect  on this
function. Directory names and paths must be specified along  with the file that is to be opened.
.br
:p.If an error has occured&comma. see the returns values from FERROR&lpar.&rpar. for  possible reasons for the error.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
      IF &lpar.nH&colon.&eq.FOPEN&lpar.'X.TXT'&comma.66&rpar. < 0
.br
         ? 'File can't be opened'
.br
      ENDIF
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl  Header  is fileio.ch
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=89.FCREATE():elink.
.br
:link reftype=hd res=90.FERROR():elink.
.br
:link reftype=hd res=91.FCLOSE():elink.
.br
:h2 id=LOWY res=89.FCREATE()
:i2 refid=LOW LX.FCREATE()
:p.FCREATE&lpar.&rpar.
.br
.br
:hp2.Creates a file.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FCREATE&lpar. <cFile>&comma. &lbrk.<nAttribute>&rbrk.. &rpar. &minus.&minus.> nHandle:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFile> is the name of the file to create.
.br
:p.<nAttribute> Numeric code for the file attributes.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nHandle>  Numeric file handle to be used in other operations.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function creates a new file with a filename of <cFile>. The  default value of <nAttribute> is 0 and is used to set the  attribute byte for the file being created by this function.  The return value will be a file handle that
is associated  with the new file. This number will be between zero to 65&comma.535&comma.  inclusive. If an error occurs&comma. the return value of this function  will be &minus.1.
.br
:p.If the file <cFile> already exists&comma. the existing file will be  truncated to a file length of 0 bytes.
.br
:p.If specified&comma. the following table shows the value for <nAttribute>  and their related meaning to the file <cFile> being created by  this function.
.br
:table cols='18 11 38'.
:row.
:c.&lt.nAttribute&gt.
:c.fileio.ch
:c.Attribute
:row.
:c.
:row.
:c.0
:c.FC_NORMAL
:c.Normal/Default,Read/Write
:row.
:c.1
:c.FC_READONLY
:c.Read-only file attribute is set
:row.
:c.2
:c.FC_HIDDEN
:c.Hidden,Excluded from normal DIR search
:row.
:c.4
:c.FC_SYSTEM
:c.Create,Excluded from normal DIR search
:etable.
.br
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      IF &lpar.nh&colon.&eq.FCREATE&lpar.&cdq.TEST.TXT&cdq.&rpar. <0
.br
          ? &cdq.Cannot create file&cdq.
.br
      ENDIF
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl  Header is fileio.ch
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=91.FCLOSE():elink.
.br
:link reftype=hd res=88.FOPEN():elink.
.br
:link reftype=hd res=29.FWRITE():elink.
.br
:link reftype=hd res=28.FREAD():elink.
.br
:link reftype=hd res=90.FERROR():elink.
.br
:h2 id=LOWY res=28.FREAD()
:i2 refid=LOW LX.FREAD()
:p.FREAD&lpar.&rpar.
.br
.br
:hp2.Reads a specified number of bytes from a file.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FREAD&lpar. <nHandle>&comma. @<cBuffer>&comma. <nBytes> &rpar. &minus.&minus.> nBytes:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nHandle>     Dos file handle
.br
:p.<cBufferVar>  Character expression passed by reference.
.br
:p.<nBytes>      Number of bytes to read.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nBytes> the number of bytes successfully read from the file.  <nHandle>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function reads the characters from a file whose file handle  is <nHandle> into a character memory variable expressed as <cBuffer>.  The function returns the number of bytes successfully read into  <cBuffer>.
.br
:p.The value of <nHandle> is obtained from either a call to the FOPEN&lpar.&rpar.  or the FCREATE&lpar.&rpar. function.
.br
:p.The <cBuffer> expression is passed by reference and must be defined  before this function is called. It also must be at least the same  length as <nBytes>.
.br
:p.<nBytes> is the number of bytes to read&comma. starting at the current  file pointer position. If this function is successful in reading  the characters from the file&comma. the length of <cBuffer> or the number  of bytes
specified in <nBytes> will be the value returned. The current  file pointer advances the number of bytes read with each successive  read. The return value is the number of bytes successfully read  from the file. If a 0 is
returned&comma. or if the number of  bytes read matches neither the length of <cBuffer> nor the specified  value in <nBytes> an end&minus.of&minus.file condition has been reached.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      cBuffer&colon.&eq.SPACE&lpar.500&rpar.
.br
      IF &lpar.nH&colon.&eq.FOPEN&lpar.'X.TXT&rpar.&rpar.>0
.br
         FREAD&lpar.Hh&comma.@cBuffer&comma.500&rpar.
.br
         ? cbuffer
.br
      ENDIF
.br
      FCLOSE&lpar.nH&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant&comma. but also extends the possible  buffer size to strings greater than 65K &lpar.depending on platform&rpar..
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is Rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=20.BIN2I():elink.
.br
:link reftype=hd res=21.BIN2L():elink.
.br
:link reftype=hd res=19.BIN2W():elink.
.br
:link reftype=hd res=90.FERROR():elink.
.br
:link reftype=hd res=29.FWRITE():elink.
.br
:h2 id=LOWY res=29.FWRITE()
:i2 refid=LOW LX.FWRITE()
:p.FWRITE&lpar.&rpar.
.br
.br
:hp2.Writes characters to a file.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FWRITE&lpar. <nHandle>&comma. <cBuffer>&comma. &lbrk.<nBytes>&rbrk.. &rpar. &minus.&minus.> nBytesWritten:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nHandle>  DOS file handle number.
.br
:p.<cBuffer>  Character expression to be written.
.br
:p.<nBytes>   The number of bytes to write.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nBytesWritten> the number of bytes successfully written.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function writes the contents of <cBuffer> to the file designated  by its file handle <nHandle>. If used&comma. <nBytes> is the number of  bytes in <cBuffer> to write.
.br
:p.The returned value is the number of bytes successfully written to the  DOS file. If the returned value is 0&comma. an error has occurred &lpar.unless  this is intended&rpar.. A successful write occurs when the number returned  by
FWRITE&lpar.&rpar. is equal to either LEN&lpar. <cBuffer>&rpar. or <nBytes>.
.br
:p.The value of <cBuffer> is the string or variable to be written to the  open DOS file <nHandle>.
.br
:p.The value of <nBytes> is the number of bytes to write out to the file.  The disk write begins with the current file position in <nHandle>. If  this variable is not used&comma. the entire contents of <cBuffer> is written  to the
file.  To truncate a file. a call of FWRITE&lpar. nHandle&comma. &cdq.&cdq.&comma. 0 &rpar. is needed.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      nHandle&colon.&eq.FCREATE&lpar.'x.txt'&rpar.
.br
      FOR X&colon.&eq.1 to 10
.br
        FWRITE&lpar.nHandle&comma.STR&lpar.x&rpar.&rpar.
.br
      NEXT
.br
      FCLOSE&lpar.nHandle&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is not CA&minus.Clipper compatile since  it can writes strings greather the 64K
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is Rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=91.FCLOSE():elink.
.br
:link reftype=hd res=89.FCREATE():elink.
.br
:link reftype=hd res=90.FERROR():elink.
.br
:link reftype=hd res=88.FOPEN():elink.
.br
:link reftype=hd res=23.I2BIN():elink.
.br
:link reftype=hd res=24.L2BIN():elink.
.br
:h2 id=LOWY res=90.FERROR()
:i2 refid=LOW LX.FERROR()
:p.FERROR&lpar.&rpar.
.br
.br
:hp2.Reports the error status of low&minus.level file functions:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FERROR&lpar.&rpar. &minus.&minus.> <nErrorCode>:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nErrorCode> Value of the DOS error last encountered by a  low&minus.level file function.
.br
:p.FERROR&lpar.&rpar. Return Values
.br
:table cols=' 5 44'.
:row.
:c.Error
:c.Meaning
:row.
:c.
:row.
:c.0
:c.Successful
:row.
:c.2
:c.File not found
:row.
:c.3
:c.Path not found
:row.
:c.4
:c.Too many files open
:row.
:c.5
:c.Access denied
:row.
:c.6
:c.Invalid handle
:row.
:c.8
:c.Insufficient memory
:row.
:c.15
:c.Invalid drive specified
:row.
:c.19
:c.Attempted to write to a write-protected disk
:row.
:c.21
:c.Drive not ready
:row.
:c.23
:c.Data CRC error
:row.
:c.29
:c.Write fault
:row.
:c.30
:c.Read fault
:row.
:c.32
:c.Sharing violation
:row.
:c.33
:c.Lock Violation
:etable.
.br
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.After every low&minus.level file function&comma.this function will return  a value that provides additional informationon the status of  the last low&minus.level file functions's performance.If the FERROR&lpar.&rpar.  function
returns a 0&comma. no error was detected.Below is a table  of possibles values returned by the FERROR&lpar.&rpar. function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      #include &cdq.Fileio.ch&cdq.
.br
      &slash.&slash.
.br
      nHandle &colon.&eq. FCREATE&lpar.&cdq.Temp.txt&cdq.&comma. FC&us.NORMAL&rpar.
.br
      IF FERROR&lpar.&rpar. !&eq. 0
.br
         ? &cdq.Cannot create file&comma. DOS error &cdq.&comma. FERROR&lpar.&rpar.
.br
      ENDIF
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compatible
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is Rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=91.FCLOSE():elink.
.br
:link reftype=hd res=92.FERASE():elink.
.br
:link reftype=hd res=88.FOPEN():elink.
.br
:link reftype=hd res=29.FWRITE():elink.
.br
:h2 id=LOWY res=91.FCLOSE()
:i2 refid=LOW LX.FCLOSE()
:p.FCLOSE&lpar.&rpar.
.br
.br
:hp2.Closes an open file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FCLOSE&lpar. <nHandle> &rpar. &minus.&minus.> <lSuccess>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nHandle> DOS file handle
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lSuccess>  Logical TRUE &lpar..T.&rpar. or FALSE &lpar..F.&rpar.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function closes an open file with a dos file handle  of <nHandle> and writes the associated DOS buffer to the  disk. The <nHandle> value is derived from the FCREATE&lpar.&rpar.  or FOPEN&lpar.&rpar. function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
     nHandle&colon.&eq.FOPEN&lpar.'x.txt'&rpar.
.br
     ? FSEEK&lpar.nHandle0&comma.2&rpar.
.br
     FCLOSE&lpar.nHandle&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is Rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=88.FOPEN():elink.
.br
:link reftype=hd res=89.FCREATE():elink.
.br
:link reftype=hd res=28.FREAD():elink.
.br
:link reftype=hd res=29.FWRITE():elink.
.br
:link reftype=hd res=90.FERROR():elink.
.br
:h2 id=LOWY res=92.FERASE()
:i2 refid=LOW LX.FERASE()
:p.FERASE&lpar.&rpar.
.br
.br
:hp2.Erase a file from disk:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FERASE&lpar. <cFile> &rpar. &minus.&minus.> nSuccess:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFile> Name of file to erase.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nSuccess> 0 if successful&comma. &minus.1 if not
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function deletes the file specified in <cFile> from the disk.  No extensions are assumed. The drive and path my be included in  <cFile>&semi. neither the SET DEFAULT not the SET PATH command controls  the performance of this
function.If the drive or path is not used&comma.  the function will look for the file only on the currently selected  direcytory on the logged drive.
.br
:p.If the function is able to successfully delete the file from the  disk&comma. the value of the function will be 0&semi. otherwise a &minus.1 will  be returned.If not successfu&comma. aditional information may be  obtained by
calling the FERROR&lpar.&rpar. function.
.br
:p.Note&colon. Any file to be removed by FERASE&lpar.&rpar. must still be closed.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      IF &lpar.FERASE&lpar.&cdq.TEST.TXT&cdq.&rpar.&eq.&eq.0&rpar.
.br
          ? &cdq.File successfully erased&cdq.
.br
      ELSE
.br
          ? &cdq.File can not be deleted&cdq.
.br
      ENDIF
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper Compatible
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is Rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=90.FERROR():elink.
.br
:link reftype=hd res=93.FRENAME():elink.
.br
:h2 id=FILEY res=93.FRENAME()
:i2 refid=FILEX.FRENAME()
:p.FRENAME&lpar.&rpar.
.br
.br
:hp2.Renames a file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FRENAME&lpar. <cOldFile>&comma. <cNewFile> &rpar. &minus.&minus.> nSuccess:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cOldFile> Old filenarne to he changed
.br
:p.<cNewFile> New filename
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nSuccess> If sucessful&comma. a 0 will he returned otherwise&comma.  a &minus.1 will be returned.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function renames the specified file <cOldFile> to <cNewFile>.  A filename and&slash.or directory name may be specified for either para&minus.  meter. However&comma. if a path is supplied as part of <cNewFile> and  this path
is different from either the path specified in <cOldFile>  or &lpar.if none is used&rpar. the current drive and directory&comma. the function  will not execute successfu
lly.
.br
:p.Neither parameter is subject to the control of the SET PATH TO or  SET DEFAULT TO commands. In attempting to locate the file to be  renamed&comma. this function will search the default drive and directory  or the drive and path
specified in <cOldFile>. It will not search  directories named by the SET PATH TO and SET DEFAULT TO commands  or by the DOS PATH statement.
.br
:p.If the file specified in <cNewFile> exists or the file is open&comma.  the function will be unable to rename the file.If the function  is unable to complete its operation&comma.it will return a value of &minus.1.  If it is able
to rename the file&comma. the return value for the function  will be 0.A call to FERROR&lpar.&rpar. function will give additional infor&minus.  mation about any error found.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      nResult&colon.&eq.FRENAME&lpar.&cdq.x.txt&cdq.&comma.&cdq.x1.txt&cdq.&rpar.
.br
      IF nResult <0
.br
         ? &cdq.File could not be renamed.&cdq.
.br
      ENDIF
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is Rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=94.ERASE:elink.
.br
:link reftype=hd res=92.FERASE():elink.
.br
:link reftype=hd res=90.FERROR():elink.
.br
:link reftype=hd res=95.FILE():elink.
.br
:link reftype=hd res=96.RENAME:elink.
.br
:h2 id=LOWY res=97.FSEEK()
:i2 refid=LOW LX.FSEEK()
:p.FSEEK&lpar.&rpar.
.br
.br
:hp2.Positions the file pointer in a file.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FSEEK&lpar. <nHandle>&comma. <nOffset>&comma. &lbrk.<nOrigin>&rbrk.. &rpar. &minus.&minus.> nPosition:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nHandle> DOS file handle.
.br
:p.<nOffset> The number of bytes to move.
.br
:p.<nOrigin> The relative position in the file.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nPosition> the current position relative to begin&minus.of&minus.file
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function sets the file pointer in the file whose DOS file  handle is <nHandle> and moves the file pointer by <expN2> bytes  from the file position designated by <nOrigin>. The returned value  is the relative position of the
file pointer to the beginning&minus.of&minus.file  marker once the operation has been completed.
.br
:p.<nHandle> is the file handle number. It is obtained from the FOPEN&lpar.&rpar.  or FCREATE&lpar.&rpar. function.
.br
:p.The value of <nOffSet> is the number of bytes to move the file pointer  from the position determined by <nOrigin>.The value of <nOffset> may  be a negative number&comma. suggesting backward movement.
.br
:p.The value of <nOrigin> designates the starting point from which the  file pointer should he moved&comma. as shown in the following table&colon.
.br
:table cols='15 11 29'.
:row.
:c.&lt.nOrigin&gt.
:c.fileio.ch
:c.File position
:row.
:c.
:row.
:c.0
:c.FS_SET
:c.Beginning of file
:row.
:c.1
:c.FS_RELATIVE
:c.Current file pointer position
:row.
:c.2
:c.FS_END
:c.End of file
:etable.
.br
:p.If a value is not provided for <nOrigin>&comma. it defaults to 0 and  moves the file pointer from the beginning of the file.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. here is a function that read one text line from an open file
.br

.br
      &slash.&slash. nH &eq. file handle obtained from FOPEN&lpar.&rpar.
.br
      &slash.&slash. cB &eq. a string buffer passed&minus.by&minus.reference to hold the result
.br
      &slash.&slash. nMaxLine &eq. maximum number of bytes to read
.br

.br
      #define EOL HB&us.OSNEWLINE&lpar.&rpar.
.br
      FUNCTION FREADln&lpar. nH&comma. cB&comma. nMaxLine &rpar.
.br
      LOCAL cLine&comma. nSavePos&comma. nEol&comma. nNumRead
.br
      cLine &colon.&eq. space&lpar. nMaxLine &rpar.
.br
      cB &colon.&eq. ''
.br
      nSavePos &colon.&eq. FSEEK&lpar. nH&comma. 0&comma. FS&us.RELATIVE &rpar.
.br
      nNumRead &colon.&eq. FREAD&lpar. nH&comma. @cLine&comma. nMaxLine &rpar.
.br
      IF &lpar. nEol &colon.&eq. AT&lpar. EOL&comma. substr&lpar. cLine&comma. 1&comma. nNumRead &rpar. &rpar. &rpar. &eq.&eq. 0
.br
        cB &colon.&eq. cLine
.br
      ELSE
.br
        cB &colon.&eq. SUBSTR&lpar. cLine&comma. 1&comma. nEol &minus. 1 &rpar.
.br
        FSEEK&lpar. nH&comma. nSavePos + nEol + 1&comma. FS&us.SET &rpar.
.br
      ENDIF
.br
      RETURN nNumRead !&eq. 0
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl  Header is fileio.ch
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=89.FCREATE():elink.
.br
:link reftype=hd res=90.FERROR():elink.
.br
:link reftype=hd res=88.FOPEN():elink.
.br
:link reftype=hd res=28.FREAD():elink.
.br
:link reftype=hd res=98.FREADSTR():elink.
.br
:link reftype=hd res=29.FWRITE():elink.
.br
:h2 id=FILEY res=95.FILE()
:i2 refid=FILEX.FILE()
:p.FILE&lpar.&rpar.
.br
.br
:hp2.Tests for the existence of file&lpar.s&rpar.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FILE&lpar. <cFileSpec> &rpar. &minus.&minus.> lExists:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFileSpec> Dos Skeleton or file name to find.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lExists> a logical true &lpar..T.&rpar. if the file exists or logical  false &lpar..F.&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function return a logical true &lpar..T.&rpar. if the given filename  <cFileSpec> exist.
.br
:p.Dos skeletons symbols may be used in the filename in <cFileSpec>&comma.  as may the drive and&slash.or path name. If a drive are not explicity  specified&comma.FILE&lpar.&rpar. will first search the current drive and
directory&comma.  and will look for the file in the directories specified by SET PATH  TO and SET DEFAULT TO commands.However&comma. this command does not look  at the values in the DOS PATH command.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? file&lpar.'c&colon.\harbour\doc\compiler.txt&cdq.&rpar.
.br
      ? file&lpar.'c&colon.&slash.harbour&slash.doc&slash.subcodes.txt&cdq.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compatible.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is Rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=99.SET PATH:elink.
.br
:link reftype=hd res=83.SET DEFAULT:elink.
.br
:link reftype=hd res=100.SET():elink.
.br
:h2 id=LOWY res=98.FREADSTR()
:i2 refid=LOW LX.FREADSTR()
:p.FREADSTR&lpar.&rpar.
.br
.br
:hp2.Reads a string from a file.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FREADSTR&lpar.<nHandle>&comma. <nBytes>&rpar. &minus.&minus.> cString:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nHandle> DOS file handle number.
.br
:p.<nBytes>  Number of bytes to read.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> an characted expression
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a character string of <nBytes> bytes from a  file whose DOS file handle is <nHandle>.
.br
:p.The value of the file handle <nHandle> is obtained from either the  FOPEN&lpar.&rpar. or FCREATE&lpar.&rpar. functions.
.br
:p.The value of <nBytes> is the number of bytes to read from the file.  The returned string will be the number of characters specified in  <nBytes> or the number of bytes read before an end&minus.of&minus.file charac&minus.  ter
&lpar.ASCII 26&rpar. is found.
.br
:p.NOTE  This function is similar to the FREAD&lpar.&rpar. function&comma. except that  it will not     read binary characters that may he required as part of  a header of a file construct. Characters Such as CHR&lpar.0&rpar. and
CHR&lpar.26&rpar.  may keep this   function from performing its intended operation. In this  event&comma. the FREAD&lpar.&rpar. function should he used in place of the FREADSTR&lpar.&rpar.  function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      IF &lpar. nH &colon.&eq. FOPEN&lpar.&cdq.x.txt&cdq.&rpar. &rpar. > 0
.br
         cStr &colon.&eq. Freadstr&lpar.nH&comma.100&rpar.
.br
         ? cStr
.br
      ENDIF
.br
      FCLOSE&lpar.nH&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is not CA&minus.Clipper compliant since may read  strings greather the 65K depending of platform.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is Rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=20.BIN2I():elink.
.br
:link reftype=hd res=21.BIN2L():elink.
.br
:link reftype=hd res=19.BIN2W():elink.
.br
:link reftype=hd res=90.FERROR():elink.
.br
:link reftype=hd res=28.FREAD():elink.
.br
:link reftype=hd res=97.FSEEK():elink.
.br
:h2 id=COMMY res=96.RENAME
:i2 refid=COMMAX.RENAME
:p.RENAME
.br
.br
:hp2.Changes the name of a specified file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.RENAME <cOldFile> TO <cNewFile>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cOldFile> Old filename
.br
:p.<cNewFile> New Filename
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command changes the name of <cOldFile> to <cNewFile>.Both  <cOldFile> and <cNewFile> must include a file extension.This command  if not affected by the SET PATH TO or SET DEFAULT TO commands&semi.drive  and directoy
designaters must be specified if either file is in a  directory other then the default drive and directory.
.br
:p.If <cNewFile> id currently open or if it previously exists&comma. this  command will not perform the desired operation.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      RENAME c&colon.\autoexec.bat to c&colon.\autoexec.old
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is CA&minus.Clipper compatible
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is Rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=101.CURDIR():elink.
.br
:link reftype=hd res=94.ERASE:elink.
.br
:link reftype=hd res=95.FILE():elink.
.br
:link reftype=hd res=92.FERASE():elink.
.br
:link reftype=hd res=93.FRENAME():elink.
.br
:h2 id=COMMY res=94.ERASE
:i2 refid=COMMAX.ERASE
:p.ERASE
.br
.br
:hp2.Remove a file from disk:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ERASE <xcFile>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xcFile> Name of file to remove
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command removes a file from the disk.The use of a drive&comma.directo&minus.  ry&comma.and wild&minus.card skeleton operator is allowed for the root of the  filename.The file extension is required.The SET DEFAULT and SET
PATH  commands do not affect this command.
.br
:p.The file must be considered closed by the operating system before it  may be deleted.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      Erase c&colon.\autoexec.bat
.br
      Erase c&colon.&slash.temp&slash.read.txt
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is CA&minus.Clipper compatible
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=101.CURDIR():elink.
.br
:link reftype=hd res=95.FILE():elink.
.br
:link reftype=hd res=92.FERASE():elink.
.br
:link reftype=hd res=102.DELETE FILE:elink.
.br
:h2 id=COMMY res=102.DELETE FILE
:i2 refid=COMMAX.DELETE FILE
:p.DELETE FILE
.br
.br
:hp2.Remove a file from disk:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DELETE FILE <xcFile>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xcFile> Name of file to remove
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command removes a file from the disk.The use of a drive&comma.directo&minus.  ry&comma.and wild&minus.card skeleton operator is allowed for the root of the  filename.The file extension is required.The SET DEFAULT and SET
PATH  commands do not affect this command.
.br
:p.The file must be considered closed by the operating system before it  may be deleted.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      Erase c&colon.\autoexec.bat
.br
      Erase c&colon.&slash.temp&slash.read.txt
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is CA&minus.Clipper compatible
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=101.CURDIR():elink.
.br
:link reftype=hd res=95.FILE():elink.
.br
:link reftype=hd res=92.FERASE():elink.
.br
:link reftype=hd res=94.ERASE:elink.
.br
:h2 id=DATAY res=103.__TYPEFILE()
:i2 refid=DATAX.__TYPEFILE()
:p.&us.&us.TYPEFILE&lpar.&rpar.
.br
.br
:hp2.Show the content of a file on the console and&slash.or printer:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.TYPEFILE&lpar. <cFile>&comma. &lbrk.<lPrint>&rbrk.. &rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFile> is a name of the file to display. If the file have an  extension&comma. it must be specified &lpar.there is no default value&rpar..
.br
:p.<lPrint> is an optional logical value that specifies whether the  output should go only to the screen &lpar..F.&rpar. or to both the screen and  printer &lpar..T.&rpar.&comma. the default is &lpar..F.&rpar..
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.TYPEFILE&lpar.&rpar. always return NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.TYPEFILE&lpar.&rpar. function type the content of a text file on the screen  with an option to send this information also to the printer. The  file is displayed as is without any headings or formating.
.br
:p.If <cFile> contain no path&comma. &us.&us.TYPEFILE&lpar.&rpar. try to find the file first  in the SET DEFAULT directory and then in search all of the SET PATH  directories. If <cFile> can not be found a run&minus.time error
occur.
.br
:p.Use SET CONSOLE OFF to suppress screen output.  You can pause the output using Ctrl&minus.S&comma. press any key to resume.
.br
:p.&us.&us.TYPEFILE&lpar.&rpar. function is used in the preprocessing of the TYPE  command.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      The following examples assume a file name MyText.DAT exist in all
.br
      specified paths&comma. a run&minus.time error would displayed if it does not
.br

.br
      &slash.&slash. display MyText.DAT file on screen
.br
      &us.&us.TYPEFILE&lpar. &cdq.MyText.DAT&cdq. &rpar.
.br

.br
      &slash.&slash. display MyText.DAT file on screen and printer
.br
      &us.&us.TYPEFILE&lpar. &cdq.MyText.DAT&cdq.&comma. .T. &rpar.
.br

.br
      &slash.&slash. display MyText.DAT file on printer only
.br
      SET CONSOLE OFF
.br
      &us.&us.TYPEFILE&lpar. &cdq.MyText.DAT&cdq.&comma. .T. &rpar.
.br
      SET CONSOLE ON
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.TYPEFILE&lpar.&rpar. works exactly like CA&minus.Clipper's &us.&us.TYPEFILE&lpar.&rpar.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is Rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=104.COPY FILE:elink.
.br
:link reftype=hd res=83.SET DEFAULT:elink.
.br
:link reftype=hd res=99.SET PATH:elink.
.br
:link reftype=hd res=105.SET PRINTER:elink.
.br
:link reftype=hd res=106.TYPE:elink.
.br
:h2 id=COMMY res=106.TYPE
:i2 refid=COMMAX.TYPE
:p.TYPE
.br
.br
:hp2.Show the content of a file on the console&comma. printer or file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.TYPE <xcFile> &lbrk.TO PRINTER&rbrk.. &lbrk.TO FILE <xcDestFile>&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xcFile> is a name of the file to display. If the file have an  extension&comma. it must be specified &lpar.there is no default value&rpar..  It can be specified as literal file name or as a character  expression enclosed in
parentheses.
.br
:p.TO PRINTER is an optional keyword that specifies that the output  should go to both the screen and printer.
.br
:p.TO FILE <xcDestFile> copy the source <xcFile> also to a file. If no  extension is given &lpar..txt&rpar. is added to the output file name.  <xcDestFile> can be specified as literal file name or as a character  expression enclosed
in parentheses.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.TYPE command type the content of a text file on the screen  with an option to send this information also to the printer or to  an alternate file. The file is displayed as is without any headings  or formating.
.br
:p.If <xcFile> contain no path&comma. TYPE try to find the file first in the  SET DEFAULT directory and then in search all of the SET PATH  directories. If <xcFile> can not be found a run&minus.time error occur.
.br
:p.If <xcDestFile> contain no path it is created in the SET DEFAULT  directory.
.br
:p.Use SET CONSOLE OFF to suppress screen output.  You can pause the output using Ctrl&minus.S&comma. press any key to resume.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      The following examples assume a file name MyText.DAT exist in all
.br
      specified paths&comma. a run&minus.time error would displayed if it does not
.br

.br
      &slash.&slash. display MyText.DAT file on screen
.br
      TYPE MyText.DAT
.br

.br
      &slash.&slash. display MyText.DAT file on screen and printer
.br
      TYPE MyText.DAT TO PRINTER
.br

.br
      &slash.&slash. display MyText.DAT file on printer only
.br
      SET CONSOLE OFF
.br
      TYPE MyText.DAT TO PRINTER
.br
      SET CONSOLE ON
.br

.br
      &slash.&slash. display MyText.DAT file on screen and into a file MyReport.txt
.br
      TYPE MyText.DAT TO FILE MyReport
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.TYPE works exactly like CA&minus.Clipper's TYPE
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=104.COPY FILE:elink.
.br
:link reftype=hd res=83.SET DEFAULT:elink.
.br
:link reftype=hd res=99.SET PATH:elink.
.br
:link reftype=hd res=105.SET PRINTER:elink.
.br
:link reftype=hd res=103.__TYPEFILE():elink.
.br
:h2 id=LOWY res=101.CURDIR()
:i2 refid=LOW LX.CURDIR()
:p.CURDIR&lpar.&rpar.
.br
.br
:hp2.Returns the current OS directory name.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.CURDIR&lpar. &lbrk.<cDrive>&rbrk.. &rpar.  &minus.&minus.> cPath:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cDir> OS drive letter
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cPath> Name of directory
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function yields the name of the current OS directory on a  specified drive.If <cDrive> is not speficied&comma.the currently logged  drive will be used.
.br
:p.This function should not return the leading and trailing  &lpar.back&rpar.slashes.
.br
:p.If an error has been detected by the function&comma.or the current OS  directory is the root&comma.the value of the function will be a NULL  byte.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? Curdir&lpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper Compatible
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.ALL
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is Rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=95.FILE():elink.
.br
:h2 id=COMMY res=104.COPY FILE
:i2 refid=COMMAX.COPY FILE
:p.COPY FILE
.br
.br
:hp2.Copies a file.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.COPY FILE <cfile> TO <cfile1>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFile>   Filename of source file  <cFile1>  Filename of target file
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command makes an exact copy of <cFile> and names it <cFile1>.  Both files must have the file extension included&semi. the drive and the  directory names must also be specified if they are different from  the default drive
and&slash.or director.<cFile1> also can refer to a OS  device &lpar.e.g. LPT1&rpar..This command does not obsert the SET PATH TO or  SET DEFAULT TO settings.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      COPY FILE C&colon.\HARBOUR\TESTS\ADIRTEST.PRG to C&colon.\TEMP\ADIRTEST.PRG
.br
      COPY FILE c&colon.\harbour\utils\hbdoc\gennf.prg to LPT1
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper compliant
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=94.ERASE:elink.
.br
:link reftype=hd res=96.RENAME:elink.
.br
:link reftype=hd res=93.FRENAME():elink.
.br
:link reftype=hd res=92.FERASE():elink.
.br
:h2 id=LOWY res=107.HB_FEOF()
:i2 refid=LOW LX.HB_FEOF()
:p.HB&us.FEOF&lpar.&rpar.
.br
.br
:hp2.Check for end&minus.of&minus.file.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.FEOF&lpar. <nHandle> &rpar. &minus.&minus.> lIsEof:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nHandle> The handle of an open file.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lIsEof> .T. if the file handle is at end&minus.of&minus.file&comma. otherwise .F.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function checks an open file handle to see if it is at E&minus.O&minus.F.
.br
:p.If the file handle is missing&comma. not numeric&comma. or not open&comma. then this  function returns .T. and sets the value returned by FERROR&lpar.&rpar. to &minus.1  &lpar.FS&us.ERROR&rpar. or a C&minus.compiler dependent
errno value &lpar.EBADF or EINVAL&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      nH&colon.&eq.FOPEN&lpar.'FILE.TXT'&rpar.
.br
      ? FREADSTR&lpar.nH&comma.80&rpar.
.br
      IF HB&us.FEOF&lpar.nH&rpar.
.br
         ? 'End&minus.of&minus.file reached.'
.br
      ELSE
.br
         ? FREADSTR&lpar.nH&comma.80&rpar.
.br
      ENDIF
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=90.FERROR():elink.
.br
:h2 id=LOWY res=108.DIRREMOVE()
:i2 refid=LOW LX.DIRREMOVE()
:p.DIRREMOVE&lpar.&rpar.
.br
.br
:hp2.Attempt to remove an directory:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DIRCHANGE&lpar. <cDirectory> &rpar. &minus.&minus.> nError:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cDirectory>  The name of the directory you want to remove.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nError> 0 if directory was successfully removed&comma. otherwise  the number of the last error.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function attempt to remove the specified directory in <cDirectory>  If this function fail&comma. the it will return the last OS error code number.  See FERROR&lpar.&rpar. function for the description of the error.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      cDir&colon.&eq. &cdq..\Backup&cdq.
.br
      if &lpar.DIRREMOVE&lpar.cDir&rpar.&eq.&eq.0&rpar.
.br
          ? &cdq.Remove of directory&cdq.&comma.cDir&comma. &cdq.was successfull&cdq.
.br
      endif
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA Clipper 5.3 compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=109.MAKEDIR():elink.
.br
:link reftype=hd res=110.DIRCHANGE():elink.
.br
:link reftype=hd res=111.ISDISK():elink.
.br
:link reftype=hd res=112.DISKCHANGE():elink.
.br
:link reftype=hd res=113.DISKNAME():elink.
.br
:link reftype=hd res=90.FERROR():elink.
.br
:h2 id=LOWY res=110.DIRCHANGE()
:i2 refid=LOW LX.DIRCHANGE()
:p.DIRCHANGE&lpar.&rpar.
.br
.br
:hp2.Changes the directory:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DIRCHANGE&lpar. <cDirectory> &rpar. &minus.&minus.> nError:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cDirectory>  The name of the directory you want do change into.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nError> 0 if directory was successfully changed&comma. otherwise  the number of the last error.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function attempt to change the current directory to the one  specidied in <cDirectory>.If this function fail&comma. the it will return  the last OS error code number.See FERROR&lpar.&rpar. function for the  description of
the error.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      if &lpar.DIRCHANGE&lpar.&cdq.\temp&cdq.&rpar.&eq.&eq.0&rpar.
.br
          ? &cdq.Change to diretory was successfull&cdq.
.br
      endif
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA Clipper 5.3 compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=109.MAKEDIR():elink.
.br
:link reftype=hd res=108.DIRREMOVE():elink.
.br
:link reftype=hd res=111.ISDISK():elink.
.br
:link reftype=hd res=112.DISKCHANGE():elink.
.br
:link reftype=hd res=113.DISKNAME():elink.
.br
:link reftype=hd res=90.FERROR():elink.
.br
:h2 id=LOWY res=109.MAKEDIR()
:i2 refid=LOW LX.MAKEDIR()
:p.MAKEDIR&lpar.&rpar.
.br
.br
:hp2.Create a new directory:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.MAKEDIR&lpar. <cDirectory> &rpar. &minus.&minus.> nError:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cDirectory>  The name of the directory you want to create.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nError> 0 if directory was successfully changed&comma. otherwise  the number of the last error.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function attempt to create a new directory with the name contained  in <cDirectory>.If this function fail&comma. the it will return the last OS  error code number.See FERROR&lpar.&rpar. function for the description of the
error
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      cDir&colon.&eq. &cdq.Temp&cdq.
.br
      If &lpar.MAKEDIR&lpar. cDir&rpar.&eq.&eq.0&rpar.
.br
          ? &cdq.Directory &cdq.&comma.cDir&comma.&cdq. successfully created
.br
      Endif
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA Clipper 5.3 compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=110.DIRCHANGE():elink.
.br
:link reftype=hd res=108.DIRREMOVE():elink.
.br
:link reftype=hd res=111.ISDISK():elink.
.br
:link reftype=hd res=112.DISKCHANGE():elink.
.br
:link reftype=hd res=113.DISKNAME():elink.
.br
:link reftype=hd res=90.FERROR():elink.
.br
:h2 id=LOWY res=111.ISDISK()
:i2 refid=LOW LX.ISDISK()
:p.ISDISK&lpar.&rpar.
.br
.br
:hp2.Verify if a drive is ready:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ISDISK&lpar. <cDrive> &rpar. &minus.&minus.> lSuccess:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cDrive>  An valid Drive letter
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lSuccess>  .T. is the drive is ready&comma. otherwise .F.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function attempts to access a drive. If the access to the drive  was successfull&comma. it will return true &lpar..T.&rpar.&comma. otherwise false&lpar..F.&rpar..This  function is usefull for backup function&comma. so you
can determine if the  drive that will recieve the backup data is ready or not.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      IF ISDISK&lpar.&cdq.A&cdq.&rpar.
.br
          ? &cdq.Drive is ready &cdq.
.br
      Endif
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See Examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA Clipper 5.3 compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=110.DIRCHANGE():elink.
.br
:link reftype=hd res=109.MAKEDIR():elink.
.br
:link reftype=hd res=108.DIRREMOVE():elink.
.br
:link reftype=hd res=112.DISKCHANGE():elink.
.br
:link reftype=hd res=113.DISKNAME():elink.
.br
:h1 MISCY.MISC
:h2  res=114.PROCNAME()
:i1 id=MISCX.MISC
:i2 refid=MISCX.PROCNAME()
:p.PROCNAME&lpar.&rpar.
.br
.br
:hp2.Gets the name of the current function on the stack:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.PROCNAME&lpar. <nLevel> &rpar. &minus.&minus.> <cProcName>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<nLevel>:ehp2.  is the function level required.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<cProcName>:ehp2.  The name of the function that it is being executed.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function looks at the top of the stack and gets the current  executed function if no arguments are passed. Otherwise it returns  the name of the function or procedure at <nLevel>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      See Test
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      This test will show the functions and procedures in stack.
.br
      before executing it.
.br
      function Test&lpar.&rpar.
.br
         LOCAL n &colon.&eq. 1
.br
         while !Empty&lpar. ProcName&lpar. n &rpar. &rpar.
.br
            ? ProcName&lpar. n++ &rpar.
.br
         end do
.br
      return nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.PROCNAME&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=115.PROCLINE():elink.
.br
:link reftype=hd res=116.PROCFILE():elink.
.br
:h2 id=MISCY res=115.PROCLINE()
:i2 refid=MISCX.PROCLINE()
:p.PROCLINE&lpar.&rpar.
.br
.br
:hp2.Gets the line number of the current function on the stack.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.PROCLINE&lpar. <nLevel> &rpar. &minus.&minus.> <nLine>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<nLevel>:ehp2.  is the function level required.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<nLine>:ehp2.  The line number of the function that it is being executed.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function looks at the top of the stack and gets the current  line number of the executed function if no arguments are passed.  Otherwise it returns the line number of the function or procedure  at <nLevel>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      See Test
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      function Test&lpar.&rpar.
.br
         ? ProcLine&lpar. 0 &rpar.
.br
         ? ProcName&lpar. 2 &rpar.
.br
      return nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.PROCLINE&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=114.PROCNAME():elink.
.br
:link reftype=hd res=116.PROCFILE():elink.
.br
:h2 id=MISCY res=116.PROCFILE()
:i2 refid=MISCX.PROCFILE()
:p.PROCFILE&lpar.&rpar.
.br
.br
:hp2.This function allways returns an empty string.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.PROCFILE&lpar. <xExp> &rpar. &minus.&minus.> <cEmptyString>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<xExp>:ehp2.  is any valid type.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<cEmptyString>:ehp2.  Return an empty string
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function is added to the RTL for full compatibility. It  always returns an empty string.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? ProcFile&lpar.&rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      function Test&lpar.&rpar.
.br
         ? ProcFile&lpar.&rpar.
.br
         ? ProcFile&lpar. NIL &rpar.
.br
         ? ProcFile&lpar. 2 &rpar.
.br
      return nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.PROCFILE&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=114.PROCNAME():elink.
.br
:link reftype=hd res=115.PROCLINE():elink.
.br
:h1 PARAY.PARAMETER CHECKS
:h2  res=117.HB_PVALUE()
:i1 id=PARAMX.PARAMETER CHECKS
:i2 refid=PARAMX.HB_PVALUE()
:p.HB&us.PVALUE&lpar.&rpar.
.br
.br
:hp2.Retrieves the value of an argument.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.PVALUE&lpar. <nArg> &rpar. &minus.&minus.> <xExp>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.A  number that indicates the argument to check.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<xExp>:ehp2.  Returns the value stored by an argument.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function is useful to check the value stored in an argument.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      See Test
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      function Test&lpar. nValue&comma. cString &rpar.
.br
         if PCount&lpar.&rpar. &eq.&eq. 2
.br
            ? hb&us.PValue&lpar. 1 &rpar.&comma. nValue
.br
            ? hb&us.PValue&lpar. 2 &rpar.&comma. cString
.br
         endif
.br
      return nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.HB&us.PVALUE&lpar.&rpar. is a new function and hence not CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=118.PCOUNT():elink.
.br
:h2 id=PARAY res=118.PCOUNT()
:i2 refid=PARAMX.PCOUNT()
:p.PCOUNT&lpar.&rpar.
.br
.br
:hp2.Retrieves the number of arguments passed to a function.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.PCOUNT&lpar.&rpar. &minus.&minus.> <nArgs>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nArgs> A number that indicates the number of arguments  passed to a function or procedure.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function is useful to check if a function or procedure  has received the required number of arguments.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      See Test
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      function Test&lpar. xExp &rpar.
.br
         if PCount&lpar.&rpar. &eq.&eq. 0
.br
            ? &cdq.This function needs a parameter&cdq.
.br
         else
.br
            ? xExp
.br
         endif
.br
      return nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.PCOUNT&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=117.HB_PVALUE():elink.
.br
:h1 EVENY.EVENTS
:h2  res=119.__QUIT()
:i1 id=EVENTX.EVENTS
:i2 refid=EVENTX.__QUIT()
:p.&us.&us.QUIT&lpar.&rpar.
.br
.br
:hp2.Terminates an application.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.QUIT&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.NIL
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function terminates the current application and returns  to the system.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      See Test
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      function EndApp&lpar. lYesNo &rpar.
.br
         if lYesNo
.br
            &us.&us.Quit&lpar.&rpar.
.br
         endif
.br
      return nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.QUIT&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=120.QUIT:elink.
.br
:h1 INTEY.INTERNAL
:h2  res=121.CLIPINIT()
:i1 id=INTERX.INTERNAL
:i2 refid=INTERX.CLIPINIT()
:p.CLIPINIT&lpar.&rpar.
.br
.br
:hp2.Initialize various Harbour sub&minus.systems:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.CLIPINIT&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.none.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.CLIPINIT&lpar.&rpar.:ehp2.  always return NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.CLIPINIT&lpar.&rpar. is one of the pre&minus.defined INIT PROCEDURE and is executed  at program startup. It declare an empty MEMVAR PUBLIC array called  GetList that is going to be used by the Get system. It activates the
default error handler&comma. and &lpar.at least for the moment&rpar. calls the  function that sets the default help key.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.It is said that CLIPINIT&lpar.&rpar. should not call the function that sets  the default help key since CA&minus.Clipper does it in some other place.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=122.INIT PROCEDURE:elink.
.br
:h2 id=INTEY res=123.__SetHelpK()
:i2 refid=INTERX.__SETHELPK()
:p.&us.&us.SetHelpK&lpar.&rpar.
.br
.br
:hp2.Set F1 as the default help key:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.SetHelpK&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.SetHelpK&lpar.&rpar.:ehp2.  always return NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Set F1 to execute a function called HELP if such a function is  linked into the program.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.SetHelpK&lpar.&rpar. works exactly like CA&minus.Clipper's &us.&us.SetHelpK&lpar.&rpar.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=124.__XHELP():elink.
.br
:link reftype=hd res=125.SET KEY:elink.
.br
:link reftype=hd res=126.SETKEY():elink.
.br
:h2 id=ERROY res=127.BREAK()
:i2 refid=ERRORX.BREAK()
:p.BREAK&lpar.&rpar.
.br
.br
:hp2.Exits from a BEGIN SEQUENCE block:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.BREAK&lpar. <xExp> &rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xExp> is any valid expression. It is always required.  If do not want to pass any argument&comma. just use NIL.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.NIL
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function passes control to the RECOVER statement in a  BEGIN SEQUENCE block.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      Break&lpar. NIL &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.BREAK&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=128.BEGIN SEQUENCE:elink.
.br
:h1 UTILY.UTILITY
:h2  res=129.DO()
:i1 id=UTILIX.UTILITY
:i2 refid=UTILIX.DO()
:p.DO&lpar.&rpar.
.br
.br
:hp2.Calls a procedure or a function:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DO&lpar. <xFuncProc> &lbrk.&comma. <xArguments...>&rbrk.. &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xFuncProc> &eq. Either a string with a function&slash.procedure name to be called  or a codeblock to evaluate.
:p.<xArguments> &eq. arguments passed to a called function&slash.procedure or to  a codeblock.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.A  value that was returned from called function.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function can be called either by the harbour compiler or by user.  The compiler always passes the item of IT&us.SYMBOL type that stores the  name of procedure specified in DO <proc> WITH ... statement.
:p.If called procedure&slash.function doesn't exist then a runtime error  is generated.
:p.This function can be used as replacement of macro operator.  It is also used internally to implement DO <proc> WITH <args...>  In this case <xFuncProc> is of type HB&us.SYMB.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      cbCode &eq.&lbrc.&splitvbar.x&splitvbar. MyFunc&lpar. x &rpar.&rbrc.
.br
      DO&lpar. cbCode&comma. 1 &rpar.
.br

.br
      cFunction &colon.&eq. &cdq.MyFunc&cdq.
.br
      xRetVal &colon.&eq.DO&lpar. cFunction&comma. 2 &rpar.
.br

.br
      Old style &lpar.slower&rpar.&colon.
.br
      DO &amp.cFunction WITH 3
.br
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
:h1 VARIY.VARIABLE MANAGEMENT
:h2  res=130.__VMVARLGET()
:i1 id=VARIAX.VARIABLE MANAGEMENT
:i2 refid=VARIAX.__VMVARLGET()
:p.&us.&us.VMVARLGET&lpar.&rpar.
.br
.br
:hp2.Retrive a local variable from a procedure level:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.VMVARLGET&lpar. <nProcLevel>&comma. <nLocal> &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nProcLevel> Is the procedure level&comma. same as used in ProcName&lpar.&rpar.  and ProcLine&lpar.&rpar.&comma. from which a local variable containts is going to  be retrieved.
:p.:hp2.<nLocal>:ehp2.  Is the index of the local variable to retrieve.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.The  containts of a specific local variable
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function is used from the debugger
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
:h1 CONSY.CONSOLE INPUT
:h2  res=131.INKEY()
:i1 id=CONSOX.CONSOLE INPUT
:i2 refid=CONSOX.INKEY()
:p.INKEY&lpar.&rpar.
.br
.br
:hp2.Extracts the next key code from the Harbour keyboard buffer.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.INKEY&lpar. &lbrk.<nTimeout>&rbrk.. &lbrk.&comma.<nEvents>&rbrk.. &rpar. &minus.&minus.> nKey:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nTimeout> is an optional timeout value in seconds&comma. with a granularity  of 1&slash.10th of a second. If omitted&comma. INKEY&lpar.&rpar. returns immediately. If set  to 0&comma. INKEY&lpar.&rpar. waits until an input event
occurs. If set to any other  value&comma. INKEY&lpar.&rpar. will return either when an input event occurs or when  the timeout period has elapsed. If only this parameter is specified  and it is not numeric&comma. it will be
treated as if it were 0. But if both  parameters are specified and this parameter is not numeric&comma. it will be  treated as if it were not present.
.br
:p.<nEvents> is an optional mask of input events that are to be enabled.  If omitted&comma. defaults to hb&us.set.HB&us.SET&us.EVENTMASK. Valid input masks are  in inkey.ch and are explained below. It is recommended that the mask
names be used rather than their numeric values&comma. in case the numeric  values change in future releases of Harbour. To allow more than one  type of input event&comma. simply add the various mask names together.
.br
:table cols='14 43'.
:row.
:c.inkey.ch
:c.Meaning
:row.
:c.
:row.
:c.INKEY_MOVE
:c.Mouse motion events are allowed
:row.
:c.INKEY_LDOWN
:c.The mouse left click down event is allowed
:row.
:c.INKEY_LUP
:c.The mouse left click up event is allowed
:row.
:c.INKEY_RDOWN
:c.The mouse right click down event is allowed
:row.
:c.INKEY_RUP
:c.The mouse right click up event is allowed
:row.
:c.INKEY_KEYBOARD
:c.All keyboard events are allowed
:row.
:c.INKEY_ALL
:c.All mouse and keyboard events are allowed
:etable.
.br
:p.If the parameter is not numeric&comma. it will be treated as if it were set  to hb&us.set.HB&us.SET&us.EVENTMASK.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.0 in case of timeout with no input event&comma. otherwise returns a value  in the range &minus.39 to 386 for keyboard events or the range 1001 to 1007  for mouse events. Mouse events and non&minus.printable keyboard events are
represented by the K&us.<event> values listed in inkey.ch. Keyboard  event return codes in the range 32 through 127 are equivalent to the  printable ASCII character set. Keyboard event return codes
in the  range 128 through 255 are assumed to be printable&comma. but results may  vary based on hardware and nationality.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.INKEY&lpar.&rpar. can be used to detect input events&comma. such as keypress&comma. mouse  movement&comma. or mouse key clicks &lpar.up and&slash.or down&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Wait for the user to press the Esc key
.br
      ? &cdq.Please press the ESC key.&cdq.
.br
      WHILE INKEY&lpar. 0.1 &rpar. !&eq. K&us.ESC
.br
      END
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      KEYBOARD &cdq.AB&cdq.&semi. ? INKEY&lpar.&rpar.&comma. INKEY&lpar.&rpar. &eq.&eq.>   65   66
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.INKEY&lpar.&rpar. is compliant with the Clipper 5.3 INKEY&lpar.&rpar. function with one  exception&colon. The Harbour INKEY&lpar.&rpar. function will raise an argument error  if the first parameter is less than or equal to 0 and
the second  parameter &lpar.or the default mask&rpar. is not valid&comma. because otherwise INKEY  would never return&comma. because it was&comma. in effect&comma. asked to wait forever  for no events &lpar.Note&colon. In
Clipper&comma. this also blocks SET KEY events&rpar..
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=132.INKEY.CH:elink.
.br
:h2 id=CONSY res=133.__KEYBOARD()
:i2 refid=CONSOX.__KEYBOARD()
:p.&us.&us.KEYBOARD&lpar.&rpar.
.br
.br
:hp2.DO NOT CALL THIS FUNCTION DIRECTLY!:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.KEYBOARD <cString>:ehp2.
:p.:hp2.CLEAR TYPEAHEAD:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> is the optional string to stuff into the Harbour keyboard  buffer after clearing it first. Note&colon. The character &cdq.&semi.&cdq. is converted  to CHR&lpar.13&rpar. &lpar.this is an undocumented CA&minus.Clipper
feature&rpar..
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.There is no return value.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Clears the Harbour keyboard typeahead buffer and then inserts an  optional string into it.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Stuff an Enter key into the keyboard buffer
.br
      KEYBOARD CHR&lpar.13&rpar.
.br
      &slash.&slash. Clear the keyboard buffer
.br
      CLEAR TYPEAHEAD
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      KEYBOARD CHR&lpar.13&rpar.&semi. ? INKEY&lpar.&rpar. &eq.&eq.> 13
.br
      KEYBOARD &cdq.&semi.&cdq. ? INKEY&lpar.&rpar. &eq.&eq.> 13
.br
      KEYBOARD &cdq.HELLO&cdq.&semi. CLEAR TYPEAHEAD&semi. ? INKEY&lpar.&rpar. &eq.&eq.> 0
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.KEYBOARD&lpar.&rpar. is compliant with CA&minus.Clipper 5.3
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=134.CLEAR TYPEAHEAD:elink.
.br
:link reftype=hd res=135.KEYBOARD:elink.
.br
:h2 id=CONSY res=136.HB_KEYPUT()
:i2 refid=CONSOX.HB_KEYPUT()
:p.HB&us.KEYPUT&lpar.&rpar.
.br
.br
:hp2.Put an inkey code to the keyboard buffer.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.KEYPUT&lpar. <nInkeyCode> &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nInkeyCode> is the inkey code&comma. which should be inserted into the  keyboard buffer.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.There is no return value.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Inserts an inkey code to the string buffer. The buffer is *not*  cleared in this operation. This function allows to insert such  inkey codes which are not in the range of 0 to 255. To insert more  than one code&comma. call the
function repeatedly. The zero code cannot  be inserted.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Stuff an Alt+PgDn key into the keyboard buffer
.br
      HB&us.KEYPUT&lpar. K&us.ALT&us.PGDN &rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      HB&us.KEYPUT&lpar. K&us.ALT&us.PGDN &rpar. &semi. ? INKEY&lpar.&rpar. &eq.&eq.> 417
.br
      HB&us.KEYPUT&lpar. K&us.F11 &rpar. &semi. ? INKEY&lpar.&rpar. &eq.&eq.> &minus.40
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.HB&us.KEYPUT&lpar.&rpar. is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=135.KEYBOARD:elink.
.br
:link reftype=hd res=134.CLEAR TYPEAHEAD:elink.
.br
:link reftype=hd res=131.INKEY():elink.
.br
:h2 id=CONSY res=137.NEXTKEY()
:i2 refid=CONSOX.NEXTKEY()
:p.NEXTKEY&lpar.&rpar.
.br
.br
:hp2.Get the next key code in the buffer without extracting it.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.NEXTKEY&lpar.&rpar. &minus.&minus.> nKey:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nKey>  The value of the next key in the Harbour keyboard buffer.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Returns the value of the next key in the Harbour keyboard buffer  without extracting it.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Use NEXTKEY&lpar.&rpar. with INKEY&lpar.&rpar. to change display characters&comma. or by
.br
      &slash.&slash. itself to exit the loop&comma. so that the caller can detect the Esc.
.br
      LOCAL nKey&comma. cChar &colon.&eq. &cdq.+&cdq.
.br
      WHILE TRUE
.br
         ?? cChar
.br
         nKey &colon.&eq. NEXTKEY&lpar.&rpar.
.br
         IF nKey &eq.&eq. K&us.ESC
.br
            EXIT
.br
         ELSE
.br
            IF nKey !&eq. 0
.br
               cChar &colon.&eq. CHR&lpar. nKey &rpar.
.br
            END IF
.br
         END IF
.br
      END WHILE
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      KEYBOARD &cdq.AB&cdq.&semi. ? NEXTKEY&lpar.&rpar.&comma. NEXTKEY&lpar.&rpar. &eq.&eq.>   65   65
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.NEXTKEY&lpar.&rpar. is compliant with CA&minus.Clipper 5.3
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=131.INKEY():elink.
.br
:link reftype=hd res=138.LASTKEY():elink.
.br
:h2 id=CONSY res=138.LASTKEY()
:i2 refid=CONSOX.LASTKEY()
:p.LASTKEY&lpar.&rpar.
.br
.br
:hp2.Get the last key extracted from the keyboard buffer.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.LASTKEY&lpar.&rpar. &minus.&minus.> nKey:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nKey>  The last key extracted from the keyboard buffer.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Returns the value of the last key exttracted from the Harbour  keyboard buffer
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Continue looping unless the ESC key was pressed in MainFunc&lpar.&rpar.
.br
      WHILE TRUE
.br
         MainFunc&lpar.&rpar.
.br
         IF LASTKEY&lpar.&rpar. &eq.&eq. K&us.ESC
.br
            EXIT
.br
         ENDIF
.br
      END WHILE
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      KEYBOARD &cdq.AB&cdq.&semi. ? INKEY&lpar.&rpar.&comma. LASTKEY&lpar.&rpar. &eq.&eq.>   65   65
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.LASTKEY&lpar.&rpar. is compliant with CA&minus.Clipper 5.3
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=131.INKEY():elink.
.br
:link reftype=hd res=138.LASTKEY():elink.
.br
:h2 id=COMMY res=135.KEYBOARD
:i2 refid=COMMAX.KEYBOARD
:p.KEYBOARD
.br
.br
:hp2.Stuffs the keyboard with a string.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.KEYBOARD <cString>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> String to be processed&comma. one character at a time&comma.  by the Harbour keyboard processor
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command stuffs the input buffer with <cString>. The  number of characters that can be stuffed into the keyboard  buffer is controlled by the SET TYPEAHEAD command and may range  from 0 to 32&comma.622&comma. with each
character appearing in the ASCII  range of 0 to 255. None of the extended keys may be stuffed  into the keyboard buffer.  Issuing a KEYBOARD &cdq. &cdq. will clear the keyboard buffer.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Stuff an Enter key into the keyboard buffer
.br
      KEYBOARD CHR&lpar.13&rpar.
.br
      &slash.&slash. Clear the keyboard buffer
.br
      CLEAR TYPEAHEAD
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      KEYBOARD CHR&lpar.13&rpar.&semi. ? INKEY&lpar.&rpar. &eq.&eq.> 13
.br
      KEYBOARD &cdq.HELLO&cdq.&semi. CLEAR TYPEAHEAD&semi. ? INKEY&lpar.&rpar. &eq.&eq.> 0
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.KEYBOARD&lpar.&rpar. is compliant with CA&minus.Clipper 5.3
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=134.CLEAR TYPEAHEAD:elink.
.br
:link reftype=hd res=133.__KEYBOARD():elink.
.br
:h2 id=DATAY res=139.READKEY()*
:i2 refid=DATAX.READKEY()*
:p.READKEY&lpar.&rpar.*
.br
.br
:hp2.Find out which key terminated a READ.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.READKEY&lpar.&rpar. &minus.&minus.> nKeyCode:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.READKEY&lpar.&rpar. returns a numeric code representing the key that caused READ  to terminate.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.READKEY&lpar.&rpar. is used after a READ was terminated to determine the exit  key pressed. If the GET buffer was updated during READ&comma. 256 is added  to the return code.
.br
:table cols='14 13  9'.
:row.
:c.Exit
:c.Return code
:c.
:row.
:c.Key
:c.(not updated)
:c.(updated)
:row.
:c.
:row.
:c.Up
:c.4
:c.260
:row.
:c.Down
:c.5
:c.261
:row.
:c.Page-Up
:c.6
:c.22
:row.
:c.Page-Down
:c.7
:c.263
:row.
:c.Ctrl Page-Up
:c.34
:c.290
:row.
:c.Ctrl Page-Down
:c.35
:c.291
:row.
:c.Esc
:c.12
:c.268
:row.
:c.Ctrl End
:c.14
:c.270
:row.
:c.Enter
:c.15
:c.271
:row.
:c.Key &gt.= 32
:c.15
:c.271
:row.
:c.otherwise
:c.0
:c.
:etable.
.br
:p.READKEY&lpar.&rpar. is a compatibility function so try not to use it.  READKEY&lpar.&rpar. is superseded by LASTKEY&lpar.&rpar. which returns the INKEY&lpar.&rpar.  code for that key.  UPDATED&lpar.&rpar. could be used to find if
the  GET buffer was changed during the READ.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.READKEY&lpar.&rpar. is compliant with CA&minus.Clipper 5.3
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=140.@...GET:elink.
.br
:link reftype=hd res=131.INKEY():elink.
.br
:link reftype=hd res=138.LASTKEY():elink.
.br
:link reftype=hd res=141.READ:elink.
.br
:link reftype=hd res=142.READEXIT():elink.
.br
:link reftype=hd res=143.UPDATED():elink.
.br
:h2 id=CONSY res=144.MROW()
:i2 refid=CONSOX.MROW()
:p.MROW&lpar.&rpar.
.br
.br
:hp2.Returns the mouse cursor row position.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.MRow&lpar.&rpar. &minus.&minus.> nMouseRow:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nMouseRow> The mouse cursor row position.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the current mouse row cursor position.  On graphical systems the value represents pixel rows.  On character&minus.based systems the value represents character  rows as in Clipper.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      IF MRow&lpar.&rpar. < 1
.br
         ? &cdq.Mouse is on top row!&cdq.
.br
      ENDIF
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.MROW&lpar.&rpar. is compliant with CA&minus.Clipper 5.3&comma. but has been extended  to work on graphical systems as well as character&minus.based systems.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=145.MCOL():elink.
.br
:h2 id=CONSY res=145.MCOL()
:i2 refid=CONSOX.MCOL()
:p.MCOL&lpar.&rpar.
.br
.br
:hp2.Returns the mouse cursor column position.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.MCol&lpar.&rpar. &minus.&minus.> nMouseColumn:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nMouseColumn> The mouse cursor column position.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the column position of the mouse cursor.  On graphical systems the value represents pixels.  On character&minus.based systems the value represents character  columns as in Clipper.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      IF MCol&lpar.&rpar. < 1
.br
         ? &cdq.Mouse is on left edge!&cdq.
.br
      ENDIF
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.MROW&lpar.&rpar. is compliant with CA&minus.Clipper 5.3&comma. but has been extended  to work on graphical systems as well as character&minus.based systems.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=144.MROW():elink.
.br
:h1 DOCUY.DOCUMENT
:h2  res=146.License
:i1 id=DOCUMX.DOCUMENT
:i2 refid=DOCUMX.LICENSE
:p.License
.br
.br
:hp2.Harbour License:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
.br
:p.:hp2.THE HARBOUR PROJECT LICENSE:ehp2.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.This program is free software&semi. you can redistribute it and&slash.or modify  it under the terms of the GNU General Public License as published by  the Free Software Foundation&semi. either version 2 of the License&comma. or
&lpar.at your option&rpar. any later version&comma. with one exception&colon.
.br
:p.The exception is that if you link the Harbour Runtime Library &lpar.HRL&rpar.  and&slash.or the Harbour Virtual Machine &lpar.HVM&rpar. with other files to produce  an executable&comma. this does not by itself cause the resulting
executable  to be covered by the GNU General Public License. Your use of that  executable is in no way restricted on account of linking the HRL  and&slash.or HVM code into it.
.br
:p.This program is distributed in the hope that it will be useful&comma.  but :hp2.WITHOUT ANY WARRANTY:ehp2.&semi. without even the implied warranty of  :hp2.MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE:ehp2..  See the  GNU
General Public License for more details.
.br
:p.You should have received a copy of the GNU General Public License  along with this program&semi. if not&comma. write to the Free Software  Foundation&comma. Inc.&comma. 675 Mass Ave&comma. Cambridge&comma. MA 02139&comma. USA
&lpar.or visit  their web site at http&colon.&slash.&slash.www.gnu.org&slash.&rpar..
.br
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=147.OVERVIEW:elink.
.br
:h1 MATHY.MATH
:h2  res=148.ABS()
:i1 id=MATHX.MATH
:i2 refid=MATHX.ABS()
:p.ABS&lpar.&rpar.
.br
.br
:hp2.Return the absolute value of a number.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ABS&lpar.<nNumber>&rpar. &minus.&minus.> <nAbsNumber>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nNumber> Any number.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nAbsNumber> The absolute numeric value.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function yields the absolute value of the numeric value or  expression <nNumber>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      Proc Main&lpar.&rpar.
.br

.br
      Local nNumber&colon.&eq.50
.br
      Local nNumber1&colon.&eq.27
.br
      cls
.br

.br
      qout&lpar.nNumber&minus.nNumber1&rpar.
.br
      qout&lpar.nNumber1&minus.nNumber&rpar.
.br
      qout&lpar.ABS&lpar.nNumber&minus.nNumber1&rpar.&rpar.
.br
      qout&lpar.ABSnNumber1&minus.nNumber&rpar.&rpar.
.br
      qout&lpar.ABS&lpar. &minus.1 * 345&rpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=149.EXP():elink.
.br
:h2 id=MATHY res=149.EXP()
:i2 refid=MATHX.EXP()
:p.EXP&lpar.&rpar.
.br
.br
:hp2.Calculates the value of e raised to the passed power.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.EXP&lpar. <nNumber> &rpar. &minus.&minus.> <nValue>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nNumber> Any  real number.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nValue>  The anti&minus.logarithm of <nNumber>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the value of e raised to the power of  <nNumber>.  It is the inverse of LOG&lpar.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? EXP&lpar.45&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=150.LOG():elink.
.br
:h2 id=MATHY res=151.INT()
:i2 refid=MATHX.INT()
:p.INT&lpar.&rpar.
.br
.br
:hp2.Return the integer port of a numeric value.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.INT&lpar. <nNumber> &rpar. &minus.&minus.> <nIntNumber>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nNumber> Any  numeric value.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nIntNumber> The integer portion of the numeric value.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts a numeric expression to an integer. All  decimal digits are truncated. This function does not round a value  upward or downward&semi. it merely truncates a number at the decimal point.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      SET Decimal to 5
.br
      ? INT&lpar.632512.62541&rpar.
.br
      ? INT&lpar.845414111.91440&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=152.ROUND():elink.
.br
:link reftype=hd res=153.STRZERO():elink.
.br
:h2 id=MATHY res=150.LOG()
:i2 refid=MATHX.LOG()
:p.LOG&lpar.&rpar.
.br
.br
:hp2.Returns the natural logarithm of a number.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.LOG&lpar. <nNumber> &rpar. &minus.&minus.> <nLog>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nNumber> Any numeric expression.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nExponent> The natural logarithm of <nNumber>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the natural logarithm of the number <nNumber>.  If <nNumber> is 0 or less than 0&comma. a numeric overflow occurs&comma.  which is depicted on the display device as a series of asterisks.  This function is
the inverse of EXP&lpar.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? LOG&lpar.632512&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=149.EXP():elink.
.br
:h2 id=MATHY res=154.MAX()
:i2 refid=MATHX.MAX()
:p.MAX&lpar.&rpar.
.br
.br
:hp2.Returns the maximum of two numbers or dates.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.MAX&lpar.<xValue>&comma.<xValue1>&rpar.  &minus.&minus.> <xMax>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xValue>  Any date or numeric value.
.br
:p.<xValue1> Any date or numeric value &lpar.same type as <xValue>&rpar..
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<xMax> The larger numeric &lpar.or later date&rpar. value.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the larger of the two passed espressions. If  <xValue> and <xValue1> are numeric data types&comma. the value returned by  this function will be a numeric data type as well and will be the  larger of the two
numbers passed to it. If <xValue> and <xValue1> are  date data types&comma. the return value will be a date data  type as well. It will be the later of the two dates passed to it.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? MAX&lpar.214514214&comma.6251242142&rpar.
.br
      ? MAX&lpar.CTOD&lpar.'11&slash.11&slash.2000'&rpar.&comma.CTOD&lpar.'21&slash.06&slash.2014'&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=155.MIN():elink.
.br
:h2 id=MATHY res=155.MIN()
:i2 refid=MATHX.MIN()
:p.MIN&lpar.&rpar.
.br
.br
:hp2.Determines the minumum of two numbers or dates.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.MIN&lpar.<xValue>&comma.<xValue1>&rpar.  &minus.&minus.> <xMin>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xValue>  Any date or numeric value.
.br
:p.<xValue1> Any date or numeric value.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<xMin>  The smaller numeric &lpar.or earlier date&rpar. value.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the smaller of the two passed espressions.  <xValue> and <xValue1> must be the same data type. If numeric&comma. the  smaller number is returned. If dates&comma. the earlier date is returned.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? MIN&lpar.214514214&comma.6251242142&rpar.
.br
      ? MIN&lpar.CTOD&lpar.'11&slash.11&slash.2000'&rpar.&comma.CTOD&lpar.'21&slash.06&slash.2014'&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=154.MAX():elink.
.br
:h2 id=MATHY res=156.MOD()
:i2 refid=MATHX.MOD()
:p.MOD&lpar.&rpar.
.br
.br
:hp2.Return the modulus of two numbers.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.MOD&lpar. <nNumber>&comma.<nNumber1>&rpar. &minus.&minus.>  <nRemainder>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nNumber>  Numerator in a divisional expression.
.br
:p.<nNumber1> Denominator in a divisional expression.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nRemainder>  The remainder after the division operation.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This functuion returns the remainder of one number divided by another.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? MOD&lpar.12&comma.8.521&rpar.
.br
      ? Mod&lpar.12&comma.0&rpar.
.br
      ? Mod&lpar.62412.5142&comma.4522114.12014&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This Function is Ca&minus.Clipper compliant.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=157.%:elink.
.br
:h2 id=MATHY res=158.SQRT()
:i2 refid=MATHX.SQRT()
:p.SQRT&lpar.&rpar.
.br
.br
:hp2.Calculates the square root of a number.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SQRT&lpar. <nNumber> &rpar. &minus.&minus.> <nSqrt>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nNumber> Any  numeric value.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nSqrt>   The square root of <number>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the square root of <nNumber>. The precision of  this evaluation is based solely on the settings of the SET DECIMAL TO  command. Any negative number passed as <nNumber> will always return a 0.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      SET Decimal to 5
.br
      ? SQRT&lpar.632512.62541&rpar.
.br
      ? SQRT&lpar.845414111.91440&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=152.ROUND():elink.
.br
:h2 id=MATHY res=152.ROUND()
:i2 refid=MATHX.ROUND()
:p.ROUND&lpar.&rpar.
.br
.br
:hp2.Rounds off a numeric expression.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ROUND&lpar. <nNumber>&comma.<nPlace> &rpar. &minus.&minus.> <nResult>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nNumber> Any numeric value.
.br
:p.<nPlace>  The number of places to round to.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nResult> The rounded number.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function rounds off the value of <nNumber> to the number of  decimal places specified by <nPlace>. If the value of <nPlace> is a  negative number&comma. the function will attempt to round <nNumber> in whole  numbers. Numbers
from 5 through 9 will be rounded up&comma. all others will  be rounded down.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? ROUND&lpar.632512.62541&comma.5&rpar.
.br
      ? ROUND&lpar.845414111.91440&comma.3&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=151.INT():elink.
.br
:link reftype=hd res=159.STR():elink.
.br
:link reftype=hd res=160.VAL():elink.
.br
:link reftype=hd res=161.SET FIXED:elink.
.br
:h1 STRIY.STRINGS
:h2  res=162.MEMOTRAN()
:i1 id=STRINX.STRINGS
:i2 refid=STRINX.MEMOTRAN()
:p.MEMOTRAN&lpar.&rpar.
.br
.br
:hp2.Converts hard and soft carriage returns within strings.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.MEMOTRAN&lpar. <cString>&comma. <cHard>&comma. <cSoft> &rpar. &minus.&minus.> <cConvertedString>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> is a string of chars to convert.
.br
:p.<cHard> is the character to replace hard returns with. If not  specified defaults to semicolon.
.br
:p.<cSoft> is the character to replace soft returns with. If not  specified defaults to single space.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cConvertedString> Trasformed string.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Returns a string&slash.memo with carriage return chars converted to  specified chars.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? MEMOTRAN&lpar. DATA&minus.>CNOTES &rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      @ 1&comma. 1 SAY MEMOTRAN&lpar. Data&minus.>CNOTES &rpar.
.br
      will display converted string starting on row two&comma. column two of the
.br
      current device.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.MEMOTRAN&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=163.HARDCR():elink.
.br
:link reftype=hd res=164.STRTRAN():elink.
.br
:h2 id=STRIY res=163.HARDCR()
:i2 refid=STRINX.HARDCR()
:p.HARDCR&lpar.&rpar.
.br
.br
:hp2.Replace all soft carriage returns with hard carriages returns.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HARDCR&lpar. <cString> &rpar. &minus.&minus.> <cConvertedString>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> is a string of chars to convert.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cConvertedString> Trasformed string.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Returns a string&slash.memo with soft carriage return chars converted to  hard carriage return chars.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? HARDCR&lpar. Data&minus.>CNOTES &rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      @ 1&comma. 1 SAY HARDCR&lpar. Data&minus.>CNOTES &rpar.
.br
      will display converted string starting on row two&comma. column two of the
.br
      current device.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.HARDCR&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=162.MEMOTRAN():elink.
.br
:link reftype=hd res=164.STRTRAN():elink.
.br
:h2 id=ARRAY res=165.ACHOICE()
:i2 refid=ARRAYX.ACHOICE()
:p.ACHOICE&lpar.&rpar.
.br
.br
:hp2.Allows selection of an element from an array:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ACHOICE&lpar.<nTop>&comma. <nLeft>&comma. <nBottom>&comma. <nRight>&comma. <acMenuItems>&comma. &lbrk.<alSelableItems> &splitvbar. <lSelableItems>&rbrk..&comma. &lbrk.<cUserFunction> &splitvbar. <bUserBlock>&rbrk..&comma.:ehp2.
:hp2.&lbrk.<nInitialItem>&rbrk..&comma. &lbrk.<nWindowRow>&rbrk..&rpar. &minus.&minus.> nPosition:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nTop>           &minus. topmost row used to display array &lpar.default 0&rpar.
.br
:p.<nLeft>          &minus. leftmost row used to display array &lpar.default 0&rpar.
.br
:p.<nBottom>        &minus. bottommost row used to display array &lpar.default MAXROW&lpar.&rpar.&rpar.
.br
:p.<nRight>         &minus. rightmost row used to display array &lpar.default MAXCOL&lpar.&rpar.&rpar.
.br
:p.<acMenuItems>    &minus. the character array of items from which to select
.br
:p.<alSelableItems> &minus. an array of items&comma. either logical or character&comma.  which is used to determine if a particular item  may be selected.  If the type of a given item is  character&comma. it is macro
evaluated&comma. and the result  is expected to be a logical.  A value of .T. means  that the item may be selected&comma. .F. that it may not.  &lpar.See next argument&colon. lSelectableItems&rpar.
.br
:p.<lSelableItems>  &minus. a logical value which is used to apply to all  items in acMenuItems.  If .T.&comma. all items may be  selected&semi. if .F.&comma. none may be selected.  &lpar.See previous argument&colon.
alSelectableItems&rpar.  Default .T.
.br
:p.<cUserFunction>  &minus. the name of a function to be called which may  affect special processing of keystrokes.  It is  specified without parentheses or parameters.  When it is called&comma. it will be supplied with the
parameters&colon. nMode&comma. nCurElement&comma. and nRowPos.  Default NIL.
.br
:p.<bUserBlock>     &minus. a codeblock to be called which may  affect special processing of keystrokes. It  should be specified in the form  &lbrc.&splitvbar.nMode&comma. nCurElemenet&comma. nRowPos&splitvbar. &semi.
MyFunc&lpar.nMode&comma. nCurElemenet&comma. nRowPos&rpar. &rbrc..  Default NIL.
.br
:p.<nInitialItem>   &minus. the number of the element to be highlighted as  the current item when the array is initially  displayed.  1 origin.  Default 1.
.br
:p.<nWindowRow>     &minus. the number of the window row on which the initial  item is to be displayed. 0 origin.  Default 0.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nPosition>  &minus. the number of the item to be selected&comma. or 0 if the  selection was aborted.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Allows selection of an element from an array.  Please see standard Clipper documentation for ACHOICE for  additional detail.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      aItems &colon.&eq. &lbrc. &cdq.One&cdq.&comma. &cdq.Two&cdq.&comma. &cdq.Three&cdq. &rbrc.
.br
      nChoice &colon.&eq. ACHOICE&lpar. 10&comma. 10&comma. 20&comma. 20&comma. aItems &rpar.
.br
      IF nChoice &eq.&eq. 0
.br
          ? &cdq.You did not choose an item&cdq.
.br
      ELSE
.br
          ? &cdq.You chose element &cdq. + LTRIM&lpar. STR&lpar. nChoice &rpar. &rpar.
.br
          ?? &cdq. which has a value of &cdq. + aItems&lbrk. nChoice &rbrk..
.br
      ENDIF
.br
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=166.MENU TO:elink.
.br
:h2 id=DATAY res=167.__AtPrompt()
:i2 refid=DATAX.__ATPROMPT()
:p.&us.&us.AtPrompt&lpar.&rpar.
.br
.br
:hp2.Display a menu item on screen and define a message:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.AtPrompt&lpar. <nRow>&comma. <nCol>&comma. <cPrompt>&comma. &lbrk.<xMsg>&rbrk.. &rpar. &minus.&minus.> .F.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nRow> is the row number to display the menu <cPrompt>. Value could  range from zero to MAXROW&lpar.&rpar..
.br
:p.<nCol> is the column number to display the menu <cPrompt>. Value  could range from zero to MAXCOL&lpar.&rpar..
.br
:p.<cPrompt> is the menu item character string to display.
.br
:p.<xMsg> define a message to display each time this menu item is  highlighted. <xMsg> could be a character string or code block that  is evaluated to a character string. If <xMsg> is not specified or  got the wrong type&comma. an
empty string &lpar.&cdq.&cdq.&rpar. would be used.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.AtPrompt&lpar.&rpar. always return .F.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.With &us.&us.AtPrompt&lpar.&rpar. you define and display a menu item&comma. each call to  &us.&us.AtPrompt&lpar.&rpar. add another item to the menu&comma. to start the menu itself  you should call the &us.&us.MenuTo&lpar.&rpar.
function &lpar.MENU TO command&rpar.. You can  define any row and column combination and they will be displayed at  the order of definition. After each call to &us.&us.AtPrompt&lpar.&rpar.&comma. the cursor  is placed one column
to the right of the last text displayed&comma. and  ROW&lpar.&rpar. and COL&lpar.&rpar. are updated.
.br
:p.@...PROMPT command is preprocessed into &us.&us.AtPrompt&lpar.&rpar. function during  compile time.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. display a two line menu with status line at the bottom
.br
      &slash.&slash. let the user select favorite day
.br
      SET MESSAGE TO 24 CENTER
.br
      @ 10&comma. 2 PROMPT &cdq.Sunday&cdq. MESSAGE &cdq.This is the 1st item&cdq.
.br
      @ 11&comma. 2 PROMPT &cdq.Monday&cdq. MESSAGE &cdq.Now we're on the 2nd item&cdq.
.br
      MENU TO nChoice
.br
      DO CASE
.br
         CASE nChoice &eq.&eq. 0           &slash.&slash. user press Esc key
.br
              QUIT
.br
         CASE nChoice &eq.&eq. 1           &slash.&slash. user select 1st menu item
.br
              ? &cdq.Guess you don't like Mondays&cdq.
.br
         CASE nChoice &eq.&eq. 2           &slash.&slash. user select 2nd menu item
.br
              ? &cdq.Just another day for some&cdq.
.br
      ENDCASE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.CA&minus.Clipper array is limited to 4096 items&comma. and therefor 4096 menu  items are the maximum that could be defined per one menu&comma. Harbour  does not have this limit &lpar.not that you'll ever need that&rpar..
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=165.ACHOICE():elink.
.br
:link reftype=hd res=166.MENU TO:elink.
.br
:link reftype=hd res=168.SET MESSAGE:elink.
.br
:link reftype=hd res=169.SET INTENSITY:elink.
.br
:link reftype=hd res=170.SET WRAP:elink.
.br
:link reftype=hd res=171.__MENUTO():elink.
.br
:h2 id=COMMY res=172.@...PROMPT
:i2 refid=COMMAX.@...PROMPT
:p.@...PROMPT
.br
.br
:hp2.Display a menu item on screen and define a message:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.@ <nRow>&comma. <nCol> PROMPT <cPrompt> &lbrk.MESSAGE <xMsg>&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nRow> is the row number to display the menu <cPrompt>. Value could  range from zero to MAXROW&lpar.&rpar..
.br
:p.<nCol> is the column number to display the menu <cPrompt>. Value  could range from zero to MAXCOL&lpar.&rpar..
.br
:p.<cPrompt> is the menu item character string to display.
.br
:p.<xMsg> define a message to display each time this menu item is  highlighted. <xMsg> could be a character string or code block that  is evaluated to a character string. If <xMsg> is not specified or  got the wrong type&comma. an
empty string &lpar.&cdq.&cdq.&rpar. would be used.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.@...Prompt always return .F.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.With @...Prompt you define and display a menu item&comma. each call to  @...Prompt add another item to the menu&comma. to start the menu itself  you should call the &us.&us.MenuTo&lpar.&rpar. function &lpar.MENU TO command&rpar..
You can  define any row and column combination and they will be displayed at  the order of definition. After each call to @...Prompt&comma. the cursor  is placed one column to the right of the last text displayed&comma. and
ROW&lpar.&rpar. and COL&lpar.&rpar. are updated.
.br
:p.@...PROMPT command is preprocessed into &us.&us.AtPrompt&lpar.&rpar. function during  compile time.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. display a two line menu with status line at the bottom
.br
      &slash.&slash. let the user select favorite day
.br
      SET MESSAGE TO 24 CENTER
.br
      @ 10&comma. 2 PROMPT &cdq.Sunday&cdq. MESSAGE &cdq.This is the 1st item&cdq.
.br
      @ 11&comma. 2 PROMPT &cdq.Monday&cdq. MESSAGE &cdq.Now we're on the 2nd item&cdq.
.br
      MENU TO nChoice
.br
      DO CASE
.br
         CASE nChoice &eq.&eq. 0           &slash.&slash. user press Esc key
.br
              QUIT
.br
         CASE nChoice &eq.&eq. 1           &slash.&slash. user select 1st menu item
.br
              ? &cdq.Guess you don't like Mondays&cdq.
.br
         CASE nChoice &eq.&eq. 2           &slash.&slash. user select 2nd menu item
.br
              ? &cdq.Just another day for some&cdq.
.br
      ENDCASE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.CA&minus.Clipper array is limited to 4096 items&comma. and therefor 4096 menu  items are the maximum that could be defined per one menu&comma. Harbour  does not have this limit &lpar.not that you'll ever need that&rpar..
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=165.ACHOICE():elink.
.br
:link reftype=hd res=166.MENU TO:elink.
.br
:link reftype=hd res=168.SET MESSAGE:elink.
.br
:link reftype=hd res=169.SET INTENSITY:elink.
.br
:link reftype=hd res=170.SET WRAP:elink.
.br
:link reftype=hd res=171.__MENUTO():elink.
.br
:h2 id=DATAY res=171.__MenuTo()
:i2 refid=DATAX.__MENUTO()
:p.&us.&us.MenuTo&lpar.&rpar.
.br
.br
:hp2.Invoked a menu defined by set of @...PROMPT:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.MenuTo&lpar. <bBlock>&comma. <cVariable> &rpar. &minus.&minus.> nChoice:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<bBlock> is a set&slash.get code block for variable named <cVariable>.
.br
:p.<cVariable> is a character string that contain the name of the  variable to hold the menu choices&comma. if this variable does not exist  a PRIVATE variable with the name <cVariable> would be created to  hold the result.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.MenuTo&lpar.&rpar. return the number of select menu item&comma. or 0 if there was  no item to select from or if the user pressed the Esc key.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.MenuTo&lpar.&rpar. invoked the menu define by previous &us.&us.AtPrompt&lpar.&rpar. call  and display a highlight bar that the user can move to select an  option from the menu. If <cVariable> does not exist or not
visible&comma.  a PRIVATE variable named <cVariable> is created and hold the current  menu selection. If there is a variable named <cVariable>&comma. its value  is used to select the first highlighted item.
.br
:p.Menu prompts and messages are displayed in current Standard color&comma.  highlighted bar is displayed using current Enhanced color.
.br
:p.Pressing the arrow keys move the highlighted bar. When a menu item  is highlighted the message associated with it is displayed on the  line specified with SET MESSAGE. If SET WRAP is ON and the user  press UP arrow while on the
first selection the last menu item is  highlighted&comma. if the user press Down arrow while on the last item&comma.  the first item is highlighted.
.br
:p.Following are active keys that handled by &us.&us.MenuTo&lpar.&rpar.&colon.
&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
.br
:table cols='12 44'.
:row.
:c.key
:c.Meaning
:row.
:c.
:row.
:c.Up
:c.Move to previous item
:row.
:c.Down
:c.Move to next item
:row.
:c.Left
:c.Move to previous item
:row.
:c.Right
:c.Move to next item
:row.
:c.Home
:c.Move to the first item
:row.
:c.End
:c.Move to the last item
:row.
:c.Page-Up
:c.Select menu item, return position
:row.
:c.Page-Down
:c.Select menu item, return position
:row.
:c.Enter
:c.Select menu item, return position
:row.
:c.Esc
:c.Abort selection, return 0
:row.
:c.First letter
:c.Select next menu with the same first letter,
:row.
:c.|
:c.return this item position.
:etable.
.br
:p.upon exit the cursor is placed at MAXROW&lpar.&rpar.&minus.1&comma. 0  &us.&us.MenuTo&lpar.&rpar. can be nested without loosing the previous prompts.
.br
:p.MENU TO command is preprocessed into &us.&us.MenuTo&lpar.&rpar. function during  compile time.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. display menu item on each screen corner and let user select one
.br
      CLS
.br
      SET MESSAGE TO MAXROW&lpar.&rpar.&slash.2 CENTER
.br
      SET WRAP ON
.br
      @ 0&comma.         0           PROMPT &cdq.1. Upper left&cdq.   MESSAGE &cdq. One &cdq.
.br
      @ 0&comma.         MAXCOL&lpar.&rpar.&minus.16 PROMPT &cdq.2. Upper right&cdq.  MESSAGE &cdq. Two &cdq.
.br
      @ MAXROW&lpar.&rpar.&minus.1&comma.MAXCOL&lpar.&rpar.&minus.16 PROMPT &cdq.3. Bottom right&cdq. MESSAGE &cdq.Three&cdq.
.br
      @ MAXROW&lpar.&rpar.&minus.1&comma.0           PROMPT &cdq.4. Bottom left&cdq.  MESSAGE &cdq.Four &cdq.
.br
      MENU TO nChoice
.br
      SETPOS &lpar. MAXROW&lpar.&rpar.&slash.2&comma. MAXCOL&lpar.&rpar.&slash.2 &minus. 10 &rpar.
.br
      if nChoice &eq.&eq. 0
.br
         ?? &cdq.Esc was pressed&cdq.
.br
      else
.br
         ?? &cdq.Selected option is&cdq.&comma. nChoice
.br
      endif
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=172.@...PROMPT:elink.
.br
:link reftype=hd res=165.ACHOICE():elink.
.br
:link reftype=hd res=168.SET MESSAGE:elink.
.br
:link reftype=hd res=169.SET INTENSITY:elink.
.br
:link reftype=hd res=170.SET WRAP:elink.
.br
:link reftype=hd res=167.__ATPROMPT():elink.
.br
:h2 id=COMMY res=166.MENU TO
:i2 refid=COMMAX.MENU TO
:p.MENU TO
.br
.br
:hp2.Invoked a menu defined by set of @...PROMPT:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.MENU TO <cVariable>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cVariable> is a character string that contain the name of the  variable to hold the menu choices&comma. if this variable does not exist  a PRIVATE variable with the name <cVariable> would be created to  hold the result.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Menu To return the number of select menu item&comma. or 0 if there was  no item to select from or if the user pressed the Esc key.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Menu To&lpar.&rpar. invoked the menu define by previous &us.&us.AtPrompt&lpar.&rpar. call  and display a highlight bar that the user can move to select an  option from the menu. If <cVariable> does not exist or not visible&comma.
a PRIVATE variable named <cVariable> is created and hold the current  menu selection. If there is a variable named <cVariable>&comma. its value  is used to select the first highlighted item.
.br
:p.Menu prompts and messages are displayed in current Standard color&comma.  highlighted bar is displayed using current Enhanced color.
.br
:p.Pressing the arrow keys move the highlighted bar. When a menu item  is highlighted the message associated with it is displayed on the  line specified with SET MESSAGE. If SET WRAP is ON and the user  press UP arrow while on the
first selection the last menu item is  highlighted&comma. if the user press Down arrow while on the last item&comma.  the first item is highlighted.
.br
:p.Following are active keys that handled by Menu To&colon.
&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
.br
:table cols='12 46'.
:row.
:c.key
:c.Meaning
:row.
:c.
:row.
:c.Up
:c.- Move to previous item
:row.
:c.Down
:c.- Move to next item
:row.
:c.Left
:c.- Move to previous item
:row.
:c.Right
:c.- Move to next item
:row.
:c.Home
:c.- Move to the first item
:row.
:c.End
:c.- Move to the last item
:row.
:c.Page-Up
:c.- Select menu item, return position
:row.
:c.Page-Down
:c.- Select menu item, return position
:row.
:c.Enter
:c.- Select menu item, return position
:row.
:c.Esc
:c.- Abort selection, return 0
:row.
:c.First letter
:c.- Select next menu with the same first letter,
:row.
:c.|
:c.return this item position.
:etable.
.br
:p.upon exit the cursor is placed at MAXROW&lpar.&rpar.&minus.1&comma. 0  Menu To can be nested without loosing the previous prompts.
.br
:p.MENU TO command is preprocessed into &us.&us.MenuTo&lpar.&rpar. function during  compile time.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. display menu item on each screen corner and let user select one
.br
      CLS
.br
      SET MESSAGE TO MAXROW&lpar.&rpar.&slash.2 CENTER
.br
      SET WRAP ON
.br
      @ 0&comma.         0           PROMPT &cdq.1. Upper left&cdq.   MESSAGE &cdq. One &cdq.
.br
      @ 0&comma.         MAXCOL&lpar.&rpar.&minus.16 PROMPT &cdq.2. Upper right&cdq.  MESSAGE &cdq. Two &cdq.
.br
      @ MAXROW&lpar.&rpar.&minus.1&comma.MAXCOL&lpar.&rpar.&minus.16 PROMPT &cdq.3. Bottom right&cdq. MESSAGE &cdq.Three&cdq.
.br
      @ MAXROW&lpar.&rpar.&minus.1&comma.0           PROMPT &cdq.4. Bottom left&cdq.  MESSAGE &cdq.Four &cdq.
.br
      MENU TO nChoice
.br
      SETPOS &lpar. MAXROW&lpar.&rpar.&slash.2&comma. MAXCOL&lpar.&rpar.&slash.2 &minus. 10 &rpar.
.br
      if nChoice &eq.&eq. 0
.br
         ?? &cdq.Esc was pressed&cdq.
.br
      else
.br
         ?? &cdq.Selected option is&cdq.&comma. nChoice
.br
      endif
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is CA Clipper compliant
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=172.@...PROMPT:elink.
.br
:link reftype=hd res=165.ACHOICE():elink.
.br
:link reftype=hd res=168.SET MESSAGE:elink.
.br
:link reftype=hd res=169.SET INTENSITY:elink.
.br
:link reftype=hd res=170.SET WRAP:elink.
.br
:link reftype=hd res=167.__ATPROMPT():elink.
.br
:h1 Y.
:h2  res=173.OS()
:i1 id=X.
:i2 refid=X.OS()
:p.OS&lpar.&rpar.
.br
.br
:hp2.Return the current operating system.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.OS&lpar.&rpar.   &minus.&minus.> <cOperatingSystem>:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cOperatinSystem>  &minus.> The Current operating system.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function will return the current operating system.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? OS&lpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compatible.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.source&slash.rtl&slash.version.c
:h1 ENVIY.ENVIRONMENT
:h2  res=174.VERSION()
:i1 id=ENVIRX.ENVIRONMENT
:i2 refid=ENVIRX.VERSION()
:p.VERSION&lpar.&rpar.
.br
.br
:hp2.Returns the HARBOUR Version or the Harbour&slash.Compiler Version.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.VERSION&lpar.&rpar.  &minus.&minus.> <cReturn>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cReturn>   String containing the Harbour Version&slash.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the current Harbour Version.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? QOUT&lpar.VERSION&lpar.&rpar.&rpar.
.br
      &cdq.Harbour Terminal&colon. Standard stream console&cdq.
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compatible.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.source&slash.rtl&slash.version.c  Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=173.OS():elink.
.br
:h2 id=ENVIY res=175.GETENV()
:i2 refid=ENVIRX.GETENV()
:p.GETENV&lpar.&rpar.
.br
.br
:hp2.Obtains system environmental settings.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.GETENV&lpar.<cEnviroment>&comma. <cDefaultValue> &rpar.  &minus.&minus.> <cReturn>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cEnviroment> Enviromental variable to obtain.
.br
:p.<cDefaultValue> Optional value to return if <cEnvironment> is not found.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cReturn>     Value of the Environment Variable.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function yields a string that is the value of the  environment variable <cEnviroment>&comma. which is stored at the  system level with the Set command. If no environment variable  can be found&comma. the value of the
function will be <cDefaultValue>  if it is passed&comma. else an empty string.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? QOUT&lpar.GETENV&lpar.'PATH'&rpar.&rpar.
.br
      ? QOUT&lpar.GETENV&lpar.'CONFIG'&rpar.&rpar.
.br
      ? QOUT&lpar.GETENV&lpar.'HARBOURCMD'&comma. '&minus.n &minus.l &minus.es2'&rpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper compliant.  The <cDefaultValue> parameter is a Harbour extension.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.source&slash.rtl&slash.gete.c  Library is rtl
:h1 DOSY.DOS
:h2  res=176.__RUN()
:i1 id=DOSX.DOS
:i2 refid=DOSX.__RUN()
:p.&us.&us.RUN&lpar.&rpar.
.br
.br
:hp2.Run an external program.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.RUN&lpar. <cCommand> &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cCommand> Command to execute.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command runs an external program. Please make sure that  you have enough free memory to be able to run the external  program. Do not use it to run Terminate and Stay Resident programs  &lpar.in case of DOS&rpar. since that
causes several problems.
.br
:p.Note&colon. This function is what the RUN command preprocesses into.  It is considered bad form to use this function directly.  Use the RUN command instead.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &us.&us.Run&lpar. &cdq.edit &cdq. + cMyTextFile &rpar.    &slash.&slash. Runs an external editor
.br
      &us.&us.Run&lpar. &cdq.command&cdq. &rpar.                &slash.&slash. Gives a DOS shell &lpar.DOS only&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.source&slash.rtl&slash.run.c  Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=177.RUN:elink.
.br
:h2 id=MISCY res=178.TONE()
:i1 id=MISCEX.MISCELLANEOUS
:i2 refid=MISCEX.TONE()
:p.TONE&lpar.&rpar.
.br
.br
:hp2.Sound a tone with a specified frequency and duration.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.TONE&lpar. <nFrequency>&comma. <nDuration> &rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nFrequency>  A non&minus.negative numeric value that specifies the  frequency of the tone in hertz.
.br
:p.<nDuration>   A positive numeric value which specifies the duration  of the tone in 1&slash.18 of a second units.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.TONE&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.TONE&lpar.&rpar. is a sound function that could be used to irritate the end  user&comma. his or her dog&comma. and the surrounding neighborhood. The frequency  is clamped to the range 0 to 32767 Hz.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      If lOk   &slash.&slash. Good Sound
.br
         TONE&lpar.  500&comma. 1 &rpar.
.br
         TONE&lpar. 4000&comma. 1 &rpar.
.br
         TONE&lpar. 2500&comma. 1 &rpar.
.br
      Else     &slash.&slash. Bad Sound
.br
         TONE&lpar.  300&comma. 1 &rpar.
.br
         TONE&lpar.  499&comma. 5 &rpar.
.br
         TONE&lpar.  700&comma. 5 &rpar.
.br
      EndIf
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      TONE&lpar. 800&comma. 1 &rpar.                         &slash.&slash. same as ? CHR&lpar.7&rpar.
.br
      TONE&lpar. 32000&comma. 200 &rpar.                     &slash.&slash. any dogs around yet?
.br
      TONE&lpar. 130.80&comma. 1 &rpar.                      &slash.&slash. musical note &minus. C
.br
      TONE&lpar. 400&comma. 0 &rpar.                         &slash.&slash. short beep
.br
      TONE&lpar. 700 &rpar.                            &slash.&slash. short beep
.br
      TONE&lpar. 10&comma. 18.2 &rpar.                       &slash.&slash. 1 second delay
.br
      TONE&lpar. &minus.1 &rpar.                             &slash.&slash. 1&slash.18.2 second delay
.br
      TONE&lpar. &rpar.                                &slash.&slash. 1&slash.18.2 second delay
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.TONE&lpar.&rpar. works exactly like CA&minus.Clipper's TONE&lpar.&rpar..
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=179.CHR():elink.
.br
:link reftype=hd res=180.SET BELL:elink.
.br
:h2 id=COMMY res=177.RUN
:i2 refid=COMMAX.RUN
:p.RUN
.br
.br
:hp2.Run an external program.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.RUN  <cCommand>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cCommand> Command to execute.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command runs an external program. Please make sure that you have  enough free memory to be able to run the external program.  Do not use it to run Terminate and Stay Resident programs  &lpar.in case of DOS&rpar. since that
causes several problems.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      Run  &cdq.edit &cdq. + cMyTextFile      &slash.&slash. Runs an external editor
.br
      Run  &cdq.command&cdq.                  &slash.&slash. Gives a DOS shell &lpar.DOS only&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper compliant.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.source&slash.rtl&slash.run.c  Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=177.RUN:elink.
.br
:h1 NATIY.NATION
:h2  res=181.ISAFFIRM()
:i1 id=NATIOX.NATION
:i2 refid=NATIOX.ISAFFIRM()
:p.ISAFFIRM&lpar.&rpar.
.br
.br
:hp2.Checks if passed char is an affirmation char:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ISAFFIRM&lpar. <cChar> &rpar. &minus.&minus.> <lTrueOrFalse>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<cChar>:ehp2.  is a char or string of chars
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lTrueOrFalse> True if passed char is an affirmation char&comma.otherwise  false
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function is used to check if a user's input is true or not  according to the msgxxx module used.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Wait until user enters Y
.br
      DO WHILE !ISAFFIRM&lpar. cYesNo &rpar.
.br
        ACCEPT &cdq.Sure&colon. &cdq. TO cYesNo
.br
      END DO
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.ISAFFIRM&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=182.ISNEGATIVE():elink.
.br
:link reftype=hd res=183.NATIONMSG():elink.
.br
:h2 id=NATIY res=182.ISNEGATIVE()
:i2 refid=NATIOX.ISNEGATIVE()
:p.ISNEGATIVE&lpar.&rpar.
.br
.br
:hp2.Checks if passed char is a negation char.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ISNEGATIVE&lpar. <cChar> &rpar. &minus.&minus.> <lTrueOrFalse>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<cChar>:ehp2.  is a char or string of chars
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lTrueOrFalse> True if passed char is a negation char&comma. otherwise  false.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function is used to check if a user's input is true or not  according to the msgxxx module used.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Wait until user enters N
.br
      DO WHILE !ISNEGATIVE&lpar. cYesNo &rpar.
.br
        ACCEPT &cdq.Sure&colon. &cdq. TO cYesNo
.br
      END DO
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.ISNEGATIVE&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=181.ISAFFIRM():elink.
.br
:link reftype=hd res=183.NATIONMSG():elink.
.br
:h2 id=NATIY res=183.NATIONMSG()
:i2 refid=NATIOX.NATIONMSG()
:p.NATIONMSG&lpar.&rpar.
.br
.br
:hp2.Returns international strings messages.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.NATIONMSG&lpar. <nMsg> &rpar. &minus.&minus.> <cMessage>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<nMsg>:ehp2.  is the message number you want to get.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cMessage> If <nMsg> is a valid message selector&comma. returns the message.  If <nMsg> is nil returns &cdq.Invalid Argument&cdq.&comma. and if <nMsg> is any  other type it returns an empty string.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.NATIONMSG&lpar.&rpar. returns international message descriptions.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Displays &cdq.Sure Y&slash.N&colon. &cdq.  and waits until user enters Y
.br
      &slash.&slash. Y&slash.N is the string for NATIONMSG&lpar. 12 &rpar. with default natmsg module.
.br
      DO WHILE !ISAFFIRM&lpar. cYesNo &rpar.
.br
        ACCEPT &cdq.Sure &cdq. + NATIONMSG&lpar. 12 &rpar. + &cdq.&colon. &cdq. TO cYesNo
.br
      END DO
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Not Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.NATIONMSG&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=181.ISAFFIRM():elink.
.br
:link reftype=hd res=182.ISNEGATIVE():elink.
.br
:h1 OBJEY.OBJECT MANIPULATION
:h2  res=184.__objHasData()
:i1 id=OBJECX.OBJECT MANIPULATION
:i2 refid=OBJECX.__OBJHASDATA()
:p.&us.&us.objHasData&lpar.&rpar.
.br
.br
:hp2.Determine whether a symbol exist in object as DATA:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.objHasData&lpar. <oObject>&comma. <cSymbol> &rpar. &minus.&minus.> lExist:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<oObject> is an object to scan.
.br
:p.<cSymbol> is the name of the symbol to look for.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objHasData&lpar.&rpar. return .T. if the given <cSymbol> exist as DATA  &lpar.instance variable&rpar. in object <oObject&rpar.&comma. .F. if it does not exist.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objHasData&lpar.&rpar. is a low level class support function that let you  find out if a symbol is an instance variable in a given object.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      oB &colon.&eq. TBrowseNew&lpar. 0&comma. 0&comma. 24&comma. 79 &rpar.
.br
      ? &us.&us.objHasData&lpar. oB&comma. &cdq.nLeft&cdq. &rpar.      &slash.&slash. this should return .T.
.br
      ? &us.&us.objHasData&lpar. oB&comma. &cdq.lBugFree&cdq. &rpar.   &slash.&slash. hopefully this should be .F.
.br
      ? &us.&us.objHasData&lpar. oB&comma. &cdq.Left&cdq. &rpar.       &slash.&slash. .F. since this is a METHOD
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objHasData&lpar.&rpar. is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=185.__OBJGETMETHODLIST():elink.
.br
:link reftype=hd res=186.__OBJGETMSGLIST():elink.
.br
:link reftype=hd res=187.__OBJHASMETHOD():elink.
.br
:h2 id=OBJEY res=187.__objHasMethod()
:i2 refid=OBJECX.__OBJHASMETHOD()
:p.&us.&us.objHasMethod&lpar.&rpar.
.br
.br
:hp2.Determine whether a symbol exist in object as METHOD:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.objHasMethod&lpar. <oObject>&comma. <cSymbol> &rpar. &minus.&minus.> lExist:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<oObject> is an object to scan.
.br
:p.<cSymbol> is the name of the symbol to look for.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objHasMethod&lpar.&rpar. return .T. if the given <cSymbol> exist as METHOD  &lpar.class function&rpar. in object <oObject&rpar.&comma. .F. if it does not exist.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objHasMethod&lpar.&rpar. is a low level class support function that let you  find out if a symbol is a class function in a given object.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      oB &colon.&eq. TBrowseNew&lpar. 0&comma. 0&comma. 24&comma. 79 &rpar.
.br
      ? &us.&us.objHasMethod&lpar. oB&comma. &cdq.nLeft&cdq. &rpar.      &slash.&slash. .F. since this is a DATA
.br
      ? &us.&us.objHasMethod&lpar. oB&comma. &cdq.FixBugs&cdq. &rpar.    &slash.&slash. hopefully this should be .F.
.br
      ? &us.&us.objHasMethod&lpar. oB&comma. &cdq.Left&cdq. &rpar.       &slash.&slash. this should return .T.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objHasMethod&lpar.&rpar. is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=185.__OBJGETMETHODLIST():elink.
.br
:link reftype=hd res=186.__OBJGETMSGLIST():elink.
.br
:link reftype=hd res=184.__OBJHASDATA():elink.
.br
:h2 id=OBJEY res=186.__objGetMsgList()
:i2 refid=OBJECX.__OBJGETMSGLIST()
:p.&us.&us.objGetMsgList&lpar.&rpar.
.br
.br
:hp2.Return names of all DATA or METHOD for a given object:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.objGetMsgList&lpar. <oObject>&comma. &lbrk.<lData>&rbrk.. &rpar. &minus.&minus.> aNames:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<oObject> is an object to scan.
.br
:p.<lData> is an optional logical value that specifies the information  to return. A value of .T. instruct the function to return list of  all DATA names&comma. .F. return list of all METHOD names. Default value  is .T.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objGetMsgList&lpar.&rpar. return an array of character stings with all DATA  names or all METHOD names for a given object. &us.&us.objGetMsgList&lpar.&rpar.  would return an empty array &lbrc.&rbrc. if the given object
does not contain  the requested information.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objGetMsgList&lpar.&rpar. is a low level class support function that let you  find all instance variable or class functions names for a given  object.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. show information about TBrowse class
.br
      oB &colon.&eq. TBrowseNew&lpar. 0&comma. 0&comma. 24&comma. 79 &rpar.
.br
      aData   &colon.&eq. &us.&us.objGetMsgList&lpar. oB&comma. .T. &rpar.
.br
      aMethod &colon.&eq. &us.&us.objGetMsgList&lpar. oB&comma. .F. &rpar.
.br
      FOR i &eq. 1 to len &lpar. aData &rpar.
.br
          ? &cdq.DATA name&colon.&cdq.&comma. aData&lbrk. i &rbrk..
.br
      NEXT
.br
      FOR i &eq. 1 to len &lpar. aMethod &rpar.
.br
          ? &cdq.METHOD name&colon.&cdq.&comma. aMethod&lbrk. i &rbrk..
.br
      NEXT
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objGetMsgList&lpar.&rpar. is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=185.__OBJGETMETHODLIST():elink.
.br
:link reftype=hd res=188.__OBJGETVALUELIST():elink.
.br
:link reftype=hd res=184.__OBJHASDATA():elink.
.br
:link reftype=hd res=187.__OBJHASMETHOD():elink.
.br
:h2 id=OBJEY res=185.__objGetMethodList()
:i2 refid=OBJECX.__OBJGETMETHODLIST()
:p.&us.&us.objGetMethodList&lpar.&rpar.
.br
.br
:hp2.Return names of all METHOD for a given object:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.objGetMethodList&lpar. <oObject> &rpar. &minus.&minus.> aMethodNames:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<oObject> is an object to scan.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objGetMethodList&lpar.&rpar. return an array of character stings with all  METHOD names for a given object. &us.&us.objGetMethodList&lpar.&rpar. would return  an empty array &lbrc.&rbrc. if the given object does not
contain any METHOD.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objGetMethodList&lpar.&rpar. is a low level class support function that let  you find all class functions names for a given object.  It is equivalent to &us.&us.objGetMsgList&lpar. oObject&comma. .F. &rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. show information about TBrowse class
.br
      oB &colon.&eq. TBrowseNew&lpar. 0&comma. 0&comma. 24&comma. 79 &rpar.
.br
      aMethod &colon.&eq. &us.&us.objGetMethodList&lpar. oB &rpar.
.br
      FOR i &eq. 1 to len &lpar. aMethod &rpar.
.br
          ? &cdq.METHOD name&colon.&cdq.&comma. aMethod&lbrk. i &rbrk..
.br
      NEXT
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objGetMethodList&lpar.&rpar. is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=186.__OBJGETMSGLIST():elink.
.br
:link reftype=hd res=188.__OBJGETVALUELIST():elink.
.br
:link reftype=hd res=184.__OBJHASDATA():elink.
.br
:link reftype=hd res=187.__OBJHASMETHOD():elink.
.br
:h2 id=OBJEY res=188.__objGetValueList()
:i2 refid=OBJECX.__OBJGETVALUELIST()
:p.&us.&us.objGetValueList&lpar.&rpar.
.br
.br
:hp2.Return an array of DATA names and values for a given object:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.objGetValueList&lpar. <oObject>&comma. &lbrk.<aExcept>&rbrk.. &rpar. &minus.&minus.> aData:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<oObject> is an object to scan.
.br
:p.<aExcept> is an optional array with DATA names you want to exclude  from the scan.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objGetValueList&lpar.&rpar. return a 2D array that contain pairs of a DATA  symbol name and the value of DATA. &us.&us.objGetValueList&lpar.&rpar. would return  an empty array &lbrc.&rbrc. if the given object does not
contain the requested  information.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objGetValueList&lpar.&rpar. is a low level class support function that  return an array with DATA names and value&comma. each array element is a  pair of&colon. aData&lbrk. i&comma. HB&us.OO&us.DATA&us.SYMBOL &rbrk..
contain the symbol name  aData&lbrk. i&comma. HB&us.OO&us.DATA&us.VALUE  &rbrk.. contain the value of DATA
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. show information about TBrowse class
.br
      oB &colon.&eq. TBrowseNew&lpar. 0&comma. 0&comma. 24&comma. 79 &rpar.
.br
      aData &colon.&eq. &us.&us.objGetValueList&lpar. oB &rpar.
.br
      FOR i &eq. 1 to len &lpar. aData &rpar.
.br
          ? &cdq.DATA name&colon.&cdq.&comma. aData&lbrk. i&comma. HB&us.OO&us.DATA&us.SYMBOL &rbrk..&comma. &semi.
.br
            &cdq.    value&eq.&cdq.&comma. aData&lbrk. i&comma. HB&us.OO&us.DATA&us.VALUE  &rbrk..
.br
      NEXT
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objGetValueList&lpar.&rpar. is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Header file is hboo.ch  Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=185.__OBJGETMETHODLIST():elink.
.br
:link reftype=hd res=186.__OBJGETMSGLIST():elink.
.br
:link reftype=hd res=184.__OBJHASDATA():elink.
.br
:link reftype=hd res=187.__OBJHASMETHOD():elink.
.br
:link reftype=hd res=189.__OBJSETVALUELIST():elink.
.br
:h2 id=OBJEY res=189.__ObjSetValueList()
:i2 refid=OBJECX.__OBJSETVALUELIST()
:p.&us.&us.ObjSetValueList&lpar.&rpar.
.br
.br
:hp2.Set object with an array of DATA names and values:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.ObjSetValueList&lpar. <oObject>&comma. <aData> &rpar. &minus.&minus.> oObject:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<oObject> is an object to set.
.br
:p.<aData> is a 2D array with a pair of instance variables and values  for setting those variable.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.ObjSetValueList&lpar.&rpar. return a reference to <oObject>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.ObjSetValueList&lpar.&rpar. is a low level class support function that let  you set a group of instance variables with values. each array  element in <aData> is a pair of&colon.  aData&lbrk. i&comma.
HB&us.OO&us.DATA&us.SYMBOL &rbrk.. which contain the variable name to set  aData&lbrk. i&comma. HB&us.OO&us.DATA&us.VALUE  &rbrk.. contain the new variable value.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. set some TBrowse instance variable
.br
      oB &colon.&eq. TBrowse&lpar.&rpar.&colon.New&lpar.&rpar.
.br
      aData &colon.&eq. array&lpar. 4&comma. 2 &rpar.
.br
      aData&lbrk. 1&comma. HB&us.OO&us.DATA&us.SYMBOL &rbrk.. &eq. &cdq.nTop&cdq.
.br
      aData&lbrk. 1&comma. HB&us.OO&us.DATA&us.VALUE  &rbrk.. &eq. 1
.br
      aData&lbrk. 2&comma. HB&us.OO&us.DATA&us.SYMBOL &rbrk.. &eq. &cdq.nLeft&cdq.
.br
      aData&lbrk. 2&comma. HB&us.OO&us.DATA&us.VALUE  &rbrk.. &eq. 10
.br
      aData&lbrk. 3&comma. HB&us.OO&us.DATA&us.SYMBOL &rbrk.. &eq. &cdq.nBottom&cdq.
.br
      aData&lbrk. 3&comma. HB&us.OO&us.DATA&us.VALUE  &rbrk.. &eq. 20
.br
      aData&lbrk. 4&comma. HB&us.OO&us.DATA&us.SYMBOL &rbrk.. &eq. &cdq.nRight&cdq.
.br
      aData&lbrk. 4&comma. HB&us.OO&us.DATA&us.VALUE  &rbrk.. &eq. 70
.br
      &us.&us.ObjSetValueList&lpar. oB&comma. aData &rpar.
.br
      ? oB&colon.nTop      &slash.&slash. 1
.br
      ? oB&colon.nLeft     &slash.&slash. 10
.br
      ? oB&colon.nBottom   &slash.&slash. 20
.br
      ? oB&colon.nRight    &slash.&slash. 70
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.ObjSetValueList&lpar.&rpar. is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Header file is hboo.ch  Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=188.__OBJGETVALUELIST():elink.
.br
:h2 id=OBJEY res=190.__objAddMethod()
:i2 refid=OBJECX.__OBJADDMETHOD()
:p.&us.&us.objAddMethod&lpar.&rpar.
.br
.br
:hp2.Add a METHOD to an already existing class:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.objAddMethod&lpar. <oObject>&comma. <cMethodName>&comma. <nFuncPtr> &rpar. &minus.&minus.> oObject:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<oObject> is the object to work on.
.br
:p.<cMethodName> is the symbol name of the new METHOD to add.
.br
:p.<nFuncPtr> is a pointer to a function to associate with the method.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objAddMethod&lpar.&rpar. return a reference to <oObject>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objAddMethod&lpar.&rpar. is a low level class support function that add a  new METHOD to an object. <oObject> is unchanged if a symbol with the  name <cMethodName> already exist in <oObject>.
.br
:p.Note that <nFuncPtr> is a special pointer to a function that was  created using the @ operator&comma. see example below.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. create a new THappy class and add a Smile method
.br
      oHappy &colon.&eq. TClass&lpar.&rpar.&colon.New&lpar. &cdq.THappy&cdq. &rpar.
.br
      &us.&us.objAddMethod&lpar. oHappy&comma. &cdq.Smile&cdq.&comma. @MySmile&lpar.&rpar. &rpar.
.br
      ? oHappy&colon.Smile&lpar. 1 &rpar.       &slash.&slash. &colon.&rpar.
.br
      ? oHappy&colon.Smile&lpar. 2 &rpar.       &slash.&slash. &semi.&rpar.
.br
      ? oHappy&colon.Smile&lpar. 3 &rpar.       &slash.&slash. *SMILE*
.br

.br
      STATIC FUNCTION MySmile&lpar. nType &rpar.
.br
      LOCAL cSmile
.br
      DO CASE
.br
         CASE nType &eq.&eq. 1
.br
              cSmile &colon.&eq. &cdq.&colon.&rpar.&cdq.
.br
         CASE nType &eq.&eq. 2
.br
              cSmile &colon.&eq. &cdq.&semi.&rpar.&cdq.
.br
         CASE nType &eq.&eq. 3
.br
              cSmile &colon.&eq. &cdq.*SMILE*&cdq.
.br
      ENDCASE
.br
      RETURN cSmile
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objAddMethod&lpar.&rpar. is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=191.__OBJADDINLINE():elink.
.br
:link reftype=hd res=192.__OBJADDDATA():elink.
.br
:link reftype=hd res=193.__OBJDELMETHOD():elink.
.br
:link reftype=hd res=185.__OBJGETMETHODLIST():elink.
.br
:link reftype=hd res=186.__OBJGETMSGLIST():elink.
.br
:link reftype=hd res=187.__OBJHASMETHOD():elink.
.br
:link reftype=hd res=194.__OBJMODMETHOD():elink.
.br
:h2 id=OBJEY res=191.__objAddInline()
:i2 refid=OBJECX.__OBJADDINLINE()
:p.&us.&us.objAddInline&lpar.&rpar.
.br
.br
:hp2.Add an INLINE to an already existing class:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.objAddInline&lpar. <oObject>&comma. <cInlineName>&comma. <bInline> &rpar. &minus.&minus.> oObject:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<oObject> is the object to work on.
.br
:p.<cInlineName> is the symbol name of the new INLINE to add.
.br
:p.<bInline> is a code block to associate with the INLINE method.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objAddInline&lpar.&rpar. return a reference to <oObject>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objAddInline&lpar.&rpar. is a low level class support function that add a  new INLINE method to an object. <oObject> is unchanged if a symbol  with the name <cInlineName> already exist in <oObject>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. create a new THappy class and add a Smile INLINE method
.br
      oHappy  &colon.&eq. TClass&lpar.&rpar.&colon.New&lpar. &cdq.THappy&cdq. &rpar.
.br
      bInline &colon.&eq. &lbrc. &splitvbar. nType &splitvbar. &lbrc. &cdq.&colon.&rpar.&cdq.&comma. &cdq.&semi.&rpar.&cdq.&comma. &cdq.*SMILE*&cdq. &rbrc.&lbrk. nType &rbrk.. &rbrc.
.br
      &us.&us.objAddInline&lpar. oHappy&comma. &cdq.Smile&cdq.&comma. bInline &rpar.
.br
      ? oHappy&colon.Smile&lpar. 1 &rpar.       &slash.&slash. &colon.&rpar.
.br
      ? oHappy&colon.Smile&lpar. 2 &rpar.       &slash.&slash. &semi.&rpar.
.br
      ? oHappy&colon.Smile&lpar. 3 &rpar.       &slash.&slash. *SMILE*
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objAddInline&lpar.&rpar. is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=192.__OBJADDDATA():elink.
.br
:link reftype=hd res=190.__OBJADDMETHOD():elink.
.br
:link reftype=hd res=195.__OBJDELINLINE():elink.
.br
:link reftype=hd res=185.__OBJGETMETHODLIST():elink.
.br
:link reftype=hd res=186.__OBJGETMSGLIST():elink.
.br
:link reftype=hd res=196.__OBJHASMETHOD() :elink.
.br
:link reftype=hd res=197.__OBJMODINLINE():elink.
.br
:h2 id=OBJEY res=192.__objAddData()
:i2 refid=OBJECX.__OBJADDDATA()
:p.&us.&us.objAddData&lpar.&rpar.
.br
.br
:hp2.Add a DATA to an already existing class:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.objAddData&lpar. <oObject>&comma. <cDataName> &rpar. &minus.&minus.> oObject:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<oObject> is the object to work on.
.br
:p.<cDataName> is the symbol name of the new DATA to add.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objAddData&lpar.&rpar. return a reference to <oObject>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objAddData&lpar.&rpar. is a low level class support function that add a new  DATA to an object. <oObject> is unchanged if a symbol with the name  <cDataName> already exist in <oObject>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. create a new THappy class and add a lHappy DATA
.br
      oHappy  &colon.&eq. TClass&lpar.&rpar.&colon.New&lpar. &cdq.THappy&cdq. &rpar.
.br
      &us.&us.objAddData&lpar. oHappy&comma. &cdq.lHappy&cdq. &rpar.
.br
      oHappy&colon.lHappy &colon.&eq. .T.
.br
      IF oHappy&colon.lHappy
.br
         ? &cdq.Happy&comma. Happy&comma. Joy&comma. Joy !!!&cdq.
.br
      ELSE
.br
         ? &cdq.&colon.&lpar....&cdq.
.br
      ENDIF
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objAddData&lpar.&rpar. is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=191.__OBJADDINLINE():elink.
.br
:link reftype=hd res=190.__OBJADDMETHOD():elink.
.br
:link reftype=hd res=198.__OBJDELDATA():elink.
.br
:link reftype=hd res=186.__OBJGETMSGLIST():elink.
.br
:link reftype=hd res=188.__OBJGETVALUELIST():elink.
.br
:link reftype=hd res=184.__OBJHASDATA():elink.
.br
:link reftype=hd res=189.__OBJSETVALUELIST():elink.
.br
:h2 id=OBJEY res=194.__objModMethod()
:i2 refid=OBJECX.__OBJMODMETHOD()
:p.&us.&us.objModMethod&lpar.&rpar.
.br
.br
:hp2.Modify &lpar.replace&rpar. a METHOD in an already existing class:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.objModMethod&lpar. <oObject>&comma. <cMethodName>&comma. <nFuncPtr> &rpar. &minus.&minus.> oObject:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<oObject> is the object to work on.
.br
:p.<cMethodName> is the symbol name of the METHOD to modify.
.br
:p.<nFuncPtr> is a pointer to a new function to associate with the  method.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objModMethod&lpar.&rpar. return a reference to <oObject>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objModMethod&lpar.&rpar. is a low level class support function that modify  a METHOD in an object and replace it with a new function. <oObject>  is unchanged if a symbol with the name <cMethodName> does not exist  in
<oObject>. &us.&us.objModMethod&lpar.&rpar. is used in inheritance mechanism.
.br
:p.Note that <nFuncPtr> is a special pointer to a function that was  created using the @ operator&comma. see example below.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. create a new THappy class and add a Smile method
.br
      oHappy &colon.&eq. TClass&lpar.&rpar.&colon.New&lpar. &cdq.THappy&cdq. &rpar.
.br
      &us.&us.objAddMethod&lpar. oHappy&comma. &cdq.Smile&cdq.&comma. @MySmile&lpar.&rpar. &rpar.
.br
      ? oHappy&colon.Smile&lpar. 1 &rpar.       &slash.&slash. &colon.&rpar.
.br
      ? oHappy&colon.Smile&lpar. 2 &rpar.       &slash.&slash. &semi.&rpar.
.br
      &slash.&slash. replace Smile method with a new function
.br
      &us.&us.objAddMethod&lpar. oHappy&comma. &cdq.Smile&cdq.&comma. @YourSmile&lpar.&rpar. &rpar.
.br
      ? oHappy&colon.Smile&lpar. 1 &rpar.       &slash.&slash. *SMILE*
.br
      ? oHappy&colon.Smile&lpar. 2 &rpar.       &slash.&slash. *WINK*
.br

.br
      STATIC FUNCTION MySmile&lpar. nType &rpar.
.br
      LOCAL cSmile
.br
      DO CASE
.br
         CASE nType &eq.&eq. 1
.br
              cSmile &colon.&eq. &cdq.&colon.&rpar.&cdq.
.br
         CASE nType &eq.&eq. 2
.br
              cSmile &colon.&eq. &cdq.&semi.&rpar.&cdq.
.br
      ENDCASE
.br
      RETURN cSmile
.br

.br
      STATIC FUNCTION YourSmile&lpar. nType &rpar.
.br
      LOCAL cSmile
.br
      DO CASE
.br
         CASE nType &eq.&eq. 1
.br
              cSmile &colon.&eq. &cdq.*SMILE*&cdq.
.br
         CASE nType &eq.&eq. 2
.br
              cSmile &colon.&eq. &cdq.*WINK*&cdq.
.br
      ENDCASE
.br
      RETURN cSmile
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objModMethod&lpar.&rpar. is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=190.__OBJADDMETHOD():elink.
.br
:link reftype=hd res=193.__OBJDELMETHOD():elink.
.br
:link reftype=hd res=185.__OBJGETMETHODLIST():elink.
.br
:link reftype=hd res=186.__OBJGETMSGLIST():elink.
.br
:link reftype=hd res=187.__OBJHASMETHOD():elink.
.br
:h2 id=OBJEY res=197.__objModInline()
:i2 refid=OBJECX.__OBJMODINLINE()
:p.&us.&us.objModInline&lpar.&rpar.
.br
.br
:hp2.Modify &lpar.replace&rpar. an INLINE method in an already existing class:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.objModInline&lpar. <oObject>&comma. <cInlineName>&comma. <bInline> &rpar. &minus.&minus.> oObject:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<oObject> is the object to work on.
.br
:p.<cInlineName> is the symbol name of the INLINE method to modify.
.br
:p.<bInline> is a new code block to associate with the INLINE method.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objModInline&lpar.&rpar. return a reference to <oObject>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objModInline&lpar.&rpar. is a low level class support function that modify  an INLINE method in an object and replace it with a new code block.  <oObject> is unchanged if a symbol with the name <cInlineName> does  not
exist in <oObject>. &us.&us.objModInline&lpar.&rpar. is used in inheritance  mechanism.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. create a new THappy class and add a Smile INLINE method
.br
      oHappy  &colon.&eq. TClass&lpar.&rpar.&colon.New&lpar. &cdq.THappy&cdq. &rpar.
.br
      bMyInline   &colon.&eq. &lbrc. &splitvbar. nType &splitvbar. &lbrc. &cdq.&colon.&rpar.&cdq.&comma. &cdq.&semi.&rpar.&cdq. &rbrc.&lbrk. nType &rbrk.. &rbrc.
.br
      bYourInline &colon.&eq. &lbrc. &splitvbar. nType &splitvbar. &lbrc. &cdq.*SMILE*&cdq.&comma. &cdq.*WINK*&cdq. &rbrc.&lbrk. nType &rbrk.. &rbrc.
.br
      &us.&us.objAddInline&lpar. oHappy&comma. &cdq.Smile&cdq.&comma. bMyInline &rpar.
.br
      ? oHappy&colon.Smile&lpar. 1 &rpar.       &slash.&slash. &colon.&rpar.
.br
      ? oHappy&colon.Smile&lpar. 2 &rpar.       &slash.&slash. &semi.&rpar.
.br
      &slash.&slash. replace Smile inline method with a new code block
.br
      &us.&us.objModInline&lpar. oHappy&comma. &cdq.Smile&cdq.&comma. bYourInline &rpar.
.br
      ? oHappy&colon.Smile&lpar. 1 &rpar.       &slash.&slash. *SMILE*
.br
      ? oHappy&colon.Smile&lpar. 2 &rpar.       &slash.&slash. *WINK*
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objModInline&lpar.&rpar. is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=191.__OBJADDINLINE():elink.
.br
:link reftype=hd res=195.__OBJDELINLINE():elink.
.br
:link reftype=hd res=185.__OBJGETMETHODLIST():elink.
.br
:link reftype=hd res=186.__OBJGETMSGLIST():elink.
.br
:link reftype=hd res=187.__OBJHASMETHOD():elink.
.br
:h2 id=OBJEY res=193.__objDelMethod()
:i2 refid=OBJECX.__OBJDELMETHOD()
:p.&us.&us.objDelMethod&lpar.&rpar.
.br
.br
:hp2.Delete a METHOD  from class:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.objDelMethod&lpar. <oObject>&comma. <cSymbol> &rpar. &minus.&minus.> oObject:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<oObject> is the object to work on.
.br
:p.<cSymbol> is the symbol name of METHOD or INLINE method to be  deleted &lpar.removed&rpar. from the object.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objDelMethod&lpar.&rpar. return a reference to <oObject>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objDelMethod&lpar.&rpar. is a low level class support function that delete  &lpar.remove&rpar. a METHOD or an INLINE method from an object. <oObject> is  unchanged if a symbol with the name <cSymbol> does not exist in
<oObject>.
.br
:p.&us.&us.objDelInline&lpar.&rpar. is exactly the same as &us.&us.objDelMethod&lpar.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. create a new THappy class and add a Smile method
.br
      oHappy &colon.&eq. TClass&lpar.&rpar.&colon.New&lpar. &cdq.THappy&cdq. &rpar.
.br
      &us.&us.objAddMethod&lpar. oHappy&comma. &cdq.Smile&cdq.&comma. @MySmile&lpar.&rpar. &rpar.
.br
      ? &us.&us.objHasMethod&lpar. oHappy&comma. &cdq.Smile&cdq. &rpar.    &slash.&slash. .T.
.br
      &slash.&slash. remove Smile method
.br
      &us.&us.objDelMethod&lpar. oHappy&comma. &cdq.Smile&cdq. &rpar.
.br
      ? &us.&us.objHasMethod&lpar. oHappy&comma. &cdq.Smile&cdq. &rpar.    &slash.&slash. .F.
.br

.br
      STATIC FUNCTION MySmile&lpar. nType &rpar.
.br
      LOCAL cSmile
.br
      DO CASE
.br
         CASE nType &eq.&eq. 1
.br
              cSmile &colon.&eq. &cdq.&colon.&rpar.&cdq.
.br
         CASE nType &eq.&eq. 2
.br
              cSmile &colon.&eq. &cdq.&semi.&rpar.&cdq.
.br
      ENDCASE
.br
      RETURN cSmile
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objDelMethod&lpar.&rpar. is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=191.__OBJADDINLINE():elink.
.br
:link reftype=hd res=190.__OBJADDMETHOD():elink.
.br
:link reftype=hd res=185.__OBJGETMETHODLIST():elink.
.br
:link reftype=hd res=186.__OBJGETMSGLIST():elink.
.br
:link reftype=hd res=187.__OBJHASMETHOD():elink.
.br
:link reftype=hd res=197.__OBJMODINLINE():elink.
.br
:link reftype=hd res=194.__OBJMODMETHOD():elink.
.br
:h2 id=OBJEY res=195.__objDelInline()
:i2 refid=OBJECX.__OBJDELINLINE()
:p.&us.&us.objDelInline&lpar.&rpar.
.br
.br
:hp2.Delete a METHOD INLINE from class:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.objDelInline&lpar. <oObject>&comma. <cSymbol> &rpar. &minus.&minus.> oObject:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<oObject> is the object to work on.
.br
:p.<cSymbol> is the symbol name of METHOD or INLINE method to be  deleted &lpar.removed&rpar. from the object.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objDelInMethod&lpar.&rpar. return a reference to <oObject>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objDelInMethod&lpar.&rpar. is a low level class support function that delete  &lpar.remove&rpar. a METHOD or an INLINE method from an object. <oObject> is  unchanged if a symbol with the name <cSymbol> does not exist in
<oObject>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. create a new THappy class and add a Smile method
.br
      oHappy &colon.&eq. TClass&lpar.&rpar.&colon.New&lpar. &cdq.THappy&cdq. &rpar.
.br
      &us.&us.objAddMethod&lpar. oHappy&comma. &cdq.Smile&cdq.&comma. @MySmile&lpar.&rpar. &rpar.
.br
      ? &us.&us.objHasMethod&lpar. oHappy&comma. &cdq.Smile&cdq. &rpar.    &slash.&slash. .T.
.br
      &slash.&slash. remove Smile method
.br
      &us.&us.objDelInMethod&lpar. oHappy&comma. &cdq.Smile&cdq. &rpar.
.br
      ? &us.&us.objHasMethod&lpar. oHappy&comma. &cdq.Smile&cdq. &rpar.    &slash.&slash. .F.
.br

.br
      STATIC FUNCTION MySmile&lpar. nType &rpar.
.br
      LOCAL cSmile
.br
      DO CASE
.br
         CASE nType &eq.&eq. 1
.br
              cSmile &colon.&eq. &cdq.&colon.&rpar.&cdq.
.br
         CASE nType &eq.&eq. 2
.br
              cSmile &colon.&eq. &cdq.&semi.&rpar.&cdq.
.br
      ENDCASE
.br
      RETURN cSmile
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objDelMethod&lpar.&rpar. is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=191.__OBJADDINLINE():elink.
.br
:link reftype=hd res=190.__OBJADDMETHOD():elink.
.br
:link reftype=hd res=185.__OBJGETMETHODLIST():elink.
.br
:link reftype=hd res=186.__OBJGETMSGLIST():elink.
.br
:link reftype=hd res=187.__OBJHASMETHOD():elink.
.br
:link reftype=hd res=197.__OBJMODINLINE():elink.
.br
:link reftype=hd res=194.__OBJMODMETHOD():elink.
.br
:h2 id=OBJEY res=198.__objDelData()
:i2 refid=OBJECX.__OBJDELDATA()
:p.&us.&us.objDelData&lpar.&rpar.
.br
.br
:hp2.Delete a DATA &lpar.instance variable&rpar. from class:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.objDelMethod&lpar. <oObject>&comma. <cDataName> &rpar. &minus.&minus.> oObject:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<oObject> is the object to work on.
.br
:p.<cDataName> is the symbol name of DATA to be deleted &lpar.removed&rpar. from  the object.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objDelData&lpar.&rpar. return a reference to <oObject>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objDelData&lpar.&rpar. is a low level class support function that delete  &lpar.remove&rpar. a DATA from an object. <oObject> is unchanged if a symbol  with the name <cDataName> does not exist in <oObject>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. create a new THappy class and add a lHappy DATA
.br
      oHappy  &colon.&eq. TClass&lpar.&rpar.&colon.New&lpar. &cdq.THappy&cdq. &rpar.
.br
      &us.&us.objAddData&lpar. oHappy&comma. &cdq.lHappy&cdq. &rpar.
.br
      ? &us.&us.objHasData&lpar. oHappy&comma. &cdq.lHappy&cdq. &rpar.    &slash.&slash. .T.
.br
      &slash.&slash. remove lHappy DATA
.br
      &us.&us.objDelData&lpar. oHappy&comma. &cdq.lHappy&cdq. &rpar.
.br
      ? &us.&us.objHasData&lpar. oHappy&comma. &cdq.lHappy&cdq. &rpar.    &slash.&slash. .F.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objDelData&lpar.&rpar. is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=192.__OBJADDDATA():elink.
.br
:link reftype=hd res=186.__OBJGETMSGLIST():elink.
.br
:link reftype=hd res=188.__OBJGETVALUELIST():elink.
.br
:link reftype=hd res=184.__OBJHASDATA():elink.
.br
:link reftype=hd res=189.__OBJSETVALUELIST():elink.
.br
:h2 id=OBJEY res=199.__objDerivedFrom()
:i2 refid=OBJECX.__OBJDERIVEDFROM()
:p.&us.&us.objDerivedFrom&lpar.&rpar.
.br
.br
:hp2.Determine whether a class is derived from another class:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.objDerivedFrom&lpar. <oObject>&comma. <xSuper> &rpar. &minus.&minus.> lIsParent:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<oObject> is the object to check.
.br
:p.<xSuper> is the object that may be a parent. <xSuper> can be either  an Object or a Character string with the class name.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objDerivedFrom&lpar.&rpar. return a logical TRUE &lpar..T.&rpar. if <oObject> is  derived from <xSuper>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objDerivedFrom&lpar.&rpar. is a low level class support function that check  is one class is a super class of the other&comma. or in other words&comma. does  class <oObject> a child or descendant of <xSuper>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Create three classes and check their relations
.br

.br
      #include &cdq.hbclass.ch&cdq.
.br
      FUNCTION main&lpar.&rpar.
.br
         local oSuper&comma. oObject&comma. oDress
.br
         oSuper  &colon.&eq. TMood&lpar.&rpar.&colon.New&lpar.&rpar.
.br
         oObject &colon.&eq. THappy&lpar.&rpar.&colon.New&lpar.&rpar.
.br
         oDress  &colon.&eq. TShirt&lpar.&rpar.&colon.New&lpar.&rpar.
.br
         ? &us.&us.objDerivedFrom&lpar. oObject&comma. oSuper &rpar.    &slash.&slash. .T.
.br
         ? &us.&us.objDerivedFrom&lpar. oSuper&comma. oObject &rpar.    &slash.&slash. .F.
.br
         ? &us.&us.objDerivedFrom&lpar. oObject&comma. oDress &rpar.    &slash.&slash. .F.
.br
      RETURN NIL
.br

.br
      CLASS TMood
.br
         METHOD New&lpar.&rpar. INLINE Self
.br
      ENDCLASS
.br

.br
      CLASS THappy FROM TMood
.br
         METHOD Smile&lpar.&rpar. INLINE qout&lpar. &cdq.*smile*&cdq. &rpar.
.br
      ENDCLASS
.br

.br
      CLASS TShirt
.br
         DATA Color
.br
         DATA Size
.br
         METHOD New&lpar.&rpar. INLINE Self
.br
      ENDCLASS
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.objDerivedFrom&lpar.&rpar. is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=184.__OBJHASDATA():elink.
.br
:link reftype=hd res=187.__OBJHASMETHOD():elink.
.br
:h2 id=DATAY res=200.RDDLIST()
:i2 refid=DATABX.RDDLIST()
:p.RDDLIST&lpar.&rpar.
.br
.br
:hp2.Return an array of the available Replaceable Database Drivers:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.RDDLIST&lpar.&lbrk.<nRDDType>&rbrk..&rpar. &minus.&minus.> aRDDList:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nRDDType> is an integer that represents the type of the RDD you  wish to list.  The constants RDT&us.FULL and RDT&us.TRANSFER represent the two  types of RDDs currently available.
.br
:p.RDDType Summary    Constant       Value     Meaning    RDT&us.FULL       1
Full RDD implementation  RDT&us.TRANSFER   2         Import&slash.Export only driver  
.br
:p.RDT&us.FULL identifies full&minus.featured RDDs that have all the capabilities  associated with an RDD.
.br
:p.RDT&us.TRANSFER identifies RDDs of limited capability.  They can only  transfer records between files.  You cannot use these limited RDD  drivers to open a file in a work area.  The SDF and DELIM drivers are  examples of this
type of RDD.  They are only used in the implementation  of APPEND FROM and COPY TO with SDF or DELIMITED files.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.RDDLIST&lpar.&rpar. returns a one&minus.dimensional array of the RDD names registered  with the application as <nRDDType>.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.RDDLIST&lpar.&rpar. is an RDD function that returns a one&minus.dimensional array that  lists the available RDDs.
.br
:p.If you do not supply <nRDDType>&comma. all available RDDs&comma. regardless of type&comma.  are returned.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
     In this example RDDLIST&lpar.&rpar. returns an array containing the
.br
      character strings&comma. &cdq.DBF&cdq.&comma. &cdq.SDF&cdq.&comma. &cdq.DELIM&cdq.&comma. &cdq.DBFCDX&cdq.&comma. and &cdq.DBFNTX&cdq.&colon.
.br

.br
      REQUEST DBFCDX
.br

.br
      .
.br
      . < statements >
.br
      .
.br

.br
      aRDDs &colon.&eq. RDDLIST&lpar.&rpar.
.br

.br
            &slash.&slash. Returns &lbrc.&cdq.DBF&cdq.&comma. SDF&cdq.&comma. &cdq.DELIM&cdq.&comma. &cdq.DBFCDX&cdq.&comma. &cdq.DBFNTX&cdq. &rbrc.
.br

.br
     In this example&comma. RDDLIST&lpar.&rpar. returns an array containing the
.br
      character strings&comma. &cdq.SDF&cdq. and &cdq.DELIM&cdq.&colon.
.br

.br
      #include &cdq.rddsys.ch&cdq.
.br
      .
.br
      . < statements >
.br
      .
.br
      aImpExp &colon.&eq. RDDLIST&lpar. RDT TRANSFER &rpar.
.br

.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
.br
:h2 id=DATAY res=201.RDDNAME()
:i2 refid=DATABX.RDDNAME()
:p.RDDNAME&lpar.&rpar.
.br
.br
:hp2.Return the name of the currently active RDD:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.RDDNAME&lpar.&rpar. &minus.&minus.> cRDDName:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Returns a character string&comma. cRDDName&comma. the registered name of the active  RDD in the current or specified work area.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.RDDNAME&lpar.&rpar. is an RDD function that returns a character string&comma. cRDDName&comma.  the name of the active RDD in the current or specified work area.
.br
:p.You can specify a work area other than the currently active work area by  aliasing the function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
   USE Customer VIA &cdq.DBFNTX&cdq. NEW
.br
   USE Sales    VIA &cdq.DBFCDX&cdq. NEW
.br

.br
   ? RDDNAME&lpar.&rpar.                          &slash.&slash. Returns&colon. DBFCDX
.br
   ? Customer&minus.>&lpar. RDDNAME&lpar.&rpar. &rpar.            &slash.&slash. Returns&colon. DBFNTX
.br
   ? Sales&minus.>&lpar. RDDNAME&lpar.&rpar. &rpar.               &slash.&slash. Returns&colon. DBFCDX
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
.br
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=200.RDDLIST():elink.
.br
:h2 id=DATAY res=202.RDDSETDEFAULT()
:i2 refid=DATABX.RDDSETDEFAULT()
:p.RDDSETDEFAULT&lpar.&rpar.
.br
.br
:hp2.Set or return the default RDD for the application:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.RDDSETDEFAULT&lpar.&lbrk.<cNewDefaultRDD>&rbrk..&rpar.:ehp2.
:p.:hp2.&minus.&minus.> cPreviousDefaultRDD:ehp2.
.br
:p.<cNewDefaultRDD> is a character string&comma. the name of the RDD that is  to be made the new default RDD in the application.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.RDDSETDEFAULT&lpar.&rpar. returns a character string&comma. cPreviousDefaultRDD&comma. the  name of the previous default driver.  The default driver is the driver  that HARBOUR uses if you do not explicitly specify an RDD with
the  VIA clause of the USE command.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.RDDSETDEFAULT&lpar.&rpar. is an RDD function that sets or returns the name of the  previous default RDD driver and&comma. optionally&comma. sets the current driver to  the new RDD driver specified by cNewDefaultRDD.  If
<cNewDefaultDriver>  is not specified&comma. the current default driver name is returned and  continues to be the current default driver.
.br
:p.This function replaces the DBSETDRIVER&lpar.&rpar. function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
   &slash.&slash. If the default driver is not DBFNTX&comma. make it the default
.br

.br
   IF &lpar. RDDSETDEFAULT&lpar.&rpar. !&eq. &cdq.DBFNTX&cdq. &rpar.
.br
      cOldRdd &colon.&eq. RDDSETDEFAULT&lpar. &cdq.DBFNTX&cdq. &rpar.
.br
   ENDIF
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
.br
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=203.DBSETDRIVER():elink.
.br
:h2 id=DATAY res=204.__RDDSETDEFAULT()
:i2 refid=DATABX.__RDDSETDEFAULT()
:p.&us.&us.RDDSETDEFAULT&lpar.&rpar.
.br
.br
:hp2.Set or return the default RDD for the application:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.RDDSETDEFAULT&lpar.&lbrk.<cNewDefaultRDD>&rbrk..&rpar.:ehp2.
:p.:hp2.&minus.&minus.> cPreviousDefaultRDD:ehp2.
.br
:p.<cNewDefaultRDD> is a character string&comma. the name of the RDD that is  to be made the new default RDD in the application.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.RDDSETDEFAULT&lpar.&rpar. returns a character string&comma. cPreviousDefaultRDD&comma. the  name of the previous default driver.  The default driver is the driver  that HARBOUR uses if you do not explicitly specify an RDD
with the  VIA clause of the USE command.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.RDDSETDEFAULT&lpar.&rpar. is an RDD function that sets or returns the name of the  previous default RDD driver and&comma. optionally&comma. sets the current driver to  the new RDD driver specified by cNewDefaultRDD.  If
<cNewDefaultDriver>  is not specified&comma. the current default driver name is returned and  continues to be the current default driver.
.br
:p.This function replaces the DBSETDRIVER&lpar.&rpar. function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. If the default driver is not DBFNTX&comma. make it the default
.br

.br
      IF &lpar. &us.&us.RDDSETDEFAULT&lpar.&rpar. !&eq. &cdq.DBFNTX&cdq. &rpar.
.br
           cOldRdd &colon.&eq. &us.&us.RDDSETDEFAULT&lpar. &cdq.DBFNTX&cdq. &rpar.
.br
      ENDIF
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
.br
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=203.DBSETDRIVER():elink.
.br
:h2 id=DATAY res=15.DBEVAL()
:i2 refid=DATABX.DBEVAL()
:p.DBEVAL&lpar.&rpar.
.br
.br
:hp2.Performs a code block operation on the current Database:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBEVAL&lpar. <bBlock>&comma.:ehp2.
:p.:hp2.&lbrk.<bFor>&rbrk..&comma. &lbrk.<bWhile>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<nNext>&rbrk..&comma. &lbrk.<nRecord>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<lRest>&rbrk.. &rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<bBlock> Operation that is to be performed
.br
:p.<bFor> Code block for the For condition
.br
:p.<bWhile> Code block for the WHILE condition
.br
:p.<nNext> Number of NEXT records  to process
.br
:p.<nRecord> Record number to work on exactly
.br
:p.<lRest> Toggle to rewind record pointer
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBEVAL&lpar.&rpar. always returns NIL
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Performs a code block operation on the current Database
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
         LOCAL nCount
.br

.br
         USE Test
.br

.br
         dbGoto&lpar. 4 &rpar.
.br
         ? RecNo&lpar.&rpar.
.br
         COUNT TO nCount
.br
         ? RecNo&lpar.&rpar.&comma. nCount
.br
         COUNT TO nCount NEXT 10
.br
         ? RecNo&lpar.&rpar.&comma. nCount
.br

.br
         RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.DBEVAL is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=14.EVAL():elink.
.br
:h2 id=DATAY res=205.DBF()
:i2 refid=DATABX.DBF()
:p.DBF&lpar.&rpar.
.br
.br
:hp2.Alias name of a work area:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.Dbf&lpar.&rpar. &minus.&minus.> <cWorkArea>:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cWorkArea> Name of alias
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the same alias name ofthe currently selected work  area.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br

.br
         USE Test
.br

.br
         select 0
.br
         qOut&lpar. IF&lpar.DBF&lpar.&rpar.&eq.&eq.&cdq.&cdq.&comma.&cdq.No Name&cdq.&comma.DBF&lpar.&rpar.&rpar.&rpar.
.br
         Test&minus.>&lpar.qOut&lpar.DBF&lpar.&rpar.&rpar.
.br
         qOut&lpar.Alias&lpar.1&rpar.&rpar.
.br

.br
         RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.DBF&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=206.ALIAS():elink.
.br
:h2 id=DATAY res=207.DBAPPEND()
:i2 refid=DATABX.DBAPPEND()
:p.DBAPPEND&lpar.&rpar.
.br
.br
:hp2.Appends a new record to a database file.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DbAppend&lpar.<lLock>&rbrk..&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<lLock> Toggle to release record locks
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DbAppend&lpar.&rpar. always returns NIL
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function add a new record to the end of the database  in the selected or aliased work area. All fields in that  database will be given empty data values &minus. character fields  will be filled with blank spaces&comma.date
fields with CTOD&lpar.'&slash.&slash.'&rpar.&comma.  numeric fields with 0&comma.logical fields with .F.&comma. and memo fields  with NULL bytes.The header of the database is not updated until  the record is flushed from th
e buffer and the contents are  written to the disk.
.br
:p.Under a networking enviroment&comma. DBAPPEND&lpar.&rpar. performs an additional  operation&colon. It attrmps to lock the newly added record. If  the database file is currently locked or if a locking assignment  if made to
LASTREC&lpar.&rpar.+1&comma.NETERR&lpar.&rpar. will return a logical true &lpar..T.&rpar.  immediately after the DBAPPEND&lpar.&rpar. function. This function does  not unlock the locked records.
.br
:p.If <lLock> is passed a logical true &lpar..T.&rpar. value&comma. it will  release the record locks&comma. which allows the application to main&minus.  tain multiple record locks during an appending operation. The  default for
this parameter is a logical false &lpar..F.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br

.br
         USE Test
.br
         local cName&eq.&cdq.HARBOUR&cdq.&comma.nId&eq.10
.br
         Test&minus.>&lpar.DbAppend&lpar.&rpar.&rpar.
.br
         Replace Test&minus.>Name wit cName&comma.Id with nId
.br
         Use
.br
         RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.DBAPPEND&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=208.DBUNLOCK():elink.
.br
:link reftype=hd res=209.DBUNLOCKALL():elink.
.br
:h2 id=DATAY res=210.DBCLEARFILTER()
:i2 refid=DATABX.DBCLEARFILTER()
:p.DBCLEARFILTER&lpar.&rpar.
.br
.br
:hp2.Clears the current filter condiction in a work area:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DbClearFilTer&lpar.&rpar. &minus.> NIL:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DbClearFilTer&lpar.&rpar. always returns NIL
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function clears any active filter condiction  for the current or selected work area.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      Function Main&lpar.&rpar.
.br

.br
       Use Test
.br

.br
       Set Filter to Left&lpar.Test&minus.>Name&comma.2&rpar. &eq.&eq. &cdq.An&cdq.
.br

.br
       Dbedit&lpar.&rpar.
.br

.br
       Test&minus.>&lpar.DbClearFilter&lpar.&rpar.&rpar.
.br

.br
       USE
.br

.br
       Return Nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.DBCLEARFILTER&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=211.DBSETFILTER():elink.
.br
:link reftype=hd res=212.DBFILTER():elink.
.br
:h2 id=DATAY res=213.DBCLOSEALL()
:i2 refid=DATABX.DBCLOSEALL()
:p.DBCLOSEALL&lpar.&rpar.
.br
.br
:hp2.Close all open files in all work areas.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DbCloseAll&lpar.&rpar. &minus.> NIL:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBCLOSEALL&lpar.&rpar. always return NIL
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function close all open databases and all associated  indexes.In addition&comma. it closes all format files and moves  the work area pointer to the first position
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      Function Main&lpar.&rpar.
.br

.br
       Use Test New
.br

.br
       DbEdit&lpar.&rpar.
.br

.br
       Use Test1 New
.br

.br
       DbEdit&lpar.&rpar.
.br

.br
       DbCloseAll&lpar.&rpar.
.br

.br
       USE
.br

.br
       Return Nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.DBCLOSEALL&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=214.DBUSEAREA():elink.
.br
:link reftype=hd res=215.DBCLOSEAREA():elink.
.br
:h2 id=DATAY res=215.DBCLOSEAREA()
:i2 refid=DATABX.DBCLOSEAREA()
:p.DBCLOSEAREA&lpar.&rpar.
.br
.br
:hp2.Close a database file in a work area.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DbCloseArea&lpar.&rpar. &minus.> NIL:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DbCloseArea&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function  will close any database open in the selected  or aliased work area.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      Function Main&lpar.&rpar.
.br

.br
       Use Test
.br

.br
       Dbedit&lpar.&rpar.
.br

.br
       Test&minus.>&lpar.DbCloseArea&lpar.&rpar.&rpar.
.br

.br
       USE
.br

.br
       Return Nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.DBCLOSEAREA&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=214.DBUSEAREA():elink.
.br
:link reftype=hd res=213.DBCLOSEALL():elink.
.br
:h2 id=DATAY res=216.DBCOMMIT()
:i2 refid=DATABX.DBCOMMIT()
:p.DBCOMMIT&lpar.&rpar.
.br
.br
:hp2.Updates all index and database buffers for a given workarea:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBCOMMIT&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBCOMMIT&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function updates all of the information for a give&comma.selected&comma.  or active workarea.This operation includes all database and index  buffers for that work area only. This function does not update all  open work
areas.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
      LOCAL cName&colon.&eq.SPACE&lpar.40&rpar.
.br
      LOCAL nId&colon.&eq.0
.br
      USE Test EXCLUSIVE NEW
.br
      &slash.&slash.
.br
      @ 10&comma. 10 GET cName
.br
      @ 11&comma. 10 GET nId
.br
      READ
.br
      &slash.&slash.
.br
      IF UPDATED&lpar.&rpar.
.br
         APPEND BLANK
.br
         REPLACE Tests&minus.>Name WITH cName
.br
         REPLACE Tests&minus.>Id WITH nId
.br
         Tests&minus.>&lpar. DBCOMMIT&lpar.&rpar. &rpar.
.br
      ENDIF
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=213.DBCLOSEALL():elink.
.br
:link reftype=hd res=217.DBCOMMITALL():elink.
.br
:link reftype=hd res=208.DBUNLOCK():elink.
.br
:h2 id=DATAY res=217.DBCOMMITALL()
:i2 refid=DATABX.DBCOMMITALL()
:p.DBCOMMITALL&lpar.&rpar.
.br
.br
:hp2.Flushes the memory buffer and performs a hard&minus.disk write:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBCOMMIT&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBCOMMIT&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function performs a hard&minus.disk write for all work areas.  Before the disk write is performed&comma.all buffers are flushed.  open work areas.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
      LOCAL cName&colon.&eq.SPACE&lpar.40&rpar.
.br
      LOCAL nId&colon.&eq.0
.br
      USE Test EXCLUSIVE NEW
.br
      USE TestId New INDEX Testid
.br
      &slash.&slash.
.br
      @ 10&comma. 10 GET cName
.br
      @ 11&comma. 10 GET nId
.br
      READ
.br
      &slash.&slash.
.br
      IF UPDATED&lpar.&rpar.
.br
         APPEND BLANK
.br
         REPLACE Tests&minus.>Name WITH cName
.br
         REPLACE Tests&minus.>Id WITH nId
.br
         IF !TestId&minus.>&lpar.DBSEEK&lpar.nId&rpar.&rpar.
.br
            APPEND BLANK
.br
            REPLACE Tests&minus.>Id WITH nId
.br
         ENDIF
.br
      ENDIF
.br
      DBCOMMITALL&lpar.&rpar.
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=213.DBCLOSEALL():elink.
.br
:link reftype=hd res=216.DBCOMMIT():elink.
.br
:link reftype=hd res=208.DBUNLOCK():elink.
.br
:h2 id=DATAY res=218.__DBCONTINUE()
:i2 refid=DATABX.__DBCONTINUE()
:p.&us.&us.DBCONTINUE&lpar.&rpar.
.br
.br
:hp2.Resume a pending LOCATE:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.DbCONTINUE&lpar.&rpar.   &minus.> NIL:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.DbCONTINUE&lpar.&rpar.  Always return nil
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.DBCONTINUE is a database command that searches from the current record  position for the next record meeting the most recent LOCATE condition  executed in the current work area.  It terminates when a match is found  or
end of file is encountered.  If &us.&us.DBCONTINUE is successful&comma. the matching  record becomes the current record and FOUND&lpar.&rpar. returns true &lpar..T.&rpar.&semi. if  unsuccessful&comma. FOUND&lpar.&rpar. returns
false &lpar..F.&rpar..
.br
:p.Each work area may have an active LOCATE condition.  In CA&minus.Clipper&comma. a  LOCATE condition remains pending until a new LOCATE condition is  specified.  No other commands release the condition.
.br
:p.Notes
.br
:p.Scope and WHILE condition&colon. Note that the scope and WHILE  condition of the initial LOCATE are ignored&semi. only the FOR condition  is used with CONTINUE.  If you are using a LOCATE with a WHILE  condition and want to
continue the search for a matching record&comma. use  SKIP and then repeat the original LOCATE statement adding REST as the  scope.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
     This example scans records in Sales.dbf for a particular
.br
      salesman and displays a running total sales amounts&colon.
.br

.br
      LOCAL nRunTotal &colon.&eq. 0
.br
      USE Sales NEW
.br
      LOCATE FOR Sales&minus.>Salesman &eq. &cdq.1002&cdq.
.br
      DO WHILE FOUND&lpar.&rpar.
.br
         ? Sales&minus.>Salesname&comma. nRunTotal +&eq. Sales&minus.>Amount
.br
         &us.&us.DBCONTINUE&lpar.&rpar.
.br
      ENDDO
.br

.br
     This example demonstrates how to continue if the pending
.br
      LOCATE scope contains a WHILE condition&colon.
.br

.br
      LOCAL nRunTotal &colon.&eq. 0
.br
      USE Sales INDEX Salesman NEW
.br
      SEEK &cdq.1002&cdq.
.br
      LOCATE REST WHILE Sales&minus.>Salesman &eq. &cdq.1002&cdq.&semi.
.br
            FOR Sales&minus.>Amount > 5000
.br
      DO WHILE FOUND&lpar.&rpar.
.br
         ? Sales&minus.>Salesname&comma. nRunTotal +&eq. Sales&minus.>Amount
.br
         SKIP
.br
         LOCATE REST WHILE Sales&minus.>Salesman &eq. &cdq.1002&cdq.&semi.
.br
            FOR Sales&minus.>Amount > 5000
.br
      ENDDO
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=219.EOF():elink.
.br
:link reftype=hd res=220.FOUND():elink.
.br
:h2 id=DATAY res=72.DBCREATE()
:i2 refid=DATABX.DBCREATE()
:p.DBCREATE&lpar.&rpar.
.br
.br
:hp2.Creates an empty database from a array.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBCREATE&lpar.<cDatabase>&comma. <aStruct>&comma.&lbrk.<cDriver>&rbrk..&comma.&lbrk.<lOpen>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<cAlias>&rbrk..&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cDatabase> Name of database to be create
.br
:p.<aStruct>   Name of a multidimensional array that contains the a database  structure
.br
:p.<cDriver>   Name of the RDD
.br
:p.<lOpen>     Toggle to Open the create File
.br
:p.<cAlias>    Name of database Alias
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBCREATE&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function creates the database file specified as <cDatabase> from the  multidimensional array <aStruct>.If no file extension is use with <cDatabase>  the .DBF extension is assumed.  The array specified in <aStruct> must
follow a few guidelines when being  built prior to a call to DBCREATE&lpar.&rpar.&colon.
.br
:p.&minus. All subscripts values in the second dimension must be set to proper values
.br
:p.&minus. The fourth subscript value in the second dimension &minus. which contains  the decimal value&minus.must he specified. even 1kw nonnumeric fields.
.br
:p.&minus. The second subscript value in the second dimension&minus.which contains  the field data type&minus.must contain a proper value&colon. C&comma. D&comma. L&comma. M or N  It is possible to use additional letters &lpar.or
clarity &lpar.e.g.&comma. 'Numeric'  for 'N'&rpar.&colon. however&comma. the first letter of this array element must  be a proper value.
.br
:p.The DBCREATE&lpar. &rpar. function does not use the decimal field to  calculate the length of a character held longer than 256. Values  up to the maximum length of a character field &lpar.which is 65&comma.519 bytes&rpar.  are
stored directly in the database in the length attribute if that  database was created via this function. However&comma. a file containing  fields longer than 256 bytes is not compatible with any interpreter.
.br
:p.The <cDriver> parameter specifies the name of the Replaceable Da&minus.  tabase Driver to use to create the database. If it is not specified&comma. then the  Replaceable Database Driver in the current work area is tised.  The
<lOpen> parameter specifies if the already created database is to be opened&comma.  The <cAlias> parameter specifies the alias name for the new opened database
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      function main&lpar.&rpar.
.br

.br
      local nI&comma. aStruct &colon.&eq. &lbrc. &lbrc. &cdq.CHARACTER&cdq.&comma. &cdq.C&cdq.&comma. 25&comma. 0 &rbrc.&comma. &semi.
.br
                          &lbrc. &cdq.NUMERIC&cdq.&comma.   &cdq.N&cdq.&comma.  8&comma. 0 &rbrc.&comma. &semi.
.br
                          &lbrc. &cdq.DOUBLE&cdq.&comma.    &cdq.N&cdq.&comma.  8&comma. 2 &rbrc.&comma. &semi.
.br
                          &lbrc. &cdq.DATE&cdq.&comma.      &cdq.D&cdq.&comma.  8&comma. 0 &rbrc.&comma. &semi.
.br
                          &lbrc. &cdq.LOGICAL&cdq.&comma.   &cdq.L&cdq.&comma.  1&comma. 0 &rbrc.&comma. &semi.
.br
                          &lbrc. &cdq.MEMO1&cdq.&comma.     &cdq.M&cdq.&comma. 10&comma. 0 &rbrc.&comma. &semi.
.br
                          &lbrc. &cdq.MEMO2&cdq.&comma.     &cdq.M&cdq.&comma. 10&comma. 0 &rbrc. &rbrc.
.br

.br
      REQUEST DBFCDX
.br

.br
      dbCreate&lpar. &cdq.testdbf&cdq.&comma. aStruct&comma. &cdq.DBFCDX&cdq.&comma. .t.&comma. &cdq.MYALIAS&cdq. &rpar.
.br

.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Not CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd  Header  is Dbstruct.ch
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=221.AFIELDS():elink.
.br
:link reftype=hd res=11.DBSTRUCT():elink.
.br
:h2 id=DATAY res=222.DBDELETE()
:i2 refid=DATABX.DBDELETE()
:p.DBDELETE&lpar.&rpar.
.br
.br
:hp2.Marks records for deletion in a database.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBDELETE&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBDELETE&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function marks a record for deletion in the selected  or aliased work area.If the DELETED setting is on&comma. the record  will still be visible until the record pointer in that work area  is moved to another record.
.br
:p.In a networking situation&comma. this function requires that the record  be locked prior to issuing the DBDELETE&lpar.&rpar. function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      nId&colon.&eq.10
.br
      USE TestId INDEX TestId NEW
.br
      IF TestId&minus.>&lpar.DBSEEK&lpar.nId&rpar.&rpar.
.br
         IF TestId&minus.>&lpar.RLOCK&lpar.&rpar.&rpar.
.br
            DBDELETE&lpar.&rpar.
.br
         ENDIF
.br
      ENDIF
.br
      USE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=223.DBRECALL():elink.
.br
:h2 id=DATAY res=212.DBFILTER()
:i2 refid=DATABX.DBFILTER()
:p.DBFILTER&lpar.&rpar.
.br
.br
:hp2.Return the filter expression in a work area:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBFILTER&lpar.&rpar. &minus.&minus.> cFilter:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBFILTER&lpar.&rpar. returns the filter expression.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function return the expression of the SET FILTER TO command  for the current or designated work area. If no filter condition  is present&comma.a NULL string will be returned.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE Test INDEX Test NEW
.br
      SET FILTER TO Name&eq. &cdq.Harbour&cdq.
.br
      USE TestId INDEX TestId NEW
.br
      SET FILTER TO Id &eq. 1
.br
      SELECT Test
.br
      &slash.&slash.
.br
      ? DBFILTER&lpar.&rpar.
.br
      ? TestId&minus.>&lpar.DBFILTER&lpar.&rpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=224.DBRELATION():elink.
.br
:link reftype=hd res=225.DBRSELECT():elink.
.br
:h2 id=DATAY res=226.DBGOBOTTOM()
:i2 refid=DATABX.DBGOBOTTOM()
:p.DBGOBOTTOM&lpar.&rpar.
.br
.br
:hp2.Moves the record pointer to the bottom of the database.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBGOBOTTOM&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBGOBOTTOM&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function moves the record pointer in the selected or aliased  work area to the end of the file.The position of the record pointer  is affected by the values in the index key or by an active FILTER
condition.Otherwise&comma.if no index is active or if no filter condition  is present&comma.the value of the record pointer will be LASTREC&lpar.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE Tests
.br
      DBGOTOP&lpar.&rpar.
.br
      ? RECNO&lpar.&rpar.
.br
      DBGOBOTTOM&lpar.&rpar.
.br
      ? RECNO&lpar.&rpar.
.br
      USE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=227.BOF():elink.
.br
:link reftype=hd res=219.EOF():elink.
.br
:link reftype=hd res=40.DBSKIP():elink.
.br
:link reftype=hd res=228.DBSEEK():elink.
.br
:link reftype=hd res=229.DBGOTOP():elink.
.br
:h2 id=DATAY res=230.DBGOTO()
:i2 refid=DATABX.DBGOTO()
:p.DBGOTO&lpar.&rpar.
.br
.br
:hp2.Position the record pointer to a specific location.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBGOTO&lpar.<xRecordNumber>&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xRecordNumber> Record number or unique identity
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBGOTO&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function places the record pointer&comma.if working with a .DBF file&comma.  in selected or aliased work area at the record number specified by  <xRecordNumber>.The position if not affected by an active index or  by any
enviromental SET condiction.
.br
:p.Issuing a DBGOTO&lpar.RECNO&lpar.&rpar.&rpar. call in a network enviroment will refresh  the database and index buffers.This is the same as a DBSKIP&lpar.0&rpar. call.  The parameter <xRecordNumber> may be something other than a
record  number.In some data formats&comma. for example&comma. the value of <xRecordNumber>  is a unique primary key while in other formats&comma.<xRecordNumber> could  be an array offset if the data set was an array.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
      The following example uses DBGOTO&lpar.&rpar. to iteratively process
.br
      every fourth record&colon.
.br

.br
      DBUSEAREA&lpar. .T.&comma. &cdq.DBFNTX&cdq.&comma. &cdq.Sales&cdq.&comma. &cdq.Sales&cdq.&comma. .T. &rpar.
.br
      &slash.&slash.
.br
      &slash.&slash. toggle every fourth record
.br
      DO WHILE !EOF&lpar.&rpar.
.br
         DBGOTO&lpar. RECNO&lpar.&rpar. + 4 &rpar.
.br
         Sales&minus.>Group &colon.&eq. &cdq.Bear&cdq.
.br
      ENDDO
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=227.BOF():elink.
.br
:link reftype=hd res=219.EOF():elink.
.br
:link reftype=hd res=229.DBGOTOP():elink.
.br
:link reftype=hd res=226.DBGOBOTTOM():elink.
.br
:link reftype=hd res=228.DBSEEK():elink.
.br
:link reftype=hd res=40.DBSKIP():elink.
.br
:h2 id=DATAY res=229.DBGOTOP()
:i2 refid=DATABX.DBGOTOP()
:p.DBGOTOP&lpar.&rpar.
.br
.br
:hp2.Moves the record pointer to the bottom of the database.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBGOTOP&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBGOTOP&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function moves the record pointer in the selected or aliased  work area to the top of the file.The position of the record pointer  is affected by the values in the index key or by an active FILTER
condition.Otherwise&comma.if no index is active or if no filter condition  is present&comma.the value of RECNO&lpar.&rpar. will be 1.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE Tests
.br
      DBGOTOP&lpar.&rpar.
.br
      ? RECNO&lpar.&rpar.
.br
      DBGOBOTTOM&lpar.&rpar.
.br
      ? RECNO&lpar.&rpar.
.br
      USE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=227.BOF():elink.
.br
:link reftype=hd res=219.EOF():elink.
.br
:link reftype=hd res=40.DBSKIP():elink.
.br
:link reftype=hd res=228.DBSEEK():elink.
.br
:link reftype=hd res=226.DBGOBOTTOM():elink.
.br
:h2 id=DATAY res=223.DBRECALL()
:i2 refid=DATABX.DBRECALL()
:p.DBRECALL&lpar.&rpar.
.br
.br
:hp2.Recalls a record previousy marked for deletion.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBRECALL&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBRECALL&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function unmarks those records marked for deletion nd reactivates  them in the aliased or selected work area.If a record is DELETED and  the DELETED setting is on&comma. the record will still be visible for a
DBRECALL&lpar.&rpar. provided that the database record pointer has not been  skipped.Once a record marked for deletion with the DELETE setting ON  has been skipped&comma. it no longer canbe brought back with DBRECALL&lpar.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE Test NEW
.br
      DBGOTO&lpar.10&rpar.
.br
      DBDELETE&lpar.&rpar.
.br
      ? DELETED&lpar.&rpar.
.br
      DBRECALL&lpar.&rpar.
.br
      ? DELETED&lpar.&rpar.
.br
      USE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=222.DBDELETE():elink.
.br
:h2 id=DATAY res=231.DBRLOCK()
:i2 refid=DATABX.DBRLOCK()
:p.DBRLOCK&lpar.&rpar.
.br
.br
:hp2.This function locks the record basedon identify:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBRLOCK&lpar.&lbrk.<xIdentity>&rbrk..&rpar. &minus.&minus.> lSuccess:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xIdentity> Record indetifier
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBRLOCK&lpar.&rpar. returns a logical true &lpar..T.&rpar. if lock was successful
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function attempts to lock a record which is indentified  by <xIdentity> in the active data set.If the lock is successful  the function will return a logical true &lpar..T.&rpar. value&semi.otherwise  a logical false
&lpar..F.&rpar. will be returned.If <xIdentity> is not  passed it will be assumed to lock the current active record&slash.data item.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
      LOCAL x&colon.&eq.0
.br
      USE Tests New
.br
      FOR x&colon.&eq.1 to reccount&lpar.&rpar.
.br
        IF !DBRLOCK&lpar.&rpar.
.br
          DBUNLOCK&lpar.&rpar.
.br
        ENDIF
.br
      NEXT
.br
      USE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=208.DBUNLOCK():elink.
.br
:link reftype=hd res=209.DBUNLOCKALL():elink.
.br
:link reftype=hd res=232.FLOCK():elink.
.br
:link reftype=hd res=233.RLOCK():elink.
.br
:h2 id=DATAY res=234.DBRLOCKLIST()
:i2 refid=DATABX.DBRLOCKLIST()
:p.DBRLOCKLIST&lpar.&rpar.
.br
.br
:hp2.This function return a list of records in the database work area:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBRLOCKLIST&lpar.&rpar. &minus.&minus.> aRecordLocks:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<aRecordList> is an array of lock records
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function will return an array of locked records in a given  and active work area.If the return array is an empty array  &lpar.meaning no elements in it&rpar.&comma.then there are no locked record in that  work area.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
      LOCAL aList&colon.&eq.&lbrc.&rbrc.
.br
      LOCAL x&colon.&eq.0
.br
      USE Tests NEW
.br
      DBGOTO&lpar.10&rpar.
.br
      RLOCK&lpar.&rpar.
.br
      DBGOTO&lpar.100&rpar.
.br
      RLOCK&lpar.&rpar.
.br
      aList&colon.&eq.DBRLOCKLIST&lpar.&rpar.
.br
      FOR x&colon.&eq.1 TO LEN&lpar.aList&rpar.
.br
         ? aList&lbrk.x&rbrk..
.br
      NEXT
.br
      USE
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=233.RLOCK():elink.
.br
:link reftype=hd res=231.DBRLOCK():elink.
.br
:link reftype=hd res=235.DBRUNLOCK():elink.
.br
:h2 id=DATAY res=235.DBRUNLOCK()
:i2 refid=DATABX.DBRUNLOCK()
:p.DBRUNLOCK&lpar.&rpar.
.br
.br
:hp2.Unlocks a record base on its indentifier:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBRUNLOCK&lpar.&lbrk.<xIdentity>&rbrk..&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xIdentity> Record indentifier&comma.tipicaly a record number
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBRUNLOCK&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function will attempt to unlock the record specified as  <xIdentity>&comma.which in a .DBF format is the record number.If not  specified&comma.them the current active record&slash.data item will be  unlocked
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
      USE Tests New
.br
      DBGOTO&lpar.10&rpar.
.br
      IF RLOCK&lpar.&rpar.
.br
         ? Tests&minus.>ID
.br
         DBRUNLOCK&lpar.&rpar.
.br
      ENDIF
.br
      USE
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=233.RLOCK():elink.
.br
:link reftype=hd res=231.DBRLOCK():elink.
.br
:link reftype=hd res=234.DBRLOCKLIST():elink.
.br
:h2 id=DATAY res=228.DBSEEK()
:i2 refid=DATABX.DBSEEK()
:p.DBSEEK&lpar.&rpar.
.br
.br
:hp2.Searches for a value based on an active index.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBSEEK&lpar.<expKey>&comma. &lbrk.<lSoftSeek>&rbrk..&comma.&lbrk.<lFindLast>&rbrk..&rpar. &minus.&minus.> lFound:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<expKey> Any expression
.br
:p.<lSoftSeek> Toggle SOFTSEEK condition
.br
:p.<lFindLast> is an optional logical value that set the current  record position to the last record if successful
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBSEEK&lpar.&rpar. returns logical true &lpar..T.&rpar. if found&comma. otherwise false
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function searches for the first record in a database file whose index  key matches <expKey>. If the item is found&comma. the function will return a logical  true &lpar..T.&rpar.&comma. the value of FOUND&lpar.&rpar. wilI be
a logical true &lpar..T.&rpar.&comma. and the value of  EOF&lpar.&rpar. wilI be a logical false &lpar..F.&rpar.. If no item is found. then the function will  return a logical false&comma. the value of FOUND&lpar. &rpar. will be a
logical false &lpar..F.&rpar.&comma. and  the value of EOF&lpar. &rpar. will be a logical true &lpar..T.&rpar..
.br
:p.This function always &cdq.rewinds&cdq. the database pointer and starts the search from  the top of the file.
.br
:p.If the SOFTSEEK flag is on or if <lSoftSeek> is set to a logical true &lpar..T.&rpar.  the value of FOUND&lpar.&rpar. wilI be a logical false and EOF&lpar.&rpar. will he a logical  false if there is an item in the index key with
a greater value than the key  expression <expKey>&semi. at this point the record pointer will position itself on that  record. However&comma. if there is no greater key in the index&comma.EOF&lpar.&rpar. will return a  logical
true &lpar..T.&rpar. value. If <lSoftSeek> is not passed&comma. the function will look  to the internal status of SOFTSEEK before performing the operation. The default  of <lSoftSeek> is a logical false &lpar..F.&rpar.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
      USE Tests New INDEX Tests
.br
      DBGOTO&lpar.10&rpar.
.br
      nId&colon.&eq.Tests&minus.>nId
.br
      IF Tests&minus.>&lpar.DBSEEK&lpar.nId&rpar.&rpar.
.br
        IF RLOCK&lpar.&rpar.
.br
           ? Tests&minus.>Name
.br
           DBRUNLOCK&lpar.&rpar.
.br
        ENDIF
.br
      ENDIF
.br
      USE
.br
      RETURN NIL
.br

.br
      ACCEPT &cdq.Employee name&colon. &cdq. TO cName
.br
      IF &lpar. Employee&minus.>&lpar.DBSEEK&lpar.cName&rpar.&rpar. &rpar.
.br
         Employee&minus.>&lpar.ViewRecord&lpar.&rpar.&rpar.
.br
      ELSE
.br
         ? &cdq.Not found&cdq.
.br
      END
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.DBSEEK&lpar.&rpar. is  Compatible with CA&minus.Clipper 5.3
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=226.DBGOBOTTOM():elink.
.br
:link reftype=hd res=229.DBGOTOP():elink.
.br
:link reftype=hd res=40.DBSKIP():elink.
.br
:link reftype=hd res=219.EOF():elink.
.br
:link reftype=hd res=227.BOF():elink.
.br
:link reftype=hd res=220.FOUND():elink.
.br
:h2 id=DATAY res=236.DBSELECTAREA()
:i2 refid=DATABX.DBSELECTAREA()
:p.DBSELECTAREA&lpar.&rpar.
.br
.br
:hp2.Change to another work area:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBSELECTAREA&lpar.<xArea>&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xArea> Alias or work area
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBSELECTAREA&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function moves the Harbour internal primary focus to the work  area designated by <xArea>. If <xArea> is numeric&comma. them it will  select the numeric work area&semi.if <xArea> is character&comma.then it will  select the
work area with the alias name.
.br
:p.DBSELECTAREA&lpar.0&rpar. will select the next avaliable and unused work area.  Up to 255 work areas are supported.Each work area has its own alias  and record pointer&comma. as well as its own
FOUND&lpar.&rpar.&comma.DBFILTER&lpar.&rpar.&comma.DBRSELECT&lpar.&rpar.&comma.  and DBRELATION&lpar.&rpar. function values.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
      LOCAL nId
.br
      USE Tests NEW INDEX Tests
.br
      USE Tests1 NEW INDEX Tests1
.br
      DBSELECTAREA&lpar.1&rpar.
.br
      nId&colon.&eq.Tests&minus.>Id
.br
      DBSELECTAREA&lpar.2&rpar.
.br
      IF DBSEEK&lpar.nId&rpar.
.br
         ? Tests1&minus.>cName
.br
      ENDIF
.br
      DBCLOSEALL&lpar.&rpar.
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.CLIPPER compatible.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=214.DBUSEAREA():elink.
.br
:link reftype=hd res=237.SELECT():elink.
.br
:h2 id=DATAY res=203.DBSETDRIVER()
:i2 refid=DATABX.DBSETDRIVER()
:p.DBSETDRIVER&lpar.&rpar.
.br
.br
:hp2.Establishes the name of replaceable daabas driver for a selected work area:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBSETDRIVER&lpar.&lbrk.<cDriver>&rbrk..&rpar. &minus.&minus.> cCurrentDriver:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cDriver> Optional database driver name
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBSETDRIVER&lpar.&rpar. returns the name of active driver
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the name of the current database driver for the  selected work area. The default will be &cdq.DBFNTX&cdq.. If specified&comma.<cDriver>  contains the name of the database driver that should be used to
activate  and manage the work area.If the specified driver is not avaliable&comma.this  function will have no effect.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      DBSETDRIVER&lpar.&cdq.ADS&cdq.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compatible
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=214.DBUSEAREA():elink.
.br
:h2 id=DATAY res=40.DBSKIP()
:i2 refid=DATABX.DBSKIP()
:p.DBSKIP&lpar.&rpar.
.br
.br
:hp2.Moves the record pointer in the selected work area.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBSKIP&lpar.&lbrk.<nRecords>&rbrk..&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nRecords> Numbers of records to move record pointer.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBSKIP&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function moves the record pointer <nRecords> in the selected or  aliased work area.The default value for <nRecords> will be 1.  A DBSKIP&lpar.0&rpar. will flush and refresh the internal database bufer and make  any changes
made to the record visible without moving the record pointer  in either direction.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
      USE Tests NEW
.br
      DBGOTOP&lpar.&rpar.
.br
      WHILE !EOF&lpar.&rpar.
.br
        ? Tests&minus.>Id&comma.Tests&minus.>Name
.br
        DBSKIP&lpar.&rpar.
.br
      ENDDO
.br
      USE
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.CLIPPER compatible
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=227.BOF():elink.
.br
:link reftype=hd res=226.DBGOBOTTOM():elink.
.br
:link reftype=hd res=229.DBGOTOP():elink.
.br
:link reftype=hd res=228.DBSEEK():elink.
.br
:link reftype=hd res=219.EOF():elink.
.br
:h2 id=DATAY res=211.DBSETFILTER()
:i2 refid=DATABX.DBSETFILTER()
:p.DBSETFILTER&lpar.&rpar.
.br
.br
:hp2.Establishes a filter condition for a work area.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBSETFILTER&lpar.<bCondition>&comma. &lbrk.<cCondition>&rbrk..&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<bCondition> Code block expression for filtered evaluation.
.br
:p.<cCondition> Optional character expression of code block.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBSETFILTER&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function masks a database so that only those records that meet the  condition prescribed by the expression in the code block <bCondition>  and literally expressed as <cCondition> are visible.  If <cCondition> is not passed
to this function&comma.then the DBFILTER&lpar.&rpar.  function will return an empty string showing no filter in that work area  which in fact&comma.would be not correct.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
      USE Tests NEW
.br
      DBSETFILTER&lpar.&lbrc.&splitvbar.&splitvbar. Tests&minus.>Id <100&rbrc.&comma.&cdq.Tests&minus.>Id <100&cdq.&rpar.
.br
      DBGOTOP&lpar.&rpar.
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=212.DBFILTER():elink.
.br
:link reftype=hd res=210.DBCLEARFILTER():elink.
.br
:h2 id=DATAY res=11.DBSTRUCT()
:i2 refid=DATABX.DBSTRUCT()
:p.DBSTRUCT&lpar.&rpar.
.br
.br
:hp2.Creates a multidimensional array of a database structure.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBSTRUCT&lpar.&rpar. &minus.&minus.> aStruct:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBSTRUCT&lpar.&rpar. returns an array pointer to database structure
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a multidimensional array.This array has array  pointers to other arrays&comma.each of which contains the characteristic  of a field in the active work area.The lenght of this array is based  in the number of
fields in that particular work area.In other words&comma.  LEN&lpar.DBSTRUCT&lpar.&rpar.&rpar. is equal to the value obtained from FCOUNT&lpar.&rpar..  Each subscript position
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
      LOCAL aStru&comma.x
.br
      USE Tests NEW
.br
      aStru&colon.&eq.DBSTRUCT&lpar.&rpar.
.br
      FOR x&colon.&eq.1 TO LEN&lpar.aStru&rpar.
.br
        ? aStru&lbrk.x&comma.1&rbrk..
.br
      NEXT
.br
      USE
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd  Header is  DbStruct.ch
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=221.AFIELDS():elink.
.br
:h2 id=DATAY res=208.DBUNLOCK()
:i2 refid=DATABX.DBUNLOCK()
:p.DBUNLOCK&lpar.&rpar.
.br
.br
:hp2.Unlock a record or release a file lock:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBUNLOCK&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBUNLOCK&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function releases the file or record lock in the currently selected  or aliased work area.It will not unlock an associated lock in a related data&minus.  bases.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      nId&colon.&eq.10
.br
      USE TestId INDEX TestId NEW
.br
      IF TestId&minus.>&lpar.DBSEEK&lpar.nId&rpar.&rpar.
.br
         IF TestId&minus.>&lpar.RLOCK&lpar.&rpar.&rpar.
.br
            DBDELETE&lpar.&rpar.
.br
         ELSE
.br
             DBUNLOCK&lpar.&rpar.
.br
         ENDIF
.br
      ENDIF
.br
      USE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compatible.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=209.DBUNLOCKALL():elink.
.br
:link reftype=hd res=232.FLOCK():elink.
.br
:link reftype=hd res=233.RLOCK():elink.
.br
:h2 id=DATAY res=209.DBUNLOCKALL()
:i2 refid=DATABX.DBUNLOCKALL()
:p.DBUNLOCKALL&lpar.&rpar.
.br
.br
:hp2.Unlocks all records and releases all file locks in all work areas.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBUNLOCKALL&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBUNLOCKALL&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function will remove all file and record locks in all work area.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      nId&colon.&eq.10
.br
      USE Tests INDEX TestId NEW
.br
      USE Tests1 INDEX Tests NEW
.br
      IF TestId&minus.>&lpar.DBSEEK&lpar.nId&rpar.&rpar.
.br
         IF TestId&minus.>&lpar.RLOCK&lpar.&rpar.&rpar.
.br
            DBDELETE&lpar.&rpar.
.br
         ELSE
.br
            DBUNLOCK&lpar.&rpar.
.br
         ENDIF
.br
      ELSE
.br
         DBUNLOCKALL&lpar.&rpar.
.br
      ENDIF
.br
      USE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=208.DBUNLOCK():elink.
.br
:link reftype=hd res=232.FLOCK():elink.
.br
:link reftype=hd res=233.RLOCK():elink.
.br
:h2 id=DATAY res=214.DBUSEAREA()
:i2 refid=DATABX.DBUSEAREA()
:p.DBUSEAREA&lpar.&rpar.
.br
.br
:hp2.Opens a work area and uses a database file.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DBUSEAREA&lpar. &lbrk.<lNewArea>&rbrk..&comma. &lbrk.<cDriver>&rbrk..&comma. <cName>&comma. &lbrk.<xcAlias>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<lShared>&rbrk..&comma. &lbrk.<lReadonly>&rbrk..&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<lNewArea>  A optional logical expression for the new work area
.br
:p.<cDriver>   Database driver name
.br
:p.<cName>     File Name
.br
:p.<xcAlias>   Alias name
.br
:p.<lShared>   Shared&slash.exclusive status flag
.br
:p.<lReadonly> Read&minus.write status flag.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DBUSEAREA&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function opens an existing database named <cName> in the current  work area. If <lNewArea> is set to a logical true &lpar..T.&rpar. value&comma. then  the database <cName> will be opened in the next available and unused
work area. The default value of <lNewArea> is a logical false &lpar..F.&rpar..  If used&comma. <cDriver> is the name of the database driver associated with  the file <cName> that is opened. The default for this will be the value
of DBSETDRlVER&lpar.&rpar..
.br
:p.IF used&comma. <xcAlias> contains the alias name for that work area&comma. If not  specified&comma. the root name of the database specified in <cName> will be  used.
.br
:p.If <lShared> is set to a logical true &lpar..T.&rpar. value&comma. the database that  is specified in <cName> will be opened by the user EXCLUSIVELY. Thus  locking it from all other nodes or users on the network. If <lShared> is
set to a logical false &lpar..F.&rpar. value&comma. then the database will be in SHARED  mode. If <lShared> is not passed&comma. then the function will turn to the  internal setting of SET EXCLUSIVE to determine a setting.
.br
:p.If <lReadOnly> is specified&comma. the file will be set to READ ONLY mode.  If it is not specified&comma. the file will he opened in normal read&minus.write  mode.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      DBUSEAREA&lpar..T.&comma.&comma.&cdq.Tests&cdq.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=215.DBCLOSEAREA():elink.
.br
:link reftype=hd res=203.DBSETDRIVER():elink.
.br
:link reftype=hd res=237.SELECT():elink.
.br
:link reftype=hd res=100.SET():elink.
.br
:h2 id=DATAY res=238.__DBZAP()
:i2 refid=DATABX.__DBZAP()
:p.&us.&us.DBZAP&lpar.&rpar.
.br
.br
:hp2.Remove all records from the current database file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.DbZap&lpar.&rpar.  &minus.> NIL:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.DbZap&lpar.&rpar.   will always return nil
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.DbZap&lpar. is a database command that permanently removes all records from  files open in the current work area.  This includes the current database  file&comma. index files&comma. and associated memo file.  Disk space
previously  occupied by the ZAPped files is released to the operating system.  &us.&us.DbZap&lpar.&rpar. performs the same operation as DELETE ALL followed by PACK but is  almost  instantaneous.
.br
:p.To ZAP in a network environment&comma. the current database file must be USEd  EXCLUSIVEly.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      This example demonstrates a typical ZAP operation in a network
.br
      environment&colon.
.br

.br
      USE Sales EXCLUSIVE NEW
.br
      IF !NETERR&lpar.&rpar.
.br
         SET INDEX TO Sales&comma. Branch&comma. Salesman
.br
         &us.&us.dbZAP&lpar.&rpar.
.br
         CLOSE Sales
.br
      ELSE
.br
         ? &cdq.Zap operation failed&cdq.
.br
         BREAK
.br
      ENDIF
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
:h2 id=DATAY res=239.ORDBAGEXT()
:i2 refid=DATABX.ORDBAGEXT()
:p.ORDBAGEXT&lpar.&rpar.
.br
.br
:hp2.Returns the Order Bag extension:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ORDBAGEXT&lpar.&rpar. &minus.&minus.> cBagExt:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cBagExt> The Rdd extension name.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function return th character name of the RDD extension for  the order bag.This is determined by the active RDD for the selected  work area.
.br
:p.This function replaces the Indexord&lpar.&rpar. function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE Tests NEW VIA &cdq.DBFNTX&cdq.
.br
      ? ORDBAGEXT&lpar.&rpar.      &slash.&slash.  Returns .ntx
.br
      DBCLOSEAREA&lpar.&rpar.
.br
      USE Tests NEW VIA &cdq.DBFCDX&cdq.
.br
      ? ORDBAGEXT&lpar.&rpar.      &slash.&slash.  Returns .cdx
.br
      DBCLOSEAREA&lpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=240.INDEXEXT():elink.
.br
:link reftype=hd res=241.ORDBAGNAME():elink.
.br
:h2 id=DATAY res=241.ORDBAGNAME()
:i2 refid=DATABX.ORDBAGNAME()
:p.ORDBAGNAME&lpar.&rpar.
.br
.br
:hp2.Returns the Order Bag Name.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ORDBAGNAME&lpar.<nOrder> &splitvbar. <cOrderName>&rpar. &minus.&minus.> cOrderBagName:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nOrder> A numeric value representing the Order bag number.
.br
:p.<cOrderName> The character name of the Order Bag.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.ORDBAGNAME&lpar.&rpar. returns the Order bag name
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the name of the order bag for the specified  work area. If <nOrder> is specidied&comma.it will represent the position  in the order list of the target order.If <cOrderName> is specified&comma.  it will
represent the name of the target order.In essence&comma.it will  tell the name of the database &lpar.if That Rddis in use&rpar. for a given  index name or index order number.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE Tests VIA &cdq.DBFCDX&cdq. NEW
.br
      Set index to TESTs
.br
      ORDBAGNAME&lpar. &cdq.TeName&cdq. &rpar.        &slash.&slash. Returns&colon. Customer
.br
      ORDBAGNAME&lpar. &cdq.TeLast&cdq. &rpar.        &slash.&slash. Returns&colon. Customer
.br
      ORDBAGNAME&lpar. &cdq.teZip&cdq. &rpar.         &slash.&slash. Returns&colon. Customer
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See Examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=242.INDEXORD():elink.
.br
:link reftype=hd res=239.ORDBAGEXT():elink.
.br
:link reftype=hd res=206.ALIAS():elink.
.br
:h2 id=DATAY res=243.ORDCONDSET()
:i2 refid=DATABX.ORDCONDSET()
:p.ORDCONDSET&lpar.&rpar.
.br
.br
:hp2.Set the Condition and scope for an order:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ORDCONSET&lpar.&lbrk.<cForCondition>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<bForCondition>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<lAll>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<bWhileCondition>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<bEval>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<nInterval>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<nStart>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<nNext>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<nRecord>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<lRest>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<lDescend>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<lAdditive>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<lCurrent>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<lCustom>&rbrk..&comma.:ehp2.
:p.:hp2.&lbrk.<lNoOptimize>&rbrk..&rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cForCondition> is a string that specifies the FOR condition for the  order.  <bForCondition> is a code block that defines a FOR condition that  each record within the scope must meet in order to be processed. If  a record does
not meet the specified condition&comma.it is ignored and the  next  record is processed.Duplicate keys values are not added to the  index file when a FOR condition is Used.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.ORDCONDSET&lpar.&rpar. is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
:h2 id=DATAY res=244.ORDCREATE()
:i2 refid=DATABX.ORDCREATE()
:p.ORDCREATE&lpar.&rpar.
.br
.br
:hp2.Create an Order in an Order Bag:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ORDCREATE&lpar.<cOrderBagName>&comma.&lbrk.<cOrderName>&rbrk..&comma. <cExpKey>&comma.:ehp2.
:p.:hp2.&lbrk.<bExpKey>&rbrk..&comma. &lbrk.<lUnique>&rbrk..&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cOrderBagName>  Name of the file that contains one or more Orders.
.br
:p.<cOrderName> Name of the order to be created.
.br
:p.<cExpKey> Key value for order for each record in the current work area
.br
:p.<bExpKey> Code block that evaluates to a key for the order for each  record in the work area.
.br
:p.<lUnique> Toggle the unique status of the index.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.ORDCREATE&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function creates an order for the current work area.It is  similar to the DBCREATEINDEX&lpar.&rpar. except that this function allows  different orders based on the RDD in effect.The name of the file  <cOrderBagName> or the
name of the order <cOrderName> are technically  both considered to be &cdq.optional&cdq. except that at least one of two  must exist in order to create the order.
.br
:p.The parameter <cExpKey> is the index key expression&semi.typically in  a .DBF driver&comma.the maximum length of the key is 255 characters.
.br
:p.If <bExpKey> is not specified&comma.then the code block is create by  macro expanding the value of <cExpKey>.
.br
:p.If <lUnique> is not specified&comma.then the current internal setting of  SET UNIQUE ON or OFF will be observed.
.br
:p.The active RDD driver determines the capacity in the order for a  specific order bag.
.br
:p.If the name <cOrderBagName> is found in the order bag can contain  a single order&comma.the the name <cOrderBagName> is erased and a new  order is added to the order list in the current or specified work  area.On the other
hand&comma.if it can contain multiples tags and if  <cOrderBagName> does not already exist in the order list&comma.then it is  added.It is does exist&comma.then the <cOrderBagName> replaces the former  name in the order list in
the current or specified work area.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE TESTS VIA &cdq.DBFNDX&cdq. NEW
.br
      ORDCREATE&lpar. &cdq.FNAME&cdq.&comma.&comma. &cdq.Tests&minus.>fName&cdq. &rpar.
.br

.br
      USE TEsts VIA &cdq.DBFCDX&cdq. NEW
.br
      ORDCREATE&lpar. &comma. &cdq.lName&cdq.&comma. &cdq.tests&minus.>lName&cdq. &rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=245.DBCREATEINDEX():elink.
.br
:link reftype=hd res=246.ORDNAME():elink.
.br
:link reftype=hd res=247.ORDSETFOCUS():elink.
.br
:h2 id=DATAY res=248.ORDDESTROY()
:i2 refid=DATABX.ORDDESTROY()
:p.ORDDESTROY&lpar.&rpar.
.br
.br
:hp2.Remove an Order from an Order Bag:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ORDDESTROY&lpar.<cOrderName> &lbrk.&comma. <cOrderBagName> &rbrk..&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cOrderName> Name of the order to remove
.br
:p.<cOrderBagName> Name of the order bag from which order id to be  removed
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.ORDDESTROY&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function attempts to remove the order named <cOrderName> from the  file containing the order bag name <cOrderBagName>. If <cOrderBagName>  is not specified&comma.then the name of the file will be based on the value  of the
ORDNAME&lpar.&rpar. function.If the extension is not included with the  name of the order file&comma.then the extension will be obtained from the  default extension of the current and active RDD.
.br
:p.The DBFNTX driver do not support multiple order bags&semi.therefore&comma.there  cannot be an order to &cdq.destroy&cdq. from a bag.This function only works  for those drivers with support multiple orders bags &lpar.e.q. DBFCDX
and RDDADS drivers&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE TEsts VIA &cdq.DBFCDX&cdq. NEW
.br
      ORDdestroy&lpar. &cdq.lName&cdq.&comma. &cdq.tests&cdq. &rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=244.ORDCREATE():elink.
.br
:h2 id=DATAY res=249.ORDFOR()
:i2 refid=DATABX.ORDFOR()
:p.ORDFOR&lpar.&rpar.
.br
.br
:hp2.Return the FOR expression of an Order:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ORDFOR&lpar.<cOrderName> &splitvbar. <nOrder>&lbrk.&comma. <cOrderBagName>&rbrk..&rpar. &minus.&minus.> cForExp:ehp2.
.br
:p.<cOrderName> is the name of the target Order&comma. whose cForExp is  sought.
.br
:p.<nOrder> is an integer that identifies the position in the Order  List of the target Order whose cForExp is sought.
.br
:p.<cOrderBagName> is the name of an Order Bag containing one or more  Orders.  You may specify <cOrderBagName> as the filename with or without  the pathname or appropriate extension.  If you do not include the  extension as part of
<cOrderBagName> HARBOUR uses the default  extension of the current RDD.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.ORDFOR&lpar.&rpar. returns a expression containing the FOR condition for  an order
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.ORDFOR&lpar.&rpar. is an Order management function that returns the character  string&comma. cForExp&comma. that represents the logical FOR condition of the Order&comma.  <cOrderName> or <nOrder>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE Tests NEW
.br
      INDEX ON  Tests&minus.>Id &semi.
.br
         TO  TESTS          &semi.
.br
         FOR Tests&minus.>Id > 100
.br

.br
      ORDFOR&lpar. &cdq.Tests&cdq. &rpar.      &slash.&slash. Returns&colon. Tests&minus.>Id > 100
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=250.ORDKEY():elink.
.br
:link reftype=hd res=244.ORDCREATE():elink.
.br
:link reftype=hd res=246.ORDNAME():elink.
.br
:link reftype=hd res=251.ORDNUMBER():elink.
.br
:h2 id=DATAY res=250.ORDKEY()
:i2 refid=DATABX.ORDKEY()
:p.ORDKEY&lpar.&rpar.
.br
.br
:hp2.Return the key expression of an Order:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ORDKEY&lpar.<cOrderName> &splitvbar. <nOrder>:ehp2.
:p.:hp2.&lbrk.&comma. <cOrderBagName>&rbrk..&rpar. &minus.&minus.> cExpKey:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cOrderName> is the name of an Order&comma. a logical ordering of a  database.
.br
:p.<nOrder> is an integer that identifies the position in the Order  List of the target Order whose cExpKey is sought.
.br
:p.<cOrderBagName> is the name of a disk file containing one or more  Orders.  You may specify <cOrderBagName> as the filename with or without  the pathname or appropriate extension.  If you do not include the  extension as part of
<cOrderBagName> HARBOUR uses the default  extension of the current RDD.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Returns a character string&comma. cExpKey.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.ORDKEY&lpar.&rpar. is an Order management function that returns a character  expression&comma. cExpKey&comma. that represents the key expression of the specified  Order.
.br
:p.You may specify the Order by name or with a number that represents its  position in the Order List.  Using the Order name is the preferred  method.
.br
:p.The active RDD determines the Order capacity of an Order Bag.  The  default DBFNTX and the DBFNDX drivers only support single&minus.Order Bags&comma.  while other RDDs may support multiple&minus.Order Bags &lpar.e.g.&comma. the
DBFCDX and  DBFMDX drivers&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
     This example retrieves the index expression from an Order&colon.
.br

.br
      USE Customer NEW
.br
      INDEX ON  Customer&minus.>Acct  &semi.
.br
         TO  Customer           &semi.
.br
         FOR Customer&minus.>Acct > &cdq.AZZZZZ&cdq.
.br

.br
      ORDKEY&lpar. &cdq.Customer&cdq. &rpar.      &slash.&slash. Returns&colon. Customer&minus.>Acct
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=249.ORDFOR():elink.
.br
:link reftype=hd res=246.ORDNAME():elink.
.br
:link reftype=hd res=251.ORDNUMBER():elink.
.br
:h2 id=DATAY res=252.ORDLISTADD()
:i2 refid=DATABX.ORDLISTADD()
:p.ORDLISTADD&lpar.&rpar.
.br
.br
:hp2.Add Orders to the Order List:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ORDLISTADD&lpar.<cOrderBagName>:ehp2.
:p.:hp2.&lbrk.&comma. <cOrderName>&rbrk..&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cOrderBagName> is the name of a disk file containing one or more  Orders.  You may specify <cOrderBagName> as the filename with or without  the pathname or appropriate extension.  If you do not include the  extension as part of
<cOrderBagName> HARBOUR uses the default  extension of the current RDD.
.br
:p.<cOrderName> the name of the specific Order from the Order Bag to be  added to the Order List of the current work area.  If you do not specify  <cOrderName>&comma. all orders in the Order Bag are added to the Order List of  the
current work area.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.ORDLISTADD&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.ORDLISTADD&lpar.&rpar. is an Order management function that adds the contents of  an Order Bag &comma. or a single Order in an Order Bag&comma. to the Order List.  This function lets you extend the Order List without issuing a
SET INDEX  command that&comma. first&comma. clears all the active Orders from the Order List.
.br
:p.Any Orders already associated with the work area continue to be active.  If the newly opened Order Bag contains the only Order associated with  the work area&comma. it becomes the controlling Order&semi. otherwise&comma. the
controlling Order remains unchanged.
.br
:p.After the new Orders are opened&comma. the work area is positioned to the  first logical record in the controlling Order.
.br
:p.ORDLISTADD&lpar.&rpar. is similar to the SET INDEX command or the INDEX clause of  the USE command&comma. except that it does not clear the Order List prior to  adding the new order&lpar.s&rpar..
.br
:p.ORDLISTADD&lpar.&rpar. supersedes the DBSETINDEX&lpar.&rpar. function.
.br
:p.The active RDD determines the Order capacity of an Order Bag.  The  default  DBFNTX and the DBFNDX drivers only support single&minus.Order Bags&comma.  while other RDDs may support multiple&minus.Order Bags &lpar.e.g.&comma. the
DBFCDX and  DBPX drivers&rpar..  When using RDDs that support multiple Order Bags&comma. you  must explicitly SET ORDER &lpar.or ORDSETFOCUS&lpar.&rpar.&rpar. to the desired controlling  Order.  If you do not specify a contr
olling Order&comma. the data file will be  viewed in natural Order.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
     In this example Customer.cdx contains three orders&comma. CuAcct&comma.
.br
      CuName&comma. and CuZip.  ORDLISTADD&lpar.&rpar. opens Customer.cdx but only uses the
.br
      order named CuAcct&colon.
.br

.br
      USE Customer VIA &cdq.DBFCDX&cdq. NEW
.br
      ORDLISTADD&lpar. &cdq.Customer&cdq.&comma. &cdq.CuAcct&cdq. &rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=253.DBSETINDEX():elink.
.br
:h2 id=DATAY res=254.ORDLISTCLEAR()
:i2 refid=DATABX.ORDLISTCLEAR()
:p.ORDLISTCLEAR&lpar.&rpar.
.br
.br
:hp2.Clear the current Order List:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ORDLISTCLEAR&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.ORDLISTCLEAR&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.ORDLISTCLEAR&lpar.&rpar. is an Order management function that removes all Orders  from the Order List for the current or aliased work area.  When you are  done&comma. the Order List is empty.
.br
:p.This function supersedes the function DBCLEARINDEX&lpar.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
   USE Sales NEW
.br
   SET INDEX TO SaRegion&comma. SaRep&comma. SaCode
.br
   .
.br
   . < statements >
.br
   .
.br
   ORDLISTCLEAR&lpar.&rpar.      &slash.&slash. Closes all the current indexes
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=255.DBCLEARINDEX():elink.
.br
:h2 id=DATAY res=256.ORDLISTREBUILD()
:i2 refid=DATABX.ORDLISTREBUILD()
:p.ORDLISTREBUILD&lpar.&rpar.
.br
.br
:hp2.Rebuild all Orders in the Order List of the current work area:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ORDLISTREBUILD&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.ORDLISTREBUILD&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.ORDLISTREBUILD&lpar.&rpar. is an Order management function that rebuilds all the  orders in the current or aliased Order List.
.br
:p.To only rebuild a single Order use the function ORDCREATE&lpar.&rpar..
.br
:p.Unlike ORDCREATE&lpar.&rpar.&comma. this function rebuilds all Orders in the Order List.  It is equivalent to REINDEX.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
   USE Customer NEW
.br
   SET INDEX TO CuAcct&comma. CuName&comma. CuZip
.br
   ORDLISTREBUILD&lpar.&rpar.     &slash.&slash. Causes CuAcct&comma. CuName&comma. CuZip to
.br
                        &slash.&slash. be rebuilt
.br

.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=244.ORDCREATE():elink.
.br
:h2 id=DATAY res=246.ORDNAME()
:i2 refid=DATABX.ORDNAME()
:p.ORDNAME&lpar.&rpar.
.br
.br
:hp2.Return the name of an Order in the Order List:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ORDNAME&lpar.<nOrder>&lbrk.&comma.<cOrderBagName>&rbrk..&rpar.:ehp2.
:p.:hp2.&minus.&minus.> cOrderName:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nOrder> is an integer that identifies the position in the Order  List of the target Order whose database name is sought.
.br
:p.<cOrderBagName> is the name of a disk file containing one or more  Orders.  You may specify <cOrderBagName> as the filename with or without  the pathname or appropriate extension.  If you do not include the  extension as part of
<xcOrderBagName> HARBOUR uses the default  extension of the current RDD.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.ORDNAME&lpar.&rpar. returns the name of the specified Order in the current Order  List or the specified Order Bag if opened in the Current Order list.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.ORDNAME&lpar.&rpar. is an Order management function that returns the name of the  specified Order in the current Order List.
.br
:p.If <cOrderBagName> is an Order Bag that has been emptied into the  current Order List&comma. only those Orders in the Order List that correspond  to <cOrderBagName> Order Bag are searched.
.br
:p.The active RDD determines the Order capacity of an Order Bag.  The  default DBFNTX and the DBFNDX drivers only support single&minus.Order Bags&comma.  while other RDDs may support multiple&minus.Order Bags &lpar.e.g.&comma. the
DBFCDX and  DBPX drivers&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
     This example retrieves the name of an Order using its position
.br
      in the order list&colon.
.br

.br
      USE Customer NEW
.br
      SET INDEX TO CuAcct&comma. CuName&comma. CuZip
.br
      ORDNAME&lpar. 2 &rpar.                        &slash.&slash. Returns&colon. CuName
.br

.br
     This example retrieves the name of an Order given its position
.br
      within a specific Order Bag in the Order List&colon.
.br

.br
      USE Customer NEW
.br
      SET INDEX TO Temp&comma. Customer
.br
      &slash.&slash. Assume Customer contains CuAcct&comma. CuName&comma. CuZip
.br
      ORDNAME&lpar. 2&comma. &cdq.Customer&cdq. &rpar.            &slash.&slash. Returns&colon. CuName
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=249.ORDFOR():elink.
.br
:link reftype=hd res=250.ORDKEY():elink.
.br
:link reftype=hd res=251.ORDNUMBER():elink.
.br
:h2 id=DATAY res=251.ORDNUMBER()
:i2 refid=DATABX.ORDNUMBER()
:p.ORDNUMBER&lpar.&rpar.
.br
.br
:hp2.Return the position of an Order in the current Order List:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ORDNUMBER&lpar.<cOrderName>:ehp2.
:p.:hp2.&lbrk.&comma. <cOrderBagName>&rbrk..&rpar. &minus.&minus.> nOrderNo:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cOrderName> the name of the specific Order whose position in the  Order List is sought.
.br
:p.<cOrderBagName> is the name of a disk file containing one or more  Orders.  You may specify <cOrderBagName> as the filename with or without  the pathname or appropriate extension.  If you do not include the  extension as part of
<cOrderBagName> HARBOUR uses the default  extension of the current RDD.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Returns nOrderNo&comma. an integer that represents the position of the  specified Order in the Order List.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.ORDNUMBER&lpar.&rpar. is an Order management function that lets you determine the  position in the current Order List of the specified Order.  ORDNUMBER&lpar.&rpar.  searches the Order List in the current work area and returns
the  position of the first Order that matches <cOrderName>.    If  <cOrderBagName> is the name of an Order Bag newly emptied into the  current Order List&comma. only those orders in the Order List that have been  emptied from
<cOrderBagName> are searched.
.br
:p.If <cOrderName> is not found ORDNUMBER&lpar.&rpar. raises a recoverable runtime  error.
.br
:p.The active RDD determines the Order capacity of an Order Bag.  The  default DBFNTX driver only supports single&minus.Order Bags&comma. while other RDDs  may support multiple&minus.Order Bags &lpar.e.g.&comma. the DBFCDX and DBPX
drivers&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
   USE Customer VIA &cdq.DBFNTX&cdq. NEW
.br
   SET INDEX TO CuAcct&comma. CuName&comma. CuZip
.br
   ORDNUMBER&lpar. &cdq.CuName&cdq. &rpar.            &slash.&slash. Returns&colon. 2
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=242.INDEXORD():elink.
.br
:h2 id=DATAY res=247.ORDSETFOCUS()
:i2 refid=DATABX.ORDSETFOCUS()
:p.ORDSETFOCUS&lpar.&rpar.
.br
.br
:hp2.Set focus to an Order in an Order List:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ORDSETFOCUS&lpar.&lbrk.<cOrderName> &splitvbar. <nOrder>&rbrk..:ehp2.
:p.:hp2.&lbrk.&comma.<cOrderBagName>&rbrk..&rpar. &minus.&minus.> cPrevOrderNameInFocus:ehp2.
.br
:p.<cOrderName> is the name of the selected Order&comma. a logical ordering  of a database.  ORDSETFOCUS&lpar.&rpar. ignores any invalid values of  <cOrderName>.
.br
:p.<nOrder> is a number representing the position in the Order List of  the selected Order.
.br
:p.<cOrderBagName> is the name of a disk file containing one or more  Orders.  You may specify <cOrderBagName> as the filename with or without  the pathname or appropriate extension.  If you do not include the  extension as part of
<cOrderBagName> HARBOUR uses the default  extension of the current RDD.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.ORDSETFOCUS&lpar.&rpar. returns the Order Name of the previous controlling Order.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.ORDSETFOCUS&lpar.&rpar. is an Order management function that returns the Order  Name of the previous controlling Order and optionally sets the focus to  an new Order.
.br
:p.If you do not specify <cOrderName> or <nOrder>&comma. the name of the  currently controlling order is returned and the controlling order  remains unchanged.
.br
:p.All Orders in an Order List are properly updated no matter what  <cOrderName> is the controlling Order.  After a change of controlling  Orders&comma. the record pointer still points to the same record.
.br
:p.The active RDD determines the Order capacity of an Order Bag.  The  default DBFNTX driver only supports single&minus.Order Bags&comma. while other RDDs  may support multiple&minus.Order Bags &lpar.e.g.&comma. the DBFCDX and DBPX
drivers&rpar..
.br
:p.ORDSETFOCUS&lpar.&rpar. supersedes INDEXORD&lpar.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
   USE Customer VIA &cdq.DBFNTX&cdq. NEW
.br
   SET INDEX TO CuAcct&comma. CuName&comma. CuZip
.br
   ? ORDSETFOCUS&lpar. &cdq.CuName&cdq. &rpar.        &slash.&slash. Displays&colon. &cdq.CuAcct&cdq.
.br
   ? ORDSETFOCUS&lpar.&rpar.                  &slash.&slash. Displays&colon. &cdq.CuName&cdq.
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
:h2 id=DATAY res=240.INDEXEXT()
:i2 refid=DATABX.INDEXEXT()
:p.INDEXEXT&lpar.&rpar.
.br
.br
:hp2.Returns the file extension of the index module used in an application:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.INDEXEXT&lpar.&rpar. &minus.&minus.> <cExtension>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cExtension>   Current driver file extension
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a string that tells what indexes are to be used  or will be created in the compiled application.The default value is  &cdq..NTX&cdq.. This is controled by the particular database driver that is  linked with
the application&comma..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      IF INDEXEXT&lpar.&rpar.&eq.&eq.&cdq..NTX&cdq.
.br
          ? &cdq.Current driver being used is DBFNTX&cdq.
.br
      Endif
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=257.INDEXKEY():elink.
.br
:link reftype=hd res=242.INDEXORD():elink.
.br
:h2 id=DATAY res=257.INDEXKEY()
:i2 refid=DATABX.INDEXKEY()
:p.INDEXKEY&lpar.&rpar.
.br
.br
:hp2.Yields the key expression of a specified index file.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.INDEXKEY&lpar.<nOrder>&rpar. &minus.&minus.> <cIndexKey>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nOrder>  Index order number
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cIndexKey>   The index key
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a character string stored in the header of the  index file
.br
:p.The index key is displayed for an index file that is designated by  <nOrder>&comma.its position in the USE...INDEX or SET INDEX TO command in  the currently selected or designated work area.If there is no  corresnponding index
key at the specified order position&comma.a NULL  byte will be returned.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE TESTS NEW INDEX TEST1
.br
      ? INDEXKEY&lpar.1&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=242.INDEXORD():elink.
.br
:h2 id=DATAY res=242.INDEXORD()
:i2 refid=DATABX.INDEXORD()
:p.INDEXORD&lpar.&rpar.
.br
.br
:hp2.Returns the numeric position of the controlling index.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.INDEXORD&lpar.&rpar. &minus.&minus.> <nPosition>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nPosition>   Ordinal position of a controling index
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The INDEXORD&lpar.&rpar. function returns the numeric position of the current  controlling index in the selected or designated work area.  A returned value of 0 indicated that no active index is controlling  the
database&comma.which therefore is in the natural order.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE TESTS NEW INDEX TEST1
.br
      IF INDEXORD&lpar.&rpar.>0
.br
          ? &cdq.Current order is &cdq.&comma.INDEXORD&lpar.&rpar.
.br
      Endif
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=257.INDEXKEY():elink.
.br
:h2 id=DATAY res=221.AFIELDS()
:i2 refid=DATABX.AFIELDS()
:p.AFIELDS&lpar.&rpar.
.br
.br
:hp2.Fills referenced arrays with database field information:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.AFields&lpar.<aNames>&lbrk.&comma.<aTypes>&rbrk..&lbrk.&comma.<aLen>&rbrk..&lbrk.&comma.<aDecs>&rbrk..&rpar. &minus.&minus.> <nFields>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<aNames>  Array of field names
.br
:p.<aTypes>  Array of field names
.br
:p.<aLens>  Array of field names
.br
:p.<aDecs>  Array of field names
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nFields> Number od fields in a database or work area
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function will fill a series of arrays with field  names&comma.field types&comma.field lenghts&comma. and number of field  decimal positions for the currently selected or designed  database. Each array parallels the different
descriptors  of a file's structure.The first array will consist of the  names of the fields in the current work area.All other arrays  are optional and will be filled with the corrensponding data.  This function will return zero
if no parameters are specified  or if no database is avaliable in the current work area.Otherwise&comma.  the number of fields or the lenght of the shortest array argument&comma.  witchever is smaller&comma. will be returned.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
         LOCAL aNames&colon.&eq.&lbrc.&rbrc.&comma.aTypes&colon.&eq.&lbrc.&rbrc.&comma.aLens&colon.&eq.&lbrc.&rbrc.&comma.aDecs&colon.&eq.&lbrc.&rbrc.&comma.nFields&colon.&eq.0
.br

.br
         USE Test
.br

.br
         dbGoTop&lpar.&rpar.
.br
         nFields&colon.&eq.aFields&lpar.aNames&comma.aTypes&comma.aLens&comma.aDecs&rpar.
.br

.br
         ? &cdq.Number of fields&cdq.&comma. nFields
.br

.br
         RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.AFIELDS&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
:h2 id=DATAY res=206.ALIAS()
:i2 refid=DATABX.ALIAS()
:p.ALIAS&lpar.&rpar.
.br
.br
:hp2.Returns the alias name of a work area:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.Alias&lpar.&lbrk.<nWorkArea>&rbrk..&rpar. &minus.&minus.> <cWorkArea>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nWorkArea> Number of a work area
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cWorkArea> Name of alias
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the alias of the work area indicated by <nWorkArea>  If <nWorkArea> is not provided&comma. the alias of the current work area is  returned.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br

.br
      USE Test
.br
      select 0
.br
      qOut&lpar. IF&lpar.Alias&lpar.&rpar.&eq.&eq.&cdq.&cdq.&comma.&cdq.No Name&cdq.&comma.Alias&lpar.&rpar.&rpar.&rpar.
.br
      Test&minus.>&lpar.qOut&lpar.Alias&lpar.&rpar.&rpar.
.br
      qOut&lpar.Alias&lpar.1&rpar.&rpar.
.br

.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.ALIAS&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=205.DBF():elink.
.br
:h2 id=DATAY res=227.BOF()
:i2 refid=DATABX.BOF()
:p.BOF&lpar.&rpar.
.br
.br
:hp2.Test for the beggining&minus.of&minus.file condition:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.BOF&lpar.&rpar. &minus.&minus.> <lBegin>:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.BOF&lpar.&rpar. Logical true &lpar..T.&rpar. or false &lpar..F.&rpar.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function determines if the beggining of the file marker has been  reached. If so&comma. the function will return a logical true &lpar..T.&rpar.&semi. otherwise&comma.  a logical false&lpar..F.&rpar. will be returned.  By
default&comma. BOF&lpar.&rpar. will apply to the currently selected database unless  the function is preceded by an alias
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
        USE Tests NEW
.br
        DBGOTOP&lpar.&rpar.
.br
        ? &cdq.Is Eof&lpar.&rpar.&cdq.&comma.EOF&lpar.&rpar.
.br
        DBGOBOTTOM&lpar.&rpar.
.br
        ? &cdq.Is Eof&lpar.&rpar.&cdq.&comma.EOF&lpar.&rpar.
.br
        USE
.br
     RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.BOF&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=219.EOF():elink.
.br
:link reftype=hd res=220.FOUND():elink.
.br
:link reftype=hd res=258.LASTREC():elink.
.br
:h2 id=COMMY res=259.ZAP
:i2 refid=COMMAX.ZAP
:p.ZAP
.br
.br
:hp2.Remove all records from the current database file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ZAP:ehp2.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command removes all of the records from the database in the  current work area.This operation also updates any index file in  use at the time of this operation.In addition&comma. this command removes  all items within an
associated memo file.  In a network enviroment&comma.any file that is about to be ZAPped must  be used exclusively.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE Tests NEW index Tests
.br
      ZAP
.br
      USE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is CA Clipper compliant
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=260.DELETE:elink.
.br
:link reftype=hd res=261.PACK:elink.
.br
:link reftype=hd res=262.USE:elink.
.br
:h2 id=DATAY res=263.DELETED()
:i2 refid=DATABX.DELETED()
:p.DELETED&lpar.&rpar.
.br
.br
:hp2.Tests the record's deletion flag.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DELETED&lpar.&rpar. &minus.&minus.> lDeleted:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.DELETED&lpar.&rpar. return a logical true &lpar..T.&rpar. or false &lpar..F.&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a logical true &lpar..T.&rpar. is the current record in the  selected or designated work area ha ben marked for deletion.If not&comma. the  function will return a logical false &lpar..F.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
      USE Test New
.br
      DBGOTO&lpar.&rpar.
.br
      DBDELETE&lpar.&rpar.
.br
      ? &cdq.Is Record Deleted&cdq.&comma.Test&minus.>&lpar.DELETED&lpar.&rpar.&rpar.
.br
      DBRECALL&lpar.&rpar.
.br
      USE
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=222.DBDELETE():elink.
.br
:h2 id=DATAY res=219.EOF()
:i2 refid=DATABX.EOF()
:p.EOF&lpar.&rpar.
.br
.br
:hp2.Test for end&minus.of&minus.file condition.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.EOF&lpar.&rpar. &minus.&minus.> <lEnd>:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lEnd> A logical true &lpar..T.&rpar. or false &lpar..F.&rpar.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function determines if the end&minus.of&minus.file marker has been reached.  If it has&comma. the function will return a logical true &lpar..T.&rpar.&semi. otherwise  a logical false &lpar..F.&rpar. will be returnd
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
        USE Tests NEW
.br
        DBGOTOP&lpar.&rpar.
.br
        ? &cdq.Is Eof&lpar.&rpar.&cdq.&comma.EOF&lpar.&rpar.
.br
        DBGOBOTTOM&lpar.&rpar.
.br
        ? &cdq.Is Eof&lpar.&rpar.&cdq.&comma.EOF&lpar.&rpar.
.br
        USE
.br
     RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.EOF&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=227.BOF():elink.
.br
:link reftype=hd res=220.FOUND():elink.
.br
:link reftype=hd res=258.LASTREC():elink.
.br
:h2 id=DATAY res=264.FCOUNT()
:i2 refid=DATABX.FCOUNT()
:p.FCOUNT&lpar.&rpar.
.br
.br
:hp2.Counts the number of fields in an active database.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FCOUNT&lpar.&rpar. &minus.&minus.> nFields:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nFields> Return the number of fields
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the number of fields in the current or designated  work area.If no database is open in this work area&comma. the function will  return 0.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
        USE Tests NEW
.br
        ? &cdq.This database have &cdq.&comma.Tests&minus.>&lpar.FCOUNT&lpar.&rpar.&rpar.&comma.&cdq.Fields&cdq.
.br
        USE
.br
      RETURN Nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=265.FIELDNAME():elink.
.br
:link reftype=hd res=266.TYPE():elink.
.br
:h2 id=DATAY res=267.FIELDGET()
:i2 refid=DATABX.FIELDGET()
:p.FIELDGET&lpar.&rpar.
.br
.br
:hp2.Obtains the value  of a specified field:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FIELDGET&lpar.<nField>&rpar. &minus.&minus.> ValueField:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nField> Is the numeric field position
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<ValueField>  Any expression
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the value of the field at the <nField>th location  in the selected or designed work area.If the value in <nField> does not  correspond to n avaliable field position in this work area&comma. the function
will return a NIL data type.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
      USE Test NEW
.br
      ? Test&minus.>&lpar.FieldGet&lpar.1&rpar.&rpar.
.br
      USE
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper Compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=268.FIELDPUT():elink.
.br
:h2 id=DATAY res=265.FIELDNAME()
:i2 refid=DATABX.FIELDNAME()
:p.FIELDNAME&lpar.&rpar.
.br
.br
:hp2.Return the name of a field at a numeric field location.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FIELDNAME&slash.FIELD&lpar.<nPosition>&rpar. &minus.&minus.> cFieldName:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nPosition> Field order in the database.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cFieldName> returns the field name.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function return the name of the field at the <nPosition>th position.  If the numeric value passed to this function does not correspond to an  existing field in the designated or selected work area&comma.this function  will
return a NULL byte.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
        LOCAL x
.br
        USE Tests NEW
.br
        FOR x &colon.&eq. 1 to Tests&minus.>&lpar.FCOUNT&lpar.&rpar.&rpar.
.br
          ? &cdq.Field Name&cdq.&comma.FieldName&lpar.x&rpar.
.br
        NEXT
.br
        USE
.br
      RETURN Nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compatible.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=11.DBSTRUCT():elink.
.br
:link reftype=hd res=264.FCOUNT():elink.
.br
:link reftype=hd res=8.LEN():elink.
.br
:link reftype=hd res=269.VALTYPE():elink.
.br
:h2 id=DATAY res=270.FIELDPOS()
:i2 refid=DATABX.FIELDPOS()
:p.FIELDPOS&lpar.&rpar.
.br
.br
:hp2.Return the ordinal position of a field.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FIELDPOS&lpar.<cFieldName>&rpar. &minus.&minus.> nFieldPos:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFieldName> Name of a field.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nFieldPos> is ordinal position of the field.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function return the ordinal position of the specified field <cField>  in the current or aliased work areaIf there isn't  field under the name  of <cField> or of no database is open in the selected work area&comma. the
func&minus.  tion will return a 0.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION Main&lpar.&rpar.
.br
      USE Test NEW
.br
      ? Test&minus.>&lpar.FIELDPOS&lpar.&cdq.ID&cdq.&rpar.&rpar.
.br
      USE
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=267.FIELDGET():elink.
.br
:link reftype=hd res=268.FIELDPUT():elink.
.br
:h2 id=DATAY res=268.FIELDPUT()
:i2 refid=DATABX.FIELDPUT()
:p.FIELDPUT&lpar.&rpar.
.br
.br
:hp2.Set the value of a field variable:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FIELDPUT&lpar.<nField>&comma. <expAssign>&rpar. &minus.&minus.> ValueAssigned:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nField> The field numeric position
.br
:p.<expAssign> Expression to be assigned to the specified field
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<ValueAssigned> Any expression
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function assings the value in <expAssing> to the <nField>th  field in the current or designated work area.If the operation is  successful&comma.the return value of the function will be the same value  assigned to the
specified field.If the operation is not successful&comma.  the function will return a NIL data type
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE Tests New
.br
      FIELDPUT&lpar.1&comma.&cdq.Mr. Jones&cdq.&rpar.
.br
      USE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compatible.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=267.FIELDGET():elink.
.br
:h2 id=DATAY res=232.FLOCK()
:i2 refid=DATABX.FLOCK()
:p.FLOCK&lpar.&rpar.
.br
.br
:hp2.Locks a file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FLOCK&lpar.&rpar. &minus.&minus.> lSuccess:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lSuccess> A true &lpar..T.&rpar. value&comma. if the lock was successful&semi.otherwise  false &lpar..F.&rpar.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a logical true &lpar..T.0 if a file lock is  attempted and is successfully placed on the current or designated  database.This function will also unlock all records locks placed  by the same network station.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE Tests New
.br
      IF FLOCK&lpar.&rpar.
.br
         SUM Tests&minus.>Ammount
.br
      ENDIF
.br
      USE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compatible
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=233.RLOCK():elink.
.br
:h2 id=DATAY res=220.FOUND()
:i2 refid=DATABX.FOUND()
:p.FOUND&lpar.&rpar.
.br
.br
:hp2.Determine the success of a previous search operation.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FOUND&lpar.&rpar. &minus.&minus.> lSuccess:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lSuccess> A logical true &lpar..T.&rpar. is successful&semi.otherwise&comma. false &lpar..F.&rpar.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function is used to test if the previous SEEK&comma.LOCATE&comma.CONTINUE&comma.  or FIND operation was successful.Each wrk area has its own FOUND&lpar.&rpar.  flag&comma.so that a FOUND&lpar.&rpar. condition may be tested
in unselected work  areas by using an alias.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      nId&colon.&eq.100
.br
      USE Tests NEW INDEX Tests
.br
      SEEK nId
.br
      IF FOUND&lpar.&rpar.
.br
        ? Tests&minus.>Name
.br
      ENDIF
.br
      USE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compatible
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=219.EOF():elink.
.br
:h2 id=DATAY res=271.HEADER()
:i2 refid=DATABX.HEADER()
:p.HEADER&lpar.&rpar.
.br
.br
:hp2.Return the length of a database file header:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HEADER&lpar.&rpar. &minus.&minus.> nBytes:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nBytes> The numeric size of a database file header in bytes
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the number of bytes in the header of the  selected database ot the database in the designated work area.
.br
:p.If used in conjunction with the LASTREC&lpar.&rpar.&comma.RECSIZE&lpar.&rpar. and DISKSPACE&lpar.&rpar.  functions&comma.this functions is capable of implementing a backup and  restore routine.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE Tests New
.br
      ? Header&lpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compatible
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=79.DISKSPACE():elink.
.br
:link reftype=hd res=258.LASTREC():elink.
.br
:link reftype=hd res=272.RECSIZE():elink.
.br
:h2 id=DATAY res=258.LASTREC()
:i2 refid=DATABX.LASTREC()
:p.LASTREC&lpar.&rpar.
.br
.br
:hp2.Returns the number of records in an active work area or database.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.LASTREC&lpar.&rpar. &splitvbar. RECCOUNT&lpar.&rpar.* &minus.&minus.> nRecords:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nRecords > The number of records
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the number of records present in the database  in the selected or designated work area.If no records are present  the value of this function will be 0.Additionaly&comma.if no database is  in use in the
selected or designated work area&comma.this function will  return a 0 value as well.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE Tests NEW
.br
      ? LASTREC&lpar.&rpar.&comma. RECCOUNT&lpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA Clipper compatible
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=219.EOF():elink.
.br
:h2 id=DATAY res=273.LUPDATE()
:i2 refid=DATABX.LUPDATE()
:p.LUPDATE&lpar.&rpar.
.br
.br
:hp2.Yields the date the database was last updated.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.LUPDATE&lpar.&rpar. &minus.&minus.> dModification:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<dModification>  The date of the last modification.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the date recorded by the OS when the selected  or designated database was last written to disk.This function will  only work for those database files in USE.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      Function Main
.br

.br
      Use Tests New
.br
      ? Lupdate&lpar.&rpar. &slash.&slash. 04&slash.25&slash.2000
.br
      Use
.br
      Return Nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=265.FIELDNAME():elink.
.br
:link reftype=hd res=258.LASTREC():elink.
.br
:link reftype=hd res=272.RECSIZE():elink.
.br
:h2 id=DATAY res=274.NETERR()
:i2 refid=DATABX.NETERR()
:p.NETERR&lpar.&rpar.
.br
.br
:hp2.Tests the success of a network function:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.NETERR&lpar.&lbrk.<lNewError>&rbrk..&rpar. &minus.&minus.> lError:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<lNewError> Is a logical Expression.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lError> A value based on the success of a network operation or  function.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function return a logical true &lpar..T.&rpar. is a USE&comma.APPEND BLANK&comma. or  a USE...EXCLUSIVE command is issue and fails in a network enviroment.  In the case of USE and USE...EXCLUSIVE commands&comma.a
NETERR&lpar.&rpar. value  of .T. would be returned if another node of the network has the  exclusive use of a file.And the case of the APPEND BLANK command&comma.  NETERR&lpar.&rpar. will return a logical true &lpar..T.&rpar. if
the file or record  is locked by another node or the value of LASTREC&lpar.&rpar. has been advanced  The value of NETERR&lpar.&rpar. may be changed via the value of <lNewError>.  This allow the run&minus.time error&minus.handling
system to control the way  certains errors are handled.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE TEST NEW Index Test
.br
      If !NetErr&lpar.&rpar.
.br
          Seek Test&minus.>Name&eq.&cdq.HARBOUR&cdq.
.br
          If Found&lpar.&rpar.
.br
             ? Test&minus.>Name
.br
          Endif
.br
      Endif
.br
      USE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=232.FLOCK():elink.
.br
:link reftype=hd res=233.RLOCK():elink.
.br
:h2 id=DATAY res=275.RECCOUNT()
:i2 refid=DATABX.RECCOUNT()
:p.RECCOUNT&lpar.&rpar.
.br
.br
:hp2.Counts the number of records in a database.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.RECCOUNT&lpar.&rpar.* &splitvbar. LASTREC&lpar.&rpar. &minus.&minus.> nRecords:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nRecords>  The number of records
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the number of records present in the database  in the selected or designated work area.If no records are present  the value of this function will be 0.Additionaly&comma.if no database is  in use in the
selected or designated work area&comma.this function will  return a 0 value as well.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      Use Test NEW
.br
      USE Harbour NEW
.br
      ? Reccount&lpar.&rpar.
.br
      ? Test&minus.>&lpar.RECCOUNT&lpar.&rpar.&rpar.
.br
      CLOSE ALL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=219.EOF():elink.
.br
:link reftype=hd res=258.LASTREC():elink.
.br
:link reftype=hd res=276.RECNO():elink.
.br
:link reftype=hd res=226.DBGOBOTTOM():elink.
.br
:h2 id=DATAY res=276.RECNO()
:i2 refid=DATABX.RECNO()
:p.RECNO&lpar.&rpar.
.br
.br
:hp2.Returns the current record number or identity.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.RECNO&lpar.&rpar. &minus.&minus.> Identity:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.RECNO&lpar.&rpar. The record number or indentity
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the position of the record pointer in the  currently selected ot designated work area.  If the database file is empty and if the RDD is the traditional .DBF  file&comma.the value of this function will be 1.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE Tests NEW
.br
      DBGOTOP&lpar.&rpar.
.br
      RECNO&lpar.&rpar.            &slash.&slash. Returns 1
.br
      DBGOTO&lpar.50&rpar.
.br
      RECNO&lpar.&rpar.            &slash.&slash. Returns 50
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=230.DBGOTO():elink.
.br
:link reftype=hd res=229.DBGOTOP():elink.
.br
:link reftype=hd res=226.DBGOBOTTOM():elink.
.br
:link reftype=hd res=258.LASTREC():elink.
.br
:link reftype=hd res=219.EOF():elink.
.br
:link reftype=hd res=227.BOF():elink.
.br
:h2 id=DATAY res=272.RECSIZE()
:i2 refid=DATABX.RECSIZE()
:p.RECSIZE&lpar.&rpar.
.br
.br
:hp2.Returns the size of a single record in an active database.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.RECSIZE&lpar.&rpar. &minus.&minus.> nBytes:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nBytes> The record size.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the number os bytes used by a single record  in the currently selected or designated database file.If no database  is in use in this work area&comma.the return value from this function  will be 0.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE Tests NEW
.br
      DBGOTOP&lpar.&rpar.
.br
      RECSIZE&lpar.&rpar.            &slash.&slash. Returns 1
.br
      DBGOTO&lpar.50&rpar.
.br
      RECSIZE&lpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=79.DISKSPACE():elink.
.br
:link reftype=hd res=265.FIELDNAME():elink.
.br
:link reftype=hd res=271.HEADER():elink.
.br
:link reftype=hd res=258.LASTREC():elink.
.br
:h2 id=DATAY res=233.RLOCK()
:i2 refid=DATABX.RLOCK()
:p.RLOCK&lpar.&rpar.
.br
.br
:hp2.Lock a record in a work area:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.RLOCK&lpar.&rpar. &minus.&minus.> lSuccess:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.RLOCK&lpar.&rpar. True &lpar..T.&rpar. if record lock is successful&semi. otherwise&comma. it  returns false &lpar..F.&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a logical true &lpar..T.&rpar. if an attempt to lock a  specific record in a selected or designated work area is successful.  It will yield a false &lpar..F.&rpar. if either the file or the desired record
is currently locked.  A record that is locked remains locked until another RLOCK&lpar.&rpar. is issued  or until an UNLOCK command is executed.  On a Network enviroment the follow command need that the record is  locked&colon.
.br
:p.@...GET
.br
:p.DELETE &lpar.single record&rpar.
.br
:p.RECALL &lpar.single record&rpar.
.br
:p.REPLACE &lpar.single record&rpar.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      nId&colon.&eq.10
.br
      USE TestId INDEX TestId NEW
.br
      IF TestId&minus.>&lpar.DBSEEK&lpar.nId&rpar.&rpar.
.br
         IF TestId&minus.>&lpar.RLOCK&lpar.&rpar.&rpar.
.br
            DBDELETE&lpar.&rpar.
.br
         ENDIF
.br
      ENDIF
.br
      USE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=232.FLOCK():elink.
.br
:h2 id=DATAY res=237.SELECT()
:i2 refid=DATABX.SELECT()
:p.SELECT&lpar.&rpar.
.br
.br
:hp2.Returns the work area number for a specified alias.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SELECT&lpar.&lbrk.<cAlias>&rbrk..&rpar. &minus.&minus.> nWorkArea:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cAlias> is the target work area alias name.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.SELECT&lpar.&rpar. returns the work area number.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the work area number for the specified alias  name <cAlias>.If no parameter is specified&comma.the current work area will  be the return value of the function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE TESTS NEW
.br
      USE NAMES NEW
.br
      cOldArea&colon.&eq.SELECT&lpar.&cdq.NAMES&cdq.&rpar.
.br
      select TEST
.br
      LIST
.br
      SELECT cOldArea
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=206.ALIAS():elink.
.br
:link reftype=hd res=277.USED():elink.
.br
:h2 id=DATAY res=277.USED()
:i2 refid=DATABX.USED()
:p.USED&lpar.&rpar.
.br
.br
:hp2.Checks whether a database is in use in a work area:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.USED&lpar.&rpar. &minus.&minus.> lDbfOpen:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<lDbfOpen> True is a database is Used&semi.otherwise False
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a logical true &lpar..T.&rpar. if a database file is in  USE in the current or designated work area. If no alias is specified  along with this function &comma. it will default to the currently selected  work
area.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      Use TESTS NEW
.br
      USE Names New
.br
      ? USED&lpar.&rpar.    &slash.&slash. .T.
.br
      ? TESTS&minus.>&lpar.USED&lpar.&rpar.&rpar. &slash.&slash..t.
.br
      CLOSE
.br
      ? USED&lpar.&rpar.  &slash.&slash. .F.
.br
      Select TESTS
.br
      ? USED&lpar.&rpar. &slash.&slash..T.
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.clipper Compliant
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rdd
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=206.ALIAS():elink.
.br
:link reftype=hd res=237.SELECT():elink.
.br
:h2 id=COMMY res=261.PACK
:i2 refid=COMMAX.PACK
:p.PACK
.br
.br
:hp2.Remove records marked for deletion from a database:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.PACK:ehp2.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command removes records that were marked for deletion from the  currently selected database.This command does not pack the contents  of a memo field&semi.those files must be packed via low&minus.level fuctions.
.br
:p.All open index files will be automatically reindexed once PACK command  has completed its operation.On completion&comma.the record pointer is placed  on the first record in the database.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      USE Tests NEW index Tests
.br
      DBGOTO&lpar.10&rpar.
.br
      DELETE NEXT 10
.br
      PACK
.br
      USE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is CA Clipper compliant
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=15.DBEVAL():elink.
.br
:link reftype=hd res=260.DELETE:elink.
.br
:link reftype=hd res=263.DELETED():elink.
.br
:link reftype=hd res=259.ZAP:elink.
.br
:link reftype=hd res=278.RECALL:elink.
.br
:h2 id=DOCUY res=147.OVERVIEW
:i2 refid=DOCUMX.OVERVIEW
:p.OVERVIEW
.br
.br
:hp2.HARBOUR Read me:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
.br
:p.:hp2.The Harbour project:ehp2.
.br
:p.:hp2.************************************************************************:ehp2.
:p.:hp2.*  This file contains information on obtaining&comma. installing&comma. and using  *:ehp2.
:p.:hp2.*  Harbour. Please read it *completely* before asking for help.        *:ehp2.
:p.:hp2.************************************************************************:ehp2.
.br
:p.Harbour is a free implementation of an xBase language compiler. It is  designed to be source code compatible with the CA&minus.Clipper&lpar.r&rpar. compiler.  That means that if you've got some code that would compile using
CA&minus.Clipper&lpar.r&rpar. then it should compile under Harbour. The Harbour&minus.Project  web page is&colon.
:p.:hp2.http:&slash.&slash.www.Harbour&minus.Project.org&slash.:ehp2.
.br
.br
:p.Status and other information is always available from the web site.  There is a Harbour mailing list. Harbour is still at a very early  stage of development&comma. so the mailing list is very much a Developers  only list&comma.
although every body is welcome to join in the discussions.
.br
:p.We would like you to join the Harbour development team. If you are  interested you may suscribe to our mailing list and start contributing  to this free public project.
.br
:p.Please feel free to report all questions&comma. ideas&comma. suggestions&comma. fixes&comma.  code&comma. etc. you may need and want. With the help of all of you&comma. the Harbour  compiler and runtime libraries will become a
reality very soon.
.br
.br
:p.:hp2.What this distribution contains:ehp2.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.This distribution is a Source code only distribution. It does not contain  any executable files. Executable versions of Harbour are available from  the web site. Executable versions of Harbour DO NOT create runable  programs.
Harbour at the moment produces C output code&comma. which must be  compiled with the Harbour Virtual Machine and the support libraries  in order to create a functioning program.
:p.Please test running Harbour against your Clipper source code and report  any problems that might occur.
.br
:p.Very important&colon. The preprocessor functionality is now working.
.br
:p.:hp2.Installation:ehp2.
:p.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
.br
:p.1. Unzip with Harbour zip file using pkunzip or equivalent.
:p.E.G. pkunzip &minus.d build72.zip
:p.This will create Harbour&slash. directory and all the relevant sub  directories.
.br
:p.2. Compile Harbour using your C compiler. Make files for different  platforms are included in the <WHERE ARE THEY?> directory.
.br
.br
:p.:hp2.&minus.&minus.&minus. COPYRIGHT &minus.&minus.&minus.:ehp2.
.br
:p.What copyright information do we have
.br
.br
:p.:hp2.&minus.&minus.&minus. LICENCE &minus.&minus.&minus.:ehp2.
.br
:p.Information about the License for usage of Harbour is available in the  file LICENCE.TXT &lpar.when we have a license&rpar.
.br
:p.:hp2.&minus.&minus.&minus. DISCLAIMER &minus.&minus.&minus.:ehp2.
.br
:p.Participants of The Harbour Project assume no responsibility for errors or  omissions in these materials.
.br
:p.:hp2.THESE MATERIALS ARE PROVIDED &cdq.AS IS&cdq. WITHOUT WARRANTY OF ANY KIND&comma. EITHER  EXPRESS OR IMPLIED&comma. INCLUDING BUT NOT LIMITED TO&comma. THE IMPLIED WARRANTIES  OF MERCHANTABILITY&comma. FITNESS FOR A
PARTICULAR PURPOSE&comma. OR NON&minus.INFRINGEMENT.:ehp2.
.br
:p.Participants of The Harbour Project further do not warrant the accuracy or  completeness of the code&comma. information&comma. text&comma. output or any other items  contained within these materials. Participants of The Harbour
Project  shall not be liable for any special&comma. direct&comma. indirect&comma. incidental&comma. or  consequential damages&comma. including without limitation&comma. lost revenues or  lost profits&comma. which may result from
the use or mis&minus.use of these materials.
.br
:p.The information in The Harbour Project is subject to change without notice  and does not represent any future commitment by the participants of The  Harbour Project.
.br
:p.The Harbour Project
.br
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=146.LICENSE:elink.
.br
:h2 id=ENVIY res=279.__SETCENTURY()
:i2 refid=ENVIRX.__SETCENTURY()
:p.&us.&us.SETCENTURY&lpar.&rpar.
.br
.br
:hp2.Set the Current Century:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.SETCENTURY&lpar.&lbrk.<lFlag> &splitvbar. <cOnOff> &rbrk.. &rpar. &minus.&minus.> lPreviousValue:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.optional <lFlag> or <cOnOff> &lpar.not case sensitive&rpar.  .T. or &cdq.ON&cdq. to enable the century setting &lpar.4&minus.digit years&rpar.  .F. or &cdq.OFF&cdq. to disable the century setting &lpar.2&minus.digit years&rpar.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Either the current or previous century setting as a logical value
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
:h2 id=ENVIY res=100.SET()
:i2 refid=ENVIRX.SET()
:p.SET&lpar.&rpar.
.br
.br
:hp2.Changes or evaluated enviromental settings:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.Set&lpar.<nSet> &lbrk.&comma. <xNewSetting> &lbrk.&comma. <xOption> &rbrk.. &rbrk.. &rpar. &minus.&minus.> xPreviousSetting:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nSet> Set Number
.br
:p.<xNewSetting> Any expression to assing a value to the seting
.br
:p.<xOption> Logical expression
.br
:p.<nSet>            <xNewSetting>          <xOption>
.br
:p.&us.SET&us.ALTERNATE   <lFlag> &splitvbar. <cOnOff>
.br
:p.If enabled&comma. QOUT&lpar.&rpar. and QQOUT&lpar.&rpar. write to the screen and to  a file&comma. provided that a file has been opened or created  with &us.SET&us.ALTFILE. If disabled&comma. which is the default&comma.
QOUT&lpar.&rpar. and QQOUT&lpar.&rpar. only write to the screen &lpar.and&slash.or to  the PRINTFILE&rpar.. Defaults to disabled.
.br
:p.&us.SET&us.ALTFILE     <cFileName>             <lAdditive>
.br
:p.When set&comma. creates or opens file to write QOUT&lpar.&rpar. and  QQOUT&lpar.&rpar. output to. If <lAdditive> is TRUE and the file  already exists&comma. the file is opened and positioned at end  of file. Otherwise&comma. the
file is created. If a file is  already opened&comma. it is closed before the new file is  opened or created &lpar.even if it is the same file&rpar.. The  default file extension is &cdq..txt&cdq.. There is no default  file name.
Call with an empty string to close the file.
.br
:p.&us.SET&us.AUTOPEN     <lFlag> &splitvbar. <cOnOff>
.br
:p.TODO&colon. Document
.br
:p.&us.SET&us.AUTORDER    <lFlag> &splitvbar. <cOnOff>
.br
:p.TODO&colon. Document
.br
:p.&us.SET&us.AUTOSHARE   <lFlag> &splitvbar. <cOnOff>
.br
:p.TODO&colon. Document
.br
:p.&us.SET&us.BELL        <lFlag> &splitvbar. <cOnOff>
.br
:p.When enabled&comma. the bell sounds when the last position of  a GET is reached and&slash.or when a GET validation fails.  Disabled by default.
.br
:p.&us.SET&us.CANCEL      <lFlag> &splitvbar. <cOnOff>
.br
:p.When enabled&comma. which is the default&comma. pressing Alt+C or  Ctrl+Break terminates the program. When disabled&comma. both  keystrokes can be read by INKEY&lpar.&rpar.. Note&colon. SET KEY has  precedence over SET CANCEL.
.br
:p.&us.SET&us.COLOR       <cColorSet>
.br
:p.Sets the current color scheme&comma. using color pairs in the  sequence &cdq.<standard>&comma.<enhanced>&comma.<border>&comma.<background>&comma.  <unselected>&cdq.. Each color pair uses the format
&cdq.<foreground>&slash.<background>&cdq.. The color codes are space  or &cdq.N&cdq. for black&comma. &cdq.B&cdq. for blue&comma. &cdq.G&cdq. for green&comma. &cdq.BG&cdq. for  Cyan&comma. &cdq.R&cdq. for red&comma. &cdq.RB&cdq.
for magenta&comma. &cdq.GR&cdq. for brown&comma. &cdq.W&cdq.  for white&comma. &cdq.N+&cdq. for gray&comma. &cdq.B+&cdq. for bright blue&comma. &cdq.G+&cdq. for  bright green&comma. &cdq.BG+&cdq. for bright cyan&comma.
&cdq.R+&cdq. for bright red&comma.  &cdq.RB+&cdq. for bright magenta&comma. &cdq.GR+&cdq. for yellow&comma. and &cdq.W+&cdq. for  bright white. Special codes are &cdq.I&cdq. for inverse video&comma.  &cdq.U&cdq. for underline on
a monochrome monitor &lpar.blue on a  color monitor&rpar.&comma. and &cdq.X&cdq. for blank. The default color is  &cdq.W&slash.N&comma.N&slash.W&comma.N&comma.N&comma.N&slash.W&cdq..
.br
:p.&us.SET&us.CONFIRM     <lFlag> &splitvbar. <cOnOff>
.br
:p.If enabled&comma. an exit key must be pressed to leave a GET.  If disabled&comma. which is the default&comma. typing past the end  will leave a GET.
.br
:p.&us.SET&us.CONSOLE     <lFlag> &splitvbar. <cOnOff>
.br
:p.If enabled&comma. which is the default&comma. all screen output goes  to the screen. When disabled&comma. screen output is suppressed  &lpar.Note&colon. This setting does not affect OUTSTD&lpar.&rpar. or OUTERR&lpar.&rpar.&rpar..
.br
:p.&us.SET&us.CURSOR      <nCursorType>
.br
:p.If enabled&comma. which is the default&comma. the cursor is displayed  on screen. If disabled&comma. the screen cursor is hidden.
.br
:p.&us.SET&us.DATEFORMAT  <cDateFormat>
.br
:p.Sets the default date format for display&comma. date input&comma. and  date conversion. Defaults to American &lpar.&cdq.mm&slash.dd&slash.yy&cdq.&rpar.. Other  formats include ANSI &lpar.&cdq.yy.mm.dd&cdq.&rpar.&comma. British
&lpar.&cdq.dd&slash.mm&slash.yy&cdq.&rpar.&comma.  French &lpar.&cdq.dd&slash.mm&slash.yy&cdq.&rpar.&comma. German &lpar.&cdq.dd.mm.yy&cdq.&rpar.&comma. Italian  &lpar.&cdq.dd&minus.mm&minus.yy&cdq.&rpar.&comma. Japan
&lpar.&cdq.yy&slash.mm&slash.dd&cdq.&rpar.&comma. and USA &lpar.&cdq.mm&minus.dd&minus.yy&cdq.&rpar..  SET CENTURY modifies the date format. SET CENTURY ON  replaces the &cdq.y&cdq.s with &cdq.YYYY&cdq.. SET CEN
TURY OFF replaces  the &cdq.y&cdq.s with &cdq.YY&cdq..
.br
:p.&us.SET&us.DEBUG       <lStatus>
.br
:p.When set to .t.&comma. pressing Alt+D activates the debugger.  When set to .f.&comma. which is the default&comma. Alt+D can be read  by INKEY&lpar.&rpar.. &lpar.Also affected by AltD&lpar.1&rpar. and AltD&lpar.0&rpar.&rpar.
.br
:p.&us.SET&us.DECIMALS    <nNumberOfDecimals>
.br
:p.Sets the number of decimal digits to use when displaying  printing numeric values when SET FIXED is ON. Defaults to  2. If SET FIXED is OFF&comma. then SET DECIMALS is only used to  determine the number of decimal digits to use
after using  EXP&lpar.&rpar.&comma. LOG&lpar.&rpar.&comma. SQRT&lpar.&rpar.&comma. or division. Other math operations  may adjust the number of decimal digits that the result  will display. Note&colon. This never affects the
precision of  a number. Only the display format is affected.
.br
:p.&us.SET&us.DEFAULT     <cDefaultDirectory>
.br
:p.Sets the default directory in which to open&comma. create and  check for files. Defaults to current directory &lpar.blank&rpar..
.br
:p.&us.SET&us.DELETED     <lFlag> &splitvbar. <cOnOff>
.br
:p.If enabled&comma. deleted records will be processed. If  disabled&comma. which is the default&comma. deleted records will  be ignored.
.br
:p.&us.SET&us.DELIMCHARS  <cDelimiters>
.br
:p.Sets the GET delimiter characters. Defaults to &cdq.&colon.&colon.&cdq..
.br
:p.&us.SET&us.DELIMITERS  <lFlag> &splitvbar. <cOnOff>
.br
:p.If enabled&comma. GETs are delimited on screen. If disabled&comma.  which is the default&comma. no GET delimiters are used.
.br
:p.&us.SET&us.DEVICE      <cDeviceName>
.br
:p.Selects the output device for DEVOUT&lpar.&rpar.. When set to  &cdq.PRINTER&cdq.&comma. all output is sent to the printer device or  file set by &us.SET&us.PRINTFILE. When set to anything else&comma.  all output is sent to the
screen. Defaults to &cdq.SCREEN&cdq..
.br
:p.&us.SET&us.EPOCH       <nYear>
.br
:p.Determines how to handle the conversion of 2&minus.digit years  to 4 digit years. When a 2&minus.digit year is greater than or  equal to the year part of the epoch&comma. the century part of  the epoch is added to the year. When
a 2&minus.digit year is  less than the year part of the epoch&comma. the century part  of the epoch is incremented and added to the year. The  default epoch is 1900&comma. which converts all 2&minus.digit years  to 19xx. Ex
ample&colon. If the epoch is set to 1950&comma. 2&minus.digit  years in the range from 50 to 99 get converted to 19xx  and 2&minus.digit years in the range 00 to 49 get converted  to 20xx.
.br
:p.&us.SET&us.ESCAPE      <lFlag> &splitvbar. <cOnOff>   *
.br
:p.When enabled&comma. which is the default&comma. pressing Esc will  exit a READ. When disabled&comma. pressing Esc during a READ  is ignored&comma. unless the Esc key has been assigned to a  function using SET KEY.
.br
:p.&us.SET&us.EVENTMASK   <nEventCodes>
.br
:p.Determines which events INKEY&lpar.&rpar. will respond to.  INKEY&us.MOVE allows mouse movement events. INKEY&us.LDOWN  allows the left mouse button down click. INKEY&us.LUP  allows the left mouse button up click. INKEY&us.RDOWN
allows the right mouse button down click. INKEY&us.RUP  allows the right mouse button up clock. INKEY&us.KEYBOARD  allows keyboard keystrokes. INKEY&us.ALL allows all of the  preceding events. Events may be combined
&lpar.e.g.&comma. using  INKEY&us.LDOWN + INKEY&us.RUP will allow left mouse button  down clicks and right mouse button up clicks&rpar.. The  default is INKEY&us.KEYBOARD.
.br
:p.&us.SET&us.EXACT       <lFlag> &splitvbar. <cOnOff>
.br
:p.When enabled&comma. all string comparisons other than &cdq.&eq.&eq.&cdq.  exclude trailing spaces when checking for equality.  When disabled&comma. which is the default&comma. all string  comparisons other than &cdq.&eq.&eq.&cdq.
treat two strings as  equal if the right hand string is &cdq.&cdq. or if the right  hand string is shorter than or the same length as the  left hand string and all of the characters in the right  hand string match the correspondi
ng characters in the  left hand string.
.br
:p.&us.SET&us.EXCLUSIVE   <lFlag> &splitvbar. <cOnOff>
.br
:p.When enabled&comma. which is the default&comma. all database files  are opened in exclusive mode. When disabled&comma. all  database files are opened in shared mode. Note&colon. The  EXCLUSIVE and SHARED clauses of the USE
command can be  used to override this setting.
.br
:p.&us.SET&us.EXIT        <lFlag> &splitvbar. <cOnOff>
.br
:p.Toggles the use of Uparrow and Dnarrow as READ exit keys.  Specifying true &lpar..T.&rpar. enables them as exit keys&comma. and  false &lpar..F.&rpar. disables them. Used internally by the  ReadExit&lpar.&rpar. function.
.br
:p.&us.SET&us.EXTRA       <lFlag> &splitvbar. <cOnOff>
.br
:p.QUESTION&colon. What is this for?  It does not affect &us.SET&us.EXTRAFILE in Clipper!
.br
:p.&us.SET&us.EXTRAFILE   <cFileName>             <lAdditive>
.br
:p.When set&comma. creates or opens file to write QOUT&lpar.&rpar. and  QQOUT&lpar.&rpar. output to. If <lAdditive> is TRUE and the file  already exists&comma. the file is opened and positioned at end  of file. Otherwise&comma. the
file is created. If a file is  already opened&comma. it is closed before the new file is  opened or created &lpar.even if it is the same file&rpar.. The  default file extension is &cdq..prn&cdq.. There is no default  file name.
Call with an empty string to close the file.
.br
:p.&us.SET&us.FIXED       <lFlag> &splitvbar. <cOnOff>
.br
:p.When enabled&comma. all numeric values will be displayed  and printed with the number of decimal digits set  by SET DECIMALS&comma. unless a PICTURE clause is used.  When disabled&comma. which is the default&comma. the number  of
decimal digits that are displayed depends upon  a variety of factors. See &us.SET&us.DECIMALS for more.
.br
:p.&us.SET&us.INSERT      <lFlag> &splitvbar. <cOnOff>
.br
:p.When enabled&comma. characters typed in a GET or MEMOEDIT  are inserted. When disabled&comma. which is the default&comma.  characters typed in a GET or MEMOEDIT overwrite.  Note&colon. This setting can also be toggled between on
and  off by pressing the Insert key during a GET or MEMOEDIT.
.br
:p.&us.SET&us.INTENSITY   <lFlag> &splitvbar. <cOnOff>
.br
:p.When enabled&comma. which is the default&comma. GETs and PROMPTs  are displayed using the enhanced color setting. When  disabled&comma. GETs and PROMPTs are displayed using the  standard color setting.
.br
:p.&us.SET&us.LANGUAGE    <cLanguageID>
.br
:p.Specifies the language to be used for Harbour messages.
.br
:p.&us.SET&us.MARGIN      <nColumns>
.br
:p.Sets the left margin for all printed output. The default  value is 0. Note&colon. PCOL&lpar.&rpar. reflects the printer's column  position including the margin &lpar.e.g.&comma. SET MARGIN TO 5  followed by DEVPOS&lpar.5&comma.
10&rpar. makes PCOL&lpar.&rpar. return 15&rpar..
.br
:p.&us.SET&us.MBLOCKSIZE <nMemoBlockSize>
.br
:p.TODO&colon. Document
.br
:p.&us.SET&us.MCENTER     <lFlag> &splitvbar. <cOnOff>
.br
:p.If enabled&comma. display PROMPTs centered on the MESSAGE row.  If disabled&comma. which is the default&comma. display PROMPTS at  column position 0 on the MESSAGE row.
.br
:p.&us.SET&us.MESSAGE     <nRow>
.br
:p.If set to 0&comma. which is the default&comma. PROMPTs are always  suppressed. Otherwise&comma. PROMPTs are displayed on the  set row. Note&colon. It is not possible to display prompts  on the top&minus.most screen row&comma.
because row 0 is reserved  for the SCOREBOARD&comma. if enabled.
.br
:p.&us.SET&us.MFILEEXT    <cMemoFileExt>
.br
:p.TODO&colon. Document
.br
:p.&us.SET&us.OPTIMIZE    <lFlag> &splitvbar. <cOnOff>
.br
:p.TODO&colon. Document
.br
:p.&us.SET&us.PATH        <cDirectories>
.br
:p.Specifies a path of directories to search through to  locate a file that can't be located in the DEFAULT  directory. Defaults to no path &lpar.&cdq.&cdq.&rpar.. Directories must  be separated by a semicolon &lpar.e.g.&comma.
&cdq.C&colon.\DATA&semi.C&colon.\MORE&cdq.&rpar..
.br
:p.&us.SET&us.PRINTER     <lFlag> &splitvbar. <cOnOff>
.br
:p.If enabled&comma. QOUT&lpar.&rpar. and QQOUT&lpar.&rpar. write to the screen and to  a file&comma. provided that a file has been opened or created  with &us.SET&us.ALTFILE. If disabled&comma. which is the default&comma.
QOUT&lpar.&rpar. and QQOUT&lpar.&rpar. only write to the screen &lpar.and&slash.or to  the ALTFILE&rpar..
.br
:p.&us.SET&us.PRINTFILE   <cFileName>             <lAdditive>
.br
:p.When set&comma. creates or opens file to write QOUT&lpar.&rpar.&comma. QQOUT&lpar.&rpar.  and DEVOUT&lpar.&rpar. output to. If <lAdditive> is TRUE and the  file already exists&comma. the file is opened and positioned  at end of
file. Otherwise&comma. the file is created. If a  file is already opened&comma. it is closed before the new file  is opened or created &lpar.even if it is the same file&rpar.. The  default file extension is &cdq..prn&cdq.. The
default file name  is &cdq.PRN&cdq.&comma. which maps to the default printer device. Call  with an empty string to close the file.
.br
:p.&us.SET&us.SCOREBOARD  <lFlag> &splitvbar. <cOnOff>
.br
:p.When enabled&comma. which is the default&comma. READ and MEMOEDIT  display status messages on screen row 0. When disabled&comma.  READ and MEMOEDIT status messages are suppressed.
.br
:p.&us.SET&us.SCROLLBREAK <lFlag> &splitvbar. <cOnOff>
.br
:p.QUESTION&colon. What is this flag for?
.br
:p.&us.SET&us.SOFTSEEK    <lFlag> &splitvbar. <cOnOff>
.br
:p.When enabled&comma. a SEEK that fails will position the record  pointer to the first key that is higher than the sought  after key or to LASTREC&lpar.&rpar. + 1 if there is no higher key.  When disabled&comma. which is the
default&comma. a SEEK that fails  will position the record pointer to LASTREC&lpar.&rpar.+1.
.br
:p.&us.SET&us.STRICTREAD  <lFlag> &splitvbar. <cOnOff>
.br
:p.TODO&colon. Document
.br
:p.&us.SET&us.TYPEAHEAD   <nKeyStrokes>
.br
:p.Sets the size of the keyboard typeahead buffer. Defaults  to 50. The minimum is 16 and the maximum is 4096.
.br
:p.&us.SET&us.UNIQUE      <lFlag> &splitvbar. <cOnOff>
.br
:p.When enabled&comma. indexes are not allowed to have duplicate  keys. When disabled&comma. indexes are allowed duplicate keys.
.br
:p.&us.SET&us.VIDEOMODE   <nValue>
.br
:p.TODO&colon. Document
.br
:p.&us.SET&us.WRAP        <lFlag> &splitvbar. <cOnOff>
.br
:p.When enabled&comma. lightbar menus can be navigated from the  last position to the first and from the first position  to the last. When disabled&comma. which is the default&comma. there  is a hard stop at the first and last
positions.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.SET&lpar.&rpar. The current or previous setting
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
:h2 id=ENVIY res=280.__SetFunction()
:i2 refid=ENVIRX.__SETFUNCTION()
:p.&us.&us.SetFunction&lpar.&rpar.
.br
.br
:hp2.Assign a character string to a function key:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.SetFunction&lpar. <nFunctionKey>&comma. &lbrk.<cString>&rbrk.. &rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nFunctionKey> is a number in the range 1..40 that represent the  function key to be assigned.
.br
:p.<cString> is a character string to set. If <cString> is not  specified&comma. the function key is going to be set to NIL releasing by  that any previous &us.&us.SetFunction&lpar.&rpar. or SETKEY&lpar.&rpar. for that function.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.SetFunction&lpar.&rpar. always return NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.SetFunction&lpar.&rpar. assign a character string with a function key&comma. when  this function key is pressed&comma. the keyboard is stuffed with this  character string. &us.&us.SetFunction&lpar.&rpar. has the effect of
clearing any  SETKEY&lpar.&rpar. previously set to the same function number and vice versa.
.br
:table cols='12 21'.
:row.
:c.nFunctionKey
:c.Key to be set
:row.
:c.
:row.
:c.1 .. 12
:c.F1 .. F12
:row.
:c.13 .. 20
:c.Shift-F3 .. Shift-F10
:row.
:c.21 .. 30
:c.Ctrl-F1 .. Ctrl-F10
:row.
:c.31 .. 40
:c.Alt-F1 .. Alt-F10
:etable.
.br
:p.SET FUNCTION command is preprocessed into &us.&us.SetFunction&lpar.&rpar. function  during compile time.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Set F1 with a string
.br
      CLS
.br
      &us.&us.SetFunction&lpar. 1&comma. &cdq.I Am Lazy&cdq. + CHR&lpar. 13 &rpar. &rpar.
.br
      cTest &colon.&eq. SPACE&lpar. 20 &rpar.
.br
      @ 10&comma. 0 SAY &cdq.type something or F1 for lazy mode &cdq. GET cTest
.br
      READ
.br
      ? cTest
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.Harbour use 11 and 12 to represent F11 and F12&comma. while CA&minus.Clipper use  11 and 12 to represent Shift&minus.F1 and Shift&minus.F2.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=131.INKEY():elink.
.br
:link reftype=hd res=126.SETKEY():elink.
.br
:link reftype=hd res=133.__KEYBOARD():elink.
.br
:link reftype=hd res=125.SET KEY:elink.
.br
:h2 id=COMMY res=281.SET FUNCTION
:i2 refid=COMMAX.SET FUNCTION
:p.SET FUNCTION
.br
.br
:hp2.Assign a character string to a function key:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET FUNCTION <nFunctionKey> TO &lbrk.<cString>&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nFunctionKey> is a number in the range 1..40 that represent the  function key to be assigned.
.br
:p.<cString> is a character string to set. If <cString> is not  specified&comma. the function key is going to be set to NIL releasing by  that any previous  Set Function or SETKEY&lpar.&rpar. for that function.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Set Function assign a character string with a function key&comma. when  this function key is pressed&comma. the keyboard is stuffed with this  character string. Set Function has the effect of clearing any  SETKEY&lpar.&rpar.
previously set to the same function number and vice versa.
.br
:table cols='12 21'.
:row.
:c.nFunctionKey
:c.Key to be set
:row.
:c.
:row.
:c.1 .. 12
:c.F1 .. F12
:row.
:c.13 .. 20
:c.Shift-F3 .. Shift-F10
:row.
:c.21 .. 30
:c.Ctrl-F1 .. Ctrl-F10
:row.
:c.31 .. 40
:c.Alt-F1 .. Alt-F10
:etable.
.br
:p.SET FUNCTION command is preprocessed into &us.&us.SetFunction&lpar.&rpar. function  during compile time.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Set F1 with a string
.br
      CLS
.br
      Set Function  1 to  &cdq.I Am Lazy&cdq. + CHR&lpar. 13 &rpar.
.br
      cTest &colon.&eq. SPACE&lpar. 20 &rpar.
.br
      @ 10&comma. 0 SAY &cdq.type something or F1 for lazy mode &cdq. GET cTest
.br
      READ
.br
      ? cTest
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.Harbour use 11 and 12 to represent F11 and F12&comma. while CA&minus.Clipper use  11 and 12 to represent Shift&minus.F1 and Shift&minus.F2.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=131.INKEY():elink.
.br
:link reftype=hd res=126.SETKEY():elink.
.br
:link reftype=hd res=133.__KEYBOARD():elink.
.br
:h2 id=EVENY res=126.SETKEY()
:i2 refid=EVENTX.SETKEY()
:p.SETKEY&lpar.&rpar.
.br
.br
:hp2.Assign an action block to a key:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SETKEY&lpar. <anKey> &lbrk.&comma. <bAction> &lbrk.&comma. <bCondition> &rbrk.. &rbrk.. &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<anKey> is either a numeric key value&comma. or an array of such values
.br
:p.<bAction> is an optional code&minus.block to be assigned
.br
:p.<bCondition> is an optional condition code&minus.block
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Current assigned action&minus.block
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The SetKey&lpar.&rpar. function returns the current code&minus.block assigned to a  key when called with only the key value.  If the action block &lpar.and  optionally the condition block&rpar. are passed&comma. the current block
is  returned&comma. and the new code block and condition block are stored.  A group of keys may be assigned the same code block&slash.condition block  by using an array of key values in place on the first parame
ter.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      local bOldF10 &colon.&eq. setKey&lpar. K&us.F10&comma. &lbrc.&splitvbar.&splitvbar. Yahoo&lpar.&rpar. &rbrc. &rpar.
.br
      ... &slash.&slash. some other processing
.br
      SetKey&lpar. K&us.F10&comma. bOldF10 &rpar.
.br
      ... &slash.&slash. some other processing
.br
      bBlock &colon.&eq. SetKey&lpar. K&us.SPACE &rpar.
.br
      if bBlock !&eq. NIL ...
.br

.br
      &slash.&slash. make F10 exit current get&comma. but only if in a get &minus. ignores other
.br
      &slash.&slash. wait&minus.states such as menus&comma. achoices&comma. etc...
.br
      SetKey&lpar. K&us.F10&comma. &lbrc.&splitvbar.&splitvbar. GetActive&lpar.&rpar.&colon.State &colon.&eq. GE&us.WRITE &rbrc.&comma.&semi.
.br
       &lbrc.&splitvbar.&splitvbar. GetActive&lpar.&rpar. !&eq. NIL &rbrc. &rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      None definable
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.SETKEY&lpar.&rpar. is mostly CA&minus.Clipper compliant. The only difference is the  addition of the condition code&minus.block parameter&comma. allowing set&minus.keys to  be conditionally turned off or on.  This
condition&minus.block cannot be  returned once set &minus. see SetKeyGet&lpar.&rpar.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=282.HB_SETKEYSAVE():elink.
.br
:h2 id=EVENY res=283.HB_SetKeyGet()
:i2 refid=EVENTX.HB_SETKEYGET()
:p.HB&us.SetKeyGet&lpar.&rpar.
.br
.br
:hp2.Determine a set&minus.key code block &amp. condition&minus.block:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.SETKEYGET&lpar. <nKey> &lbrk.&comma. <bConditionByRef> &rbrk.. &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<anKey> is an numeric key value
.br
:p.<bConditionByRef> is an optional return&minus.parameter
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Current assigned action&minus.block
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The HB&us.SetKeyGet&lpar.&rpar. function returns the current code&minus.block assigned to  a key&comma. and optionally assignes the condition&minus.block to the  return&minus.parameter
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      local bOldF10&comma. bOldF10Cond
.br
      bOldF10 &colon.&eq. HB&us.SetKeyGet&lpar. K&us.F10&comma. @bOldF10Cond &rpar.
.br
      ... &slash.&slash. some other processing
.br
      SetKey&lpar. K&us.F10&comma. bOldF10&comma. bOldF10Cond &rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See test code above
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.HB&us.SETKEYGET&lpar.&rpar. is a new function and hence not CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=126.SETKEY():elink.
.br
:link reftype=hd res=282.HB_SETKEYSAVE():elink.
.br
:link reftype=hd res=284.HB_SETKEYCHECK():elink.
.br
:h2 id=EVENY res=282.HB_SETKEYSAVE()
:i2 refid=EVENTX.HB_SETKEYSAVE()
:p.HB&us.SETKEYSAVE&lpar.&rpar.
.br
.br
:hp2.Returns a copy of internal set&minus.key list&comma. optionally overwriting:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.SETKEYSAVE&lpar. &lbrk. <OldKeys> &rbrk.. &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<OldKeys> is an optional set&minus.key list from a previous call to  HB&us.SetKeySave&lpar.&rpar.&comma. or NIL to clear current set&minus.key list
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Current set&minus.key list
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.HB&us.SetKeySave&lpar.&rpar. is designed to act like the set&lpar.&rpar. function which  returns the current state of an environment setting&comma. and optionally  assigning a new value.  In this case&comma. the &cdq.environment
setting&cdq. is the  internal set&minus.key list&comma. and the optional new value is either a value  returned from a previous call to SetKeySave&lpar.&rpar. &minus. to restore that list&comma.  or the value of NIL to clear the
current list.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
     local aKeys &colon.&eq. HB&us.SetKeySave&lpar. NIL &rpar.  &slash.&slash. removes all current set&eq.keys
.br
     ... &slash.&slash. some other processing
.br
     HB&us.SetKeySave&lpar. aKeys &rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
     None definable
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.HB&us.SETKEYSAVE&lpar.&rpar. is new.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=126.SETKEY():elink.
.br
:h2 id=EVENY res=284.HB_SetKeyCheck()
:i2 refid=EVENTX.HB_SETKEYCHECK()
:p.HB&us.SetKeyCheck&lpar.&rpar.
.br
.br
:hp2.Impliments common hot&minus.key activation code:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.SetKeyCheck&lpar. <nKey> &lbrk.&comma. <p1> &rbrk..&lbrk.&comma. <p2> &rbrk..&lbrk.&comma. <p3> &rbrk.. &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nKey> is a numeric key value to be tested code&minus.block&comma. if executed
.br
:p.<p1>..<p3> are optional parameters that will be passed to the code&minus.block
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.True if there is a hot&minus.key associated with <nKey> and it was executed&semi.  otherwise False  If there is a hot&minus.key association &lpar.before checking any condition&rpar.&colon.  &minus. if there is a
condition&minus.block&comma. it is passed one parameter &minus. <nKey>  &minus. when the hot&minus.key code&minus.block is called&comma. it is passed 1 to 4 parameters&comma.  depending on the para
meters passed to HB&us.SetKeyCheck&lpar.&rpar..  Any  parameters so passed are directly passed to the code&minus.block&comma. with an  additional parameter being <nKey>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.HB&us.SetKeyCheck&lpar.&rpar. is intended as a common interface to the SetKey&lpar.&rpar.  functionality for such functions as ACHOICE&lpar.&rpar.&comma. DBEDIT&lpar.&rpar.&comma. MEMOEDIT&lpar.&rpar.&comma.  ACCEPT&comma.
INPUT&comma. READ&comma. and WAIT
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. within ReadModal&lpar.&rpar.
.br
      if HB&us.SetKeyCheck&lpar. K&us.ALT&us.X&comma. GetActive&lpar.&rpar. &rpar.
.br
      ... &slash.&slash. some other processing
.br
      endif
.br
      &slash.&slash. within TBrowse handler
.br
      case HB&us.SetKeyCheck&lpar. nInkey&comma. oTBrowse &rpar.
.br
        return
.br
      case nInKey &eq.&eq. K&us.ESC
.br
      ... &slash.&slash. some other processing
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      None definable
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.HB&us.SETKEYCHECK&lpar.&rpar. is new.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=126.SETKEY():elink.
.br
:link reftype=hd res=282.HB_SETKEYSAVE():elink.
.br
:h2 id=COMMY res=125.SET KEY
:i2 refid=COMMAX.SET KEY
:p.SET KEY
.br
.br
:hp2.Assign an action block to a key:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET KEY   <anKey> to p<bAction>&rbrk.. &lbrk.when  <bCondition> &rbrk..  &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<anKey> is either a numeric key value&comma. or an array of such values
.br
:p.<bAction> is an optional code&minus.block to be assigned
.br
:p.<bCondition> is an optional condition code&minus.block
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The Set Key Command function is translated to the SetKey&lpar.&rpar. function  witch returns the current code&minus.block assigned to a  key when called with only the key value.  If the action block &lpar.and  optionally the
condition block&rpar. are passed&comma. the current block is  returned&comma. and the new code block and condition block are stored.  A group of keys may be assigned the same code block&slash.condition blo
ck  by using an array of key values in place on the first parameter.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      local bOldF10 &colon.&eq. setKey&lpar. K&us.F10&comma. &lbrc.&splitvbar.&splitvbar. Yahoo&lpar.&rpar. &rbrc. &rpar.
.br
      ... &slash.&slash. some other processing
.br
      Set Key  K&us.F10 to  bOldF10&rpar.
.br
      ... &slash.&slash. some other processing
.br
      bBlock &colon.&eq. SetKey&lpar. K&us.SPACE &rpar.
.br
      if bBlock !&eq. NIL ...
.br

.br
      &slash.&slash. make F10 exit current get&comma. but only if in a get &minus. ignores other
.br
      &slash.&slash. wait&minus.states such as menus&comma. achoices&comma. etc...
.br
      SetKey&lpar. K&us.F10&comma. &lbrc.&splitvbar.&splitvbar. GetActive&lpar.&rpar.&colon.State &colon.&eq. GE&us.WRITE &rbrc.&comma.&semi.
.br
       &lbrc.&splitvbar.&splitvbar. GetActive&lpar.&rpar. !&eq. NIL &rbrc. &rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      None definable
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.SET KEY is mostly CA&minus.Clipper compliant. The only difference is the  addition of the condition code&minus.block parameter&comma. allowing set&minus.keys to  be conditionally turned off or on.  This condition&minus.block
cannot be  returned once set &minus. see SetKeyGet&lpar.&rpar.
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=282.HB_SETKEYSAVE():elink.
.br
:h2 id=ENVIY res=285.SETTYPEAHEAD()
:i2 refid=ENVIRX.SETTYPEAHEAD()
:p.SETTYPEAHEAD&lpar.&rpar.
.br
.br
:hp2.Sets the typeahead buffer to given size.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SETTYPEAHEAD&lpar. <nSize> &rpar. &minus.&minus.> <nPreviousSize>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nSize> is a valid typeahead size.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nPreviousSize> The previous state of &us.SET&us.TYPEAHEAD
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function sets the typeahead buffer to a valid given size as is  Set&lpar. &us.SET&us.TYPEAHEAD &rpar. where used.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Sets typeahead to 12
.br
      SetTypeahead&lpar. 12 &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.SETTYPEAHEAD&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=286.__ACCEPT():elink.
.br
:link reftype=hd res=287.__INPUT():elink.
.br
:h2 id=INTEY res=124.__XHELP()
:i2 refid=INTERX.__XHELP()
:p.&us.&us.XHELP&lpar.&rpar.
.br
.br
:hp2.Looks if a Help&lpar.&rpar. user defined function exist.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.XHELP&lpar.&rpar. &minus.&minus.> <xValue>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns aleatory values.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This is an internal undocumented Clipper function&comma. which will  try to call the user defined function HELP&lpar.&rpar. if it's defined  in the current application. This is the default SetKey&lpar.&rpar. handler  for the F1
key.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.XHELP&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
:h2 id=COMMY res=83.SET DEFAULT
:i2 refid=COMMAX.SET DEFAULT
:p.SET DEFAULT
.br
.br
:hp2.Establishes the Harbour search drive and directory.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET DEFAULT TO &lbrk.<cPath>&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cPath> Drive and&slash.or path.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command changes the drive and directory used for reading and  writting database&comma.index&comma.memory&comma. and alternate files.Specifying no  parameters with this command will default the operation to the  current
logged drive and directory.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      SET DEFAULT to c&colon.\TEMP
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper Compliant.
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=99.SET PATH:elink.
.br
:link reftype=hd res=101.CURDIR():elink.
.br
:link reftype=hd res=100.SET():elink.
.br
:h2 id=COMMY res=170.SET WRAP
:i2 refid=COMMAX.SET WRAP
:p.SET WRAP
.br
.br
:hp2.Toggle wrapping the PROMPTs in a menu.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET WRAP on &splitvbar. OFF &splitvbar. &lpar.<lWrap>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<lWrap> Logical expression for toggle
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command toggles the highlighted bars in a @...PROMPT command  to wrap around in a bottom&minus.to&minus.top and top&minus.to&minus.bottom manner.If the  value of the logical expression <lWrap> is a logical false
&lpar..F.&rpar.&comma.  the wrapping mode is set OFF&semi.otherwise&comma.it is set ON.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      See Tests&slash.menutest.prg
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper Compliant.
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=172.@...PROMPT:elink.
.br
:link reftype=hd res=166.MENU TO:elink.
.br
:h2 id=COMMY res=168.SET MESSAGE
:i2 refid=COMMAX.SET MESSAGE
:p.SET MESSAGE
.br
.br
:hp2.Extablishes a message row for @...PROMPT command:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET MESSAGE TO &lbrk.<nRow> &lbrk.CENTER&rbrk..&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nRow> Row number to display the message
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command is designed to work in conjuntion with the MENU TO and  @...PROMPT commands.With this command&comma. a row number between 0 and  MAXROW&lpar.&rpar. may be specified in <nRow>.This establishes the row on  witch any
message associated with an @...PROMPT command will apear.
.br
:p.If the value of <nRow> is 0&comma.all messages will be supressed.  All messaged will be left&minus.justifies unless the CENTER clause is  used.In this case&comma.the individual messages in each @...PROMPT command  will be
centered at the designated row &lpar.unless <nRow> is 0&rpar..All  messages are independent&semi.therefor&comma.the screen area is cleared out  by the centered message will vary based on the length
of each  individual message.
.br
:p.Specifying no parameters with this command set the row value to 0&comma.  witch suppresses all messages output.  The British spelling of CENTRE is also supported.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      See Tests&slash.menutest.prg
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper Compliant.
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=100.SET():elink.
.br
:link reftype=hd res=170.SET WRAP:elink.
.br
:link reftype=hd res=172.@...PROMPT:elink.
.br
:link reftype=hd res=166.MENU TO:elink.
.br
:h2 id=COMMY res=99.SET PATH
:i2 refid=COMMAX.SET PATH
:p.SET PATH
.br
.br
:hp2.Specifies a search path for opening files:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET PATH TO &lbrk.<cPath>&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cPath> Search path for files
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command specifies the search path for files required by most  commands and functions not found in the current drive and directory.  This pertains primarily&comma.but not exclusively&comma. to databases&comma.indexes&comma.
and memo files&comma.as well as to memory&comma.labels&comma.and reports files. The  search hirarchy is&colon. 1 Current drive and directory&comma.2 The SET DEFAULT  path&semi.3 The SET PATH path.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      SET PATH TO c&colon.\Harbour\Test
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper Compliant.
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=83.SET DEFAULT:elink.
.br
:link reftype=hd res=101.CURDIR():elink.
.br
:link reftype=hd res=100.SET():elink.
.br
:h2 id=COMMY res=169.SET INTENSITY
:i2 refid=COMMAX.SET INTENSITY
:p.SET INTENSITY
.br
.br
:hp2.Toggles the enhaced display of PROMPT's and GETs.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET INTENSITY  ON &splitvbar. off &splitvbar. &lpar.<lInte>&rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<lInte> Logical expression for toggle command
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command set the field input color and @...PROMPT menu color  to either highlighted &lpar.inverse video&rpar. or normal color. The default  condition is ON &lpar.highlighted&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      SET INTENSITY ON
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper Compliant.
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=140.@...GET:elink.
.br
:link reftype=hd res=172.@...PROMPT:elink.
.br
:link reftype=hd res=32.@...SAY:elink.
.br
:link reftype=hd res=100.SET():elink.
.br
:h2 id=COMMY res=288.SET ALTERNATE
:i2 refid=COMMAX.SET ALTERNATE
:p.SET ALTERNATE
.br
.br
:hp2.Toggle and echos output to an alternate file:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET ALTERNATE to <cFile> &lbrk.ADDITIVE&rbrk..:ehp2.
:p.:hp2.SET ALTERNATE  on &splitvbar. OFF &splitvbar. &lpar.<lAlter>&rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFile> Name of alternate file.
.br
:p.<lAlter> Logical expression for toggle
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command toggles and output console information to the alternate  file <cFile>&comma.provided that the command is toggled on or the condition  <lAlter> is set to a logical true &lpar..T.&rpar.. If <cFile> does not has a  file
extension&comma. .TXT will be assumed.The file name may optionally  have a drive letter and&slash.or directory path.If none is speficied&comma. the  current drive and directory will be used.  If the ALTERNATE file is created but
no ALTERNATE ON command is  issued&comma.nothing will be echoed to the file.  If ADDITIVE clause is used&comma.then the information will be appended  to the existing alternate file.Otherwise&comma.a new file will be created  with
the specified name &lpar.or an existing one will be overwritten&rpar. and  the information will be appended to the file.The default is to create  a new file.  A SET ALTERNATE TO command will close the alternate file
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      SET ALTERNATE TO test.txt
.br
      SET ALTERNATE ON
.br
      ? 'Harbour'
.br
      ? &cdq.is&cdq.
.br
      ? &cdq.Power&cdq.
.br
      SET ALTERNATE TO
.br
      SET ALTERNATE OFF
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper Compliant.
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=289.CLOSE:elink.
.br
:link reftype=hd res=105.SET PRINTER:elink.
.br
:link reftype=hd res=290.SET CONSOLE:elink.
.br
:link reftype=hd res=100.SET():elink.
.br
:h2 id=COMMY res=291.SET CENTURY
:i2 refid=COMMAX.SET CENTURY
:p.SET CENTURY
.br
.br
:hp2.Toggle the century digits in all dates display:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET CENTURY on &splitvbar. OFF &splitvbar. &lpar.<lCent>&rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<lCent> Logical expression for toggle
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command allows the input and display of dates with the century  prefix.It will be in the standart MM&slash.DD&slash.YYYY format unless specified  by the SET DATE command or SET&lpar.&rpar. function.If <lCent> is a logical
true &lpar..T.&rpar.&comma.the command will be set on&semi.otherwise&comma. the command will  be set off
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      SET CENTURY ON
.br
      ? DATE&lpar.&rpar.
.br
      SET CENTURY OFF
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper compliant
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=63.SET DATE:elink.
.br
:link reftype=hd res=292.SET EPOCH:elink.
.br
:link reftype=hd res=61.CTOD():elink.
.br
:link reftype=hd res=56.DATE():elink.
.br
:link reftype=hd res=60.DTOC():elink.
.br
:link reftype=hd res=100.SET():elink.
.br
:h2 id=COMMY res=63.SET DATE
:i2 refid=COMMAX.SET DATE
:p.SET DATE
.br
.br
:hp2.Assings a date format or chooses a predefined date data set.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET DATE FORMAT &lbrk.TO&rbrk.. <cFormat>:ehp2.
:p.:hp2.SET DATE &lbrk.TO&rbrk.. &lbrk. ANSI &slash. BRITISH &slash. FRENCH &slash. GERMAN &slash. ITALIAN &slash. JAPAN:ehp2.
:p.:hp2.&slash. USA &slash. AMERICAN&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFormat> Keyword for date format
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command sets the date format for function display purposes.  If specified&comma.<cFormat> may be a customized date format in which the  letters d&comma.m and y may be used to desing a date format.The default  is an AMERICAN
date format&semi.specifying no parameters will set the  date format to AMERICAN.Below is a table of the varius predefined  dates formats.
.br
:table cols=' 8 11'.
:row.
:c.Syntax
:c.Date Format
:row.
:c.ANSI
:c.yy.mm.dd
:row.
:c.BRITISH
:c.dd/mm/yy
:row.
:c.FRENCH
:c.dd/mm/yy
:row.
:c.GERMAN
:c.dd.mm.yy
:row.
:c.ITALIAN
:c.dd-mm-yy
:row.
:c.JAPAN
:c.yy.mm.dd
:row.
:c.USA
:c.mm-dd-yy
:row.
:c.AMERICAN
:c.mm/dd/yy
:etable.
.br
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      SET DATE JAPAN
.br
      ? DATE&lpar.&rpar.
.br
      SET DATE GERMAN
.br
      ? Date&lpar.&rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See tests&slash.dates.prg
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper compliant
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=63.SET DATE:elink.
.br
:link reftype=hd res=292.SET EPOCH:elink.
.br
:link reftype=hd res=61.CTOD():elink.
.br
:link reftype=hd res=56.DATE():elink.
.br
:link reftype=hd res=60.DTOC():elink.
.br
:link reftype=hd res=100.SET():elink.
.br
:h2 id=COMMY res=292.SET EPOCH
:i2 refid=COMMAX.SET EPOCH
:p.SET EPOCH
.br
.br
:hp2.Specifie a base year for interpreting dates:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET EPOCH TO <nEpoch>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nEpoch> Base Century.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command sets the base year value for dates that have only two  digits.The default setting is 1900.Dates between 01&slash.01&slash.0100 and  12&slash.31&slash.2999 are fully supported.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      SET EPOCH TO 2000
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper compliant
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=63.SET DATE:elink.
.br
:link reftype=hd res=291.SET CENTURY:elink.
.br
:link reftype=hd res=61.CTOD():elink.
.br
:link reftype=hd res=56.DATE():elink.
.br
:link reftype=hd res=60.DTOC():elink.
.br
:link reftype=hd res=100.SET():elink.
.br
:h2 id=COMMY res=161.SET FIXED
:i2 refid=COMMAX.SET FIXED
:p.SET FIXED
.br
.br
:hp2.Set the number of decimal position to be displayed:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET FIXED on &splitvbar. OFF &splitvbar. &lpar.<lFixed>&rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<lFixed> Logical expression for toggle
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command activates a system wide fixed placement of decimals  places shown for all numeric outputs.If the value of <lFixed> is  a logical true &lpar..T.&rpar.&comma.FIXED will be turned ON&semi.otherwise it will be  turned
OFF.
.br
:p.When SET DECIMALS OFF is used&comma. the follow rules aply to the number  of decimal placed displayed.
.br
:table cols='14 58'.
:row.
:c.Addition
:c.Same as operand with the greatest number of decimal digits
:row.
:c.Subraction
:c.Same as operand with the greatest number of decimal digits
:row.
:c.Multiplication
:c.Sum of operand decimal digits
:row.
:c.Division
:c.Determined by SET DECIMAL TO
:row.
:c.Exponential
:c.Determined by SET DECIMAL TO
:row.
:c.LOG()
:c.Determined by SET DECIMAL TO
:row.
:c.EXP()
:c.Determined by SET DECIMAL TO
:row.
:c.SQRT()
:c.Determined by SET DECIMAL TO
:row.
:c.VAL()
:c.Determined by SET DECIMAL TO
:etable.
.br
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      SET FIXED ON
.br
      ? 25141251&slash.362
.br
      SET FIXED OFF
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper compliant
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=293.SET DECIMALS:elink.
.br
:link reftype=hd res=149.EXP():elink.
.br
:link reftype=hd res=150.LOG():elink.
.br
:link reftype=hd res=158.SQRT():elink.
.br
:link reftype=hd res=160.VAL():elink.
.br
:link reftype=hd res=100.SET():elink.
.br
:h2 id=COMMY res=105.SET PRINTER
:i2 refid=COMMAX.SET PRINTER
:p.SET PRINTER
.br
.br
:hp2.Toggles the printer and controls the printer device:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET PRINTER on &splitvbar. OFF:ehp2.
:p.:hp2.SET PRINTER &lpar.<lPrinter>&rpar.:ehp2.
:p.:hp2.SET PRINTER TO &lbrk.<cPrinter>&rbrk.. &lbrk.ADDITIVE&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<lFixed>   Logical condition by which to toggle the printer  <cPrinter> A device name or an alternate name
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command can direct all output that is not controled by the  @...SAY command and the DEVPOS&lpar.&rpar. and DEVOUT&lpar.&rpar. functions to the  printer.If specified&comma.the condition <lPrinter> toggles the printer  ON if a
logical true &lpar..T.&rpar. and OFF if a logical false &lpar..F.&rpar..If no  argument is specified in the command&comma. the alternate file &lpar.if one  is open&rpar. is closed&comma. or the device is reselected and the
PRINTER  option is turned OFF.
.br
:p.If a device is specified in <cPrinter>&comma. the outpur will be directed  to that device instead of to the PRINTER.A specified device may be  a literal string or a variable&comma. as long as the variable is enclosed  in
parentheses.For a network&comma.do not use a trailing colon when  redirecting to a device.
.br
:p.If an alternate file is specified&comma.<cPrinter> becomes the name of a  file that will contain the output.If no file extension is specified  an extension of.PRN will be defaulted to.
.br
:p.If the ADDITIVE clause is specified&comma.the information will be appended  to the end of the specified output file.Otherwise&comma. a new file will  be created with the specified name &lpar.or an existing file will first  be
cleared&rpar. and the information will then be appended to the file.  The default is to create a new file.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      SET PRINTER ON
.br
      SET PRINTER TO LPT1
.br
      ? 25141251&slash.362
.br
      SET PRINTER .F.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper compliant
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=294.SET DEVICE:elink.
.br
:link reftype=hd res=290.SET CONSOLE:elink.
.br
:link reftype=hd res=295.DEVOUT():elink.
.br
:link reftype=hd res=100.SET():elink.
.br
:h2 id=COMMY res=290.SET CONSOLE
:i2 refid=COMMAX.SET CONSOLE
:p.SET CONSOLE
.br
.br
:hp2.Toggle the console display:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET CONSOLE ON &splitvbar. off &splitvbar. &lpar.<lConsole>&rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<lConsole> Logical expression for toggle command
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command turns the screen display either off or on for all  screens display other then direct output via the @...SAY commands  or the <&minus.> DEVOUT&lpar.&rpar. function.
.br
:p.If <lConsole > is a logical true &lpar..T.&rpar.&comma.the console will be turned  ON&semi.otherwise&comma. the console will be turned off.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      SET console on
.br
      ? DATE&lpar.&rpar.
.br
      SET console off
.br
      ? date&lpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper compliant
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=294.SET DEVICE:elink.
.br
:link reftype=hd res=100.SET():elink.
.br
:h2 id=COMMY res=293.SET DECIMALS
:i2 refid=COMMAX.SET DECIMALS
:p.SET DECIMALS
.br
.br
:hp2.Toggle the console display:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET DECIMALS TO &lbrk.<nDecimal>&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nDecimal> Number of decimals places
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command establishes the number of decimal places that Harbour  will display in mathematical calculations&comma.functions&comma.memory variables&comma.  and fields.Issuing no parameter with this command will the default
number of decimals to 0.For decimals to be seen&comma.the SET FIXED ON  command must be activated.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      SET FIXED ON
.br
      ? 25141251&slash.362
.br
      SET DECIMALS TO 10
.br
      ? 214514.214&slash.6325
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper compliant
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=161.SET FIXED:elink.
.br
:link reftype=hd res=100.SET():elink.
.br
:h2 id=COMMY res=294.SET DEVICE
:i2 refid=COMMAX.SET DEVICE
:p.SET DEVICE
.br
.br
:hp2.Directs all @...SAY output to a device.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET DEVICE TO &lbrk.printer &splitvbar. SCREEN &rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command determines whether the output from the @...SAY command  and the DEVPOS&lpar.&rpar. and DEVOUT&lpar.&rpar. function will be displayed on the  printer.
.br
:p.When the device is set to the PRINTER&comma.the SET MARGIN value adjusts  the position of the column values accordingly.Also&comma.an automatic  page eject will be issued when the current printhead position is  less than the last
printed row.Finally&comma.if used in conjunction with  the @...GET commands&comma.the values for the GETs will all be ignored.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      SET DEVICE TO SCRENN
.br
      ? 25141251&slash.362
.br
      SET DEVICE TO PRINTER
.br
      SET PRINTER TO LPT1
.br
      ? 214514.214&slash.6325
.br
      SET PRINTER OFF
.br
      SET DEVICE TO SCREEN
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper compliant
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=32.@...SAY:elink.
.br
:link reftype=hd res=105.SET PRINTER:elink.
.br
:link reftype=hd res=296.SETPRC():elink.
.br
:link reftype=hd res=100.SET():elink.
.br
:h2 id=COMMY res=180.SET BELL
:i2 refid=COMMAX.SET BELL
:p.SET BELL
.br
.br
:hp2.Toggle the bell to sound once a GET has been completed.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SET BELL on &splitvbar. OFF &splitvbar. &lpar.<lBell>&rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<lBell> Logical expression for toggle command
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command toggles the bell to sound whenever a character is  entered into the last character positionof a GET&comma.of if an invalid  data type is entered into a GET.
.br
:p.If <lBell > is a logical true &lpar..T.&rpar.&comma.the bell will be turned  ON&semi.otherwise&comma. the belle will be turned off.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      SET BEEL ON
.br
      cDummy&colon.&eq.space&lpar.20&rpar.
.br
      ? 3&comma.2 get cDummy
.br
      Read
.br
      SET bell off
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper compliant
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=100.SET():elink.
.br
:h2 id=STRIY res=297.ISALPHA()
:i2 refid=STRINX.ISALPHA()
:p.ISALPHA&lpar.&rpar.
.br
.br
:hp2.Checks if leftmost character in a string is an alphabetic character:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ISALPHA&lpar.<cString>&rpar. &minus.&minus.> lAlpha:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> Any character string
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.lAlpha Logical true &lpar..T.&rpar. or false &lpar..F.&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function return a logical true &lpar..T.&rpar. if the first character  in <cString> is an alphabetic character.If not&comma. the function will  return a logical false &lpar..F.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      QOUT&lpar. &cdq.isalpha&lpar. 'hello' &rpar. &eq. &cdq.&comma. isalpha&lpar. 'hello' &rpar. &rpar.
.br
      QOUT&lpar. &cdq.isalpha&lpar. '12345' &rpar. &eq. &cdq.&comma. isalpha&lpar. '12345' &rpar. &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=298.ISDIGIT():elink.
.br
:link reftype=hd res=299.ISLOWER():elink.
.br
:link reftype=hd res=300.ISUPPER():elink.
.br
:link reftype=hd res=301.LOWER():elink.
.br
:link reftype=hd res=302.UPPER():elink.
.br
:h2 id=STRIY res=298.ISDIGIT()
:i2 refid=STRINX.ISDIGIT()
:p.ISDIGIT&lpar.&rpar.
.br
.br
:hp2.Checks if leftmost character is a digit character:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ISDIGIT&lpar.<cString>&rpar. &minus.&minus.> lDigit:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> Any character string
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.lDigit Logical true &lpar..T.&rpar. or false &lpar..F.&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function takes the caracter string <cString> and checks to  see if the leftmost character is a digit&comma.from 1 to 9.If so&comma. the  function will return a logical true &lpar..T.&rpar.&semi.otherwise&comma. it will
return a logical false &lpar..F.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      QOUT&lpar. &cdq.isdigit&lpar. '12345' &rpar. &eq. &cdq.&comma. isdigit&lpar. '12345' &rpar. &rpar.
.br
      QOUT&lpar. &cdq.isdigit&lpar. 'abcde' &rpar. &eq. &cdq.&comma. isdigit&lpar. 'abcde' &rpar. &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=297.ISALPHA():elink.
.br
:link reftype=hd res=299.ISLOWER():elink.
.br
:link reftype=hd res=300.ISUPPER():elink.
.br
:link reftype=hd res=301.LOWER():elink.
.br
:link reftype=hd res=302.UPPER():elink.
.br
:h2 id=STRIY res=300.ISUPPER()
:i2 refid=STRINX.ISUPPER()
:p.ISUPPER&lpar.&rpar.
.br
.br
:hp2.Checks if leftmost character is an uppercased letter.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ISUPPER&lpar.<cString>&rpar. &minus.&minus.> lUpper:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> Any character string
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.lUpper Logical true &lpar..T.&rpar. or false &lpar..F.&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function takes the caracter string <cString> and checks to  see if the leftmost character is a uppercased letter.If so&comma. the  function will return a logical true &lpar..T.&rpar.&semi.otherwise&comma. it will  return a
logical false &lpar..F.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      QOUT&lpar. &cdq.isupper&lpar. 'Abcde' &rpar. &eq. &cdq.&comma. isupper&lpar. 'Abcde' &rpar. &rpar.
.br
      QOUT&lpar. &cdq.isupper&lpar. 'abcde' &rpar. &eq. &cdq.&comma. isupper&lpar. 'abcde' &rpar. &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=297.ISALPHA():elink.
.br
:link reftype=hd res=299.ISLOWER():elink.
.br
:link reftype=hd res=298.ISDIGIT():elink.
.br
:link reftype=hd res=301.LOWER():elink.
.br
:link reftype=hd res=302.UPPER():elink.
.br
:h2 id=STRIY res=299.ISLOWER()
:i2 refid=STRINX.ISLOWER()
:p.ISLOWER&lpar.&rpar.
.br
.br
:hp2.Checks if leftmost character is an lowercased letter.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ISLOWER&lpar.<cString>&rpar. &minus.&minus.> lLower:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> Any character string
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.lLower Logical true &lpar..T.&rpar. or false &lpar..F.&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function takes the caracter string <cString> and checks to  see if the leftmost character is a lowercased letter.If so&comma. the  function will return a logical true &lpar..T.&rpar.&semi.otherwise&comma. it will  return a
logical false &lpar..F.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      QOUT&lpar. &cdq.islower&lpar. 'Abcde' &rpar. &eq. &cdq.&comma. islower&lpar. 'Abcde' &rpar. &rpar.
.br
      QOUT&lpar. &cdq.islower&lpar. 'abcde' &rpar. &eq. &cdq.&comma. islower&lpar. 'abcde' &rpar. &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=297.ISALPHA():elink.
.br
:link reftype=hd res=298.ISDIGIT():elink.
.br
:link reftype=hd res=300.ISUPPER():elink.
.br
:link reftype=hd res=301.LOWER():elink.
.br
:link reftype=hd res=302.UPPER():elink.
.br
:h2 id=STRIY res=303.LTRIM()
:i2 refid=STRINX.LTRIM()
:p.LTRIM&lpar.&rpar.
.br
.br
:hp2.Removes leading spaces from a string:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.LTRIM&lpar.<cString>&rpar.   &minus.&minus.> <cReturn>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString>  Character expression with leading spaces
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cReturn>  The same character expression with leading spaces removed
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function trims the leading space blank
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? QOUT&lpar. LTRIM&lpar.&cdq.HELLO     &cdq.&rpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This functions is CA&minus.CLIPPER compatible
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=304.TRIM():elink.
.br
:link reftype=hd res=305.RTRIM():elink.
.br
:link reftype=hd res=306.ALLTRIM():elink.
.br
:h2 id=STRIY res=307.AT()
:i2 refid=STRINX.AT()
:p.AT&lpar.&rpar.
.br
.br
:hp2.Locates the position of a substring in a main string.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.AT&lpar.<cSearch>&comma.<cString>&rpar. &minus.&minus.> nPos:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cSearch>  Substring to search for
.br
:p.<cString>  Main string
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.AT&lpar.&rpar. return the starting position of the first occurrence of the  substring in the main string
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function searches the string <cString> for the characters in  the first string <cSearch>. If the substring is not contained within  the second expression&comma.the function will return 0.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      QOUT&lpar. &cdq.at&lpar. 'cde'&comma. 'abcdefgfedcba' &rpar. &eq. '&cdq. +&semi.
.br
      at&lpar. 'cde'&comma. 'abcsefgfedcba' &rpar. + &cdq.'&cdq. &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compatible.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=308.RAT():elink.
.br
:h2 id=STRIY res=308.RAT()
:i2 refid=STRINX.RAT()
:p.RAT&lpar.&rpar.
.br
.br
:hp2.Searches for a substring from the right side of a string.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.RAT&lpar.<cSearch>&comma.<cString>&rpar. &minus.&minus.> nPos:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cSearch>  Substring to search for
.br
:p.<cString>  Main string
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.RAT&lpar.&rpar. return the location of beginnig position.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function searches througt <cString> for the first existence  of <cSearch>.The search operation is performed from the right side  of <cString> to the left. If the function is unable to find any  occurence of <cSearch> in
<cString>&comma.the value of the function will be 0.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      QOUT&lpar. &cdq.rat&lpar. 'cde'&comma. 'abcdefgfedcba' &rpar. &eq. '&cdq. +&semi.
.br
      rat&lpar. 'cde'&comma. 'abcsefgfedcba' &rpar. + &cdq.'&cdq. &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.Will not work with a search string > 64 KB on some platforms
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=307.AT():elink.
.br
:link reftype=hd res=309.SUBSTR():elink.
.br
:link reftype=hd res=310.RIGHT():elink.
.br
:h2 id=STRIY res=311.LEFT()
:i2 refid=STRINX.LEFT()
:p.LEFT&lpar.&rpar.
.br
.br
:hp2.Extract the leftmost substring of a character expression:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.LEFT&lpar.<cString>&comma.<nPos>&rpar. &minus.&minus.> <cReturn>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> Main character to be parsed
.br
:p.<nPos>    Number of bytes to return beggining at the leftmost position
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cReturn>  Substring of evaluation
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This functions returns the leftmost <nPos> characters of <cString>.  It is equivalent to the following programing expression&colon.  SUBSTR&lpar.<cString>&comma.1&comma.<nPos>
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? QOUT&lpar.LEFT&lpar.'HELLO HARBOUR'&comma.5&rpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This functions is CA CLIPPER compatible
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=309.SUBSTR():elink.
.br
:link reftype=hd res=310.RIGHT():elink.
.br
:link reftype=hd res=307.AT():elink.
.br
:link reftype=hd res=308.RAT():elink.
.br
:h2 id=STRIY res=310.RIGHT()
:i2 refid=STRINX.RIGHT()
:p.RIGHT&lpar.&rpar.
.br
.br
:hp2.Extract the rightmost substring of a character expression:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SUBSTR&lpar.<cString>&comma.<nPos>&rpar. &minus.&minus.> <cReturn>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> Character expression to be parsed
.br
:p.<nPos>    Number of bytes to return beggining at the rightmost position
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cReturn>  Substring of evaluation
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This functions returns the rightmost <nPos> characters of <cString>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? QOUT&lpar.RIGHT&lpar.'HELLO HARBOUR'&comma.5&rpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This functions is CA CLIPPER compatible
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=309.SUBSTR():elink.
.br
:link reftype=hd res=311.LEFT():elink.
.br
:link reftype=hd res=307.AT():elink.
.br
:link reftype=hd res=308.RAT():elink.
.br
:h2 id=STRIY res=309.SUBSTR()
:i2 refid=STRINX.SUBSTR()
:p.SUBSTR&lpar.&rpar.
.br
.br
:hp2.Returns a substring from a main string:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SUBSTR&lpar.<cString>&comma.<nStart>&lbrk.&comma.<nLen>&rpar.&rbrk.. &minus.&minus.> <cReturn>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> Character expression to be parsed
.br
:p.<nStart>  Start position
.br
:p.<nLen>    Number of characters to return
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cReturn>  Substring of evaluation
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This functions returns a character string formed from <cString>&comma.  starting at the position of <nStart> and continuing on for a  lenght of <nLen> characters. If <nLen> is not specified&comma. the value  will be all remaining
characters from the position of <nStart>.
.br
:p.The value of <nStart> may be negative. If it is&comma. the direction of  operation is reversed from a default of left&minus.to&minus.right to right&minus.to&minus.left  for the number of characters specified in <nStart>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION MAIN&lpar.&rpar.
.br
      LOCAL X&colon.&eq.REPLICATE&lpar.'ABCD'&comma.70000&rpar.
.br

.br
      ? QOUT&lpar.SUBSTR&lpar.X&comma.65519&comma.200&rpar.
.br

.br
      RETURN NIL
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      ? QOUT&lpar.SUBSTR&lpar.'HELLO HARBOUR'&comma.5&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This functions is CA CLIPPER compatible with the execption that  CA CLIPPER will generate an error if the passed string is >65519 bytes  and Harbour depends of plataform.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=311.LEFT():elink.
.br
:link reftype=hd res=307.AT():elink.
.br
:link reftype=hd res=310.RIGHT():elink.
.br
:h2 id=STRIY res=159.STR()
:i2 refid=STRINX.STR()
:p.STR&lpar.&rpar.
.br
.br
:hp2.Convert a numeric expression to a character string.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.STR&lpar.<nNumber>&comma. &lbrk.<nLength>&rbrk..&comma. &lbrk.<nDecimals>&rbrk..&rpar. &minus.&minus.> cNumber:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nNumber> is the numeric expression to be converted to a character  string.
.br
:p.<nLength> is the length of the character string to return&comma. including  decimal digits&comma. decimal point&comma. and sign.
.br
:p.<nDecimals> is the number of decimal places to return.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.STR&lpar.&rpar. returns <nNumber> formatted as a character string.  If the  optional length and decimal arguments are not specified&comma. STR&lpar.&rpar.  returns the character string according to the following rules&colon.
.br
:p.Results of STR&lpar.&rpar. with No Optional Arguments
.br
:table cols='21 34'.
:row.
:c.Expression
:c.Return Value Length
:row.
:c.
:row.
:c.Field Variable
:c.Field length plus decimals
:row.
:c.Expressions/constants
:c.Minimum of 10 digits plus decimals
:row.
:c.VAL()
:c.Minimum of 3 digits
:row.
:c.MONTH()/DAY()
:c.3 digits
:row.
:c.YEAR()
:c.5 digits
:row.
:c.RECNO()
:c.7 digits
:etable.
.br
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.STR&lpar.&rpar. is a numeric conversion function that converts numeric values  to character strings. It is commonly used to concatenate numeric values  to character strings. STR&lpar.&rpar. has applications displaying
numbers&comma.  creating codes such as part numbers from numeric values&comma. and creating  index keys that combine numeric and character data.
.br
:p.STR&lpar.&rpar. is like TRANSFORM&lpar.&rpar.&comma. which formats numeric values as character  strings using a mask instead of length and decimal specifications.
.br
:p.The inverse of STR&lpar.&rpar. is VAL&lpar.&rpar.&comma. which converts character numbers to  numerics.
.br
:p.*  If <nLength> is less than the number of whole number digits in  <nNumber>&comma. STR&lpar.&rpar. returns asterisks instead of the number.
.br
:p.*  If <nLength> is less than the number of decimal digits  required for the decimal portion of the returned string&comma. Harbour  rounds the number to the available number of decimal places.
.br
:p.*  If <nLength> is specified but <nDecimals> is omitted &lpar.no  decimal places&rpar.&comma. the return value is rounded to an integer.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? STR&lpar. 10&comma. 6&comma. 2 &rpar. &slash.&slash. &cdq. 10.00&cdq.
.br
      ? STR&lpar. &minus.10&comma. 8&comma. 2 &rpar. &slash.&slash. &cdq.  &minus.10.00&cdq.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      see the regression test suit for comprehensive tests.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.CA&minus.Clipper compatible.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=153.STRZERO():elink.
.br
:link reftype=hd res=35.TRANSFORM():elink.
.br
:link reftype=hd res=160.VAL():elink.
.br
:h2 id=STRIY res=153.STRZERO()
:i2 refid=STRINX.STRZERO()
:p.STRZERO&lpar.&rpar.
.br
.br
:hp2.Convert a numeric expression to a character string&comma. zero padded.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.STRZERO&lpar.<nNumber>&comma. &lbrk.<nLength>&rbrk..&comma. &lbrk.<nDecimals>&rbrk..&rpar. &minus.&minus.> cNumber:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nNumber> is the numeric expression to be converted to a character  string.
.br
:p.<nLength> is the length of the character string to return&comma. including  decimal digits&comma. decimal point&comma. and sign.
.br
:p.<nDecimals> is the number of decimal places to return.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.STRZERO&lpar.&rpar. returns <nNumber> formatted as a character string.  If the  optional length and decimal arguments are not specified&comma. STRZERO&lpar.&rpar.  returns the character string according to the following
rules&colon.
.br
:p.Results of STRZERO&lpar.&rpar. with No Optional Arguments
.br
:table cols='21 34'.
:row.
:c.Expression
:c.Return Value Length
:row.
:c.
:row.
:c.Field Variable
:c.Field length plus decimals
:row.
:c.Expressions/constants
:c.Minimum of 10 digits plus decimals
:row.
:c.VAL()
:c.Minimum of 3 digits
:row.
:c.MONTH()/DAY()
:c.3 digits
:row.
:c.YEAR()
:c.5 digits
:row.
:c.RECNO()
:c.7 digits
:etable.
.br
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.STRZERO&lpar.&rpar. is a numeric conversion function that converts numeric values  to character strings. It is commonly used to concatenate numeric values  to character strings. STRZERO&lpar.&rpar. has applications displaying
numbers&comma.  creating codes such as part numbers from numeric values&comma. and creating  index keys that combine numeric and character data.
.br
:p.STRZERO&lpar.&rpar. is like TRANSFORM&lpar.&rpar.&comma. which formats numeric values as character  strings using a mask instead of length and decimal specifications.
.br
:p.The inverse of STRZERO&lpar.&rpar. is VAL&lpar.&rpar.&comma. which converts character numbers to  numerics.
.br
:p.*  If <nLength> is less than the number of whole number digits in  <nNumber>&comma. STR&lpar.&rpar. returns asterisks instead of the number.
.br
:p.*  If <nLength> is less than the number of decimal digits  required for the decimal portion of the returned string&comma. Harbour  rounds the number to the available number of decimal places.
.br
:p.*  If <nLength> is specified but <nDecimals> is omitted &lpar.no  decimal places&rpar.&comma. the return value is rounded to an integer.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? STRZERO&lpar. 10&comma. 6&comma. 2 &rpar. &slash.&slash. &cdq.010.00&cdq.
.br
      ? STRZERO&lpar. &minus.10&comma. 8&comma. 2 &rpar. &slash.&slash. &cdq.&minus.0010.00&cdq.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      see the regression test suit for comprehensive tests.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.CA&minus.Clipper compatible &lpar.it was not mentioned in the docs though&rpar..
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=159.STR():elink.
.br
:h2 id=STRIY res=312.HB_VALTOSTR()
:i2 refid=STRINX.HB_VALTOSTR()
:p.HB&us.VALTOSTR&lpar.&rpar.
.br
.br
:hp2.Converts any scalar type to a string.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.VALTOSTR&lpar. <xValue> &rpar. &minus.&minus.> cString:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xValue> is any scalar argument.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cString>  A string representation of <xValue> using default conversions.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.HB&us.VALTOSTR can be used to convert any scalar value to a string.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? HB&us.VALTOSTR&lpar. 4 &rpar.
.br
      ? HB&us.VALTOSTR&lpar. &cdq.String&cdq. &rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      ? HB&us.VALTOSTR&lpar. 4 &rpar. &eq.&eq. &cdq.         4&cdq.
.br
      ? HB&us.VALTOSTR&lpar. 4.0 &slash. 2 &rpar. &eq.&eq. &cdq.         2.00&cdq.
.br
      ? HB&us.VALTOSTR&lpar. &cdq.String&cdq. &rpar. &eq.&eq. &cdq.String&cdq.
.br
      ? HB&us.VALTOSTR&lpar. CTOD&lpar. &cdq.01&slash.01&slash.2001&cdq. &rpar. &rpar. &eq.&eq. &cdq.01&slash.01&slash.01&cdq.
.br
      ? HB&us.VALTOSTR&lpar. NIL &rpar. &eq.&eq. &cdq.NIL&cdq.
.br
      ? HB&us.VALTOSTR&lpar. .F. &rpar. &eq.&eq. &cdq..F.&cdq.
.br
      ? HB&us.VALTOSTR&lpar. .T. &rpar. &eq.&eq. &cdq..T.&cdq.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.HB&us.VALTOSTR&lpar.&rpar. is a Harbour enhancement.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=159.STR():elink.
.br
:h2 id=STRIY res=8.LEN()
:i2 refid=STRINX.LEN()
:p.LEN&lpar.&rpar.
.br
.br
:hp2.Returns size of a string or size of an array.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.LEN&lpar. <cString> &splitvbar. <aArray> &rpar. &minus.&minus.> <nLength>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<acString> is a character string or the array to check.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.The length of the string or the number of elements that contains  an array.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the string length or the size of an array. If  it is used with a multidimensional array it returns the size of the  first dimension.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? Len&lpar. &cdq.Harbour&cdq. &rpar. &minus.&minus.> 7
.br
      ? Len&lpar. &lbrc. &cdq.One&cdq.&comma. &cdq.Two&cdq. &rbrc. &rpar. &minus.&minus.> 2
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      function Test&lpar.&rpar.
.br
         LOCAL cName &colon.&eq. &cdq.&cdq.
.br
         ACCEPT &cdq.Enter your name&colon. &cdq. TO cName
.br
         ? Len&lpar. cName &rpar.
.br
      return nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.LEN&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=313.EMPTY():elink.
.br
:link reftype=hd res=305.RTRIM():elink.
.br
:link reftype=hd res=303.LTRIM():elink.
.br
:link reftype=hd res=2.AADD():elink.
.br
:link reftype=hd res=6.ASIZE():elink.
.br
:h2 id=CONVY res=313.EMPTY()
:i2 refid=CONVEX.EMPTY()
:p.EMPTY&lpar.&rpar.
.br
.br
:hp2.Checks if the passed argument is empty.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.EMPTY&lpar. <xExp> &rpar. &minus.&minus.> <lIsEmpty>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xExp> is any valid expression.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.A logical value. It is true &lpar..T.&rpar. if the passed argument is empty  otherwise it is false &lpar..F.&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function checks if an expression has empty value and returns a  logical indicating whether it the expression is empty or not.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? Empty&lpar. &cdq.I'm not empty&cdq. &rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      function Test&lpar.&rpar.
.br
         ? Empty&lpar. 1 &rpar.       &minus.&minus.> .f.
.br
         ? Empty&lpar. Date&lpar.&rpar. &rpar.  &minus.&minus.> .f.
.br
         ? Empty&lpar. .f. &rpar.     &minus.&minus.> .t.
.br
      return nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.EMPTY&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=8.LEN():elink.
.br
:h2 id=CONVY res=314.DESCEND()
:i2 refid=CONVEX.DESCEND()
:p.DESCEND&lpar.&rpar.
.br
.br
:hp2.Inverts an expression of string&comma. logical&comma. date or numeric type.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DESCEND&lpar. <xExp> &rpar. &minus.&minus.> <xExpInverted>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xExp> is any valid expression.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Inverted value of the same type as passed.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts an expression in his inverted form. It is  useful to build descending indexes.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Seek for Smith in a descending index
.br
      SEEK DESCEND&lpar. &cdq.SMITH&cdq. &rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      DATA&minus.>&lpar. DBSEEK&lpar. DESCEND&lpar. &cdq.SMITH&cdq. &rpar. &rpar. &rpar.
.br
      will seek &cdq.SMITH&cdq. into a descending index.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.DESCEND&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=315.INDEX:elink.
.br
:link reftype=hd res=316.SEEK:elink.
.br
:h2 id=STRIY res=317.HB_ANSITOOEM()
:i2 refid=STRINX.HB_ANSITOOEM()
:p.HB&us.ANSITOOEM&lpar.&rpar.
.br
.br
:hp2.Convert a windows Character to a Dos based character:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.ANSITOOEM&lpar.<cString>&rpar.  &minus.> cDosString:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString>  Windows ansi string to convert to DOS oem String
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cDosString> Dos based  string
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts each character in <cString> to the corresponding  character in the MS&minus.DOS &lpar.OEM&rpar. character set.The character expression  <cString> should contain characters from the ANSI character set.  If a
character in <cString> doesn't have a MS&minus.DOS equivalent&comma. the  character is converted to a similar MS&minus.DOS character.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? HB&us.OEMTOANSI&lpar.&cdq.Harbour&cdq.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.This functions work only on Windows Plataform
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=318.HB_OEMTOANSI():elink.
.br
:h2 id=STRIY res=318.HB_OEMTOANSI()
:i2 refid=STRINX.HB_OEMTOANSI()
:p.HB&us.OEMTOANSI&lpar.&rpar.
.br
.br
:hp2.Convert a DOS&lpar.OEM&rpar. Character to a WINDOWS &lpar.ANSI&rpar. based character:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.OEMTOANSI&lpar.<cString>&rpar.  &minus.> cDosString:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString>  DOS &lpar.OEM&rpar.  string to convert to WINDOWS &lpar.ANSI&rpar. String
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cDosString> WINDOWS based  string
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts each character in <cString> to the corresponding  character in the Windows &lpar.ANSI&rpar. character set.The character expression  <cString> should contain characters from the OEM character set.  If a
character in <cString> doesn't have a ANSI equivalent&comma. the  character is remais the same.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? HB&us.OEMTOANSI&lpar.&cdq.Harbour&cdq.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.This functions work only on Windows Plataform
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=317.HB_ANSITOOEM():elink.
.br
:h2 id=STRIY res=301.LOWER()
:i2 refid=STRINX.LOWER()
:p.LOWER&lpar.&rpar.
.br
.br
:hp2.Universally lowercases a character string expression.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.LOWER&lpar. <cString> &rpar. &minus.&minus.> cLowerString:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> Any character expression.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cLowerString> Lowercased value of <cString>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts any character expression passes as <cString>  to its lowercased representation.Any nonalphabetic character withing  <cString> will remain unchanged.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? Lower&lpar.&cdq.HARBOUR&cdq.&rpar.
.br
      ? Lower&lpar.&cdq.Hello All&cdq.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compatible
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.ALL
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=302.UPPER():elink.
.br
:link reftype=hd res=299.ISLOWER():elink.
.br
:link reftype=hd res=300.ISUPPER():elink.
.br
:h2 id=STRIY res=302.UPPER()
:i2 refid=STRINX.UPPER()
:p.UPPER&lpar.&rpar.
.br
.br
:hp2.Converts a character expression to uppercase format:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.UPPER&lpar. <cString> &rpar. &minus.&minus.> cUpperString:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> Any character expression.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cUpperString> Uppercased value of <cString>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts all alpha characters in <cString> to upper  case values and returns that formatted character expression.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? UPPER&lpar.&cdq.harbour&cdq.&rpar.
.br
      ? UPPER&lpar.&cdq.Harbour&cdq.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is CA&minus.Clipper compatible
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=301.LOWER():elink.
.br
:link reftype=hd res=300.ISUPPER():elink.
.br
:link reftype=hd res=299.ISLOWER():elink.
.br
:h2 id=STRIY res=179.CHR()
:i2 refid=STRINX.CHR()
:p.CHR&lpar.&rpar.
.br
.br
:hp2.Converts an ASCII value to it character value:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.CHR&lpar.<nAsciiNum>&rpar.  &minus.&minus.> cReturn:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nAsciiNum> Any ASCII character code.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cReturn> Character expression of that ASCII value
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the ASCII character code for <nAsciiNum>.The  number expressed must be an interger value within the range of 0 to  255 inclusive.The CHR&lpar.&rpar. function will send the character returned  to whatever
device is presently set.
.br
:p.The CHR&lpar.&rpar. function may be used for printing special codes as well  as normal and graphics character codes.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? CHR&lpar.32&rpar.
.br
      ? chr&lpar.215&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=319.ASC():elink.
.br
:link reftype=hd res=131.INKEY():elink.
.br
:h2 id=STRIY res=319.ASC()
:i2 refid=STRINX.ASC()
:p.ASC&lpar.&rpar.
.br
.br
:hp2.Returns the ASCII value of a character:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ASC&lpar. <cCharacter> &rpar. &minus.&minus.> nAscNumber:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cCharacter> Any character expression
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nAscNumber> ASCII value
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function return the ASCII value of the leftmost character of  any character expression passed as <cCharacter>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? ASC&lpar.&cdq.A&cdq.&rpar.
.br
      ? ASC&lpar.&cdq.&cdq.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=179.CHR():elink.
.br
:h2 id=STRIY res=320.PADC()
:i2 refid=STRINX.PADC()
:p.PADC&lpar.&rpar.
.br
.br
:hp2.Centers an expression for a given width:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.PADC&lpar.<xVal>&comma.<nWidth>&comma.<cFill>&rpar.  &minus.&minus.> cString:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xVal>    An number&comma.Character or date to pad
.br
:p.<nWidth>  Width of output string
.br
:p.<cFill>   Character to fill in the string
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> The Center string of <xVal>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function takes an date&comma.number&comma.or character expression <xVal>  and attempt to center the expression within a string of a given width  expressed as <nWidth>.The default character used to pad either side  of <xVal>
will be an blank space&semi.however&comma.this character may be  explicitly specified the value of <cFill>.
.br
:p.If the lenght of <xVal> is longer then <nWidth>&comma.this function will  truncate the string <xVal> from the leftmost side to the lenght of  <nWidth>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? PADC&lpar.'Harbour'&comma.20&rpar.
.br
      ? PADC&lpar.34.5142&comma.20&rpar.
.br
      ? PADC&lpar.Date&lpar.&rpar.&comma.35&rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See Examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compilant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=306.ALLTRIM():elink.
.br
:link reftype=hd res=321.PADL():elink.
.br
:link reftype=hd res=322.PADR():elink.
.br
:h2 id=STRIY res=321.PADL()
:i2 refid=STRINX.PADL()
:p.PADL&lpar.&rpar.
.br
.br
:hp2.Left&minus.justifies an expression for a given width:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.PADL&lpar.<xVal>&comma.<nWidth>&comma.<cFill>&rpar.  &minus.&minus.> cString:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xVal>    An number&comma.Character or date to pad
.br
:p.<nWidth>  Width of output string
.br
:p.<cFill>   Character to fill in the string
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> The left&minus.justifies string of <xVal>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function takes an date&comma.number&comma.or character expression <xVal>  and attempt to left&minus.justify it within a string of a given width  expressed as <nWidth>.The default character used to pad left side  of <xVal>
will be an blank space&semi.however&comma.this character may be  explicitly specified the value of <cFill>.
.br
:p.If the lenght of <xVal> is longer then <nWidth>&comma.this function will  truncate the string <xVal> from the leftmost side to the lenght of  <nWidth>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? PADC&lpar.'Harbour'&comma.20&rpar.
.br
      ? PADC&lpar.34.5142&comma.20&rpar.
.br
      ? PADC&lpar.Date&lpar.&rpar.&comma.35&rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compilant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=306.ALLTRIM():elink.
.br
:link reftype=hd res=320.PADC():elink.
.br
:link reftype=hd res=322.PADR():elink.
.br
:h2 id=STRIY res=322.PADR()
:i2 refid=STRINX.PADR()
:p.PADR&lpar.&rpar.
.br
.br
:hp2.Right&minus.justifies an expression for a given width:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.PADR&lpar.<xVal>&comma.<nWidth>&comma.<cFill>&rpar.  &minus.&minus.> cString:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xVal>    An number&comma.Character or date to pad
.br
:p.<nWidth>  Width of output string
.br
:p.<cFill>   Character to fill in the string
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> The right&minus.justifies string of <xVal>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function takes an date&comma.number&comma.or character expression <xVal>  and attempt to right&minus.justify it within a string of a given width  expressed as <nWidth>.The default character used to pad right side  of <xVal>
will be an blank space&semi.however&comma.this character may be  explicitly specified the value of <cFill>.
.br
:p.If the lenght of <xVal> is longer then <nWidth>&comma.this function will  truncate the string <xVal> from the leftmost side to the lenght of  <nWidth>.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? PADC&lpar.'Harbour'&comma.20&rpar.
.br
      ? PADC&lpar.34.5142&comma.20&rpar.
.br
      ? PADC&lpar.Date&lpar.&rpar.&comma.35&rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compilant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=306.ALLTRIM():elink.
.br
:link reftype=hd res=320.PADC():elink.
.br
:link reftype=hd res=321.PADL():elink.
.br
:h2 id=STRIY res=306.ALLTRIM()
:i2 refid=STRINX.ALLTRIM()
:p.ALLTRIM&lpar.&rpar.
.br
.br
:hp2.Removes leading and trailing blank spaces from a string:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ALLTRIM&lpar. <cString> &rpar. &minus.&minus.> cExpression:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString>   Any character string
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cExpression> An string will all blank spaces removed from <cString>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the string <cExpression> will all leading and  trailing blank spaces removed.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? ALLTRIM&lpar.&cdq.HELLO HARBOUR&cdq.&rpar.
.br
      ? ALLTRIM&lpar.&cdq.     HELLO HARBOUR&cdq.&rpar.
.br
      ? ALLTRIM&lpar.&cdq.HELLO HARBOUR     &cdq.&rpar.
.br
      ? ALLTRIM&lpar.&cdq.     HELLO HARBOUR     &cdq.&rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See Examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compilant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=303.LTRIM():elink.
.br
:link reftype=hd res=305.RTRIM():elink.
.br
:link reftype=hd res=304.TRIM():elink.
.br
:h2 id=STRIY res=305.RTRIM()
:i2 refid=STRINX.RTRIM()
:p.RTRIM&lpar.&rpar.
.br
.br
:hp2.Remove trailing spaces from a string.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.RTRIM&lpar.<cExpression>&rpar.   &minus.&minus.> cString:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cExpression>   Any character expression
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cString>       A formated string with out any blank spaced.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the value of <cString> with any trailing blank  removed.
.br
:p.This function is indentical to RTRIM&lpar.&rpar. and the opposite of LTRIM&lpar.&rpar..  Together with LTRIM&lpar.&rpar.&comma.this function equated to the ALLTRIM&lpar.&rpar.  function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? RTrim&lpar.&cdq.HELLO&cdq.&rpar.     &slash.&slash.               &cdq.HELLO&cdq.
.br
      ? RTrim&lpar. &cdq.&cdq. &rpar.       &slash.&slash.                &cdq.&cdq.
.br
      ? RTrim&lpar. &cdq.UA   &cdq. &rpar.  &slash.&slash.                &cdq.UA&cdq.
.br
      ? RTrim&lpar. &cdq.   UA&cdq. &rpar.  &slash.&slash.                &cdq.   UA&cdq.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See Examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compilant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=306.ALLTRIM():elink.
.br
:link reftype=hd res=303.LTRIM():elink.
.br
:link reftype=hd res=304.TRIM():elink.
.br
:h2 id=STRIY res=304.TRIM()
:i2 refid=STRINX.TRIM()
:p.TRIM&lpar.&rpar.
.br
.br
:hp2.Remove trailing spaces from a string.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.TRIM&lpar.<cExpression>&rpar.   &minus.&minus.> cString:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cExpression>   Any character expression
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cString>       A formated string with out any blank spaced.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the value of <cString> with any trailing blank  removed.
.br
:p.This function is indentical to RTRIM&lpar.&rpar. and the opposite of LTRIM&lpar.&rpar..  Together with LTRIM&lpar.&rpar.&comma.this function equated to the ALLTRIM&lpar.&rpar.  function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? Trim&lpar.&cdq.HELLO&cdq.&rpar.     &slash.&slash.               &cdq.HELLO&cdq.
.br
      ? Trim&lpar. &cdq.&cdq. &rpar.       &slash.&slash.                &cdq.&cdq.
.br
      ? Trim&lpar. &cdq.UA   &cdq. &rpar.  &slash.&slash.                &cdq.UA&cdq.
.br
      ? Trim&lpar. &cdq.   UA&cdq. &rpar.  &slash.&slash.                &cdq.   UA&cdq.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See Examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compilant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=305.RTRIM():elink.
.br
:link reftype=hd res=303.LTRIM():elink.
.br
:link reftype=hd res=306.ALLTRIM():elink.
.br
:h2 id=STRIY res=323.REPLICATE()
:i2 refid=STRINX.REPLICATE()
:p.REPLICATE&lpar.&rpar.
.br
.br
:hp2.Repeats a single character expression:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.REPLICATE&lpar.<cString>&comma.<nSize>&rpar.  &minus.&minus.> cReplicateString:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString>  Character string to be replicated
.br
:p.<nSize>    Number of times to replicate <cString>
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cReplicateString>  A character expression containg the <cString>  fill character.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a string composed of <nSize> repetitions of  <cString>.The lenght of the character string returned by this  function is limited to the memory avaliable.
.br
:p.A value of 0 for <nSize> will return a NULL string.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? Replicate&lpar.'a'&comma.10&rpar.    &slash.&slash. aaaaaaaaaa
.br
      ? Replicate&lpar.'b'&comma.100000&rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See Examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant in all aspects&comma. with the  exception don't have the Clipper 64Kb string length.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=324.SPACE():elink.
.br
:link reftype=hd res=320.PADC():elink.
.br
:link reftype=hd res=321.PADL():elink.
.br
:link reftype=hd res=322.PADR():elink.
.br
:h2 id=STRIY res=324.SPACE()
:i2 refid=STRINX.SPACE()
:p.SPACE&lpar.&rpar.
.br
.br
:hp2.Returns a string of blank spaces:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SPACE&lpar. <nSize> &rpar. &minus.&minus.> cString:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nSize>    The lenght of the string
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cString>  An string containing blank spaces
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a string consisting of <nSize> blank spaces. If  the value of <nSize> is 0&comma.a NULL string will be returned.
.br
:p.This function is useful to declare the lenght of a character memory  variable.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNC MAIN
.br
      LOCAL cBigString
.br
      LOCAL cFirst
.br
      LOCAL cString &colon.&eq. Space&lpar.20&rpar.   &slash.&slash.Create an characte memory variable
.br
                                   &slash.&slash. with lenght 20
.br
      ? len&lpar.cString&rpar.      &slash.&slash. 20
.br
      cBigString&colon.&eq.space&lpar.100000&rpar.    &slash.&slash. create a memory variable with 100000
.br
                                   &slash.&slash. blank spaces
.br
      ?  len&lpar.cBigString&rpar.
.br
      Use Tests New
.br
      cFirst&colon.&eq. makeempty&lpar.1&rpar.
.br
      ? len&lpar.cFirst&rpar.
.br
      Return Nil
.br

.br
      Function MakeEmpty&lpar.xField&rpar.
.br
      LOCAL nRecord
.br
      LOCAL xRetValue
.br

.br
      If !empty&lpar.alias&lpar.&rpar.&rpar.
.br
          nRecord&colon.&eq.recno&lpar.&rpar.
.br
          dbgoto&lpar.0&rpar.
.br
          if valtype&lpar.xField&rpar.&eq.&eq.&cdq.C&cdq.
.br
              xField&colon.&eq. ascan&lpar.dbstruct&lpar.&rpar.&comma.&lbrc.&splitvbar.aFields&splitvbar. aFields&lbrk.1&rbrk..&eq.&eq.upper&lpar.xfield&rpar.&rbrc.&rpar.
.br
          else
.br
              default xField to 0
.br
              if xField < 1 .or. xField>fcount&lpar.&rpar.
.br
                  xfield&colon.&eq.0
.br
              endif
.br
          endif
.br
          if !&lpar.xfield &eq.&eq.0&rpar.
.br
              xRetvalue&colon.&eq.fieldget&lpar.xfield&rpar.
.br
          endif
.br
          dbgoto&lpar.nrecord&rpar.
.br
      endif
.br
      return&lpar. xRetvalue&rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compliant in all aspects&comma. with the  exception don't have the Clipper 64Kb string length.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is Rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=320.PADC():elink.
.br
:link reftype=hd res=321.PADL():elink.
.br
:link reftype=hd res=322.PADR():elink.
.br
:link reftype=hd res=323.REPLICATE():elink.
.br
:h2 id=STRIY res=160.VAL()
:i2 refid=STRINX.VAL()
:p.VAL&lpar.&rpar.
.br
.br
:hp2.Convert a number from a character type to numeric:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.VAL&lpar. <cNumber> &rpar. &minus.&minus.> nNumber:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cNumber>   Any valid character string of numbers.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nNumber>   The numeric value of <cNumber>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function converts any number previosly defined as an character  expression <cNumber> into a numeric expression.
.br
:p.This functions is the oppose of the STR&lpar.&rpar. function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? VAL&lpar.'31421'&rpar. &slash.&slash. 31421
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See regression test
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compatible
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is RTL
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=159.STR():elink.
.br
:link reftype=hd res=35.TRANSFORM():elink.
.br
:h2 id=STRIY res=164.STRTRAN()
:i2 refid=STRINX.STRTRAN()
:p.STRTRAN&lpar.&rpar.
.br
.br
:hp2.Translate substring valuw with a main string:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.STRTRAN&lpar.  <cString>&comma. <cLocString>&comma. <cRepString>&comma. <nPos>&comma. <nOccurences> &rpar. &minus.&minus.> cReturn:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cString>     The main string to search
.br
:p.<cLocString>  The string to locate in the main string
.br
:p.<cRepString>  The string to replace the <cLocString>
.br
:p.<nPos>        The first occurence to be replaced
.br
:p.<nOccurences> Number of occurence to replace
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cReturn>  Formated string
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function searches for any occurence of <cLocString> in <cString>  and replacesit with <cRepString>.If <cRepString> is not specified&comma. a  NULL byte will replace <cLocString>.
.br
:p.If <nPos> is used&comma.its value defines the first occurence to be  replaced.The default value is 1.Additionally&comma.if used&comma.the value of  <nOccurences> tell the function how many occurrences of <cLocString>  in
<cString> are to the replaced.The default of <nOccurences> is  all occurrences.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? StrTran&lpar.&cdq.Harbour  Power&cdq.&comma.&cdq.  &cdq.&comma.&cdq. &cdq.&rpar. &slash.&slash. Harbour Power
.br
      ? StrTran&lpar.&cdq.Harbour  Power  The Future  of  xBase&cdq.&comma.&cdq.  &cdq.&comma.&cdq. &cdq.&comma.&comma.2&rpar. &slash.&slash. Harbour Power The future  of  xBase
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See regression test
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.Will not work with a search string of > 64 KB on some platforms
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Libraty is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=309.SUBSTR():elink.
.br
:link reftype=hd res=307.AT():elink.
.br
:h2 id=STRIY res=35.TRANSFORM()
:i2 refid=STRINX.TRANSFORM()
:p.TRANSFORM&lpar.&rpar.
.br
.br
:hp2.Formats a value based on a specific picture template.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.TRANSFORM&lpar. <xExpression>&comma. <cTemplate> &rpar.  &minus.&minus.> cFormated:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xExpression> Any expression to be formated.
.br
:p.<cTemplate>   Character string with picture template
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cFormated>   An formatted expression in character format
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns <xExpression> in the format of the picture  expression passed to the function as <cTemplate>.
.br
:p.Their are two components that can make up <cTemplate> &colon. a function  string and a template string.Function strings are those functions  that globally tell what the format of <xExpression> should be.These  functions are
represented by a single character precede by the  @ symbol.
.br
:p.There are a couple of rules to follow when using function strings  and template strings&colon.
.br
:p.&minus. First&comma. a single space must fall between the function template  and the template string if they are used in conjunction with  one another.
.br
:p.&minus. Second&comma.if both components make up the value of <cTemplate>&comma.the  function string must precede the template string.Otherwise&comma.the  function string may appear with out the template string and  vice versa.
.br
:p.The table below shows the possible function strings avaliable with  the TRANSFORM&lpar.&rpar. function.
.br
:table cols=' 2 48'.
:row.
:c.@B
:c.Left justify the string within the format.
:row.
:c.@C
:c.Issue a CR after format is numbers are positive.
:row.
:c.@D
:c.Put dates in SET DATE format.
:row.
:c.@E
:c.Put dates in BRITISH format.
:row.
:c.@L
:c.Make a zero padded string out of the number.
:row.
:c.@R
:c.Insert nontemplate characters.
:row.
:c.@X
:c.Issue a DB after format is numbers are negative.
:row.
:c.@Z
:c.Display any zero as blank spaces.
:row.
:c.@(
:c.Quotes around negative numbers
:row.
:c.@!
:c.Convert alpha characters to uppercased format.
:etable.
.br
.br
:p.The second part of <cTemplate> consists of the format string.Each  character in the string may be formated based on using the follow  characters as template markers for the string.
.br
:table cols=' 9 59'.
:row.
:c.A,N,X,9,#
:c.Any data type
:row.
:c.L
:c.Shows logical as "T" or "F"
:row.
:c.Y
:c.Shows logical as "Y" or "N"
:row.
:c.!
:c.Convert to uppercase
:row.
:c.$
:c.Dolar sing in place of leading spaces in numeric expression
:row.
:c.*
:c.Asterisks in place of leading spaces in numeric expression
:row.
:c.,
:c.Commas position
:row.
:c..
:c.Decimal point position
:etable.
.br
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      local cString &colon.&eq. 'This is harbour'
.br
      local nNumber &colon.&eq. 9923.34
.br
      local nNumber1 &colon.&eq. &minus.95842.00
.br
      Local lValue &colon.&eq. .T.
.br
      Local dDate &colon.&eq. DATE&lpar.&rpar.
.br
      ? 'working with String'
.br
      ? &cdq.Current String is&cdq. &comma.cString
.br
      ? &cdq.All uppercased&cdq.&comma.transform&lpar.cString&comma.&cdq.@!&cdq.&rpar.
.br
      ? &cdq.Date is&cdq.&comma.ddate
.br
      ? &cdq.Date is &cdq.&comma.transform&lpar.ddate&comma.&cdq.@D&cdq.&rpar.
.br
      ? Transform&lpar. nNumber        &comma. &cdq.@L 99999999&cdq.     &rpar.  &slash.&slash.     &comma. &cdq.009923.34&cdq.
.br
      ? Transform&lpar. 0         &comma. &cdq.@L 9999&cdq.     &rpar.       &slash.&slash.  &cdq.0000&cdq.
.br

.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See regression Test
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.The  @L function template is a FOXPRO&slash.Xbase Extension
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=32.@...SAY:elink.
.br
:link reftype=hd res=325.DEVOUTPICT():elink.
.br
:h1 CLASY.CLASSES
:h2  res=43.TClass()
:i1 id=CLASSX.CLASSES
:i2 refid=CLASSX.TCLASS()
:p.TClass&lpar.&rpar.
.br
.br
:hp2.TClass&lpar.&rpar. is used in the creation of all classes:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.oClass &colon.&eq. TClass&lpar.&rpar.&colon.New&lpar.&cdq.TMyClass&cdq.&rpar.:ehp2.
:p.:hp2.&minus.or&minus.:ehp2.
:p.:hp2.TClass&lpar.&rpar. is usually accessed by defining a class with the commands:ehp2.
:p.:hp2.defined in hbclass.h&colon.:ehp2.
:p.:hp2.CLASS TGetList    &slash.&slash. Calls TClass&lpar.&rpar. to create the TGetList class:ehp2.
:p.:hp2....:ehp2.
:p.:hp2.ENDCLASS:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.An instance of the TClass Class. This special object's &colon.New&lpar.&rpar.  method can then create the classes you define.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.TClass is a class that ...  The class methods are as follows&colon.
.br
:p.New&lpar.&rpar.                 Create a new instance of the class
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION TestObject&lpar.&rpar.
.br
      local oObject
.br

.br
      oObject &colon.&eq. TClass&lpar.&rpar.&colon.New&lpar.&cdq.TMyClass&cdq.&rpar.
.br
      oObject&colon.End&lpar.&rpar.
.br

.br
     RETURN Nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.Object Oriented syntax in Harbour is compatible with CA&minus.CLIPPER.  But Clipper only allowed creation of objects from a few standard  classes&comma. and did not let the programmer create new classes.  In Harbour&comma. you
can create your own classes&minus.&minus.complete with  Methods&comma. Instance Variables&comma. Class Variables and Inheritance.  Entire applications can be designed and coded in Object Oriented  style.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=184.__OBJHASDATA():elink.
.br
:link reftype=hd res=44.OBJECT ORIENTED PROGRAMMING:elink.
.br
:link reftype=hd res=42.CLASS:elink.
.br
:h2 id=DATAY res=326.__XSaveScreen()
:i2 refid=DATAX.__XSAVESCREEN()
:p.&us.&us.XSaveScreen&lpar.&rpar.
.br
.br
:hp2.Save whole screen image and coordinate to an internal buffer:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.XSaveScreen&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.none.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.XSaveScreen&lpar.&rpar. always return NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.XSaveScreen&lpar.&rpar. save the image of the whole screen into an internal  buffer&comma. it also save current cursor position. The information could  later be restored by &us.&us.XRestScreen&lpar.&rpar.. Each call to
&us.&us.XSaveScreen&lpar.&rpar.  overwrite the internal buffer.
.br
:p.SAVE SCREEN command is preprocessed into &us.&us.XSaveScreen&lpar.&rpar. function  during compile time. Note that SAVE SCREEN TO is preprocessed into  SAVESCREEN&lpar.&rpar. function.
.br
:p.&us.&us.XSaveScreen&lpar.&rpar. is a compatibility function&comma. it is superseded by  SAVESCREEN&lpar.&rpar. which allow you to save part or all the screen into a  variable.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. save the screen&comma. display list of files than restore the screen
.br
      SAVE SCREEN
.br
      DIR *.*
.br
      WAIT
.br
      RESTORE SCREEN
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.XSaveScreen&lpar.&rpar. works exactly like CA&minus.Clipper's &us.&us.XSaveScreen&lpar.&rpar.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.XSaveScreen&lpar.&rpar. is part of the GT API&comma. and supported only by some  platforms.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=327.RESTORE SCREEN:elink.
.br
:link reftype=hd res=328.RESTSCREEN():elink.
.br
:link reftype=hd res=329.SAVESCREEN():elink.
.br
:h2 id=COMMY res=330.SAVE SCREEN
:i2 refid=COMMAX.SAVE SCREEN
:p.SAVE SCREEN
.br
.br
:hp2.Save whole screen image and coordinate to an internal buffer:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SAVE SCREEN:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.none.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.SAVE SCREEN always return NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.SAVE SCREEN save the image of the whole screen into an internal  buffer&comma. it also save current cursor position. The information could  later be restored by REST SCREEN. Each call to SAVE SCREEN  overwrite the internal
buffer.
.br
:p.SAVE SCREEN command is preprocessed into &us.&us.XSaveScreen&lpar.&rpar. function  during compile time. Note that SAVE SCREEN TO is preprocessed into  SAVESCREEN&lpar.&rpar. function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. save the screen&comma. display list of files than restore the screen
.br
      SAVE SCREEN
.br
      DIR *.*
.br
      WAIT
.br
      RESTORE SCREEN
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.XSaveScreen&lpar.&rpar. works exactly like CA&minus.Clipper's &us.&us.XSaveScreen&lpar.&rpar.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.XSaveScreen&lpar.&rpar. is part of the GT API&comma. and supported only by some  platforms.
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=327.RESTORE SCREEN:elink.
.br
:link reftype=hd res=331.__XRESTSCREEN():elink.
.br
:link reftype=hd res=326.__XSAVESCREEN():elink.
.br
:h2 id=DATAY res=331.__XRestScreen()
:i2 refid=DATAX.__XRESTSCREEN()
:p.&us.&us.XRestScreen&lpar.&rpar.
.br
.br
:hp2.Restore screen image and coordinate from an internal buffer:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.XRestScreen&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.none.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.XRestScreen&lpar.&rpar. always return NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.XRestScreen&lpar.&rpar. restore saved image of the whole screen from an  internal buffer that was saved by &us.&us.XSaveScreen&lpar.&rpar.&comma. it also restore  cursor position. After a call to
&us.&us.XRestScreen&lpar.&rpar. the internal buffer  is cleared.
.br
:p.RESTORE SCREEN command is preprocessed into &us.&us.XRestScreen&lpar.&rpar. function  during compile time. Note that RESTORE SCREEN FROM is preprocessed  into RESTSCREEN&lpar.&rpar. function.
.br
:p.&us.&us.XRestScreen&lpar.&rpar. is a compatibility function&comma. it is superseded by  RESTSCREEN&lpar.&rpar. which allow you to restore the screen from a variable.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. save the screen&comma. display list of files than restore the screen
.br
      SAVE SCREEN
.br
      DIR *.*
.br
      WAIT
.br
      RESTORE SCREEN
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.XRestScreen&lpar.&rpar. works exactly like CA&minus.Clipper's &us.&us.XRestScreen&lpar.&rpar.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.XRestScreen&lpar.&rpar. is part of the GT API&comma. and supported only by some  platforms.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=331.__XRESTSCREEN():elink.
.br
:link reftype=hd res=330.SAVE SCREEN:elink.
.br
:link reftype=hd res=326.__XSAVESCREEN():elink.
.br
:h2 id=COMMY res=327.RESTORE SCREEN
:i2 refid=COMMAX.RESTORE SCREEN
:p.RESTORE SCREEN
.br
.br
:hp2.Restore screen image and coordinate from an internal buffer:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.RESTORE SCREEN:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.none.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.REST SCREEN always return NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Rest Screen restore saved image of the whole screen from an  internal buffer that was saved by Save Screen&comma. it also restore  cursor position. After a call to Rest Screen the internal buffer  is cleared.
.br
:p.RESTORE SCREEN command is preprocessed into &us.&us.XRestScreen&lpar.&rpar. function  during compile time. Note that RESTORE SCREEN FROM is preprocessed  into RESTSCREEN&lpar.&rpar. function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. save the screen&comma. display list of files than restore the screen
.br
      SAVE SCREEN
.br
      DIR *.*
.br
      WAIT
.br
      RESTORE SCREEN
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.Rest Screen&lpar.&rpar. works exactly like CA&minus.Clipper's Rest Screen
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.Rest Screen is part of the GT API&comma. and supported only by some  platforms.
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=331.__XRESTSCREEN():elink.
.br
:link reftype=hd res=330.SAVE SCREEN:elink.
.br
:link reftype=hd res=326.__XSAVESCREEN():elink.
.br
:h2 id=DATAY res=332.ALERT()
:i2 refid=DATAX.ALERT()
:p.ALERT&lpar.&rpar.
.br
.br
:hp2.Display a dialog box with a message:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.ALERT&lpar. <xMessage>&comma. &lbrk.<aOptions>&rbrk..&comma. &lbrk.<cColorNorm>&rbrk..&comma. &lbrk.<nDelay>&rbrk.. &rpar. &minus.&minus.> nChoice or NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xMessage> Message to display in the dialog box. <xMessage> can be  of any Harbour type.  If <xMessage> is an array of Character strings&comma. each element would  be displayed in a new line. If <xMessage> is a Character
string&comma. you could split the message to several lines by placing  a semicolon &lpar.&semi.&rpar. in the desired places.
.br
:p.<aOptions> Array with available response. Each element should be  Character string. If omitted&comma. default is &lbrc. &cdq.Ok&cdq. &rbrc..
.br
:p.<cColorNorm> Color string to paint the dialog box with.  If omitted&comma. default color is &cdq.W+&slash.R&cdq..
.br
:p.<nDelay> Number of seconds to wait to user response before abort.  Default value is 0&comma. that wait forever.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.ALERT&lpar.&rpar. return Numeric value representing option number chosen.  If ESC was pressed&comma. return value is zero. The return value is NIL  if ALERT&lpar.&rpar. is called with no parameters&comma. or if <xMessage> type is
not Character and HB&us.C52&us.STRICT option was used. If <nDelay> seconds  had passed without user response&comma. the return value is 1.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.ALERT&lpar.&rpar. display simple dialog box on screen and let the user select  one option. The user can move the highlight bar using arrow keys or  TAB key. To select an option the user can press ENTER&comma. SPACE or the  first
letter of the option.
.br
:p.If the program is executed with the &slash.&slash.NOALERT command line switch&comma.  nothing is displayed and it simply returns NIL. This switch could  be overridden with &us.&us.NONOALERT&lpar.&rpar..
.br
:p.If the GT system is linked in&comma. ALERT&lpar.&rpar. display the message using  the full screen I&slash.O system&comma. if not&comma. the information is printed to  the standard output using OUTSTD&lpar.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      LOCAL cMessage&comma. aOptions&comma. nChoice
.br

.br
      &slash.&slash. harmless message
.br
      cMessage &colon.&eq. &cdq.Major Database Corruption Detected!&semi.&cdq. +  &semi.
.br
                  &cdq.&lpar.deadline in few hours&rpar.&semi.&semi.&cdq.             +  &semi.
.br
                  &cdq.where DO you want to go today?&cdq.
.br

.br
      &slash.&slash. define response option
.br
      aOptions &colon.&eq. &lbrc. &cdq.Ok&cdq.&comma. &cdq.www.jobs.com&cdq.&comma. &cdq.Oops&cdq. &rbrc.
.br

.br
      &slash.&slash. show message and let end user select panic level
.br
      nChoice &colon.&eq. ALERT&lpar. cMessage&comma. aOptions &rpar.
.br
      DO CASE
.br
         CASE nChoice &eq.&eq. 0
.br
              &slash.&slash. do nothing&comma. blame it on some one else
.br
         CASE nChoice &eq.&eq. 1
.br
              ? &cdq.Please call home and tell them you're gonn'a be late&cdq.
.br
         CASE nChoice &eq.&eq. 2
.br
              &slash.&slash. make sure your resume is up to date
.br
         CASE nChoice &eq.&eq. 3
.br
              ? &cdq.Oops mode is not working in this version&cdq.
.br
      ENDCASE
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is sensitive to HB&us.C52&us.STRICT settings during the  compilation of source&slash.rtl&slash.alert.prg
.br
:p.:hp2.defined:ehp2.: <xMessage> accept Character values only and return  NIL if other types are passed.
.br
:p.:hp2.undefined:ehp2.: <xMessage> could be any type&comma. and internally  converted to Character string. If type is Array&comma. multi&minus.line message  is displayed.
.br
:p.:hp2.defined:ehp2.: Only the first four valid <aOptions> are taken.
.br
:p.:hp2.undefined:ehp2.: <aOptions> could contain as many as needed options.
.br
:p.If HB&us.COMPAT&us.C53 was define during compilation of  source&slash.rtl&slash.alert.prg the Left&minus.Mouse button could be used to select  an option.
.br
:p.The interpretation of the &slash.&slash.NOALERT command line switch is done only  if HB&us.C52&us.UNDOC was define during compilation of source&slash.rtl&slash.alert.prg
.br
:p.<cColorNorm> is a Harbour extension&comma. or at least un&minus.documented  in Clipper 5.2 NG.
.br
:p.<nDelay> is a Harbour extension.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=172.@...PROMPT:elink.
.br
:link reftype=hd res=166.MENU TO:elink.
.br
:link reftype=hd res=333.OUTSTD():elink.
.br
:link reftype=hd res=334.__NONOALERT():elink.
.br
:h2 id=DATAY res=334.__NONOALERT()
:i2 refid=DATAX.__NONOALERT()
:p.&us.&us.NONOALERT&lpar.&rpar.
.br
.br
:hp2.Override &slash.&slash.NOALERT command line switch:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.NONOALERT&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.This function takes no arguments.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.NONOALERT&lpar.&rpar. always return NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The &slash.&slash.NOALERT command line switch cause Clipper to ignore calls to  the ALERT&lpar.&rpar. function&comma. this function override this behavior  and always display ALERT&lpar.&rpar. dialog box.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. make sure alert are been displayed
.br
      &us.&us.NONOALERT&lpar.&rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.NONOALERT&lpar.&rpar. is an undocumented CA&minus.Clipper function and exist only  if HB&us.C52&us.UNDOC was defined during the compilation of  source&slash.rtl&slash.alert.prg
:h1 OPERY.OPERATING SYSTEM SPECIFIC
:h2  res=335.HB_OSNEWLINE()
:i1 id=OPERAX.OPERATING SYSTEM SPECIFIC
:i2 refid=OPERAX.HB_OSNEWLINE()
:p.HB&us.OSNEWLINE&lpar.&rpar.
.br
.br
:hp2.Returns the newline character&lpar.s&rpar. to use with the current OS:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.OSNewLine&lpar.&rpar. &minus.&minus.> cString:ehp2.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cString> A character string containing the character or characters  required to move the screen cursor or print head to the start of a  new line. The string will hold either CHR&lpar.10&rpar. or CHR&lpar.13&rpar. +
CHR&lpar.10&rpar..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Returns a character string containing the character or characters  required to move the screen cursor or print head to the start of a  new line for the operating system that the program is running on  &lpar.or thinks it is
running on&comma. if an OS emulator is being used&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Get the newline character&lpar.s&rpar. for the current OS using defaults.
.br
      STATIC s&us.cNewLine
.br
      ...
.br
      s&us.cNewLine &colon.&eq. HB&us.OSNewLine&lpar.&rpar.
.br
      ...
.br
      OutStd&lpar. &cdq.Hello World!&cdq. + s&us.cNewLine &rpar.
.br
      ...
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      valtype&lpar. HB&us.OSNewLine&lpar.&rpar. &rpar. &eq.&eq. &cdq.C&cdq.
.br
      LEN&lpar. HB&us.OSNewLine&lpar.&rpar. &rpar. &eq.&eq. 1
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This is an add&minus.on Operating System Tool function.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.Under OS&us.UNIX&us.COMPATIBLE operating system the return value is the  Line&minus.Feed &lpar.0x0a&rpar. character CHR&lpar.10&rpar.&comma. with other operating systems  &lpar.like DOS&rpar. the return value is the
Carriage&minus.Return plus Line&minus.Feed  &lpar.0x0d 0x0a&rpar. characters CHR&lpar.13&rpar.+CHR&lpar.10&rpar..
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=173.OS():elink.
.br
:link reftype=hd res=333.OUTSTD():elink.
.br
:link reftype=hd res=336.OUTERR():elink.
.br
:h1 GTY.GT
:h2  res=337.hb_ColorIndex()
:i1 id=GTX.GT
:i2 refid=GTX.HB_COLORINDEX()
:p.hb&us.ColorIndex&lpar.&rpar.
.br
.br
:hp2.Extract one color from a full Clipper colorspec string.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.hb&us.ColorIndex&lpar. <cColorSpec>&comma. <nIndex> &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cColorSpec> is a Clipper color list
.br
:p.<nIndex> is the position of the color item to be extracted&comma. the  first position is the zero.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.The selected color string&comma. or if anything goes wrong&comma. an empty  string.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Clipper has a color spec string&comma. which has more than one  color in it&comma. separated with commas. This function is able to extract  a given item from this list. You may use the manifest constants  defined in color.ch to
extract common Clipper colors.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      ? hb&us.ColorIndex&lpar. &cdq.W&slash.N&comma. N&slash.W&cdq.&comma. CLR&us.ENHANCED &rpar. &slash.&slash. &cdq.N&slash.W&cdq.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      see the regression test suit for comprehensive tests.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.Was not part of CA&minus.Clipper.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=338.COLORSELECT():elink.
.br
:h1 TERMY.TERMINAL
:h2  res=325.DEVOUTPICT()
:i1 id=TERMIX.TERMINAL
:i2 refid=TERMIX.DEVOUTPICT()
:p.DEVOUTPICT&lpar.&rpar.
.br
.br
:hp2.Displays a value to a device using a picture template:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.DEVOUTPICT&lpar.<xExp>&comma.<cPicture>&lbrk.&comma.<cColorString>&rbrk..&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xExp> is any valid expression.
.br
:p.<cPicture> is any picture transformation that TRANSFORM&lpar.&rpar. can use.
.br
:p.<cColorString> is an optional string that specifies a screen color to  use in place of the default color when the output goes to the screen.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.NIL
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Outputs any expression using a picture transformation instead of  using the default transformation for the type of expression.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Output a negative dollar amount using debit notation.
.br
      DEVOUTPICT&lpar. &minus.1.25&comma. &cdq.@D&dollar. 99&comma.999.99 &rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      @ 3&comma.1 SAY &minus.1.25 PICTURE &cdq.@D&dollar. 99&comma.999.99&cdq.
.br
      will display &cdq.&dollar.&lpar.     1.25&rpar.&cdq. starting on row four&comma. column two of the
.br
      current device &lpar.without the double quotation marks&comma. of course&rpar..
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.DEVOUTPICT&lpar.&rpar. is mostly CA&minus.Clipper compliant. Any differences are due  to enhancements in the Harbour TRANSFORM&lpar.&rpar. over CA&minus.Clipper.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=295.DEVOUT():elink.
.br
:link reftype=hd res=35.TRANSFORM():elink.
.br
:h2 id=DATAY res=287.__INPUT()
:i2 refid=DATAX.__INPUT()
:p.&us.&us.INPUT&lpar.&rpar.
.br
.br
:hp2.Stops application:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.INPUT&lpar. <cMessage> &rpar. &minus.&minus.> <cString>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cMessage> is any valid expression.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Macroed <cString>
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function waits for a console input and returns macroed  expression entered.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.INPUT&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=339.__WAIT():elink.
.br
:link reftype=hd res=286.__ACCEPT():elink.
.br
:h2 id=INTEY res=340.__TextSave()
:i2 refid=INTERX.__TEXTSAVE()
:p.&us.&us.TextSave&lpar.&rpar.
.br
.br
:hp2.Redirect console output to printer or file and save old settings:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.TextSave&lpar. <cFile> &rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFile> is either &cdq.PRINTER&cdq. &lpar.note the uppercase&rpar. in which console  output is SET to PRINTER&comma. or a name of a text file with a default  &cdq..txt&cdq. extension&comma. that is used to redirect console
output.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.TextSave&lpar.&rpar. always return NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.TextSave&lpar.&rpar. is used in the preprocessing of the TEXT TO command to  redirect the console output while saving old settings that can be  restored later by &us.&us.TextRestore&lpar.&rpar..
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.TextSave&lpar.&rpar. is an Undocumented CA&minus.Clipper function
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.ALL
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=100.SET():elink.
.br
:link reftype=hd res=288.SET ALTERNATE:elink.
.br
:link reftype=hd res=105.SET PRINTER:elink.
.br
:link reftype=hd res=341.TEXT:elink.
.br
:link reftype=hd res=342.__TEXTRESTORE():elink.
.br
:h2 id=INTEY res=342.__TextRestore()
:i2 refid=INTERX.__TEXTRESTORE()
:p.&us.&us.TextRestore&lpar.&rpar.
.br
.br
:hp2.Restore console output settings as saved by &us.&us.TextSave&lpar.&rpar.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.TextRestore&lpar.&rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.none.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.TextRestore&lpar.&rpar. always return NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.TextRestore&lpar.&rpar. is used in the preprocessing of the TEXT TO command  to restore console output settings that were previously saved by  &us.&us.TextSave&lpar.&rpar..
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.TextRestore&lpar.&rpar. is an Undocumented CA&minus.Clipper function
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=100.SET():elink.
.br
:link reftype=hd res=288.SET ALTERNATE:elink.
.br
:link reftype=hd res=105.SET PRINTER:elink.
.br
:link reftype=hd res=341.TEXT:elink.
.br
:link reftype=hd res=340.__TEXTSAVE():elink.
.br
:h2 id=EVENY res=339.__WAIT()
:i2 refid=EVENTX.__WAIT()
:p.&us.&us.WAIT&lpar.&rpar.
.br
.br
:hp2.Stops the application until a key is pressed.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.WAIT&lpar. <cMessage> &rpar. &minus.&minus.> <cKey>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cMessage> is a string.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Pressed key.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function stops the application until a key is pressed. The key  must be in the range 32..255. Control keys are not processed.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. Wait for a key stroke
.br
      &us.&us.Wait&lpar. &cdq.Press a key to continue&cdq. &rpar.
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      do while cKey !&eq. &cdq.Q&cdq.
.br
        cKey &colon.&eq. &us.&us.Wait&lpar. &cdq.Press 'Q' to continue&cdq. &rpar.
.br
      end do
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.WAIT&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=286.__ACCEPT():elink.
.br
:link reftype=hd res=287.__INPUT():elink.
.br
:h2 id=DATAY res=333.OUTSTD()
:i2 refid=DATAX.OUTSTD()
:p.OUTSTD&lpar.&rpar.
.br
.br
:hp2.Write a list of values to the standard output device:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.OUTSTD&lpar. <xExp&comma....> &rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xExp&comma....> is a list of expressions to display. Expressions are any  mixture of Harbour data types.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.OUTSTD&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.OUTSTD&lpar.&rpar. write one or more values into the standard output device.  Character and Memo values are printed as is&comma. Dates are printed  according to the SET DATE FORMAT&comma. Numeric values are converted to
strings&comma. Logical values are printed as .T. or .F.&comma. NIL are printed  as NIL&comma. values of any other kind are printed as empty string. There  is one space separating each two values. Note that Numeric value can  take
varying length when converted into string depending on its  source &lpar.see STR&lpar.&rpar. for detail&rpar..
.br
:p.OUTSTD&lpar.&rpar. is similar to QQOUT&lpar.&rpar. with the different that QQOUT&lpar.&rpar. send  its output to the Harbour console stream&comma. which can or can not be  redirected according with the screen driver&comma. and
OUTSTD&lpar.&rpar. send its  output to the standard output device &lpar.STDOUT&rpar. and can be redirected.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      OUTSTD&lpar. &cdq.Hello&cdq. &rpar.            &slash.&slash. Result&colon. Hello
.br

.br
      OUTSTD&lpar. 1&comma. .T.&comma. NIL&comma. &cdq.A&cdq. &rpar.
.br
      OUTSTD&lpar. &cdq.B&cdq. &rpar.                &slash.&slash. Result&colon.          1 .T. NIL AB
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.OUTSTD&lpar.&rpar. works exactly as in CA&minus.Clipper
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=343.?:elink.
.br
:link reftype=hd res=344.??:elink.
.br
:link reftype=hd res=295.DEVOUT():elink.
.br
:link reftype=hd res=325.DEVOUTPICT():elink.
.br
:link reftype=hd res=345.DISPOUT():elink.
.br
:link reftype=hd res=346.DISPOUTAT():elink.
.br
:link reftype=hd res=336.OUTERR():elink.
.br
:link reftype=hd res=347.QOUT():elink.
.br
:link reftype=hd res=348.QQOUT():elink.
.br
:link reftype=hd res=159.STR():elink.
.br
:h2 id=DATAY res=336.OUTERR()
:i2 refid=DATAX.OUTERR()
:p.OUTERR&lpar.&rpar.
.br
.br
:hp2.Write a list of values to the standard error device:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.OUTERR&lpar. <xExp&comma....> &rpar. &minus.&minus.> NIL:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xExp&comma....> is a list of expressions to display. Expressions are any  mixture of Harbour data types.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.OUTERR&lpar.&rpar. always returns NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.OUTERR&lpar.&rpar. write one or more values into the standard error device.  Character and Memo values are printed as is&comma. Dates are printed  according to the SET DATE FORMAT&comma. Numeric values are converted to
strings&comma. Logical values are printed as .T. or .F.&comma. NIL are printed  as NIL&comma. values of any other kind are printed as empty string. There  is one space separating each two values. Note that Numeric value can  take
varying length when converted into string depending on its  source &lpar.see STR&lpar.&rpar. for detail&rpar..
.br
:p.There is an undocumented CA&minus.Clipper command line switch &slash.&slash.STDERR  which can set the file handle to write output from OUTERR&lpar.&rpar.. If not  specified the default STDERR is used&comma. &slash.&slash.STDERR
or &slash.&slash.STDERR&colon.0 set  OUTERR&lpar.&rpar. to output to the same file handle as OUTSTD&lpar.&rpar.&comma. &slash.&slash.STDERR&colon.n  set output to file handle n. Like other undocumented features this  swit
ch is available only if source&slash.rtl&slash.console.c was compiled with  the HB&us.C52&us.UNDOC flag.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. write error log information
.br
      OUTERR&lpar. DATE&lpar.&rpar.&comma. TIME&lpar.&rpar.&comma. &cdq.Core meltdown detected&cdq. &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.OUTERR&lpar.&rpar. works exactly as in CA&minus.Clipper
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=343.?:elink.
.br
:link reftype=hd res=344.??:elink.
.br
:link reftype=hd res=295.DEVOUT():elink.
.br
:link reftype=hd res=325.DEVOUTPICT():elink.
.br
:link reftype=hd res=345.DISPOUT():elink.
.br
:link reftype=hd res=346.DISPOUTAT():elink.
.br
:link reftype=hd res=333.OUTSTD():elink.
.br
:link reftype=hd res=347.QOUT():elink.
.br
:link reftype=hd res=348.QQOUT():elink.
.br
:link reftype=hd res=159.STR():elink.
.br
:h2 id=COMMY res=349.EJECT
:i2 refid=COMMAX.EJECT
:p.EJECT
.br
.br
:hp2.Issue an command to advance the printer to the top of the form:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.EJECT:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command issue an form&minus.feed command to the printer.If the printer  is not properly hooked up to the computer&comma.an error will not be  generated and the command will be ignored.
.br
:p.Once completed&comma.the values of PROW&lpar.&rpar. and PCOL&lpar.&rpar.&comma.the row and column  indicators to the printer&comma.will be set to 0.Their values&comma.however&comma.may  be manipulated before or after ussuing an
EJECT by using the DEVPOS&lpar.&rpar.  function.
.br
:p.On compile time this command is translated into &us.&us.EJECT&lpar.&rpar. function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      Use Clientes New
.br
      Set Device to Printer
.br
      CurPos&colon.&eq.0
.br
      While !Eof&lpar.&rpar.
.br
      ? Clientes&minus.>nome&comma.Clientes&minus.>endereco
.br
      Curpos++
.br
      if Curpos >59
.br
          Curpos&colon.&eq.0
.br
          Eject
.br
      Endif
.br
      Enddo
.br
      Set Device to Screen
.br
      Use
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=350.DEVPOS():elink.
.br
:link reftype=hd res=105.SET PRINTER:elink.
.br
:link reftype=hd res=351.PROW():elink.
.br
:link reftype=hd res=352.PCOL():elink.
.br
:h2 id=DATAY res=353.READVAR()
:i2 refid=DATAX.READVAR()
:p.READVAR&lpar.&rpar.
.br
.br
:hp2.Return variable name of current GET or MENU:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.READVAR&lpar. &lbrk.<cVarName>&rbrk.. &rpar. &minus.&minus.> cOldVarName:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<cVarName>:ehp2.  is a new variable name to set.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.READVAR&lpar.&rpar. return the old variable name. If no variable previously  was set&comma. READVAR&lpar.&rpar. return &cdq.&cdq..
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.READVAR&lpar.&rpar. is set inside a READ or MENU TO command to hold the  uppercase name of the GET &slash. MENU TO variable&comma. and re&minus.set back to old  value when those commands finished. You should not normally set a
variable name but rather use it to retrieve the name of a GET  variable when executing a VALID or WHEN clause&comma. or during SET KEY  execution and you are inside a READ or MENU TO.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. display a menu&comma. press F1 to view the MENU TO variable name
.br
      CLS
.br
      @ 1&comma. 10 PROMPT &cdq.blood sucking insect that infect beds   &cdq.
.br
      @ 2&comma. 10 PROMPT &cdq.germ&semi. virus infection                   &cdq.
.br
      @ 3&comma. 10 PROMPT &cdq.defect&semi. snag&semi. &lpar.source of&rpar. malfunctioning&cdq.
.br
      @ 4&comma. 10 PROMPT &cdq.small hidden microphone                 &cdq.
.br
      @ 6&comma. 10 SAY &cdq.&lpar.Press F1 for a hint&rpar.&cdq.
.br
      SET KEY 28 TO ShowVar
.br
      MENU TO What&us.Is&us.Bug
.br

.br
      PROCEDURE ShowVar
.br
      ALERT&lpar. READVAR&lpar.&rpar. &rpar.        &slash.&slash. WHAT&us.IS&us.BUG in red ALERT&lpar.&rpar. box
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.READVAR&lpar.&rpar. works exactly like CA&minus.Clipper's READKEY&lpar.&rpar.&comma. note however&comma.  that the <cVarName> parameter is not documented and used internally  by CA&minus.Clipper.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=140.@...GET:elink.
.br
:link reftype=hd res=172.@...PROMPT:elink.
.br
:link reftype=hd res=166.MENU TO:elink.
.br
:link reftype=hd res=141.READ:elink.
.br
:link reftype=hd res=125.SET KEY:elink.
.br
:link reftype=hd res=167.__ATPROMPT():elink.
.br
:link reftype=hd res=171.__MENUTO():elink.
.br
:h2 id=COMMY res=354.LABEL FORM
:i2 refid=COMMAX.LABEL FORM
:p.LABEL FORM
.br
.br
:hp2.Displays labels to the screen or an alternate device:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.LABEL FORM <cLabelName> &lbrk.TO PRINTER&rbrk.. &lbrk.TO FILE <cFile>&rbrk.. &lbrk.<cScope>&rbrk.. &lbrk.WHILE <bWhile> &rbrk.. &lbrk.FOR <bFor> &rbrk.. &lbrk.SAMPLE&rbrk.. &lbrk.NOCONSOLE&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.<cLabelName>:ehp2.    Name of label file
.br
:p.:hp2.<cFile>:ehp2.         Name of an alternate file
.br
:p.:hp2.<cScope>:ehp2.        Expression of a scoping condition
.br
:p.:hp2.<bWhile>:ehp2.        WHILE condition
.br
:p.:hp2.<bFor>:ehp2.          FOR condition
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command allows labels to be printed based on the format outlined in  .LBL file specified as <cLabelName>. By default&comma. output will go to the  screen however this output may be rerouted with either the TO PRINTER or  the
TO FILE clause.
.br
:p.If the TO FILE clause is specified&comma. the name of the ASCII text file  containing the generated labels will be <cFile>.
.br
:p.If no file extension is specified a .TXT extension is added.  <cScope> is the scope condition for this command. Valid scopes include  NEXT <expN> &lpar.number of records to be displayed&comma. where <expN> is the number  of
records&rpar.&comma. RECORD <expN> &lpar.a specific record to be printed&rpar.&comma. REST &lpar.all  records starting from the current record position&comma.and ALL &lpar.all records&rpar..  The default is ALL.
.br
:p.Both logical expression may work ill conjunction with one another where  <bFor> is the logical expression for the FOR condition &lpar.for records to  be displayed whitin a given value range&rpar. and <bWhile> for the WHILE
condition &lpar.for records to be displayed until they fail to meet the  condition&rpar..
.br
:p.If the SAMPLE clause is specified&comma. test labels will be generated.
.br
:p.If the NOCONSOLE clause is specified&comma.the console will be turned off while  this command is being executed.
.br
:p.This command follows the search criteria outlined in the SET PATH TO  command. The path may be specified&comma. along&comma. with &lpar.the drive letter&comma. in  <cLabelName>
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION MAIN&lpar.&rpar.
.br
      USE Test New
.br
      LABEL FORM EE
.br
      USE
.br
      RETURN NIL
.br

.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is CA&minus.Clipper compliant.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.ALL
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is Rtl.lib
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=355.REPORT FORM:elink.
.br
:h2 id=COMMY res=355.REPORT FORM
:i2 refid=COMMAX.REPORT FORM
:p.REPORT FORM
.br
.br
:hp2.Display a report:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.REPORT FORM <cReportName> &lbrk.TO PRINTER&rbrk.. &lbrk.TO FILE <cFile>&rbrk.. &lbrk.<cScope>&rbrk.. &lbrk.WHILE <bWhile> &rbrk.. &lbrk.FOR <bFor> &rbrk.. &lbrk.PLAIN &splitvbar.HEADING <cHeading>&rbrk.. &lbrk.NOEJECT&rbrk..:ehp2.
:hp2.&lbrk.SUMMARY&rbrk.. &lbrk.NOCONSOLE&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cReportName> Name of report file
.br
:p.<cFile>       Name of alternate file
.br
:p.<cScope>      Scope.
.br
:p.<bWhile>      Logical expression of WHILE condition .
.br
:p.<bFor>        Logical expression of FOR condition.
.br
:p.<cHeading>    Report heading
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.NIL
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command prints out the report named <cReportName>&comma. which is a standard  FRM file. The file extension is not required because FRM will be assumed.  The SET PATH TO and SET DEFAULT TO commands affect the search for the
file  <cReportName>&semi. unless a drive and path are specified in <cReportName>&comma. REPORT  will search the path specified in the SET PATH command if it cannot find the  report form in the current directory.
.br
:p.The output of the report will be offset based on the setting of the SET MARGIN  TO value.
.br
:p.By default&comma. output will go to the console&semi. however&comma. it may be controlled via  either the TO PRINTER or TO FILE clause. If the output is to go to the file&comma.  the name of the alternate file is specified in
<cFile>. Unless specified in  <cFile>&comma. the default file extension will be .TXT .  <cScope> is the scope for this command. Valid scopes include NEXT <expN> &lpar.where  <expN> is tile number of records&rpar.&comma. RECORD
<expN> &lpar.a specific record to be  displayed&rpar.&comma. REST &lpar.all records from the current record position&rpar.&comma. and ALL  &lpar.all records&rpar.. The default is ALL.
.br
:p.Both logical expressions may work in conjuntion with one another&comma. where <bFor>  is the logical expression for the FOR condition &lpar.for records to be displayed  within a given range&rpar. and <bWhile> for the WHILE
condition &lpar.for records to be  displayed until the condition fails&rpar..
.br
:p.If the PLAIN clause is specified&comma. date and page numbers are suppressed. In  addition&comma. there is no  automatic page breaking&comma. and the report title and  column headings appear only once at the top of the form.
.br
:p.If the HEADING clause is used&comma. <cHeading> is displayed on the first title  of each report page. The value of <cHeading> is evaluated only once before  executing the report&semi. varying the values of <cHeading> is not
allowed. The  PLAIN clause will take precedence over the HEADING clause if both are included.
.br
:p.If the NOEJECT clause is used&comma. the initial page eject on the report will not be  issued when the output clause TO PRINTER is specified. Otherwise&comma. this clause has  no effect.
.br
:p.If the SUMMARY Clause is specified&comma. the report will contain only groups&comma. subgroups&comma.  and grand total information. The detailed title item information will be ignored.
.br
:p.If the NOCONSOLE clause is specified&comma.output to the console will be turned off  while this command is being executed.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION&lpar.&rpar. MAIN
.br
      USE Test New
.br
      Report FORM EE
.br
      USE
.br
      RETURN NIL
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This Command is CA&minus.Clipper compliant.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.ALL
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is Rtl.lib
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=354.LABEL FORM:elink.
.br
:h2 id=VARIY res=356.__MVPUBLIC()
:i2 refid=VARIAX.__MVPUBLIC()
:p.&us.&us.MVPUBLIC&lpar.&rpar.
.br
.br
:hp2.This function creates a PUBLIC variable:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.MVPUBLIC&lpar. <variable&us.name> &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<variable&us.name> &eq. either a string that contains the variable's name or  an one&minus.dimensional array of strings with variable names  No skeleton are allowed here.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Nothing
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function can be called either by the harbour compiler or by user.  The compiler always passes the item of IT&us.SYMBOL type that stores the  name of variable.  If a variable with the same name exists already then the new
variable is not created &minus. the previous value remains unchanged.  If it is first variable with this name then the  variable is  initialized with .T. value.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      None Avaliable
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
:h2 id=VARIY res=357.__MVPRIVATE()
:i2 refid=VARIAX.__MVPRIVATE()
:p.&us.&us.MVPRIVATE&lpar.&rpar.
.br
.br
:hp2.This function creates a PRIVATE variable:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.MVPRIVATE&lpar. <variable&us.name> &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<variable&us.name> &eq. either a string that contains the variable's name or  an one&minus.dimensional array of strings with variable names  No skeleton are allowed here.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Nothing
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function can be called either by the harbour compiler or by user.  The compiler always passes the item of IT&us.SYMBOL type that stores the  name of variable.  If a variable with the same name exists already then the value
of old  variable is hidden until the new variable is  released. The new variable  is always initialized to NIL value.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      None Avaliable
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
:h2 id=VARIY res=358.__MVXRELEASE()
:i2 refid=VARIAX.__MVXRELEASE()
:p.&us.&us.MVXRELEASE&lpar.&rpar.
.br
.br
:hp2.This function releases value stored in PRIVATE or PUBLIC variable:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.MVXRELEASE&lpar. <variable&us.name> &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<variable&us.name> &eq. either a string that contains the variable's name or  an one&minus.dimensional array of strings with variable names  No skeleton are allowed here.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Nothing
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function releases values stored in memory variable. It shouldn't  be called directly&comma. rather it should be placed into RELEASE command.  If the released variable is a PRIVATE variable then previously hidden  variable
with the same name becomes visible after exit from the  procedure where released variable was created. If you access  the released variable in the same function&slash.procedure where it  was created the the NIL value is returned.
You can however assign  a new value to released variable without any side effects.
.br
:p.It releases variable even if this variable was created in different  procedure
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
      PROCEDURE MAIN&lpar.&rpar.
.br
      PRIVATE mPrivate
.br

.br
        mPrivate &colon.&eq.&cdq.PRIVATE from MAIN&lpar.&rpar.&cdq.
.br
        ? mPrivate     &slash.&slash.PRIVATE from MAIN&lpar.&rpar.
.br
        Test&lpar.&rpar.
.br
        ? mPrivate     &slash.&slash.PRIVATE from MAIN&lpar.&rpar.
.br

.br
      RETURN
.br

.br
      PROCEDURE Test&lpar.&rpar.
.br
      PRIVATE mPrivate
.br

.br
        mPrivate &colon.&eq.&cdq.PRIVATE from Test&lpar.&rpar.&cdq.
.br
        ? mPrivate           &slash.&slash.PRIVATE from TEST&lpar.&rpar.
.br
        RELEASE mPrivate
.br
        ? mPrivate           &slash.&slash.NIL
.br
        mPrivate &colon.&eq.&cdq.Again in Test&lpar.&rpar.&cdq.
.br

.br
      RETURN
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
:h2 id=VARIY res=359.__MVRELEASE()
:i2 refid=VARIAX.__MVRELEASE()
:p.&us.&us.MVRELEASE&lpar.&rpar.
.br
.br
:hp2.This function releases PRIVATE variables:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.MVRELEASE&lpar. <skeleton>&comma. <include&us.exclude&us.flag> &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<skeleton> &eq. string that contains the wildcard mask for variables' names  that will be released. Supported wildcards&colon. '*' and '?'  <include&us.exclude&us.flag> &eq. logical value that specifies if variables  that match
passed skeleton should be either included in deletion  &lpar.if .T.&rpar. or excluded from deletion &lpar.if .F.&rpar.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Nothing
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function releases values stored in memory variables. It shouldn't  be called directly&comma. it should be placed into RELEASE ALL command.  If the released variable is a PRIVATE variable then previously hidden  variable with
the same name becomes visible after exit from the  procedure where released variable was created. If you access  the released variable in the same function&slash.procedure where it  was created the the NIL value is returned. You
can however assign  a new value to released variable without any side effects.  PUBLIC variables are not changed by this function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      None Avaliable
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
:h2 id=VARIY res=360.__MVSCOPE()
:i2 refid=VARIAX.__MVSCOPE()
:p.&us.&us.MVSCOPE&lpar.&rpar.
.br
.br
:hp2.If variable exists then returns its scope.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.MVSCOPE&lpar. <cVarName> &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cVarName> &eq. a string with a variable name to check
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.The symbolic values are defined in include&slash.hbmemvar.ch  HB&us.MV&us.NOT&us.FOUND     &eq.variable is not declared &lpar.not found in symbol table&rpar.  HB&us.MV&us.UNKNOWN       &eq.if variable doesn't exist &lpar.but
found in symbol table&rpar.  HB&us.MV&us.ERROR         &eq.if information cannot be obtained &lpar.memory error  or argument error&rpar.  HB&us.MV&us.PUBLIC         &eq.for public variables  HB&us.MV&us.PRIVATE&us.GLOBAL
&eq.for private variables declared outside of current  function&slash.procedure  HB&us.MV&us.PRIVATE&us.LOCAL  &eq.for private variables declared in current  function&slash.procedure
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
      PROCEDURE MAIN&lpar.&rpar.
.br
      PUBLIC mPublic
.br
      PRIVATE mPrivateGlobal
.br

.br
      CallProc&lpar.&rpar.
.br
      ? &us.&us.mvScope&lpar. &cdq.mPrivateLocal&cdq. &rpar.      &slash.&slash.HB&us.MV&us.UNKNOWN
.br

.br
      RETURN
.br

.br
      PROCEDURE CallProc&lpar.&rpar.
.br
      PRIVATE mPrivateLocal
.br

.br
      ? &us.&us.mvScope&lpar. &cdq.mPublic&cdq. &rpar.            &slash.&slash.HB&us.MV&us.PUBLIC
.br
      ? &us.&us.mvScope&lpar. &cdq.mPrivateGlobal&cdq. &rpar.     &slash.&slash.HB&us.MV&us.PRIVATE&us.GLOBAL
.br
      ? &us.&us.mvScope&lpar. &cdq.mPrivateLocal&cdq. &rpar.      &slash.&slash.HB&us.MV&us.PRIVATE&us.LOCAL
.br
      ? &us.&us.mvScope&lpar. &cdq.mFindMe&cdq. &rpar.            &slash.&slash.HB&us.MV&us.NOT&us.FOUND
.br

.br
      IF&lpar. &us.&us.mvScope&lpar. &cdq.mPublic&cdq. &rpar. > HB&us.MV&us.ERROR &rpar.
.br
         ? &cdq.Variable exists&cdq.
.br
      ELSE
.br
         ? &cdq.Variable not created yet&cdq.
.br
      ENDIF
.br

.br
      RETURN
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour Extension
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=361.INCLUDE/HBMEMVAR.CH:elink.
.br
:h2 id=VARIY res=362.__MVCLEAR()
:i2 refid=VARIAX.__MVCLEAR()
:p.&us.&us.MVCLEAR&lpar.&rpar.
.br
.br
:hp2.This function releases all PRIVATE and PUBLIC variables:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.MVCLEAR&lpar.&rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Nothing
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function releases all PRIVATE and PUBLIC variables.  It is used to implement CLEAR MEMORY statement.  The memory occupied by all visible variables are released &minus. any  attempt to access the variable will result in a
runtime error.  You have to reuse PRIVATE or PUBLIC statement to create again  the variable that was cleared by this function.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=356.__MVPUBLIC():elink.
.br
:h2 id=VARIY res=363.__MVDBGINFO()
:i2 refid=VARIAX.__MVDBGINFO()
:p.&us.&us.MVDBGINFO&lpar.&rpar.
.br
.br
:hp2.This function returns the information about the variables for debugger:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.MVDBGINFO&lpar. <nScope> &lbrk.&comma. <nPosition> &lbrk.&comma. @<cVarName>&rbrk.. &rbrk.. &rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nScope> &eq. the scope of variables for which an information is asked  Supported values &lpar.defined in hbmemvar.ch&rpar.  HB&us.MV&us.PUBLIC  HB&us.MV&us.PRIVATE &lpar.or any other value&rpar.  <nPosition> &eq. the position of
asked variable on the list of variables  with specified scope &minus. it should start from position 1  <cVarName> &eq. the value is filled with a variable name if passed by  reference and <nPosition> is specified
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.The return value depends on the number of arguments passed
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function retrieves the information about memvar variables.  It returns either the number of variables with given scope &lpar.when the  first argument is passed only&rpar. or a value of variable identified by its  position in
the variables' list &lpar.when second argument is passed&rpar..  It also returns the name of a variable if optional third argument  is passed by reference.
.br
:p.If requested variable doesn't exist &lpar.requested position is  greater then the number of defined variables&rpar. then NIL value is  returned and variable name is set to &cdq.?&cdq.
.br
:p.The dynamic symbols table is used to find a PUBLIC variable then  the PUBLIC variables are always sorted alphabetically. The PRIVATE  variables are sorted in the creation order.
.br
:p.Note&colon.  Due to dynamic nature of memvar variables there is no guarantee that  successive calls to retrieve the value of <Nth> PUBLIC variable will  return the value of the same variable.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
.br

.br
      #include <hbmemvar.ch>
.br

.br
      LOCAL nCount&comma. i&comma. xValue&comma. cName
.br

.br
      nCount &eq.&us.mvDBGINFO&lpar. HB&us.MV&us.PUBLIC &rpar.
.br
      FOR i&colon.&eq.1 TO nCount
.br
          xValue &eq.&us.&us.mvDBGINFO&lpar. HB&us.MV&us.PUBLIC&comma. i&comma. @cName &rpar.
.br
          ? i&comma. cName&comma. xValue
.br
      NEXT
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      #include <hbmemvar.ch>
.br
      PROCEDURE MAIN&lpar.&rpar.
.br

.br
      ? 'PUBLIC&eq.'&comma. &us.&us.mvDBGINFO&lpar. HB&us.MV&us.PUBLIC &rpar.
.br
      ? 'PRIVATE&eq.'&comma. &us.&us.mvDBGINFO&lpar. HB&us.MV&us.PRIVATE &rpar.
.br

.br
      PUBLIC cPublic&colon.&eq.'cPublic in MAIN'
.br

.br
      ? 'PUBLIC&eq.'&comma. &us.&us.mvDBGINFO&lpar. HB&us.MV&us.PUBLIC &rpar.
.br
      ? 'PRIVATE&eq.'&comma. &us.&us.mvDBGINFO&lpar. HB&us.MV&us.PRIVATE &rpar.
.br

.br
      PRIVATE cPrivate&colon.&eq.'cPrivate in MAIN'
.br

.br
      ? 'PUBLIC&eq.'&comma. &us.&us.mvDBGINFO&lpar. HB&us.MV&us.PUBLIC &rpar.
.br
      ? 'PRIVATE&eq.'&comma. &us.&us.mvDBGINFO&lpar. HB&us.MV&us.PRIVATE &rpar.
.br

.br
      CountMemvars&lpar.&rpar.
.br

.br
      ? 'Back in Main'
.br
      ? 'PUBLIC&eq.'&comma. &us.&us.mvDBGINFO&lpar. HB&us.MV&us.PUBLIC &rpar.
.br
      ? 'PRIVATE&eq.'&comma. &us.&us.mvDBGINFO&lpar. HB&us.MV&us.PRIVATE &rpar.
.br

.br

.br
      RETURN
.br

.br
      PROCEDURE CountMemvars&lpar.&rpar.
.br
      LOCAL i&comma. nCnt&comma. xVal&comma. cName
.br
      PUBLIC ccPublic&colon.&eq.'ccPublic'
.br
      PRIVATE ccPrivate&colon.&eq.'ccPrivate'
.br

.br
      ? 'In CountMemvars'
.br
      ? 'PUBLIC&eq.'&comma. &us.&us.mvDBGINFO&lpar. HB&us.MV&us.PUBLIC &rpar.
.br
      ? 'PRIVATE&eq.'&comma. &us.&us.mvDBGINFO&lpar. HB&us.MV&us.PRIVATE &rpar.
.br

.br
      PRIVATE cPublic&colon.&eq.'cPublic'
.br

.br
      ? 'PUBLIC&eq.'&comma. &us.&us.mvDBGINFO&lpar. HB&us.MV&us.PUBLIC &rpar.
.br
      ? 'PRIVATE&eq.'&comma. &us.&us.mvDBGINFO&lpar. HB&us.MV&us.PRIVATE &rpar.
.br

.br
      nCnt &eq.&us.&us.mvDBGINFO&lpar. HB&us.MV&us.PRIVATE &rpar. +1
.br
      FOR i&colon.&eq.1 TO nCnt
.br
        xVal &eq.&us.&us.mvDBGINFO&lpar. HB&us.MV&us.PRIVATE&comma. i&comma. @cName &rpar.
.br
        ? i&comma. '&eq.'&comma. cName&comma. xVal
.br
      NEXT
.br

.br
      nCnt &eq.&us.&us.mvDBGINFO&lpar. HB&us.MV&us.PUBLIC &rpar. +1
.br
      FOR i&colon.&eq.1 TO nCnt
.br
        xVal &eq.&us.&us.mvDBGINFO&lpar. HB&us.MV&us.PUBLIC&comma. i&comma. @cName &rpar.
.br
        ? i&comma. '&eq.'&comma. cName&comma. xVal
.br
      NEXT
.br

.br
      RETURN
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function should be called from the debugger only.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
:h2 id=VARIY res=364.__MVGET()
:i2 refid=VARIAX.__MVGET()
:p.&us.&us.MVGET&lpar.&rpar.
.br
.br
:hp2.This function returns value of memory variable:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.MVGET&lpar. <cVarName> &rpar.  &minus.&minus.> <xVar>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cVarName> &minus. string that specifies the name of variable
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<xVar> The value of variable
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns the value of PRIVATE or PUBLIC variable if  this variable exists otherwise it generates a runtime error.  The variable is specified by its name passed as the function parameter.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION MEMVARBLOCK&lpar. cMemvar &rpar.
.br
      RETURN &lbrc.&splitvbar.x&splitvbar. IIF&lpar. PCOUNT&lpar.&rpar.&eq.&eq.0&comma. &us.&us.MVGET&lpar. cMemvar &rpar.&comma.&semi.
.br
      &us.&us.MVPUT&lpar. cMemvar&comma. x &rpar. &rpar. &rbrc.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=365.__MVPUT():elink.
.br
:h2 id=VARIY res=365.__MVPUT()
:i2 refid=VARIAX.__MVPUT()
:p.&us.&us.MVPUT&lpar.&rpar.
.br
.br
:hp2.This function set the value of memory variable:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.&us.&us.MVGET&lpar. <cVarName> &lbrk.&comma. <xValue>&rbrk.. &rpar.  &minus.&minus.> <xValue>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cVarName> &minus. string that specifies the name of variable  <xValue>   &minus. a value of any type that will be set &minus. if it is not  specified then NIL is assumed
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<xValue> A value assigned to the given variable.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function sets the value of PRIVATE or PUBLIC variable if  this variable exists otherwise it generates a runtime error.  The variable is specified by its name passed as the function  parameter.  If a value is not specified
then the NIL is assumed
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNCTION MEMVARBLOCK&lpar. cMemvar &rpar.
.br
      RETURN &lbrc.&splitvbar.x&splitvbar. IIF&lpar. PCOUNT&lpar.&rpar.&eq.&eq.0&comma. &us.&us.MVGET&lpar. cMemvar &rpar.&comma.&semi.
.br
      &us.&us.MVPUT&lpar. cMemvar&comma. x &rpar. &rpar. &rbrc.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=365.__MVPUT():elink.
.br
:h2 id=VARIY res=366.MEMVARBLOCK()
:i2 refid=VARIAX.MEMVARBLOCK()
:p.MEMVARBLOCK&lpar.&rpar.
.br
.br
:hp2.Returns a codeblock that sets&slash.gets a value of memvar variable:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.MEMVARBLOCK&lpar. <cMemvarName> &rpar. &minus.&minus.> <bBlock>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cMemvarName> &minus. a string that contains the name of variable
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<bBlock> a codeblock that sets&slash.get the value of variable
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a codeblock that sets&slash.gets the value of  PRIVATE or PUBLIC variable. When this codeblock is evaluated  without any parameters passed then it returns the current value  of given variable. If the second
parameter is passed for  the codeblock evaluation then its value is used to set the new  value of given variable &minus. the passed value is also returned  as a value of the codeblock evaluation.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      PROCEDURE MAIN&lpar.&rpar.
.br
      LOCAL cbSetGet
.br
      PUBLIC xPublic
.br

.br
      cbSetGet &eq. MEMVARBLOCK&lpar. &cdq.xPublic&cdq. &rpar.
.br
      EVAL&lpar. cbSetGet&comma. &cdq.new value&cdq. &rpar.
.br
      ? &cdq.Value of xPublic variable&cdq.&comma. EVAL&lpar. cbSetGet &rpar.
.br

.br
      RETURN
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca&minus.Clipper compatible
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=364.__MVGET():elink.
.br
:link reftype=hd res=365.__MVPUT():elink.
.br
:h1 CODEY.CODE BLOCK
:h2  res=367.FIELDBLOCK()
:i1 id=CODEX.CODE BLOCK
:i2 refid=CODEX.FIELDBLOCK()
:p.FIELDBLOCK&lpar.&rpar.
.br
.br
:hp2.Return a code block that sets&slash.gets a value for a given field:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FIELDBLOCK&lpar. <cFieldName> &rpar. &minus.&minus.> bFieldBlock:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFieldName> is a string that contain the field name.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.FIELDBLOCK&lpar.&rpar. return a code block that when evaluate could retrieve  field value or assigning a new value to the field. If <cFieldName>  is not specified or from type other than character&comma. FIELDBLOCK&lpar.&rpar.
return NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.FIELDBLOCK&lpar.&rpar. return a code block that sets&slash.gets the value of field.  When this code block is evaluated without any parameters passed then  it returns the current value of the given field. If the code block  is
evaluated with a parameter&comma. than its value is used to set a new  value to the field&comma. this value is also return by the block. If the  block is evaluate and there is no field with the name <cFieldName>  in the current
work area&comma. the code block return NIL.
.br
:p.Note that FIELDBLOCK&lpar.&rpar. works on the current work area&comma. if you need  a specific work area code block use FIELDWBLOCK&lpar.&rpar. instead.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      &slash.&slash. open a file named Test that have a field named &cdq.name&cdq.
.br
      LOCAL bField
.br
      bFiled &colon.&eq. FIELDBLOCK&lpar. &cdq.name&cdq. &rpar.
.br
      USE Test
.br
      ? 'Original value of field &cdq.name&cdq. &colon.'&comma. EVAL&lpar. bField &rpar.
.br
      EVAL&lpar. bField&comma. &cdq.Mr X new name&cdq. &rpar.
.br
      ? 'New value for the field &cdq.name&cdq. &colon.'&comma. EVAL&lpar. bField &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.If the block is evaluate and there is no field with the name  <cFieldName> in the current work area&comma. the code block return NIL.
.br
:p.CA&minus.Clipper would raise BASE&slash.1003 error if the field does not exist.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=14.EVAL():elink.
.br
:link reftype=hd res=368.FIELDWBLOCK():elink.
.br
:link reftype=hd res=366.MEMVARBLOCK():elink.
.br
:h2 id=CODEY res=368.FIELDWBLOCK()
:i2 refid=CODEX.FIELDWBLOCK()
:p.FIELDWBLOCK&lpar.&rpar.
.br
.br
:hp2.Return a sets&slash.gets code block for field in a given work area:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.FIELDWBLOCK&lpar. <cFieldName>&comma. <nWorkArea> &rpar. &minus.&minus.> bFieldBlock:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cFieldName> is a string that contain the field name.
.br
:p.<nWorkArea> is the work area number in which <cFieldName> exist.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.FIELDWBLOCK&lpar.&rpar. return a code block that when evaluate could retrieve  field value or assigning a new value for a field in a given work  area. If <cFieldName> is not specified or from type other than  character&comma. or
if <nWorkArea> is not specified or is not numeric  FIELDWBLOCK&lpar.&rpar. return NIL.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.FIELDWBLOCK&lpar.&rpar. return a code block that sets&slash.gets the value of field  from a given work area. When this code block is evaluated without  any parameters passed then it returns the current value of the given  field.
If the code block is evaluated with a parameter&comma. than its  value is used to set a new value to the field&comma. this value is also  return by the block. If the block is evaluate and there is no field  with the name
<cFieldName> in work area number <nWorkArea>&comma. the code  block return NIL.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      LOCAL bField
.br
      &slash.&slash. this block work on the field &cdq.name&cdq. that exist on work area 2
.br
      bFiled &colon.&eq. FIELDBLOCK&lpar. &cdq.name&cdq.&comma. 2 &rpar.
.br
      &slash.&slash. open a file named One in work area 1
.br
      &slash.&slash. that have a field named &cdq.name&cdq.
.br
      SELECT 1
.br
      USE One
.br
      &slash.&slash. open a file named Two in work area 2
.br
      &slash.&slash. it also have a field named &cdq.name&cdq.
.br
      SELECT 2
.br
      USE Two
.br
      SELECT 1
.br
      ? &cdq.Original names&colon. &cdq.&comma. One&minus.>name&comma. Two&minus.>name
.br
      ? &cdq.Name value for file Two &colon.&cdq.&comma. EVAL&lpar. bField &rpar.
.br
      EVAL&lpar. bField&comma. &cdq.Two has new name&cdq. &rpar.
.br
      ? &cdq.and now&colon. &cdq.&comma. One&minus.>name&comma. Two&minus.>name
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.If the block is evaluate and there is no field with the name  <cFieldName> in the given work area&comma. the code block return NIL.
.br
:p.CA&minus.Clipper would raise BASE&slash.1003 error if the field does not exist.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=14.EVAL():elink.
.br
:link reftype=hd res=367.FIELDBLOCK():elink.
.br
:link reftype=hd res=366.MEMVARBLOCK():elink.
.br
:h2 id=MISCY res=266.TYPE()
:i2 refid=MISCX.TYPE()
:p.TYPE&lpar.&rpar.
.br
.br
:hp2.Retrieves the type of an expression:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.TYPE&lpar. <cExp> &rpar. &minus.&minus.> <cRetType>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cExp> must be a character expression.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cRetType> a string indicating the type of the passed expression.
.br
:table cols='16 57'.
:row.
:c.&lt.cRetType&gt.
:c.Meaning
:row.
:c.
:row.
:c."A"
:c.array
:row.
:c."B"
:c.block
:row.
:c."C"
:c.string
:row.
:c."D"
:c.date
:row.
:c."L"
:c.logical
:row.
:c."M"
:c.memo
:row.
:c."N"
:c.numeric
:row.
:c."O"
:c.object
:row.
:c."U"
:c.NIL, local, or static variable, or not linked-in function
:row.
:c."UE"
:c.syntax error in the expression or invalid arguments
:row.
:c."UI"
:c.function with non-reserved name was requested
:etable.
.br
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns a string which represents the data type  of the argument. The argument can be any valid Harbour expression.  If there is a syntax error in passed expression then &cdq.UE&cdq. is returned.  If there is a call
for any non&minus.reserved Harbour function then &cdq.UI&cdq.  is returned &lpar.in other words there is no call for passed UDF function  during a data type determination &minus. this is Clipper compatible  behavior&rpar..
Additionally if requested user defined function is not  linked into executable then &cdq.U&cdq. is returned.
.br
:p.The data type of expression is checked by invoking a macro compiler  and by evaluation of generated code &lpar.if there is no syntax errors&rpar..  This causes that TYPE&lpar.&rpar. cannot determine a type of local or static
variables &minus. only symbols visible at runtime can be checked.
.br
:p.Notice the subtle difference between TYPE and VALTYPE functions.  VALTYPE&lpar.&rpar. function doesn't call a macro compiler &minus. it simply checks  the type of passed argument of any type. TYPE&lpar.&rpar. requires a string
argument with a valid Harbour expression &minus. the data type of this  expression is returned.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
       ? TYPE&lpar. &cdq.&lbrc. 1&comma. 2 &rbrc.&cdq. &rpar.                            &slash.&slash.prints &cdq.A&cdq.
.br
       ? TYPE&lpar. &cdq.IIF&lpar..T.&comma. SUBSTR&lpar.'TYPE'&comma.2&comma.1&rpar.&comma. .F.&rpar.&cdq. &rpar.   &slash.&slash.prints &cdq.C&cdq.
.br
       ? TYPE&lpar. &cdq.AT&lpar. 'OK'&comma. MyUDF&lpar.&rpar.&rpar.>0&cdq. &rpar.                &slash.&slash.prints &cdq.UI&cdq.
.br
       ? TYPE&lpar. &cdq.&lbrc. 1&comma. 2 &rbrc.&lbrk. 5 &rbrk..&cdq. &rpar.                       &slash.&slash.prints &cdq.UE&cdq.
.br

.br
       &slash.&slash.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
.br

.br
       LOCAL c
.br
       PRIVATE a&colon.&eq.&cdq.A&cdq.&comma. b&colon.&eq.&cdq.B&cdq.
.br
       ? TYPE&lpar. &cdq.a + b + c&cdq. &rpar.     &slash.&slash.prints&colon. &cdq.U&cdq. &lpar.'C' variable is a local one&rpar.
.br

.br
       &slash.&slash.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
.br

.br
       LOCAL cFilter &colon.&eq. SPACE&lpar. 60 &rpar.
.br
       ACCEPT &cdq.Enter filter expression&colon.&cdq. TO cFilter
.br
       IF&lpar. TYPE&lpar. cFilter &rpar. &dollar. &cdq.CDLMN&cdq. &rpar. &rpar.
.br
          &slash.&slash. this is a valid expression
.br
          SET FILTER TO &amp.cFilter
.br
       ENDIF
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
.br
:p.&minus. Incompatibility with Clipper&colon.  In the following code&colon.
.br
:p.PRIVATE lCond &colon.&eq. 0  ? TYPE&lpar. &cdq.IIF&lpar. lCond&comma. 'true'&comma. MyUDF&lpar.&rpar. &rpar.&cdq. &rpar.
.br
:p.Clipper will print &cdq.UE&cdq. &minus. in Harbour the output will be &cdq.UI&cdq.
.br
:p.&minus. if &cdq.UI&cdq. is returned then the syntax of the expression is  correct. However invalid arguments can be passed to  function&slash.procedure that will cause runtime errors during  evaluation of expression.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=269.VALTYPE():elink.
.br
:h2 id=MISCY res=269.VALTYPE()
:i2 refid=MISCX.VALTYPE()
:p.VALTYPE&lpar.&rpar.
.br
.br
:hp2.Retrieves the data type of an expression:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.VALTYPE&lpar. <xExp> &rpar. &minus.&minus.> <cReturnType>:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<xExp> is any valid expression.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cReturnType> a character indicating the type of the passed expression.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function returns one character which represents the date type  of the argument.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      See Test
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      function Test&lpar.&rpar.
.br
         ? ValType&lpar. Array&lpar. 1 &rpar. &rpar.  &minus.&minus.> &cdq.A&cdq.
.br
         ? ValType&lpar. &lbrc.&splitvbar.&splitvbar. 1 + 1 &rbrc. &rpar. &minus.&minus.> &cdq.B&cdq.
.br
         ? ValType&lpar. &cdq.HARBOUR&cdq. &rpar.   &minus.&minus.> &cdq.C&cdq.
.br
         ? ValType&lpar. Date&lpar.&rpar. &rpar.      &minus.&minus.> &cdq.D&cdq.
.br
         ? ValType&lpar. .T. &rpar.         &minus.&minus.> &cdq.L&cdq.
.br
         ? ValType&lpar. 1 &rpar.           &minus.&minus.> &cdq.N&cdq.
.br
         ? ValType&lpar. TBrowse&lpar.&rpar. &rpar.   &minus.&minus.> &cdq.O&cdq.
.br
         ? ValType&lpar. NIL &rpar.         &minus.&minus.> &cdq.U&cdq.
.br
      return nil
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.VALTYPE&lpar.&rpar. is fully CA&minus.Clipper compliant.
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=266.TYPE():elink.
.br
:h1 RUNY.RUN TIME ERRORS
:h2  res=369.BASE/1003
:i1 id=RUN TX.RUN TIME ERRORS
:i2 refid=RUN TX.BASE/1003
:p.BASE&slash.1003
.br
.br
:hp2.Attempt to acces nonexisting or hidden variable:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The specified variable was not found.
:p.If it is a database field make sure that the required database is open.
:p.If it is a private or public variable then you must first create it  using PRIVATE or PUBLIC statement.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=370.BASE/1068
:i2 refid=RUN TX.BASE/1068
:p.BASE&slash.1068
.br
.br
:hp2.Invalid type of argument:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The used data is not of logical type
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=370.BASE/1068
:i2 refid=RUN TX.BASE/1068
:p.BASE&slash.1068
.br
.br
:hp2.Bound error in array access:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The attempt to retrieve data from non&minus.array value
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=371.BASE/1069
:i2 refid=RUN TX.BASE/1069
:p.BASE&slash.1069
.br
.br
:hp2.Bound error in array access:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The attempt to set data to non&minus.array value
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=372.BASE/1078
:i2 refid=RUN TX.BASE/1078
:p.BASE&slash.1078
.br
.br
:hp2.Invalid type of arguments:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The type of compared arguments do not match
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.&eq.&eq.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=373.BASE/1072
:i2 refid=RUN TX.BASE/1072
:p.BASE&slash.1072
.br
.br
:hp2.Invalid type of arguments:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The type of compared arguments do not match
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.<>
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=374.BASE/1073
:i2 refid=RUN TX.BASE/1073
:p.BASE&slash.1073
.br
.br
:hp2.Invalid type of arguments:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The type of compared argument do not match
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.<
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=375.BASE/1074
:i2 refid=RUN TX.BASE/1074
:p.BASE&slash.1074
.br
.br
:hp2.Invalid type of arguments:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The type of compared arguments do not match
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.<&eq.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=376.BASE/1075
:i2 refid=RUN TX.BASE/1075
:p.BASE&slash.1075
.br
.br
:hp2.Invalid type of arguments:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The type of compared arguments do not match
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.>
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=377.BASE/1076
:i2 refid=RUN TX.BASE/1076
:p.BASE&slash.1076
.br
.br
:hp2.Invalid type of arguments:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The type of compared arguments do not match
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.>&eq.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=378.BASE/1077
:i2 refid=RUN TX.BASE/1077
:p.BASE&slash.1077
.br
.br
:hp2.Invalid type of arguments:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Operation is not allowed for passed argument. The argument is not  a logical value.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.!
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=372.BASE/1078
:i2 refid=RUN TX.BASE/1078
:p.BASE&slash.1078
.br
.br
:hp2.Invalid type of arguments:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The type of one or both arguments is not a logical
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p..AND.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=379.BASE/1079
:i2 refid=RUN TX.BASE/1079
:p.BASE&slash.1079
.br
.br
:hp2.Invalid type of arguments:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The type of one or both arguments is not a logical
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p..OR.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=377.BASE/1076
:i2 refid=RUN TX.BASE/1076
:p.BASE&slash.1076
.br
.br
:hp2.Invalid type of arguments:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The value of argument cannot be incremented
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.++
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=380.BASE/1081
:i2 refid=RUN TX.BASE/1081
:p.BASE&slash.1081
.br
.br
:hp2.Invalid type of arguments:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The plus operation is not allowed for used arguments.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.+
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=381.BASE/1082
:i2 refid=RUN TX.BASE/1082
:p.BASE&slash.1082
.br
.br
:hp2.Invalid type of arguments:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The minus operation is not allowed for used arguments.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.&minus.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=382.BASE/1100
:i2 refid=RUN TX.BASE/1100
:p.BASE&slash.1100
.br
.br
:hp2.Incorrect type of argument:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The specified argument is not a string.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.RTRIM&comma. TRIM
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=383.BASE/1101
:i2 refid=RUN TX.BASE/1101
:p.BASE&slash.1101
.br
.br
:hp2.Incorrect type of argument:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The specified argument is not a string.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.LTRIM
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=384.BASE/1102
:i2 refid=RUN TX.BASE/1102
:p.BASE&slash.1102
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The first argument passed to a function is not a string.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.UPPER
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=385.BASE/1103
:i2 refid=RUN TX.BASE/1103
:p.BASE&slash.1103
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The first argument passed to a function is not a string.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.LOWER
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=386.BASE/1104
:i2 refid=RUN TX.BASE/1104
:p.BASE&slash.1104
.br
.br
:hp2.Incorrect type of argument:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The specified argument is not a numeric value.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.CHR
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=387.BASE/1105
:i2 refid=RUN TX.BASE/1105
:p.BASE&slash.1105
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The arguments passed to a function are of incorrect type.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.SPACE
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=388.BASE/1106
:i2 refid=RUN TX.BASE/1106
:p.BASE&slash.1106
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The arguments passed to a function are of incorrect type.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.REPLICATE
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=389.BASE/1107
:i2 refid=RUN TX.BASE/1107
:p.BASE&slash.1107
.br
.br
:hp2.Incorrect type of argument:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The specified argument is not a string.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.ASC
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=390.BASE/1108
:i2 refid=RUN TX.BASE/1108
:p.BASE&slash.1108
.br
.br
:hp2.Incorrect type of argument:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The specified argument is not a string.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.AT
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=377.BASE/1076
:i2 refid=RUN TX.BASE/1076
:p.BASE&slash.1076
.br
.br
:hp2.Invalid type of arguments:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=391.BASE/1110
:i2 refid=RUN TX.BASE/1110
:p.BASE&slash.1110
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The first argument passed to a function is not a string.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.SUBSTR
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=391.BASE/1110
:i2 refid=RUN TX.BASE/1110
:p.BASE&slash.1110
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The passed argument is neither a string nor an array.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.LEN
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=392.BASE/1112
:i2 refid=RUN TX.BASE/1112
:p.BASE&slash.1112
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function are of incorrect  type
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.YEAR
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=393.BASE/1113
:i2 refid=RUN TX.BASE/1113
:p.BASE&slash.1113
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function are of incorrect  type
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.MONTH
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=394.BASE/1114
:i2 refid=RUN TX.BASE/1114
:p.BASE&slash.1114
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function are of incorrect  type
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.DAY
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=395.BASE/1115
:i2 refid=RUN TX.BASE/1115
:p.BASE&slash.1115
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function are of incorrect  type
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.DOW
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=396.BASE/1116
:i2 refid=RUN TX.BASE/1116
:p.BASE&slash.1116
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function are of incorrect  type
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.CMONTH
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=397.BASE/1117
:i2 refid=RUN TX.BASE/1117
:p.BASE&slash.1117
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function is of incorrect  type
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.CDOW
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=398.BASE/1120
:i2 refid=RUN TX.BASE/1120
:p.BASE&slash.1120
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function is of incorrect  type
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.DTOS
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=399.BASE/1122
:i2 refid=RUN TX.BASE/1122
:p.BASE&slash.1122
.br
.br
:hp2.Incorrect type of argument:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function is of incorrect  type
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.TRANSFORM
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=400.BASE/1124
:i2 refid=RUN TX.BASE/1124
:p.BASE&slash.1124
.br
.br
:hp2.Incorrect type of argument:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The first argument is not a string.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.LEFT
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=401.BASE/1126
:i2 refid=RUN TX.BASE/1126
:p.BASE&slash.1126
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The first arguments passed to a function is not a string.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.STRTRAN
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=402.BASE/1132
:i2 refid=RUN TX.BASE/1132
:p.BASE&slash.1132
.br
.br
:hp2.Bound error in array access:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The specified index into an array was greater then the number of  elements in the array.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=403.BASE/1133
:i2 refid=RUN TX.BASE/1133
:p.BASE&slash.1133
.br
.br
:hp2.Bound error in array assigment:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The specified index into an array was greater then the number of  elements in the array.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=370.BASE/1068
:i2 refid=RUN TX.BASE/1068
:p.BASE&slash.1068
.br
.br
:hp2.Bound error in array element assigment:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The specified index into an array was greater then the number of  elements in the array.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=404.BASE/1085
:i2 refid=RUN TX.BASE/1085
:p.BASE&slash.1085
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function is not an numeric  value
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.MOD
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=405.BASE/1089
:i2 refid=RUN TX.BASE/1089
:p.BASE&slash.1089
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function is not an numeric  value
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.ABS
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=406.BASE/1090
:i2 refid=RUN TX.BASE/1090
:p.BASE&slash.1090
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function is not an numeric  value
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.INT
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=407.BASE/1092
:i2 refid=RUN TX.BASE/1092
:p.BASE&slash.1092
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function is not an numeric  value
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.MIN
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=408.BASE/1093
:i2 refid=RUN TX.BASE/1093
:p.BASE&slash.1093
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function is not an numeric  value
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.MAX
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=409.BASE/1094
:i2 refid=RUN TX.BASE/1094
:p.BASE&slash.1094
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function is not an numeric  value
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.ROUND
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=410.BASE/1095
:i2 refid=RUN TX.BASE/1095
:p.BASE&slash.1095
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function is not an numeric  value
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.LOG
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=411.BASE/1096
:i2 refid=RUN TX.BASE/1096
:p.BASE&slash.1096
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function is not an numeric  value
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.EXP
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=412.BASE/1097
:i2 refid=RUN TX.BASE/1097
:p.BASE&slash.1097
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function is not an numeric  value
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.SQRT
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=413.BASE/1098
:i2 refid=RUN TX.BASE/1098
:p.BASE&slash.1098
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function is not a string  value
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.VAL
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=414.BASE/1099
:i2 refid=RUN TX.BASE/1099
:p.BASE&slash.1099
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The argument &lpar.or arguments&rpar. passed to a function is not a numeric  value
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.STR
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=415.BASE/2010
:i2 refid=RUN TX.BASE/2010
:p.BASE&slash.2010
.br
.br
:hp2.Incorrect arguments type:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Passed Run Time Errors was not strings with filenames to copy&slash.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.COPYFILE
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.Harbour specific
:h2 id=RUNY res=416.BASE/2012
:i2 refid=RUN TX.BASE/2012
:p.BASE&slash.2012
.br
.br
:hp2.File error:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.An error has occured during the attempt to open&comma. create or write  during copy operation
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.COPYFILE
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=417.BASE/2017
:i2 refid=RUN TX.BASE/2017
:p.BASE&slash.2017
.br
.br
:hp2.Invalid argument passed to a function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The first argument is not an array or&slash.and the second argument  is not a code block
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.AEVAL
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=418.BASE/2020
:i2 refid=RUN TX.BASE/2020
:p.BASE&slash.2020
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The passed value is negative. Only values > 0 are allowed.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.SET DECIMALS
:p.SET EPOCH
:p.SET MARGIN
:p.SET MESSAGE
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=RUNY res=419.BASE/3001
:i2 refid=RUN TX.BASE/3001
:p.BASE&slash.3001
.br
.br
:hp2.Incorrect argument type:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The passed argument is not an object. Only data of type OBJECT  can be cloned by this function
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.OCLONE
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour specific
:h2 id=RUNY res=420.BASE/3002
:i2 refid=RUN TX.BASE/3002
:p.BASE&slash.3002
.br
.br
:hp2.Super class does not return an object:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Passed argument is not a name of defined class or specified class  doesn't have a super class
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.INSTSUPER
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour specific
:h2 id=RUNY res=421.BASE/3003
:i2 refid=RUN TX.BASE/3003
:p.BASE&slash.3003
.br
.br
:hp2.Cannot find super class:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Passed argument is not a name of defined class
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.INSTSUPER
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour specific
:h2 id=RUNY res=422.BASE/3004
:i2 refid=RUN TX.BASE/3004
:p.BASE&slash.3004
.br
.br
:hp2.Cannot modify a DATA item in a class:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The attempt to modify a data member of a class was made.  Only INLINE and METHOD can be modified
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.CLASSMOD
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour specific
:h2 id=RUNY res=423.BASE/3005
:i2 refid=RUN TX.BASE/3005
:p.BASE&slash.3005
.br
.br
:hp2.Incorrect arguments type:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Either the first argument was not an object or the second argument  wasn't a string.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.ISMESSAGE&comma. OSEND
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour specific
:h2 id=RUNY res=424.BASE/3007
:i2 refid=RUN TX.BASE/3007
:p.BASE&slash.3007
.br
.br
:hp2.Invalid type of argument:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The passed arguments are causing conflict in hanndling of the request.  There is no point in waiting forever for no input events!
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.INKEY
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour specific
:h2 id=RUNY res=425.BASE/3008
:i2 refid=RUN TX.BASE/3008
:p.BASE&slash.3008
.br
.br
:hp2.Invalid type of argument:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The passed argument&lpar.s&rpar. is not a string. It should be a string with  a variable name or an one&minus.dimensional array of strings.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.MVPRIVATE&comma. &us.&us.MVPUBLIC
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour specific
:h2 id=RUNY res=426.BASE/3009
:i2 refid=RUN TX.BASE/3009
:p.BASE&slash.3009
.br
.br
:hp2.Incorrect argument passed to &us.&us.MVGET function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.MVGET function expects only one argument&colon. a string with a name  of variable. The value of this variable will be returned.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.MVGET
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour specific
:h2 id=RUNY res=427.BASE/3010
:i2 refid=RUN TX.BASE/3010
:p.BASE&slash.3010
.br
.br
:hp2.Incorrect argument passed to &us.&us.MVPUT function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.MVPUT function expects at least one argument&colon. a string with a name  of variable. The value of this variable will be set.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.MVPUT
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour specific
:h2 id=RUNY res=428.BASE/3011
:i2 refid=RUN TX.BASE/3011
:p.BASE&slash.3011
.br
.br
:hp2.Invalid argument passed to a function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The attempt to retrieve the function argument that was not passed.  The number of requested argument is greated then the number of  passed arguments.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.PVALUE
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour specific
:h2 id=RUNY res=429.BASE/3012
:i2 refid=RUN TX.BASE/3012
:p.BASE&slash.3012
.br
.br
:hp2.Invalid argument passed to a function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The first argument is not a string with function&slash.procedure name  that should be called.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.DO
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour specific
:h2 id=RUNY res=430.BASE/3101
:i2 refid=RUN TX.BASE/3101
:p.BASE&slash.3101
.br
.br
:hp2.Invalid argument passed to an object&slash.class function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.One passed argument is not of the required type.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.OBJ*&lpar.&rpar.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour specific
:h2 id=RUNY res=431.BASE/3102
:i2 refid=RUN TX.BASE/3102
:p.BASE&slash.3102
.br
.br
:hp2.A symbol should be modified or deleted from a class&comma. but the symbol:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.A symbol should be modified or deleted from a class&comma. but the symbol  doesn't exist.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.OBJ*&lpar.&rpar.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour specific
:h2 id=RUNY res=432.BASE/3103
:i2 refid=RUN TX.BASE/3103
:p.BASE&slash.3103
.br
.br
:hp2.A symbol should be added to a class&comma. but the symbol already exists.:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.A symbol should be added to a class&comma. but the symbol already exists.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.&us.&us.OBJ*&lpar.&rpar.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour specific
:h2 id=RUNY res=433.TOOLS/4001
:i2 refid=RUN TX.TOOLS/4001
:p.TOOLS&slash.4001
.br
.br
:hp2.Invalid argument passed to function:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The second arguments passed to a function is not a string.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.ISLEAPYEAR
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour specific
:h2 id=RUNY res=434.TERM/2013
:i2 refid=RUN TX.TERM/2013
:p.TERM&slash.2013
.br
.br
:hp2.Create error:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The specified file cannot be created due some OS error.
.br
.br
:hp2.Function:ehp2.
.br
:p.
:lm margin=6.
:p.SET&comma. SET ALTERNATE TO
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Clipper
:h2 id=DOCUY res=435.Harbour Extensions
:i2 refid=DOCUMX.HARBOUR EXTENSIONS
:p.Harbour Extensions
.br
.br
:hp2.Harbour Extensions:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.Language extensions::ehp2.
:p.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
.br
:p.* Class generation and management.
.br
:p.Clipper only allowed creation of objects from a few standard  classes.
.br
:p.In Harbour&comma. you can create your own classes&minus.&minus.complete with  Methods&comma. Instance Variables&comma. Class Variables and Inheritance.  Entire applications can be designed and coded in Object Oriented  style.
.br
:p.* @<FunctionName>&lpar.&rpar.
.br
:p.Returns the pointer &lpar.address&rpar. to a function.
.br
:p.The returned value is not useful to application&minus.level programming&comma. but  is used at a low level to implement object oriented coding.  &lpar.Internally&comma. a class method is a static function and there is no  symbol
for it&comma. so it is accessed via its address&rpar..
.br
:p.* Class TGetList
.br
:p.Object oriented support for GetLists management.
.br
:p.* ProcName&lpar.&rpar. support for class Method names.
.br
:p.Class Methods can be retrieved from the call stack.
.br
:p.* Memory&lpar.&rpar. has new return values.
.br
:p.See hbmemory.ch
.br
:p.* Transform&lpar.&rpar.  &minus.&minus.> new function in format string
.br
:p.@0      Make a zero padded string out of the number.
.br
:p.* SToD&lpar.&rpar.  &minus.&minus.> dDate
.br
:p.New function that converts a yyyymmdd string to a Date value.
.br
:p.* Optional Compile Time STRONG TYPE declaration &lpar.and compile time TYPE  MISMATCH warnings&rpar.
.br
:p.Example&colon. LOCAL&slash.STATIC Var AS ...
.br
:p.* The Harbour debugger provides new interesting classes&colon.
.br
:p.&minus. Class TDbWindow could be the foundation for a generic multiplatform
.br
:p.&minus. Class TForm
.br
:p.&minus. Class TDbMenu implement both pulldown and popup menus.
.br
:p.:hp2.RTL enhanced functionality::ehp2.
:p.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
.br
:p.&minus. Directory&lpar. <cMask>&comma. <cFlags>&comma. <lEightDotThree> &rpar.
.br
:p.The 3rd parameter is a Harbour &lpar.optional&rpar. parameter and indicates that on  those platforms that support long filenames&comma. that you wish to receive what  would be considered the dos equivalant 8.3 name.  Could affect
Adir&lpar.&rpar. and Dir if they were modified to take advantage  of it &minus. currently&comma. they will return long names if the os supports it.
.br
:p.&minus. HB&us.DiskSpace&lpar. <nDrive>&comma. <nType> &rpar.
.br
:p.The second parameter is a Harbour &lpar.optional&rpar. parameter and indicates the  type of diskinfo being requested.  See en&slash.diskspac.txt for info.
.br
:h2 id=DOCUY res=436.GNU License
:i2 refid=DOCUMX.GNU LICENSE
:p.GNU License
.br
.br
:hp2.Gnu License File Part 1:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
.br
:p.GNU GENERAL PUBLIC LICENSE
:p.Version 2&comma. June 1991
:p.Copyright &lpar.C&rpar. 1989&comma. 1991 Free Software Foundation&comma. Inc.  59 Temple Place &minus. Suite 330&comma. Boston&comma. MA  02111&minus.1307&comma. USA
.br
:p.Everyone is permitted to copy and distribute verbatim copies  of this license document&comma. but changing it is not allowed.
.br
:p.Preamble
.br
:p.The licenses for most software are designed to take away your  freedom to share and change it. By contrast&comma. the GNU General Public  License is intended to guarantee your freedom to share and change  free
software&minus.&minus.to make sure the software is free for all its users.  This General Public License applies to most of the Free Software  Foundation's software and to any other program whose authors commit  to using it.
&lpar.Some other Free Software Foundation software is  covered by the GNU Library General Public License instead.&rpar.  You can apply it to your programs&comma. too.
.br
:p.When we speak of free software&comma. we are referring to freedom&comma. not  price. Our General Public Licenses are designed to make sure that  you have the freedom to distribute copies of free software &lpar.and  charge for
this service if you wish&rpar.&comma. that you receive source code  or can get it if you want it&comma. that you can change the software or  use pieces of it in new free programs&semi. and that you know you can do  these things.
.br
:p.To protect your rights&comma. we need to make restrictions that forbid  anyone to deny you these rights or to ask you to surrender the  rights. These restrictions translate to certain responsibilities  for you if you distribute
copies of the software&comma. or if you modify  it.
.br
:p.For example&comma. if you distribute copies of such a program&comma. whether  gratis or for a fee&comma. you must give the recipients all the rights  that you have. You must make sure that they&comma. too&comma. receive or can
get the source code. And you must show them these terms so they  know their rights.
.br
:p.We protect your rights with two steps&colon. &lpar.1&rpar. copyright the software&comma.  and &lpar.2&rpar. offer you this license which gives you legal permission to  copy&comma. distribute and&slash.or vmodify the software.
.br
:p.Also&comma. for each author's protection and ours&comma. we want to make  certain that everyone understands that there is no warranty for  this free software. If the software is modified by someone else and  passed on&comma. we
want its recipients to know that what they have is  not the original&comma. so that any problems introduced by others will  not reflect on the original authors' reputations.
.br
:p.Finally&comma. any free program is threatened constantly by software  patents. We wish to avoid the danger that redistributors of a free  program will individually obtain patent licenses&comma. in effect making  the program
proprietary. To prevent this&comma. we have made it clear  that any patent must be licensed for everyone's free use or not  licensed at all.
.br
:p.The precise terms and conditions for copying&comma. distribution and  modification follow.
.br
:p.:hp2.TERMS AND CONDITIONS FOR COPYING&comma. DISTRIBUTION AND MODIFICATION:ehp2.
.br
:p.0. This License applies to any program or other work which contains  a notice placed by the copyright holder saying it may be  distributed under the terms of this General Public License. The  &cdq.Program&cdq.&comma. below&comma.
refers to any such program or work&comma. and a &cdq.work  based on the Program&cdq. means either the Program or any derivative  work under copyright law&colon. that is to say&comma. a work containing the  Program or a portion of
it&comma. either verbatim or with modifications  and&slash.or translated into another language. &lpar.Hereinafter&comma. translation  is included without limitation in the term &cdq.modification&cdq..&rpar. Each  licensee is
addressed as &cdq.you&cdq.. Activities other than copying&comma.  distribution and modification are not covered by this License&semi. they  are outside its scope. The act of running the Program is not  restricted&comma. and the
output from the Program is covered only if its  contents constitute a work based on the Program &lpar.independent of  having been made by running the Program&rpar.. Whether that is true  depends on what the Program does.
.br
:p.1. You may copy and distribute verbatim copies of the Program's  source code as you receive it&comma. in any medium&comma. provided that you  conspicuously and appropriately publish on each copy an appropriate  copyright notice
and disclaimer of warranty&semi. keep intact all the  notices that refer to this License and to the absence of any  warranty&semi. and give any other recipients of the Program a copy of  this License along with the Program. You
may charge a fee for the  physical act of transferring a copy&comma. and you may at your option  offer warranty protection in exchange for a fee.
.br
:p.2. You may modify your copy or copies of the Program or any portion  of it&comma. thus forming a work based on the Program&comma. and copy and  distribute such modifications or work under the terms of Section 1  above&comma.
provided that you also meet all of these conditions&colon.
.br
:p.a&rpar. You must cause the modified files to carry prominent notices  stating that you changed the files and the date of any change.
.br
:p.b&rpar. You must cause any work that you distribute or publish&comma. that  in whole or in part contains or is derived from the Program or  any part thereof&comma. to be licensed as a whole at no charge to all  third parties
under the terms of this License.
.br
:p.c&rpar. If the modified program normally reads commands interactively  when run&comma. you must cause it&comma. when started running for such  interactive use in the most ordinary way&comma. to print or display an  announcement
including an appropriate copyright notice and a  notice that there is no warranty &lpar.or else&comma. saying that you  provide a warranty&rpar. and that users may redistribute the program  under these conditions&comma. and
telling the user how to view a copy  of this License. &lpar.Exception&colon. if the Program itself is interactive  but does not normally print such an announcement&comma. your work based  on the Program is not required to print
an announcement.&rpar.
.br
:p.These requirements apply to the modified work as a whole. If  identifiable sections of that work are not derived from the  Program&comma. and can be reasonably considered independent and separate  works in themselves&comma. then
this License&comma. and its terms&comma. do not apply  to those sections when you distribute them as separate works. But  when you distribute the same sections as part of a whole which is a  work based on the Program&comma. the
distribution of the whole must be on  the terms of this License&comma. whose permissions for other licensees  extend to the entire whole&comma. and thus to each and every part  regardless of who wrote it.
.br
:p.Thus&comma. it is not the intent of this section to claim rights or  contest your rights to work written entirely by you&semi. rather&comma. the  intent is to exercise the right to control the distribution of  derivative or
collective works based on the Program.
.br
:p.In addition&comma. mere aggregation of another work not based on the  Program with the Program &lpar.or with a work based on the Program&rpar. on a  volume of a storage or distribution medium does not bring the other  work under
the scope of this License.
.br
:p.3. You may copy and distribute the Program &lpar.or a work based on it&comma.  under Section 2&rpar. in object code or executable form under the terms  of Sections 1 and 2 above provided that you also do one of the
following&colon.
.br
:p.a&rpar. Accompany it with the complete corresponding machine&minus.readable  source code&comma. which must be distributed under the terms of  Sections 1 and 2 above on a medium customarily used for software  interchange&semi.
or&comma.
.br
:p.b&rpar. Accompany it with a written offer&comma. valid for at least three  years&comma. to give any third party&comma. for a charge no more than your  cost of physically performing source distribution&comma. a complete
machine&minus.readable copy of the corresponding source code&comma. to be  distributed under the terms of Sections 1 and 2 above on a medium  customarily used for software interchange&semi. or&comma.
.br
:p.c&rpar. Accompany it with the information you received as to the offer  to distribute corresponding source code. &lpar.This alternative is  allowed only for noncommercial distribution and only if you  received the program in
object code or executable form with such  an offer&comma. in accord with Subsection b above.&rpar.
.br
:p.The source code for a work means the preferred form of the work for  making modifications to it. For an executable work&comma. complete source  code means all the source code for all modules it contains&comma. plus  any
associated interface definition files&comma. plus the scripts used to  control compilation and installation of the executable. However&comma. as  a special exception&comma. the source code distributed need not include  anything
that is normally distributed &lpar.in either source or binary  form&rpar. with the major components &lpar.compiler&comma. kernel&comma. and so on&rpar. of  the operating system on which the executable runs&comma. unless that
component itself accompanies the executable.
.br
:p.If distribution of executable or object code is made by offering  access to copy from a designated place&comma. then offering equivalent  access to copy the source code from the same place counts as  distribution of the source
code&comma. even though third parties are not  compelled to copy the source along with the object code.
.br
:p.4. You may not copy&comma. modify&comma. sublicense&comma. or distribute the Program  except as expressly provided under this License. Any attempt  otherwise to copy&comma. modify&comma. sublicense or distribute the Program is
void&comma. and will automatically terminate your rights under this  License. However&comma. parties who have received copies&comma. or rights&comma. from  you under this License will not have their licenses terminated so  long
as such parties remain in full compliance.
.br
:p.5. You are not required to accept this License&comma. since you have not  signed it. However&comma. nothing else grants you permission to modify or  distribute the Program or its derivative works. These actions are  prohibited by
law if you do not accept this License. Therefore&comma. by  modifying or distributing the Program &lpar.or any work based on the  Program&rpar.&comma. you indicate your acceptance of this License to do so&comma.  and all its
terms and conditions for copying&comma. distributing or  modifying the Program or works based on it.
.br
:p.6. Each time you redistribute the Program &lpar.or any work based on the  Program&rpar.&comma. the recipient automatically receives a license from the  original licensor to copy&comma. distribute or modify the Program subject  to
these terms and conditions. You may not impose any further  restrictions on the recipients' exercise of the rights granted  herein. You are not responsible for enforcing compliance by third  parties to this License.
.br
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=437.GNU LICENSE PART 2:elink.
.br
:h2 id=DOCUY res=437.GNU License Part 2
:i2 refid=DOCUMX.GNU LICENSE PART 2
:p.GNU License Part 2
.br
.br
:hp2.Gnu License File Part 2:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
.br
:p.7. If&comma. as a consequence of a court judgment or allegation of patent  infringement or for any other reason &lpar.not limited to patent  issues&rpar.&comma. conditions are imposed on you &lpar.whether by court order&comma.
agreement or otherwise&rpar. that contradict the conditions of this  License&comma. they do not excuse you from the conditions of this  License. If you cannot distribute so as to satisfy simultaneously  your obligations under
this License and any other pertinent  obligations&comma. then as a consequence you may not distribute the  Program at all. For example&comma. if a patent license would not permit  royalty&minus.free redistribution of the Program
by all those who receive  copies directly or indirectly through you&comma. then the only way you  could satisfy both it and this License would be to refrain entirely  from distribution of the Pr
ogram.
.br
:p.If any portion of this section is held invalid or unenforceable  under any particular circumstance&comma. the balance of the section is  intended to apply and the section as a whole is intended to apply  in other circumstances.
.br
:p.It is not the purpose of this section to induce you to infringe any  patents or other property right claims or to contest validity of  any such claims&semi. this section has the sole purpose of protecting  the integrity of the
free software distribution system&comma. which is  implemented by public license practices. Many people have made  generous contributions to the wide range of software distributed  through that system in reliance on consistent
application of that  system&semi. it is up to the author&slash.donor to decide if he or she is  willing to distribute software through any other system and a  licensee cannot impose that choice.
.br
:p.This section is intended to make thoroughly clear what is believed  to be a consequence of the rest of this License.
.br
:p.8. If the distribution and&slash.or use of the Program is restricted in  certain countries either by patents or by copyrighted interfaces&comma.  the original copyright holder who places the Program under this  License may add an
explicit geographical distribution limitation  excluding those countries&comma. so that distribution is permitted only  in or among countries not thus excluded. In such case&comma. this License  incorporates the limitation as if
written in the body of this  License.
.br
:p.9. The Free Software Foundation may publish revised and&slash.or new  versions of the General Public License from time to time. Such new  versions will be similar in spirit to the present version&comma. but may  differ in detail
to address new problems or concerns.
.br
:p.Each version is given a distinguishing version number. If the  Program specifies a version number of this License which applies to  it and &cdq.any later version&cdq.&comma. you have the option of following the  terms and
conditions either of that version or of any later version  published by the Free Software Foundation. If the Program does not  specify a version number of this License&comma. you may choose any  version ever published by the Free
Software Foundation.
.br
:p.10. If you wish to incorporate parts of the Program into other free  programs whose distribution conditions are different&comma. write to the  author to ask for permission. For software which is copyrighted by  the Free Software
Foundation&comma. write to the Free Software  Foundation&semi. we sometimes make exceptions for this. Our decision  will be guided by the two goals of preserving the free status of  all derivatives of our free software and of
promoting the sharing  and reuse of software generally.
.br
:p.:hp2.NO WARRANTY:ehp2.
:p.11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE&comma. THERE IS NO  WARRANTY FOR THE PROGRAM&comma. TO THE EXTENT PERMITTED BY APPLICABLE  LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS  AND&slash.OR OTHER
PARTIES PROVIDE THE PROGRAM &cdq.AS IS&cdq. WITHOUT WARRANTY  OF ANY KIND&comma. EITHER EXPRESSED OR IMPLIED&comma. INCLUDING&comma. BUT NOT  LIMITED TO&comma. THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS  FOR A
PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND  PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE  DEFECTIVE&comma. YOU ASSUME THE COST OF ALL NECESSARY SERVICING&comma. REPAIR  OR CORRECTION.
.br
:p.12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN  WRITING WILL ANY COPYRIGHT HOLDER&comma. OR ANY OTHER PARTY WHO MAY  MODIFY AND&slash.OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE&comma. BE  LIABLE TO YOU FOR
DAMAGES&comma. INCLUDING ANY GENERAL&comma. SPECIAL&comma.  INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR  INABILITY TO USE THE PROGRAM &lpar.INCLUDING BUT NOT LIMITED TO LOSS OF  DATA OR DATA BEING RENDERED
INACCURATE OR LOSSES SUSTAINED BY YOU  OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY  OTHER PROGRAMS&rpar.&comma. EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
.br
:p.:hp2.END OF TERMS AND CONDITIONS:ehp2.
.br
.br
:p.Appendix&colon. How to Apply These Terms to Your New Programs
.br
:p.If you develop a new program&comma. and you want it to be of the greatest  possible use to the public&comma. the best way to achieve this is to make  it free software which everyone can redistribute and change under  these terms.
.br
:p.To do so&comma. attach the following notices to the program. It is safest  to attach them to the start of each source file to most effectively  convey the exclusion of warranty&semi. and each file should have at  least the
&cdq.copyright&cdq. line and a pointer to where the full notice  is found&colon.
.br
:p.<One line to give the program's name and an idea of what it does.>  Copyright &lpar.C&rpar. yyyy  <name of author>
.br
.br
:p.This program is free software&semi. you can redistribute it and&slash.or  modify it under the terms of the GNU General Public License  as published by the Free Software Foundation&semi. either version 2  of the License&comma. or
&lpar.at your option&rpar. any later version.
.br
:p.This program is distributed in the hope that it will be useful&comma.  but :hp2.WITHOUT ANY WARRANTY:ehp2.&semi. without even the implied warranty of  :hp2.MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE:ehp2..  See the  GNU
General Public License for more details.
.br
:p.You should have received a copy of the GNU General Public License  along with this program&semi. if not&comma. write to the Free Software  Foundation&comma. Inc.&comma.
:p.59 Temple Place &minus. Suite 330&comma. Boston&comma. MA  02111&minus.1307&comma. USA.
.br
:p.Also add information on how to contact you by electronic and paper  mail. If the program is interactive&comma. make it output a short notice  like this when it starts in an interactive mode&colon.
.br
:p.Gnomovision version 69&comma. Copyright &lpar.C&rpar. year name of author  Gnomovision comes with ABSOLUTELY NO WARRANTY&semi. for details  type `show w'.  This is free software&comma. and you are welcome  to redistribute it
under certain conditions&semi. type `show c'  for details.
.br
:p.The hypothetical commands `show w' and `show c' should show the  appropriate parts of the General Public License. Of course&comma. the  commands you use may be called something other than `show w' and  `show c'&semi. they could
even be mouse&minus.clicks or menu items&minus.&minus.whatever  suits your program.
.br
:p.You should also get your employer &lpar.if you work as a programmer&rpar. or  your school&comma. if any&comma. to sign a &cdq.copyright disclaimer&cdq. for the  program&comma. if necessary. Here is a sample&semi. alter the
names&colon.
.br
:p.Yoyodyne&comma. Inc.&comma. hereby disclaims all copyright interest in the  program `Gnomovision' &lpar.which makes passes at compilers&rpar. written by  James Hacker.
.br
:p.signature of Ty Coon&comma. 1 April 1989
:p.Ty Coon&comma. President of Vice
.br
:p.This General Public License does not permit incorporating your  program into proprietary programs. If your program is a subroutine  library&comma. you may consider it more useful to permit linking  proprietary applications with
the library. If this is what you want  to do&comma. use the GNU Library General Public License instead of this  License.
.br
.br
:p.FSF &amp. GNU inquiries &amp. questions to gnu@gnu.org.
:p.Copyright notice above.
.br
:p.Free Software Foundation&comma. Inc.&comma.
:p.59 Temple Place &minus. Suite 330&comma. Boston&comma. MA 02111&comma. USA
:p.Updated&colon. 3 Jan 2000 rms
.br
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=146.LICENSE:elink.
.br
:link reftype=hd res=436.GNU LICENSE:elink.
.br
:h2 id=DOCUY res=438.Compiler Options
:i2 refid=DOCUMX.COMPILER OPTIONS
:p.Compiler Options
.br
.br
:hp2.Compiler Options:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
.br
:p.:hp2.Invoking the Harbour compiler:  :ehp2.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.harbour <file&lbrk..prg&rbrk..> &lbrk.options&rbrk..
:p.or
:p.harbour &lbrk.options&rbrk.. <file&lbrk..prg&rbrk..>
:p.or
:p.harbour &lbrk.options&rbrk.. <file&lbrk..prg&rbrk..> &lbrk.options&rbrk..
.br
:p.The command line options have to be separated by at least one space.  The option can start with either '&slash.' character or '&minus.' character.
.br
:p.:hp2.The Harbour command line options:  :ehp2.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.&slash.a               automatic memvar declaration
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.This causes all variables declared by PARAMETER&comma. PRIVATE or PUBLIC  statements to be automatically declared as MEMVAR variables.
.br
:p.&slash.b               debug info
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.The compiler generates all information required for debugging
.br
:p.&slash.d<id>&lbrk.&eq.<val>&rbrk..   #define <id>
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.&slash.es&lbrk.<level>&rbrk..     set exit severity
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.&slash.es or &slash.es0 &eq. all warnings are ignored and exit code returned by  the compiler &lpar.accessed by DOS ERRORLEVEL command&rpar.  is equal to 0 if there are no errors in compiled  source file.
.br
:p.&slash.es1        &eq. any warnings generate a non&eq.zero exit code&comma. but  output is still created.
.br
:p.&slash.es2        &eq. all warnings are treated as errors and no output  file is created. The exit code is set to a non&eq.zero  value.
.br
:p.&slash.g<type>         output type generated is <type>
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.&slash.gc          output type&colon. C source &lpar..c&rpar. &lpar.default&rpar.
.br
:p.&slash.gf          output type&colon. Windows&slash.DOS OBJ32 &lpar..obj&rpar.
.br
:p.&slash.gh          output type&colon. Harbour Portable Object &lpar..hrb&rpar.
.br
:p.&slash.gj          output type&colon. Java source &lpar..java&rpar.
.br
:p.&slash.gp          output type&colon. Pascal source &lpar..pas&rpar.
.br
:p.&slash.gr          output type&colon. Windows resource &lpar..rc&rpar.
.br
:p.&slash.i<path>         add #include file search path
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.&slash.l               suppress line number information
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.The compiler does not generate the source code line numbers in  the output file. The PROCLINE&lpar.&rpar. function will return 0 for  modules compiled using this option.
.br
:p.&slash.m               compile current module only
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.&slash.n               no implicit starting procedure
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.The compiler does not create a procedure with the same name as  the compiled file. This means that any declarations placed  before the first PROCEDURE or FUNCTION statement have file&eq.  wide scope and can be accessed&slash.used
in all functions&slash.procedures  defined in the compiled source file. All executable statements  placed at the beginning of the file and before the first  PROCEDURE&slash.FUNCTION statement are ignored.
.br
:p.&slash.o<path>         output file drive and&slash.or path
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.&slash.p               generate pre&eq.processed output &lpar..ppo&rpar. file
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.The compiler only creates the file that contains the result of  pre&eq.processing the source file.
.br
:p.&slash.q               quiet
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.The compiler does not print any messages during compiling  &lpar.except the copyright info&rpar..
.br
:p.&slash.q0     be really quiet and don't display even the copyright info
.br
:p.&slash.r&lbrk.<lib>&rbrk..        request linker to search <lib> &lpar.or none&rpar.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.Currently not supported in Harbour.
.br
:p.&slash.s               syntax check only
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.The compiler checks the syntax only. No output file is generated.
.br
:p.&slash.t<path>         path for temp file creation
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.Currently not used in Harbour &lpar.the Harbour compiler does not  create any temporary files&rpar..
.br
:p.&slash.u&lbrk.<file>&rbrk..       use command definition set in <file> &lpar.or none&rpar.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.&slash.v               variables are assumed M&eq.>
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.All undeclared or unaliased variables are assumed MEMVAR  variables &lpar.private or public variables&rpar.. If this switch is not  used then the scope of such variables is checked at runtime.
.br
:p.&slash.w&lbrk.<level>&rbrk..      set warning level number &lpar.0..4&comma. default 1&rpar.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.&slash.w0         &eq. no warnings
.br
:p.&slash.w or &slash.w1   &eq. Clipper compatible warnings
.br
:p.&slash.w2         &eq. some useful warnings missed in Clipper
.br
:p.&slash.w3         &eq. warnings generated for Harbour language extensions  and also enables strong type checking but only  warns against declared types&comma. or types which may be  calculated at compile time
.br
:p.&slash.w4         &eq. Enables warning about suspicious operations&comma. which  means if you mix undeclared types&comma. or types which  can not be calculated at compile time&comma.together with  declared types&comma. a warning
will be  generated.
.br
:p.&slash.x&lbrk.<prefix>&rbrk..     set symbol init function name prefix &lpar.for .c only&rpar.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.Sets the prefix added to the generated symbol init function name  &lpar.in C output currently&rpar.. This function is generated  automatically for every PRG module compiled. This additional  prefix can be used to suppress
problems with duplicated symbols  during linking an application with some third party libraries.
.br
:p.&slash.y               trace lex &amp. yacc activity
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.The Harbour compiler uses the FLEX and YACC utilities to parse  the source code and to generate the required output file. This  option traces the activity of these utilities.
.br
:p.&slash.z               suppress logical shortcutting &lpar..and. &amp. .or.&rpar.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.&slash.10              restrict symbol length to 10 characters
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.All variable and function names are cut to maximum 10 characters.
.br
:p.Compilation in batch mode.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.@<file>         compile list of modules in <file>
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.Not supported yet.
.br
:p.:hp2.Known incompatibilities between harbour and clipper compilers  :ehp2.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
&eq.&eq.&eq.&eq.
.br
:p.NOTE&colon.
.br
:p.If you want a 100% compatible compile and runtime libraries then  you have to define HARBOUR&us.STRICT&us.CLIPPER&us.COMPATIBILITY. This  option should be defined in the file include&slash.hbsetup.h &lpar.in fact this  option is
placed in a comment by default &eq. you need to remove the  &slash.* *&slash. characters only&rpar.. This change has to be done before invoking  the make utility.
.br
.br
:p.:hp2.Handling of undeclared variables  :ehp2.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.When a value is assigned to an undeclared variable and the '&eq.v'  command line option is not used&comma. then the Clipper compiler assumes  that the variable is a PRIVATE or a PUBLIC variable and generates  POPM &lpar.pop
memvar&rpar. opcode.
.br
:p.When the value of an undeclared variable is accessed and the '&eq.v'  command line option is not used&comma. the Clipper compiler generates PUSHV  &lpar.push variable&rpar. opcode that determines the type of variable at runtime.
If a field with the requested name exists in the current workarea then  its value is used. If there is no field then a PRIVATE or a PUBLIC  variable is used &lpar.if exists&rpar..
.br
:p.The Harbour compiler generates an opcode to determine the type of  variable at runtime &lpar.POPVARIABLE or PUSHVARIABLE&rpar. in both cases  &lpar.assignment and access&rpar..
.br
:p.The difference can be checked by the following code&colon.
.br
      PROCEDURE MAIN&lpar.&rpar.
.br
      PRIVATE myname
.br

.br
        DBCREATE&lpar. &cdq.TEST&cdq.&comma. &lbrc. &lbrc. &cdq.MYNAME&cdq.&comma. &cdq.C&cdq.&comma. 10&comma. 0&rbrc. &rbrc. &rpar.
.br
        USE test NEW
.br
        SELECT test
.br
        APPEND BLANK
.br

.br
        FIELD&eq.>myname  &colon.&eq. &cdq.FIELD&cdq.
.br
        MEMVAR&eq.>myname &colon.&eq. &cdq.MEMVAR&cdq.
.br

.br
        myname &colon.&eq. myname + &cdq. assigned&cdq.
.br

.br
        &slash.&slash. In Clipper&colon. &cdq.FIELD&cdq.&comma.  In Harbour&colon. &cdq.FIELD assigned&cdq.
.br
        ? FIELD&eq.>myname
.br

.br
        &slash.&slash. In Clipper&colon. &cdq.MEMVAR assigned&cdq.&comma. In Harbour&colon. &cdq.MEMVAR&cdq.
.br
        ? MEMVAR&eq.>myname
.br

.br
        USE
.br

.br
      RETURN
.br
.br
:p.:hp2.Passing an undeclared variable by the reference :ehp2.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.The Clipper compiler uses the special opcode PUSHP to pass a  reference to an undeclared variable &lpar. '@' operator &rpar.. The type of  passed variable is checked at runtime &lpar.field or memvar&rpar.. However&comma.  field
variables cannot be passed by reference. This means that  Clipper checks the memvar variable only and doesn't look for a field.  This is the reason why the Harbour compiler uses the usual  PUSHMEMVARREF opcode in such cases.
Notice that the runtime behavior  is the same in Clipper and in Harbour &eq. only the generated opcodes  are different.
.br
.br
:p.Handling of object messages
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.The HARBOUR&us.STRICT&us.CLIPPER&us.COMPATIBILITY setting determines  the way chained send messages are handled.
.br
:p.For example&comma. the following code&colon.
.br
:p.a&colon.b&lpar. COUNT&lpar.&rpar. &rpar.&colon.c +&eq. 1
.br
:p.will be handled as&colon.
.br
:p.a&colon.b&lpar. COUNT&lpar.&rpar. &rpar.&colon.c &colon.&eq. a&colon.b&lpar. COUNT&lpar.&rpar. &rpar.&colon.c + 1
.br
:p.in strict Clipper compatibility mode and
.br
:p.temp &colon.&eq. a&colon.b&lpar. COUNT&lpar.&rpar. &rpar.&comma. temp&colon.c +&eq. 1
.br
:p.in non&eq.strict mode.
.br
:p.In practice&comma. Clipper will call the COUNT&lpar.&rpar. function two times&colon.  the first time before addition and the second one after addition.  In Harbour&comma. COUNT&lpar.&rpar. will be called only once&comma. before
addition.
.br
:p.The Harbour &lpar.non&eq.strict&rpar. method is&colon.
:p.1&rpar. faster
:p.2&rpar. it guarantees that the same instance variable of the same object  will be changed
.br
:p.&lpar.See also&colon. source&slash.compiler&slash.expropt.c&rpar.
.br
:p.:hp2.Initialization of static variables      :ehp2.
:p.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.&eq.
.br
:p.There is a difference in the initialization of static  variables that are initialized with a codeblock that refers to  a local variable. For example&colon.
.br
      PROCEDURE TEST&lpar.&rpar.
.br
      LOCAL MyLocalVar
.br
      STATIC MyStaticVar &colon.&eq. &lbrc.&splitvbar.&splitvbar. MyLocalVar &rbrc.
.br

.br
        MyLocalVar &colon.&eq.0
.br
        ? EVAL&lpar. MyStaticVar &rpar.
.br

.br
      RETURN
.br
.br
:p.The above code compiles fine in Clipper&comma. but it generates a  runtime error Error&slash.BASE 1132 Bound error&colon. array access
:p.Called form &lpar.b&rpar.STATICS&dollar.&lpar.0&rpar.
.br
:p.In Harbour this code generates a compile time error&colon.  Error E0009 Illegal variable &lpar.b&rpar. initializer&colon. 'MyLocalVar'
.br
:p.Both Clipper and Harbour are handling all local variables used in a  codeblock in a special way&colon. they are detached from the local stack  of function&slash.procedure where they are declared. This allows access to  these
variables after the exit from a function&slash.procedure. However&comma.  all static variables are initialized in a separate procedure
:p.&lpar.'STATICS&dollar.' in Clipper and '&lpar.&us.INITSTATICS&rpar.' in Harbour&rpar. before the  main procedure and before all INIT procedures. The local variables  don't exist on the eval stack when static variables are
initialized&comma.  so they cannot be detached.
.br
:h2 id=NATIY res=439.HB_LANGSELECT()
:i2 refid=NATIOX.HB_LANGSELECT()
:p.HB&us.LANGSELECT&lpar.&rpar.
.br
.br
:hp2.Select a specific nation message module:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.LANGSELECT&lpar.<cNewLang>&rpar.   &minus.&minus.> cOldLang:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cNewLang>  The ID of the country language module  The possible values for <cNewLang> is below as is defined in the  Lang library&comma.sorted by language.
.br
:table cols='16 10 10'.
:row.
:c.&lt.cNewLang&gt.
:c.Language
:c.Codepage
:row.
:c.EU
:c.Basque
:c.850
:row.
:c.CS852
:c.Czech
:c.852
:row.
:c.CSISO
:c.Czech
:c.ISO-8859-2
:row.
:c.CSKAM
:c.Czech
:c.KAM
:row.
:c.CA
:c.Catalan
:c.850
:row.
:c.EN
:c.English
:c.437
:row.
:c.FR
:c.French
:c.850
:row.
:c.GL
:c.Galician
:c.850
:row.
:c.DE
:c.German
:c.850
:row.
:c.HE862
:c.Hebrew
:c.862
:row.
:c.HEWIN
:c.Hebrew
:c.1255
:row.
:c.HU852
:c.Hungarian
:c.852
:row.
:c.HUCWI
:c.Hungarian
:c.CWI-2
:row.
:c.HUWIN
:c.Hungarian
:c.Windows-1
:row.
:c.ID
:c.Indonesian
:c.437
:row.
:c.IS85
:c.Icelandic
:c.850
:row.
:c.IT
:c.Italian
:c.437
:row.
:c.KR
:c.Korean
:c.949
:row.
:c.PL852
:c.Polish
:c.852
:row.
:c.PLISO
:c.Polish
:c.ISO-8859-1
:row.
:c.PLMAZ
:c.Polish
:c.Mozowia
:row.
:c.PT
:c.Portuguese
:c.850
:row.
:c.RO
:c.Romanian
:c.852
:row.
:c.SRISO
:c.Serbian
:c.ISO-8859-2
:row.
:c.SR852
:c.Serbian
:c.852
:row.
:c.ES
:c.Spanish
:c.850
:etable.
.br
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cOldLang>   The old language indentifier
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function set a default language module for date&slash.month names&comma.  internal warnigs&comma.NatMsg messages and internal errors. When a  Lang ID is selected all messages will be output as the current lang  selected
until another one is selected or the program ends.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      REQUEST HB&us.LANG&us.PT
.br
      REQUEST HB&us.LANG&us.RO
.br
      REQUEST HB&us.LANG&us.ES
.br
      FUNCTION MAIN&lpar.&rpar.
.br
      HB&us.LANGSELECT&lpar.'PT'&rpar.       &slash.&slash. Default language is now Portuguese
.br
      ? CDOW&lpar.DATE&lpar.&rpar.&rpar. &slash.&slash.Segunda&minus.feira
.br
      ? 'Old language id selected is &cdq.&comma.HB&us.LANGSELECT&lpar.&rpar.   &slash.&slash. PT
.br
      HB&us.LANGSELECT&lpar.'RO'&rpar.       &slash.&slash. Default language is now Romanian
.br
      ? CMONTH&lpar.DATE&lpar.&rpar.&rpar. &slash.&slash. Mai
.br
      ? 'Old language id selected is &cdq.&comma.HB&us.LANGSELECT&lpar.&rpar.   &slash.&slash. RO
.br
      HB&us.LANGSELECT&lpar.'ES'&rpar.       &slash.&slash. Default language is now Romanian
.br
      ? CMONTH&lpar.DATE&lpar.&rpar.&rpar. &slash.&slash.       Mayo
.br
      ? CDOW&lpar.DATE&lpar.&rpar.&rpar. &slash.&slash.  Lunes
.br

.br
    Return nil
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See tests&slash.langapi.prg
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour Extension.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.Dos&comma.Win32&comma.OS&slash.2
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Libraty is rtl
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=440.HB_LANGNAME():elink.
.br
:link reftype=hd res=183.NATIONMSG():elink.
.br
:h2 id=NATIY res=440.HB_LANGNAME()
:i2 refid=NATIOX.HB_LANGNAME()
:p.HB&us.LANGNAME&lpar.&rpar.
.br
.br
:hp2.Return the Name of the Current Language module in USE:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.LANGNAME&lpar.&rpar.   &minus.&minus.> cLangName:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<cLangName>  Name of the Current language in use
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function return the current name of the language module in use.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      REQUEST HB&us.LANG&us.PT
.br
      REQUEST HB&us.LANG&us.RO
.br
      REQUEST HB&us.LANG&us.ES
.br
      FUNCTION MAIN&lpar.&rpar.
.br
      HB&us.LANGSELECT&lpar.'PT'&rpar.       &slash.&slash. Default language is now Portuguese
.br
      ? CDOW&lpar.DATE&lpar.&rpar.&rpar. &slash.&slash.Segunda&minus.feira
.br
      ? 'Current language is &cdq.&comma.HB&us.LANGNAME&lpar.&rpar. &slash.&slash.Portuguese
.br
      ? 'Old language id selected is &cdq.&comma.HB&us.LANGSELECT&lpar.&rpar.   &slash.&slash. PT
.br
      HB&us.LANGSELECT&lpar.'RO'&rpar.       &slash.&slash. Default language is now Romanian
.br
      ? CMONTH&lpar.DATE&lpar.&rpar.&rpar. &slash.&slash. Mai
.br
      ? 'Old language id selected is &cdq.&comma.HB&us.LANGSELECT&lpar.&rpar.   &slash.&slash. RO
.br
      HB&us.LANGSELECT&lpar.'ES'&rpar.       &slash.&slash. Default language is now Romanian
.br
      ? 'Current language is &cdq.&comma.HB&us.LANGNAME&lpar.&rpar. &slash.&slash.Spanish
.br
      ? CMONTH&lpar.DATE&lpar.&rpar.&rpar. &slash.&slash.       Mayo
.br
      ? CDOW&lpar.DATE&lpar.&rpar.&rpar. &slash.&slash.  Lunes
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See tests&slash.langapi.prg
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour Extension
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.Dos&comma.Win32&comma.OS&slash.2
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is lang
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=439.HB_LANGSELECT():elink.
.br
:link reftype=hd res=183.NATIONMSG():elink.
.br
:h2 id=ENVIY res=441.SETMODE()
:i2 refid=ENVIRX.SETMODE()
:p.SETMODE&lpar.&rpar.
.br
.br
:hp2.Change the video mode to a specified number of rows and columns:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.SETMODE&lpar. <nRows>&comma. <nCols> &rpar. &minus.&minus.> lSuccess:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nRows> is the number of rows for the video mode to set.
.br
:p.<nCols> is the number of columns for the video mode to set.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.SETMODE&lpar.&rpar. returns true if the video mode change was successful&semi.  otherwise&comma. it returns false.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.SETMODE&lpar.&rpar. is a function that change the video mode depend on the  video card and monitor combination&comma. to match the number of rows and  columns specified.  Note that there are only a real few combination or
rows&slash.cols pairs  that produce the video mode change.  The followings are availables for D.O.S&colon.
.br
:table cols='20 20'.
:row.
:c.12 rows x 40 columns
:c.12 rows x 80 columns
:row.
:c.25 rows x 40 columns
:c.25 rows x 80 columns
:row.
:c.28 rows x 40 columns
:c.28 rows x 80 columns
:row.
:c.50 rows x 40 columns
:c.43 rows x 80 columns
:row.
:c.
:c.50 rows x 80 columns
:etable.
.br
:p.The follow modes are avaliable to Windows
.br
:table cols='20 20'.
:row.
:c.25 rows x 40 columns
:c.25 rows x 80 columns
:row.
:c.50 rows x 40 columns
:c.43 rows x 80 columns
:row.
:c.
:c.50 rows x 80 columns
:etable.
.br
:p.Some modes only are availables for color and&slash.or VGA monitors.  Any change produced on the screen size is updated in the values  returned by MAXROW&lpar.&rpar. and MAXCOL&lpar.&rpar..
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
     The first example change to a 12 lines of display mode&colon.
.br
      IF SETMODE&lpar. 12&comma. 40&rpar.
.br
         ? &cdq.Hey man are you blind ?&cdq.
.br
      ELSE
.br
         ? &cdq.Mom bring me my glasses!&cdq.
.br
      ENDIF
.br

.br
     Next example change to a 50 lines mode&colon.
.br
      IF SETMODE&lpar. 50&comma. 80&rpar.
.br
         ? &cdq.This wonderful mode was successfully set&cdq.
.br
      ELSE
.br
         ? &cdq.Wait. this monitor are not made in rubber !&cdq.
.br
      ENDIF
.br

.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.Some of these modes are not availables on Clipper
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.DOS&comma.WIN32
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Source  is gtdos.c&comma.gtwin.c
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=442.MAXCOL():elink.
.br
:link reftype=hd res=443.MAXROW():elink.
.br
:h2 id=CODEY res=14.EVAL()
:i2 refid=CODEX.EVAL()
:p.EVAL&lpar.&rpar.
.br
.br
:hp2.Evaluate a code block:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.EVAL&lpar. <bBlock> &lbrk.&comma. <xVal> &lbrk.&comma....&rbrk..&rbrk..&rpar.   &minus.&minus.> xExpression:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<bBlock>   Code block expression to be evaluated
.br
:p.<xVal>     Argument to be passed to the code block expression
.br
:p.<xVal...>  Argument list to be passed to the code block expression
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<xExpression>  The result of the evaluated code block
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function evaluates the code bloc expressed as <bBlock> and  returns its evaluated value.If their are multiple expressions within  the code block&comma.the last expression will be value of this function.
.br
:p.If the code block requires parameters to be passed to it&comma.they are  specified in the parameter list <xVal> and following.Each parameter  is separated by a comma within the expression list.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      FUNC MAIN
.br
      LOCAL    sbBlock   &colon.&eq. &lbrc.&splitvbar.&splitvbar. NIL &rbrc.
.br
      ?  Eval&lpar. 1 &rpar.
.br
      ?  Eval&lpar. @sbBlock &rpar.
.br

.br
      ? Eval&lpar. &lbrc.&splitvbar.p1&splitvbar. p1 &rbrc.&comma.&cdq.A&cdq.&comma.&cdq.B&cdq.&rpar.
.br
      ? Eval&lpar. &lbrc.&splitvbar.p1&comma.p2&splitvbar. p1+p2 &rbrc.&comma.&cdq.A&cdq.&comma.&cdq.B&cdq.&rpar.
.br
      ? Eval&lpar. &lbrc.&splitvbar.p1&comma.p2&comma.p3&splitvbar. p1 &rbrc.&comma.&cdq.A&cdq.&comma.&cdq.B&cdq.&rpar.
.br
      Return Nil
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is Ca Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.Library is vm
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=10.AEVAL():elink.
.br
:link reftype=hd res=15.DBEVAL():elink.
.br
:h2 id=COMMY res=140.@...Get
:i2 refid=COMMAX.@...GET
:p.@...Get
.br
.br
:hp2.Creates a GET object and displays it to the screen:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.@ <nRow>&comma.<nCol> &lbrk.SAY <cSay> &lbrk.PICTURE <cSayPict>&rbrk.. COLOR <cSayColor> &rbrk..:ehp2.
:p.:hp2.GET <xVar> &lbrk.PICTURE <cGetPict>&rbrk.. &lbrk.WHEN <lWhen>&rbrk.. &lbrk.COLOR <cGetColor>&rbrk..:ehp2.
:p.:hp2.&lbrk.VALID <lValid> &slash. RANGE <xStart>&comma.<xEnd>&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nRow>      The row coordinate.
.br
:p.<nCol>      The column coordinate.
.br
:p.<cSay>      Message to display.
.br
:p.<cSayPict>  Character expression of PICTURE displayed.
.br
:p.<cSayColor> Color to be Used for the SAY expression.
.br
:p.<xVar>      An variable&slash.field name.
.br
:p.<cGetPict>  Character expression of PICTURE to get.
.br
:p.<lWhen>     Logical expression to allow GET.
.br
:p.<lValid>    Logical expression to validate GET input.
.br
:p.<xStart>    Lower RANGE value.
.br
:p.<xEnd>      Upper RANGE value.
.br
:p.<cGetColor> Color string to be used for the GET expression.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command adds a GET object to the reserved array variable  named GETLIST&lbrk.&rbrk.. and displays it to the screen. The field or variable  to be added to the GET object is specified in <xVar> and is displayed  at row&comma.
column coordinate <nRow>&comma. <nCol>.
.br
:p.If the SAY clause is used <cSay> will be displayed starting at  <nRow>&comma.<nCol>&comma. with the field variable <xVar> displayed at ROW&lpar.&rpar.&comma.  COL&lpar.&rpar.+ 1. If <cSayPicr>&comma. the picture template for the
SAY expression  <cSay>&comma. is used&comma. all formatting rules contained will apply See the  TRANSFORM I function for futher information.
.br
:p.If <cGetPict> is specified&comma. the PICTURE clause of <xVar> will be  used for the GET object and all formatting rules will apply. See  the table below for GET formatting rules.
.br
:p.If the WHEN clause is specified&comma.when <lWhen> evaluates to a logical  true &lpar..T.&rpar. condition&comma. the GET object will he activated otherwise the  GET object will be skipped and no information will be obtained via
the screen. The name of a user&minus.defined function returning a logical  true &lpar..T.&rpar. or false &lpar. F.&rpar. or a code block may be &comma.specified in <lWhen>  This clause not activated until a READ command or
READMODAL&lpar.&rpar.  function call is issued.
.br
:p.If the VALID clause is specified and <lValid> evaluates to it logical  true &lpar..T.&rpar. condition the current GET will be considered valid and  the get operation will continue onto the next active GET object. If  not&comma.
the cursor will remain on this GET object until aborted or  until the condition in <lValid> evaluates to true &lpar..T.&rpar.. The name  of a user&minus.defined function returning a logical true &lpar..T.&rpar. or false
&lpar..F.&rpar. or it code block may be specified in <lValid>. This clause is  not activated until a READ command or READMODAL&lpar. &rpar. function call is  issued.
.br
:p.If the RANGE clause is specified instead of the VALID clause&comma. the  two inclusive range values for <xVar> must be specified in <xStart>  and <xEnd>. Id <xVar> is a date data type&comma.<xStart> and <xEnd> must  also be date
data types&semi. if <xVar> is a numeric data type <xStart>  and <xEnd> must also be numeric data types. If a value fails the  RANGE test &comma.a message of OUT OF RANGE will appear in the SCOREBOARD  area &lpar.row &eq. 0&comma.
col &eq. 60&rpar..The RANGE message may be turned off it the  SET SCOREBOARD command or SET&lpar.&rpar. function appropriately toggled.
.br
:p.NOTE       GET functions&slash.formatting rules&colon.
.br
:table cols='15 64'.
:row.
:c.@A
:c.Allows only alphabetic characters.
:row.
:c.@B
:c.Numbers will be left justified
:row.
:c.@C
:c.All positive numbers will be followes by CR.
:row.
:c.@D
:c.All dates will be in the SET DATE format.
:row.
:c.@E
:c.Dates will be in British formal: numbers in European format.
:row.
:c.@K
:c.Allows a suggested value to be seen within the GET
:row.
:c.
:c.area but clears It if any noncu sor key is pressed when
:row.
:c.
:c.the cursor is in the first Position in the GET area.
:row.
:c.@R
:c.Nontemplate characters will be inserted.
:row.
:c.@S&lt.nSize&gt.
:c.Allows horizontal scrolling of a field or variable that
:row.
:c.
:c.is &lt.nSize&gt. characters wide.
:row.
:c.@X
:c.All negative numbers will be followed by DB
:row.
:c.@Z
:c.Displays zero values as blanks.
:row.
:c.@!
:c.Forces uppercase lettering
:row.
:c.@(
:c.Displays negative numbers in parentheses with leading spaces.
:row.
:c.@)
:c.Displays negative numbers in parentheses without leading spaces.
:etable.
.br
.br
:p.GET templates&slash.formatting rules&colon.
.br
:table cols=' 1 55'.
:row.
:c.A
:c.Only alphabetic characters allowed.
:row.
:c.N
:c.Only alphabetic and numeric characters allowed
:row.
:c.X
:c.Any character allowed.
:row.
:c.L
:c.Only T or F allowed For logical data.
:row.
:c.Y
:c.Only Y or N allowed for logical data.
:row.
:c.9
:c.Only digits, including signs, will be allowed.
:row.
:c.#
:c.Only digits, signs. and spaces will he allowed.
:row.
:c.!
:c.Alphabetic characters are converted to Uppercase.
:row.
:c.$
:c.Dollar  will be displayed in place of leading
:row.
:c.
:c.spaces for numeric data types.
:row.
:c.*
:c.Asterisk,, will Be displayed in place of leading spaces
:row.
:c.
:c.for numeric data types.
:row.
:c..
:c.Position of decimal point.
:row.
:c.,
:c.Position of comma.
:etable.
.br
:p.Format PICTURE functions may he grouped together as well as used  in Conjunction with a PICTURE templates&semi.however&comma. a blank space must  be included in the PICTURE string if there are both functions and  templates.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      Function Main&lpar.&rpar.
.br
      Local cVar&colon.&eq.Space&lpar.50&rpar.
.br
      Local nId&colon.&eq.0
.br
      cls
.br
      @ 3&comma.1 SAY &cdq.Name&cdq. GET cVar PICTURE &cdq.@!S 30&cdq.
.br
      @ 4&comma.1 SAY &cdq.Id&cdq.   GET nId  PICTURE &cdq.999.999&cdq.
.br
      READ
.br
      ? &cdq.The name you entered is&cdq.&comma.cVar
.br
      ? &cdq.The id you entered is&cdq.&comma.nId
.br
      RETURN NIL
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See Examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper compatible
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=32.@...SAY:elink.
.br
:link reftype=hd res=141.READ:elink.
.br
:link reftype=hd res=35.TRANSFORM():elink.
.br
:h2 id=COMMY res=32.@...SAY
:i2 refid=COMMAX.@...SAY
:p.@...SAY
.br
.br
:hp2.Displays data to specified coordinates of the current device.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.@ <nRow>&comma.<nCol> SAY <xValue> &lbrk. PICTURE <cPict> &rbrk.. &lbrk.COLOR <cColor>&rbrk..:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nRow>     Row coordinate
.br
:p.<nCol>     Column coordinate
.br
:p.<xValue>   Value to display
.br
:p.<cPict>    PICTURE format
.br
:p.<cColor>   Color string
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This command displays the contents of <xValue> at row column  coordinates <nRow>&comma. <nCol>. A PICTURE clause may be speclfied  in <cPict>. If the current device is set to the printer&comma. the output  will go to the
printer&semi. the default is for all output to go to  the screen.
.br
:p.For a complete list of PICTURES templates and functions&comma. see the  @...GET command.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      Function Main
.br
      Cls
.br
      @ 2&comma.1 SAY &cdq.Harbour&cdq.
.br
      @ 3&comma.1 SAY &cdq.is&cdq. COLOR &cdq.b&slash.r+&cdq.
.br
      @ 4&comma.1 SAY &cdq.Power&cdq. PICTURE &cdq.@!&cdq.
.br
      Return NIL
.br
.br
.br
:hp2.Tests:ehp2.
.br
:p.
:lm margin=6.
.br
      See Examples
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Ready
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This command is Ca&minus.Clipper compliant
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
.br
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=140.@...GET:elink.
.br
:link reftype=hd res=294.SET DEVICE:elink.
.br
:link reftype=hd res=35.TRANSFORM():elink.
.br
:h2 id=DOCUY res=444.Strong Typing
:i2 refid=DOCUMX.STRONG TYPING
:p.Strong Typing
.br
.br
:hp2.Compile&minus.Time type checking:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.Strong Type Checking&comma. could also be described as &cdq.Compile&minus.Time Type  Checking&cdq.. As you might know Clipper&comma. generates a Run&minus.Time Error&comma.  &lpar.&cdq.Type Mismatch&cdq.&rpar. when we attempt to
perform some operations with  the wrong type of Variable.
.br
:p.Examples&colon.
.br
:p.LOCAL Var1 &colon.&eq. &cdq.A&cdq.
.br
:p.? Var1 * 3 &slash.&slash. Error here.
.br
:p.@ Var1&comma. 7 SAY 'Hello' &slash.&slash. Error here.
.br
:p.? SubStr&lpar. &cdq.Hello&cdq.&comma. Var1 &rpar. &slash.&slash. Error here.
.br
:p.The above 3 lines would all result in Run&minus.Time Error&comma. because Var1 is  of type CHARACTER but the above lines used it as if it was of type  NUMERIC.
.br
:p.Using Strong Type Checking&comma. or Compile&minus.Time Type Checking&comma. the above  problem would have been discovered and reported in COMPILE&minus.TIME&comma.  rather than waiting for the inevitable problem to be discovered
when  we finally execute the program.
.br
:p.Strong Typed Languages allow the programmer to &cdq.tell&cdq. the compiler &lpar.declare&rpar.  what is the type of a each Variable&comma. so that the Compiler in return can warn  the programmer&comma. when ever such Declared
&lpar.Strong Typed&rpar. Variable&comma. is used in  a context which is incompatible with its declared type.
.br
:p.For instance&comma. if we &cdq.told&cdq. the compiler that Var1 above is of type  CHARACTER &lpar.LOCAL Var1 AS CHARACTER&rpar. the Harbour Compiler could&comma. in  return&comma. warn us if we attempted to perform the
calculation&colon.
.br
:p.Var1 * 3
.br
:p.because the Compiler knows we can't perform a multiplication of a  Character. &lpar.we might allow it in some context&comma. but this is beyond  the scope of this discussion&rpar.. Similarly we would have been warned  when
attempting to use Var1 as a Row Number &lpar. @ Var1 &rpar.&comma. or as the  2nd operand of the SubStr&lpar.&rpar. function SubStr&lpar. &cdq.Hello&cdq.&comma. Var1&rpar. &rpar.&comma.  because the Compiler knows that these
operations require a NUMERIC  rather than CHARACTER type.
.br
:p.The above may save us lots of time&comma. by pointing a problem&comma. we can not  escape&comma. since such code will never perform correctly once executed.  So rather than wait to the testing cycle&comma. for such problems to be
discovered&comma. &lpar.and some times even later&comma. after we may have  distributed our applications&rpar. instead we may know of such problems  as soon as we type HARBOUR ProgName &minus.w3
.br
:p.Harbour also offers a hybrid mode&comma. where it can report such type  mismatch problems&comma. even without requiring the programmer to declare  the type of variables. This feature&comma. is referred to as Adaptive Type
Checking. The programmer&comma. is not required to make any changes in his  code&comma. to take advantage of this feature. All of the above 3 errors  would have been reported just as effectively as if the programmer  Strong Typed
&lpar.declared&rpar. Var1. Harbour would have been able to report  such problems at compile time&comma.because the assignment Var1 &colon.&eq. &cdq.A&cdq.  implied that Var1 is of type CHARACTER&comma.until it will be assigned
another value. Therefore Harbour will &cdq.remember&cdq. that Var1 &cdq.adapted&cdq.  type CHARACTER&comma. and thus the subsequent multiplication Var1 * 3&comma. will  be reported as an error&comma. a
s soon as you attempt to compile such code.
.br
:p.The nice aspect of this hybrid mode&comma. is that unlike Strong Typed  Variables&comma.you don't have to declare the type&comma. so no code changes  are need&comma. the Type instead is assumed by implication &lpar.type of the
assigned value&rpar.. The other benefit&comma. is that it is completely ok to  assign a new value of different type&comma. any time&comma. to such undeclared  &lpar.variant&rpar. variable. As soon as we assign a new type&comma.
the Compiler  will than protect us from using the Variable in an incompatible  context&comma. since the variable &cdq.adapted&cdq. this type as soon as we  assigned a value which implies a type.
.br
:p.While Adapted Type Checking may be fairly effective in reporting many  common mistakes&comma. to take full benefits of such Compile&minus.Time checking&comma.  it is recommended to do declare the Type of Variables&comma. when
ever  possible.
.br
:p.The Harbour Strong Type features&comma. also allows the declaration of the  expected parameters &lpar.including optionals&rpar. of User Defined Functions&comma.  as well as their return Type. Similarly&comma. you may declare the
Type of  any Class Variables&comma. Methods&comma. and Methods Parameters.
:h2 id=DOCUY res=445.The Garbage Collector
:i2 refid=DOCUMX.THE GARBAGE COLLECTOR
:p.The Garbage Collector
.br
.br
:hp2.Readme for Harbour Garbage Collect Feature:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The garbage collector uses the following logic&colon.  &minus. first collect all memory allocations that can cause the garbage&semi.  &minus. next scan all variables if these memory blocks are still referenced.
.br
:p.Notice that only arrays&comma. objects and codeblocks are collected because  these are the only datatypes that can cause self&minus.references &lpar.a&lbrk.1&rbrk..&colon.&eq.a&rpar.  or circual references
&lpar.a&lbrk.1&rbrk..&colon.&eq.b&semi. b&lbrk.1&rbrk..&colon.&eq.c&semi. c&lbrk.1&rbrk..&colon.&eq.a&rpar. that cannot be  properly deallocated by simple reference counting.
.br
:p.Since all variables in harbour are stored inside some available tables  &lpar.the eval stack&comma. memvars table and array of static variables&rpar. then checking  if the reference is still alive is quite easy and don't require
any  special treatment during memory allocation. Additionaly the garbage  collector is scanning some internal data used by harbour objects  implementation that stores also some values that can contain memory  references. These
data are used to initialize class instance variables  and are stored in class shared variables.
.br
:p.In special cases when the value of harbour variable is stored internally  in some static area &lpar.at C or assembler level&rpar.&comma. for example SETKEY&lpar.&rpar.  stores codeblocks that will be evaluated when a key is
pressed&comma.  the garbage collector will be not able to scan such values since it  doesn't know their location. This can cause that some memory blocks will be  released prematurely. To prevent the premature deallocation of such
memory  blocks they have to be locked for the garbage collector. The memory block  can be locked with hb&us.gcLockItem&lpar.&rpar. function &lpar.recommendeed method&rpar. if  harbour item structure is used or
hb&us.gcLock&lpar.&rpar. function if direct memory  pointer is used. The memory block can be unlocked by hb&us.gcUnlockItem&lpar.&rpar. or  hb&us.gcUnlock&lpar.&rpar. functions.
.br
:p.Notice however that all variables passed to a low level function are  passed via the eval stack then they don't require locking during the  function call. The locking will be required if passed value is copied  into some static
area to make it available for other low&minus.level functions  called after the exit from function that stored the value. This is required  because the value is removed from the eval stack after function call and  it can be no
longer referenced by other variables.
.br
:p.However scanning of all variables can be a time consuming operation. It  requires that all allocated arrays have to be traversed through all its  elements to find more arrays. Also all codeblocks are scanned for detached  local
variables they are reffering. For this reason looking for unreferenced  memory blocks is performed during the idle states.
.br
:p.The idle state is a state when there is no real application code  executed&comma.for example&comma. the user code is stopped for 0.1 of a second  during INKEY&lpar.0.1&rpar. call &minus. the harbour is checking the keyboard only
during this time. It leaves however quite enough amount of time for  many other background tasks. One of such background task can be looking  for unreferenced memory blocks.
.br
:p.Allocating memory
:p.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
.br
:p.The garbage collector collects memory blocks allocated with hb&us.gcAlloc&lpar.&rpar.  function calls. Memory allocated by hb&us.gcAlloc&lpar.&rpar. should be released with  hb&us.gcFree&lpar.&rpar. function.
.br
:p.Locking memory
:p.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
.br
:p.The memory allocated with hb&us.gcAlloc&lpar.&rpar. should be locked to prevent the  automatic releasing if such memory pointer is not stored within a  harbour level variable. All harbour values &lpar.items&rpar. stored
internally  in static C area have to be locked.  See hb&us.gcLockItem&lpar.&rpar. and hb&us.gcUnlockItem&lpar.&rpar. for more information.
.br
:p.The garbage collecting
:p.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
.br
:p.During scanning of unreferenced memory the GC is using mark &amp. sweep  algorithm. This is done in three steps&colon.
.br
:p.1&rpar. mark all memory blocks allocated by the GC with unused flag&semi.
.br
:p.2&rpar. sweep &lpar.scan&rpar. all known places and clear unused flag for memory  blocks that are referenced there&semi.
.br
:p.3&rpar. finalize collecting by deallocation of all memory blocks that are  still marked as unused and that are not locked.
.br
:p.To speed things the mark step is simplified by swapping the meaning  of unused flag. After deallocation of unused blocks all still alive  memory blocks are marked with the same 'used' flag so we can reverse  the meaning of this
flag to 'unused' state in the next collecting.  All new or unlocked memory blocks are automatically marked as 'unused'  using the current flag&comma. which assures that all memory blocks are marked  with the same flag before the
sweep step will start.  See hb&us.gcCollectAll&lpar.&rpar.  and hb&us.gcItemRef&lpar.&rpar.
.br
:p.Calling the garbage collector from harbour code
:p.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.&minus.
.br
:p.The garbage collector can be called directly from the harbour code.  This is usefull in situations where there is no idle states available  or the application is working in the loop with no user interaction  and there is many
memory allocations.  See HB&us.GCALL&lpar.&rpar. for explanation of how to call this function from your  harbour code.
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=446.HB_GCALLOC():elink.
.br
:link reftype=hd res=447.HB_GCFREE():elink.
.br
:link reftype=hd res=448.HB_GCLOCKITEM():elink.
.br
:link reftype=hd res=449.HB_GCUNLOCKITEM():elink.
.br
:link reftype=hd res=450.HB_GCCOLLECTALL():elink.
.br
:link reftype=hd res=451.HB_GCITEMREF():elink.
.br
:link reftype=hd res=452.HB_GCALL():elink.
.br
:h1 THEY.THE GARBAGE COLLECTOR
:h2  res=446.hb_gcAlloc()
:i1 id=THE GX.THE GARBAGE COLLECTOR
:i2 refid=THE GX.HB_GCALLOC()
:p.hb&us.gcAlloc&lpar.&rpar.
.br
.br
:hp2.Allocates memory that will be collected by the garbage collector.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.#include <hbapi.h>:ehp2.
:p.:hp2.void *hb&us.gcAlloc&lpar. ULONG ulSize&comma.:ehp2.
:p.:hp2.HB&us.GARBAGE&us.FUNC&us.PTR pCleanupFunc &rpar.&semi.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<ulSize> Requested size of memory block
.br
:p.<pCleanupFunc> Pointer to HB&us.GARBAGE&us.FUNC function that will be called  directly before releasing the garbage memory block or NULL. This  function should release all other memory allocated and stored inside  the memory
block. For example&comma. it releases all items stored inside  the array. The functions receives a single parameter&colon. the pointer  to memory allocated by hb&us.gcAlloc&lpar.&rpar..
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.The pointer to allocated memory or it generates an internal  unrecoverable error.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.hb&us.gcAlloc&lpar.&rpar. is used to allocate the memory that will be tracked  by the garbage collector. It allows to properly release memory  in case of self&minus.referencing or cross&minus.referencing harbour level  variables.
Memory allocated with this function should be released with  hb&us.gcFree&lpar.&rpar. function or it will be automatically deallocated  by the GC if it is not locked or if it is not referenced by some  harbour level variable.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      See source&slash.vm&slash.arrays.c
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Not Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.source&slash.vm&slash.garbage.c
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=447.HB_GCFREE():elink.
.br
:link reftype=hd res=448.HB_GCLOCKITEM():elink.
.br
:link reftype=hd res=449.HB_GCUNLOCKITEM():elink.
.br
:h2 id=THEY res=447.hb_gcFree()
:i2 refid=THE GX.HB_GCFREE()
:p.hb&us.gcFree&lpar.&rpar.
.br
.br
:hp2.Releases the memory that was allocated with hb&us.gcAlloc&lpar.&rpar..:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.void hb&us.gcFree&lpar. void *pMemoryPtr &rpar.&semi.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<pMemoryPtr> The pointer to memory for release. This memory  pointer have to be allocated with hb&us.gcAlloc&lpar.&rpar. function.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Nothing.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.hb&us.gcFree&lpar.&rpar. is used to deallocate the memory that was  allocated with the hb&us.gcAlloc&lpar.&rpar. function.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      See source&slash.vm&slash.arrays.c
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Not Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.source&slash.vm&slash.garbage.c
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=446.HB_GCALLOC():elink.
.br
:link reftype=hd res=448.HB_GCLOCKITEM():elink.
.br
:link reftype=hd res=449.HB_GCUNLOCKITEM():elink.
.br
:h2 id=THEY res=448.hb_gcLockItem()
:i2 refid=THE GX.HB_GCLOCKITEM()
:p.hb&us.gcLockItem&lpar.&rpar.
.br
.br
:hp2.Locks the memory to prevent deallocation by the garbage collector.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.void hb&us.gcLockItem&lpar. HB&us.ITEM&us.PTR pItem &rpar.&semi.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<pItem> The pointer to item structure that will be locked. The  passed item can be of any datatype although arrays&comma. objects  and codeblocks are locked only. Other datatypes don't require  locking so they are simply ignored.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Nothing.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.hb&us.gcLockItem&lpar.&rpar. is used to lock the memory pointer stored in  the passed item structure. It suppres the memory releasing  if the garbage collector will not find any reference to this  pointer. The garbage collector
is storing the lock counter &minus.  every call of this function increases the counter. The item is  locked if this counter is greather then 0.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      See source&slash.rtl&slash.setkey.c
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Not Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.source&slash.vm&slash.garbage.c
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=446.HB_GCALLOC():elink.
.br
:link reftype=hd res=447.HB_GCFREE():elink.
.br
:link reftype=hd res=449.HB_GCUNLOCKITEM():elink.
.br
:h2 id=THEY res=449.hb_gcUnlockItem()
:i2 refid=THE GX.HB_GCUNLOCKITEM()
:p.hb&us.gcUnlockItem&lpar.&rpar.
.br
.br
:hp2.Unlocks the memory to prevent deallocation by the garbage collector.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.void hb&us.gcUnlockItem&lpar. HB&us.ITEM&us.PTR pItem &rpar.&semi.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<pItem> The pointer to item structure that will be unlocked. The  passed item can be of any datatype although arrays&comma. objects  and codeblocks are unlocked only. Other datatypes don't require  locking so they are simply
ignored.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Nothing.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.hb&us.gcUnlockItem&lpar.&rpar. is used to unlock the memory pointer stored in  the passed item structure that was previously locked with  hb&us.gcLockItem&lpar.&rpar. call. It allows to release the memory during  garbage
collecting if the garbage collector will not find any  reference to this pointer. The garbage collector is storing the  lock counter &minus. every call of this function decreases the counter.  This function doesn't deallocate
memory stored inside the item &minus.  the memory can be deallocated however during the closest garbage  collecting if the lock counter is equal to 0 and the memory pointer  is not referenced
by any harbour level variable.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      See source&slash.rtl&slash.setkey.c
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Not Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.source&slash.vm&slash.garbage.c
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=446.HB_GCALLOC():elink.
.br
:link reftype=hd res=447.HB_GCFREE():elink.
.br
:link reftype=hd res=448.HB_GCLOCKITEM():elink.
.br
:h2 id=THEY res=450.hb_gcCollectAll()
:i2 refid=THE GX.HB_GCCOLLECTALL()
:p.hb&us.gcCollectAll&lpar.&rpar.
.br
.br
:hp2.Scans all memory blocks and releases the garbage memory.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.void hb&us.gcCollectAll&lpar. void &rpar.&semi.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Nothing.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function scans the eval stack&comma. the memvars table&comma. the array  of static variables and table of created classes for referenced  memory blocks. After scanning all unused memory blocks and blocks  that are not locked
are released.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Not Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.source&slash.vm&slash.garbage.c
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=446.HB_GCALLOC():elink.
.br
:link reftype=hd res=447.HB_GCFREE():elink.
.br
:link reftype=hd res=448.HB_GCLOCKITEM():elink.
.br
:link reftype=hd res=449.HB_GCUNLOCKITEM():elink.
.br
:h2 id=THEY res=451.hb_gcItemRef()
:i2 refid=THE GX.HB_GCITEMREF()
:p.hb&us.gcItemRef&lpar.&rpar.
.br
.br
:hp2.Marks the memory to prevent deallocation by the garbage collector.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.void hb&us.gcItemRef&lpar. HB&us.ITEM&us.PTR pItem &rpar.&semi.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<pItem>  The pointer to item structure that will be scanned. The  passed item can be of any datatype although arrays&comma. objects  and codeblocks are scanned only. Other datatypes don't require  locking so they are simply
ignored.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Nothing.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The garbage collector uses hb&us.gcItemRef&lpar.&rpar. function during  scanning of referenced memory pointers. This function checks the  type of passed item and scans recursively all other memory blocks  referenced by this item
if it is an array&comma. an object or a codeblock.
.br
:p.NOTE&colon. This function is reserved for the garbage collector only. It  cannot be called from the user code &minus. calling it can cause  unpredicted results &lpar.memory blocks referenced by the  passed item can be released
prematurely during the closest  garbage collection&rpar..
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
Not Started
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.source&slash.vm&slash.garbage.c
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=446.HB_GCALLOC():elink.
.br
:link reftype=hd res=447.HB_GCFREE():elink.
.br
:link reftype=hd res=448.HB_GCLOCKITEM():elink.
.br
:link reftype=hd res=449.HB_GCUNLOCKITEM():elink.
.br
:h2 id=THEY res=452.HB_GCALL()
:i2 refid=THE GX.HB_GCALL()
:p.HB&us.GCALL&lpar.&rpar.
.br
.br
:hp2.Scans the memory and releases all garbage memory blocks.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.GCALL&lpar.&rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.NIL
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This function releases all memory blocks that are considered  as the garbage.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.This function is a Harbour extension
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.source&slash.vm&slash.garbage.c
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=450.HB_GCCOLLECTALL():elink.
.br
:h2 id=DOCUY res=453.The idle states
:i2 refid=DOCUMX.THE IDLE STATES
:p.The idle states
.br
.br
:hp2.Read me file for Idle States:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.The idle state is the state of the harbour virtual machine when it  waits for the user input from the keyboard or the mouse. The idle  state is entered during INKEY&lpar.&rpar. calls currently. All applications  that don't use
INKEY&lpar.&rpar. function call can signal the idle states with  the call of HB&us.IDLESTATE&lpar.&rpar. function &lpar.or hb&us.idleState&lpar.&rpar. on C level&rpar..
.br
:p.During idle states the virtual machine calls the garbage collector and  it can call user defined actions &lpar.background tasks&rpar.. It also releases  the CPU time slices for some poor platforms that are not smart enough
&lpar.Windows NT&rpar..
.br
:p.For defining the background tasks see the HB&us.IDLEADD&lpar.&rpar. and HB&us.IDLEDEL&lpar.&rpar.  functions.
.br
:p.For direct call for background actions see HB&us.IDLESTATE&lpar.&rpar. function.
.br
:p.For signaling the idle state from C code see the hb&us.idleState&lpar.&rpar.  API function.
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=454.HB_IDLEADD():elink.
.br
:link reftype=hd res=455.HB_IDLEDEL():elink.
.br
:h2 id=THEY res=454.HB_IDLEADD()
:i1 id=THE IX.THE IDLE STATES
:i2 refid=THE IX.HB_IDLEADD()
:p.HB&us.IDLEADD&lpar.&rpar.
.br
.br
:hp2.Adds the background task.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.IDLEADD&lpar. <cbAction> &rpar. &minus.&minus.> nHandle:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<cbAction> is an codeblock that will be executed during idle states.  There is no arguments passed to this codeblock during evaluation.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<nHandle> The handle &lpar.an integer value&rpar. that identifies the task. This  handle can be used during deleting the task.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.HB&us.IDLEADD&lpar.&rpar. adds a passed codeblock to the list of background  tasks that will be evaluated during the idle states. There is no  limit for the number of tasks.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      nTask &colon.&eq. HB&us.IDLEADD&lpar. &lbrc.&splitvbar.&splitvbar. SayTime&lpar.&rpar.&rbrc. &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.Harbour extension simmilar to FT&us.ONIDLE&lpar.&rpar. function available  in NanForum library.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.source&slash.rtl&slash.idle.c
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=455.HB_IDLEDEL():elink.
.br
:link reftype=hd res=456.HB_IDLESTATE():elink.
.br
:h2 id=THEY res=455.HB_IDLEDEL()
:i2 refid=THE IX.HB_IDLEDEL()
:p.HB&us.IDLEDEL&lpar.&rpar.
.br
.br
:hp2.Removes the background task from the list of tasks.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.IDLEDEL&lpar. <nHandle> &rpar. &minus.&minus.> xAction:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.<nHandle> is the identifier of the task returned by the  HB&us.IDLEADD&lpar.&rpar. function.
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.<xAction> NIL if invalid handle is passed or a codeblock that was  passed to HB&us.IDLEADD&lpar.&rpar. function
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.HB&us.IDLEDEL&lpar.&rpar. removes the action associated with passed identifier  from the list of background tasks. The identifer should be the  value returned by the previous call of HB&us.IDLEADD&lpar.&rpar. function.
.br
:p.If specified task is defined then the codeblock is returned  otherwise the NIL value is returned.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      nTask &colon.&eq. HB&us.IDLEADD&lpar. &lbrc.&splitvbar.&splitvbar. SayTime&lpar.&rpar.&rbrc. &rpar.
.br
      INKEY&lpar.10&rpar.
.br
      cbAction &colon.&eq. HB&us.IDLEDEL&lpar. nTask &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.Harbour extension
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.source&slash.rtl&slash.idle.c
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=454.HB_IDLEADD():elink.
.br
:link reftype=hd res=456.HB_IDLESTATE():elink.
.br
:h2 id=THEY res=456.HB_IDLESTATE()
:i2 refid=THE IX.HB_IDLESTATE()
:p.HB&us.IDLESTATE&lpar.&rpar.
.br
.br
:hp2.Evaluates a single background task and calls the garbage collector.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.HB&us.IDLESTATE&lpar.&rpar.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.NIL
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.HB&us.IDLESTATE&lpar.&rpar. requests the garbage collecting and executes a  single background task defined by the codeblock code passed with  HB&us.IDLEADD&lpar.&rpar. function. Every call for this function evaluates  different
task in the order of tasks creation. There is no  arguments passed during a codeblock evaluation.
.br
:p.This function can be safely called even if there are no background  tasks defined.
.br
.br
:hp2.Examples:ehp2.
.br
:p.
:lm margin=6.
.br
      nTask1 &colon.&eq. HB&us.IDLEADD&lpar. &lbrc.&splitvbar.&splitvbar. SayTime&lpar.&rpar.&rbrc. &rpar.
.br
      nTask2 &colon.&eq. HB&us.IDLEADD&lpar. &lbrc.&splitvbar.&splitvbar. SaveScreen&lpar.&rpar.&rbrc. &rpar.
.br
      DO WHILE&lpar. !bFinished &rpar.
.br
        bFinished &colon.&eq.DOSomethingVeryImportant&lpar.&rpar.
.br
        HB&us.IdleState&lpar.&rpar.
.br
      ENDDO
.br
      cbAction &colon.&eq. HB&us.IDLEDEL&lpar. nTask1 &rpar.
.br
      HB&us.IDLEDEL&lpar. nTask2 &rpar.
.br
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour
.br
.br
:hp2.Compliance:ehp2.
.br
:p.
:lm margin=6.
:p.Harbour extension similar to FT&us.IAMIDLE&lpar.&rpar. function available  in NanForum library.
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.source&slash.rtl&slash.idle.c
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=454.HB_IDLEADD():elink.
.br
:link reftype=hd res=455.HB_IDLEDEL():elink.
.br
:h2 id=THEY res=456.hb_idleState()
:i2 refid=THE IX.HB_IDLESTATE()
:p.hb&us.idleState&lpar.&rpar.
.br
.br
:hp2.Evaluates a single background task and calls the garbage collector.:ehp2.
.br
:p.
:lm margin=6.
.br
:hp2.Syntax:ehp2.
.br
:p.
:lm margin=6.
:p.:hp2.void hb&us.idleState&lpar. void &rpar.&semi.:ehp2.
.br
.br
:hp2.Arguments:ehp2.
.br
:p.
:lm margin=6.
:p.None
.br
.br
:hp2.Returns:ehp2.
.br
:p.
:lm margin=6.
:p.Nothing
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.hb&us.idleState&lpar.&rpar. requests the garbage collecting and executes a  single background task defined by the codeblock code passed with  HB&us.IDLEADD&lpar.&rpar. function. It also releases the CPU time slices for  platforms
that require it.
.br
:p.Every call for this function evaluates different task in the  order of tasks creation. There is no arguments passed during  a codeblock evaluation.
.br
:p.This function can be safely called even if there are no background  tasks defined.
.br
:p.This function is automatically called from INKEY&lpar.&rpar. function.
.br
:hp2.Status:ehp2.
.br
:p.
:lm margin=6.
      Harbour
.br
.br
:hp2.Platforms:ehp2.
.br
:p.
:lm margin=6.
:p.All
.br
.br
:hp2.Files:ehp2.
.br
:p.
:lm margin=6.
:p.source&slash.rtl&slash.idle.c
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=454.HB_IDLEADD():elink.
.br
:link reftype=hd res=455.HB_IDLEDEL():elink.
.br
:link reftype=hd res=456.HB_IDLESTATE():elink.
.br
:h2 id=DOCUY res=457.Command line Utility
:i2 refid=DOCUMX.COMMAND LINE UTILITY
:p.Command line Utility
.br
.br
:hp2.Compiler Options:ehp2.
.br
:p.
:lm margin=6.
.br
.br
:hp2.Description:ehp2.
.br
:p.
:lm margin=6.
:p.This spec goes for CLIPPERCMD&comma. HARBOURCMD&comma. Harbour compiler and  #pragma directives in the source code.
.br
:p.The command line always overrides the envvar.
.br
:p.Note that some switches are not accepted in envvar&comma.some others in  #pragmas.
.br
:p.First the parser should start to step through all the tokens in the  string separated by whitespace. &lpar.or just walk through all argv&lbrk.&rbrk..&rpar.
.br
:p.1.&rpar. If the token begins with &cdq.&minus.&cdq.&comma. it should be treated as a new style  switch.
.br
:p.One or more switch characters can follow this. The &cdq.&minus.&cdq. sign inside  the token will turn off the switch.
.br
:p.If the switch has an argument all the following characters are  treated as part of the argument.
.br
:p.The &cdq.&slash.&cdq. sign has no special meaning here.
.br
:table cols='21 27'.
:row.
:c.Switch
:c.Result option
:row.
:c.
:row.
:c.-wn
:c.( W N )
:row.
:c.-w-n
:c.( !W N )
:row.
:c.-wi/harbour/include/
:c.( W I=/harbour/include/ )
:row.
:c.-wi/harbour/include/n
:c.( W I=/harbour/include/n )
:row.
:c.-wes0n
:c.( W ES=0 N )
:row.
:c.-wen
:c.( W [invalid switch: e] N )
:row.
:c.-wesn
:c.( W ES=default(0) N )
:row.
:c.-wses
:c.( W S ES=default(0) )
:row.
:c.-wess
:c.( W ES=default(0) S )
:row.
:c.-
:c.( [invalid switch] )
:row.
:c.-w-n-p
:c.( !W !N P )
:row.
:c.-w-n-p-
:c.( !W !N !P )
:row.
:c.-w- -w -w-
:c.( finally: !W )
:etable.
.br
.br
:p.2.&rpar. If the token begins with &cdq.&slash.&cdq.&comma. it should be treated as a compatibility  style switch.
.br
:p.The parser scans the token for the next &cdq.&slash.&cdq. sign or EOS and treats  the resulting string as one switch.
.br
:p.This means that a switch with an argument containing &cdq.&slash.&cdq. sign has  some limitations. This may be solved by allowing the usage of quote  characters. This is mostly a problem on systems which use &cdq.&slash.&cdq. as
path separator.
.br
:p.The &cdq.&minus.&cdq. sign has no special meaning here&comma. it can't be used to  disable a switch.
.br
:table cols='18 55'.
:row.
:c.Switch
:c.Result option
:row.
:c.
:row.
:c./w/n
:c.( W N )
:row.
:c./wo/n
:c.( [invalid switch: wo] N )
:row.
:c./ihello/world/
:c.( I=hello [invalid switch: world] [invalid switch: /] )
:row.
:c./i"hello/world/"/w
:c.( I=hello/world/ W )
:row.
:c./ihello\world\
:c.( I=hello\world\ )
:etable.
.br
.br
:p.3.&rpar. If the token begins with anything else it should be skipped.
.br
:p.The Harbour switches are always case insensitive.
.br
:p.In the Harbour commandline the two style can be used together&colon.
:p.HARBOUR &minus.wnes2 &slash.gc0&slash.q0 &minus.ic&colon.\hello
.br
:p.Exceptions&colon.
.br
:p.&minus. Handlig of the &slash.CREDIT undocumented switch on Harbour command line  is unusual&comma. check the current code for this.
.br
:p.&minus. The CLIPPER&comma. HARBOUR and Harbour application command line parsing  is a different beast&comma. see CMDARG.C for a NOTE.
.br
:p.Notes&colon.
.br
:p.&minus. All occurences where a path is accepted&comma. Harbour should handle the  quote char to specify path containing space&comma. negative sign&comma. slash&comma.  or any other chars with special meaning.
.br
:p.&slash.i&cdq.c&colon.&slash.hello&slash.&cdq.
:p.&minus.i&cdq.c&colon.&slash.hello&minus.n&cdq.
:p.&slash.i&cdq.c&colon.&slash.program files&slash.&cdq.
:p.&minus.i&cdq.c&colon.&slash.program files&slash.&cdq.
.br
        Just some examples for the various accepted forms&colon.
.br
        &slash.&slash.F20 &eq.&eq. &slash.F20 &eq.&eq. F20 &eq.&eq. F&colon.20 &eq.&eq. F20X
.br
        &slash.&slash.TMPPATH&colon.C&colon.\HELLO
.br
        F20&slash.&slash.TMPPATH&colon.&slash.TEMP&slash.&slash.&slash.F&colon.30000000 NOIDLE
.br
        F0NOIDLEX10
.br
        SQUAWKNOIDLE
.br
:p.&cdq.&slash.&slash.&cdq. should always be used on the command line.
.br
.br
:hp2.See Also&colon.:ehp2.
.br
:p.
:lm margin=6.
:link reftype=hd res=438.COMPILER OPTIONS:elink.
.br
:euserdoc.
