//===============================================================
// vcmd.cxx - vCmd class
//
// Copyright (C) 1995,1996,1997,1998  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================
#include <v/vos2.h>		// for OS/2 stuff
#include <v/vapp.h>
#include <v/vcmd.h>
#include <v/vcmdprnt.h>
#include <v/vutil.h>

//===================>>> vCmd::vCmd <<<=======================
  vCmd::vCmd(vCmdParent* dp, CommandObject* co)
  {
    // We had to make this a non-inline to get access
    // to the vcmdprnt definitons.
    _parentWin = dp;			// dialog class parent
    dlgCmd = co;			// static data structure
    wParent = 0;			// parent window
    _origVal = co->retVal;		// save orignal state
    _validLblHeight = 0;                // label height not known yet
    _labelHeight = 0;
  }

//===================>>> vCmd::CopyToLocal <<<=======================
  void vCmd::CopyToLocal(void)
  {
    // Copy static values to local copy
    _title = dlgCmd->title;
    if (!_title || *_title == 0)
      _title = "";
    _cmdId = dlgCmd->cmdId;
    _retVal = dlgCmd->retVal;
    _Sensitive = dlgCmd->Sensitive;
    _itemList = dlgCmd->itemList;
  }

//===================>>> vCmd::vCmdCallback <<<=======================
  void vCmd::CmdCallback(UINT uMsg, MPARAM mp1, MPARAM mp2)
  {
    _parentWin->ProcessCmd(dlgCmd->cmdId, dlgCmd->retVal, dlgCmd->cmdType);
  }

//===================>>> vCmd::GetMyHwnd <<<=======================
  HWND vCmd::GetMyHwnd(ItemVal id) VCONST
  {
    return WinWindowFromID(_parentWin->getParent(), id);
  }

//===================>>> vCmd::LabelWidth <<<=======================
  int vCmd::LabelWidth(char* lbl) VCONST
  {
    // We create a temporary and invisible client window here to
    // gather font metric info for use in sizing labels in dialogs.
    // Since dialogs are sized in dialog-units relative to
    // the default dialog font, we first have to compute
    // the number of pixels in a dialog-unit.  Once we have
    // that info we compute the length in pixels of the label using
    // the desired font (8.Helv) and then convert to dialog-units.
    // We need to do this because every display driver uses different
    // default font sizes and so there is no simple way to map text
    // to dialog-units.

    int len = 0;

    // register the font probe window class
    WinRegisterClass(theApp->AppHab(),
      "MyProbeClass",     // window-class name
      0L,                 // no window-procedure required
      0L,                 // default window style
      4L);                // reserved storage

    HWND hProbe = WinCreateWindow(HWND_DESKTOP,
                    "MyProbeClass",
                    "probe",
                    0L,
                    0,0,
                    1000,200,
                    NULLHANDLE,
                    HWND_BOTTOM,
                    0,
                    NULL,
                    NULL);


    // first, we get the default font width to compute
    // pixels/dialog-unit ratio.  We make use of the
    // fact that 4 dialog-units = average-font-width of the
    // default font.

    // create a cached-micro PS
    HPS probeDC = WinGetPS(hProbe);
    FONTMETRICS _fm;
    GpiQueryFontMetrics(probeDC, sizeof(_fm), &_fm);
    double pxr = _fm.lAveCharWidth / 4.0;

    // we get the default font height to compute vertical
    // pixels/dialog-unit ratio.  We make use of the
    // fact that 8 dialog-units = font-height of the
    // default font.
    double pyr = (_fm.lMaxAscender+_fm.lMaxDescender) / 8.0;
    WinReleasePS(probeDC);

    // next we set the font to 8.Helv and compute length
    // in pixels
    char fns[] = "8.Helv";
    WinSetPresParam(hProbe, PP_FONTNAMESIZE, sizeof(fns), fns);

    probeDC = WinGetPS(hProbe);
    POINTL box[TXTBOX_COUNT];
    GpiQueryTextBox(probeDC, strlen(lbl), lbl, TXTBOX_COUNT, box);
    int pixux = box[TXTBOX_TOPRIGHT].x - box[TXTBOX_TOPLEFT].x;
    double dlgux = pixux / pxr;
    len = (int) (dlgux + 0.5);   // make sure we handle roundoff properly here

    // now compute label height
    GpiQueryFontMetrics(probeDC, sizeof(_fm), &_fm);
    double pixuy = _fm.lMaxAscender+_fm.lMaxDescender;
    double dlguy = pixuy / pyr;
    _labelHeight = (int) (dlguy + 0.5);   // make sure we handle roundoff properly here
    _validLblHeight = TRUE;

    // cleanup
    WinReleasePS(probeDC);
    WinDestroyWindow(hProbe);

//    printf("vCmd::LabelWidth pxr=%lf pixu=%u dlgu=%lf len=%u \n", pxr, pixu, dlgu, len);
//    printf("                 lbl=%s \n", lbl);

    return len;
  }


//===================>>> vCmd::LabelHeight <<<=======================
  int vCmd::LabelHeight(void) VCONST
  {
    if (_validLblHeight )
    {
      return (_labelHeight);
    }
    else
    {
      // register the font probe window class
      WinRegisterClass(theApp->AppHab(),
        "MyProbeClass",     // window-class name
        0L,                 // no window-procedure required
        0L,                 // default window style
        4L);                // reserved storage

      HWND hProbe = WinCreateWindow(HWND_DESKTOP,
                      "MyProbeClass",
                      "probe",
                      0L,
                      0,0,
                      1000,200,
                      NULLHANDLE,
                      HWND_BOTTOM,
                      0,
                      NULL,
                      NULL);


      // create a cached-micro PS
      HPS probeDC = WinGetPS(hProbe);
      FONTMETRICS _fm;
      GpiQueryFontMetrics(probeDC, sizeof(_fm), &_fm);

      // we get the default font height to compute vertical
      // pixels/dialog-unit ratio.  We make use of the
      // fact that 8 dialog-units = average-font-height of the
      // default font.
      double pyr = (_fm.lMaxAscender+_fm.lMaxDescender) / 8.0;
      WinReleasePS(probeDC);

      // next we set the font to 8.Helv and compute height
      // in pixels
      char fns[] = "8.Helv";
      WinSetPresParam(hProbe, PP_FONTNAMESIZE, sizeof(fns), fns);

      probeDC = WinGetPS(hProbe);

      GpiQueryFontMetrics(probeDC, sizeof(_fm), &_fm);
      double pixuy = _fm.lMaxAscender+_fm.lMaxDescender;
      double dlguy = pixuy / pyr;
      _labelHeight = (int) (dlguy + 0.5);   // make sure we handle roundoff properly here
      _validLblHeight = TRUE;

      // cleanup
      WinReleasePS(probeDC);
      WinDestroyWindow(hProbe);

      return (_labelHeight);
    }
  }
