//===============================================================
// vboxlbl.cxx - boxed label for stat bar - Windows
//
// Copyright (C) 1995,1996,1997,1998  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================
#include <v/vos2.h>           // for OS/2 stuff
#include <v/vapp.h>
#include <v/vboxlblc.h> // our definitions
#include <v/vcmdprnt.h> // a command parent

  // Boxed Labels are subclassed to this procedure
  MRESULT EXPENTRY BoxLblProc(HWND hDlg, ULONG uMsg, MPARAM mp1, MPARAM mp2);
  // this is a pointer to the original entrybox procedure that is subclassed
  PFNWP orgBoxLblProc;

//=====================>>> vBoxedLabelCmd::vBoxedLabelCmd <<<================
  vBoxedLabelCmd::vBoxedLabelCmd(vCmdParent* dp, CommandObject* dc) :
    vCmd(dp, dc)
  {
    initialize();
  }
//=================>>> vBoxedLabelCmd::~vBoxedLabelCmd <<<===================
  vBoxedLabelCmd::~vBoxedLabelCmd()
  {
    SysDebug(Destructor,"vBoxedLabelCmd::~vBoxedLabelCmd() destructor\n")
  }
//=====================>>> vBoxedLabelCmd::initialize <<<=====================
  void vBoxedLabelCmd::initialize(void)
  {
    // build a button command for use in a parent window

    SysDebug(Constructor,"vBoxedLabelCmd::vBoxedLabelCmd() constructor\n")

    long style = WS_GROUP | ES_READONLY | ES_CENTER | ES_AUTOSIZE;

    CopyToLocal();                      // Make local copies of CmdObject

    if (!(dlgCmd->attrs & CA_Hidden))           // Check for Hidden
	style |= WS_VISIBLE;

    if (!(dlgCmd->attrs & CA_NoBorder))
	style |= ES_MARGIN;

    _efd.cb = sizeof(ENTRYFDATA);
    _efd.cchEditLimit = 80;
    _efd.ichMinSel = 0;
    _efd.ichMaxSel = 0;

    int tl = strlen(_title);
    if ( tl < 80)
	strcpy(_lbl,_title);
    else
	strcpy(_lbl,"text length too long!");

    if (dlgCmd->size > 0)               // may reset title!
    {
	_w = dlgCmd->size ;
    }
    else
//      _w = -1;                        // AUTOSIZE confuses SetPosition()
//    _h = -1;                          // AUTOSIZE confuses SetPosition()

    // entrybox border extends 1/2 character beyond specified width so
    // need to compensate to keep alignment aesthetic
    _w = LabelWidth(_lbl) + 8;      // set my width
    _h = 10;			    // default height

    // set the entryfield colors so they blend into the dialog background
    _PPColor[0].PPtype = PP_BACKGROUNDCOLORINDEX;
    _PPColor[0].PPval.color = SYSCLR_DIALOGBACKGROUND;
    _PPColor[1].PPtype = PP_DISABLEDBACKGROUNDCOLORINDEX;
    _PPColor[1].PPval.color = SYSCLR_DIALOGBACKGROUND;
    _PPColor[2].PPtype = PP_HILITEBACKGROUNDCOLORINDEX;
    _PPColor[2].PPval.color = SYSCLR_DIALOGBACKGROUND;
    _PPColor[3].PPtype = PP_HILITEFOREGROUNDCOLORINDEX;
    _PPColor[3].PPval.color = SYSCLR_MENUTEXT;
    _PPColor[4].PPtype = 0;    // end of array marker

    _parentWin->SetPosition(_x, _y, _w, _h, dlgCmd->cFrame, dlgCmd->cRightOf,
	dlgCmd->cBelow);

    if (_parentWin->paneType() == P_Status)
    {
      _x += 2; _y += 2;   // status panes position fine tuning
      _w -= 4; _h -= 3;
    }
    else
    {
      _x += 2; _y += 2;
      _w -= 4; _h -= 4;
    }

    _CtrlOffset = _parentWin->AddDlgControl(_x, _y, _w, _h, _cmdId,
	  style, WC_ENTRYFIELD, _lbl, _parentWin->AssyPresParams(_PPColor),
	  _efd.cb, &_efd);

  }
//================>>> vBoxedLabelCmd::SetCmdVal <<<===========================
  void vBoxedLabelCmd::SetCmdVal(ItemVal val, ItemSetType st)
  {
    SysDebug1(Misc,"vBoxedLabelCmd::SetCmdVal(val:%d)\n",val)
    HWND myHwnd = GetMyHwnd(_cmdId);

    switch (st)
    {
      case Sensitive:
	_Sensitive = val;               // set
	WinEnableWindow (myHwnd, val);
	break;

      case Hidden:
	if (val)
	  WinShowWindow (myHwnd, FALSE);
	else
	  WinShowWindow (myHwnd, TRUE);
	break;
    }
  }

//================>>> vBoxedLabelCmd::SetCmdStr <<<===========================
  void vBoxedLabelCmd::SetCmdStr(char* str)
  {
    SysDebug1(Misc,"vBoxedLabelCmd::SetCmdStr(str:%s)\n",str)
    HWND myHwnd = GetMyHwnd(_cmdId);
    strcpy(_lbl,str);
    _title = _lbl;

    WinSetWindowText(myHwnd, _lbl);
// set focus back to client (owner of owner of boxedlabel)
//    HWND client = WinQueryWindow(WinQueryWindow(myHwnd, QW_OWNER), QW_OWNER);
//      WinSetFocus(HWND_DESKTOP,client);
  }

//================>>> vBoxedLabelCmd::MEASUREITEM <<<=========================
  int vBoxedLabelCmd::MEASUREITEM(int id, OWNERITEM* ois)
  {
    return 1;
  }


//================>>> vBoxedLabelCmd::DRAWITEM <<<============================
  int vBoxedLabelCmd::DRAWITEM(int id, OWNERITEM* poi)
  {
    // This really has nothing to do with DRAWITEM, but its
    // an unused procedure that we can hijak and use to subclass
    // boxed labels during the WM_INITDLG setup

    if (dlgCmd->cmdType == C_BoxedLabel)
    {
      // This is called during WM_INITDLG for boxed labels
      // so we can subclass the button procedure
      HWND hBtn = GetMyHwnd(id);
      WinSetWindowULong(hBtn, QWL_USER, (LONG) this);
      _orgBoxLblProc = WinSubclassWindow(hBtn, BoxLblProc);
      SysDebug2(OS2Dev,"vBoxedLabelCmd::DRAWITEM this:%x hBtn:%x \n", this, hBtn)
    }
    return (0);
  }

//====================>>> BoxLblProc <<<=======================
// we subclass the C_BoxedLabel so we can intercept any attempt
// to activate it with a mouse click
  MRESULT EXPENTRY BoxLblProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
    vBoxedLabelCmd* thisCmd = (vBoxedLabelCmd*) WinQueryWindowULong( hwnd, QWL_USER ); // Pointer from window word
    if (!thisCmd)
    {
      return (MRESULT) WinDefDlgProc(hwnd, msg, mp1, mp2);
    }
    else
      return (MRESULT) thisCmd->vBoxLblProc(hwnd, msg, mp1, mp2);
  }

//====================>>> vBoxLblProc <<<=======================
  MRESULT vBoxedLabelCmd::vBoxLblProc(HWND hBtn, ULONG uMsg, MPARAM mp1, MPARAM mp2)
  {
    // set the original frame procedure
    orgBoxLblProc = (PFNWP) _orgBoxLblProc;

    switch (uMsg)
    {
      case WM_CHORD:
      case WM_BUTTON1DBLCLK:
      case WM_BUTTON2DBLCLK:
      case WM_BUTTON3DBLCLK:
      case WM_BUTTON1DOWN:
      case WM_BUTTON2DOWN:
      case WM_BUTTON3DOWN:
      case WM_SETFOCUS:
      {
        // user has clicked on the label, so trap message and prevent
        // it from reaching the entry field procedure so that control
        // does not get focus
        return 0;
      }
    }
    return orgBoxLblProc(hBtn, uMsg, mp1, mp2);
  }

//===================>>> vBoxedLabelCmd::vCmdCallback <<<=======================
  void vBoxedLabelCmd::CmdCallback(UINT uMsg, MPARAM mp1, MPARAM mp2)
  {
   // No Op for a label
  }

