#define INCL_BASE
#include <os2.h>


#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <io.h>

#define TOOLNAME     "SC.EXE\0"

#define HF_STDSCREEN 2
//#define PIPESIZE     65535 /* the maximal value for an unnamed pipe to function correctly */
#define PIPESIZE     128
#define LINELENGTH   CCHMAXPATH + 260


int main(int argc, char *argv[])
{
   HFILE hw,hr;
   HFILE herr = HF_STDSCREEN;
   HFILE hsav = -1;
   int res = -1;
   APIRET ulrc;
   ULONG ulRead,ulWritten,ulLen;
   PCHAR gMessage;
   CHAR szCmdLine[CCHMAXPATH];

   if (DosAllocMem(  (PPVOID)&gMessage,
                     PIPESIZE,
                     PAG_READ|PAG_WRITE|PAG_COMMIT|OBJ_TILE) != NO_ERROR) {
      return -1;
   }
   *gMessage = '\0';
   szCmdLine[0] = '\0';

   if (DosCreatePipe(   &hr,
                        &hw,
                        PIPESIZE) == NO_ERROR) {

      // sc.exe writes its output to standard error (2), NOT to standard out (1)
      ulrc = DosDupHandle(HF_STDSCREEN,&hsav);
      ulrc = DosDupHandle(hw,&herr);

      strcpy(szCmdLine,TOOLNAME);
      PSZ pszTemp = &szCmdLine[0] + strlen(szCmdLine) + 1;
      for (ULONG i=1;i<argc;i++) {
         sprintf(pszTemp,"%s ",argv[i]);
         pszTemp += strlen(pszTemp);
      }
      *(pszTemp-1)='\0';
      *(pszTemp)='\0';

      RESULTCODES sCodes={0};
      PID pid;

      ulrc = DosExecPgm(NULL,0,EXEC_ASYNCRESULT,szCmdLine,NULL,&sCodes,TOOLNAME);

      CHAR pszFileName[CCHMAXPATH];
      ULONG ulLineNumber;
      CHAR pszErrorText[CCHMAXPATH];
      CHAR pszLineIn[LINELENGTH];
      ULONG j;
      BOOL fLine;

      ulrc = DosClose(hw);
      ulrc = DosDupHandle(hsav,&herr);
      ulrc = DosClose(hsav);

      j=0;
      fLine = FALSE;
      pszLineIn[0]='\0';

      ulrc = DosRead(hr,gMessage,PIPESIZE,&ulRead);
      while (ulRead) {
         gMessage[ulRead] = '\0';
         for (i=0;i < ulRead;i++) {
            if (gMessage[i] == '\n' || gMessage[i] == '\r' || gMessage[i] == '\0') {
               pszLineIn[j] = '\0';
               if (j) {
                  j = 0;
                  int num = sscanf(pszLineIn, "\"%[^\"]\", line %lu: %[^\n\r]",pszFileName,&ulLineNumber,pszErrorText);
                  if (num == 3) {
                     // bug in sc.exe, the line numbers are always too big by 1, decrease line number by 1
                     ulLen = sprintf(pszLineIn,"%s(%lu): %s\r\n",pszFileName,ulLineNumber-1,pszErrorText);
                  }
                  else {
                     ulLen = sprintf(pszLineIn,"%s\r\n",pszLineIn);
                  }
                  // sc.exe writes its output to standard error (2), NOT to standard out (1)
                  DosResetBuffer(HF_STDSCREEN);
                  DosWrite(HF_STDSCREEN,pszLineIn,ulLen,&ulWritten);
               }
            }
            else {
               pszLineIn[j++] = gMessage[i];
            }
         }
         ulrc = DosRead(hr,gMessage,PIPESIZE,&ulRead);
      }

      ulrc = DosClose(hr);

      ulrc = DosWaitChild(DCWA_PROCESSTREE,DCWW_WAIT,&sCodes,&pid,sCodes.codeTerminate);
      res = sCodes.codeResult;
   }
   ulrc = DosFreeMem(gMessage);
   return res;
}
