#define INCL_PM
#include <os2.h>
#include <kenthdr.hpp>
#include <ievent.hpp>
#include <ictlevt.hpp>

Boolean KEntryHandler::dispatchHandlerEvent(IEvent& event)
{
   Boolean filtered = false;
   if (event.eventId() == WM_CONTROL)
   {                                   // Control event
      IControlEvent ctlEvent(event);
      unsigned long ulMsg = ctlEvent.parameter1().number2();
      switch(ulMsg)
      {
         case EN_MEMERROR:
            filtered = memError(ctlEvent);
            break;

         case EN_SCROLL:
            filtered = scroll(ctlEvent);
            break;

         case EN_OVERFLOW:
            filtered = overflow(ctlEvent);
            break;

         default: 
            filtered = false;
            break;
      }
      if (filtered)
         event.setResult(ctlEvent.result());      
   }
   return filtered;
}
