#ifndef _KDOBMGR_
#define _KDOBMGR_

#ifndef _ISTRING_
   #include <istring.hpp>
#endif

#ifndef _IRESLOCK_
   #include <ireslock.hpp>
#endif

class KDobEntry;
class KDobMap;
class KData;
class KDataFactory;
class IPrivateResource;
class IWindow;

class _Export KDobManager
{
   public:
      KDobManager(IWindow *owner=0, IWindow *caller=0);
      ~KDobManager();
      KData   &dataObject(KDataFactory const &key);
      IPrivateResource &dataLock(KDataFactory const &key);
      void mergeWith(KDobManager &other);
      static    KDobManager &globalManager();
      static    KDobManager *managerFor(IWindow *window=0, 
                                        IWindow *caller=0);
      static KDobManager *associate(IWindow *window, 
                                    IWindow *caller);
      static void detach(IWindow *window);

   private:
      KDobEntry *findEntry(KDataFactory const &key);
      KDobMap   &map;
      static KDobManager global;
      IWindow   *_window;
      IWindow   *_caller;
};



#endif
