%{

/* REFERENCE GRAMMAR FOR JRCPP (3/20/90)



    Copyright (C) 1990 James Roskind, All rights reserved. Permission 
    is  granted  to copy and distribute this file as part any machine 
    readable archive containing the entire, unmodified, JRCPP  PUBLIC 
    DISTRIBUTION PACKAGE (henceforth call the "Package").  The set of 
    files that form the Package are described in the README file that 
    is  a  part  of the Package.  Permission is granted to individual 
    users of the Package to copy individual portions of  the  Package 
    (i.e.,  component  files) in any form (e.g.: printed, electronic, 
    electro-optical, etc.) desired  for  the  purpose  of  supporting 
    users   of  the  Package  (i.e.,  providing  online,  or  onshelf 
    documentation access; executing the  binary  JRCPP  code,  etc.).  
    Permission  is  not  granted  to  distribute copies of individual 
    portions of the Package, unless a machine readable version of the 
    complete  Package  is also made available with such distribution. 
    Abstracting with credit is permitted.   There  is  no  charge  or 
    royalty  fee  required  for  copies  made in compliance with this 
    notice.  To otherwise copy  elements  of  this  package  requires 
    prior permission in writing from James Roskind.

    James Roskind
    516 Latania Palm Drive
    Indialantic FL 32903

    End of copyright notice


What  the  above  copyright  means  is  that  you are free to use and 
distribute (or even sell) the entire set of files  in  this  Package, 
but  you  can't split them up, and distribute them as separate files.  
The notice also says that you  cannot  modify  the  copies  that  you 
distribute, and this ESPECIALLY includes NOT REMOVING the any part of 
the copyright notice in any file.  JRCPP  currently  implements  a  C 
Preprocessor,  but  the  users  of  this Package do NOT surrender any 
right of ownership or copyright to any source text that is  processed 
by JRCPP, either before or after processing.  Similarly, there are no 
royalty or fee requirements for using the post-preprocessed output of 
JRCPP.  

This  Package is expected to be distributed by shareware and freeware 
channels (including BBS sites), but the fees paid for  "distribution" 
costs  are  strictly  exchanged  between  the  distributor,  and  the 
recipient, and James Roskind makes no express or  implied  warranties 
about  the  quality  or integrity of such indirectly acquired copies.  
Distributors  and  users  may  obtain   the   Package   (the   Public 
distribution form) directly from the author by following the ordering 
procedures in the REGISTRATION file.


DISCLAIMER:

JAMES ROSKIND PROVIDES THIS FILE "AS  IS"  WITHOUT  WARRANTY  OF  ANY 
KIND,  EITHER  EXPRESS  OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE 
IMPLIED WARRANTIES OF MERCHANTABILITY OR  FITNESS  FOR  A  PARTICULAR 
PURPOSE.   THE  ENTIRE  RISK AS TO THE QUALITY AND PERFORMANCE OF THE 
PROGRAM AND DOCUMENTATION IS WITH YOU.   Some  states  do  not  allow 
disclaimer  of express or implied warranties in certain transactions, 
therefore, this statement may not apply to you.


UNIX is a registered trademark of AT&T Bell Laboratories.


_____________________________________________________________________




The file may be processed by YACC.  The only  conflict  left  in  the 
grammar  involves  the  distinction between function like macros, and 
manifest macros that begin with a left  parenthesis.   Removing  this 
last conflict would unnecessarily complicate the grammar.  */




/*******************************************************************/

/*  The  following defines the terminals of the grammar. Terminal are 
identified lexically  as  groups  of  characters  (either  tokens  or 
whitespace). */

%token  IDENTIFIER   OTHER_TOKENS
%token  HORIZONTAL_WHITE      VERTICAL_WHITE
%token  '#'     '('     ')'     ','      '\n'
%token  DEFINE       POUND_POUND   UNDEF
%token  IF           IFDEF        IFNDEF
%token  ELIF         ELSE         ENDIF
%token  DEFINEDoperator
%token  INCLUDE      LINE         ERROR        PRAGMA


/*************************************************************************/



%%

preprocessing_file:
	/* empty file */
	| preprocessed_group
        ;

preprocessed_group:
	directive_group
        | non_directive_line 
        | preprocessed_group directive_group
        | preprocessed_group non_directive_line 
        ;

directive_group:
	directive_start if_section
	| directive_start opt_white_space define_directive
	| directive_start opt_white_space INCLUDE line
	| directive_start opt_white_space LINE line
	| directive_start opt_white_space ERROR line
	| directive_start opt_white_space PRAGMA line
	| directive_start new_line  /* null directive */
	;
        
directive_start:
	opt_white_space '#'
        ;


non_directive_line:
	new_line
	| opt_white_space non_pound_non_white_non_new_line line
        ;

line:
	new_line
	| line_interior new_line
        ;

line_interior:
	opt_white_space non_white_non_new_line
	| line_interior opt_white_space non_white_non_new_line
        ;


new_line:
	opt_white_space '\n'
        ;

opt_white_space:
	/* nothing */
	| white_space
        ;
        

white_space:
        a_white_space
	| white_space a_white_space
        ;
        
        
a_white_space:
	HORIZONTAL_WHITE
	| VERTICAL_WHITE
        ;

non_white_non_new_line:
	'#'
        | non_pound_non_white_non_new_line 
        ;
        
non_pound_non_white_non_new_line 
	non_pound_non_white_non_new_line_non_opdefined
	| DEFINEDoperator
        ;
        
non_pound_non_white_non_new_line_non_opdefined:
	IDENTIFIER
	| OTHER_TOKENS
        | '('     
        | ')'     
        | ','     
	| DEFINE
	| UNDEF
	| IF
	| IFDEF
	| IFNDEF
	| ELIF
	| ELSE
	| ENDIF
	| INCLUDE
	| LINE
	| ERROR
	| PRAGMA
	| POUND_POUND
        ;                
        
if_section:
	if_line elif_groups else_group endif_group
	| if_line             else_group endif_group
	| if_line elif_groups            endif_group
	| if_line                        endif_group
	;

if_line:
	opt_white_space IF opdefined_processed_line
	| opt_white_space IFDEF opt_white_space any_identifier new_line
	| opt_white_space IFNDEF opt_white_space any_identifier new_line
        ;

elif_groups:
	elif_group
        | elif_groups elif_group
        ;

elif_group:
	elif_line
        | preprocessed_group elif_line
        ;

elif_line:
	directive_start opt_white_space ELIF opdefined_processed_line
	;


else_group:
	else_line
        | preprocessed_group else_line
        ;

else_line:
	directive_start opt_white_space ELSE new_line
	;

endif_group:
	endif_line
	| preprocessed_group endif_line
        ;
        
endif_line:
	directive_start opt_white_space ENDIF new_line
        ;

opdefined_processed_line:
	opdefined_processed_tokens new_line
        ;
        
opdefined_processed_tokens:
	opdefined_processed_token
	| opdefined_processed_tokens opdefined_processed_token
	;

opdefined_processed_token:
	opt_white_space   DEFINEDoperator opt_white_space
				    any_identifier
	| opt_white_space DEFINEDoperator opt_white_space
		'(' opt_white_space any_identifier opt_white_space ')'
	| opt_white_space non_opdefined_non_white_non_new_line
	;

non_opdefined_non_white_non_new_line:
        non_pound_non_white_non_new_line_non_opdefined
        | '#'
        ;
        



define_directive:
	DEFINE opt_white_space any_identifier  '(' opt_dummy_arg_list ')'
		replacement_line
	| DEFINE opt_white_space any_identifier replacement_line
	| UNDEF opt_white_space any_identifier new_line
        ;

opt_dummy_arg_list:
	opt_white_space
        | dummy_arg_list 
        ;

dummy_arg_list:
	dummy_arg
        | dummy_arg_list  ',' dummy_arg
        ;

dummy_arg:
	opt_white_space any_identifier opt_white_space
        ;

replacement_line:
        new_line
	| opt_white_space replacement_list new_line
	;

replacement_list:
	non_white_non_new_line
	| replacement_list opt_white_space non_white_non_new_line
        ;
        
any_identifier:
	DEFINEDoperator
	| IDENTIFIER
	| DEFINE
	| UNDEF
	| IF
	| IFDEF
	| IFNDEF
	| ELIF
	| ELSE
	| ENDIF
	| INCLUDE
	| LINE
	| ERROR
	| PRAGMA
	;



%%
