/*
 *      INSTEXE.CMD - Wireless LAN Monitor Installation - Netlabs WLAN Project 2003-2008
 *
 *      Syntax: INSTEXE
 *
 *      This program installs the Wireless LAN Monitor as a standalone
 *      GUI executable.
 *
 *      If either XWorkplace or the OEM-Version EWorkplace (contained in
 *      eComStation V1.1. or better) is installed, it is recommended to
 *      install the XCenter version of the Wireless LAN Monitor instead!
 *      For this start the script: INSTWGT.CMD
 *
 */
/* The first comment is used as online help text */
/*****************Module Header *******************************
*
* Module Name: install.cmd
*
* Wireless LAN Status GUI library bubble help module
*
* Copyright (c) WLan Project 2003
*
* $Id: instexe.cmd 1116 2016-01-23 10:17:31Z andib $
*
* ===========================================================================
*
* This file is part of the WLan Project and is free software.  You can
* redistribute it and/or modify it under the terms of the GNU Library General
* Public License as published by the Free Software Foundation, in version 2
* as it comes in the "COPYING.LIB" file of the WLan Project CVS tree.
* This library is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
* License for more details.
*
****************************************************************************/

 SIGNAL ON HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 Title     = CmdName Info

 env          = 'OS2ENVIRONMENT';
 TRUE         = (1 = 1);
 FALSE        = (0 = 1);
 CrLf         = '0d0a'x;
 Redirection  = '> NUL 2>&1';
 '@ECHO OFF'

 /* OS/2 Error codes */
 ERROR.NO_ERROR           =   0;
 ERROR.INVALID_FUNCTION   =   1;
 ERROR.FILE_NOT_FOUND     =   2;
 ERROR.PATH_NOT_FOUND     =   3;
 ERROR.ACCESS_DENIED      =   5;
 ERROR.NOT_ENOUGH_MEMORY  =   8;
 ERROR.INVALID_FORMAT     =  11;
 ERROR.INVALID_DATA       =  13;
 ERROR.NO_MORE_FILES      =  18;
 ERROR.WRITE_FAULT        =  29;
 ERROR.READ_FAULT         =  30;
 ERROR.GEN_FAILURE        =  31;
 ERROR.SHARING_VIOLATION  =  32;
 ERROR.INVALID_PARAMETER  =  87;
 ERROR.ENVVAR_NOT_FOUND   = 203;

 GlobalVars = 'Title CmdName CrLf env TRUE FALSE Redirection ERROR.';
 SAY;

 /* eventually show help */
 ARG Parm .
 IF (POS('?', Parm) > 0) THEN
 DO
    rc = ShowHelp();
    EXIT(ERROR.INVALID_PARAMETER);
 END;

 call RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs

 /* dafault values */
 GlobalVars = GlobalVars 'CallDir AppName';
 rc = ERROR.NO_ERROR;
 CallDir  = GetCallDir();

 AppName = 'Wireless LAN Monitor';

 DO UNTIL (TRUE)

    SAY Title;
    SAY;

    /* install standalone version */
    rc = InstallExec();
    IF (rc \= ERROR.NO_ERROR) THEN
       LEAVE;

    /* check cached TCP/IP binding information */
    rc = CheckBindings();
    IF (rc \= ERROR.NO_ERROR) THEN
       LEAVE;
 END;

 EXIT( rc);

/* ------------------------------------------------------------------------- */
HALT:
 SAY 'Abbruch durch Benutzer.';
 EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE (GlobalVars)

 /* show title */
 SAY Title;
 SAY;

 PARSE SOURCE . . ThisFile

 /* skip header */
 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 /* show help text */
 ThisLine = LINEIN(Thisfile);
 DO WHILE (ThisLine \= ' */')
    SAY SUBSTR(ThisLine, 7);
    ThisLine = LINEIN(Thisfile);
 END;

 /* close file */
 rc = LINEOUT(Thisfile);

 RETURN('');

/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ------------------------------------------------------------------------- */
GetDrivePath: PROCEDURE
 PARSE ARG FileName

 FullPath = FILESPEC('D', FileName)||FILESPEC('P', FileName);
 IF (FullPath \= '') THEN
    RETURN(LEFT(FullPath, LENGTH(FullPath) - 1));
 ELSE
    RETURN('');

/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE
 PARSE ARG FileName

 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');

/* ========================================================================= */
GetSystemLanguage: PROCEDURE EXPOSE (GlobalVars)

 ValidLanguageChars = '0GF';
 ValidLanguageIds   = 'eng deu fra';
 SystemLanguage     = 'eng'; /* default */

 DO 1
    /* open Syslevel file and read language char */
    PARSE VALUE TRANSLATE( VALUE( 'PATH',,'OS2ENVIRONMENT')) WITH '\OS2;' -2 BootDrive +2;
    SyslevelFile = BootDrive'\OS2\INSTALL\SYSLEVEL.OS2';
    IF (STREAM( SyslevelFile, 'C', 'OPEN READ') \= 'READY:') THEN
       LEAVE;
    LanguageChar = CHARIN( SyslevelFile, X2D(37), 1);
    rcx = STREAM( SyslevelFile, 'C', 'CLOSE');

    /* translate into three letter ISO language code */
    LanguagePos = POS( LanguageChar, ValidLanguageChars);
    IF ((LanguagePos > 0) & (LanguagePos <= WORDS( ValidLanguageIds))) THEN
       SystemLanguage = WORD( ValidLanguageIds, LanguagePos);
 END;

 RETURN( SystemLanguage);

/* ========================================================================= */
GetInfFile: PROCEDURE
 PARSE ARG Path, Stem, Language;

 Language = STRIP( Language);
 IF (Language = '') THEN
    Language   = GetSystemLanguage();

 RETURN( Path'\'Stem''Language'.inf');

/* ========================================================================= */
InstallExec: PROCEDURE EXPOSE (GlobalVars)
 PARSE ARG XwpPluginPath;

 rc = ERROR.NO_ERROR;


 InfStem  = 'xwlan';
 DefPanel = 'Wireless';
 BmpPanel = '_dragdrop';
 EnvVar   = 'XWLAN_LANGUAGE';

 ExeDir    = CallDir'\XCENTER';
 ExeName   = ExeDir'\WLANSTAT.EXE';
 ReadMeDir = CallDir;
 ReadMeName = CallDir'\readme.txt';
 HlpDir    = CallDir'\XCENTER\XWLAN';
 BitmapDir = HlpDir'\Bitmap';


 DO 1
    /* check INF file */
    InfFile = GetInfFile( HlpDir, 'xwlan', VALUE( EnvVar,,'OS2ENVIRONMENT'));
    IF (\FileExist( InfFile)) THEN
    DO
       InfFile = GetInfFile( HlpDir, InfStem, 'eng');
       IF (\FileExist( InfFile)) THEN
       DO
          SAY 'error:' FILESPEC( 'N', InfFile) 'could not be found.';
          rc = 2; /* ERROR_FILE_NOT_FOUND */
       END;
    END;

    /* check program file */
    IF (\FileExist( ExeName)) THEN
    DO
       SAY CmdName': error: program files not found, package maybe corrupt.';
       rc = 2; /* ERROR_FILE_NOT_FOUND */
       LEAVE;
    END;

    CALL CHAROUT, '- installing Workplace Shell folder ... ';
    rcx = SysCreateObject( 'WPFolder', AppName, '<WP_DESKTOP>', 'CCVIEW=NO;STATUSBAR=NO;ICONVIEWPOS=15 40 40 20;OBJECTID=<WLAN_FOLDER>;', 'U');
    rcx = SysCreateObject( 'WPProgram', AppName, '<WLAN_FOLDER>', 'PROGTYPE=PM;EXENAME='ExeName';STARTUPDIR='ExeDir';OBJECTID=<WLAN_EXEC>;', 'U');
    rcx = SysCreateObject( 'WPProgram', AppName 'Help', '<WLAN_FOLDER>', 'PROGTYPE=PM;EXENAME=VIEW.EXE;PARAMETERS='InfFile DefPanel';OBJECTID=<WLAN_HELP>;', 'U');
    rcx = SysCreateObject( 'WPProgram', AppName 'ReadMe', '<WLAN_FOLDER>', 'PROGTYPE=PM;EXENAME=E.EXE;PARAMETERS='ReadMeName';STARTUPDIR='ReadMeDir';OBJECTID=<WLAN_README>;', 'U');

    rcx = SysFileTree( BitmapDir'\*', 'Folder.', 'DO');
    IF ((rcx = 0) & (Folder.0 > 0)) THEN
    DO
       rcx = SysCreateObject( 'WPFolder', 'Bitmaps', '<WLAN_FOLDER>', 'CCVIEW=NO;STATUSBAR=NO;ICONVIEWPOS=35 20 40 20;OBJECTID=<WLAN_BITMAP_FOLDER>;', 'U');
       rcx = SysCreateObject( 'WPProgram', 'Help on changing^status sybmols', '<WLAN_BITMAP_FOLDER>', 'PROGTYPE=PM;EXENAME=VIEW.EXE;PARAMETERS='InfFile BmpPanel';OBJECTID=<WLAN_BITMAP_HELP>;', 'U');
       DO i = 1 TO Folder.0

          FolderName = FILESPEC( 'N', Folder.i);
          FolderId = TRANSLATE( FolderName);
          rcx = SysCreateObject( 'WPShadow', FolderName, '<WLAN_BITMAP_FOLDER>', 'SHADOWID='Folder.i';OBJECTID=<WLAN_BITMAP_'FolderId'>;', 'U');
       END;
    END;

    SAY 'Ok.';

    DO 2
       rcx = SysSetObjectData( '<WLAN_FOLDER>', 'OPEN=DEFAULT;');
    END;
 END;

 RETURN( rc);

/* ========================================================================= */
CheckBindings: PROCEDURE EXPOSE (GlobalVars)

 rc = ERROR.NO_ERROR;

 XwlCheckExec = CallDir'\xcenter\xwlprf.exe';
 XwlCheckOpts = '/C /V /N';

 DO 1
    /* check for executable */
    IF (\FileExist( XwlCheckExec)) THEN
       LEAVE;

    'CALL' XwlCheckExec XwlCheckOpts Redirection;
    IF (rc \= ERROR.NO_ERROR) THEN
    DO
       SAY;
       SAY 'Warning:';
       SAY 'The TCP/IP binding information previously stored by Wireless LAN Monitor'
       SAY 'and used for GenPrism style drivers on your system may be outdated. In case'
       SAY 'that the Wireless LAN Monitor is unable to configure the TCP/IP interface'
       SAY 'corresponding to the active Wireless LAN device, please restart your system !!!'
       SAY;
       'CALL' XwlCheckExec XwlCheckOpts;
    END;

 END;

 RETURN( rc);

