/* Get the title of the current song from the web site  */
/* of an internet radio station.                        */

signal on halt name TrapErr

rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
if rc = 0 then call SysLoadFuncs

Parse Arg RadioURL Verbose

/* Check parameters */
if RadioURL = '' then call CorrectSyntax
if (Verbose \= '') & (Verbose \= '/V') then call CorrectSyntax

Parse Value RadioUrl With . '.' RadioStation '.' .

RadioURL = 'http://' || RadioURL

if Verbose = '/V' then do
	Verbose = 1
	say
    say ' * GetTitle script for Z! Controller.       *'
    say ' * (C) Copyright Cristiano Guadagnino 2001. *'
	say
end; else do
	Verbose = 0
end

/* Get the constant to locate the title. */
OKString = linein(RadioStation, 1, 1)
LinesToSkip = linein(RadioStation)

if (OKString = '') | (LinesToSkip = '') then do
	say 'Error reading "' || RadioStation || '" setup.'
	exit
end

/* Close the setup file */
rc = lineout(RadioStation)

/* Name the queue */
TheQ = 'GetTitleQ'

/* Delete the file if it exists */
frc = SysFileDelete('force-title.txt')

Looper:

/* Delete the queue if it exists */
qrc = rxqueue('Delete', TheQ)

/* Create the queue and set it as current */
TheQ = rxqueue('Create', TheQ)
qrc = rxqueue('Set', TheQ)

/* Exec wget and pipe the output to the queue */
'@wget -q --cache=off -O- ' || RadioURL || ' | rxqueue ' || TheQ || ' /FIFO'

/* Get queued lines */
TheTitle = ''
do while Queued() > 0
    WebLine = LineIn('QUEUE:')

    if Abbrev(WebLine, OKString) = 1 then do
        do LinesToSkip 
        	WebLine = LineIn('QUEUE:')
        end
		TheTitle = strip(WebLine)
		leave
    end
end /* while */

if TheTitle \= '' then do
	call LineOut 'force-title.txt', TheTitle, 1
	call LineOut 'force-title.txt'
	if Verbose then say TheTitle
end; else do
	if Verbose then say 'Unable to retrieve title.'
end

frc = SysSleep(10)
signal Looper

return

CorrectSyntax: Procedure
	say
    say ' * GetTitle script for Z! Controller.       *'
    say ' * (C) Copyright Cristiano Guadagnino 2001. *'
	say
    say '   Correct syntax is:'
    say
    say '      gettitle <radio_station_url> [/V]'
    say
    say '   The "V" parameter tells the program to be verbose,'
    say '   i.e. to display the title it retrieves.'
    say
    exit
return

TrapErr:
	frc = SysFileDelete('force-title.txt')
    say 'User break.'
    exit
