//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE common dialogs DLL                //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit Unit8;

Interface

Uses
  Classes, Forms, Graphics, ExtCtrls, Buttons, StdCtrls, Unit9
  , SysUtils, Dos, Unit6, pdeNLS;

Type
  TRunForm = Class (TForm)
    pBox: TPaintBox;
    bOK: TButton;
    bCancel: TButton;
    Label1: TLabel;
    edName: TEdit;
    bView: TButton;
    Procedure bCancelOnClick (Sender: TObject);
    Procedure bViewOnClick (Sender: TObject);
    Procedure bOKOnClick (Sender: TObject);
    Procedure RunFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  RunForm: TRunForm;

function DirExists( _Path: String ): Boolean;
function RunDialogS(cptn, text: String; img: LongInt): String;
function RunDialogR(cptn, text: String; img: LongInt): String;

Implementation

function RunDialogS(cptn, text: String; img: LongInt): String;
begin

  {simply display dialog, that allow to choose program/file name
   and return this into calling program}
  //Application.Create;
  RunForm := TRunForm.Create(nil);

  RunForm.ShowModal;
  Result := RunForm.edName.Text;

  RunForm.Free;
  //Application.Destroy;

end;

function RunDialogR(cptn, text: String; img: LongInt): String;
var
  basepath, fname: String;
begin

  {display dialog, that allow to choose program name and execute it
   , also return program name}
  //Application.Create;
  RunForm := TRunForm.Create(nil);

  Result := '';
  RunForm.ShowModal;

  if RunForm.edName.Text <> '' then
  begin
    fname := RunForm.edName.Text;

    if DirExists(fname) then
      begin
      basepath := getenv('PDE_HOME');
      if basepath = '' then
        basepath := 'c:\pde';

      if fname[length(fname)] <> '\' then
        fname := fname + '\';

      ShellExecute(basepath+'\filehalf.exe', basepath+'\', fname, false);
      end
    else
      ShellExecute(fname, ExtractFilePath(fname), '', true);
  end;

  Result := fname; //RunForm.edName.Text;
  RunForm.Free;
  //Application.Destroy;

end;

Procedure TRunForm.bCancelOnClick (Sender: TObject);
Begin

  {close window}
  edName.Text := '';
  Close;

End;

Procedure TRunForm.bViewOnClick (Sender: TObject);
Begin

edName.Text := pdeOpenFileDialog(pdeLoadNLS('ppOpenFile', '⨥ 䠩'),
  'c:\', pdeLoadNLS('ppPrograms', 'ணࠬ')+' (*.exe;*.com;*.cmd;*.bat)|');

End;

Procedure TRunForm.bOKOnClick (Sender: TObject);
Begin

  {button OK}
  if edName.Text = '' then exit;

  Close;

End;

Procedure TRunForm.RunFormOnCreate (Sender: TObject);
Begin

  BorderStyle := bsDialog;

End;

function DirExists( _Path: String ): Boolean;
var
  DirInfo: SearchRec;
begin
  // Remove trailing backslash, if any
  if _Path[Length(_Path)] = '\' then
    Delete( _Path, Length(_Path), 1 );
  // FindFirst: Allow any attribute; require Directory attribute
  FindFirst( _Path, $37, DirInfo );
  Result := DosError = 0;
  if Result then
    FindClose(DirInfo);
end;


Initialization
  RegisterClasses ([TRunForm, TPaintBox, TButton, TLabel, TEdit]);
End.
