//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE common dialogs DLL                //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit Unit6;

Interface

Uses
  Classes, Forms, Graphics, pdeNLS, Buttons, ExtCtrls, StdCtrls
  , CustomFileControls, Dialogs, XplorBtn
  , SysUtils, Dos, FileCtrl, DirectoryEdit, BseDos, TabCtrls
  , ColorWheel, pdeFileBox
  , Unit1, Unit2;

Type
  TPDEOpenDialog = Class (TForm)
    pList: TPDEListbox;
    pListBevel: TBevel;
    bOK: Tbutton;
    bCancel: Tbutton;
    Label1: TLabel;
    Label2: TLabel;
    edName: TEdit;
    edPath: TDirectoryEdit;
    cbMask: TCombobox; //䨫
    drBox: TDriveComboBox; //롮 ᪠
    tBar: TToolbar;
    pPanel: TPanel;
    xbUp: TExplorerButton;
    xbRefresh: TExplorerButton;
    xbNew: TExplorerButton;
    xbBookmarks: TExplorerButton; //뢠  
    xbAddBookmark: TExplorerButton;
    bmMenu: TPopupmenu; //    
    bookItem: TMenuItem;
    xbHome: TExplorerButton;
    xbDocs: TExplorerButton;
    xbCdrom: TExplorerButton;
    xbFloppy: TExplorerButton;
    bmpDir: TBitmap;
    bmpFile: Tbitmap;
    wasBkSp: Boolean;
    Procedure PDEOpenDialogOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
    procedure drBoxChange (Sender: TObject);
    procedure cbMaskItemSelect(Sender: TObject; Index: LongInt);
    procedure xbUpClick (Sender: TObject);
    procedure xbRefreshClick (Sender: TObject);
    procedure xbNewClick (Sender: TObject);
    procedure xbBookmarksClick (Sender: TObject);
    procedure xbAddBookmarkClick (Sender: TObject);
    procedure BookmarkClick (Sender: TObject);
    procedure xbHomeClick (Sender: TObject);
    procedure xbDocsClick (Sender: TObject);
    procedure xbCdromClick (Sender: TObject);
    procedure xbFloppyClick (Sender: TObject);
    Procedure drEditChangeDir (NewDir: String);
    Procedure pdeOpenDialogTranslateShortcut(Sender: TObject; KeyCode: TKeyCode;
  Var ReceiveR: TForm);
  End;

Var
  PDEOpenDialog: TPDEOpenDialog;

function pdeOpenFileDialog(cptn, directory, mask: String): String;

Implementation

function pdeOpenFileDialog(cptn, directory, mask: String): String;
var
  s, s2: String;
begin

  //Application.Create;
  //example: mask = 'All (*.*)|Exe (*.exe;*.com;*.cmd;*.bat)|'
  s2 := mask;

  PDEOpenDialog := TPDEOpenDialog.Create(nil);
  pdeOpenDialog.Caption := cptn; //'⨥ 䠩';

  while s2 <> '' do
    begin
    s := copy(s2, 1, pos('|', s2) - 1);
    pdeOpenDialog.cbMask.Items.Add(s);
    delete(s2, 1, pos('|', s2));
    end;

  pdeOpenDialog.cbMask.Text := pdeOpenDialog.cbMask.Items[0];

  s := pdeOpenDialog.cbMask.Items[0];
  delete(s, 1, pos('(', s));
  delete(s, length(s), 1);

  pdeOpenDialog.pList.Mask := s;
  pdeOpenDialog.pList.Path := directory;

  Result := '';

  if pdeOpenDialog.ShowModal = cmOK then
    Result := concatfilename(pdeOpenDialog.edPath.Text, pdeOpenDialog.edName.Text);

  //if pdeOpenDialog<>nil then
  pdeOpenDialog.Free;
  //Application.Destroy;

end;

Procedure TPDEOpenDialog.PDEOpenDialogOnCreate (Sender: TObject);
var
  basepath: String;
  pclr: TColor;
  afile: TextFile;
  tsr: TSearchRec;
  itext: String;
  rez: Integer;
Begin

  pclr := clNavy;

  BorderStyle := bsDialog;
  Width := 500;
  Height := 400;
  Position := poScreenCenter;
  BorderIcons :=[biSystemMenu, biMinimize];
  Caption := ' ';
  OnTranslateShortcut := pdeOpenDialogTranslateShortcut;

  tBar:= TToolbar.Create(Self);
  tBar.parent := Self;
  tBar.Alignment := tbTop;
  tBar.bevelstyle := tbNone;
  tBar.size := 32;

  pPanel:= TPanel.Create(Self);
  pPanel.parent := Self;
  pPanel.color := pclr;
  pPanel.Align := alleft;
  pPanel.bevelouter := bvLowered;
  pPanel.width := 100;


  pListBevel := InsertBevel(Self, 104, 0, 387, 276, bsBox, bsLowered);
  pListBevel.Top := 0;

  pList:= TPDEListbox.Create(Self);
  pList.parent := Self;
  pList.BorderStyle := bsNone;
  pList.width := 385;
  pList.height := 274;
  pList.left := 105;
  pList.top := 1;
  pList.color := clwhite;

  bOK:= Tbutton.Create(Self);
  bOK.parent := Self;
  bOK.width := 80;
  bOK.height := 24;
  bOK.left := 410;
  bOK.top := 282;
  bOK.align := alfixedlefttop;

  bOK.modalresult := cmOk;
  bOK.caption := pdeLoadNLS('dlgOkButton', 'OK');
  bOK.command := cmOk;
  bOK.default := true;

  bCancel:= Tbutton.Create(Self);
  bCancel.parent := Self;
  bCancel.width := 80;
  bCancel.height := 24;
  bCancel.left := 410;
  bCancel.top := 307;
  bCancel.align := alfixedlefttop;

  bCancel.modalresult := cmCancel;
  bCancel.caption := pdeLoadNLS('dlgCancelButton', '⬥');
  bCancel.command := cmCancel;
  bCancel.Cancel := True;

  Label1:= TLabel.Create(Self);
  Label1.parent := Self;
  Label1.left := 105;
  Label1.top := 290;
  Label1.align := alfixedlefttop;
  Label1.caption := pdeLoadNLS('pdeDlgChoose', '롮:');
  Label1.autosize := true;

  Label2:= TLabel.Create(Self);
  Label2.parent := Self;
  Label2.left := 105;
  Label2.top := 315;
  Label2.align := alfixedlefttop;
  Label2.caption := pdeLoadNLS('pdeDlgFilter', ':');
  Label2.autosize := true;

  edName:= TEdit.Create(Self);
  edName.parent := Self;
  edName.width := 220;
  edName.left := 170;
  edName.top := 285;
  edName.align := alfixedlefttop;
  edName.showhint := true;
  edName.Hint := pdeLoadNLS('pdeDlgHint1', ' ࠭ 쥪');

  edPath:= TDirectoryEdit.Create(Self);
  edPath.parent := tBar;
  edPath.width := 235;
  edPath.left := 255;
  edPath.top := 8;
  edPath.align := alfixedlefttop;
  edPath.showhint := true;
  edPath.Hint := pdeLoadNLS('pdeDlgHint2', '  䠩');
  edPath.OnChangeDirectory := drEditChangeDir;

  drBox:= TDriveComboBox.Create(Self);
  drBox.parent := tBar;
  drBox.width := 100;
  drBox.top := 8;
  drBox.left := 154;//105;
  drBox.align := alfixedlefttop;
  drBox.onchange := drBoxChange;

  cbMask:= TCombobox.Create(Self);
  cbMask.parent := Self;
  cbMask.width := 220;
  cbMask.top := 310;
  cbMask.left := 170;
  cbMask.align := alfixedlefttop;
  cbMask.onitemselect := cbMaskItemselect;

  xbUp:= TExplorerButton.Create(Self);
  xbUp.parent := tBar;
  xbUp.width := 28;
  xbUp.height :=28;
  xbUp.left := 2;
  xbUp.top := 2;
  xbUp.ShowHint := True;
  xbUp.Hint := pdeLoadNLS('pdeDlgHint3', '३  ஢ ');
  xbUp.align := alfixedlefttop;
  xbUp.onclick := xbUpClick;

  xbRefresh:= TExplorerButton.Create(Self);
  xbRefresh.parent := tBar;
  xbRefresh.width := 28;
  xbRefresh.height :=28;
  xbRefresh.left := 32;
  xbRefresh.top := 2;
  xbRefresh.ShowHint := True;
  xbRefresh.Hint := pdeLoadNLS('pdeDlgHint4', '');
  xbRefresh.align := alfixedlefttop;
  xbRefresh.onclick := xbRefreshClick;

  xbNew:= TExplorerButton.Create(Self);
  xbNew.parent := tBar;
  xbNew.width := 28;
  xbNew.height :=28;
  xbNew.left := 62;
  xbNew.top := 2;
  xbNew.ShowHint := True;
  xbNew.Hint := pdeLoadNLS('pdeDlgHint5', ' ');
  xbNew.align := alfixedlefttop;
  xbNew.onclick := xbNewClick;

  bmMenu:= TPopupMenu.Create(Self);
  bmMenu.Alignment := paLeft;

  xbBookmarks:= TExplorerButton.Create(Self);
  xbBookmarks.parent := tBar;
  xbBookmarks.width := 28;
  xbBookmarks.height :=28;
  xbBookmarks.left := 92;
  xbBookmarks.top := 2;
  xbBookmarks.ShowHint := True;
  xbBookmarks.Hint := pdeLoadNLS('pdeDlgHint6', '');
  xbBookmarks.align := alfixedlefttop;
  xbBookmarks.onclick := xbBookmarksClick;

  xbAddBookmark:= TExplorerButton.Create(Self);
  xbAddBookmark.parent := tBar;
  xbAddBookmark.width := 28;
  xbAddBookmark.height :=28;
  xbAddBookmark.left := 122;
  xbAddBookmark.top := 2;
  xbAddBookmark.ShowHint := True;
  xbAddBookmark.Hint := pdeLoadNLS('pdeDlgHint7', ' ');
  xbAddBookmark.align := alfixedlefttop;
  xbAddBookmark.onclick := xbAddBookmarkClick;

  xbHome:= TExplorerButton.Create(Self);
  xbHome.parent := pPanel;
  xbHome.width := 80;
  xbHome.height :=60;
  xbHome.left := 10;
  xbHome.top := 20;
  xbHome.PenColor := clWhite;
  xbHome.caption := pdeLoadNLS('pdeDlgHomeFolder', ' ');
  xbHome.color := pclr;
  xbHome.layout := blGlyphTop;
  xbHome.align := alfixedlefttop;
  xbHome.onclick := xbHomeClick;

  xbDocs:= TExplorerButton.Create(Self);
  xbDocs.parent := pPanel;
  xbDocs.width := 80;
  xbDocs.height :=60;
  xbDocs.left := 10;
  xbDocs.top := 90;
  xbDocs.PenColor := clWhite;
  xbDocs.caption := pdeLoadNLS('pdeDlgDocsFolder', '㬥');
  xbDocs.color := pclr;
  xbDocs.layout := blGlyphTop;
  xbDocs.align := alfixedlefttop;
  xbDocs.onclick := xbDocsClick;

  xbCdrom:= TExplorerButton.Create(Self);
  xbCdrom.parent := pPanel;
  xbCdrom.width := 80;
  xbCdrom.height :=60;
  xbCdrom.left := 10;
  xbCdrom.top := 160;
  xbCdrom.PenColor := clWhite;
  xbCdrom.caption := pdeLoadNLS('pdeDlgCDROM', 'CD-ROM');
  xbCdrom.color := pclr;
  xbCdrom.layout := blGlyphTop;
  xbCdrom.align := alfixedlefttop;
  xbCdrom.onclick := xbCdromClick;

  xbFloppy:= TExplorerButton.Create(Self);
  xbFloppy.parent := pPanel;
  xbFloppy.width := 80;
  xbFloppy.height :=60;
  xbFloppy.left := 10;
  xbFloppy.top := 230;
  xbFloppy.PenColor := clWhite;
  xbFloppy.caption := pdeLoadNLS('pdeDlgFloppy', '');
  xbFloppy.color := pclr;
  xbFloppy.layout := blGlyphTop;
  xbFloppy.align := alfixedlefttop;
  xbFloppy.onclick := xbFloppyClick;

  bmpDir:= TBitmap.Create;
  bmpFile:= TBitmap.Create;

  //-----------
  pList.selectedname := edName;
  pList.selectedpath := edPath;
  pList.dirbitmap := bmpDir;
  pList.filebitmap := bmpFile;

  basepath := getenv('PDE_HOME');
  if basepath = '' then
    basepath := 'c:\pde';

//-----㧪 -------------------
rez:=FindFirst(basepath+pdeLoadCfgStrD('general.cfg', 'userbookmarks', '\root\Bookmarks')+'\*.*',
  faAnyFile, tsr);
  while rez=0 do
    begin
    rez:=FindNext(tsr);
    if rez<>0 then break;
    if (tsr.attr and faDirectory)=0 then //file
      begin
      assignfile(afile, basepath+pdeLoadCfgStrD('general.cfg', 'userbookmarks', '\root\Bookmarks')+
        '\'+tsr.name);
      reset(afile);
      readln(afile); readln(afile); readln(afile);
      readln(afile, itext);

      bookitem:=TMenuItem.Create(self);
      bookitem.Caption:=tsr.name;
      bookitem.hint:=itext;
      bookitem.onclick:=BookMarkClick;
      bmMenu.Items.add(bookitem);

      closefile(afile);
      end;
    end;
FindClose(tsr);
//-----------------------------------------

  basepath := basepath + '\bitmaps\dialogs\';

  xbUp.glyph.loadfromfile(basepath + 'up.bmp');
  xbRefresh.glyph.loadfromfile(basepath + 'refresh.bmp');
  xbNew.glyph.loadfromfile(basepath + 'new.bmp');
  xbBookmarks.glyph.loadfromfile(basepath + 'bookmark.bmp');
  xbAddBookmark.glyph.loadfromfile(basepath + 'addbookmark.bmp');
  xbHome.glyph.loadfromfile(basepath + 'home.bmp');
  xbDocs.glyph.loadfromfile(basepath + 'docs.bmp');
  xbCdrom.glyph.loadfromfile(basepath + 'cdrom.bmp');
  xbFloppy.glyph.loadfromfile(basepath + 'floppy.bmp');
  bmpDir.LoadFromFile(basepath + 'folder.bmp');
  bmpFile.LoadFromFile(basepath + 'file.bmp');

End;

Procedure TPDEOpenDialog.drBoxChange (Sender: TObject);
Begin
  pList.path:= drBox.Drive + ':\';
End;

procedure TPDEOpenDialog.cbMaskItemSelect(Sender: TObject; Index: LongInt);
var
  s: String;
Begin
  s := cbMask.Items[index];
  delete(s, 1, pos('(', s));
  delete(s, length(s), 1);
  pList.mask := s;
End;

procedure TPDEOpenDialog.xbUpClick (Sender: TObject);
var
  temp: String;
Begin
  temp := pList.path;
  if (length(temp) <= 3) then exit;
  if temp[length(temp)]='\' then Delete(temp, length(temp), 1);
  while temp[length(temp)]<>'\' do
    Delete(temp, length(temp), 1);

  pList.Path := temp;

End;

procedure TPDEOpenDialog.xbRefreshClick (Sender: TObject);
Begin
  pList.Clear;
  pList.LoadFromPath;
End;

procedure TPDEOpenDialog.xbNewClick (Sender: TObject);
var
  newname: String;
Begin
  newname := pdePromptDialog(pdeLoadNLS('pdeDlgCreateFolder', '   ')
    , pdeLoadNLS('pdeDlgHint5', ' '), '');
  if newname <> '' then
    begin
    if DosCreateDir(pList.Path + newname, nil) <> 0 then
      pdeMessageBoxOK(pdeLoadNLS('dlgErrorOnFolderCreate', 'H 㤠 ᮧ .')
        , pdeLoadNLS('dlgError', '訡'), xbHome.Glyph.Handle);
    pList.Clear;
    pList.LoadFromPath;
    end;
End;

procedure TPDEOpenDialog.xbBookmarksClick (Sender: TObject);
var
  p: TPoint;
Begin
  //p := ClientToScreen(Point(xbBookmarks.Left, xbBookmarks.Top));
  //bmMenu.Popup(p.x, p.y);
  bmMenu.Popup(TForm(Self).Left + xbBookmarks.Left + 4,
    Screen.Height - TForm(Self).Top - xbBookmarks.Height - bmMenu.Height - 20);
End;

procedure TPDEOpenDialog.xbAddBookmarkClick (Sender: TObject);
var
  basepath, fname: String;
  afile: TextFile;
Begin
// 
  basepath := getenv('PDE_HOME');
  if basepath = '' then
    basepath := 'c:\pde';

fname:=pList.path;
if length(fname)>3 then
  begin
  delete(fname, length(fname), 1);
  while pos('\', fname)<>0 do
    delete(fname, 1, 1);
  end;
  assignfile(afile, basepath+pdeLoadCfgStrD('general.cfg', 'userbookmarks', '\root\Bookmarks')+'\['+fname+']');
  rewrite(afile);
  writeln(afile, '[SHORTCUT]');
  writeln(afile, '//link: type, object-name, path, parameters');
  writeln(afile, 'FOLDER');
  writeln(afile, pList.path);
  writeln(afile, pList.path);
  writeln(afile);
  closefile(afile);

  bookitem:=TMenuItem.Create(self);
  bookitem.Caption:='['+fname+']';
  bookitem.hint:=pList.path;
  bookitem.onclick:=BookMarkClick;
  bmMenu.Items.add(bookitem);
End;

procedure TPDEOpenDialog.BookmarkClick (Sender: TObject);
Begin
  //饫箪  㭪 bookmark-
  pList.Path := TMenuItem(Sender).Hint;
End;

procedure TPDEOpenDialog.xbHomeClick (Sender: TObject);
var
  basepath: String;
Begin
  basepath := getenv('PDE_HOME');
  if basepath = '' then
    basepath := 'c:\pde';
//  drBox.Drive := basepath[1];
  pList.Path := basepath +pdeLoadCfgStrD('general.cfg', 'userhome', '\root\Home')+ '\';
End;

procedure TPDEOpenDialog.xbDocsClick (Sender: TObject);
var
  basepath: String;
Begin
  basepath := getenv('PDE_HOME');
  if basepath = '' then
    basepath := 'c:\pde';
  pList.Path := basepath +pdeLoadCfgStrD('general.cfg', 'userdocs', '\root\Documents')+'\';
//  drBox.Drive := basepath[1];
End;

procedure TPDEOpenDialog.xbCdromClick (Sender: TObject);
var
  basepath: String;
  afile: TextFile;
  tsr: TSearchRec;
  itext, itext2: String;
  rez: Integer;
Begin

  //  pList.path := 'e:\';
  //  drBox.Drive := 'e';

  {we have CD-ROM? Really ;-)}
  itext := '';
  itext2 := '';
  basepath := getenv('PDE_HOME');
  if basepath = '' then
    basepath := 'c:\pde';

rez:=FindFirst(basepath
  +pdeLoadCfgStrD('general.cfg', 'userdrives', '\root\Drives')+'\*.*'
  ,  faAnyFile, tsr);
  while rez=0 do
    begin
    rez:=FindNext(tsr);
    if rez<>0 then break;
    if (tsr.attr and faDirectory)=0 then //file
      begin
      assignfile(afile, basepath+pdeLoadCfgStrD('general.cfg', 'userdrives', '\root\Drives')+
        '\'+tsr.name);
      reset(afile);
      readln(afile); readln(afile);
      readln(afile, itext);
      readln(afile, itext2);
      closefile(afile);
      if itext = 'CD-ROM' then
        begin
        //we find it... of cource if you set it right ;-)
        FindClose(tsr);
        pList.path := itext2;
        drBox.Drive := itext2[1];
        exit;
        end;
      end;
    end;
FindClose(tsr);

End;

procedure TPDEOpenDialog.xbFloppyClick (Sender: TObject);
Begin
  pList.path := 'a:\';
  drBox.Drive := 'a';
End;

Procedure TPDEOpenDialog.drEditChangeDir (NewDir: String);
Begin
  pList.path := NewDir;
End;

Procedure TPDEOpenDialog.pdeOpenDialogTranslateShortcut(Sender: TObject;
  KeyCode: TKeyCode; Var ReceiveR: TForm);
var
  temp: String;
Begin
if (KeyCode = kbBkSp) and (ActiveControl <> edName) then
  begin
  if wasBkSp then begin wasBkSp:=false; exit; end;
  wasBkSp := true;
  if length(pList.path) > 3 then
    begin
    temp := pList.path;
    if temp[length(temp)] = '\' then delete(temp, length(temp), 1);
    while temp[length(temp)] <> '\' do
      delete(temp, length(temp), 1);

    pList.path := temp;
    end;
  end
  else if (KeyCode = kbF5) then
    begin
    pList.Clear;
    pList.LoadFromPath;
    end
  else if (KeyCode = kbF7) then
    xbNewClick (Sender)
  else if (ActiveControl = pList) then
    begin
    if pList.ItemIndex <> -1 then
      begin
        edName.Text := pList.Items[pList.ItemIndex].Text;
      end;
    end;

End;

Initialization
  RegisterClasses ([TPDEOpenDialog]);
End.
