//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE common dialogs DLL                //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit Unit2;

Interface

Uses
  Classes, Forms, Graphics, StdCtrls, Buttons, pdeNLS;

Type
  TPromptForm = Class (TForm)
    Label1: TLabel;
    bOK: TButton;
    bCancel: TButton;
    edResult: TEdit;
    Procedure bCancelOnClick (Sender: TObject);
    Procedure bOKOnClick (Sender: TObject);
    Procedure PromptFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  PromptForm: TPromptForm;

function pdePromptDialog(text, cptn, default: String): String;

Implementation

function pdePromptDialog(text, cptn, default: String): String;
begin

  {dialog, asking something (with default value)}
  //Application.Create;
  PromptForm := TPromptForm.Create(nil);
  PromptForm.Caption := cptn;
  PromptForm.Label1.Caption := text;
  PromptForm.edResult.Text := default;
  PromptForm.ActiveControl := PromptForm.edResult;

  PromptForm.ShowModal;
  Result := PromptForm.edResult.Text;

  PromptForm.Free;
  //Application.Destroy;

end;

Procedure TPromptForm.bCancelOnClick (Sender: TObject);
Begin
  edResult.Text := '';
  close;
End;

Procedure TPromptForm.bOKOnClick (Sender: TObject);
Begin
  close;
End;

Procedure TPromptForm.PromptFormOnCreate (Sender: TObject);
Begin
  BorderStyle := bsStealthDlg;
  bOK.Caption := pdeLoadNLS('dlgOkButton', 'OK');
  bCancel.Caption := pdeLoadNLS('dlgCancelButton', '⬥');
End;

Initialization
  RegisterClasses ([TPromptForm, TLabel, TButton, TEdit]);
End.
