//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE Desktop Manager (pdm.exe)         //
//  "Desktop notes" unit                  //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit pdmNotesUnit;

Interface

Uses
  Classes, Forms, Graphics, StdCtrls, Buttons, pdeNLS;

Type
  TNotesForm = Class (TForm)
    chShowNotes: TCheckBox;
    List: TMemo;
    Procedure NotesFormOnClose (Sender: TObject; Var Action: TCloseAction);
    Procedure NotesFormOnShow (Sender: TObject);
    Procedure chShowNotesOnClick (Sender: TObject);
    Procedure NotesFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  NotesForm: TNotesForm;

Implementation

Uses pdmUnit1;

Procedure TNotesForm.NotesFormOnClose (Sender: TObject;
  Var Action: TCloseAction);
Begin
  { save quick notes to the file }
  if NotesEnabled then
    List.Lines.Add(';-)');
  List.Lines.SaveToFile(pdebase
    +pdeLoadCfgStrD('general.cfg', 'userhome', '\root\Home')
    +'\quicknotes.txt');
  if NotesEnabled then
    List.Lines.Delete(List.Lines.IndexOf(';-)'));
  MainForm.Invalidate;
End;

Procedure TNotesForm.NotesFormOnShow (Sender: TObject);
Begin
  ClientWidth := Screen.Width div 3 + 40;
End;

Procedure TNotesForm.chShowNotesOnClick (Sender: TObject);
Begin
  NotesEnabled := chShowNotes.Checked;
  MainForm.Invalidate;
End;

Procedure TNotesForm.NotesFormOnCreate (Sender: TObject);
Begin
  BorderStyle := bsDialog;
  NotesForm.caption := MainForm.mNotes.caption;
  chShowNotes.caption := MainForm.mNotes.caption;
End;

Initialization
  RegisterClasses ([TNotesForm, TCheckBox, TMemo]);
End.
