//----------------------------------------//
//                                        //
//  PDE Desktop Environment (OS/2)        //
//  http://os2progg.by.ru/pde             //
//                                        //
//  PDE Desktop Manager (pdm.exe)         //
//  New "Desktop config" dialog unit      //
//  Copyleft [PDE Team] 2004              //
//                                        //
//----------------------------------------//

Unit pdmCFG;

Interface

Uses
  Classes, Forms, Graphics, Buttons, ComCtrls, StdCtrls, ExtCtrls
  , pdeNLS ,SysUtils, pdeDlgsDLL, Dos, pmwin, bsedos, os2def;

Type
  TTPDMCfgForm = Class (TForm)
    bOK: TButton;
    bCancel: TButton;
    LWallpaper: TLabel;
    LColor: TLabel;
    IWallpaper: TImage;
    SHColor: TShape;
    Bevel1: TBevel;
    LIcons: TLabel;
    LLanguage: TLabel;
    EdIcons: TEdit;
    EdLanguage: TEdit;
    LLangChange: TLabel;
    CBBox: TComboBox;
    LGradient: TLabel;
    SHGradient: TShape;
    Bevel2: TBevel;
    Procedure LLangChangeOnClick (Sender: TObject);
    Procedure IWallpaperOnClick (Sender: TObject);
    Procedure TPDMCfgFormOnShow (Sender: TObject);
    Procedure TPDMCfgFormOnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
    Procedure ColorClick (Sender: TObject);
    Procedure Color2Click (Sender: TObject);
  End;

Var
  TPDMCfgForm: TTPDMCfgForm;
  FWallpaper: String;
  FColor1: LongInt;
  FColor2: LongInt;
  FWallStyle: Integer;

function pdmCfgShow(wp: String): Integer;
function LoadGBM(fname: String): String;

Implementation

//-----------------------------------------

function pdmCfgShow(wp: String): Integer;
var
  pdmCfgForm: TTPDMCfgForm;
  tmpstr: String;
  cfgdata: TStringList;
Begin
  try
    tpdmCfgForm := TTPDMCfgForm.Create(Application.MainForm);
    except
    tpdmCfgForm.Free;
    Result := 1;
    exit;
    end;

  FWallpaper := wp;

  FColor1 := pdeLoadCfgColor('pdm.cfg', 'desktopcolor');
  FColor2 := pdeLoadCfgColor('pdm.cfg', 'secondcolor');
  tpdmCfgForm.shColor.Brush.Color := FColor1;
  tpdmCfgForm.shGradient.Brush.Color := FColor2;

  tpdmCfgForm.edIcons.Text := pdeLoadCfgStr('pdm.cfg', 'iconsize');
  tpdmCfgForm.edLanguage.Text := pdeLoadCfgStr('general.cfg', 'language');

  tmpstr := pdeLoadCfgStr('pdm.cfg', 'wallpaperstyle');

  if tmpstr = 'center' then
    FWallStyle := 0
  else if tmpstr = 'stretch' then
    FWallStyle := 1
  else if tmpstr = 'tile' then
    FWallStyle := 2
  else if tmpstr = 'lefttop' then
    FWallStyle := 3
  else if tmpstr = 'righttop' then
    FWallStyle := 4
  else if tmpstr = 'leftbottom' then
    FWallStyle := 5
  else if tmpstr = 'rightbottom' then
    FWallStyle := 6
  else if tmpstr = 'vgradient' then
    FWallStyle := 7;

  Result := 0;

  if tpdmCfgForm.ShowModal = cmOK then
    begin
    //save configuration
    case tpdmCfgForm.cbBox.ItemIndex of
      0: tmpstr := 'center';
      1: tmpstr := 'stretch';
      2: tmpstr := 'tile';
      3: tmpstr := 'lefttop';
      4: tmpstr := 'righttop';
      5: tmpstr := 'leftbottom';
      6: tmpstr := 'rightbottom';
      7: tmpstr := 'vgradient';
    end;
    cfgdata := TStringList.Create;
    cfgdata.Add('//config file of the PDE desktop manager (pdm.exe)');
    cfgdata.Add('iconsize='+tpdmCfgForm.edIcons.Text);
    cfgdata.Add('//desktop color');
    cfgdata.Add('desktopcolor='+IntToStr(FColor1));
    cfgdata.Add('secondcolor='+IntToStr(FColor2));
    cfgdata.Add('//wallpaper (full path or path from \..\pde\)');
    cfgdata.Add('wallpaper='+FWallpaper);
    cfgdata.Add('//center, tile, stretch, vgradient, lefttop, righttop, leftbottom, rightbottom');
    cfgdata.Add('wallpaperstyle='+tmpstr);
    cfgdata.Add('//Screen-saver application');
    cfgdata.Add('screensaver='+pdeLoadCfgStr('pdm.cfg','screensaver'));
    cfgdata.Add('//Time (msec) for screen-saver');
    cfgdata.Add('savertime='+pdeLoadCfgStr('pdm.cfg', 'savertime'));
    pdeSaveCfgFile('pdm.cfg', cfgdata);
    cfgdata.free;

    cfgdata := TStringList.Create;
    cfgdata.Add('//General preferences for "PDE desktop"');
    cfgdata.Add('//pde_home= <-in config.sys "SET PDE_HOME=C:\PDE" for example');
    cfgdata.Add('//language= <-not in config.sys "SET LANG=ua_ua"');
    cfgdata.Add('language=' + tpdmCfgForm.edLanguage.Text);
    cfgdata.Add('//1/0');
    cfgdata.Add('askforshutdown=' + pdeLoadCfgStrD('general.cfg', 'askforshutdown', '1'));
    cfgdata.Add('//ask user when delete file or folder');
    cfgdata.Add('askfordelete=' + pdeLoadCfgStrD('general.cfg', 'askfordelete', '1'));
    cfgdata.Add('//overwrite destination when copying (moving) files and destination exists');
    cfgdata.Add('overwritefiles=' + pdeLoadCfgStrD('general.cfg', 'overwritefiles', '1'));
    cfgdata.Add('//Show error messages when unsucsessful start apps');
    cfgdata.Add('execerrors=' + pdeLoadCfgStrD('general.cfg', 'execerrors', '1'));
    cfgdata.Add('//folders paths');
    cfgdata.Add('userhome=' + pdeLoadCfgStrD('general.cfg', 'userhome', '\root\Home'));
    cfgdata.Add('userdocs=' + pdeLoadCfgStrD('general.cfg', 'userdocs', '\root\Documents'));
    cfgdata.Add('userdrives=' + pdeLoadCfgStrD('general.cfg', 'userdrives', '\root\Drives'));
    cfgdata.Add('userstartup=' + pdeLoadCfgStrD('general.cfg', 'userstartup', '\root\StartUp'));
    cfgdata.Add('userprograms=' + pdeLoadCfgStrD('general.cfg', 'userprograms', '\root\Programs'));
    cfgdata.Add('userbookmarks=' + pdeLoadCfgStrD('general.cfg', 'userbookmarks', '\root\Bookmarks'));
    pdeSaveCfgFile('general.cfg', cfgdata);
    cfgdata.free;
    end
    else
    Result := 1;

  if tpdmCfgForm<>nil then
    tpdmCfgForm.Free;
End;

//-----------------------------------------

Procedure TTPDMCfgForm.TPDMCfgFormOnShow (Sender: TObject);
Begin

  Caption := pdeLoadNLS('pdmcfgstr1', '稩 ⮫ - ன');
  bCancel.Caption := pdeLoadNLS('dlgCancelButton', '⬥');
  bOk.Caption := pdeLoadNLS('dlgOkButton', 'OK');
  lWallpaper.Caption := pdeLoadNLS('pdmcfgstr2', ' 㭮:');
  lColor.Caption := pdeLoadNLS('pdmcfgstr3', ' 䮭:');
  lGradient.Caption := pdeLoadNLS('pdmcfgstr13', 'ன 梥:');
  lIcons.Caption := pdeLoadNLS('pdmcfgstr4', ' ⮣ࠬ:');

  cbBox.Clear;
  cbBox.Items.Add(pdeLoadNLS('pdmcfgstr5', 'ᯮ  業'));
  cbBox.Items.Add(pdeLoadNLS('pdmcfgstr6', ' (⠡஢)'));
  cbBox.Items.Add(pdeLoadNLS('pdmcfgstr7', '뫮 ⪮'));
  cbBox.Items.Add(pdeLoadNLS('pdmcfgstr8', ' 孨 㣮'));
  cbBox.Items.Add(pdeLoadNLS('pdmcfgstr9', 'ࠢ 孨 㣮'));
  cbBox.Items.Add(pdeLoadNLS('pdmcfgstr10', '  㣮'));
  cbBox.Items.Add(pdeLoadNLS('pdmcfgstr11', 'ࠢ  㣮'));
  cbBox.Items.Add(pdeLoadNLS('pdmcfgstr12', '⮢ 室 (ࠤ)'));
  cbBox.ItemIndex := FWallStyle;

  shColor.OnClick := ColorClick;
  shGradient.OnClick := Color2Click;

  try
  if FWallpaper=':' then
    begin
    if FileExists(FWallpaper) then
      iWallpaper.Bitmap.Loadfromfile(FWallpaper);
    end
    else
    begin
    if FileExists(extractfilepath(application.exename)+FWallpaper) then
      iWallpaper.Bitmap.Loadfromfile(extractfilepath(application.exename)+FWallpaper);
    end;

    except

    end;

End;

//------------------------------------------

function LoadGBM(fname: String): String;
var
  tmppath: String;
Begin

  tmpPath := ExtractFilePath(Application.ExeName);//GetEnv('TEMP') + '\';
  DeleteFile(tmpPath + '~pdm.bmp');

  _ShellExecute(tmpPath+'Utils\gbmsize.exe'
    , ExtractFilePath(Application.ExeName)+'Utils\', ' '
    + fname + ' '+ tmpPath + '~pdm.bmp', True, SSF_FGBG_BACK
    , SSF_CONTROL_INVISIBLE, SSF_RELATED_CHILD);

    DosSleep(2000);
    if not FileExists(tmpPath + '~pdm.bmp') then DosSleep(500);
    if not FileExists(tmpPath + '~pdm.bmp') then DosSleep(500);
    if not FileExists(tmpPath + '~pdm.bmp') then DosSleep(300);
    if not FileExists(tmpPath + '~pdm.bmp') then DosSleep(300);
    if not FileExists(tmpPath + '~pdm.bmp') then DosSleep(300);

  Result := tmpPath + '~pdm.bmp';

End;

//------------------------------------------

Procedure TTPDMCfgForm.LLangChangeOnClick (Sender: TObject);
var
  fname, fpath: String;
Begin

  { click on change Language button }
  fpath := getenv('PDE_HOME');
  if fpath = '' then
    fpath := 'c:\pde';
  if fpath[length(fpath)] <> '\' then
    fpath := fpath + '\';
  fpath := fpath + 'Languages\';

  fname := pdeOpenFileDialog(pdeLoadNLS('ppOpenFile', '⨥ 䠩')
    , fpath, 'NLS (*.nls)|');

  if fname <> '' then
    begin
    fname := ExtractFileName(fname);
    delete(fname, length(fname)-3, 4);
    edLanguage.Text := fname;
    end;

End;

//------------------------------------------

Procedure TTPDMCfgForm.ColorClick (Sender: TObject);
var
  Clr: TColor;
Begin
  if pdeColorDialog(Clr) then
    begin
    shColor.Brush.Color := Clr;
    FColor1 := Clr;
    shColor.Invalidate;
    end;
End;

//-----------------------------------------

Procedure TTPDMCfgForm.Color2Click (Sender: TObject);
var
  Clr: TColor;
Begin
  if pdeColorDialog(Clr) then
    begin
    shGradient.Brush.Color := Clr;
    FColor2 := Clr;
    shGradient.Invalidate;
    end;
End;

//-----------------------------------------

Procedure TTPDMCfgForm.IWallpaperOnClick (Sender: TObject);
var
  fname: String;
Begin

  {load wallpaper}
  fname := pdeOpenFileDialog(pdeLoadNLS('ppOpenFile', '⨥ 䠩')
    , 'c:\', pdeLoadNLS('pdmcfgstr14', '㭪')+' (*.bmp;*.jpg;*.jpe;*.jpeg;*.gif;*.pcx;*.tif;*.tiff;*.tga)|');
  if fname <> '' then
    begin
    if lowercase(ExtractFileExt(fname)) <> '.bmp' then
      fname := LoadGBM(fname);

      if FileExists(fname) then
        begin
        iWallpaper.bitmap.loadfromfile(fname);
        FWallpaper := fname;
        end;

    end;

End;

//-----------------------------------------

Procedure TTPDMCfgForm.TPDMCfgFormOnCreate (Sender: TObject);
Begin

  BorderStyle := bsDialog;

End;

//-----------------------------------------

Initialization
  RegisterClasses ([TTPDMCfgForm, TButton, TLabel, TImage, TShape, TBevel, TEdit
   , TComboBox]);
End.
