//[SHORTCUT] properties dialog
Unit PropUnit3;

Interface

Uses
  Classes, Forms, Graphics, Buttons, ExtCtrls, SysUtils
  , pdeNLS, os2def, PMWin, StdCtrls, pdedlgs;

Type
  TPropForm3 = Class (TForm)
    btnCancel: TButton;
    btnOK: TButton;
    Shape1: TShape;
    pBox: TPaintBox;
    Bevel1: TBevel;
    LName: TLabel;
    LDir: TLabel;
    Bevel2: TBevel;
    LData: TLabel;
    LFName: TLabel;
    LFPath: TLabel;
    LFParam: TLabel;
    edName: TEdit;
    edPath: TEdit;
    bChoose: TButton;
    edParams: TEdit;
    Bevel3: TBevel;
    Procedure bChooseOnClick (Sender: TObject);
    Procedure pBoxOnPaint (Sender: TObject; Const rec: TRect);
    Procedure PropForm3OnTranslateShortCut (Sender: TObject; KeyCode: TKeyCode;
      Var ReceiveR: TForm);
    Procedure PropForm3OnShow (Sender: TObject);
    Procedure btnOKOnClick (Sender: TObject);
    Procedure btnCancelOnClick (Sender: TObject);
    Procedure PropForm3OnCreate (Sender: TObject);
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
  End;

Var
  PropForm3: TPropForm3;
  bmp: LongWord;
  LinkType: String; //APP, FOLDER

Implementation

Uses Unit1;

Procedure TPropForm3.bChooseOnClick (Sender: TObject);
var
  fname: String;
Begin
  //path for place new link/path, where existing link stored
  fname := pdeOpenFileDialog(pdeLoadNLS('ppOpenFile', '⨥ 䠩')
    , edPath.Text, pdeLoadNLS('eD2Str35','All files')+' (*.*)|');
  if fname <> '' then
    edPath.Text := fname;
End;

Procedure TPropForm3.pBoxOnPaint (Sender: TObject; Const rec: TRect);
var
  ps: hPS;
Begin
  {render image in "bmp" pointer}
  pBox.canvas.fillrect(pBox.Canvas.ClipRect, Shape1.Brush.Color);
  ps := WinGetPS(pBox.Handle);
  WinDrawPointer( ps, 0, 0, bmp, 0);
  WinReleasePS(ps);
End;

Procedure TPropForm3.PropForm3OnTranslateShortCut (Sender: TObject;
  KeyCode: TKeyCode; Var ReceiveR: TForm);
Begin

  if KeyCode=kbEsc then
    btnCancelOnClick (Sender);

End;

Procedure TPropForm3.PropForm3OnShow (Sender: TObject);
Begin

  Color := MainForm.Color;
  bmp := MainForm.vFiles.Items[MainForm.vFiles.ItemIndex].Icon;

End;

Procedure TPropForm3.btnOKOnClick (Sender: TObject);
var
  afile: TextFile;
  t: String;
Begin
  {save propeerties of shortcut}
  try
    assignfile(afile, LDir.Caption+LName.Caption);
    Rewrite(afile);
    Writeln(afile, '[SHORTCUT]');
    Writeln(afile, '//link: type, object-name, path, parameters');
    Writeln(afile, LinkType);
    if LinkType = 'APP' then
      t := ConcatFileName(edPath.Text,edName.Text)
      else
      t := edName.Text;
    Writeln(afile, t);
    Writeln(afile, PropForm3.edPath.Text);
    Writeln(afile, PropForm3.edParams.Text);
    CloseFile(afile);
  except
    CloseFile(afile);
  end;
  PropForm3.Close;
  WinSetActiveWindow(HWND_DESKTOP, MainForm.Handle);
End;

Procedure TPropForm3.btnCancelOnClick (Sender: TObject);
Begin
  {cancel}
  PropForm3.Close;
  WinSetActiveWindow(HWND_DESKTOP, MainForm.Handle);
End;

Procedure TPropForm3.PropForm3OnCreate (Sender: TObject);
Begin
  BorderStyle:=bsStealthDlg;
  LData.Caption := pdeLoadNLS('dlgShortcutData', 'Target object data');
  LFName.Caption := pdeLoadNLS('dlgShortcutName', 'Name');
  LFPath.Caption := pdeLoadNLS('dlgShortcutPath', 'Work directory');
  LFParam.Caption := pdeLoadNLS('dlgShortcutParams', 'Parameters');
  btnOk.Caption := pdeLoadNLS('dlgOkButton', '');
  btnCancel.Caption := pdeLoadNLS('dlgCancelButton', '⬥');
End;

Initialization
  RegisterClasses ([TPropForm3, TButton, TShape, TPaintBox, TBevel, TLabel,
    TEdit]);
End.
