//-----------------------------------------
//PDE Desktop, stVova 2003
//Desktop config dialog
//-----------------------------------------

unit pdmCFG;

Interface

Uses Classes, Forms, Graphics, Buttons, ComCtrls, StdCtrls, ExtCtrls
  , pdeNLS ,SysUtils, pdeDlgs, Dos, pmwin, bsedos, os2def;

Type

TPDMCfgForm = class(TForm)
  FWallpaper: String;
  FColor1: LongInt;
  FColor2: LongInt;
  lWallpaper: TLabel;
  lColor: TLabel;
  lIcons: TLabel;
  lGradient: TLabel;
  iWallpaper: TImage;
  shColor: TShape;
  Bevel1: TBevel;
  Bevel2: TBevel;
  rbCenter: TRadioButton;
  rbStretch: TRadioButton;
  rbTile: TRadioButton;
  rbLU: TRadioButton;
  rbRU: TRadioButton;
  rbLB: TRadioButton;
  rbRB: TRadioButton;
  rbGradient: TRadioButton;
  shGradient: TShape;
  edIcons: TEdit;
  bOK: TButton;
  bCancel: TButton;

  lLanguage: TLabel;
  edLanguage: TEdit;
  lLangChange: TLabel;
  Private
    {Insert private declarations here}
  Public
    {Insert public declarations here}
    Constructor Create(AOwner:TComponent); Override;
    Procedure bOKClick (Sender: TObject);
    Procedure bCancelClick (Sender: TObject);
    Procedure iWallClick (Sender: TObject);
    Procedure ColorClick (Sender: TObject);
    Procedure Color2Click (Sender: TObject);
    Procedure lLangChangeClick (Sender: TObject);
  End;

function pdmCfgShow(wp: String): Integer;
function _ShellExecute(fname, fdir, fparam: string; shortcut: boolean; fg, pgmCntr, rel: ULong): Boolean;
function LoadGBM(fname: String): String;

Implementation

//Uses pdmUnit1;

function LoadGBM(fname: String): String;
var
  tmppath: String;
Begin

  tmpPath := ExtractFilePath(Application.ExeName);//GetEnv('TEMP') + '\';
  DeleteFile(tmpPath + '~pdm.bmp');

  _ShellExecute(tmpPath+'Utils\gbmsize.exe'
    , ExtractFilePath(Application.ExeName)+'Utils\', ' '
    + fname + ' '+ tmpPath + '~pdm.bmp', True, SSF_FGBG_BACK
    , SSF_CONTROL_INVISIBLE, SSF_RELATED_CHILD);

    DosSleep(2000);
    if not FileExists(tmpPath + '~pdm.bmp') then DosSleep(500);
    if not FileExists(tmpPath + '~pdm.bmp') then DosSleep(500);
    if not FileExists(tmpPath + '~pdm.bmp') then DosSleep(300);
    if not FileExists(tmpPath + '~pdm.bmp') then DosSleep(300);
    if not FileExists(tmpPath + '~pdm.bmp') then DosSleep(300);

  Result := tmpPath + '~pdm.bmp';

End;

function _ShellExecute(fname, fdir, fparam: string; shortcut: boolean; fg, pgmCntr, rel: ULong): Boolean;
var
  sd: StartData;
  idSession: ULong;
  apid: PID;
  fname2, fparam2: pchar;
  rc, rc2: APIRET;
begin
if not(shortcut) and (fparam <> '') then
  fparam:='"'+fparam+'"';  //<-  ஡    䠩
new(fname2);
new(fparam2);
StrPCopy(fname2, fname);
StrPCopy(fparam2, fparam);

with sd do
  begin
      Length   := sizeof(StartData);
      Related  := rel;//ssf_Related_Independent; // start an independent session
      FgBg     := fg;//ssf_Fgbg_Fore;           // start session in foreground
      TraceOpt := ssf_TraceOpt_None;       // No trace
      PgmTitle := fname2;
      PgmName := fname2;
      PgmInputs :=fparam2;
      TermQ := nil;                        // No termination queue
      Environment := nil;                  // No environment string
      InheritOpt := ssf_InhertOpt_Parent;
      SessionType := ssf_Type_Default;
      IconFile := nil;                     // No icon association
      PgmHandle := 0;
      PgmControl := pgmCntr;//ssf_Control_Visible;
      InitXPos  := 0;     // Initial window coordinates
      InitYPos  := 0;
      InitXSize := 200;    // Initial window size
      InitYSize := 140;
      Reserved := 0;
      ObjectBuffer  := nil;
      ObjectBuffLen := 0;
  end;

if length(fdir)>3 then
  Delete(fdir, length(fdir), 1); //delete "\"

rc:=DosSetCurrentDir(fdir);
rc2:=DosStartSession(sd, idSession, apid);

freemem(fname2, sizeof(fname2));
freemem(fparam2, sizeof(fparam2));

Result := True;

end;

Constructor TPDMCfgForm.Create(AOwner:TComponent);
var
  fnt: TFont;
Begin
Inherited Create(AOwner);

BorderStyle := bsDialog;
BorderIcons := [biSystemMenu, biMinimize];
Font.Name := 'WarpSans:9';
Width := 420;
Height := 430;
Position := poScreenCenter;
Caption := pdeLoadNLS('pdmcfgstr1', '稩 ⮫ - ன');

fnt := screen.createcompatiblefont(font);
fnt.attributes := [fabold];

lWallpaper := TLabel.Create(Self);
lWallpaper.Parent := Self;
lWallpaper.Caption := pdeLoadNLS('pdmcfgstr2', ' 㭮:');
lWallpaper.Font := fnt; //bold
lWallpaper.Width := 170;
lWallpaper.Left := 8;
lWallpaper.Top := 8;
lWallpaper.Align := alFixedLeftTop;

lColor := TLabel.Create(Self);
lColor.Parent := Self;
lColor.Caption := pdeLoadNLS('pdmcfgstr3', ' 䮭:');
lColor.Font := fnt;
lColor.Width := 170;
lColor.Left := 8;
lColor.Top := 160;
lColor.Align := alFixedLeftTop;

lIcons := TLabel.Create(Self);
lIcons.Parent := Self;
lIcons.Caption := pdeLoadNLS('pdmcfgstr4', ' ⮣ࠬ:');
lIcons.Font := fnt;
lIcons.Width := 170;
lIcons.Left := 8;
lIcons.Top := 310;
lIcons.Align := alFixedLeftTop;

//TImage
iWallpaper := TImage.Create(Self);
iWallpaper.Parent := Self;
iWallpaper.Width := 160;
iWallpaper.Height := 120;
iWallpaper.Left := 8;
iWallpaper.Top := 30;
iWallpaper.Align := alFixedLeftTop;
iWallpaper.OnClick := iWallClick;

shColor:=TShape.Create(Self);
shColor.Parent := Self;
shColor.Width := 160;
shColor.Height := 120;
shColor.Left := 8;
shColor.Top := 180;
shColor.Align := alFixedLeftTop;
shColor.OnClick := ColorClick;

Bevel1:=TBevel.Create(Self);
Bevel1.Parent := Self;
Bevel1.Width := 220;
Bevel1.Height := 270;
Bevel1.Left := 180;
Bevel1.Top := 30;
Bevel1.Align := alFixedLeftTop;

//RadioButton
rbCenter:=TRadioButton.Create(Self);
rbCenter.Parent := Self;
rbCenter.Caption := pdeLoadNLS('pdmcfgstr5', 'ᯮ  業');
rbCenter.Width := 200;
rbCenter.Left := 190;
rbCenter.Top := 35;
rbCenter.Align := alFixedLeftTop;

rbStretch:=TRadioButton..Create(Self);
rbStretch.Parent := Self;
rbStretch.Caption := pdeLoadNLS('pdmcfgstr6', ' (⠡஢)');
rbStretch.Width := 200;
rbStretch.Left := 190;
rbStretch.Top := 60;
rbStretch.Align := alFixedLeftTop;

rbTile:=TRadioButton..Create(Self);
rbTile.Parent := Self;
rbTile.Caption := pdeLoadNLS('pdmcfgstr7', '뫮 ⪮');
rbTile.Width := 200;
rbTile.Left := 190;
rbTile.Top := 85;
rbTile.Align := alFixedLeftTop;

rbLU:=TRadioButton..Create(Self);
rbLU.Parent := Self;
rbLU.Caption := pdeLoadNLS('pdmcfgstr8', ' 孨 㣮');
rbLU.Width := 200;
rbLU.Left := 190;
rbLU.Top := 110;
rbLU.Align := alFixedLeftTop;

rbRU:=TRadioButton..Create(Self);
rbRU.Parent := Self;
rbRU.Caption := pdeLoadNLS('pdmcfgstr9', 'ࠢ 孨 㣮');
rbRU.Width := 200;
rbRU.Left := 190;
rbRU.Top := 135;
rbRU.Align := alFixedLeftTop;

rbLB:=TRadioButton..Create(Self);
rbLB.Parent := Self;
rbLB.Caption := pdeLoadNLS('pdmcfgstr10', '  㣮');
rbLB.Width := 200;
rbLB.Left := 190;
rbLB.Top := 160;
rbLB.Align := alFixedLeftTop;

rbRB:=TRadioButton..Create(Self);
rbRB.Parent := Self;
rbRB.Caption := pdeLoadNLS('pdmcfgstr11', 'ࠢ  㣮');
rbRB.Width := 200;
rbRB.Left := 190;
rbRB.Top := 185;
rbRB.Align := alFixedLeftTop;

rbGradient:=TRadioButton..Create(Self);
rbGradient.Parent := Self;
rbGradient.Caption := pdeLoadNLS('pdmcfgstr12', '⮢ 室 (ࠤ)');
rbGradient.Width := 200;
rbGradient.Left := 190;
rbGradient.Top := 210;
rbGradient.Align := alFixedLeftTop;

lGradient:=TLabel.Create(Self);
lGradient.Parent := Self;
lGradient.Caption := pdeLoadNLS('pdmcfgstr13', 'ன 梥:');
lGradient.Width := 100;
lGradient.Left := 205;
lGradient.Top := 240;
lGradient.Align := alFixedLeftTop;

//TShape
shGradient:=TShape.Create(Self);
shGradient.Parent := Self;
shGradient.Width := 80;
shGradient.Height := 20;
shGradient.Left := 310;
shGradient.Top := 235;
shGradient.OnClick := Color2Click;
//shGradient.Align := alFixedLeftTop;

edIcons:=TEdit.Create(Self);
edIcons.Parent := Self;
edIcons.Width := 100;
edIcons.Left := 180;
edIcons.Top := 305;
edIcons.NumbersOnly := True;
edIcons.Align := alFixedLeftTop;

Bevel2:=TBevel.Create(Self);
Bevel2.Parent := Self;
Bevel2.Shape := bsTopLine;
Bevel2.Width := 390;
Bevel2.Height := 4;
Bevel2.Left := 8;
Bevel2.Top := 355;
Bevel2.Align := alFixedLeftTop;

bOK:=TButton.Create(Self);
bOK.Parent := Self;
bOK.Command := cmOK;
bOK.ModalResult := cmOK;
bOk.Caption := pdeLoadNLS('dlgOkButton', 'OK');
bOK.Width := 100;
bOK.Left := 190;
bOK.Top := 365;
bOK.Default := True;
bOK.Align := alFixedLeftTop;
bOK.OnClick := bOKClick;

bCancel:=TButton.Create(Self);
bCancel.Parent := Self;
bCancel.Command := cmCancel;
bCancel.ModalResult := cmCancel;
bCancel.Caption := pdeLoadNLS('dlgCancelButton', '⬥');
bCancel.Width := 100;
bCancel.Left := 300;
bCancel.Top := 365;
bCancel.Align := alFixedLeftTop;
bCancel.OnClick := bCancelClick;

lLanguage := TLabel.Create(Self);
lLanguage.Parent := Self;
lLanguage.Caption := pdeLoadNLS('pdmcfgstr15', ' 樨:');
lLanguage.Font := fnt;
lLanguage.Width := 170;
lLanguage.Left := 8;
lLanguage.Top := 335;
lLanguage.Align := alFixedLeftTop;

edLanguage:= TEdit.Create(Self);
edLanguage.Parent := Self;
edLanguage.Width := 100;
edLanguage.Left := 180;
edLanguage.Top := 330;
edLanguage.Align := alFixedLeftTop;

lLangChange := TLabel.Create(Self);
lLangChange.Parent := Self;
lLangChange.Caption := '[...]';
lLangChange.Width := 30;
lLangChange.Left := 290;
lLangChange.Top := 335;
lLangChange.Align := alFixedLeftTop;
lLangChange.OnClick := lLangChangeClick;

End;

//-----------------------------------------

Procedure TPDMCfgForm.iWallClick (Sender: TObject);
var
  fname: String;
Begin

  {load wallpaper}
  fname := pdeOpenFileDialog(pdeLoadNLS('ppOpenFile', '⨥ 䠩')
    , 'c:\', pdeLoadNLS('pdmcfgstr14', '㭪')+' (*.bmp;*.jpg;*.jpe;*.jpeg;*.gif;*.pcx;*.tif;*.tiff;*.tga)|');
  if fname <> '' then
    begin
    if lowercase(ExtractFileExt(fname)) <> '.bmp' then
      fname := LoadGBM(fname);

      if FileExists(fname) then
        begin
        iWallpaper.bitmap.loadfromfile(fname);
        FWallpaper := fname;
        end;

    end;

End;

//-----------------------------------------

Procedure TPDMCfgForm.ColorClick (Sender: TObject);
var
  Clr: TColor;
Begin
  if pdeColorDialog(Clr) then
    begin
    shColor.Brush.Color := Clr;
    FColor1 := Clr;
    shColor.Invalidate;
    end;
End;

//-----------------------------------------

Procedure TPDMCfgForm.Color2Click (Sender: TObject);
var
  Clr: TColor;
Begin
  if pdeColorDialog(Clr) then
    begin
    shGradient.Brush.Color := Clr;
    FColor2 := Clr;
    shGradient.Invalidate;
    end;
End;

//-----------------------------------------

Procedure TPDMCfgForm.lLangChangeClick (Sender: TObject);
var
  fname, fpath: String;
Begin
  fpath := getenv('PDE_HOME');
  if fpath = '' then
    fpath := 'c:\pde';
  if fpath[length(fpath)] <> '\' then
    fpath := fpath + '\';
  fpath := fpath + 'Languages\';

  fname := pdeOpenFileDialog(pdeLoadNLS('ppOpenFile', '⨥ 䠩')
    , fpath, 'NLS (*.nls)|');

  if fname <> '' then
    begin
    fname := ExtractFileName(fname);
    delete(fname, length(fname)-3, 4);
    edLanguage.Text := fname;
    end;

End;

//-----------------------------------------

Procedure TPDMCfgForm.bOKClick (Sender: TObject);
Begin

End;

//-----------------------------------------

Procedure TPDMCfgForm.bCancelClick (Sender: TObject);
Begin

End;

//-----------------------------------------

function pdmCfgShow(wp: String): Integer;
var
  pdmCfgForm: TPDMCfgForm;
  tmpstr: String;
  cfgdata: TStringList;
Begin
  try
    pdmCfgForm := TPDMCfgForm.Create(Application.MainForm);
    except
    pdmCfgForm.Free;
    Result := 1;
    exit;
    end;

  //tmpstr := pdeLoadCfgStr('pdm.cfg', 'wallpaper');
  //pdmCfgForm.FWallpaper := tmpstr;
  pdmCfgForm.FWallpaper := wp;

  try
  if {tmpstr[2]}wp=':' then
    begin
    if FileExists(wp{tmpstr}) then
      pdmCfgForm.iWallpaper.bitmap.loadfromfile(wp{tmpstr});
    end
    else
    begin
    if FileExists(extractfilepath(application.exename)+wp{tmpstr}) then
      pdmCfgForm.iWallpaper.bitmap.loadfromfile(extractfilepath(application.exename)+wp{tmpstr});
    end;

    except

    end;

  pdmCfgForm.shColor.Brush.Color := pdeLoadCfgColor('pdm.cfg', 'desktopcolor');
  pdmCfgForm.shGradient.Brush.Color := pdeLoadCfgColor('pdm.cfg', 'secondcolor');
  pdmCfgForm.FColor1 := pdeLoadCfgColor('pdm.cfg', 'desktopcolor');
  pdmCfgForm.FColor2 := pdeLoadCfgColor('pdm.cfg', 'secondcolor');
  pdmCfgForm.edIcons.Text := pdeLoadCfgStr('pdm.cfg', 'iconsize');
  pdmCfgForm.edLanguage.Text := pdeLoadCfgStr('general.cfg', 'language');

  tmpstr := pdeLoadCfgStr('pdm.cfg', 'wallpaperstyle');

  if tmpstr = 'center' then
    pdmCfgForm.rbCenter.Checked := True
  else if tmpstr = 'tile' then
    pdmCfgForm.rbTile.Checked := True
  else if tmpstr = 'stretch' then
    pdmCfgForm.rbStretch.Checked := True
  else if tmpstr = 'vgradient' then
    pdmCfgForm.rbGradient.Checked := True
  else if tmpstr = 'lefttop' then
    pdmCfgForm.rbLU.Checked := True
  else if tmpstr = 'righttop' then
    pdmCfgForm.rbRU.Checked := True
  else if tmpstr = 'leftbottom' then
    pdmCfgForm.rbLB.Checked := True
  else if tmpstr = 'rightbottom' then
    pdmCfgForm.rbRB.Checked := True;

  Result := 0;

  if pdmCfgForm.ShowModal = cmOK then
    begin
    //save configuration
    if pdmCfgForm.rbCenter.Checked then
      tmpstr := 'center'
    else if pdmCfgForm.rbTile.Checked then
      tmpstr := 'tile'
    else if pdmCfgForm.rbStretch.Checked then
      tmpstr := 'stretch'
    else if pdmCfgForm.rbGradient.Checked then
      tmpstr := 'vgradient'
    else if pdmCfgForm.rbLU.Checked then
      tmpstr := 'lefttop'
    else if pdmCfgForm.rbRU.Checked then
      tmpstr := 'righttop'
    else if pdmCfgForm.rbLB.Checked then
     tmpstr := 'leftbottom'
    else if pdmCfgForm.rbRB.Checked then
      tmpstr := 'rightbottom';

    cfgdata := TStringList.Create;
    cfgdata.Add('//config file of the PDE desktop manager (pdm.exe)');
    cfgdata.Add('iconsize='+pdmCfgForm.edIcons.Text);
    cfgdata.Add('//desktop color');
    //cfgdata.Add('desktopcolor='+IntToStr(pdmCfgForm.shColor.Brush.Color));
    //cfgdata.Add('secondcolor='+IntToStr(pdmCfgForm.shGradient.Brush.Color));
    cfgdata.Add('desktopcolor='+IntToStr(pdmCfgForm.FColor1));
    cfgdata.Add('secondcolor='+IntToStr(pdmCfgForm.FColor2));
    cfgdata.Add('//wallpaper (full path or path from \..\pde\)');
    cfgdata.Add('wallpaper='+pdmCfgForm.FWallpaper);
    cfgdata.Add('//center, tile, stretch, vgradient, lefttop, righttop, leftbottom, rightbottom');
    cfgdata.Add('wallpaperstyle='+tmpstr);
    cfgdata.Add('//Screen-saver application');
    cfgdata.Add('screensaver='+pdeLoadCfgStr('pdm.cfg','screensaver'));
    cfgdata.Add('//Time (msec) for screen-saver');
    cfgdata.Add('savertime='+pdeLoadCfgStr('pdm.cfg', 'savertime'));
    pdeSaveCfgFile('pdm.cfg', cfgdata);
    cfgdata.free;

    cfgdata := TStringList.Create;
    cfgdata.Add('//General preferences for "PDE desktop"');
    cfgdata.Add('//pde_home= <-in config.sys "SET PDE_HOME=C:\PDE" for example');
    cfgdata.Add('//language= <-not in config.sys "SET LANG=ua_ua"');
    cfgdata.Add('language=' + pdmCfgForm.edLanguage.Text);
    cfgdata.Add('//1/0');
    cfgdata.Add('askforshutdown=' + pdeLoadCfgStrD('general.cfg', 'askforshutdown', '1'));
    cfgdata.Add('//ask user when delete file or folder');
    cfgdata.Add('askfordelete=' + pdeLoadCfgStrD('general.cfg', 'askfordelete', '1'));
    cfgdata.Add('//overwrite destination when copying (moving) files and destination exists');
    cfgdata.Add('overwritefiles=' + pdeLoadCfgStrD('general.cfg', 'overwritefiles', '1'));
    cfgdata.Add('//Show error messages when unsucsessful start apps');
    cfgdata.Add('execerrors=' + pdeLoadCfgStrD('general.cfg', 'execerrors', '1'));
    cfgdata.Add('//folders paths');
    cfgdata.Add('userhome=' + pdeLoadCfgStrD('general.cfg', 'userhome', '\root\Home'));
    cfgdata.Add('userdocs=' + pdeLoadCfgStrD('general.cfg', 'userdocs', '\root\Documents'));
    cfgdata.Add('userdrives=' + pdeLoadCfgStrD('general.cfg', 'userdrives', '\root\Drives'));
    cfgdata.Add('userstartup=' + pdeLoadCfgStrD('general.cfg', 'userstartup', '\root\StartUp'));
    cfgdata.Add('userprograms=' + pdeLoadCfgStrD('general.cfg', 'userprograms', '\root\Programs'));
    cfgdata.Add('userbookmarks=' + pdeLoadCfgStrD('general.cfg', 'userbookmarks', '\root\Bookmarks'));
    pdeSaveCfgFile('general.cfg', cfgdata);
    cfgdata.free;
    end
    else
    Result := 1;

  if pdmCfgForm<>nil then
    pdmCfgForm.Free;
End;

//-----------------------------------------

Initialization
  RegisterClasses ([TPDMCfgForm]);
End.