/*
 * Mark.cmd
 *
 * This macro marks the whole text belonging to an environment.
 * Environments can be defined with SKl and OKl. An Environment
 * can be a brace or a '\begin' or end '\end' statement.
 *
 * The opening brace (OKl) and the closing brace (SKl) have to
 * be different.


Number = 4
SKl.1 = ')'
SKl.2 = '}'
SKl.3 = ']'
SKl.4 = '\('
SKl.5 = '\begin{'

OKl.1 = '('
OKl.2 = '{'
OKl.3 = '['
OKl.4 = '\)'
OKl.5 = '\end{'


/*
 * Variables
 */
Text = VRGet( 'MLE_1', 'Value')
pos  = VRGet( 'MLE_1', 'SelectedStart')


/*
 * Find all braces to the right
 */
do i = 1 to Number
   OKl = OKl.i
   SKl = SKl.i
   pos.i = pos
   found = 1
   do while found > 0
      O = Pos( OKl, Text, pos.i + 1 )
      ImText = Check(O)
      do while ImText = 0
         O = LastPos( OKl, Text, O+1 )
         ImText = Check(O)
      end
      S = Pos( SKl, Text, pos.i + 1)
      ImText = Check(S)
      do while ImText = 0
         S = LastPos( OKl, Text, S + 1)
         ImText = Check(S)
      end
      if (O = 0) & (S > 0) then O = S + 1
      if O < S then do
         found = found + 1
         pos.i = O
      end
      else do
         if (O = 0) & (S = 0) then do
            found = 0
            pos.i = 0
         end
         else do
            found = found - 1
            pos.i = S
         end
      end
   end
end


/*
 * Find brace to the left
 */
pstring = pos.1
do j = 2 to Number
   pstring = pstring||','||pos.j
end
INTERPRET 'mx = max(' pstring ')'
if mx = 0 then return
do j = 1 to Number
   if pos.j = 0 then pos.j = mx + 1
end
i = 0
pstring = pos.1
do j = 2 to Number
   pstring = pstring||','||pos.j
end
INTERPRET 'mn = min(' pstring ')'
do j = 1 to Number
   if mn = pos.j then i = j
end
if i < 1 then return
LPos = pos.i


/*
 * Find opening brace
 */
SKl = SKl.i
OKl = OKl.i
found = 1
do while found > 0
   S = LastPos( SKl, Text, pos - 1)
   ImText = Check(S)
   do while ImText = 0
      S = LastPos( SKl, Text, S - 1)
      ImText = Check(S)
   end
   O = LastPos( OKl, Text, pos - 1)
   ImText = Check(O)
   do while ImText = 0
      O = LastPos( OKl, Text, O - 1)
      ImText = Check(O)
   end
   if (S = 0) then
      select
         when O > 0 then S = O - 1
         when O = 0 then do
            call VRMessage VRWindow(), "Opening brace not found.",
               "Mark macro", "Information"
            return
         end
      end
   if S > O then do
      found = found + 1
      pos = S
   end
   else do
      found = found - 1
      pos = O
   end
end


/*
 * Mark text
 */
call VRSet 'MLE_1', 'SelectedEnd', LPos
call VRSet 'MLE_1', 'SelectedStart', Pos+1

return


/*
 * Subroutine, which checks if the found brace is part of a comment
 */

Check:  procedure expose Text
pos   = arg(1)
rc = 1
if pos > 0 then do
   ENTER = LastPos( D2C(13), Text, pos) + 1
   if ENTER = 1 then return rc
   Str   = SubStr(Text, ENTER, pos - ENTER + 1)
   do forever
      Str = DelStr( Str, 1, 1)
      select
         when C2D( Left( Str, 1, 1)) = '9' then iterate
         when C2D( Left( Str, 1, 1)) = '32' then iterate
         when C2D( Left( Str, 1, 1)) = '37' then do
            rc = 0
            leave
         end
         otherwise leave
      end
   end
end
return rc
