/*
 * BraceCheck
 *
 * This macro marks the whole text between an closing brace and the
 * corresponding (opening) brace for a short time.
 *
 * The cursor has to be on or directly behind a closing brace
 */


/*
 * Getting the text an the cursor position
 */
Text = VRGet( 'MLE_1', 'Value')
pos  = VRGet( 'MLE_1', 'SelectedStart')


/*
 * Get Brace
 */
if pos \= VRGet( 'MLE_1', 'SelectedEnd') then
   Pos = Max( VRGet( 'MLE_1', 'SelectedStart'), VRGet( 'MLE_1', 'SelectedEnd'))
OldPos = Pos
Pos = Pos - 1
SKl = SubStr( Text, Pos , 1)
select
   when SKl = ')' then OKl = '('
   when SKl = '}' then OKl = '{'
   when SKl = ']' then OKl = '['
   otherwise return
end


/*
 * Find corresponding brace
 */
found = 1
do while found > 0
   S = LastPos( SKl, Text, pos - 1)
   ImText = Check(S)
   do while ImText = 0
      S = LastPos( SKl, Text, S - 1)
      ImText = Check(S)
   end
   O = LastPos( OKl, Text, pos - 1)
   ImText = Check(O)
   do while ImText = 0
      O = LastPos( OKl, Text, O - 1)
      ImText = Check(O)
   end
   if (S = 0) then
      select
         when O > 0 then S = O - 1
         when O = 0 then do
            call VRMessage VRWindow(), "ffnende Klammer nicht gefunden.",
               "Klammer Makro", "Information"
            return
         end
      end
   if S > O then do
      found = found + 1
      pos = S
   end
   else do
      found = found - 1
      pos = O
   end
end


/*
 * Mark text for a short time
 */
call VRSet 'MLE_1', 'SelectedEnd', OldPos
call VRSet 'MLE_1', 'SelectedStart', Pos
do 50000
   nop
end
call VRSet 'MLE_1', 'SelectedStart', OldPos
return


/*
 * Subroutine, which tests, if the found brace belongs to a comment
 */

Check:  procedure expose Text
pos   = arg(1)
rc = 1
if pos > 0 then do
   ENTER = LastPos( D2C(13), Text, pos) + 1
   if ENTER = 1 then return rc
   Str   = SubStr(Text, ENTER, pos - ENTER + 1)
   do forever
      Str = DelStr( Str, 1, 1)
      select
         when C2D( Left( Str, 1, 1)) = '9' then iterate
         when C2D( Left( Str, 1, 1)) = '32' then iterate
         when C2D( Left( Str, 1, 1)) = '37' then do
            rc = 0
            leave
         end
         otherwise leave
      end
   end
end
return rc
